;**
;**  This CADKEY LISP program is provided with CADKEY LISP free of charge.
;**  This and other example programs are for demonstration purposes and
;**  should be thoroughly tested and inspected prior to implementation in
;**  any CADKEY LISP application program.  BitWise Solutions does not
;**  warrant the functionality nor correctness of this or any example
;**  program.  All or portions of this example program may be included
;**  in an CADKEY LISP application program provided the following copyright
;**  line appears at the beginning of the application:
;**                 Copyright 1994, BitWise Solutions
;**
;**  Copyright 1994, BitWise Solutions.  All rights reserved.
;**
;** -----------------------------------------------------------------------
;**  doffset.lsp
;**
;**  This example program will offset either a vertical line or a horizontal
;**  line a given distance in both directions and erase the original line.
;**  Type 'ox' to offset a vertical line or 'oy' to offset a horizontal line.
;**  No check is made to determine that the line is horizontal or vertical.
;**  Lines may continue to be selected and offset at the specified distance
;**  until the ENTER key is pressed.
;** -----------------------------------------------------------------------
;**
(defun c:ox (/ n a b c o)
	(initget 1)
	(setq o (getdist "\nOffset distance: "))
	(while (/= (setq n (car (entsel "\nSelect line: "))) nil)
		(setq a (cdr (entget n))
				b (cdr (assoc 10 a))
				c (cdr (assoc 11 a))
				b (list (+ (car b) o) (cadr b))
				c (list (+ (car c) o) (cadr c))
				a (subst (cons 10 b) (assoc 10 a) a)
				a (subst (cons 11 c) (assoc 11 a) a)
		)
		(entmake a)
		(setq b (list (- (car b) (* 2 o)) (cadr b))
				c (list (- (car c) (* 2 o)) (cadr c))
				a (subst (cons 10 b) (assoc 10 a) a)
				a (subst (cons 11 c) (assoc 11 a) a)
		)
		(entmake a)
		(entdel n)
	)
)
(defun c:oy (/ n a b c o)
	(initget 1)
	(setq o (getdist "\nOffset distance: "))
	(while (/= (setq n (car (entsel "\nSelect line: "))) nil)
		(setq a (cdr (entget n))
				b (cdr (assoc 10 a))
				c (cdr (assoc 11 a))
				b (list (car b) (+ (cadr b) o))
				c (list (car c) (+ (cadr c) o))
				a (subst (cons 10 b) (assoc 10 a) a)
				a (subst (cons 11 c) (assoc 11 a) a)
		)
		(entmake a)
		(setq b (list (car b) (- (cadr b) (* 2 o)))
				c (list (car c) (- (cadr c) (* 2 o)))
				a (subst (cons 10 b) (assoc 10 a) a)
				a (subst (cons 11 c) (assoc 11 a) a)
		)
		(entmake a)
		(entdel n)
	)
)
