;**
;**  This CADKEY LISP program is provided with CADKEY LISP free of charge.
;**  This and other example programs are for demonstration purposes and
;**  should be thoroughly tested and inspected prior to implementation in
;**  any CADKEY LISP application program.  BitWise Solutions does not
;**  warrant the functionality nor correctness of this or any example
;**  program.  All or portions of this example program may be included
;**  in an CADKEY LISP application program provided the following copyright
;**  line appears at the beginning of the application:
;**                 Copyright 1994, BitWise Solutions
;**
;**  Copyright 1994, BitWise Solutions.  All rights reserved.
;**
;** -----------------------------------------------------------------------
;**  List.lsp
;**
;**  This example program is identical to the LIST and DBLIST commands.
;**  Type 'lst' to LIST a single entity or 'dblst' to list all entities
;**  in the drawing.
;** -----------------------------------------------------------------------
;**
(defun c:lst ( / ent )
	(setq ent (car (entsel "\nSelect entity to list: ")))
	(if (/= ent nil)
		(progn
			(textpage)
			(dispent ent)
		)
	)
	(princ)
)

;*
;*	'Dblist' command.
;*
(defun c:dblst ( / ent counter entlist )
	(setq 
		entlist (ssget "X")
		counter 0
	)
	(textpage)
	(repeat (sslength entlist)
		(dispent (ssname entlist counter))
		(nltab)
		(setq counter (1+ counter))
	)
	(princ)
)

;*
;*	Utility to display the contents of a given entity.
;*	Requires argument of an ename.
;*

(defun dispent ( ename / typ ent flag )
	(setq
		ent (entget ename)
		typ (cdr (assoc 0 ent))
	)
			
	;*
	;*	Default stuff for each entity, regardless of type.
	;*
	(nltab) (princ "Entity type: " ) (princ (cdr (assoc 0 ent)))
	(nltab)
	(princ "Entity name: " ) (princ (cdr (assoc -1 ent)))
	(nltab)
	(princ "Layer: " ) (princ (cdr (assoc 8 ent)))
	(princ "\tColor: " ) (princ (cdr (assoc 62 ent)))
			
	;*
	;*	Attributes of each entity.
	;*
	(if (= typ "LINE")
		(progn
			(nltab) (princ "Line type: ") (princ (cdr (assoc 6 ent)))
			(nltab) (princ "Start point: ") (princ (formatpt 10 ent))
			(nltab) (princ "End point: ") (princ (formatpt 11 ent))
		)
	)
	
	(if (= typ "POLYLINE")
		(progn
			(nltab) (princ "Number of vertices: ") (princ (cdr (assoc 78 ent)))
			(nltab) (princ "Starting width: ") (princ (cdr (assoc 40 ent)))
			(nltab) (princ "Ending width: ") (princ (cdr (assoc 41 ent)))
		)
	)

	(if (= typ "TEXT")
		(progn
			(nltab) (princ "Insertion point: ") (princ (formatpt 10 ent))
			(nltab) (princ "Text string: ") (princ (cdr (assoc 1 ent)))
			(nltab) (princ "Text height: ") (princ (cdr (assoc 40 ent)))
			(nltab) (princ "Rotation angle: ") (princ (formatang 50 ent))
			(nltab) (princ "Oblique angle: ") (princ (formatang 51 ent))
			(nltab) (princ "Text style: ") (princ (cdr (assoc 7 ent)))

			(nltab) (princ "Generation flag: ")
			(setq flag (cdr (assoc 71 ent)))
			(if (= flag 0)
				(princ "Default")
			)
			(if	(= flag 2)
				(princ "Backward")
			)
			(if (= flag 4)
				(princ "Upside down")
			)

			(nltab) (princ "Horizontal alignment: ")
			(setq flag (cdr (assoc 72 ent)))
			(if (= flag 0)
				(princ "Left")
			)
			(if (= flag 1)
				(princ "Center")
			)
			(if (= flag 2)
				(princ "Right")
			)
			(if (= flag 3)
				(princ "Aligned")
			)
			(if (= flag 4)
				(princ "Middle")
			)
			(if (= flag 5)
				(princ "Fit")
			)

			(nltab) (princ "Vertical alignment: ")
			(setq flag (cdr (assoc 73 ent)))
			(if (= flag 0 )
				(princ "Baseline")
			)
			(if (= flag 1)
				(princ "Bottom")
			)
			(if (= flag 2)
				(princ "Middle")
			)
			(if (= flag 3)
				(princ "Top")
			)

			(nltab) (princ "Alignment point: ") (princ (formatpt 11 ent))
		)
	)
			
	(if (= typ "CIRCLE")
		(progn
			(nltab) (princ "Center point: ") (princ (formatpt 10 ent))
			(nltab) (princ "Radius: ") (princ (cdr (assoc 40 ent)))
		)
	)
			
	(if (= typ "ARC")
		(progn
			(nltab) (princ "Start angle: ") (princ (formatang 50 ent))
			(nltab) (princ "End angle: ") (princ (formatang 51 ent))
			(nltab) (princ "Center point: ") (princ (formatpt 10 ent))
			(nltab) (princ "Radius: ") (princ (cdr (assoc 40 ent)))
		)
	)
						
	;*
	;*	View number and normal vector.
	;*
	(nltab) (princ "View number: ") (princ (cdr (assoc 80 ent)))
	(nltab) (princ "Normal vector: ") (princ (formatpt 210 ent))

	(princ)
)

(defun nltab ( / )
	(princ "\n\t")
)

(defun formatpt( dxf lst / x y z)
	(setq
		x	(nth 1 (assoc dxf lst))
		y	(nth 2 (assoc dxf lst))
		z	(nth 3 (assoc dxf lst))
	)
	(strcat (rtos x) ", " (rtos y) ", " (rtos z))
)

(defun formatang( dxf lst / a )
	(setq 
		a	(cdr (assoc dxf lst))
	)
	(strcat (angtos a) " deg")
)
