;**
;**  This CADKEY LISP program is provided with CADKEY LISP free of charge.
;**  This and other example programs are for demonstration purposes and
;**  should be thoroughly tested and inspected prior to implementation in
;**  any CADKEY LISP application program.  BitWise Solutions does not
;**  warrant the functionality nor correctness of this or any example
;**  program.  All or portions of this example program may be included
;**  in an CADKEY LISP application program provided the following copyright
;**  line appears at the beginning of the application:
;**                 Copyright 1994, BitWise Solutions
;**
;**  Copyright 1994, BitWise Solutions.  All rights reserved.
;**
;** -----------------------------------------------------------------------
;**  Maketext.Lsp
;**
;**  This example program will ask the user for all of the options in
;**  creating text and will then create the text using the ENTMAKE function.
;**  Type 'maketext' to run this function.
;** -----------------------------------------------------------------------
;**
(defun c:maketext ( / val dval hal dhal pt hgt rot oblique xscale mirror text )

	;;
	;; Get the vertical alignment option
	;;
	(initget 1 "BAseline BOttom Middle Top")
	(setq 
		val (getkword "\nVertical justification: BAseline/BOttom/Middle/Top: " )
		dval
			(cond
				((= val "BAseline") 0)
				((= val "BOttom")   1)
				((= val "Middle")   2)
				(t                  3)
			)
	)
	
	;;
	;; Get the horizontal alignment option
	;;
	(if (= dval 0)
		(progn
			(initget 1 "Left Center Right Align Middle Fit")
			(setq hal (getkword "\nHorizontal justification: Left/Center/Right/Align/Middle/Fit: " ))
		)
	; else
		(progn
			(initget 1 "Left Center Right")
			(setq hal (getkword "\nHorizontal justification: Left/Center/Right: " ))
		)
	)
	(setq dhal
		(cond
			((= hal "Left")     0)
			((= hal "Center")   1)
			((= hal "Right")    2)
			((= hal "Align")    3)
			((= hal "Middle")   4)
			(t                  5)
		)
	)
	
	;;
	;;  get insertion point, height, rotation, mirror, oblique, xscale, text
	;;
	(initget 1)
	(setq pt (getpoint (strcat "\n" val "/" hal " point: ")))

	(initget 0)
	(setq hgt (getdist (strcat "\nText height<" (rtos (getvar "textsize")) ">: ")))
	(if (null hgt)
		(setq hgt (getvar "textsize"))
	)
	
	(initget 0)
	(setq rot (getangle "\nRotation angle<0>: "))
	(if (null rot)
		(setq rot 0.0)
	)
	
	(initget 0)
	(setq oblique (getangle "\nOblique angle<0>: "))
	(if (null oblique)
		(setq oblique 0.0)
	)
	
	(initget 0)
	(setq xscale (getreal "\nX scale multiplier<1.0>: "))
	(if (null xscale)
		(setq xscale 1.0)
	)

	(initget 0 "Yes No")
	(setq mirror (getkword "\nMirror text(Yes/No) <No>: "))
	(if (or (null mirror) (= mirror "No"))
		(setq mirror 0)
	;else
		(setq mirror 2)
	)

	(setq text (getstring T "\nText: "))
	
	;;
	;;  Form the DXF list and call entmake
	;;
	(setq l (list
		(cons 0 "TEXT")
		(cons 10 pt)
		(cons 40 hgt)
		(cons 1 text)
		(cons 50 rot)
		(cons 51 oblique)
		(cons 41 xscale)
		(cons 71 mirror)
		(cons 72 dhal)
		(cons 73 dval)
	))

	(if (or (/= dval 0) (/= dhal 0))
		(setq l (append l (list (cons 11 pt))))
	)
	(entmake l)
)
