;
;	This tutorial program is used within the CADKEY LISP environment
;	The goals, inputs and outputs of this program are described in
;	the on-line tutorial.
;
;	BitWise - 1994.


(setq 
	stNum	1	; Starting number. 
	incr	1	; Increment step 
	txtHgt	2.0	;Text height of the text 
) 


(defun c:numbers (  /	txtPt  	; Insertion point for the text. 
								tstNum 	;	Temporarystarting number. 
								tincr 	; Temporary increment number. 
								ttxtHgt ;	Temporary text height. 
							) ; End of variable declarations.

	; Using the standard assign function `setq'
	; set the various variables.  
	(setq 
		tstNum (getint (strcat "\nStarting number <" (itoa stNum) ">: "))
		tincr (getint (strcat "\nIncrement <" (itoa incr) ">: "))
		ttxtHgt (getdist (strcat "\nText height <" (rtos txtHgt) ">: ")) 
	) 


	(if (/= tstNum nil)		; Starting number. 
		(setq stNum tstNum) 
	) 
	(if (/= tincr nil)		; Increment number. 
		(setq incr tincr) 
	) 
	(if (/= ttxtHgt nil)		; Text height. 
		(setq txtHgt ttxtHgt) 
	) 

	(setvar "cmdecho" 0) 

	(while (/= (setq txtPt (getpoint "\nText insertion point: ")) nil)  
		(command  "text" txtPt txtHgt 0.0 (itoa stNum)) 
		; Increment the text number for the next pass. 
		(setq stNum (+ stNum incr)) 
	) 

	(princ) 
) 
