;**
;**  This CADKEY LISP program is provided with CADKEY LISP free of charge.
;**  This and other example programs are for demonstration purposes and
;**  should be thoroughly tested and inspected prior to implementation in
;**  any CADKEY LISP application program.  BitWise Solutions does not
;**  warrant the functionality nor correctness of this or any example
;**  program.  All or portions of this example program may be included
;**  in an CADKEY LISP application program provided the following copyright
;**  line appears at the beginning of the application:
;**                 Copyright 1994, BitWise Solutions
;**
;**  Copyright 1994, BitWise Solutions.  All rights reserved.
;**
;** -----------------------------------------------------------------------
;**  ssfilter.Lsp
;**
;**  This example program is an example of using selection set filters. 
;**  It will allow for an entity to be selected and then all entities
;**  matching the selected entity's 1> Type, 2> Color, and/or 3> Layer
;**  will be highlighted. The attribute to match can be toggled on and off
;**  by typing the first letter of the keyword.  Once all attributes have
;**  been set, press ENTER to select and highlight all matching entities.
;**  Type 'sselect' on the command line to run this function.
;** -----------------------------------------------------------------------
;**
;
;  c:sselect
;
;  Allows the selection of entity and then will find all entities that match
;  a certain aspect of that entity (type, color, layer).
;
(defun c:sselect ( / )

	;
	;  Get the entity
	;
	(while (= (setq ent (car (entsel "\nSelect an entity: "))) nil)
		(princ "\nNo entity found.")
	)

	;
	;  Ask which attributes to search on
	;
	(setq ty 0 co 0 la 1 done 0)
	(while (= done 0)
		(setq df "")
		(if (/= ty 0) (setq df (strcat df "T")))
		(if (/= co 0) (setq df (strcat df "C")))
		(if (/= la 0) (setq df (strcat df "L")))
		(setq prompt (strcat "\nSearch by: Type/Color/Layer <" df ">: "))
		(initget 0 "Type Color Layer")
		(setq kw (getkword prompt))
		(cond 
			((= kw "Type") (if (= ty 0) (setq ty 1) (setq ty 0)))
			((= kw "Color") (if (= co 0) (setq co 1) (setq co 0)))
			((= kw "Layer") (if (= la 0) (setq la 1) (setq la 0)))
			(t (setq done 1))
		)
	)

	;
	;  Build a filter list based upon the selected entity and the
	;  attributes to match.
	;
	(setq 
		filter 	nil
		dxf		(entget ent)
	)

	(if (= ty 1)
		(setq filter (list (assoc 0 dxf)))
	)

	(if (= co 1)
		(if (= filter nil)
			(setq filter (list (assoc 62 dxf)))
		;else
			(setq filter (append filter (list (assoc 62 dxf))))
		)
	)

	(if (= la 1)
		(if (= filter nil)
			(setq filter (list (assoc 8 dxf)))
		;else
			(setq filter (append filter (list (assoc 8 dxf))))
		)
	)

	;
	;  Select all entities matching the selected attributes
	;
	(setq ss (ssget "X" filter))
	(show_entities ss)
	(princ)
)

;
;  show_entities
;
;  Redraws all entities in the selection set in a highlighted mode and
;  waits for the user to press Enter.  Note the use of the CADKEY CDE
;  call to display the prompt and wait for Enter.
;
(defun show_entities ( ss / len i )
	(setq
		len		(sslength ss)
		i		0
	)
	
	(while (< i len)
		(redraw (ssname ss i) 3)
		(setq i (1+ i))
	)
	(ck_pause "Press <ENTER> to continue...")
	(redraw)
)
	
	
