hmLoadTopic({
hmKeywords:"",
hmTitle:"Adding Users from LDAP Server",
hmDescription:"LDAP integration allows a DW Spectrum Administrator to link a pre-existing user database to the System, keeping existing LDAP domain usernames and passwords, and providing the...",
hmPrevLink:"deleting_a_user_(admin_only).html",
hmNextLink:"viewing_users_actions_log_audi.html",
hmParentLink:"users_management.html",
hmBreadCrumbs:"<a href=\"working_with_display_product_n.html\">Working with DW Spectrum<\/a> &gt; <a href=\"users_management.html\">Users and User Roles<\/a>",
hmTitlePath:"Working with DW Spectrum > Users and User Roles > Adding Users from LDAP Server",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">Adding Users from LDAP Server<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\">LDAP integration allows a DW Spectrum Administrator to link a pre-existing user database to the System, keeping existing LDAP domain usernames and passwords, and providing the option to assign specific User Roles and access rights during import. For security reasons, the VMS does not keep LDAP passwords. The following LDAP servers are available:<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\">Microsoft Active Directory<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\">Open LDAP Server<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\">JumpCloud<\/span><\/p><p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\">After an LDAP user is enabled in DW Spectrum they will be able to log in to DW Spectrum using their LDAP domain username and password. However, user permission levels are not imported – you will need to define and assign the desired authority structure in DW Spectrum for all LDAP users. Once a DW Spectrum Administrator is defined they will be able to fetch other LDAP users and configure their LDAP settings. (Note that it is not possible to import an LDAP user into an Owner role.)<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\">The DW Spectrum Media Server attempts to synchronize with the LDAP\/AD server once every 10 minutes so that changes there are reflected in the VMS System.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><img alt=\"!\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/!.png\"\/><span class=\"f_ImageCaption\"> <\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\">IMPORTANT:<\/span><span class=\"f_BodyText\"> <\/span><span class=\"f_BodyText\">If the LDAP server is not available, LDAP users will not be able to log in.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"text-decoration: underline;\">Setting Up LDAP Integration<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">To be able to import users and allow them to connect to DW Spectrum, it is necessary to establish a connection between DW Spectrum and the corporate LDAP server. The LDAP server does not have to be a part of the LAN the Media Server is on, but it must be available for the Media Server either on LAN or via WAN. This integration should be performed by, or in cooperation with, the <\/span><span class=\"f_BodyTextIndent\">Network (Domain) Administrator<\/span><span class=\"f_BodyTextIndent\">. To use LDAP over SSL most likely you will be required to change certificates or to install certificates to both the LDAP Server and the Media Server.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><img alt=\"note\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/note.png\"\/><span class=\"f_ImageCaption\"> <\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\">Note<\/span><span class=\"f_BodyText\">: When configuring LDAP integration, you cannot specify the domain\'s base distinguished name (DN) as a search base, but you can specify the organizational units (OU\'s) underneath the base DN because it is not possible to filter on OU membership, but you can filter on group membership. To retrieve all users that are members of a specified group, filter on the <\/span><span class=\"f_CodeExample\">memberOf<\/span><span class=\"f_BodyText\"> attribute. For example: memberOf=CN=Security Users,CN=Users,DC=DOMAIN,DC=LOCAL.<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextIndent\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">1.<\/span><span class=\"f_BodyTextFirstIndent2\">From <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">System Administration<\/span><span class=\"f_BodyTextFirstIndent2\">, go to the <\/span><span class=\"f_T_Interface_Elements\" style=\"font-style: normal; font-weight: bold;\">Users<\/span><span class=\"f_T_Interface_Elements\" style=\"font-style: normal;\"> tab<\/span><span class=\"f_BodyTextIndent\"> and click <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">LDAP Settings<\/span><span class=\"f_BodyTextIndent\">. <\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">2.<\/span><span class=\"f_BodyTextIndent\">Enter the following information (consult with your <\/span><span class=\"f_BodyText\">Network or Domain Administrator if needed<\/span><span class=\"f_BodyTextIndent\">):<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\"> <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">Server URL<\/span><span class=\"f_BodyTextFirstIndent2\"> or IP address<\/span><span class=\"f_BodyTextFirstIndent2\">, <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">Admin DN or CN<\/span><span class=\"f_BodyTextFirstIndent2\">, <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">Password<\/span><span class=\"f_BodyTextFirstIndent2\">, <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">Search Base<\/span><span class=\"f_BodyTextFirstIndent2\">, (optional) <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">Search Filter <\/span><span class=\"f_BodyTextFirstIndent2\">(optional)<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">, <\/span><span class=\"f_BodyTextFirstIndent2\">and<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\"> Search Timeout<\/span><span class=\"f_BodyTextFirstIndent2\">. An LDAP port can also be required if it is not the default, for example ldap:\/\/ldapServerUrl:Port or ldap:\/\/IP:Port. The s<\/span><span class=\"f_BodyTextFirstIndent2\">earch filter<\/span><span class=\"f_BodyTextFirstIndent2\"> is optional and is used to filter users on the server side (special LDAP syntax is needed). The example below illustrates the most simple filter.<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"page-break-inside: avoid;\"><img alt=\"Setting Up LDAP Integration - 1\" style=\"margin:0;width:28.4375rem;height:14.5625rem;border:none\" src=\".\/images\/hmfile_hash_101a7a1c.png\"\/><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\"><img alt=\"!\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/!.png\"\/><span class=\"f_ImageCaption\"> <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">IMPORTANT:<\/span><span class=\"f_BodyTextFirstIndent2\"> If using a server U<\/span><span class=\"f_BodyTextFirstIndent2\">RL, it should be a <\/span><span class=\"f_BodyTextFirstIndent2\">fully qualified domain name (FQDN), sometimes also referred to as an absolute domain name<\/span><span class=\"f_BodyTextFirstIndent2\">. See <a href=\"https:\/\/en.wikipedia.org\/wiki\/Fully_qualified_domain_name\" target=\"_blank\" class=\"weblink\">https:\/\/en.wikipedia.org\/wiki\/Fully_qualified_domain_name<\/a> for details.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">3.<\/span><span class=\"f_BodyTextIndent\">Click <\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Test<\/span><span class=\"f_BodyTextIndent\">. If the test is successful, the server will return the number of LDAP users found (<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Search Filter<\/span><span class=\"f_BodyTextIndent\"> will be pre-applied).<\/span><\/p><p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"text-decoration: underline;\">Importing Users from LDAP Server<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">After LDAP integration is complete it is possible to import LDAP users into DW Spectrum. If available, name and email address information will be imported.<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">1.<\/span><span class=\"f_BodyTextFirstIndent2\">Open <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">System Administration<\/span><span class=\"f_BodyTextFirstIndent2\"> &gt; <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">Users<\/span><span class=\"f_BodyTextFirstIndent2\"> tab and click <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">Fetch Users from LDAP<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">.<\/span><span class=\"f_BodyTextFirstIndent2\"> The list of LDAP users found on the server will be displayed.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">2.<\/span><span class=\"f_BodyTextIndent\">Select user(s) to be imported, using the <\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Search<\/span><span class=\"f_BodyTextIndent\"> filter if desired.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">3.<\/span><span class=\"f_BodyTextIndent\">If needed, <\/span><span class=\"f_BodyText\">enable or disable LDAP users (see &quot;<a href=\"disabling_user.html\" class=\"topiclink\">Disabling\/Enabling Users<\/a>&quot;) and assign the appropriate User Roles (see &quot;<a href=\"changing_user_settings.html\" class=\"topiclink\">Changing User Settings<\/a>&quot;).<\/span><\/p><p class=\"p_BodyTextIndent\"><img alt=\"note\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/note.png\"\/><span class=\"f_ImageCaption\"> <\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\">Note<\/span><span class=\"f_BodyText\">: LDAP users must successfully log into the Desktop Client one time to be able to login to the Web Client.<\/span><\/p>\n\r"
})
