hmLoadTopic({
hmKeywords:"",
hmTitle:"Server Certificate Validation",
hmDescription:"DW Spectrum Server certificate validation occurs on the communication between DW Spectrum Server, DW Spectrum Clients (Desktop Client and Mobile Client), and DW Cloud to...",
hmPrevLink:"connecting_to_display_product_.html",
hmNextLink:"vms_quick_start.html",
hmParentLink:"logging_in_to_a_system.html",
hmBreadCrumbs:"<a href=\"working_with_display_product_n.html\">Working with DW Spectrum<\/a> &gt; <a href=\"logging_in_to_a_system.html\">Connecting to a System<\/a>",
hmTitlePath:"Working with DW Spectrum > Connecting to a System > Server Certificate Validation",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">Server Certificate Validation<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyTextIndent\">DW Spectrum <\/span><span class=\"f_BodyText\">Server certificate validation occurs on the communication between <\/span><span class=\"f_BodyTextIndent\">DW Spectrum <\/span><span class=\"f_BodyText\">Server, <\/span><span class=\"f_BodyTextIndent\">DW Spectrum <\/span><span class=\"f_BodyText\">Clients (Desktop Client and Mobile Client), and <\/span><span class=\"f_BodyTextIndent\">DW Cloud<\/span><span class=\"f_BodyText\"> to enhance the security of <\/span><span class=\"f_BodyTextIndent\">DW Spectrum<\/span><span class=\"f_BodyText\"> by ensuring you are connecting to a trusted location. While the Client connects to the System, the System will provide all servers’ public keys to the Client for validation. No matter which level is configured, there will be no warning message displayed at all when you connect to the System with a valid (public) certificate and matching hostname.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><img alt=\"note\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/note.png\"\/><span class=\"f_ImageCaption\"> <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">Note<\/span><span class=\"f_BodyTextIndent\">:<\/span><span class=\"f_BodyText\"> A valid certificate must be issued by a public Certification Authority (CA) and contains the completed information of the certificate chain. A public certificate without a certificate chain will be considered invalid in <\/span><span class=\"f_BodyTextIndent\">DW Spectrum<\/span><span class=\"f_BodyText\">.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\">For other types of certificates, the behavior will depend on the Client’s validation level:<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">Disabled<\/span><span class=\"f_BodyTextIndent\"> <\/span><span class=\"f_BodyTextFirstIndent2\">–<\/span><span class=\"f_BodyTextIndent\"> The Client will skip the validation process and connect to the System directly. The user will not see a warning message. However, it is still NOT recommended to turn the validation off since certificate validation is recommended as a part of the security hardening process of any System.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\">Recommended<\/span><span class=\"f_BodyText\"> (default) <\/span><span class=\"f_BodyTextFirstIndent2\">–<\/span><span class=\"f_BodyText\"> It allows the user to connect to the System with any certificate, but it may require the user’s confirmation. You may still see the warning message in the following situations:<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyText\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">Connected to an UNKNOWN System<\/span><span class=\"f_BodyTextFirstIndent2\"> <\/span><span class=\"f_BodyTextFirstIndent2\">– <\/span><span class=\"f_BodyText\">When a Client attempts to connect to a new System for the first time, that means the Client has no information about the servers’ certificates before. When the System provides the certificate(s) that is custom\/self-signed, or public certificate without chain information, a “Connecting to Server for the first time?” prompt may appear stating that the SSL certificate could not be verified automatically. Once the Client approves this connection, the certificate will be stored at the Client’s end. It is expected that no warning message will pop up again for any further connections until the certificate expires\/changes.<\/span><br \/>\n\r<img alt=\"Certificate_Validation_Known_System\" style=\"margin:0;width:25.0000rem;height:15.4375rem;border:none\" src=\".\/images\/certificate_validation_known_system.png\"\/><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyText\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyText\" style=\"font-style: italic;\">Connected to a KNOWN System<\/span><span class=\"f_BodyText\"> <\/span><span class=\"f_BodyTextFirstIndent2\">– <\/span><span class=\"f_BodyText\">When a user attempts to use the Client to connect a known System but whose certificate(s) cannot be verified successfully (for example, mismatched with the Client\'s pinned certificate, expired certificate, etc.), the Client will display the warning message: “Cannot verify the identity of Server ”. The user will be asked to take further action and check the certificate\'s problems. The user can check the <\/span><span class=\"f_BodyText\" style=\"font-style: italic;\">I trust this server<\/span><span class=\"f_BodyText\"> checkbox and then click <\/span><span class=\"f_BodyText\" style=\"font-style: italic;\">Connect Anyway<\/span><span class=\"f_BodyText\"> to proceed if the user would like to connect to the Server. This message will be seen every time the user attempts to connect to the System until the issue with the certificate has been fixed.<\/span><br \/>\n\r<img alt=\"Certificate_Validation_Unknown_System\" style=\"margin:0;width:25.0000rem;height:15.4375rem;border:none\" src=\".\/images\/certificate_validation_unknown_system.png\"\/><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\">Strict<\/span><span class=\"f_BodyText\"> <\/span><span class=\"f_BodyTextFirstIndent2\">–<\/span><span class=\"f_BodyText\"> With this mode, the servers that use the default self-signed certificates will also be rejected by the Client. It forces the user to connect to Servers with only a valid (public) certificate and correct hostname. The user will see the warning message below when they attempt to connect to the System with an invalid certificate or mismatched hostname.<\/span><br \/>\n\r<img alt=\"Certificate_Validation_Failed_Connection\" style=\"margin:0;width:25.1250rem;height:10.3750rem;border:none\" src=\".\/images\/certificate_validation_failed_connection.png\"\/><\/p><p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"text-decoration: underline;\">How to Change the Certificate\'s Validation Level<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">To change the validation level in the Desktop Client: <\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">1.<\/span><span class=\"f_BodyTextFirstIndent2\">Open <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">Main Menu<\/span><span class=\"f_BodyTextFirstIndent2\"> &gt; <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">Local Settings<\/span><span class=\"f_BodyTextFirstIndent2\"> &gt; <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">Advanced<\/span><span class=\"f_BodyTextFirstIndent2\"> tab.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">2.<\/span><span class=\"f_BodyText\">Open the <\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\">Server certificate validation<\/span><span class=\"f_BodyText\"> dropdown and select a validation level: <\/span><span class=\"f_BodyText\" style=\"font-style: italic;\">Disabled<\/span><span class=\"f_BodyText\">, <\/span><span class=\"f_BodyText\" style=\"font-style: italic;\">Recommended<\/span><span class=\"f_BodyText\">, or <\/span><span class=\"f_BodyText\" style=\"font-style: italic;\">Strict<\/span><span class=\"f_BodyText\">.<\/span><\/p><p class=\"p_BodyText\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 3.3750rem; margin-left: 0;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">3.<\/span><span class=\"f_BodyText\">Apply changes.<\/span><\/p><p class=\"p_BodyTextFirstIndent2\"><img alt=\"note\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/note.png\"\/><span class=\"f_ImageCaption\"> <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">Note<\/span><span class=\"f_BodyTextIndent\">:<\/span><span class=\"f_BodyText\"> The Server certificate validation level can also be modified in the Mobile Client.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"text-decoration: underline;\">How to Check the Certificate\'s Details<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyText\">To check the Server\'s SSL certificate validity and information:<\/span><br \/>\n\r<span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Desktop Client<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">1.<\/span><span class=\"f_BodyTextFirstIndent2\">Open <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">Server Settings<\/span><span class=\"f_BodyTextFirstIndent2\"> &gt; <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">General<\/span><span class=\"f_BodyTextFirstIndent2\">.<\/span><br \/>\n\r<span class=\"f_BodyText\">Note: Any available pinned\/custom certificate will be listed here.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">2.<\/span><span class=\"f_BodyText\">Click the certificate to view its details.<\/span><\/p><p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\"><a href=\"connecting_to_vms_thr.html\" class=\"topiclink\">Web Admin<\/a><\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">1.<\/span><span class=\"f_BodyTextFirstIndent2\">Visit the Web Admin and click the <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">Not secure<\/span><span class=\"f_BodyTextFirstIndent2\"> indicator in the address bar.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">2.<\/span><span class=\"f_BodyText\">Click on the certificate’s status to open its details<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">3.<\/span><span class=\"f_BodyText\">Review the certificate\'s information, such as issuer and expiration date.<\/span><br \/>\n\r<img alt=\"Certificate_Validation_Check\" style=\"margin:0;width:42.3750rem;height:20.8750rem;border:none\" src=\".\/images\/certificate_validation_check.png\"\/><\/p><p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"text-decoration: underline;\">How to Renew the Expired Certificate<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">Self-signed Certificates from <\/span><span class=\"f_BodyTextIndent\">DW Spectrum<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\"><span class=\"f_BodyTextFirstIndent2\">Restart the<\/span><span class=\"f_BodyTextIndent\"> <\/span><span class=\"f_BodyTextFirstIndent2\">Server to renew its certificate and try again. <\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">Public Certificates \/ Other Self-signed Certificates<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\"><span class=\"f_BodyTextFirstIndent2\">Contact your<\/span><span class=\"f_BodyTextIndent\"> <\/span><span class=\"f_BodyTextFirstIndent2\">VMS administrator to renew the Server’s certificate.<\/span><\/p>\n\r"
})
