hmLoadTopic({
hmKeywords:"",
hmTitle:"Event Rules",
hmDescription:"An Event Rule is an Event-Action pair – when an Event is detected, the related Action is triggered.",
hmPrevLink:"alerts.html",
hmNextLink:"default_rules.html",
hmParentLink:"working_with_display_product_n.html",
hmBreadCrumbs:"<a href=\"working_with_display_product_n.html\">Working with DW Spectrum<\/a>",
hmTitlePath:"Working with DW Spectrum > Event Rules",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">Event Rules<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\">An Event Rule is an Event-Action pair – when an Event is detected, the related Action is triggered.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\">An event rule is a one-to-one definition: a given event can have just one action. However, you can create as many event rules as you need. For example, you can define an event that detects motion on a camera with the action &quot;send an email&quot;, and a second event that detects motion on a camera with the action &quot;create a bookmark&quot;.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\">There are three types of Event Rules:<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">User events<\/span><span class=\"f_BodyTextIndent\"> – Custom defined for a wide variety of conditions, using the available events and actions.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">System-generated events<\/span><span class=\"f_BodyTextIndent\"> – Exist for notification of critical storage and connection issues; a user cannot configure them or delete them. <\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Default Events<\/span><span class=\"f_BodyTextIndent\"> <\/span><span class=\"f_BodyTextIndent\">–<\/span><span class=\"f_BodyTextIndent\"> Preconfigured<\/span><span class=\"f_BodyTextIndent\"> events <\/span><span class=\"f_BodyTextIndent\">that run in background whenever DW Spectrum is open<\/span><span class=\"f_BodyTextIndent\">. Default events are triggered by System-level circumstances such as storage issue, license issues, device disconnection, etc. <\/span><\/p><p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"text-decoration: underline;\">Default Events<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">Default events are effective as soon as DW Spectrum is installed, and are automatically written to the <a href=\"viewing_events_log.html\" class=\"topiclink\">Event log<\/a>. With the exceptions noted below, all default events trigger both global notifications and an email:<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\"><a href=\"notifications.html\" class=\"topiclink\">Show Notifications<\/a> to all <\/span><span class=\"f_BodyTextFirstIndent2\">users, every 30 seconds until issue is resolved.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.0625rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\"><a href=\"mail_notifications.html\" class=\"topiclink\">Send Email<\/a> to System Owner. <\/span><\/p><p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">(The exceptions are <a href=\"archive_backup_finished.html\" class=\"topiclink\">Archive Backup Finished<\/a> and <a href=\"generic_event.html\" class=\"topiclink\">Generic Event<\/a>, which send notifications only, and <a href=\"media_server_started.html\" class=\"topiclink\">Server Started<\/a>, which sends email only.)<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"text-decoration: underline;\">Event Indicators in Layout<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">Due to their importance, or simply to make an event noticeable in a dense layout, certain events provide built-in visual indication when triggered. For critical events – storage issue or storage not configured, server failure or conflict, device disconnected, etc. – the indicator is a set of red outlines that radiate from the perimeter of the related item in layout. For other less critical events – motion on camera, input signal on device – a set of green outlines will radiate from the perimeter of the related item. The server monitor also provides a similar visual indicator when a server issue is detected.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"text-decoration: underline;\">Event Logging<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">Events are automatically recorded in the System Event Log (see &quot;<a href=\"viewing_events_log.html\" class=\"topiclink\">Viewing Events Log<\/a>&quot;). The<\/span><span class=\"f_BodyTextIndent\"> &quot;<a href=\"write_to_log.html\" class=\"topiclink\">Write to Log<\/a>&quot; <\/span><span class=\"f_BodyTextIndent\">action <\/span><span class=\"f_BodyTextIndent\">can be used for an event to be written to the log without needing to perform an external action such as playing a sound, sending an email, setting a bookmark, etc. <\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"text-decoration: underline;\">Turning Rules On or Off<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Using the Event Rule List<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\"> <\/span><span class=\"f_BodyTextIndent\">–<\/span><span class=\"f_BodyTextIndent\"> Once a rule is defined, it can be turned on or off using a checkbox in the Event Rules list. Turning a rule off means the event will not be detected and the corresponding action will not be performed.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Using the Schedule<\/span><span class=\"f_BodyTextIndent\"> – For any rule, <\/span><span class=\"f_BodyText\">detection of the event can be turned on or off in increments of one hour using a weekly calendar (see &quot;<a href=\"setting_up_schedule_for_tracki.html\" class=\"topiclink\">Event Scheduling<\/a>&quot;.)<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Using Global Notification<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic; font-weight: bold;\"> <\/span><span class=\"f_BodyTextIndent\">–<\/span><span class=\"f_BodyTextIndent\"> Notification of a rule occurrence can be turned on or off System-wide <\/span><span class=\"f_BodyTextIndent\">(s<\/span><span class=\"f_BodyTextIndent\">ee &quot;<a href=\"global_notifications.html\" class=\"topiclink\">Global Notification Settings<\/a>&quot;). The rule is still on, but notifications are not sent when it triggers.<\/span><\/p><p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"text-decoration: underline;\">Resetting All Rules to Default<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">Rule configurations can be returned to their default settings:<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">1.<\/span><span class=\"f_BodyTextFirstIndent2\">From <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">Main Menu <\/span><span class=\"f_BodyTextFirstIndent2\">&gt; <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">System Administration<\/span><span class=\"f_BodyTextFirstIndent2\"> &gt;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\"> Event Rules<\/span><span class=\"f_BodyTextFirstIndent2\">.<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">2.<\/span><span class=\"f_BodyTextFirstIndent2\">Click on <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">Restore all<\/span><span class=\"f_T_Interface_Elements\" style=\"font-style: normal; font-weight: bold;\"> Rules to Default<\/span><span class=\"f_T_Interface_Elements\" style=\"font-style: normal;\">.<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">3.<\/span><span class=\"f_BodyTextFirstIndent2\">Click <\/span><span class=\"f_T_Interface_Elements\" style=\"font-style: normal; font-weight: bold;\">Reset<\/span><span class=\"f_T_Interface_Elements\"> <\/span><span class=\"f_T_Interface_Elements\" style=\"font-style: normal;\">to accept changes.<\/span><\/p><p class=\"p_BodyTextIndent\"><img alt=\"!\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/!.png\"\/><span class=\"f_ImageCaption\" style=\"font-size: 1.10rem; font-family: Calibri,Vectora,\'Droid Sans\',\'Open Sans\',Frutiger,sans-serif;\"> <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">IMPORTANT:<\/span><span class=\"f_BodyTextIndent\"> All user-defined rules are discarded when you restore rules to default.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"text-decoration: underline;\">To Create a Rule<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">See &quot;<\/span><span class=\"f_BodyTextIndent\" style=\"text-decoration: underline;\"><a href=\"configuring_event_rules.html\" class=\"topiclink\">Using the Event Rules List<\/a><\/span><span class=\"f_BodyTextIndent\">&quot; and &quot;<a href=\"event_rule_advanced_settigns_f.html\" class=\"topiclink\">Using the Event Rules Form<\/a>&quot;.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"text-decoration: underline;\">To Delete a Rule<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">Right-click<\/span><span class=\"f_BodyTextIndent\"> on a single rule in the list and choose <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">Delete<\/span><span class=\"f_BodyTextIndent\"> from the context menu<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\">Use the <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">Delete<\/span><span class=\"f_BodyTextIndent\"> button at the top of the dialog. <\/span><\/p><p class=\"p_BodyTextIndent\"><img alt=\"!\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/!.png\"\/><span class=\"f_ImageCaption\" style=\"font-size: 1.10rem; font-family: Calibri,Vectora,\'Droid Sans\',\'Open Sans\',Frutiger,sans-serif;\"> <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">IMPORTANT: <\/span><span class=\"f_BodyTextIndent\">There is no confirmation prompt before a rule is deleted.<\/span><\/p>\n\r"
})
