hmLoadTopic({
hmKeywords:"",
hmTitle:"Configuring Failover",
hmDescription:"Automatic failover allows a server to automatically discover and attach cameras from a failed server. The failed and the functional server(s) must be within the same System....",
hmPrevLink:"split_server_to_different_syst.html",
hmNextLink:"configuring_routing_within_mul.html",
hmParentLink:"configuring_multi-server_envir.html",
hmBreadCrumbs:"<a href=\"working_with_display_product_n.html\">Working with DW Spectrum<\/a> &gt; <a href=\"configuring_multi-server_envir.html\">Configuring Multi-Server Environment<\/a>",
hmTitlePath:"Working with DW Spectrum > Configuring Multi-Server Environment > Configuring Failover",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">Configuring Failover<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"font-style: italic; background-color: #ffffff;\">Automatic<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyText\" style=\"font-style: italic; background-color: #ffffff;\">failover<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">&nbsp;allows a server to automatically discover and attach cameras from a failed server.&nbsp;<\/span><span class=\"f_BodyText\">The failed and the functional server(s) must be within the same System. <\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">When a server power, networking failure, or failure to the last remaining storage drives occurs, devices are transferred to the first available failover-enabled server, and the Client is automatically reconnected. A 30-day grace period is granted to the failover-enabled server to allow the cameras to continue recording seamlessly (see&nbsp;<a href=\"deleting_expired_license_keys.html\" class=\"topiclink\">Expired and Invalid License Keys<\/a>).<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">Failover requires that at least two servers be enabled. However, to adequately protect a System, all servers should be failover-enabled. This is to protect any given server and because failover success depends on the device capacity of the individual servers.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">For example, in a System with three servers, server A has maximum capacity of 128 cameras and is actively recording 80 cameras, server B has a maximum capacity of 128 cameras and is actively recording 64 cameras, and server C has a maximum capacity of 128 cameras and is actively recording 88 cameras. Therefore server A has a failover capacity of 48 devices (128 -40), server B has a failover capacity of 64 devices (128-64), and server C has a failover capacity of 40 devices (128-88).<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">If any one of these servers were to fail, both the other servers would be required to capture all of the disconnected devices. For example, a failure of server A would require space for 80 devices. Server B has failover capacity for 64 devices and server C has failover capacity for 40<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">&nbsp;devices, so neither alone would be sufficient (64 + 40 ≥ 80). Similarly, A (48) plus C (40) are needed for the 64 cameras on B if it were to fail, and A + B are needed for the 88 devices on C (48 + 64 ≥ 88).<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">Failover takes approximately 1 minute in the instance of a network or power failure. Archive playback from the failed server will not function until it is back online.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"background-color: #ffffff; text-decoration: underline;\">To Configure Failover on a Server<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">The failover priority setting is a system-wide option and is synced across all servers in the System.<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">&nbsp;When failover is enabled, if the last remaining main storage location is invalid or failed, failover is triggered automatically.<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">1.<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">Right click on the desired server in the Resource Panel and choose<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic; background-color: #ffffff;\">&nbsp;Server Settings<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">2.<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">In the&nbsp;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic; background-color: #ffffff;\">General<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">&nbsp;tab of the&nbsp;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic; background-color: #ffffff;\">Server Settings<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">&nbsp;dialog, enable&nbsp;<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold; background-color: #ffffff;\">Failover<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">3.<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">Enter<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">&nbsp;the maximum number of cameras that can be attached to the server (128 maximum on Core i3 or above CPUs, 12 maximum on ARM CPUs).<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">4.<\/span><span class=\"f_BodyText\">Set the <\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\">Server Location ID<\/span><span class=\"f_BodyText\">. By default, this value is 0 for all servers with failover enabled. Servers that share the same Location ID can failover to one another but not to servers with different Location IDs. This ensures that failover occurs between appropriate servers (for example, you may want to set servers near one another to the same Location ID and severs that are further away to a different Location ID).<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">5.<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">Click&nbsp;<\/span><span class=\"f_BodyText\" style=\"font-style: italic; background-color: #ffffff;\">Apply<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">&nbsp;or&nbsp;<\/span><span class=\"f_BodyText\" style=\"font-style: italic; background-color: #ffffff;\">OK<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">6.<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">Repeat steps 1 – 4 to enable additional failover servers.<\/span><\/p><p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">It is also possible to establish a&nbsp;<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold; background-color: #ffffff;\">failover priority<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">&nbsp;for individual cameras, so that the most important streams will be transferred first, lower priority cameras after that, and inessential devices can be set to not transfer at all.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"background-color: #ffffff; text-decoration: underline;\">To Configure Failover Priority for a Specific Camera<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">By default all cameras in a System are set to &quot;Medium&quot; failover priority. To turn off the failover feature for a given cameras, set it to &quot;Never&quot;.<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">1.<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">In the&nbsp;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic; background-color: #ffffff;\">General<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">&nbsp;tab of the&nbsp;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic; background-color: #ffffff;\">Server Settings<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">&nbsp;dialog, click&nbsp;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold; background-color: #ffffff;\">Failover Priority<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">2.<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">Expand each server to list the attached cameras and reveal the Failover Priority checkbox. The default setting is medium.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">3.<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">Check the desired camera and click one of the buttons –&nbsp;<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold; background-color: #ffffff;\">Never<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">,&nbsp;<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold; background-color: #ffffff;\">Low<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">,&nbsp;<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold; background-color: #ffffff;\">Medium<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">, or&nbsp;<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold; background-color: #ffffff;\">High<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">&nbsp;– at the bottom to set the desired priority.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">4.<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">Repeat steps 2 – 3 for all cameras that should be given a failover priority.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">5.<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">Click&nbsp;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic; background-color: #ffffff;\">OK<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">&nbsp;to apply changes in the Failover Priority dialog.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">6.<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">Click&nbsp;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic; background-color: #ffffff;\">OK<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">&nbsp;or&nbsp;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic; background-color: #ffffff;\">Apply<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">&nbsp;in the Server Setting dialog.<\/span><\/p>"
})
