hmLoadTopic({
hmKeywords:"",
hmTitle:"Configuring Server and NAS Storage",
hmDescription:"Each server can use an unlimited number of local and network storage paths. If more than one storage location is used, the Media Server will automatically balance space...",
hmPrevLink:"restoring_broken_archive.html",
hmNextLink:"configuring_redundant_storage_.html",
hmParentLink:"configuring_media_servers_additional_settings_(ad.html",
hmBreadCrumbs:"<a href=\"working_with_display_product_n.html\">Working with DW Spectrum<\/a> &gt; <a href=\"configuring_media_servers_additional_settings_(ad.html\">Configuring Server Settings<\/a>",
hmTitlePath:"Working with DW Spectrum > Configuring Server Settings > Configuring Server and NAS Storage",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">Configuring Server and NAS Storage<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">Each&nbsp;<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">server<\/span><span class=\"f_BodyText\" style=\"font-weight: bold; background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">can use an unlimited number of local and network&nbsp;<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">storage<\/span><span class=\"f_BodyText\" style=\"font-weight: bold; background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">paths<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">. If more than one storage location<\/span><span class=\"f_BodyText\" style=\"font-weight: bold; background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">is used, the&nbsp;<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">Media Server<\/span><span class=\"f_BodyText\" style=\"font-weight: bold; background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">will<\/span><span class=\"f_BodyText\" style=\"font-weight: bold; background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">automatically balance space consumption across drives (see &quot;<a href=\"archive_retention.html\" class=\"topiclink\">Background: Archive Distribution and Retention<\/a>&quot;).&nbsp;<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">Each local&nbsp;<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">hard disk partition is considered a storage location. If enabled, Network attached storage (<\/span><span class=\"f_BodyText\" style=\"font-weight: bold; background-color: #ffffff;\">NAS<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">) and USB storage are also supported. Usage intensity is directly related to storage availability.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><img alt=\"!\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/!.png\"\/><span class=\"f_ImageCaption\" style=\"background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold; background-color: #ffffff;\">IMPORTANT:<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">&nbsp;10-30 GB of free space is always preserved on each s<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">torage location<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">. For NAS storage, this amount may vary between 50 and 100 GB depending on storage capacity. If only one system partition (where OS is installed) is present, then DW Spectrum will use this partition for recording. If any other disk is added and an extended partition is created with 5 times the storage capacity than the system storage or if the total sum of available (non-system) storage capacity is 5 times that of the system storage, the system partition will be disabled for recording and DW Spectrum will record data to the extended partition(s).<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"background-color: #ffffff; text-decoration: underline;\">To Configure Server Storage<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><img alt=\"note\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/note.png\"\/><span class=\"f_ImageCaption\" style=\"background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyText\" style=\"font-weight: bold; background-color: #ffffff;\">Note<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">: USB storage is not enabled by default. DW Spectrum will show a warning when a user is attempting to record to a removable drive (USB).<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">1.<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">Do one of the following:<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent3\" style=\"font-style: italic; background-color: #ffffff;\">Desktop Client<\/span><span class=\"f_BodyTextFirstIndent3\" style=\"background-color: #ffffff;\">: Open the server context menu and go to&nbsp;<\/span><span class=\"f_BodyTextFirstIndent3\" style=\"font-weight: bold; background-color: #ffffff;\">Server Settings<\/span><span class=\"f_BodyTextFirstIndent3\" style=\"background-color: #ffffff;\">&nbsp;&gt;&nbsp;<\/span><span class=\"f_BodyTextFirstIndent3\" style=\"font-weight: bold; background-color: #ffffff;\">Storage Management<\/span><span class=\"f_BodyTextFirstIndent3\" style=\"font-style: italic; background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyTextFirstIndent3\" style=\"background-color: #ffffff;\">tab.<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 2.0000rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\"><a href=\"connecting_to_vms_thr.html\" class=\"topiclink\">Web Admin<\/a><\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\"> <\/span><span class=\"f_BodyTextIndent\">\/<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\"> <a href=\"cloudname-portal-interface.html\" class=\"topiclink\">Cloud Portal<\/a><\/span><span class=\"f_BodyTextFirstIndent2\">: Open <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">Settings<\/span><span class=\"f_BodyTextFirstIndent2\"> &gt; <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">Servers<\/span><span class=\"f_BodyTextFirstIndent2\"> and select a server.<\/span><\/p><p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">&nbsp;DW Spectrum discovers and displays local storage resources.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">2.<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">In the example shown below, the computer has 3 partitions. Disk E is the main storage partition and disk D is configured as backup. Disk C is not used because it is a system partition (a partition where the operating system is installed) and there are two other storage locations in the list. The system disk drive will be used if it is the only storage location on a server or the total sum of available storage space (excluding the system partition) is less than 5 times the system partition size.<\/span><\/p><p class=\"p_BodyTextFirstIndent2\"><img alt=\"Obtaining and Configuring Media Server\'s Additional Settings (Admin Only) - 1\" style=\"margin:0;width:37.1250rem;height:13.4375rem;border:none\" src=\".\/images\/hmfile_hash_c45e1de1.png\"\/><br \/>\n\r<span class=\"f_ImageCaption\" style=\"background-color: #ffffff;\">&nbsp;<\/span><br \/>\n\r<img alt=\"note\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/note.png\"\/><span class=\"f_ImageCaption\" style=\"background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold; background-color: #ffffff;\">Note<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">: Recycling bins (i.e. Trashboxes\/trash bins) must be disabled as a part of the configuration step.&nbsp;<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">DW Spectrum&nbsp;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">Server will start overwriting data when the &quot;Reserved Space&quot; limit is reached. To do that, it sends standard SMB-delete requests to the NAS drive. NAS will put files in the bin if the recycle bin is enabled. The&nbsp;<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">DW Spectrum&nbsp;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">Server will not get the necessary space, sending new delete commands instead. Eventually, it will end up with a full drive and the inability to record data until the recycle bin is emptied.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">3.<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">Click on a storage location and use the button at the end of the row to toggle it on or off. There must always be at least one&nbsp;<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold; background-color: #ffffff;\">Main<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">&nbsp;storage location. Once a main storage location is configured, any other storage location you may have can be set as&nbsp;<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold; background-color: #ffffff;\">Main<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">&nbsp;or&nbsp;<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold; background-color: #ffffff;\">Backup<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">.<\/span><\/p><p class=\"p_BodyTextFirstIndent2\"><img alt=\"note\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/note.png\"\/><span class=\"f_ImageCaption\" style=\"background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold; background-color: #ffffff;\">Note<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">: At least one drive must be defined as&nbsp;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">Backup<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">&nbsp;for archive backup to be possible.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">4.<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">DW Spectrum will check all storage locations for validity and confirm the ability to write to each. If a drive is not available or has insufficient space, a warning will display.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">5.<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">To enable storage backup, see &quot;<a href=\"configuring_redundant_storage_.html\" class=\"topiclink\">Configuring Backup and Redundant Storage<\/a>&quot;<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">.<\/span><\/p><p class=\"p_BodyTextFirstIndent2\"><img alt=\"note\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/note.png\"\/><span class=\"f_ImageCaption\" style=\"background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyText\" style=\"font-weight: bold; background-color: #ffffff;\">Note<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">: Because some cameras record directly to their own internal storage, DW Spectrum must periodically download archive from the camera\'s internal storage to<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">&nbsp;DW Spectrum System<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">&nbsp;servers. See &quot;<a href=\"remote_archive_synchronization.html\" class=\"topiclink\">Remote Archive Synchronization<\/a>&quot;.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"background-color: #ffffff; text-decoration: underline;\">To Add Network Storage<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">External storage must use one of the supported storage protocols:&nbsp;<\/span><span class=\"f_BodyTextIndent\">CIFS, SMB, NFS, or iSCSI.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><img alt=\"!\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/!.png\"\/><span class=\"f_ImageCaption\" style=\"background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyText\" style=\"font-weight: bold; background-color: #ffffff;\">IMPORTANT:<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">Make sure NAS is available and accessible through the network on which the computer&nbsp;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">server<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">&nbsp;is installed.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">1.<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">Do one of the following:<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent3\" style=\"font-style: italic; background-color: #ffffff;\">Desktop Client:&nbsp;<\/span><span class=\"f_BodyTextFirstIndent3\" style=\"background-color: #ffffff;\">Open the server\'s context menu and go to&nbsp;<\/span><span class=\"f_BodyTextFirstIndent3\" style=\"font-weight: bold; background-color: #ffffff;\">Server Settings<\/span><span class=\"f_BodyTextFirstIndent3\" style=\"background-color: #ffffff;\">&nbsp;&gt;&nbsp;<\/span><span class=\"f_BodyTextFirstIndent3\" style=\"font-weight: bold; background-color: #ffffff;\">Storage Management<\/span><span class=\"f_BodyTextFirstIndent3\" style=\"font-style: italic; background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyTextFirstIndent3\" style=\"background-color: #ffffff;\">tab.<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent3\" style=\"font-style: italic;\"><a href=\"connecting_to_vms_thr.html\" class=\"topiclink\">Web Admin<\/a> <\/span><span class=\"f_BodyTextIndent\">\/ <\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\"><a href=\"cloudname-portal-interface.html\" class=\"topiclink\">Cloud Portal<\/a><\/span><span class=\"f_BodyTextFirstIndent3\" style=\"font-style: italic;\">: <\/span><span class=\"f_BodyTextFirstIndent3\">Open <\/span><span class=\"f_BodyTextFirstIndent3\" style=\"font-weight: bold;\">Settings<\/span><span class=\"f_BodyTextFirstIndent3\"> &gt; <\/span><span class=\"f_BodyTextFirstIndent3\" style=\"font-weight: bold;\">Servers<\/span><span class=\"f_BodyTextFirstIndent3\"> and select a server.<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0; margin-left: 2.1250rem;\"><span class=\"f_BodyTextIndent\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">2.<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">Click&nbsp;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold; background-color: #ffffff;\">Add External Storage<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">.<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0; margin-left: 2.1250rem;\"><span class=\"f_BodyTextIndent\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">3.<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">Choose the desired option from the&nbsp;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold; background-color: #ffffff;\">Protocol<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic; background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">menu,<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic; background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">and enter the storage path (<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold; background-color: #ffffff;\">URL<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">),&nbsp;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold; background-color: #ffffff;\">Login<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic; background-color: #ffffff;\">,<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">&nbsp;and&nbsp;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold; background-color: #ffffff;\">Password<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">&nbsp;for the external storage device.<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0; margin-left: 2.1250rem;\"><span class=\"f_BodyTextIndent\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">4.<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">Click OK to accept the entries and add the new device to the list of storage locations.<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0; margin-left: 2.1250rem;\"><span class=\"f_BodyTextIndent\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">5.<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">Use the button at the end of the row to toggle it on or off.<\/span><\/p><p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><a id=\"tofindarchiveonastoragedevice\" class=\"hmanchor\"><\/a><span class=\"f_BodyText\" style=\"background-color: #ffffff; text-decoration: underline;\">To Find Archive on a Storage Device<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">The s<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">torage<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold; background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">structure<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">&nbsp;on a partition is as follows:<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic; background-color: #ffffff;\">&lt;drive&gt;\/DW Spectrum Media\/\$Resolution\/\$ID\/\$YYYY\/\$MM\/\$DD\/\$HH<\/span><\/p><p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">where:<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic; background-color: #ffffff;\">\$Resolution<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyTextFirstIndent3\" style=\"background-color: #ffffff;\">– can be&nbsp;<\/span><span class=\"f_BodyTextFirstIndent3\" style=\"font-style: italic; background-color: #ffffff;\">hi_quality<\/span><span class=\"f_BodyTextFirstIndent3\" style=\"background-color: #ffffff;\">&nbsp;(high resolution streams) or<\/span><span class=\"f_BodyTextFirstIndent3\" style=\"font-style: italic; background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic; background-color: #ffffff;\">lo_quality<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">&nbsp;(low resolution streams)<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.0625rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic; background-color: #ffffff;\">\$ID<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">&nbsp;– if reported, the MAC address of the recorded device, otherwise the Camera ID<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.0625rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic; background-color: #ffffff;\">\$YYYY<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">&nbsp;– year recorded<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.0625rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic; background-color: #ffffff;\">\$MM<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">&nbsp;– month recorded<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.0625rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic; background-color: #ffffff;\">\$DD<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">&nbsp;– day recorded<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.0625rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic; background-color: #ffffff;\">\$HH&nbsp;<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">– hour recorded<\/span><\/p><p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"text-decoration: underline;\">Reindexing and Fast Archive Scanning<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">The Server creates a database that stores an index that maps the relationship between archive filenames and the physical location of the archive on the storage drive. <a href=\"restoring_broken_archive.html\" class=\"topiclink\">Reindexing an archive<\/a> restores the relationship between the database and storage drive. This process can take up to several hours, depending on the size of the archive. The System can still be used during this process and will continue recording while the archive is reindexed as long as the storage drive has enough capacity to do both simultaneously (performance may be affected).<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">Reindexing should be performed when the index is broken, which can occur when<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\">a camera is deleted; or<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.0625rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\">a storage device is moved, renamed, or deleted; or<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.0625rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\">an archive file is removed, renamed, has an incorrect timestamp, or is otherwise corrupted.<\/span><\/p><p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">When an archive is damaged, administrators will receive a notification when attempting to view that archive. The notification indicates the storage path where the problem was detected. When a camera is deleted, its archive remains, but access to the footage is lost. After reindexing, the Desktop Client will display the deleted camera in the Resource Tree as an offline device so that it is possible to navigate through its archive.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><img alt=\"note\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/note.png\"\/><span class=\"f_ImageCaption\" style=\"background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyText\" style=\"font-weight: bold; background-color: #ffffff;\">Note<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">:<\/span><span class=\"f_BodyText\"> Archives can be saved to one or more backup storage locations to protect against the possibility of complete loss or removal.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">A fast archive scan checks to see that the database is intact and matches the archive. This process usually only takes a few seconds and occurs automatically when the Server is initially started or restarted at any point afterward, an archive file closed improperly, or the index files cannot be read. During a fast archive scan, recording will be put on hold and resume after the process is complete. <\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">There are a few situations where a fast archive scan may take much longer than anticipated, such as when there is an extremely large archive, the server database was moved while the server was offline, or an archive from another server was transferred over to this server prior to its initial launch.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"background-color: #ffffff; text-decoration: underline;\">To Fix the Analytics Storage Database Error<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">The error “Storage Issue: Analytics storage DB error. Insufficient permissions on the mount point” typically occurs on Ubuntu servers when trying to store analytics data on a drive that the DW Spectrum Server application is not able to properly access due to having inadequate permissions. Your server is likely missing the following permissions to the storage drive:<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\">Read (the capability to read the contents of the file)<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.0625rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\">Execute (the capability to execute a file or view the contents of a directory)<\/span><\/p><p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">Fix the storage issue by enabling the option <\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">forceAnalyticsDbStoragePermissons<\/span><span class=\"f_BodyTextIndent\"> in the DW Spectrum Web Admin interface. This option grants the DW Spectrum Server application the necessary read and execute permissions for that storage drive.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">By default, the option is enabled, but it may not be enabled if you have upgraded from a previous version. To enable it manually:<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">1.<\/span><span class=\"f_BodyTextFirstIndent2\">Open the <\/span><span class=\"f_BodyText\">DW Spectrum<\/span><span class=\"f_BodyTextFirstIndent2\"> Web Admin advanced page (i.e., http:\/\/&lt;server ip&gt;:&lt;server port&gt;\/static\/index.html#\/advanced).<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">2.<\/span><span class=\"f_BodyTextIndent\">Log in to the administrator account to gain access.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">3.<\/span><span class=\"f_BodyTextIndent\">Check the box for <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">forceAnalyticsDbStoragePermissons<\/span><span class=\"f_BodyTextIndent\">.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">4.<\/span><span class=\"f_BodyTextIndent\">Click the <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">Save<\/span><span class=\"f_BodyTextIndent\"> button at the bottom of the page.<\/span><\/p><p class=\"p_BodyTextFirstIndent2\"><img alt=\"note\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/note.png\"\/><span class=\"f_ImageCaption\" style=\"background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyText\" style=\"font-weight: bold; background-color: #ffffff;\">Note<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">: If the server still does not have the appropriate permissions after enabling&nbsp;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">forceAnalyticsDbStoragePermissons<\/span><span class=\"f_BodyTextIndent\">, the error<\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\"> <\/span><span class=\"f_BodyText\">“Storage Issue: Analytics storage DB error. Insufficient permissions on the mount point” will still appear in the Notification Panel.<\/span><\/p>\n\r"
})
