hmLoadTopic({
hmKeywords:"",
hmTitle:"Dual Stream Processing",
hmDescription:"Most IP cameras can provide multiple data streams, each at a different resolution and frame rate. DW Spectrum requests two data streams, one high resolution and one low...",
hmPrevLink:"preventing_vms_from_c.html",
hmNextLink:"setting_up_camera_transport_pr.html",
hmParentLink:"working_around_device_issues_e.html",
hmBreadCrumbs:"<a href=\"working_with_display_product_n.html\">Working with DW Spectrum<\/a> &gt; <a href=\"configuring_cameras.html\">Device Management<\/a> &gt; <a href=\"setting_up_cameras_and_devices.html\">Setting Up Cameras and Devices<\/a> &gt; <a href=\"working_around_device_issues_e.html\">Working With Expert Device Settings<\/a>",
hmTitlePath:"Working with DW Spectrum > Device Management > Setting Up Cameras and Devices > Working With Expert Device Settings > Dual Stream Processing",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">Dual Stream Processing<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\">Most IP cameras can provide multiple data streams, each at a different resolution and frame rate. DW Spectrum requests two data streams, one high resolution and one low resolution, and switches between them for the best image quality with the least impact on processing and network efficiency. This <\/span><span class=\"f_BodyText\" style=\"font-style: italic;\">adaptive scaling<\/span><span class=\"f_BodyText\"> is one of the most valued features of the DW Spectrum VMS:<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Primary (High-Resolution)<\/span><span class=\"f_BodyTextIndent\"> <\/span><span class=\"f_BodyTextFirstIndent2\">–<\/span><span class=\"f_BodyTextIndent\"> Streams provide better image quality, but require significant CPU capacity and network bandwidth to view.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Secondary<\/span><span class=\"f_BodyText\" style=\"font-style: italic;\"> (Low-Resolution) <\/span><span class=\"f_BodyTextFirstIndent2\">– S<\/span><span class=\"f_BodyText\">treams require far less computing power than typical high-resolution streams, but provide much lower image resolution at a slower frame rate.<\/span><\/p><p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\">When a camera supports dual-streaming, the System tries to<\/span><span class=\"f_BodyText\"> configure the low-resolution stream at or near 640x360 resolution at 7fps<\/span><span class=\"f_BodyTextIndent\"> (though some cameras may set secondary stream resolution at up to 720p). <\/span><span class=\"f_BodyText\">The secondary stream is used for constant recording, for <\/span><span class=\"f_BodyText\">motion detection (as long as the resolution is less than 1024x728), <\/span><span class=\"f_BodyText\">and to save <\/span><span class=\"f_BodyText\">bandwidth and CPU during playback<\/span><span class=\"f_BodyText\">. <\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\">However, if the secondary stream resolution is more than 1024x728, the media server will check the primary stream resolution. If the primary stream is less than 1024x728, it will be used for motion. If it\'s higher than 1024x728, motion detection will be disabled unless <\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\">Force motion detection for the stream<\/span><span class=\"f_BodyText\"> is enabled in <\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\">Camera Settings<\/span><span class=\"f_BodyText\"> &gt; <\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\">Expert<\/span><span class=\"f_BodyText\"> tab.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\">Default DW Spectrum dual stream settings work well with most cameras. If not, a set of individual controls can be used to manually control stream processing. It is important to understand how these settings behave individually and together, as adjusting them can seriously affect server and display performance.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><img alt=\"!\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/!.png\"\/><span class=\"f_ImageCaption\"> <\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\">IMPORTANT: <\/span><span class=\"f_BodyText\">Do not change image or stream quality settings unless you are absolutely sure of the likely impact on System performance.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"text-decoration: underline;\">Dual Streaming on the Server<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">The Server uses the<\/span><span class=\"f_BodyTextIndent\"> low-resolution<\/span><span class=\"f_BodyTextIndent\"> stream whenever possible for software motion detection and records both streams to archive unless a different behavior is specified. However, some cameras may not or cannot comply with default System behavior, usually for one of these reasons:<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\">Requested settings are not available from the camera.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.0625rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\">The lowest resolution stream is higher than 640x360p.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.0625rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\">A secondary or low-resolution stream is not provided at all.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.0625rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\">A low<\/span><span class=\"f_BodyText\">-resolution stream is provided as Primary and a high-resolution stream as Secondary.<\/span><\/p><p class=\"p_BodyTextFirstIndent2\"><img alt=\"note\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/note.png\"\/><span class=\"f_ImageCaption\"> <\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\">Note<\/span><span class=\"f_BodyText\">: If data is not received from the secondary stream for more than 10 seconds, the Sever will re-initialize the camera.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"text-decoration: underline;\">Dual Streaming on the Client<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">On the Client, stream resolution for viewing live or archive video is selected automatically.<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\">High Resolution is displayed under the following conditions:<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent3\">Network bandwidth and CPU load are within normal range.<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyText\">An item is pulled into Fullscreen display.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.0625rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\">Low Resolution is displayed under the following conditions:<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent3\">If network bandwidth between client and server is insufficient.<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent3\">When image quality is of limited importance: items smaller than 172 pixels, during fast forward or fast rewind playback.<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent3\">When high resolution processing compromises display quality or raises CPU usage to a high level (frames are delayed or dropped during decoding, too many streams are open in a given layout).<\/span><\/p><p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"text-decoration: underline;\">Settings That Affect Motion Detection<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">Motion detection is performed on the lowest resolution stream detected, to a threshold of ≤ 1024x768p. Above that, motion detection will not be performed. <\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">Motion Detection<\/span><span class=\"f_BodyTextFirstIndent2\"> <\/span><span class=\"f_BodyTextFirstIndent2\">– <\/span><span class=\"f_BodyTextFirstIndent3\">Toggles motion detection on and off for a given camera (see &quot;<a href=\"editing_recording_schedule.html\" class=\"topiclink\">Setting a Recording Schedule<\/a>&quot;).<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">Disable secondary stream<\/span><span class=\"f_BodyTextFirstIndent2\"> <\/span><span class=\"f_BodyTextFirstIndent2\">– <\/span><span class=\"f_BodyTextFirstIndent3\">If enabled, motion detection will not be performed for the camera, and the secondary stream will not be archived (see &quot;<\/span><span class=\"f_BodyTextIndent\"><a href=\"disabling_secondary_stream.html\" class=\"topiclink\">Disabling a Secondary Stream<\/a>&quot;).<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">Force motion detection for stream<\/span><span class=\"f_BodyTextFirstIndent2\"> <\/span><span class=\"f_BodyTextFirstIndent2\">– <\/span><span class=\"f_BodyTextFirstIndent3\">Occasionally, a camera will report its configuration incorrectly and swap the primary and secondary streams. If the secondary stream is high-resolution, motion detection processing will create a very high CPU load. To correct this you can force motion detection to a specific stream (see &quot;<a href=\"forcing_software_motion_detect.html\" class=\"topiclink\">Forcing Motion Detection to a Specific Stream<\/a>&quot;).<\/span><\/p><p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"text-decoration: underline;\">Settings That Affect Recording and Playback<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">When certain settings are applied, the server may or may not archive high-resolution or low-resolution streams.<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">Motion + Lo-Res<\/span><span class=\"f_BodyTextFirstIndent2\"> <\/span><span class=\"f_BodyTextFirstIndent2\">– <\/span><span class=\"f_BodyTextFirstIndent2\">Archives the high-resolution stream when motion is detected and the low-resolution stream when there is no motion, so high-resolution will not always be available for playback <\/span><span class=\"f_BodyTextFirstIndent3\">(see &quot;<a href=\"editing_recording_schedule.html\" class=\"topiclink\">Setting a Recording Schedule<\/a>&quot;)<\/span><span class=\"f_BodyTextFirstIndent2\">.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.0625rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Disable secondary stream<\/span><span class=\"f_BodyTextIndent\"> <\/span><span class=\"f_BodyTextFirstIndent2\">– <\/span><span class=\"f_BodyTextFirstIndent2\">If checked, motion detection won’t be performed for the camera, and the secondary stream won’t be archived (see &quot;<a href=\"disabling_secondary_stream.html\" class=\"topiclink\">Disabling a Secondary Stream<\/a>&quot;).<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.0625rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Do not archive primary stream \/ Do not archive secondary stream<\/span><span class=\"f_BodyTextIndent\"> <\/span><span class=\"f_BodyTextFirstIndent2\">– <\/span><span class=\"f_BodyTextFirstIndent2\">Use to completely disable archiving of one or both streams (see &quot;<\/span><span class=\"f_BodyTextIndent\"><a href=\"disabling_recording_of_primary.html\" class=\"topiclink\">Disabling Recording of a Specific Stream<\/a><\/span><span class=\"f_BodyTextFirstIndent2\">&quot;).<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.0625rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Video Streams Configuration<\/span><span class=\"f_BodyTextIndent\"> <\/span><span class=\"f_BodyTextFirstIndent2\">– <\/span><span class=\"f_BodyTextFirstIndent2\">Depending on the camera, camera stream settings may be configured in the either of these tabs <\/span><span class=\"f_BodyTextIndent\">(<\/span><span class=\"f_BodyTextIndent\">Camera Settings &gt; Advanced or <\/span><span class=\"f_BodyTextIndent\">Camera Settings &gt; Web Page<\/span><span class=\"f_BodyTextIndent\"> tab)<\/span><span class=\"f_BodyTextFirstIndent2\">. If you choose to control stream settings from one of these tabs you must do <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">one of the following<\/span><span class=\"f_BodyTextFirstIndent2\">:<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyText\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent3\">Open<\/span><span class=\"f_BodyTextFirstIndent3\" style=\"font-style: italic;\"> <\/span><span class=\"f_BodyTextFirstIndent3\" style=\"font-weight: bold;\">Camera Settings &gt; Expert<\/span><span class=\"f_BodyTextFirstIndent3\"> and enable <\/span><span class=\"f_BodyTextFirstIndent3\" style=\"font-weight: bold;\">Keep camera stream and profile settings<\/span><span class=\"f_BodyTextFirstIndent3\"> to prevent the internal optimization performed by DW Spectrum, and causes <\/span><span class=\"f_BodyText\">FPS and image quality settings in the Recording Schedule to be ignored. S<\/span><span class=\"f_BodyTextFirstIndent3\">ee &quot;<a href=\"preventing_vms_from_c.html\" class=\"topiclink\">Preventing DW Spectrum from Changing Manufacturer Settings<\/a><\/span><span class=\"f_BodyText\">&quot;.<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 2.0000rem; margin-left: 2.1250rem;\"><span class=\"f_BodyText\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent2\">Open <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">System Administration &gt; General<\/span><span class=\"f_BodyTextFirstIndent2\"> and disable <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">Allow System to optimize device settings<\/span><span class=\"f_BodyTextFirstIndent2\">.<\/span><\/p><p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">Refer to &quot;<a href=\"configuring_proprietary_camera_parameters.html\" class=\"topiclink\">Configuring Device Using DW Spectrum Client<\/a>&quot; and &quot;<a href=\"configuring_devices_using_thei.html\" class=\"topiclink\">Configuring Device Using Web Page<\/a>&quot; for how to use <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">Restore to Defaults<\/span><span class=\"f_BodyTextIndent\"> to discard manual adjustments and return to native presets.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">If performance has dropped significantly after a given layout was opened and some cameras on layout have a fixed high resolution setting, the message &quot;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Set layout resolution to &quot;Auto&quot; to increase performance<\/span><span class=\"f_BodyTextIndent\">&quot; will display across that layout so you can improve streaming quality yourself.<\/span><\/p>\n\r"
})
