hmLoadTopic({
hmKeywords:"",
hmTitle:"Generic Event (default)",
hmDescription:"Occurs when the server receives an HTTP request from an external system such as an alarm system, access control device, or monitoring system. This is a default event.",
hmPrevLink:"error_while_sending_e-mail.html",
hmNextLink:"input_signal_on_camera.html",
hmParentLink:"events_available_in_vms.html",
hmBreadCrumbs:"<a href=\"working_with_display_product_n.html\">Working with DW Spectrum<\/a> &gt; <a href=\"configuring_events_and_actions.html\">Event Rules<\/a> &gt; <a href=\"events_available_in_vms.html\">Tracked Events<\/a>",
hmTitlePath:"Working with DW Spectrum > Event Rules > Tracked Events > Generic Event (default)",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">Generic Event (default)<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\">Occurs when the server receives an HTTP request from an external system such as an alarm system, access control device, or monitoring system. This is a default event.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\">DW Spectrum allows third-party systems and devices to send an HTTP string known as a &quot;createEvent&quot; API call. The CreateEvent request must follow the proper format in order to be read by the server, and the event fields in the rule must match the corresponding fields in the HTTP request to be acted upon. <\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\">Together with the &quot;<a href=\"perform_http_request.html\" class=\"topiclink\">Do HTTP Request<\/a>&quot; action, which can send an HTTP request, you can create bidirectional API communication between DW Spectrum and other software systems. A Generic Event can automatically replace the appropriate <a href=\"perform_http_request.html#generichttp\" class=\"topiclink\">action parameter placeholders<\/a> used in a &quot;Do HTTP Request&quot; with the corresponding parameter\'s value. Full server API documentation can be accessed on any installed server from http:\/\/&lt;<\/span><span class=\"f_BodyText\" style=\"font-style: italic;\">serveripaddress<\/span><span class=\"f_BodyText\">&gt;:&lt;<\/span><span class=\"f_BodyText\" style=\"font-style: italic;\">servernetworkport<\/span><span class=\"f_BodyText\">&gt;\/static\/api.xml. See &quot;<a href=\"using_media_servers_web_interf.html\" class=\"topiclink\">Using a Server\'s Web Interface<\/a>&quot; for more information.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><img alt=\"note\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/note.png\"\/><span class=\"f_ImageCaption\"> <\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\">Note<\/span><span class=\"f_BodyText\">: Values in the event field are case-sensitive, and an empty string functions as a wildcard, where any value is considered a match.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"font-weight: bold;\">Basic Parameters<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">Each request contains the following fields:<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Source<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Caption<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Description<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Metadata<\/span><span class=\"f_BodyTextIndent\"> – <\/span><span class=\"f_BodyTextFirstIndent2\">Used to pass a device identifier that will specify devices the <\/span><span class=\"f_BodyTextIndent\">event is limited to (cameras, I\/O modules, etc). To obtain the device identifier:<\/span><\/p><p class=\"p_BodyTextFirstIndent2\"><span class=\"f_BodyTextIndent\">Open the device context menu and click <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">Device Settings<\/span><span class=\"f_BodyTextIndent\">. In the <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">General<\/span><span class=\"f_BodyTextIndent\"> tab, the device identifier will be displayed as <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">Camera\/Device ID<\/span><span class=\"f_BodyTextIndent\">. The d<\/span><span class=\"f_BodyTextIndent\">evice identifier should be passed in the following format: <\/span><span class=\"f_CodeExample\">{&quot;cameraRefs&quot;:[&quot;&lt;id&gt;&quot;]}<\/span><span class=\"f_BodyTextFirstIndent2\">. <\/span><span class=\"f_BodyTextIndent\">In HTML encoding it will look like this: <\/span><span class=\"f_CodeExample\">{%22cameraRefs%22:[%22&lt;id&gt;%22]}.<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\"><img alt=\"!\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/!.png\"\/><span class=\"f_ImageCaption\" style=\"font-size: 1.10rem; font-family: Calibri,Vectora,\'Droid Sans\',\'Open Sans\',Frutiger,sans-serif;\"> <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">IMPORTANT:<\/span><span class=\"f_BodyTextFirstIndent2\"> <\/span><span class=\"f_BodyTextFirstIndent2\">It is necessary to specify a device if the generic event is linked to a notification, and the &quot;Force Acknowledgment&quot; option is required. In this case once the notification is acknowledged, a Bookmark will be created and linked to the specified device. See &quot;<a href=\"notifications.html\" class=\"topiclink\">Show Notifications<\/a>&quot; for details.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyText\" style=\"font-style: italic;\">Occurs\/Starts\/Stops<\/span><span class=\"f_BodyText\"> – This is an optional field for the &quot;<\/span><span class=\"f_BodyText\">State&quot;.<\/span><span class=\"f_BodyText\"> <\/span><span class=\"f_BodyTextFirstIndent2\">If there is no &quot;State&quot; field in the HTTP request, the event is considered <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">instant<\/span><span class=\"f_BodyTextFirstIndent2\">. If specified, the event is considered <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">continuous<\/span><span class=\"f_BodyTextFirstIndent2\"> and the rule requires a State=<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">Active<\/span><span class=\"f_BodyTextFirstIndent2\"> <\/span><span class=\"f_BodyTextFirstIndent2\">(Start) <\/span><span class=\"f_BodyTextFirstIndent2\">or State=<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">Inactive<\/span><span class=\"f_BodyTextFirstIndent2\"> <\/span><span class=\"f_BodyTextFirstIndent2\">(Stop)<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\"> <\/span><span class=\"f_BodyTextFirstIndent2\">attribute. If a Generic Event containing State=Active is received, the resulting action will continue until the server receives a Generic Event with the same parameters that contains State=Inactive.<\/span><\/p><p class=\"p_BodyTextIndent\"><img alt=\"note\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/note.png\"\/><span class=\"f_ImageCaption\"> <\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\">Note<\/span><span class=\"f_BodyText\">: <\/span><span class=\"f_BodyTextFirstIndent2\">If a continuous action such as &quot;device recording&quot; or &quot;repeat sound&quot; is bound to an instant Generic Event (one without a State field), the rule will not work. (See &quot;<a href=\"configuring_event_rules.html\" class=\"topiclink\">Configuring Event Rules<\/a>&quot; for more information about continuous and instant events.)<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"font-weight: bold;\">Example<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">http:\/\/127.0.0.1:7001\/api\/createEvent?source=%22<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">Door<\/span><span class=\"f_BodyTextIndent\">%22&amp;caption=%22<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">Knock<\/span><span class=\"f_BodyTextIndent\">%20<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">Knock<\/span><span class=\"f_BodyTextIndent\">%22&amp;description=%22<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">Visitor!<\/span><span class=\"f_BodyTextIndent\">%22&amp;metadata={%22cameraRefs%22:[<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">%22066fbf9c-2e11-a501-6e15-dfb0fb97c7cb<\/span><span class=\"f_BodyTextIndent\">%22]} This HTTP request:<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\">Sends data to a server at IP Address 127.0.0.1 and Port 7001,<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Source<\/span><span class=\"f_BodyTextIndent\"> <\/span><span class=\"f_BodyTextFirstIndent2\">–&quot;Door&quot;.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">Caption<\/span><span class=\"f_BodyTextIndent\"> <\/span><span class=\"f_BodyTextFirstIndent2\">– &quot;Knock Knock&quot;.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">Description<\/span><span class=\"f_BodyTextIndent\"> <\/span><span class=\"f_BodyTextFirstIndent2\">– &quot;Visitor!&quot;.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">State<\/span><span class=\"f_BodyTextIndent\"> <\/span><span class=\"f_BodyTextFirstIndent2\">– Not used, so it is instant.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">Device Identifier<\/span><span class=\"f_BodyTextIndent\"> <\/span><span class=\"f_BodyTextFirstIndent2\">– 066fbf9c-2e11-a501-6e15-dfb0fb97c7cb.<\/span><\/p><p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\">Remember, fields in the Generic Event must match the corresponding HTTP request and are case-sensitive. For instance, for an event configured as <\/span><span class=\"f_BodyTextIndent\">Source <\/span><span class=\"f_BodyTextFirstIndent2\">&quot;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">foo<\/span><span class=\"f_BodyTextFirstIndent2\">&quot;, <\/span><span class=\"f_BodyTextIndent\">Caption<\/span><span class=\"f_BodyTextFirstIndent2\"> &quot;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">bar<\/span><span class=\"f_BodyTextFirstIndent2\">&quot;, and <\/span><span class=\"f_BodyTextIndent\">Description <\/span><span class=\"f_BodyTextFirstIndent2\">&quot;&quot; (empty)<\/span><span class=\"f_BodyText\">:<\/span><\/p>\n\r<div style=\"text-align: left; text-indent: 0; line-height: 1.38; padding: 0 0 0 0; margin: 0.1250rem 0 0.1250rem 0.8750rem;\"><table style=\"border:none; border-spacing:0;\">\n\r<tr>\n\r<td style=\"vertical-align:top; width:28.0625rem; padding:0; border:none\"><p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\" style=\"text-decoration: underline;\">An HTTP request with the following data WILL trigger a Generic Event:<\/span><\/p>\n\r<\/td>\n\r<td style=\"vertical-align:top; width:32.7500rem; padding:0; border:none\"><p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\" style=\"text-decoration: underline;\">An HTTP request with the following data will NOT trigger Generic Event:<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr>\n\r<td style=\"vertical-align:top; width:28.0625rem; padding:0; border:none\"><p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">Source – <\/span><span class=\"f_BodyTextFirstIndent2\">&quot;foo12345&quot; (contains &quot;foo&quot;)<\/span><\/p>\n\r<\/td>\n\r<td style=\"vertical-align:top; width:32.7500rem; padding:0; border:none\"><p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">Source <\/span><span class=\"f_BodyTextFirstIndent2\">– &quot;Foo12345&quot; (contains &quot;Foo&quot; instead of &quot;foo&quot;)<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr>\n\r<td style=\"vertical-align:top; width:28.0625rem; padding:0; border:none\"><p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">Caption <\/span><span class=\"f_BodyTextFirstIndent2\">– &quot;bartender&quot; (contains &quot;bar&quot;)<\/span><\/p>\n\r<\/td>\n\r<td style=\"vertical-align:top; width:32.7500rem; padding:0; border:none\"><p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">Caption <\/span><span class=\"f_BodyTextFirstIndent2\">– &quot;batender&quot; (does not contain &quot;bar&quot;)<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr>\n\r<td style=\"vertical-align:top; width:28.0625rem; padding:0; border:none\"><p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">Description <\/span><span class=\"f_BodyTextFirstIndent2\">– (empty string means all values match)<\/span><\/p>\n\r<\/td>\n\r<td style=\"vertical-align:top; width:32.7500rem; padding:0; border:none\"><p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">Description <\/span><span class=\"f_BodyTextFirstIndent2\">– &quot;Lorem ipsum dolor sit amet&quot; (empty string means all values match).<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"font-weight: bold;\">Advanced Parameters<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Omit Logging <\/span><span class=\"f_BodyTextIndent\">– When checked, the generic event will not be added to the Event log. This option allows an action that is trigger in rapid succession or with a very high frequency to be performed without a database call or database storage that would cause undesirable &quot;spamming&quot; of the Event Log. (Note that even if the &quot;Omit logging&quot; checkbox is enabled, a Generic event with a &quot;Write to log&quot; Action will still appear in the Event Log).<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\"><a href=\"setting_up_schedule_for_tracki.html\" class=\"topiclink\">Event Scheduling<\/a><\/span><\/p><p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"font-weight: bold;\">Why Event may work incorrectly<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyText\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\">HTTP request is not correctly written. Refer to the server <\/span><span class=\"f_BodyText\">API.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyText\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyText\">Request is filtered out. Try clearing all fields (<\/span><span class=\"f_BodyTextIndent\">Source, Caption, Description) and trigger the HTTP request again.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyText\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\">HTTP request<\/span><span class=\"f_BodyText\"> is bound to a continuous type of action but does not<\/span><span class=\"f_BodyTextIndent\"> contain <\/span><span class=\"f_BodyText\">the &quot;State&quot; field.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyText\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\">A device is not specified yet the event is linked to a notification and the &quot;Force Acknowledgment&quot; option is set.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyText\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\"><a href=\"global_notifications.html\" class=\"topiclink\">Global notification<\/a> for this event is disabled.<\/span><\/p>"
})
