hmLoadTopic({
hmKeywords:"",
hmTitle:"Merging Systems",
hmDescription:"It is possible to merge two Systems of the same type or to merge a Local System to a Cloud System. This is useful, for example, if System A contains several servers and you...",
hmPrevLink:"join_server_from_different_sys.html",
hmNextLink:"backing_up_and_restoring_produ.html",
hmParentLink:"configuring_multi-server_envir.html",
hmBreadCrumbs:"<a href=\"working_with_display_product_n.html\">Working with DW Spectrum<\/a> &gt; <a href=\"configuring_multi-server_envir.html\">Configuring Multi-Server Environment<\/a>",
hmTitlePath:"Working with DW Spectrum > Configuring Multi-Server Environment > Merging Systems",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">Merging Systems<\/span><\/h1>\n\r",
hmBody:"<p style=\"line-height: 1.43;\"><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">It is possible to merge two Systems of the same type or to merge a Local System to a Cloud System. This is useful, for example, if System A contains several servers and you want to join all of them to System B, or when you want to join remote server(s) to a current System. Systems that have one or more servers with the&nbsp;<\/span><span class=\"f_BodyText\">same server ID in<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">&nbsp;common cannot be merged. This happens when DW Spectrum System files are copied over to another server without removing the unique identifiers from the original System.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><img alt=\"!\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/!.png\"\/><span class=\"f_ImageCaption\" style=\"background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold; background-color: #ffffff;\">IMPORTANT:<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">&nbsp;This is a directional operation – you can merge&nbsp;<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">servers from a local System<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">&nbsp;to a Cloud System, but not vice versa.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">Cloud connected Systems can be merged together as long as the same user has the Owner role on both Systems. You cannot initiate a merge for Cloud-connected Systems from the Client, it can only be initiated from the&nbsp;<a href=\"cloudname-portal-interface.html\" class=\"topiclink\">Cloud Portal<\/a>&nbsp;while logged into the Cloud Administrator (Owner) account.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\">See the diagram below for a visual representation of your options when trying to merge two Systems.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><img alt=\"Merge Diagram\" style=\"margin:0;width:52.6875rem;height:33.8750rem;border:none\" src=\".\/images\/hmfile_hash_54be6558.png\"\/><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"background-color: #ffffff; text-decoration: underline;\">To Merge Local Systems<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid; margin: 0.3750rem 0 0.3750rem 0.8125rem;\"><span class=\"f_BodyTextIndent\" style=\"font-style: italic; background-color: #ffffff;\">&nbsp;Desktop Client<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">1.<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">Launch&nbsp;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">DW Spectrum Client and connect to any server in System A.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">2.<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">Right-click on the&nbsp;<\/span><span class=\"f_T_Interface_Elements\" style=\"font-style: normal; background-color: #ffffff;\">System name in the Resource Tree<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">&nbsp;and choose&nbsp;<\/span><span class=\"f_T_Interface_Elements\" style=\"font-style: normal; font-weight: bold; background-color: #ffffff;\">Merge Systems<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">&nbsp;from the&nbsp;<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">context menu.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">3.<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">In the&nbsp;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic; background-color: #ffffff;\">Merge Systems<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">&nbsp;dialog, enter the URL of the server you want to merge (any server in System B or a remote server) in the<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold; background-color: #ffffff;\">&nbsp;Server URL<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">&nbsp;field. You can use the drop-down menu to find Systems in the local network. For a remote server, type&nbsp;<\/span><span class=\"f_T_Value\" style=\"background-color: #ffffff;\">http:\/\/&lt;ip&gt;:&lt;port&gt;<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">, where:<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent3\" style=\"background-color: #ffffff;\">&lt;ip&gt;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">&nbsp;– IP address of server (the current computer should be able to connect to this server)<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 2.0000rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_T_Value\" style=\"background-color: #ffffff;\">&lt;port&gt;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">&nbsp;– network port of server (default&nbsp;<\/span><span class=\"f_T_Value\" style=\"background-color: #ffffff;\">7001<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">).<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">4.<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">Enter the&nbsp;<\/span><span class=\"f_T_Interface_Elements\" style=\"font-style: normal; font-weight: bold; background-color: #ffffff;\">Password<\/span><span class=\"f_T_Interface_Elements\" style=\"background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">to System B (or the remote server) and click<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic; font-weight: bold; background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_T_Interface_Elements\" style=\"font-style: normal; font-weight: bold; background-color: #ffffff;\">Check<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">5.<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">Select the system that the others will merge into:&nbsp;<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">System A – System B will be merged to System A<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"background-color: #ffffff;\">System B – System A will be merged to System B<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">6.<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">Click&nbsp;<\/span><span class=\"f_T_Interface_Elements\" style=\"font-style: normal; font-weight: bold; background-color: #ffffff;\">Merge with &lt;System Name&gt;<\/span><span class=\"f_T_Interface_Elements\" style=\"background-color: #ffffff;\">.<\/span><\/p><p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Web Admin<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">1.<\/span><span class=\"f_BodyTextFirstIndent2\">Open a web browser and enter the following address: <a href=\"http:\/\/%3Cip%3E:%3Cport%3E\" target=\"_blank\" class=\"weblink\" style=\"font-style: normal; font-weight: normal; color: #000000; background-color: transparent; text-decoration: none;\">http:\/\/&lt;ip&gt;:&lt;port&gt;<\/a><\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 3.2500rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\">&lt;ip&gt; – IP address of server (the current computer should be able to connect to this server)<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 3.2500rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\">&lt;port&gt; – network port of server (default 7001).<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">2.<\/span><span class=\"f_BodyTextIndent\">Log in with your username and password. <\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">3.<\/span><span class=\"f_BodyTextIndent\">Go to the <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">System<\/span><span class=\"f_BodyTextIndent\"> tab and click Merge Systems.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">4.<\/span><span class=\"f_BodyTextIndent\">Choose a System from the drop down or enter the target System\'s information and click <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">Find System<\/span><span class=\"f_BodyTextIndent\">.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 3.2500rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\">Other System URL (<a href=\"<server_ip>:<server_port>)\" target=\"_blank\" class=\"weblink\" style=\"font-style: normal; font-weight: normal; color: #000000; background-color: transparent; text-decoration: none;\">&lt;server_ip&gt;:&lt;server_port&gt;)<\/a><\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 3.2500rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\">Other System Login<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 3.2500rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\">Other System Password<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">5.<\/span><span class=\"f_BodyTextIndent\">Fill in the Current Password (for this System) field.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">6.<\/span><span class=\"f_BodyTextIndent\">Select which System\'s name and administrator password will be kept.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">7.<\/span><span class=\"f_BodyTextIndent\">Click<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\"> Merge with &lt;System Name&gt;<\/span><span class=\"f_BodyTextIndent\">.<\/span><\/p><p class=\"p_BodyTextIndent\"><img alt=\"!\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/!.png\"\/><span class=\"f_ImageCaption\" style=\"background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold; background-color: #ffffff;\">IMPORTANT:<\/span><span class=\"f_BodyTextIndent\" style=\"background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">DW Spectrum creates a System database backup automatically before merging Systems. See &quot;<a href=\"backing_up_and_restoring_produ.html\" class=\"topiclink\">Backing up and Restoring the System Database<\/a>&quot;.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"text-decoration: underline;\">To Merge Cloud Systems<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\"><a href=\"cloudname-portal-interface.html\" class=\"topiclink\">Cloud Portal<\/a><\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">1.<\/span><span class=\"f_BodyTextFirstIndent2\">Open DW Cloud<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">2.<\/span><span class=\"f_BodyTextIndent\">Click on the System you want to start the merge with. You will be taken to that System\'s page.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">3.<\/span><span class=\"f_BodyTextIndent\">Click on <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">Merge with Another System<\/span><span class=\"f_BodyTextIndent\">.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">4.<\/span><span class=\"f_BodyTextIndent\">Choose the System you want to merge with from the drop down menu or manually enter the server information and click <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">Next<\/span><span class=\"f_BodyTextIndent\">.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">5.<\/span><span class=\"f_BodyTextIndent\">Select which System\'s name and settings will be kept and click <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">Next<\/span><span class=\"f_BodyTextIndent\">.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">6.<\/span><span class=\"f_BodyTextIndent\">Enter the Cloud account password and click <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">Merge Systems<\/span><span class=\"f_BodyTextIndent\">.<\/span><\/p><p class=\"p_BodyText\" style=\"page-break-inside: avoid; margin: 0.3750rem 0 0.3750rem 0.8125rem;\"><span class=\"f_BodyText\" style=\"font-style: italic;\">Desktop Client<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\"><span class=\"f_BodyTextFirstIndent2\">See &quot;To merge Local Systems&quot;.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid; margin: 0.3750rem 0 0.3750rem 0.8125rem;\"><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Web Admin<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\"><span class=\"f_BodyTextFirstIndent2\">See &quot;To merge Local Systems&quot;.<\/span><\/p>\n\r"
})
