hmLoadTopic({
hmKeywords:"",
hmTitle:"Do HTTP Request",
hmDescription:"Sends an HTTP\/HTTPS request to a targeted external device or system (floodlight switch, access control trigger, alarm system) which can then be used in those devices or systems...",
hmPrevLink:"start_recording_on_camera.html",
hmNextLink:"execute_ptz_preset.html",
hmParentLink:"actions_that_vms_can_.html",
hmBreadCrumbs:"<a href=\"working_with_display_product_n.html\">Working with DW Spectrum<\/a> &gt; <a href=\"configuring_events_and_actions.html\">Event Rules<\/a> &gt; <a href=\"actions_that_vms_can_.html\">Available Actions<\/a>",
hmTitlePath:"Working with DW Spectrum > Event Rules > Available Actions > Do HTTP Request",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">Do HTTP Request<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\">Sends an <\/span><span class=\"f_BodyText\">HTTP\/HTTPS request<\/span><span class=\"f_BodyText\"> to a targeted external device or system (floodlight switch, access control trigger, alarm system) which can then be used in those devices or systems to trigger additional actions. The request must follow the proper format in order to be read by the receiving device. HTTPS URLs are supported.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\">This action generates an HTTP GET, POST, PUT, or DELETE request in response to any event triggered in DW Spectrum. Together with the &quot;<a href=\"generic_event.html\" class=\"topiclink\">Generic Event<\/a>&quot;, which can receive an HTTP request as an event, you can create bidirectional API communication between DW Spectrum and other software systems. <\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\">For example, a manufacturer has a restricted area with an ACS card reader at the entry point and cameras that monitor the area surrounding the entry point. DW Spectrum has a standard rule to send a notification when abnormal duration motion is detected in the entry area. If someone tampers with the card reader in an unauthorized attempt to enter the restricted area, DW Spectrum triggers one action to notify the surveillance center that motion is detected in the area, and a second HTTP request action to the manufacturer\'s call center server, which in turn runs a security procedure to activate an alarm and generate a phone call to factory floor security personnel.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"font-weight: bold;\">Example<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">http:\/\/123.12.8.1:7001\/api.clickandcall.com\/http\/<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">sendmsg<\/span><span class=\"f_BodyTextIndent\">?<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">user<\/span><span class=\"f_BodyTextIndent\">=VMSuser&amp;password=123456&amp;<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">api_id<\/span><span class=\"f_BodyTextIndent\">=3612726\$MO=1&amp;<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">from<\/span><span class=\"f_BodyTextIndent\">-13234567890&amp;<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">to<\/span><span class=\"f_BodyTextIndent\">=18184493546\$<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">text<\/span><span class=\"f_BodyTextIndent\">=Visitor+is+outside+front+door.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">This example sends an API request to the clickandcall system to send an SMS message to the phone number you specify. It could be coupled, for example, with a generic event that can trigger a 3rd party device to unlock the front door.<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">sendmsg<\/span><span class=\"f_BodyTextFirstIndent2\"> – Sends data to a server at IP Address 123.12.8.1 port 7001<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">user and password<\/span><span class=\"f_BodyTextFirstIndent2\"> – credentials required by the receiver to allow the request access to their system.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.0625rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">api_id<\/span><span class=\"f_BodyTextIndent\"> – <\/span><span class=\"f_BodyTextFirstIndent2\">required account number with receiving entity.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.0625rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">from<\/span><span class=\"f_BodyTextIndent\"> – <\/span><span class=\"f_BodyTextFirstIndent2\">phone number from which the message will be sent.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.0625rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">to<\/span><span class=\"f_BodyTextIndent\"> – <\/span><span class=\"f_BodyTextFirstIndent2\">phone number to which the message is sent.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.0625rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">text<\/span><span class=\"f_BodyTextIndent\"> – the message text, in this case &quot;Visitor is outside front door&quot;.<\/span><\/p><p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"font-weight: bold;\">Basic Parameters<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Interval of action<\/span><span class=\"f_BodyTextIndent\"> <\/span><span class=\"f_BodyTextFirstIndent2\">– Check this box to aggregate the number of times the action will be triggered. Enter an integer and select a time interval from the menu (<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">seconds<\/span><span class=\"f_BodyTextFirstIndent2\">, <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">minutes<\/span><span class=\"f_BodyTextFirstIndent2\">, <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">hours<\/span><span class=\"f_BodyTextFirstIndent2\">, or <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">days<\/span><span class=\"f_BodyTextFirstIndent2\">). <\/span><span class=\"f_BodyTextIndent\">Uncheck to trigger the action every time the event occurs.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">HTTP URL<\/span><span class=\"f_BodyTextIndent\"> <\/span><span class=\"f_BodyTextFirstIndent2\">– The HTTP link to the external system that will receive the request. Can also contain the request itself.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">HTTP Content<\/span><span class=\"f_BodyTextIndent\"> <\/span><span class=\"f_BodyTextFirstIndent2\">– The body of the HTTP request, if needed. See &quot;<a href=\"event-field-placeholders.html\" class=\"topiclink\">Event Field Placeholders<\/a>&quot; for details about the parameters that the appropriate Event data can automatically replace.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Login and Password<\/span><span class=\"f_BodyTextIndent\"> <\/span><span class=\"f_BodyTextFirstIndent2\">– If required by the external system, enter credentials for authentication.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">Content type<\/span><span class=\"f_BodyTextIndent\"> <\/span><span class=\"f_BodyTextFirstIndent2\">– Enter the body of the request. Select one of the following content <\/span><span class=\"f_BodyTextFirstIndent2\">format types according to the requirements of the receiving system<\/span><span class=\"f_BodyTextFirstIndent2\">:<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">Auto<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">text\/plain<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">text\/html<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">application\/html<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">application\/json<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">application\/xml<\/span><\/p><p class=\"p_BodyTextFirstIndent2\"><img alt=\"note\" style=\"margin:0;width:1.1875rem;height:1.1875rem;border:none\" src=\".\/images\/note.png\"\/><span class=\"f_ImageCaption\" style=\"font-size: 1.10rem; font-family: Calibri,Vectora,\'Droid Sans\',\'Open Sans\',Frutiger,sans-serif;\"> <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">Note<\/span><span class=\"f_BodyTextFirstIndent2\">: Auto selects the best format based on<\/span><span class=\"f_BodyText\"> your entry.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyText\" style=\"font-style: italic;\">Authentication type<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic; font-weight: bold;\"> <\/span><span class=\"f_BodyTextFirstIndent2\">– Level of authentication required (<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">Auto <\/span><span class=\"f_BodyTextFirstIndent2\">or<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\"> Basic<\/span><span class=\"f_BodyTextFirstIndent2\">).<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyText\" style=\"font-style: italic;\">Request type<\/span><span class=\"f_BodyTextIndent\"> <\/span><span class=\"f_BodyTextFirstIndent2\">– Type of request. Select one of the following request types:<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">Auto<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">GET<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">POST<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">PUT<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\">DELETE<\/span><\/p><p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"font-weight: bold;\">Why Action may work incorrectly<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\">Event<\/span><span class=\"f_BodyTextIndent\"> is not configured properly. <\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\">HTTP request syntax is incorrect or does not meet receiver requirements.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyText\">External system requires authorization and no or incorrect credentials were specified.<\/span><\/p>"
})
