hmLoadTopic({
hmKeywords:"",
hmTitle:"Setting Up Motion Detection",
hmDescription:"The DW Spectrum server is able to perform software motion detection. Motion detection on the software side allows for adaptive scaling, which is dynamic resolution switching...",
hmPrevLink:"setting_up_analog_cameras.html",
hmNextLink:"forcing_software_motion_detect.html",
hmParentLink:"setting_up_cameras_and_devices.html",
hmBreadCrumbs:"<a href=\"working_with_display_product_n.html\">Working with DW Spectrum<\/a> &gt; <a href=\"configuring_cameras.html\">Device Management<\/a> &gt; <a href=\"setting_up_cameras_and_devices.html\">Setting Up Cameras and Devices<\/a>",
hmTitlePath:"Working with DW Spectrum > Device Management > Setting Up Cameras and Devices > Setting Up Motion Detection",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">Setting Up Motion Detection<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\">The DW Spectrum server<\/span><span class=\"f_BodyText\"> is able to perform software motion detection<\/span><span class=\"f_BodyText\">. Motion detection<\/span><span class=\"f_BodyText\"> on the software side allows for adaptive scaling, which is dynamic resolution switching that yields bandwidth savings and optimizes the processor load. <\/span><span class=\"f_BodyText\">By default, the secondary stream will only be used for motion detection if its resolution is less than 1024x728.<\/span><span class=\"f_BodyText\"> If the secondary stream resolution is higher than this, the primary stream will be checked and used if its resolution is 1024x728 or less. If the primary stream\'s resolution is higher, then no motion detection will be enabled.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><img alt=\"!\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/!.png\"\/><span class=\"f_ImageCaption\" style=\"font-size: 1.10rem; font-family: Calibri,Vectora,\'Droid Sans\',\'Open Sans\',Frutiger,sans-serif;\"> <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">IMPORTANT:<\/span><span class=\"f_BodyTextFirstIndent2\"> If the secondary <\/span><span class=\"f_BodyTextFirstIndent2\">stream is high-resolution, motion <\/span><span class=\"f_BodyTextFirstIndent2\">decoding<\/span><span class=\"f_BodyTextFirstIndent2\"> may consume most or all of the server CPU. See &quot;<a href=\"forcing_software_motion_detect.html\" class=\"topiclink\">Forcing Motion Detection to a Specific Stream<\/a>&quot; to adjust for this issue.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\">Software-side detection also makes it possible to define regions in which motion detection is performed, with a range of sensitivity levels that include complete<\/span><span class=\"f_BodyText\"> <\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\">motion masking<\/span><span class=\"f_BodyText\">, <\/span><span class=\"f_BodyText\">where motion detection is blocked. <\/span><span class=\"f_BodyText\">For cameras that perform in-device motion detection, DW Spectrum does not implement software motion detection. <\/span><span class=\"f_BodyTextIndent\">With such <\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\">hardware motion detection<\/span><span class=\"f_BodyText\">,<\/span><span class=\"f_BodyText\"> <\/span><span class=\"f_BodyTextIndent\">a motion mask can be applied, but no other sensitivity levels are available. In some cases it may be possible to use the <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">Camera Settings<\/span><span class=\"f_BodyTextIndent\"> &gt; <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">General<\/span><span class=\"f_BodyTextIndent\"> tab to instead configure device parameters<\/span><span class=\"f_BodyTextIndent\"> (<\/span><span class=\"f_BodyTextIndent\">see &quot;<a href=\"configuring_proprietary_camera_parameters.html\" class=\"topiclink\">Configuring Device Using DW Spectrum Client<\/a>&quot;).<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><img alt=\"note\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/note.png\"\/><span class=\"f_ImageCaption\"> <\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\">Note<\/span><span class=\"f_BodyText\">: <\/span><span class=\"f_BodyTextIndent\">Arecont Vision devices are set to<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\"> <\/span><span class=\"f_BodyTextIndent\">hardware detection mode automatically.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><a id=\"motiondetectionindicators\" class=\"hmanchor\"><\/a><span class=\"f_BodyText\" style=\"text-decoration: underline;\">Motion Detection Indicators<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">DW Spectrum provides motion detection indicators in the form of a temporary red outline on grid cells when motion is detected. This feature is especially useful for highlighting motion that is easily detected by cameras but often filtered out by humans – for example, trees moving in the wind, the motion of shadows, sudden changes in light level, etc.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><a id=\"motion\" class=\"hmanchor\"><\/a><span class=\"f_BodyText\" style=\"text-decoration: underline;\">To Configure Motion Detection<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">1.<\/span><span class=\"f_BodyTextIndent\">Do one of the following:<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_ListBullet2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent3\" style=\"font-style: italic;\">Desktop Client<\/span><span class=\"f_BodyTextFirstIndent3\" style=\"font-style: italic; font-weight: bold;\">:<\/span><span class=\"f_BodyTextFirstIndent3\" style=\"font-weight: bold;\"> <\/span><span class=\"f_BodyTextFirstIndent3\">Open <\/span><span class=\"f_BodyTextFirstIndent3\" style=\"font-weight: bold;\">Camera Settings<\/span><span class=\"f_BodyTextFirstIndent3\"> and go to the <\/span><span class=\"f_BodyTextFirstIndent3\" style=\"font-weight: bold;\">Motion<\/span><span class=\"f_BodyTextFirstIndent3\"> tab, then c<\/span><span class=\"f_ListBullet2\">lick the <\/span><span class=\"f_ListBullet2\" style=\"font-weight: bold;\">Motion Detection<\/span><span class=\"f_ListBullet2\"> button to enable detection (green) for the device.<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent3\" style=\"font-style: italic;\"><a href=\"connecting_to_vms_thr.html\" class=\"topiclink\">Web Admin<\/a><\/span><span class=\"f_BodyTextFirstIndent3\" style=\"font-style: italic; font-weight: bold;\"> <\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">\/ <a href=\"cloudname-portal-interface.html\" class=\"topiclink\">Cloud Portal<\/a><\/span><span class=\"f_BodyTextFirstIndent3\" style=\"font-style: italic; font-weight: bold;\">:<\/span><span class=\"f_BodyTextFirstIndent3\" style=\"font-weight: bold;\"> <\/span><span class=\"f_BodyTextIndent\">Open <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">Settings<\/span><span class=\"f_BodyTextIndent\"> &gt; <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">Cameras <\/span><span class=\"f_BodyTextIndent\">and select a camera and Click the <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">Enable motion detection<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\"> <\/span><span class=\"f_BodyTextIndent\">button.<\/span><\/p><p class=\"p_BodyTextFirstIndent2\"><img alt=\"!\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/!.png\"\/><span class=\"f_ImageCaption\" style=\"font-size: 1.10rem; font-family: Calibri,Vectora,\'Droid Sans\',\'Open Sans\',Frutiger,sans-serif;\"> <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">IMPORTANT:<\/span><span class=\"f_BodyTextFirstIndent2\"> <\/span><span class=\"f_BodyTextFirstIndent2\">Cells in the motion detection grid are briefly highlighted in red when <\/span><span class=\"f_BodyTextFirstIndent2\">motion is <\/span><span class=\"f_BodyTextFirstIndent2\">detected. The brighter these red indicators, the higher the level of motion.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">2.<\/span><span class=\"f_BodyTextIndent\">Click on a number in the <\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Sensitivity<\/span><span class=\"f_BodyTextIndent\"> section, where <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">0<\/span><span class=\"f_BodyTextIndent\"> is no sensitivity to motion (motion mask), <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">1<\/span><span class=\"f_BodyTextIndent\"> is minimal sensitivity, and <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">9<\/span><span class=\"f_BodyTextIndent\"> is maximum sensitivity.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">3.<\/span><span class=\"f_BodyTextIndent\">The motion detection grid is 42 x 32 cells. Use the following actions to apply the selected sensitivity to cells:<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent3\">Click and Drag to select a rectangular area.<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 2.0000rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\">Click on a cell (the entire area that the cell is associated with will be filled, not just the individual cell).<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">4.<\/span><span class=\"f_BodyTextIndent\">The sensitivity level remains active until a new one is selected. Continue to select and apply sensitivity levels as desired. If necessary, you can use <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">Clear Selection<\/span><span class=\"f_BodyTextIndent\"> to return the entire field to the default level of 5.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">5.<\/span><span class=\"f_BodyTextIndent\">Apply changes.<\/span><\/p><p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"text-decoration: underline;\">For Example<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><img alt=\"Setting up Motion Mask and Motion Sensitivity - 3\" style=\"margin:0;width:31.3750rem;height:17.8125rem;border:none\" src=\".\/images\/hmfile_hash_9a8aabbf.jpg\"\/><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">The above image contains the following motion detection regions:<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\">Grey (un-numbered) is <\/span><span class=\"f_BodyTextFirstIndent2\">motion mask<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\">Blue (<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">1<\/span><span class=\"f_BodyTextFirstIndent2\">) has very low sensitivity to motion<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\">Green (<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">5<\/span><span class=\"f_BodyTextFirstIndent2\">) will capture motion with moderate sensitivity (5 is the default setting)<\/span><\/p><p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\">Orange (<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">7<\/span><span class=\"f_BodyTextFirstIndent2\">) will be highly sensitive to motion, red (<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">9<\/span><span class=\"f_BodyTextFirstIndent2\">) offers the maximum sensitivity<\/span><\/p><p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">You can also see some of the red motion indicators on the left side of the image.<\/span><\/p>\n\r"
})
