hmLoadTopic({
hmKeywords:"",
hmTitle:"Using Encryption for System Security",
hmDescription:"DW Spectrum provides HTTPS encryption for client-server data exchange and, separately, for RTSP video traffic streams. ",
hmPrevLink:"",
hmNextLink:"",
hmParentLink:"troubleshooting_and_contacting_support.html",
hmBreadCrumbs:"",
hmTitlePath:"Working with DW Spectrum > Contacting Support > Sending Anonymous Usage and Crash Statistics",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">Using Encryption for System Security<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\">DW Spectrum provides HTTPS encryption for <\/span><span class=\"f_BodyTextIndent\">client-server data exchange <\/span><span class=\"f_BodyText\">and, separately, for RTSP video traffic streams. <\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\">HyperText Transfer Protocol (<\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\">HTTP<\/span><span class=\"f_BodyText\">) is a universally agreed upon convention for network information exchange that is easy to intercept and read. HyperText Transfer Protocol <\/span><span class=\"f_BodyText\" style=\"text-decoration: underline;\">Secure<\/span><span class=\"f_BodyText\"> (<\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\">HTTP<\/span><span class=\"f_BodyText\" style=\"font-weight: bold; text-decoration: underline;\">S<\/span><span class=\"f_BodyText\">) is a safer connection that includes encryption to protect the information exchanged over networks. The encryption is performed using a Secure Sockets Layer (SSL) or TLS (Transport Layer Security) certificate. When an SSL\/TLS certificate is issued it means the sending and receiving websites have been authenticated, and a secure connection has been established between the web server and the browser that connects to it. When you have a secure connection, the website\'s URL is prefixed with &quot;https&quot; instead of &quot;http,&quot; and a padlock icon will display on the address bar.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\">By default, DW Spectrum encryption is disabled. Without encryption, API requests and the server web administration interface can be intercepted and analyzed, and video streams (live and playback) can be intercepted and viewed.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\">The<\/span><span class=\"f_BodyText\"> <\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\">Allow only secure connections<\/span><span class=\"f_BodyText\"> <\/span><span class=\"f_BodyTextFirstIndent2\">checkbox<\/span><span class=\"f_BodyText\"> forces all servers in the System to accept only secure HTTPS connections. When it is enabled, you have the option to also force video traffic encryption.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\">The <\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\">Encrypt video traffic<\/span><span class=\"f_BodyText\"> <\/span><span class=\"f_BodyTextFirstIndent2\">checkbox <\/span><span class=\"f_BodyText\">applies encryption to RTSP\/S format, HLS format, and requests that start with a \/media prefix. Note that encrypted video transfer requires intensive CPU processing, so overall system performance can be severely impacted, particularly on smaller or weaker hardware such as ARM devices.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><img alt=\"!\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/!.png\"\/><span class=\"f_BodyTextFirstIndent2\"> <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">Important!<\/span><span class=\"f_BodyTextFirstIndent2\"> <\/span><span class=\"f_BodyText\">Due to self-signed certificates, explicit HTTP integrations, or other configuration settings, all integrations configured to work with HTTP need to be tested, and may need to be updated for compatibility with this feature. For example, you will need to disable HTTPS support in order to merge a secured System with one that does only supports HTTP. Similarly, some third-party products may not support RTSPS and may therefore cause integration issues.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"text-decoration: underline;\">To enable HTTPS encrypted client-server connections<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">1.<\/span><span class=\"f_BodyTextIndent\">Open <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">Main Menu<\/span><span class=\"f_BodyTextIndent\"> –&gt; <\/span><span class=\"f_T_Interface_Elements\" style=\"font-style: normal; font-weight: bold;\">System Administration<\/span><span class=\"f_T_Interface_Elements\"> <\/span><span class=\"f_BodyTextIndent\">(shortcut <\/span><span class=\"f_T_Hotkey\" style=\"font-style: normal;\">Ctrl<\/span><span class=\"f_T_Hotkey\" style=\"font-style: normal; font-weight: normal;\">+<\/span><span class=\"f_T_Hotkey\" style=\"font-style: normal;\">Alt<\/span><span class=\"f_T_Hotkey\" style=\"font-style: normal; font-weight: normal;\">+<\/span><span class=\"f_T_Hotkey\" style=\"font-style: normal;\">A<\/span><span class=\"f_BodyTextIndent\">)<\/span><span class=\"f_BodyTextIndent\">.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">2.<\/span><span class=\"f_BodyText\">In the <\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\">General<\/span><span class=\"f_BodyText\"> tab, check the <\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\">Allow only secure connections<\/span><span class=\"f_BodyText\"> <\/span><span class=\"f_BodyTextFirstIndent2\">checkbox<\/span><span class=\"f_BodyTextFirstIndent2\">.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">3.<\/span><span class=\"f_BodyText\">Once HTTPS is enabled, the first time you attempt to log onto a server\'s web page, the browser may first display warnings that indicate a<\/span><span class=\"f_BodyText\"> bad certificate and insecure connection (&quot;Your connection is not private. Attackers might be trying to steal your information...&quot;). This is not the case. The warning is a safety feature due to a self-signed certificate on the server, the connection will in fact be more secure.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">4.<\/span><span class=\"f_BodyText\">To proceed using an HTTPS connection, click on the word <\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\">Advanced<\/span><span class=\"f_BodyText\">, then click the <\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\">Proceed to [xxx.x.x.x] (unsafe)<\/span><span class=\"f_BodyText\"> link to log in. You should only need to do this the first time the HTTPS connection is established.<\/span><\/p><p class=\"p_BodyTextFirstIndent2\"><img alt=\"note\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/note.png\"\/><span class=\"f_BodyTextFirstIndent2\"> <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">Note<\/span><span class=\"f_BodyTextFirstIndent2\"> Although it may have a line through it, as long as https is displayed in the address bar, the connection is secure.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"text-decoration: underline;\">To enable RTSPS encrypted video traffic<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">1.<\/span><span class=\"f_BodyTextIndent\">Open <\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\">Main Menu<\/span><span class=\"f_BodyTextIndent\"> –&gt; <\/span><span class=\"f_T_Interface_Elements\" style=\"font-style: normal; font-weight: bold;\">System Administration<\/span><span class=\"f_T_Interface_Elements\"> <\/span><span class=\"f_BodyTextIndent\">(shortcut <\/span><span class=\"f_T_Hotkey\" style=\"font-style: normal;\">Ctrl<\/span><span class=\"f_T_Hotkey\" style=\"font-style: normal; font-weight: normal;\">+<\/span><span class=\"f_T_Hotkey\" style=\"font-style: normal;\">Alt<\/span><span class=\"f_T_Hotkey\" style=\"font-style: normal; font-weight: normal;\">+<\/span><span class=\"f_T_Hotkey\" style=\"font-style: normal;\">A<\/span><span class=\"f_BodyTextIndent\">)<\/span><span class=\"f_BodyTextIndent\">.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">2.<\/span><span class=\"f_BodyText\">In the <\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\">General<\/span><span class=\"f_BodyText\"> tab, check the <\/span><span class=\"f_BodyText\" style=\"font-weight: bold;\">Encrypt video traffic<\/span><span class=\"f_BodyText\"> <\/span><span class=\"f_BodyTextFirstIndent2\">checkbox<\/span><span class=\"f_BodyTextFirstIndent2\">.<\/span><\/p><p class=\"p_BodyTextFirstIndent2\"><img alt=\"!\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/!.png\"\/><span class=\"f_BodyTextFirstIndent2\"> <\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-weight: bold;\">Important!<\/span><span class=\"f_BodyTextFirstIndent2\"> Encrypting video traffic will significantly increase CPU and bandwidth usage because data packets must be encrypted by the server and decrypted by the client.<\/span><\/p>\n\r"
})
