hmLoadTopic({
hmKeywords:"",
hmTitle:"Working with DW Spectrum",
hmDescription:"The below diagrams illustrate how the DW Spectrum components work together in a System. The following icons are used:",
hmPrevLink:"",
hmNextLink:"launching_and_closing_vms_client.html",
hmParentLink:"index.html",
hmBreadCrumbs:"",
hmTitlePath:"Working with DW Spectrum",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">Working with DW Spectrum<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\">The below diagrams illustrate how the DW Spectrum components work together in a System. The following icons are used:<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><img alt=\"system\" style=\"margin:0;width:1.2500rem;height:1.2500rem;border:none\" src=\".\/images\/system.png\"\/><span class=\"f_BodyTextIndent\"> System<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><img alt=\"user\" style=\"margin:0;width:1.2500rem;height:1.2500rem;border:none\" src=\".\/images\/user.png\"\/><span class=\"f_BodyTextIndent\"> User<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><img alt=\"server\" style=\"margin:0;width:1.2500rem;height:1.2500rem;border:none\" src=\".\/images\/server.png\"\/><span class=\"f_BodyTextIndent\"> Server<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><img alt=\"camera\" style=\"margin:0;width:1.2500rem;height:1.2500rem;border:none\" src=\".\/images\/camera.png\"\/><span class=\"f_BodyTextIndent\"> Camera<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><img alt=\"client\" style=\"margin:0;width:1.2500rem;height:1.2500rem;border:none\" src=\".\/images\/client.png\"\/><span class=\"f_BodyTextIndent\"> Client<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><img alt=\"cloud_20_disabled\" style=\"margin:0;width:1.1250rem;height:0.7500rem;border:none\" src=\".\/images\/cloud_20_disabled.png\"\/><span class=\"f_BodyTextIndent\"> Cloud<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"text-decoration: underline;\">System<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">DW Spectrum has a unique Client-Server hive architecture where the servers discover devices and manage system users and data together. <\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">A System is made up of one or more servers, their connected streaming devices (IP Cameras, I\/O devices), streams ( RTSP, HTTP, UDP), storage (HDDs, NAS, DAS, etc), and connected Desktop, Mobile, or Web client applications. Multiple servers can be tied together as a System – for example when there are several locations with cameras, or if the total number of cameras is too large to process with just one computer, or in order to improve system stability. The maximum recommended number of servers per system is 100 and the maximum recommended number of resources (Cameras, NVR channels, I\/O modules, etc.) per system is 10,000 (if a user reaches 100 servers in a system, the maximum recommended number of cameras per server is reduced to 100).<\/span><\/p>\n\r<div style=\"text-align: left; text-indent: 0; line-height: 1.38; padding: 0 0 0 0; margin: 0.1250rem 0 0.1250rem 0.8750rem;\"><table style=\"border:solid 0.1250rem #000000; border-spacing:0; border-collapse:collapse;\">\n\r<tr>\n\r<td style=\"vertical-align:top; width:20.8125rem; padding:0; border:solid thin #000000;\"><p class=\"p_BodyText\" style=\"text-align: center; page-break-inside: avoid;\"><span class=\"f_BodyText\">A System can have just one server<\/span><\/p>\n\r<\/td>\n\r<td style=\"vertical-align:top; width:27.3750rem; padding:0; border:solid thin #000000;\"><p class=\"p_BodyText\" style=\"text-align: center; page-break-inside: avoid;\"><span class=\"f_BodyText\">A System can have several servers<\/span><\/p>\n\r<\/td>\n\r<td style=\"vertical-align:top; width:16.7500rem; padding:0; border:solid thin #000000;\"><p class=\"p_BodyText\" style=\"text-align: center; page-break-inside: avoid;\"><span class=\"f_BodyText\">A server by itself is a System<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr>\n\r<td style=\"vertical-align:bottom; width:20.8125rem; padding:0; border:solid thin #000000;\"><p class=\"p_BodyText\" style=\"text-align: center; page-break-inside: avoid;\"><img alt=\"Working with DISPLAY.PRODUCT.NAME - 2\" style=\"margin:0 auto 0 auto;width:11.8750rem;height:10.6250rem;border:none\" src=\".\/images\/hmfile_hash_96a6cb03.png\"\/><\/p>\n\r<\/td>\n\r<td style=\"vertical-align:bottom; width:27.3750rem; padding:0; border:solid thin #000000;\"><p class=\"p_BodyText\" style=\"text-align: center; page-break-inside: avoid;\"><img alt=\"Working with DISPLAY.PRODUCT.NAME - 1\" style=\"margin:0 auto 0 auto;width:18.7500rem;height:10.6250rem;border:none\" src=\".\/images\/hmfile_hash_97ea65ad.png\"\/><\/p>\n\r<\/td>\n\r<td style=\"vertical-align:bottom; width:16.7500rem; padding:0; border:solid thin #000000;\"><p class=\"p_BodyText\" style=\"text-align: center; page-break-inside: avoid;\"><img alt=\"Working with DISPLAY.PRODUCT.NAME - 3\" style=\"margin:0 auto 0 auto;width:6.8750rem;height:6.8750rem;border:none\" src=\".\/images\/hmfile_hash_86bf2390.png\"\/><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">If there is only one server, there is little difference between the server and the System, and they can be considered equivalent. However, with more servers in a System the differences will become significant.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">All servers in a System are equal and each of them has all the information about all cameras, users, and settings in the System. Video archive, however, is not shared. Recorded video is stored only on the server to which a camera is connected. <\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">Therefore, if you replace one server in the System with a new one (e.g., for an update or repair), all System settings will be retained – but the video archive recorded on the old server is not.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"text-decoration: underline;\">Users<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">Every System has a list of user accounts that are allowed access. To log in to a System you must be an authorized user. Every System has a special Administrator user account with <\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Owner<\/span><span class=\"f_BodyTextIndent\"> rights. <\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Administrator<\/span><span class=\"f_BodyTextIndent\"> rights can be granted to other users only by the Owner of a System.<\/span><span class=\"f_BodyTextIndent\"> Users can be added to or deleted from the System by<\/span><span class=\"f_BodyTextIndent\"> the Owner or other <\/span><span class=\"f_BodyTextIndent\">Administrators<\/span><span class=\"f_BodyTextIndent\">. A <\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Cloud<\/span><span class=\"f_BodyTextIndent\"> user has access to all servers that are connected to<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\"> DW Cloud<\/span><span class=\"f_BodyTextIndent\" style=\"font-weight: bold;\"> <\/span><span class=\"f_BodyTextIndent\">(see <a href=\"connecting_system_to_cloud.html\" class=\"topiclink\">Connecting System to DW Cloud)<\/a>.<\/span><span class=\"f_BodyTextIndent\"> An <\/span><span class=\"f_BodyTextIndent\">Administr<\/span><span class=\"f_BodyTextIndent\">ator can specify every parameter of a new user (name, password, email, etc.), and can manage these parameters in the future. Each user can have different rights within the System. For example, a user account with limited access rights might not be able to see specific servers or resources on those servers, but would still be able to connect to those servers.<\/span><\/p>\n\r<div style=\"text-align: left; text-indent: 0; line-height: 1.38; padding: 0 0 0 0; margin: 0.1250rem 0 0.1250rem 0.8750rem;\"><table style=\"border:solid 0.1250rem #333333; border-spacing:0; border-collapse:collapse;\">\n\r<tr>\n\r<td style=\"vertical-align:middle; width:26.5625rem; padding:0.1875rem; border:solid thin #333333;\"><p class=\"p_BodyText\" style=\"text-align: center; page-break-inside: avoid;\"><span class=\"f_BodyText\">Some users have access to everything in the System and can edit or manage its settings.<\/span><\/p>\n\r<\/td>\n\r<td style=\"vertical-align:middle; width:28.2500rem; padding:0.1875rem; border:solid thin #333333;\"><p class=\"p_BodyText\" style=\"text-align: center; page-break-inside: avoid;\"><span class=\"f_BodyText\">Other users only have access to a few settings or none at all, and can see only certain cameras.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr>\n\r<td style=\"vertical-align:bottom; width:26.5625rem; padding:0.1875rem; border:solid thin #333333;\"><p class=\"p_BodyText\" style=\"text-align: center; page-break-inside: avoid;\"><img alt=\"Working with DISPLAY.PRODUCT.NAME - 6\" style=\"margin:0 auto 0 auto;width:20.4375rem;height:16.8750rem;border:none\" src=\".\/images\/hmfile_hash_6537a1b6.png\"\/><\/p>\n\r<\/td>\n\r<td style=\"vertical-align:bottom; width:28.2500rem; padding:0.1875rem; border:solid thin #333333;\"><p class=\"p_BodyText\" style=\"text-align: center; page-break-inside: avoid;\"><img alt=\"Working with DISPLAY.PRODUCT.NAME - 5\" style=\"margin:0 auto 0 auto;width:21.6875rem;height:16.8750rem;border:none\" src=\".\/images\/hmfile_hash_64ce7e81.png\"\/><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">The term &quot;User&quot; can mean the same thing as the term account, or it can refer to a physical person. A given person can have multiple accounts – for example, different accounts to access different Systems, or different accounts with different access rights to a single System. &quot;User Roles&quot; are used to easily assign the same set of access rights to multiple users. The maximum recommended number of users per system is 1,000.<\/span><\/p>\n\r<p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"text-decoration: underline;\">Server<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">&quot;Server” in this manual can refer to either the server application (called the Media Server) or the computer on which the Media Server application is installed. The maximum recommended number of cameras per server is 128.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">Servers can:<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">1.<\/span><span class=\"f_BodyTextFirstIndent2\">Receive video streams from cameras<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">2.<\/span><span class=\"f_BodyTextIndent\">Manage camera settings<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">3.<\/span><span class=\"f_BodyTextIndent\">Record video from cameras to internal or external storage<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">4.<\/span><span class=\"f_BodyTextIndent\">Process and analyze video – for example, detect motion<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">5.<\/span><span class=\"f_BodyTextIndent\">Manage user database and access levels<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">6.<\/span><span class=\"f_BodyTextIndent\">Track certain events and react to them<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">7.<\/span><span class=\"f_BodyTextIndent\">Work with different hardware devices – for example, NVRs, I\/O modules, or door locks<\/span><\/p><p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><span class=\"f_BodyText\" style=\"text-decoration: underline;\">Client<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">Client applications can connect to servers, and can show live or recorded video from cameras in the System. Clients are also used to manage the System, server, and cameras settings. A client can be connected to different servers, but only to one at a time. However, any number of clients can be connected to one server at any time. If the client is connected to a single server in the System, it has access to the entire System through this server – to all other servers and cameras, System settings, and camera settings.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><img alt=\"Working with DISPLAY.PRODUCT.NAME - 4\" style=\"margin:0;width:18.7500rem;height:12.5000rem;border:none\" src=\".\/images\/hmfile_hash_87873ce8.png\"\/><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">The following Сlient applications allow operators to access and manage their System(s) with an intuitive GUI:<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextFirstIndent2\" style=\"font-style: italic;\"><a href=\"connecting_to_enterprise_contr.html\" class=\"topiclink\">DW Spectrum Desktop<\/a><\/span><span class=\"f_BodyTextFirstIndent2\"> <\/span><span class=\"f_BodyTextIndent\">–<\/span><span class=\"f_BodyTextFirstIndent2\"> <\/span><span class=\"f_BodyTextIndent\">The most powerful Client application. Available on Windows, MacOS and Ubuntu Linux.<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent3\">Connect to any server<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent3\">View live streams<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent3\">Playback recorded video and local video files<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent3\">Playback up to 64 videos simultaneously<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent3\">Advanced camera controls – PTZ, 2-way-audio, I\/O ports, etc.<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent3\">Built-in web browser<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent3\">Manage users, cameras, System, and server settings<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent3\">View event logs and user behavior logs<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.0625rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyText\" style=\"font-style: italic; background-color: #ffffff;\"><a href=\"connecting_to_display_product_.html\" class=\"topiclink\">DW Spectrum<\/a><\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyTextIndent\">–<\/span><span class=\"f_BodyText\" style=\"background-color: #ffffff;\">&nbsp;<\/span><span class=\"f_BodyTextIndent\">Available on Android and iOS.<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent3\">Connect to any server<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent3\">View live streams<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent3\">Playback recorded videos<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent3\">Camera controls – PTZ, 2-way-audio<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent3\">Smart Search<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent3\">Push Notifications<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.0625rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\"><a href=\"connecting_to_vms_thr.html\" class=\"topiclink\">DW Spectrum Server Web Admin<\/a><\/span><span class=\"f_BodyTextIndent\"> <\/span><span class=\"f_BodyTextIndent\">–<\/span><span class=\"f_BodyTextIndent\"> Also called &quot;Web Client&quot;. <\/span><span class=\"f_BodyTextIndent\">Can be opened in any modern web browser.<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent3\">Server specific<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent3\">View live streams<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent3\">Playback recorded videos<\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent3\">Access <a href=\"health-monitoring.html\" class=\"topiclink\">Health Monitoring<\/a><\/span><\/p><p class=\"p_BodyTextFirstIndent3\" style=\"text-indent: 0; page-break-inside: avoid; padding-left: 0.8125rem; margin-left: 3.3125rem;\"><span class=\"f_BodyTextFirstIndent3\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span class=\"f_BodyTextFirstIndent3\">Manage users, cameras, System, and server settings (see <a href=\"connecting_to_vms_thr.html\" class=\"topiclink\">Opening DW Spectrum Web Client<\/a> for details)<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.0625rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\"><a href=\"cloudname-portal-interface.html\" class=\"topiclink\">DW Spectrum Cloud Admin<\/a><\/span><\/p><p class=\"p_BodyText\" style=\"page-break-inside: avoid;\"><a id=\"cloud\" class=\"hmanchor\"><\/a><span class=\"f_BodyText\" style=\"text-decoration: underline;\">DW Cloud<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">An important part of DW Spectrum is DW Cloud. It is a cloud service hosted on the Internet and extends functionality of DW Spectrum Systems.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">In addition to the default functionality, DW Cloud also gives the ability to:<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextIndent\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">1.<\/span><span class=\"f_BodyTextFirstIndent2\">Log in to multiple<\/span><span class=\"f_BodyTextIndent\"> Systems with a single account<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">2.<\/span><span class=\"f_BodyTextIndent\">Connect to servers through the internet even though they don’t have an external IP address<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextIndent\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">3.<\/span><span class=\"f_BodyTextIndent\">Add users to your Systems via an email invite<\/span><\/p><p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">To access Cloud features, a System must be connected to the cloud – which makes it a <\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Cloud System<\/span><span class=\"f_BodyTextIndent\"> (as opposed to a L<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">ocal System<\/span><span class=\"f_BodyTextIndent\">).<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">Create a Cloud account <\/span><span class=\"f_BodyTextIndent\">to<\/span><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\"> <\/span><span class=\"f_BodyTextIndent\">interact with DW Cloud. You can do the following with a Cloud account:<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">1.<\/span><span class=\"f_BodyTextFirstIndent2\">Log in to Cloud systems in the same way as with a regular user account<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">2.<\/span><span class=\"f_BodyTextIndent\">Log in to Cloud systems from desktop and mobile clients<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">3.<\/span><span class=\"f_BodyTextIndent\"><a href=\"connecting_as_cloud_user.html\" class=\"topiclink\">Logging in to DW Cloud<\/a><\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">4.<\/span><span class=\"f_BodyTextIndent\"><a href=\"connecting_system_to_cloud.html\" class=\"topiclink\">Connect your Systems to DW Cloud<\/a><\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">5.<\/span><span class=\"f_BodyTextIndent\">Restore a password using your email address<\/span><\/p><p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">Users with Cloud accounts are also referred to as Cloud <\/span><span class=\"f_BodyTextIndent\">users. Users with regular accounts or local accounts are referred to as Local users.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">Local accounts belong to the System, and cannot be moved elsewhere or used in the different services.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">Cloud accounts do not belong to any System, so System Administrators are not able to create a new account – they can just add an account to their System, and grant some rights to this account. To do that they specify only the account itself – all other parameters, such as name and password, are defined by the Cloud account Owner themselves.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">In the diagram below, users 1–5 are Local user accounts – they exist only in the System databases and are managed by System Administrators. User 6 is a Cloud user – the account is the same for both Systems, and is managed on the Cloud Portal by the Cloud account owner. The System database has<\/span><span class=\"f_BodyText\"> information about this account but cannot manage it.<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\"><img alt=\"Working with DISPLAY.PRODUCT.NAME - 7\" style=\"margin:0;width:26.2500rem;height:14.2500rem;border:none\" src=\".\/images\/hmfile_hash_438c38a1.png\"\/><span class=\"f_ImageCaption\"> <\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\" style=\"font-style: italic;\">To connect a System to<\/span><span class=\"f_BodyText\" style=\"font-style: italic;\"> DW Cloud<\/span><span class=\"f_BodyText\">,<\/span><span class=\"f_BodyTextIndent\"> you must log in to the System using the owner’s account. In the<\/span><span class=\"f_BodyText\"> DW Cloud<\/span><span class=\"f_BodyTextIndent\"> tab of the System Administration dialog, specify the Cloud account that the System will be associated with. This account will also receive Owner’s access permissions and be displayed in the interface as the System Owner.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyText\">After a System is connected to DW Cloud, it has access to all Cloud features, and can be disconnected from DW Cloud at any time. After being disconnected, a System becomes a local System again. The Cloud owner and all other Cloud users will be deleted, but other settings and video archive will not be affected.<\/span><\/p>\n\r<p class=\"p_BodyTextIndent\"><span class=\"f_BodyTextIndent\">Benefits to using the <a href=\"cloudname-portal-interface.html\" class=\"topiclink\">Cloud Portal<\/a>:<\/span><\/p>\n\r<p class=\"p_BodyTextFirstIndent2\" style=\"text-indent: 0; padding-left: 1.2500rem; margin-left: 2.1250rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">1.<\/span><span class=\"f_BodyTextFirstIndent2\">Cloud accounts can be created on the Cloud Portal – a web service which is independent of any System and available to everybody.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">2.<\/span><span class=\"f_BodyTextIndent\">On the Cloud Portal you can see all your Cloud Systems, view video, and edit some of the settings.<\/span><\/p><p class=\"p_BodyTextIndent\" style=\"text-indent: 0; padding-left: 2.5000rem; margin-left: 0.8750rem;\"><span class=\"f_BodyTextFirstIndent2\" style=\"display:inline-block;width:1.2500rem;margin-left:-1.2500rem\">3.<\/span><span class=\"f_BodyText\">You can log in to all Systems associated with your Cloud account from the client Welcome Screens.<\/span><\/p>"
})
