/*
 * Copyright (c) 2018-2022 CTCaer
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <bdk.h>
#include <libs/compr/blz.h>
#include "logos.h"

// 68 x 192 @8bpp Grayscale RAW.
#define BOOTLOGO_WIDTH    68
#define BOOTLOGO_HEIGHT   192
#define BOOTLOGO_X        ((720  - BOOTLOGO_WIDTH)  / 2)
#define BOOTLOGO_Y        ((1280 - BOOTLOGO_HEIGHT) / 2)
#define BOOTLOGO_SIZE     13056
#define BOOTLOGO_BLZ_SIZE 3988

u8 bootlogo_blz[] = {
	0x0F, 0xF0, 0x80, 0x1B, 0x1B, 0x40, 0xF0, 0x1E, 0x1F, 0x48, 0x5A, 0x0F, 0xF0, 0x0F, 0xF0, 0xE4,
	0x17, 0xF0, 0x91, 0x13, 0x26, 0x28, 0x23, 0x1E, 0x0A, 0xA0, 0x0F, 0xF0, 0xC3, 0x22, 0xF0, 0xC3,
	0xA4, 0x1E, 0x29, 0x33, 0xDB, 0x2C, 0xEA, 0x53, 0x83, 0x0F, 0xF0, 0x38, 0xF0, 0xBC, 0x39, 0x21,
	0x22, 0xB0, 0x87, 0x20, 0x2F, 0x27, 0x3E, 0xDB, 0x35, 0x01, 0xA6, 0x69, 0xF2, 0x3C, 0xFD, 0x25,
	0x2D, 0x38, 0x77, 0x28, 0x15, 0x8A, 0x33, 0x45, 0xDB, 0x09, 0xEF, 0xBB, 0x44, 0xD0, 0xC0, 0x18,
	0xEF, 0x2E, 0x3B, 0xF5, 0x32, 0x25, 0x41, 0xC0, 0x83, 0x52, 0xE1, 0x07, 0xCD, 0x08, 0xF4, 0xF5,
	0x3B, 0x61, 0xB2, 0x95, 0xF1, 0x01, 0x10, 0xE7, 0xA3, 0x02, 0x95, 0x91, 0x3C, 0xFD, 0x41, 0x90,
	0x41, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x3D, 0x7F, 0x3D, 0x9B, 0xFA, 0x41, 0xF0, 0x41, 0xF0, 0x0F,
	0xF0, 0x26, 0xF0, 0x41, 0xF0, 0x41, 0xF0, 0xFE, 0x4C, 0xF0, 0x41, 0xF0, 0x41, 0xF0, 0x4D, 0xF5,
	0x95, 0x01, 0x9B, 0x02, 0xCD, 0x5D, 0x41, 0xF0, 0xFF, 0x41, 0xF0, 0x4D, 0xF5, 0x77, 0xC5, 0x18,
	0x93, 0xCD, 0x8D, 0x41, 0xF0, 0x41, 0xF0, 0xEB, 0x4D, 0xF5, 0x69, 0xFB, 0x6C, 0xF4, 0x41, 0xF0,
	0x4D, 0xF5, 0x65, 0x3F, 0x28, 0x01, 0x10, 0xBF, 0x03, 0x30, 0x00, 0x00, 0x2A, 0x2A, 0x2A, 0x30,
	0x45, 0x57, 0x03, 0xE4, 0x03, 0x41, 0xB0, 0xCD, 0xFD, 0x5D, 0x02, 0xCD, 0x1D, 0xC9, 0x1C, 0x2C,
	0x38, 0x3F, 0x3F, 0x01, 0x10, 0x03, 0x30, 0x00, 0x00, 0x41, 0x41, 0x41, 0x48, 0x0E, 0x56, 0x61,
	0xF5, 0x41, 0xED, 0xDF, 0xCD, 0xFD, 0x3D, 0xBB, 0x30, 0x2D, 0x6D, 0xB3, 0x6D, 0x4D, 0x15, 0x38,
	0x01, 0x10, 0xE1, 0xF6, 0xD0, 0x3C, 0x27, 0x41, 0xB0, 0xCD, 0xFD, 0xA4, 0xCD, 0x2D, 0xF0, 0x4E,
	0x6F, 0x6C, 0x01, 0x10, 0x03, 0x30, 0x00, 0x00, 0x73, 0x73, 0x73, 0x74, 0x75, 0x07, 0x72, 0x68,
	0x31, 0x22, 0x41, 0xD0, 0xA4, 0xF2, 0xCD, 0x3D, 0xE6, 0x1E, 0xF0, 0x36, 0x3D, 0x02, 0x20, 0x03,
	0x30, 0x00, 0x00, 0x40, 0x40, 0x40, 0x1C, 0x3F, 0x3A, 0x31, 0x84, 0x89, 0x21, 0x41, 0xF0, 0xB8,
	0xCB, 0x20, 0x68, 0x23, 0x26, 0x28, 0x2A, 0x2C, 0x2F, 0x2F, 0x2E, 0x00, 0x2B, 0x28, 0x28, 0x01,
	0x10, 0x27, 0x27, 0x27, 0x27, 0x08, 0x26, 0x24, 0x21, 0x08, 0x85, 0x41, 0xF0, 0xCB, 0xF8, 0x21,
	0x28, 0x38, 0x2F, 0x35, 0x38, 0x39, 0x36, 0x31, 0x2B, 0x24, 0x00, 0x1F, 0x1D, 0x01, 0x10, 0x1C,
	0x1C, 0x1C, 0xC3, 0x50, 0x41, 0xF0, 0xC4, 0x39, 0xF8, 0x40, 0x20, 0x2D, 0x3A, 0x56, 0xA8, 0xBE,
	0xBE, 0x03, 0xBE, 0xA7, 0x63, 0x34, 0x42, 0x40, 0x41, 0xF0, 0xB1, 0xF7, 0xA8, 0x02, 0xF0, 0xE5,
	0x06, 0x77, 0xB3, 0x8A, 0x08, 0x25, 0x30, 0x41, 0xAA, 0x11, 0xED, 0xD3, 0xAC, 0xA1, 0xAD, 0xCA,
	0xF5, 0xB2, 0x00, 0x39, 0x37, 0x33, 0x41, 0xF0, 0x41, 0xF0, 0x50, 0x49, 0x6D, 0x71, 0x03, 0x1B,
	0x5E, 0x20, 0x2D, 0x41, 0xAB, 0xE4, 0x80, 0x4E, 0x48, 0x00, 0x46, 0x4A, 0x53, 0x77, 0xE4, 0xBD,
	0x35, 0x24, 0x00, 0x44, 0x94, 0x41, 0xF0, 0x4D, 0xF5, 0x09, 0x15, 0x26, 0x3A, 0x7C, 0xF5, 0x0F,
	0x7F, 0x45, 0x37, 0x30, 0x2F, 0x32, 0x3F, 0x51, 0x00, 0x78, 0xF5, 0x74, 0x2D, 0xAE, 0x32, 0x41,
	0xF0, 0x4D, 0xF5, 0x9D, 0x6A, 0xF0, 0x1F, 0x2D, 0x45, 0xC1, 0xC1, 0x47, 0x30, 0x23, 0x00, 0x1F,
	0x1F, 0x21, 0x2A, 0x3D, 0x54, 0xC1, 0xBE, 0x00, 0x35, 0x22, 0x01, 0x10, 0x41, 0xF0, 0xA5, 0xF2,
	0x3D, 0x44, 0x15, 0x0A, 0x20, 0x7C, 0x33, 0x4C, 0xED, 0x88, 0x39, 0x24, 0x84, 0x10, 0x1F, 0x40,
	0x2F, 0x49, 0x8D, 0xED, 0x3B, 0x44, 0x0D, 0x41, 0xF0, 0x41, 0xF0, 0xE0, 0x64, 0x02, 0x27, 0x0B,
	0xBB, 0xB3, 0xB5, 0x13, 0x21, 0x37, 0x4F, 0x13, 0xF5, 0x49, 0x30, 0xED, 0x21, 0x1D, 0x28, 0x40,
	0x55, 0x08, 0xF5, 0x3F, 0x15, 0x40, 0x41, 0xF0, 0x2D, 0xF3, 0xAF, 0x07, 0x2D, 0x41, 0x50, 0xBC,
	0x42, 0x2C, 0xB8, 0x32, 0x24, 0x3B, 0x52, 0xF5, 0x40, 0x04, 0xB1, 0xF7, 0x1B, 0x41, 0xF0, 0x41,
	0xF0, 0x41, 0x41, 0xD0, 0x41, 0xF0, 0x41, 0xF0, 0xED, 0x79, 0xF7, 0x41, 0xF0, 0x41, 0xF0, 0xD0,
	0xD9, 0x8A, 0x8A, 0x8A, 0x8A, 0x0F, 0x8A, 0x93, 0xAC, 0x09, 0x50, 0x29, 0xB7, 0xF9, 0xF3, 0x41,
	0xF0, 0x8C, 0x0D, 0xF8, 0x81, 0x1F, 0x0F, 0x81, 0xBB, 0x81, 0x41, 0x10, 0x50, 0xF5, 0x22, 0x45,
	0x30, 0x70, 0x33, 0x29, 0x3F, 0x54, 0xF5, 0x46, 0x04, 0x30, 0x72, 0x23, 0x20, 0x71, 0xE3, 0xA5,
	0xF2, 0x3D, 0x20, 0x77, 0x9B, 0x3A, 0xAD, 0x16, 0x52, 0xF5, 0x52, 0x09, 0x00, 0x07, 0x10, 0x3B,
	0x4E, 0x31, 0x61, 0xF5, 0x54, 0x41, 0x35, 0x35, 0x35, 0x35, 0x00, 0x34, 0x30, 0x29, 0x21, 0x0D,
	0xF1, 0x41, 0xF0, 0x11, 0x4E, 0x36, 0x70, 0x50, 0xF5, 0xAF, 0x09, 0x00, 0x07, 0x10, 0xAA, 0xAF,
	0xB4, 0x18, 0xF5, 0xB1, 0xAC, 0xA9, 0xA9, 0xA9, 0xA9, 0xA8, 0x00, 0xA5, 0xA2, 0x99, 0xCE, 0x1D,
	0xF2, 0xA1, 0x22, 0x11, 0x3E, 0x30, 0x46, 0x3C, 0xC1, 0xC2, 0x09, 0x10, 0x06, 0x10, 0xC2, 0xC4,
	0xC5, 0xC3, 0x0C, 0xC1, 0xC0, 0xC0, 0xC0, 0xC0, 0xBF, 0xBD, 0xBA, 0x00, 0x2A, 0x41, 0xB0, 0x6D,
	0xF7, 0x41, 0x00, 0x8A, 0xA4, 0x3D, 0x8A, 0x0E, 0xA4, 0x95, 0x01, 0x27, 0x35, 0x43, 0x49, 0x09,
	0x00, 0x07, 0x10, 0xC2, 0x49, 0x4B, 0x4E, 0x4F, 0x4C, 0x49, 0x48, 0x48, 0x00, 0x48, 0x48, 0x46,
	0x40, 0x34, 0x51, 0x91, 0x41, 0xF0, 0x01, 0x10, 0xE0, 0xC7, 0x00, 0x9B, 0xBB, 0xB3, 0x4A, 0xC9,
	0x10, 0x25, 0x2C, 0x21, 0x01, 0x10, 0x06, 0x30, 0x31, 0x31, 0x31, 0x00, 0x00, 0x30, 0x30, 0x23,
	0x30, 0x2C, 0x27, 0xC9, 0x00, 0x41, 0xF0, 0xA1, 0xF2, 0x42, 0x40, 0x06, 0x60, 0xF8, 0x03, 0x30,
	0x00, 0x00, 0x1F, 0xDD, 0xA6, 0x41, 0xF0, 0xBF, 0xF3, 0x02, 0x20, 0xCD, 0xFD, 0xFB, 0x95, 0xF1,
	0x17, 0xD6, 0x62, 0x6D, 0x62, 0x2D, 0x90, 0x48, 0x29, 0x43, 0x2E, 0x03, 0x30, 0x03, 0x30, 0x00,
	0x00, 0x2F, 0x2F, 0x2F, 0x2B, 0x0E, 0x7D, 0xF8, 0x95, 0xF1, 0xB3, 0x9B, 0xAC, 0x95, 0x21, 0x1D,
	0x23, 0x23, 0x2F, 0x60, 0x66, 0x02, 0x20, 0x03, 0x30, 0x00, 0x00, 0x68, 0x68, 0x38, 0x68, 0x67,
	0x63, 0x5B, 0x27, 0x85, 0x10, 0x41, 0xF0, 0x0D, 0xF1, 0xE0, 0x39, 0x03, 0x28, 0x39, 0x07, 0x70,
	0x03, 0x30, 0x00, 0x00, 0xF5, 0xF5, 0x39, 0xF5, 0x2C, 0x20, 0x41, 0x90, 0x41, 0xF0, 0x27, 0x1B,
	0x25, 0x2B, 0xF5, 0x17, 0xF8, 0x34, 0x44, 0x4F, 0x02, 0x20, 0x03, 0x30, 0x00, 0x00, 0x52, 0x52,
	0x38, 0x52, 0x51, 0x49, 0x3A, 0x29, 0xE0, 0x12, 0x41, 0xF0, 0x2D, 0xF3, 0xE0, 0x42, 0x00, 0x20,
	0x28, 0x31, 0x38, 0x03, 0x30, 0x03, 0x30, 0x00, 0x00, 0xE1, 0x39, 0x39, 0x39, 0x34, 0x2C, 0x23,
	0xA9, 0xBF, 0xE9, 0xF2, 0xC0, 0xAC, 0x32, 0x4A, 0xBB, 0x3B, 0x27, 0x20, 0x21, 0xAC, 0xCF, 0x22,
	0x49, 0x22, 0xA9, 0xFF, 0xB5, 0xF3, 0xEA, 0x2F, 0x57, 0xAC, 0xAD, 0x63, 0x38, 0xF0, 0xCE, 0x41,
	0xF0, 0xDD, 0xFE, 0xA4, 0x9B, 0xA4, 0xBB, 0x81, 0x06, 0x60, 0x83, 0x37, 0xF0, 0x41, 0xF0, 0xD6,
	0xF5, 0xC3, 0x00, 0xD4, 0xC5, 0x1D, 0xF0, 0x41, 0xF0, 0x0F, 0xF0, 0xFF, 0x0F, 0xF0, 0x19, 0xF0,
	0x41, 0xF0, 0x0F, 0xF0, 0x0F, 0xF0, 0x2D, 0xF0, 0x41, 0xF0, 0x03, 0x30, 0xFF, 0x00, 0x00, 0x6D,
	0x6D, 0xD9, 0xC1, 0x33, 0xF0, 0x41, 0xF0, 0x15, 0xFA, 0x03, 0x30, 0xF9, 0x23, 0xF0, 0x41, 0xF0,
	0x41, 0xF0, 0x19, 0xF0, 0xE2, 0x3F, 0x20, 0x91, 0xAD, 0x1B, 0x5F, 0x41, 0xF0, 0x24, 0xF0, 0xA6,
	0xD2, 0x24, 0x2A, 0x56, 0x26, 0x61, 0xD2, 0x87, 0x41, 0xF0, 0xF8, 0xCC, 0xD9, 0xC1, 0x2C, 0x39,
	0xF5, 0x31, 0x24, 0x07, 0x15, 0x90, 0x41, 0xF0, 0xA5, 0xF2, 0x15, 0xD0, 0x46, 0xF5, 0x15, 0x10,
	0x41, 0xF0, 0xCF, 0xE5, 0xF6, 0x57, 0xBB, 0x00, 0x00, 0x57, 0x57, 0x57, 0x77, 0x09, 0x7D, 0xC0,
	0x22, 0x38, 0x4D, 0xF5, 0x3F, 0xC9, 0x50, 0x41, 0xF0, 0xC1, 0xBC, 0xBC, 0xBB, 0x00, 0x00, 0xAC,
	0xAC, 0xAC, 0xA4, 0xA5, 0x92, 0x85, 0x41, 0xF0, 0x41, 0xF0, 0xD9, 0xF1, 0x41, 0xF0, 0x39, 0x4F,
	0xF5, 0x40, 0x0F, 0xCE, 0x14, 0x41, 0xF0, 0x41, 0xF0, 0xD5, 0x3D, 0x85, 0xF5, 0x37, 0x4B, 0xF5,
	0x1F, 0x3E, 0x46, 0x74, 0x41, 0xF0, 0x26, 0xF0, 0x15, 0xF0, 0x32, 0x44, 0xF5, 0x1E, 0x39, 0xEE,
	0x76, 0x1B, 0x41, 0xF0, 0xA5, 0xF2, 0x6D, 0xFC, 0x36, 0x7C, 0x3A, 0x2F, 0x23, 0x15, 0xB0, 0x41,
	0xF0, 0xA5, 0xF2, 0x71, 0xAB, 0x22, 0x28, 0x3C, 0x2A, 0x25, 0x1F, 0x15, 0x90, 0x41, 0xF0, 0xA5,
	0xF2, 0x11, 0xC0, 0x6E, 0x0C, 0xF8, 0xE3, 0xAE, 0x41, 0xF0, 0xA5, 0xF2, 0x41, 0xC0, 0x33, 0xF0,
	0x41, 0xF0, 0xA5, 0xF2, 0x0B, 0xB0, 0xFF, 0x33, 0xF0, 0x41, 0xF0, 0xA5, 0xF2, 0x0B, 0xB0, 0x33,
	0xF0, 0x41, 0xF0, 0xA5, 0xF2, 0x0A, 0xA0, 0xFF, 0x33, 0xF0, 0x41, 0xF0, 0xA5, 0xF2, 0x09, 0x90,
	0x1E, 0xF0, 0x41, 0xF0, 0xA5, 0xF2, 0x04, 0x40, 0xFF, 0x25, 0xF0, 0xD5, 0xF5, 0x41, 0xF0, 0x53,
	0xF2, 0x85, 0xFE, 0x4D, 0xF5, 0xE3, 0xFA, 0x81, 0x7F, 0x8A, 0x81, 0xA9, 0x3B, 0x1E, 0x21, 0x26,
	0x26, 0x23, 0x04, 0x1F, 0x1C, 0x33, 0xAD, 0x24, 0x28, 0x29, 0x26, 0x05, 0x89, 0x84, 0x41, 0xF0,
	0x47, 0x20, 0xB3, 0x93, 0x77, 0x8A, 0xB3, 0xA4, 0x03, 0x2D, 0x81, 0x24, 0x40, 0x41, 0x39, 0x28,
	0x1F, 0xCB, 0x18, 0x82, 0x21, 0x21, 0x20, 0x1E, 0x1B, 0x2A, 0x24, 0x68, 0x6A, 0x20, 0x62, 0x2B,
	0x3D, 0xA4, 0x41, 0xF0, 0x93, 0xA4, 0x58, 0x16, 0x2D, 0x4C, 0xA4, 0x93, 0x10, 0x10, 0x4C, 0x10,
	0x10, 0x23, 0x84, 0x09, 0x2B, 0x54, 0x35, 0x37, 0xBB, 0x07, 0x96, 0x1F, 0x4F, 0x2E, 0x00, 0x39,
	0x24, 0x2C, 0x41, 0xA0, 0x41, 0xF0, 0x55, 0x31, 0x3D, 0x2D, 0x23, 0x63, 0x18, 0x29, 0x34, 0x04,
	0xD7, 0x41, 0xC7, 0xC8, 0xC4, 0x31, 0x21, 0x0E, 0x5F, 0x46, 0x40, 0xA1, 0xB6, 0x55, 0xFE, 0x9A,
	0x52, 0x10, 0x70, 0x34, 0x64, 0xB2, 0x14, 0x6E, 0x2E, 0x00, 0xBF, 0x4D, 0xA5, 0xB2, 0x65, 0xFF,
	0xA5, 0x36, 0x6D, 0xAC, 0x10, 0x70, 0x34, 0x64, 0xCE, 0x2E, 0x40, 0x41, 0xF0, 0xD2, 0xD9, 0xBB,
	0x77, 0x2D, 0x1B, 0x2D, 0x07, 0x77, 0xBB, 0x6D, 0x10, 0x70, 0x34, 0x64, 0x2E, 0x40, 0x41, 0xF0,
	0x08, 0xE9, 0xF8, 0x98, 0x1E, 0xAC, 0x62, 0x41, 0xC0, 0x41, 0xF0, 0x41, 0xF0, 0x77, 0xC8, 0x41,
	0x60, 0xF9, 0x41, 0xF0, 0x41, 0xF0, 0x41, 0xF0, 0xB5, 0xF3, 0x07, 0x60, 0xA2, 0xF3, 0x41, 0xF0,
	0x71, 0xF3, 0xFF, 0x06, 0x20, 0x07, 0x40, 0x55, 0x32, 0x24, 0x24, 0x2B, 0x47, 0x03, 0x44, 0x09,
	0x41, 0xF0, 0x47, 0xBD, 0x8A, 0x81, 0x4A, 0x1B, 0x77, 0x07, 0xB3, 0xBB, 0xD5, 0x55, 0x06, 0x20,
	0x07, 0x40, 0x6B, 0x44, 0x05, 0x46, 0x5C, 0x5E, 0xBC, 0x08, 0x41, 0xF0, 0xC8, 0xB4, 0x93, 0x73,
	0x07, 0xAC, 0x62, 0x2E, 0x3D, 0x6D, 0xAC, 0x3D, 0x34, 0x06, 0x20, 0x07, 0x40, 0xD1, 0xCF, 0x38,
	0xCD, 0xCD, 0xCF, 0xD1, 0xD2, 0x41, 0xC0, 0x91, 0xF5, 0x77, 0x60, 0x80, 0x14, 0x8D, 0x15, 0x57,
	0xBB, 0xA5, 0x32, 0x40, 0xF0, 0x92, 0x52, 0x41, 0xF0, 0xF3, 0x41, 0xF0, 0x1D, 0x02, 0x3E, 0x6D,
	0x01, 0x10, 0x3D, 0xF0, 0x4C, 0x0A, 0x12, 0xB3, 0x41, 0xF0, 0x41, 0xF0, 0xF1, 0x1B, 0x61, 0x01,
	0x10, 0x29, 0xF3, 0x44, 0x21, 0x8F, 0xB7, 0x41, 0xF0, 0x03, 0x20, 0x61, 0x5B, 0x1F, 0x21, 0xFF,
	0x21, 0xFF, 0xD5, 0xF5, 0x03, 0x20, 0xF7, 0xAE, 0x27, 0xBB, 0x1B, 0xF6, 0x1F, 0x47, 0x51, 0x52,
	0x50, 0x09, 0x21, 0xAF, 0x4E, 0x4E, 0x4B, 0x44, 0x38, 0x65, 0x2F, 0x41, 0xF0, 0xC1, 0xB1, 0xF7,
	0x51, 0x04, 0x25, 0x32, 0x41, 0x45, 0x3F, 0x34, 0x03, 0x21, 0x0F, 0x03, 0x30, 0x00, 0x00, 0x1E,
	0x0F, 0x29, 0x28, 0x24, 0x02, 0x6A, 0x8F, 0x41, 0xF0, 0x45, 0xFD, 0x42, 0x34, 0x0F, 0x34, 0x24,
	0x01, 0x10, 0x03, 0x30, 0xCB, 0x00, 0x00, 0x1D, 0x35, 0x59, 0x41, 0xF0, 0x19, 0xF0, 0x34, 0xBF,
	0x1B, 0xF0, 0x41, 0xF0, 0xFD, 0x19, 0xF0, 0xB5, 0x83, 0x1E, 0xF0, 0x41, 0xF0, 0x1C, 0xF0, 0x21,
	0x9F, 0x2D, 0x83, 0x15, 0xF0, 0xFF, 0x41, 0xF0, 0x41, 0xF0, 0xA5, 0xF2, 0x91, 0xD5, 0x41, 0xF0,
	0x41, 0xF0, 0x57, 0x34, 0x3F, 0x00, 0x00, 0x03, 0x30, 0x00, 0x00, 0x26, 0x26, 0x26, 0x24, 0x21,
	0x07, 0x1E, 0x1C, 0x41, 0x80, 0x51, 0xF1, 0x99, 0xFE, 0x6D, 0x51, 0x04, 0x40, 0x9C, 0x45, 0x00,
	0x00, 0x45, 0x45, 0x45, 0x43, 0x3D, 0x32, 0x02, 0x26, 0x01, 0xDD, 0x38, 0xAC, 0xAA, 0x83, 0x41,
	0x50, 0xE1, 0xE1, 0x04, 0x40, 0x9E, 0xE0, 0x00, 0x00, 0xE0, 0xE0, 0xE0, 0xDF, 0xDE, 0xDA, 0x02,
	0x34, 0x22, 0x41, 0xC0, 0xC4, 0xA8, 0x4A, 0xB2, 0x73, 0x41, 0x50, 0x3E, 0xF0, 0xEC, 0x85, 0xF0,
	0xCD, 0xB0, 0x81, 0xDB, 0x31, 0x8A, 0xBB, 0x77, 0x41, 0x50, 0x8B, 0x3E, 0xF0, 0x69, 0xFB, 0xCA,
	0xD0, 0x57, 0xB2, 0x13, 0x9B, 0x3D, 0x65, 0x7F, 0x97, 0xDD, 0xFA, 0x41, 0xE1, 0xFA, 0xC7, 0xC0,
	0x8A, 0x9B, 0xB3, 0x6D, 0x0D, 0x41, 0x80, 0x7E, 0x76, 0x04, 0x40, 0x70, 0x00, 0x00, 0x70, 0x70,
	0x29, 0x70, 0x6E, 0x63, 0x4C, 0x35, 0xCC, 0x51, 0xF1, 0x81, 0xBB, 0x30, 0xBB, 0x6D, 0x01, 0x9D,
	0x6A, 0x4C, 0x04, 0x40, 0x40, 0x00, 0x00, 0xA4, 0x40, 0xD1, 0xD9, 0x41, 0xF0, 0xF5, 0x0F, 0xA4,
	0xAC, 0x62, 0x77, 0x0E, 0xE7, 0x02, 0xBD, 0x7C, 0x54, 0x30, 0x00, 0x00, 0x03, 0x30, 0x00, 0x00,
	0x22, 0x73, 0x22, 0x22, 0x21, 0x1F, 0xA5, 0xD2, 0x2D, 0xF3, 0x5F, 0x32, 0x79, 0x8C, 0xF0, 0x3A,
	0xD1, 0x1C, 0xF7, 0x83, 0x21, 0x2D, 0xF3, 0xAC, 0x57, 0xD7, 0x41, 0x95, 0xB3, 0x9B, 0x35, 0x1C,
	0xF1, 0x1B, 0x4F, 0x70, 0x46, 0x85, 0x61, 0x27, 0x6C, 0x25, 0x20, 0x6D, 0xD7, 0xD8, 0xA5, 0xCA,
	0x79, 0x9B, 0x7C, 0x7B, 0xB8, 0x70, 0xDC, 0xBD, 0x04, 0x34, 0x3E, 0x41, 0x80, 0x2B, 0xE5, 0x56,
	0x41, 0xF0, 0xC1, 0x05, 0xF9, 0x59, 0xF0, 0xF0, 0xEF, 0xDC, 0x60, 0x1D, 0x20, 0x21, 0x09, 0x05,
	0x4A, 0x6B, 0xB9, 0xE6, 0xFF, 0x39, 0xC9, 0x10, 0x81, 0x41, 0xF0, 0x3B, 0xF0, 0x59, 0x2A, 0x54,
	0x58, 0x49, 0x30, 0x21, 0x07, 0xC1, 0x50, 0x81, 0x04, 0xA4, 0x17, 0x26, 0xC5, 0x24, 0x41, 0xF0,
	0xC3, 0xF0, 0xF5, 0x17, 0xFB, 0x29, 0x32, 0x33, 0x2E, 0x24, 0x1E, 0xC1, 0x50, 0x7C, 0x40, 0xBC,
	0x80, 0x30, 0x09, 0xF5, 0xAC, 0xCF, 0xA9, 0x6F, 0x85, 0x20, 0x1F, 0x1F, 0x3E, 0x1F, 0xD3, 0x19,
	0x2F, 0x39, 0x49, 0xC1, 0x00, 0x2C, 0x63, 0x71, 0xE3, 0xE2, 0x5F, 0xBA, 0x00, 0x00, 0x5A, 0x0A,
	0x4A, 0x93, 0xBB, 0x77, 0x76, 0x53, 0x87, 0x24, 0x2B, 0x35, 0x42, 0x52, 0x98, 0xC1, 0x60, 0xF1,
	0x40, 0xC0, 0x90, 0x4D, 0xE9, 0xF2, 0x1B, 0x1B, 0xCE, 0xF9, 0x9B, 0x48, 0x3D, 0xEE, 0x32, 0x22,
	0x28, 0x31, 0x3E, 0x4D, 0x7B, 0x02, 0xBC, 0xF0, 0x1C, 0x62, 0xA6, 0x6C, 0x55, 0x42, 0x61, 0xF2,
	0x84, 0xD2, 0xF9, 0x93, 0xB3, 0x54, 0x1A, 0x45, 0x2D, 0x37, 0x47, 0x69, 0x19, 0xB0, 0xE0, 0x94,
	0x51, 0xDA, 0x36, 0x00, 0x6A, 0x45, 0x30, 0x14, 0x27, 0x21, 0x91, 0xA5, 0x41, 0xF0, 0xBF, 0x1C,
	0x93, 0x3D, 0x51, 0x61, 0x9C, 0x92, 0xCF, 0xF8, 0x3E, 0x60, 0x88, 0x7F, 0x51, 0x11, 0x30, 0x48,
	0x1F, 0x1D, 0x41, 0xF0, 0x4D, 0xC9, 0x9B, 0xAC, 0x62, 0xA1, 0x66, 0x8C, 0x32, 0x56, 0x11, 0x41,
	0xDA, 0xB7, 0x7C, 0x5F, 0x55, 0x04, 0x62, 0xC9, 0x10, 0x50, 0x41, 0x00, 0x41, 0xF0, 0x93, 0xB5,
	0xBB, 0x81, 0x3A, 0xC6, 0x54, 0x41, 0x60, 0xF8, 0xC1, 0x8A, 0x77, 0x5F, 0x4A, 0x03, 0x39, 0x35,
	0x41, 0x60, 0x41, 0xF0, 0x84, 0xA4, 0xBB, 0x9B, 0xD5, 0x65, 0x9C, 0x2D, 0x13, 0x89, 0x4D, 0xDA,
	0xAC, 0x6E, 0x49, 0x39, 0x34, 0x03, 0x49, 0x74, 0x41, 0x40, 0x41, 0xF0, 0xE0, 0xFE, 0x4D, 0x55,
	0x1F, 0x32, 0x3C, 0x57, 0xD1, 0xD1, 0x40, 0xF8, 0xD6, 0x9E, 0x52, 0x61, 0x04, 0x7C, 0xC6, 0xA8,
	0x41, 0xF0, 0x3B, 0xF0, 0x1D, 0x12, 0x3E, 0x5B, 0x80, 0x1E, 0xD1, 0x60, 0xF8, 0xD1, 0xB0, 0x3A,
	0x00, 0x55, 0x2F, 0x14, 0x8E, 0x91, 0x1B, 0x41, 0xF0, 0x95, 0xF1, 0x29, 0x38, 0xD1, 0x00, 0x8F,
	0xC1, 0x26, 0xF1, 0x8A, 0x75, 0x69, 0x43, 0x2F, 0x27, 0x21, 0x42, 0x30, 0x82, 0x41, 0xF0, 0x3A,
	0xF0, 0x68, 0x2B, 0xD1, 0x90, 0x98, 0x22, 0xB9, 0x72, 0x41, 0x1F, 0xF5, 0x23, 0x41, 0xF0, 0x3C,
	0xF0, 0xD1, 0xA0, 0x54, 0x67, 0x82, 0xB8, 0x0F, 0xE1, 0xAF, 0x53, 0xE6, 0xAF, 0xC5, 0x24, 0x41,
	0xF0, 0x3B, 0xF0, 0xD1, 0x90, 0xF2, 0x2F, 0x3B, 0x49, 0x5B, 0x6C, 0x90, 0xC1, 0xF1, 0x00, 0xC5,
	0x54, 0x1D, 0x32, 0x41, 0xF0, 0x39, 0xF0, 0xD1, 0x80, 0x23, 0x29, 0x33, 0x1F, 0x3F, 0x4F, 0x61,
	0x72, 0xA5, 0xD2, 0x95, 0xB1, 0x41, 0xF0, 0xC0, 0x40, 0xF0, 0xE1, 0x0D, 0xC4, 0x5D, 0x1F, 0x25,
	0x2C, 0x36, 0x44, 0x07, 0x55, 0x68, 0x83, 0xC1, 0xE9, 0x51, 0x41, 0x41, 0xF0, 0xAF, 0xF3, 0xE0,
	0xD1, 0x19, 0x25, 0x27, 0x23, 0x1E, 0x25, 0xE0, 0x3F, 0x21, 0x27, 0x31, 0x30, 0x3B, 0x4D, 0x65,
	0x79, 0x9C, 0xDE, 0x99, 0xDE, 0x80, 0x15, 0xFA, 0x00, 0x00, 0x8A, 0x8A, 0x8A, 0x8A, 0x49, 0x19,
	0x35, 0x43, 0xA9, 0x36, 0x2A, 0x2E, 0x52, 0xD9, 0x22, 0x27, 0x35, 0x4F, 0x18, 0x6B, 0x99, 0xEF,
	0x44, 0x41, 0xB0, 0x7D, 0xF8, 0xB3, 0x81, 0x30, 0xE9, 0x52, 0x20, 0x31, 0x4B, 0xFF, 0xB2, 0x43,
	0x2C, 0x01, 0x21, 0xE9, 0x61, 0x1D, 0x21, 0x2B, 0x40, 0x5E, 0xBF, 0x02, 0x9D, 0xEA, 0x41, 0xF0,
	0x69, 0x3F, 0x71, 0x33, 0x60, 0x98, 0x00, 0x49, 0x30, 0x2F, 0x16, 0x59, 0x1E, 0x24, 0x31, 0x48,
	0x80, 0x42, 0x11, 0x4A, 0x41, 0x91, 0xB5, 0x51, 0xF1, 0x31, 0x81, 0x3D, 0x1C, 0x15, 0xE7, 0x6F,
	0x34, 0x17, 0x25, 0x1E, 0x44, 0x41, 0x52, 0xA8, 0xF8, 0xF5, 0x37, 0x41, 0xF0, 0xC4, 0x0E, 0xAE,
	0x70, 0x5B, 0x45, 0x1D, 0x89, 0x2D, 0xF0, 0x81, 0x39, 0x27, 0x0F, 0x1F, 0x1C, 0x1D, 0x22, 0x2E,
	0x42, 0x6E, 0xD8, 0x00, 0x82, 0x20, 0xD5, 0x3F, 0xF5, 0xB7, 0x41, 0xF0, 0xB3, 0x6D, 0x8A, 0x39,
	0x99, 0xBD, 0x1C, 0x54, 0xAE, 0xD2, 0x10, 0xF8, 0x9D, 0x3D, 0x29, 0x09, 0x22, 0x27, 0x35, 0x4D,
	0x90, 0xF0, 0x18, 0x22, 0xA9, 0x40, 0x4F, 0x30, 0xF5, 0x27, 0x41, 0xF0, 0xC4, 0x7C, 0x8D, 0x69,
	0x1D, 0x27, 0x3C, 0x3C, 0x60, 0x9B, 0x57, 0x11, 0xFF, 0xB6, 0x46, 0x39, 0x08, 0x41, 0x5A, 0xC7,
	0x40, 0x20, 0xE1, 0x84, 0x4D, 0x34, 0x08, 0x24, 0xF5, 0xB7, 0x71, 0xF3, 0x8A, 0x2D, 0x42, 0x70,
	0x29, 0x3E, 0x26, 0x5B, 0x85, 0x05, 0x20, 0xCE, 0x65, 0x86, 0xE9, 0x7F, 0x20, 0x84, 0xBF, 0x60,
	0x43, 0x2F, 0x23, 0xC5, 0x10, 0x41, 0xF0, 0xE9, 0xF2, 0xE0, 0x68, 0x3B, 0x28, 0x39, 0x55, 0x75,
	0x56, 0x21, 0xE9, 0x82, 0x20, 0xA1, 0xE9, 0x94, 0x52, 0xEC, 0x02, 0x25, 0xDB, 0x61, 0xF2, 0x42,
	0xA0, 0x1E, 0x78, 0x25, 0x34, 0x4F, 0x70, 0xC1, 0x4B, 0x51, 0xC9, 0x64, 0x20, 0x47, 0x31, 0x25,
	0x1E, 0x41, 0xE0, 0x85, 0xF0, 0x9B, 0x2D, 0x30, 0x1B, 0x90, 0x1D, 0x22, 0x30, 0x49, 0x6A, 0xAF,
	0xF8, 0x01, 0xCB, 0x10, 0xF1, 0xA5, 0x5F, 0x3E, 0x2B, 0x21, 0x1D, 0x01, 0xD1, 0xE9, 0x41, 0xF0,
	0xBC, 0x0C, 0x3B, 0x34, 0x28, 0x17, 0x1F, 0x21, 0x23, 0x1F, 0x25, 0x2A, 0x36, 0x4C, 0x6C, 0x9D,
	0xF1, 0x42, 0x10, 0x80, 0x99, 0x51, 0x34, 0x28, 0x25, 0x24, 0x24, 0x22, 0x00, 0x20, 0x1E, 0x49,
	0xC9, 0x8D, 0xF9, 0x8B, 0x39, 0xA1, 0x16, 0x21, 0x2B, 0x3C, 0x37, 0x3D, 0x41, 0x41, 0x45, 0x4F,
	0x63, 0x7C, 0x00, 0x8A, 0xE9, 0x42, 0x10, 0x8C, 0x4C, 0x42, 0x40, 0x40, 0x04, 0x3F, 0x39, 0x30,
	0x25, 0x1E, 0x0C, 0x30, 0x41, 0xF0, 0xE5, 0xF6, 0xE0, 0x2B, 0x41, 0xC8, 0xCC, 0xCD, 0xCD, 0xCE,
	0xCF, 0x00, 0xD0, 0xD2, 0xD2, 0xD2, 0x37, 0x10, 0xF8, 0xD0, 0xCE, 0x10, 0xCD, 0xCD, 0xCD, 0xCA,
	0xC4, 0x31, 0xD9, 0x11, 0x41, 0xF0, 0xC0, 0x5B, 0xF2, 0xEC, 0x51, 0xFF, 0x3D, 0xF0, 0xD9, 0xF1,
	0xD8, 0xE1, 0x81, 0x8A, 0x3B, 0x81, 0xDA, 0x01, 0x9D, 0x1A, 0x66, 0x00, 0x00, 0x3E, 0xF0, 0x9D,
	0xFA, 0x2F, 0xE7, 0xF6, 0xB3, 0x93, 0x77, 0x8A, 0xB3, 0x3B, 0x10, 0x20, 0x38, 0x20, 0x5F, 0x01,
	0x10, 0xF5, 0xF3, 0x43, 0xE5, 0x36, 0x41, 0xF0, 0x25, 0x52, 0xA4, 0x76, 0x09, 0x19, 0x2D, 0x3D,
	0x14, 0x1F, 0x2F, 0x49, 0x99, 0xA1, 0x05, 0x02, 0x20, 0x03, 0x30, 0x00, 0x00, 0xA4, 0xA4, 0xA4,
	0xA3, 0x9D, 0x07, 0x8E, 0x36, 0x23, 0x41, 0x70, 0x41, 0xF0, 0x41, 0x14, 0xE5, 0x76, 0x26, 0x78,
	0x35, 0x45, 0x4F, 0x52, 0x4F, 0x03, 0x30, 0x4E, 0x00, 0x00, 0xA0, 0x4E, 0x4E, 0x4E, 0x4F, 0x52,
	0x52, 0x4B, 0x3C, 0x00, 0x2A, 0x41, 0x00, 0x41, 0xF0, 0xA5, 0xF2, 0xA1, 0x16, 0x24, 0x30, 0x3D,
	0x1E, 0x41, 0x3C, 0x32, 0x2D, 0x2A, 0xC0, 0x44, 0x2A, 0x2A, 0x20, 0x2A, 0x2B, 0x31, 0x3A, 0x44,
	0x42, 0x39, 0x28, 0x00, 0x09, 0xA5, 0x41, 0xF0, 0xAC, 0x30, 0x37, 0x6D, 0x05, 0x09, 0x1F, 0x2A,
	0x2B, 0x3F, 0xB1, 0xB2, 0xAD, 0x31, 0x23, 0x1D, 0x1E, 0x00, 0x20, 0x26, 0x8A, 0x04, 0x22, 0x1F,
	0x1D, 0x1D, 0x20, 0x04, 0x2D, 0x44, 0xC8, 0xC8, 0xC5, 0x32, 0x21, 0x41, 0xC0, 0x80, 0xA8, 0xE6,
	0x77, 0x2D, 0x1B, 0x2D, 0x77, 0xE5, 0x16, 0x20, 0x41, 0x34, 0x57, 0x10, 0x00, 0x3E, 0x25, 0x30,
	0x18, 0x68, 0x6A, 0x24, 0x43, 0x28, 0x20, 0x35, 0x5A, 0x2E, 0x00, 0x40, 0x09, 0x75, 0x41, 0xF0,
	0xD1, 0xB5, 0x27, 0xAC, 0x4A, 0x05, 0xAC, 0x62, 0x1B, 0xE9, 0x22, 0x10, 0x20, 0xC5, 0x30, 0x18,
	0x43, 0x48, 0x21, 0x3C, 0x6B, 0x2E, 0x00, 0xE9, 0xF2, 0x95, 0xF5, 0xE3, 0x3D, 0xA3, 0x16, 0x10,
	0x70, 0x30, 0x08, 0x74, 0x18, 0x46, 0x28, 0x4E, 0x22, 0x9E, 0x61, 0xF2, 0x95, 0xF1, 0x22, 0xF6,
	0x14, 0x02, 0x6E, 0x07, 0x00, 0x4D, 0x29, 0x2F, 0x2E, 0x20, 0x41, 0xF0, 0x2D, 0xF3, 0x22, 0x40,
	0x93, 0x10, 0x30, 0x41, 0xF0, 0x41, 0xF0, 0xEF, 0xC9, 0xF0, 0x80, 0x44, 0xBB, 0x10, 0x50, 0x41,
	0xF0, 0x41, 0xF0, 0x4F, 0xC5, 0xBB, 0x7B, 0x4C, 0x35, 0xB3, 0xA4, 0x10, 0x70, 0x07, 0x60, 0x2E,
	0x40, 0x41, 0xF0, 0xA8, 0xB2, 0xF9, 0x6D, 0xBB, 0x00, 0x00, 0x6D, 0x7A, 0x08, 0x2D, 0x41, 0x20,
	0x06, 0x20, 0xD4, 0xD5, 0x65, 0xCB, 0x25, 0x41, 0xF0, 0x51, 0xF1, 0x41, 0xA0, 0x06, 0x20, 0xD5,
	0x65, 0xCB, 0x25, 0xFF, 0x41, 0xA0, 0x41, 0xF0, 0x41, 0xF0, 0x06, 0x20, 0xD5, 0x65, 0xCB, 0x25,
	0x41, 0xB0, 0x41, 0xF0, 0xFF, 0xCE, 0xF4, 0x40, 0xF0, 0x33, 0x24, 0x41, 0x80, 0x41, 0xF0, 0x9A,
	0x21, 0x2D, 0x8A, 0x3F, 0xAC, 0x98, 0x16, 0x22, 0x3F, 0x6F, 0x01, 0x10, 0x3D, 0xF0, 0x4E, 0x62,
	0x29, 0x41, 0x90, 0x41, 0xF0, 0x8A, 0xAC, 0x4A, 0x1B, 0x9B, 0x06, 0xA4, 0x6D, 0xA4, 0x93, 0x1D,
	0x12, 0x69, 0x01, 0x10, 0xD5, 0xF1, 0xD0, 0x49, 0x1D, 0xC2, 0x85, 0xF0, 0x3D, 0x00, 0x3D, 0x1B,
	0x3D, 0xD5, 0x45, 0x8E, 0xD5, 0xF5, 0xD5, 0xF5, 0x41, 0xF0, 0xC7, 0x00, 0x7D, 0x14, 0xBB, 0xD5,
	0x25, 0xD5, 0xF5, 0xDF, 0xD5, 0xF5, 0x41, 0xF0, 0x44, 0x00, 0x8A, 0x8A, 0xCB, 0x15, 0xD5, 0x85,
	0xD5, 0xF5, 0xE7, 0x41, 0xF0, 0x3A, 0xB4, 0x93, 0xBB, 0x4A, 0x1B, 0x4A, 0xA4, 0x03, 0x77, 0xB5,
	0x13, 0x22, 0x28, 0x2A, 0x03, 0x30, 0x03, 0x30, 0x00, 0x00, 0xE2, 0x2B, 0x2B, 0x2B, 0x28, 0x24,
	0x1F, 0x1D, 0xD2, 0x23, 0xE2, 0xC0, 0x77, 0x4A, 0x9F, 0x12, 0xDA, 0x11, 0x23, 0x2E, 0x3A, 0x41,
	0x0C, 0x02, 0x20, 0x03, 0x30, 0x00, 0x00, 0x45, 0x45, 0x45, 0x43, 0x3D, 0x07, 0x32, 0x26, 0x95,
	0x11, 0x41, 0xF0, 0x3B, 0xF0, 0x0D, 0x11, 0x45, 0xDC, 0x3C, 0xDF, 0x02, 0x20, 0x03, 0x30, 0x00,
	0x00, 0xE0, 0xE0, 0xE0, 0xDF, 0x0E, 0xDE, 0xDA, 0x0D, 0x21, 0x41, 0xF0, 0xC3, 0xF0, 0x85, 0x10,
	0x5D, 0x01, 0x10, 0xBC, 0x3D, 0xF0, 0x41, 0x26, 0x41, 0x90, 0x41, 0xF0, 0x00, 0x00, 0x00, 0x00,
	0x57, 0x79, 0x57, 0x24, 0x03, 0x21, 0x3B, 0x67, 0x01, 0x10, 0x3D, 0xF0, 0x48, 0x62, 0x71, 0xA3,
	0x41, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xBB, 0xBB, 0x85, 0x00, 0x20, 0x4F, 0x37, 0x5E, 0x01, 0x10,
	0xE5, 0xF2, 0x42, 0x27, 0x01, 0x10, 0x41, 0xF0, 0xCC, 0x16, 0xC2, 0xA4, 0x81, 0xA5, 0x02, 0x2D,
	0x46, 0x7E, 0x8A, 0x09, 0x09, 0x10, 0x8E, 0x92, 0x61, 0x12, 0x94, 0x90, 0x8C, 0x8C, 0x09, 0x8C,
	0x8C, 0x8C, 0x8B, 0x83, 0x71, 0x34, 0x22, 0x00, 0x41, 0xF0, 0x1B, 0x3D, 0xF0, 0x3D, 0x41, 0x00,
	0x1D, 0x23, 0x2F, 0x15, 0x3B, 0x43, 0x09, 0x10, 0x4C, 0x63, 0x7C, 0x41, 0x00, 0x6F, 0x44, 0x52,
	0x47, 0x47, 0x47, 0x47, 0x47, 0x45, 0x3F, 0x00, 0x33, 0x27, 0x1D, 0x62, 0x41, 0xF0, 0x9A, 0xD2,
	0x1D, 0x20, 0x23, 0x1C, 0x25, 0x09, 0x10, 0x2D, 0x49, 0x74, 0x41, 0x00, 0x57, 0x34, 0x22, 0x27,
	0x27, 0x27, 0x27, 0x27, 0x26, 0x24, 0x21, 0x00, 0x1E, 0x1C, 0x41, 0xF0, 0x1B, 0x68, 0xF0, 0x6D,
	0x56, 0x32, 0x0B, 0x30, 0xD4, 0x23, 0x0D, 0x21, 0x50, 0x2B, 0x00, 0x00, 0x1C, 0x1C, 0x1C, 0x12,
	0x1C, 0x41, 0xC0, 0x41, 0xF0, 0x00, 0x00, 0x9B, 0x9B, 0x9B, 0xA4, 0x0E, 0xBB, 0xCF, 0x31, 0x41,
	0xF0, 0x41, 0xF0, 0x41, 0xF0, 0x00, 0x00, 0x77, 0x77, 0x3E, 0x77, 0x6D, 0x3D, 0x11, 0x50, 0x41,
	0xF0, 0x41, 0xF0, 0x41, 0xF0, 0x17, 0xF0, 0xF8, 0x22, 0x40, 0x70, 0x41, 0x00, 0x4F, 0x2A, 0x16,
	0xF0, 0x41, 0xF0, 0xC8, 0x4F, 0xF3, 0x0B, 0x30, 0x24, 0x41, 0x71, 0x41, 0x00, 0x51, 0x2B, 0x23,
	0x00, 0x00, 0x1D, 0x1D, 0x81, 0x93, 0x41, 0xF0, 0xDF, 0x21, 0x62, 0x03, 0x10, 0xB9, 0x62, 0x2D,
	0x1E, 0x22, 0x1F, 0x24, 0x29, 0x2E, 0x09, 0x10, 0x84, 0x35, 0x50, 0x78, 0x41, 0x00, 0x5D, 0x3C,
	0x00, 0x00, 0x2F, 0x48, 0x2F, 0x2F, 0x2B, 0x26, 0x20, 0xD9, 0xE1, 0x40, 0xA0, 0xBB, 0x60, 0xB3,
	0x7D, 0x20, 0xB3, 0x77, 0x85, 0x22, 0x35, 0x6A, 0x72, 0x12, 0x09, 0x10, 0x78, 0x88, 0x94, 0x38,
	0x00, 0x8E, 0x7D, 0x75, 0x11, 0x75, 0x75, 0x75, 0x75, 0x74, 0x6D, 0x62, 0x2B, 0x00, 0x1F, 0x0C,
	0x60, 0x41, 0xF0, 0x77, 0xAC, 0x57, 0x42, 0x50, 0x77, 0x46, 0xC9, 0x00, 0x30, 0x4F, 0x01, 0x10,
	0x3D, 0xF0, 0x39, 0xE8, 0x71, 0x41, 0xF0, 0xD9, 0xB3, 0x6D, 0x24, 0x50, 0x57, 0xAC, 0x21, 0x00,
	0x39, 0x63, 0x24, 0x01, 0x10, 0x3D, 0xF0, 0x45, 0x0C, 0x10, 0x41, 0xF0, 0x41, 0xF0, 0x21, 0x00,
	0x3A, 0x7B, 0x65, 0x07, 0x70, 0x03, 0x30, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x47, 0x0E, 0x28, 0x41,
	0xE0, 0x08, 0x80, 0x34, 0x70, 0xBB, 0x1B, 0x1B, 0x1F, 0x0E, 0x33, 0x55, 0xE0, 0x05, 0x50, 0x03,
	0x30, 0x00, 0x00, 0xE1, 0xE1, 0x38, 0xE1, 0xDD, 0x3D, 0x25, 0x0C, 0x60, 0x41, 0xF0, 0xA4, 0x8A,
	0x30, 0x24, 0x50, 0x81, 0xA4, 0x31, 0x01, 0x28, 0x3C, 0x52, 0x60, 0x09, 0x02, 0x20, 0x03, 0x30,
	0x00, 0x00, 0x65, 0x65, 0x65, 0x63, 0x58, 0x07, 0x45, 0x2F, 0x20, 0x41, 0xC0, 0x42, 0xA0, 0xBB,
	0x81, 0x3D, 0x18, 0x22, 0x10, 0x2D, 0x81, 0xBB, 0x57, 0x31, 0x11, 0x28, 0x30, 0x21, 0x36, 0x02,
	0x20, 0x03, 0x30, 0x00, 0x00, 0x39, 0x39, 0x39, 0x37, 0x0E, 0x32, 0x2B, 0x22, 0x40, 0x70, 0x21,
	0x34, 0x47, 0xDB, 0x08, 0x3A, 0x28, 0x43, 0xB0, 0x9B, 0xBB, 0xB3, 0xAC, 0xAC, 0x04, 0xB3, 0xBB,
	0xA4, 0x3F, 0x20, 0x1C, 0x1E, 0x1F, 0x04, 0x40, 0x88, 0x03, 0x30, 0x00, 0x00, 0x20, 0x20, 0x20,
	0x1F, 0x1F, 0xD9, 0x80, 0x83, 0x20, 0x32, 0x44, 0xDB, 0x38, 0x26, 0x12, 0xC0, 0x4A, 0x40, 0x62,
	0x6D, 0x6D, 0x62, 0x4A, 0x02, 0x20, 0x0F, 0xF0, 0x15, 0xF0, 0xE0, 0x20, 0x2E, 0x3B, 0xDB, 0x32,
	0x24, 0x05, 0x50, 0x0F, 0xF0, 0xC0, 0x0F, 0xF0, 0x15, 0xF0, 0x1E, 0x26, 0x2E, 0x31, 0x29, 0x20,
	0x03, 0x06, 0x60, 0x0F, 0xF0, 0x26, 0xF0, 0x42, 0xF0, 0x20, 0x23, 0x24, 0x20, 0x0F, 0x1D, 0x06,
	0x60, 0x0F, 0xF0, 0x0F, 0xF0, 0x13, 0xF0, 0x1C, 0x1D, 0x1D, 0x1E, 0x1C, 0x00, 0x00, 0x09, 0x90,
	0x03, 0x30, 0x00, 0x00, 0x1B, 0x1B, 0x1B, 0x1E, 0x94, 0x0F, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00,
	0x6C, 0x23, 0x00, 0x00
};

u8 battery_icons_blz[] = {
	0x17, 0xC0, 0x5D, 0x51, 0x79, 0x12, 0x79, 0x48, 0x69, 0x00, 0x0D, 0x46, 0xE3, 0x0F, 0xF0, 0x20,
	0xF0, 0x35, 0x2E, 0x38, 0x3F, 0x40, 0xEF, 0xCF, 0x00, 0x89, 0x77, 0x00, 0x17, 0x01, 0x14, 0x09,
	0x90, 0x36, 0xF0, 0xA4, 0xF1, 0x62, 0x01, 0x38, 0xA1, 0x99, 0x84, 0x3E, 0x00, 0x23, 0x1F, 0x04,
	0x40, 0x3B, 0xF0, 0x5B, 0x4F, 0x00, 0x18, 0x25, 0x20, 0x24, 0x90, 0x57, 0x00, 0x3C, 0xC0, 0x7B,
	0x00, 0x63, 0x10, 0x31, 0x7C, 0x2B, 0x03, 0x30, 0x3C, 0xF0, 0xA2, 0x00, 0xCE, 0x11, 0x0F, 0x0D,
	0x21, 0x00, 0x9E, 0xDE, 0x00, 0x06, 0x40, 0x60, 0xF0, 0xB9, 0xA0, 0xEA, 0x70, 0x3C, 0xF0, 0xF5,
	0x67, 0xD4, 0x3E, 0x01, 0x54, 0x00, 0x00, 0x00, 0x57, 0x70, 0xCD, 0xB1, 0x00, 0x1E, 0xFB, 0xD9,
	0x15, 0xA0, 0xC9, 0xAE, 0x69, 0x30, 0x3C, 0xD0, 0x30, 0xF0, 0xE4, 0xC1, 0xA7, 0x18, 0x10, 0x0D,
	0x0C, 0x00, 0x49, 0x3F, 0x04, 0x00, 0x87, 0x75, 0x00, 0xC5, 0xAA, 0x2A, 0x00, 0x09, 0x40, 0xC0,
	0xD7, 0xBA, 0x24, 0x00, 0x0C, 0xA0, 0x33, 0xF0, 0xF7, 0xD6, 0x0C, 0x00, 0x9C, 0x3C, 0xA0, 0x07,
	0x06, 0x2A, 0x10, 0x7D, 0x6C, 0x00, 0xBB, 0x09, 0xA2, 0x00, 0xF3, 0xD2, 0x00, 0xE3, 0xC4, 0x0C,
	0xA0, 0x80, 0x3C, 0xF0, 0x41, 0x38, 0x05, 0x50, 0x3E, 0xF1, 0x03, 0x00, 0x01, 0x19, 0x01, 0x00,
	0x33, 0x2C, 0x00, 0x71, 0x62, 0x00, 0x00, 0xAF, 0x97, 0x00, 0xEB, 0xCB, 0x03, 0x30, 0x03, 0x30,
	0x3C, 0x40, 0xE0, 0x81, 0x70, 0x04, 0x40, 0x0F, 0xF0, 0x23, 0xF0, 0x2D, 0x27, 0x00, 0x1C, 0x6B,
	0x5D, 0x00, 0xA9, 0x92, 0x00, 0xE7, 0xC8, 0x00, 0x00, 0x00, 0x00, 0xFE, 0xDC, 0x00, 0xBF, 0xA5,
	0x0E, 0xE0, 0x81, 0x0F, 0xF0, 0x19, 0xF0, 0xA5, 0x00, 0x22, 0x00, 0x65, 0x58, 0x00, 0x07, 0x67,
	0x59, 0x07, 0x70, 0x0F, 0xF0, 0x2A, 0xF0, 0x06, 0x09, 0x45, 0x10, 0x3C, 0x0A, 0x00, 0x00, 0x03,
	0x30, 0x00, 0x00, 0x49, 0x11, 0x0B, 0x47, 0x0E, 0x10, 0x0B, 0x1B, 0x06, 0x04, 0x3F, 0xF0, 0xD2,
	0xF0, 0xCD, 0x38, 0xE0, 0x85, 0xF8, 0xF7, 0x3A, 0x26, 0x75, 0x00, 0xD2, 0xF0, 0x33, 0x00, 0x27,
	0x71, 0x09, 0x06, 0x24, 0x30, 0xBD, 0x2C, 0x1D, 0x15, 0x00, 0xDB, 0x44, 0x33, 0x22, 0x00, 0x00,
	0x03, 0x30, 0x00, 0x00, 0x57, 0x00, 0x5D, 0x00, 0x18, 0x00, 0xFC, 0xC7, 0x2E, 0x1F, 0x00, 0x00,
	0x45, 0x00, 0x29, 0x09, 0x06, 0x18, 0x89, 0x30, 0x2F, 0x0B, 0x07, 0xDF, 0x34, 0x23, 0x21, 0xC0,
	0x81, 0x59, 0x15, 0x0E, 0x3C, 0xC0, 0x2A, 0x00, 0xF5, 0xC7, 0xE1, 0x34, 0x38, 0x23, 0x31, 0x0B,
	0x07, 0xC9, 0x2F, 0x1F, 0x33, 0x00, 0x80, 0x2D, 0x00, 0x1E, 0x90, 0x4D, 0x12, 0x0C, 0x2D, 0xC0,
	0x41, 0x0F, 0x23, 0x0A, 0x03, 0x30, 0x00, 0x00, 0xD9, 0x33, 0x22, 0xE7, 0x36, 0x06, 0x24, 0x06,
	0x00, 0xCB, 0x2F, 0x1F, 0x39, 0x30, 0x15, 0x05, 0x22, 0x03, 0x06, 0x60, 0x0F, 0xF0, 0x21, 0xF0,
	0x0F, 0x03, 0x02, 0x03, 0x00, 0x8E, 0xF9, 0x3A, 0x3C, 0xA0, 0x0F, 0xF0, 0x27, 0xF0, 0x3C, 0xF0,
	0x3C, 0xF0, 0x30, 0xF0, 0xFC, 0x3C, 0xF0, 0x3C, 0xF0, 0x0F, 0xF0, 0x27, 0xF0, 0x3C, 0xF0, 0x3C,
	0xF0, 0x30, 0xF0, 0x3C, 0xF0, 0xFF, 0x3C, 0xF0, 0x0F, 0xF0, 0x27, 0xF0, 0x3C, 0xF0, 0x3C, 0xF0,
	0x30, 0xF0, 0x3C, 0xF0, 0x3C, 0xF0, 0xFF, 0x0F, 0xF0, 0x27, 0xF0, 0x3C, 0xF0, 0x3C, 0xF0, 0x30,
	0xF0, 0x3C, 0xF0, 0x3C, 0xF0, 0x0F, 0xF0, 0xFF, 0x27, 0xF0, 0x3C, 0xF0, 0x3C, 0xF0, 0x30, 0xF0,
	0x3C, 0xF0, 0x3C, 0xF0, 0x0F, 0xF0, 0x27, 0xF0, 0xFF, 0x3C, 0xF0, 0x3C, 0xF0, 0x30, 0xF0, 0x3C,
	0xF0, 0x3C, 0xF0, 0x0F, 0xF0, 0x27, 0xF0, 0x3C, 0xF0, 0xFF, 0x3C, 0xF0, 0x30, 0xF0, 0x3C, 0xF0,
	0x3C, 0xF0, 0x0F, 0xF0, 0x27, 0xF0, 0x3C, 0xF0, 0x3C, 0xF0, 0xFF, 0x30, 0xF0, 0x3C, 0xF0, 0x3C,
	0xF0, 0x0F, 0xF0, 0x27, 0xF0, 0x3C, 0xF0, 0x3C, 0xF0, 0x30, 0xF0, 0xFF, 0x3C, 0xF0, 0x3C, 0xF0,
	0x0F, 0xF0, 0x27, 0xF0, 0x3C, 0xF0, 0x3C, 0xF0, 0x30, 0xF0, 0x3C, 0xF0, 0xFF, 0x3C, 0xF0, 0x0F,
	0xF0, 0x27, 0xF0, 0x3C, 0xF0, 0x3C, 0xF0, 0x30, 0xF0, 0x3C, 0xF0, 0x3C, 0xF0, 0xFF, 0x0F, 0xF0,
	0x27, 0xF0, 0x3C, 0xF0, 0x3C, 0xF0, 0x30, 0xF0, 0x3C, 0xF0, 0x3C, 0xF0, 0x0F, 0xF0, 0xFF, 0x27,
	0xF0, 0x3C, 0xF0, 0x3C, 0xF0, 0x30, 0xF0, 0x3C, 0xF0, 0x3C, 0xF0, 0x0F, 0xF0, 0x27, 0xF0, 0xFF,
	0x3C, 0xF0, 0x3C, 0xF0, 0x30, 0xF0, 0x3C, 0xF0, 0x84, 0x90, 0x3F, 0x00, 0x00, 0x00, 0x0F, 0xF0,
	0xFF, 0x09, 0x90, 0x03, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x02, 0x07, 0x01, 0xB1, 0x40,
	0x81, 0x20, 0x33, 0x0C, 0x08, 0x00, 0x00, 0x0F, 0xF0, 0xC6, 0x09, 0x90, 0x03, 0x30, 0x00, 0x00,
	0x0D, 0x03, 0x02, 0x2D, 0x0A, 0x07, 0x07, 0x75, 0x30, 0x39, 0x00, 0x00, 0x00, 0x0F, 0xF0, 0x0F,
	0xF0, 0x1B, 0xF0, 0x03, 0x00, 0xFE, 0x39, 0x00, 0xB1, 0x29, 0x1B, 0xF3, 0x39, 0x26, 0x00, 0x00,
	0x81, 0x0F, 0xF0, 0x09, 0x90, 0x03, 0x30, 0x00, 0x00, 0xFE, 0x3B, 0x27, 0xF5, 0x0F, 0x39, 0x26,
	0xB3, 0x2A, 0x1C, 0x17, 0x05, 0x03, 0x00, 0xFF, 0xE4, 0x02, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00,
	0x6A, 0x09, 0x00, 0x00
};

u8 *render_static_bootlogo()
{
	// Clear background.
	gfx_clear_grey(0x1B);

	// Set default logo.
	u8 *logo_buf = (void *)malloc(SZ_16K);
	blz_uncompress_srcdest(bootlogo_blz, sizeof(bootlogo_blz), logo_buf, BOOTLOGO_SIZE);
	gfx_set_rect_grey(logo_buf, BOOTLOGO_WIDTH, BOOTLOGO_HEIGHT, BOOTLOGO_X, BOOTLOGO_Y);

	return logo_buf;
}

bool render_ticker_logo(u32 boot_wait, u32 backlight)
{
	u32 btn = 0;

	u32 ticker_step_us = boot_wait * 1000000;
	ticker_step_us /= BOOTLOGO_HEIGHT;

	// Set default logo.
	u8 *logo_buf = render_static_bootlogo();

	// Clear line.
	u8 *grey = malloc(6 * BOOTLOGO_HEIGHT);
	memset(grey, 0x1B, 6 * BOOTLOGO_HEIGHT);
	gfx_set_rect_grey(grey, 6, BOOTLOGO_HEIGHT, 362, BOOTLOGO_Y);
	free(grey);

	// Enable backlight to show first frame.
	display_backlight_brightness(backlight, 1000);

	// Animated line as ticker.
	for (u32 i = 1; i <= BOOTLOGO_HEIGHT; i++)
	{
		// If only VOL- was pressed, exit.
		btn = btn_read_vol();
		if (btn == BTN_VOL_DOWN)
			break;

		// Wait before setting next tick.
		usleep(ticker_step_us);

		// Set next ticker progress.
		gfx_set_rect_grey(logo_buf + BOOTLOGO_WIDTH * (BOOTLOGO_HEIGHT - i) + 36, 6, 1, 362, BOOTLOGO_Y + BOOTLOGO_HEIGHT - i);
	}
	free(logo_buf);

	return (btn == BTN_VOL_DOWN);
}

bool render_ticker(u32 boot_wait, u32 backlight, bool no_ticker)
{
	u32 btn = 0;

	u32 ticker_step_us = boot_wait * 1000000;
	ticker_step_us /= 1280;

	// Save bottom lines.
	u32 *logo_line = (u32 *)malloc(1280 * sizeof(u32) * 2);
	for (u32 i = 1280; !no_ticker && i >= 1; i--)
	{
		logo_line[i - 1]        = gfx_ctxt.fb[i * gfx_ctxt.width - 2];
		logo_line[i - 1 + 1280] = gfx_ctxt.fb[i * gfx_ctxt.width - 1];
	}

	// Enable backlight to show first frame.
	display_backlight_brightness(backlight, 1000);

	// Animated line as ticker.
	for (u32 i = 1280; i >= 1; i--)
	{
		// If only VOL- was pressed, exit.
		btn = btn_read_vol();
		if (btn == BTN_VOL_DOWN)
			break;

		// Wait before setting next tick.
		usleep(ticker_step_us);

		// Set bottom lines ticker progress.
		if (!no_ticker)
		{
			gfx_ctxt.fb[i * gfx_ctxt.width - 2] = TXT_CLR_DEFAULT;
			gfx_ctxt.fb[i * gfx_ctxt.width - 1] = TXT_CLR_DEFAULT;
		}
	}

	// Restore bottom lines.
	for (u32 i = 1280; !no_ticker && i >= 1; i--)
	{
		gfx_ctxt.fb[i * gfx_ctxt.width - 2] = logo_line[i - 1];
		gfx_ctxt.fb[i * gfx_ctxt.width - 1] = logo_line[i - 1 + 1280];
	}
	free(logo_line);

	return (btn == BTN_VOL_DOWN);
}
