/*
 * Minerva Training Cell
 * DRAM Training for Tegra X1 SoC. Supports DDR2/3 and LPDDR3/4.
 *
 * Copyright (c) 2018 CTCaer  <ctcaer@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _MTC_MC_EMC_REGS_H_
#define _MTC_MC_EMC_REGS_H_

/* Clock controller registers */
#define CLK_RST_CONTROLLER_PLLM_BASE           0x90
#define CLK_RST_CONTROLLER_PLLM_MISC2          0x9C
#define  PLLM_ENABLE    (1 << 30)
#define  PLLM_LOCK      (1 << 27)
#define  PLLM_EN_LCKDET (1 << 4)

#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC      0x19C
#define  EMC_2X_CLK_SRC_SHIFT 29

#define CLK_RST_CONTROLLER_CLK_OUT_ENB_X       0x280
#define CLK_RST_CONTROLLER_CLK_ENB_X_SET       0x284
#define CLK_RST_CONTROLLER_CLK_ENB_X_CLR       0x288
#define CLK_RST_CONTROLLER_PLLMB_BASE          0x5E8
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_DLL  0x664
#define  EMC_DLL_PLLM_VCOB  (1 << 10)
#define  EMC_DLL_SWITCH_OUT (1 << 11)

#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_SAFE 0x724

/* Memory controller registers */
#define MC_EMEM_ADR_CFG               0x54
#define MC_EMEM_ARB_CFG               0x90
#define MC_EMEM_ARB_OUTSTANDING_REQ   0x94
#define MC_EMEM_ARB_TIMING_RCD        0x98
#define MC_EMEM_ARB_TIMING_RP         0x9C
#define MC_EMEM_ARB_TIMING_RC         0xA0
#define MC_EMEM_ARB_TIMING_RAS        0xA4
#define MC_EMEM_ARB_TIMING_FAW        0xA8
#define MC_EMEM_ARB_TIMING_RRD        0xAC
#define MC_EMEM_ARB_TIMING_RAP2PRE    0xB0
#define MC_EMEM_ARB_TIMING_WAP2PRE    0xB4
#define MC_EMEM_ARB_TIMING_R2R        0xB8
#define MC_EMEM_ARB_TIMING_W2W        0xBC
#define MC_EMEM_ARB_TIMING_R2W        0xC0
#define MC_EMEM_ARB_TIMING_W2R        0xC4
#define MC_EMEM_ARB_MISC2             0xC8
#define MC_EMEM_ARB_DA_TURNS          0xD0
#define MC_EMEM_ARB_DA_COVERS         0xD4
#define MC_EMEM_ARB_MISC0             0xD8
#define MC_EMEM_ARB_MISC1             0xDC
#define MC_EMEM_ARB_RING1_THROTTLE    0xE0

#define MC_LATENCY_ALLOWANCE_AVPC_0    0x2E4
#define MC_LATENCY_ALLOWANCE_HC_0      0x310
#define MC_LATENCY_ALLOWANCE_HC_1      0x314
#define MC_LATENCY_ALLOWANCE_MPCORE_0  0x320
#define MC_LATENCY_ALLOWANCE_NVENC_0   0x328
#define MC_LATENCY_ALLOWANCE_PPCS_0    0x344
#define MC_LATENCY_ALLOWANCE_PPCS_1    0x348
#define MC_LATENCY_ALLOWANCE_ISP2_0    0x370
#define MC_LATENCY_ALLOWANCE_ISP2_1    0x374
#define MC_LATENCY_ALLOWANCE_XUSB_0    0x37C
#define MC_LATENCY_ALLOWANCE_XUSB_1    0x380
#define MC_LATENCY_ALLOWANCE_TSEC_0    0x390
#define MC_LATENCY_ALLOWANCE_VIC_0     0x394
#define MC_LATENCY_ALLOWANCE_VI2_0     0x398
#define MC_LATENCY_ALLOWANCE_GPU_0     0x3AC
#define MC_LATENCY_ALLOWANCE_SDMMCA_0  0x3B8
#define MC_LATENCY_ALLOWANCE_SDMMCAA_0 0x3BC
#define MC_LATENCY_ALLOWANCE_SDMMC_0   0x3C0
#define MC_LATENCY_ALLOWANCE_SDMMCAB_0 0x3C4
#define MC_LATENCY_ALLOWANCE_NVDEC_0   0x3D8
#define MC_LATENCY_ALLOWANCE_GPU2_0    0x3E8

#define MC_MLL_MPCORER_PTSA_RATE  0x44C
#define MC_FTOP_PTSA_RATE         0x50C

#define MC_EMEM_ARB_TIMING_RFCPB      0x6C0
#define MC_EMEM_ARB_TIMING_CCDMW      0x6C4
#define MC_EMEM_ARB_REFPB_HP_CTRL     0x6F0
#define MC_EMEM_ARB_REFPB_BANK_CTRL   0x6F4

#define MC_PTSA_GRANT_DECREMENT       0x960

#define MC_EMEM_ARB_DHYST_CTRL           0xBCC
#define MC_EMEM_ARB_DHYST_TIMEOUT_UTIL_0 0xBD0
#define MC_EMEM_ARB_DHYST_TIMEOUT_UTIL_1 0xBD4
#define MC_EMEM_ARB_DHYST_TIMEOUT_UTIL_2 0xBD8
#define MC_EMEM_ARB_DHYST_TIMEOUT_UTIL_3 0xBDC
#define MC_EMEM_ARB_DHYST_TIMEOUT_UTIL_4 0xBE0
#define MC_EMEM_ARB_DHYST_TIMEOUT_UTIL_5 0xBE4
#define MC_EMEM_ARB_DHYST_TIMEOUT_UTIL_6 0xBE8
#define MC_EMEM_ARB_DHYST_TIMEOUT_UTIL_7 0xBEC

/* External Memory controller registers */
#define EMC_INTSTATUS                 0x0
#define  CLKCHANGE_COMPLETE_INT (1 << 4)

#define EMC_DBG                       0x8
#define EMC_CFG                       0xC
#define EMC_PIN                       0x24
#define EMC_TIMING_CONTROL            0x28
#define EMC_RC                        0x2C
#define EMC_RFC                       0x30
#define EMC_RAS                       0x34
#define EMC_RP                        0x38
#define EMC_R2W                       0x3C
#define EMC_W2R                       0x40
#define EMC_R2P                       0x44
#define EMC_W2P                       0x48
#define EMC_RD_RCD                    0x4C
#define EMC_WR_RCD                    0x50
#define EMC_RRD                       0x54
#define EMC_REXT                      0x58
#define EMC_WDV                       0x5C
#define EMC_QUSE                      0x60
#define EMC_QRST                      0x64
#define EMC_QSAFE                     0x68
#define EMC_RDV                       0x6C
#define EMC_REFRESH                   0x70
#define EMC_BURST_REFRESH_NUM         0x74
#define EMC_PDEX2WR                   0x78
#define EMC_PDEX2RD                   0x7C
#define EMC_PCHG2PDEN                 0x80
#define EMC_ACT2PDEN                  0x84
#define EMC_AR2PDEN                   0x88
#define EMC_RW2PDEN                   0x8C
#define EMC_TXSR                      0x90
#define EMC_TCKE                      0x94
#define EMC_TFAW                      0x98
#define EMC_TRPAB                     0x9C
#define EMC_TCLKSTABLE                0xA0
#define EMC_TCLKSTOP                  0xA4
#define EMC_TREFBW                    0xA8
#define EMC_TPPD                      0xAC
#define EMC_ODT_WRITE                 0xB0
#define EMC_PDEX2MRR                  0xB4
#define EMC_WEXT                      0xB8
#define EMC_RFC_SLR                   0xC0
#define EMC_MRS_WAIT_CNT2             0xC4
#define EMC_MRS_WAIT_CNT              0xC8
#define EMC_MRS                       0xCC
#define EMC_EMRS                      0xD0
#define EMC_REF                       0xD4
#define EMC_MRW                       0xE8
#define EMC_SELF_REF                  0xE0
#define EMC_MRR                       0xEC
#define EMC_FBIO_SPARE                0x100
#define EMC_FBIO_CFG5                 0x104
#define EMC_PDEX2CKE                  0x118
#define EMC_CKE2PDEN                  0x11C
#define EMC_MPC                       0x128
#define EMC_EMRS2                     0x12C
#define EMC_MRW2                      0x134
#define EMC_MRW3                      0x138
#define EMC_MRW4                      0x13C
#define EMC_R2R                       0x144
#define EMC_EINPUT                    0x14C
#define EMC_EINPUT_DURATION           0x150
#define EMC_PUTERM_EXTRA              0x154
#define EMC_TCKESR                    0x158
#define EMC_TPD                       0x15C
#define EMC_AUTO_CAL_CONFIG           0x2A4

#define EMC_EMC_STATUS                0x2B4
#define  TIMING_UPDATE_STALLED  (1 << 23)
#define  MRR_DIVLD              (1 << 20)
#define  IN_SELF_REFRESH_MASK   (3 << 8)
#define  IN_POWERDOWN_BOTH_MASK (3 << 4)
#define  IN_POWERDOWN_1DEV_MASK (1 << 4)
#define  REQ_FIFO_EMPTY         (1 << 0)

#define EMC_CFG_2                     0x2B8
#define EMC_CFG_DIG_DLL               0x2BC
#define EMC_CFG_DIG_DLL_PERIOD        0x2C0
#define EMC_DIG_DLL_STATUS            0x2C4
#define EMC_RDV_MASK                  0x2CC
#define EMC_WDV_MASK                  0x2D0
#define EMC_RDV_EARLY_MASK            0x2D4
#define EMC_RDV_EARLY                 0x2D8
#define EMC_AUTO_CAL_CONFIG8          0x2DC
#define EMC_ZCAL_INTERVAL             0x2E0
#define EMC_ZCAL_WAIT_CNT             0x2E4
#define EMC_ZQ_CAL                    0x2EC
#define EMC_FDPD_CTRL_DQ              0x310
#define EMC_FDPD_CTRL_CMD             0x314
#define EMC_PMACRO_CMD_BRICK_CTRL_FDPD     0x318
#define EMC_PMACRO_DATA_BRICK_CTRL_FDPD    0x31C
#define EMC_SCRATCH0                  0x324
#define EMC_PMACRO_BRICK_CTRL_RFU1    0x330
#define EMC_PMACRO_BRICK_CTRL_RFU2    0x334
#define EMC_TR_TIMING_0               0x3B4
#define EMC_TR_CTRL_0                 0x3B8
#define EMC_TR_CTRL_1                 0x3BC
#define EMC_SWITCH_BACK_CTRL          0x3C0
#define EMC_TR_RDV                    0x3C4
#define EMC_STALL_THEN_EXE_AFTER_CLKCHANGE 0x3CC
#define EMC_SEL_DPD_CTRL              0x3D8
#define EMC_PRE_REFRESH_REQ_CNT       0x3DC
#define EMC_DYN_SELF_REF_CONTROL      0x3E0
#define EMC_TXSRDLL                   0x3E4
#define EMC_CCFIFO_ADDR               0x3E8
#define EMC_CCFIFO_DATA               0x3EC
#define EMC_CCFIFO_STATUS             0x3F0
#define EMC_TR_QPOP                   0x3F4
#define EMC_TR_RDV_MASK               0x3F8
#define EMC_TR_QSAFE                  0x3FC
#define EMC_TR_QRST                   0x400
#define EMC_AUTO_CAL_CONFIG2          0x458
#define EMC_AUTO_CAL_CONFIG3          0x45C
#define EMC_TR_DVFS                   0x460
#define EMC_AUTO_CAL_CHANNEL          0x464
#define EMC_IBDLY                     0x468
#define EMC_OBDLY                     0x46c
#define EMC_TXDSRVTTGEN               0x480
#define EMC_WE_DURATION               0x48C
#define EMC_WS_DURATION               0x490
#define EMC_WEV                       0x494
#define EMC_WSV                       0x498
#define EMC_CFG_3                     0x49C
#define EMC_MRW6                      0x4A4
#define EMC_MRW7                      0x4A8
#define EMC_MRW8                      0x4AC
#define EMC_MRW14                     0x4C4
#define EMC_MRW15                     0x4D0
#define EMC_CFG_SYNC                  0x4D4
#define EMC_FDPD_CTRL_CMD_NO_RAMP     0x4D8
#define EMC_WDV_CHK                   0x4E0
#define EMC_CFG_PIPE_2                0x554
#define EMC_CFG_PIPE_CLK              0x558
#define EMC_CFG_PIPE_1                0x55C
#define EMC_CFG_PIPE                  0x560
#define EMC_QPOP                      0x564
#define EMC_QUSE_WIDTH                0x568
#define EMC_PUTERM_WIDTH              0x56C
#define EMC_AUTO_CAL_CONFIG7          0x574
#define EMC_REFCTRL2                  0x580
#define EMC_FBIO_CFG7                 0x584

#define EMC_DATA_BRLSHFT_0            0x588
#define  EMC_DATA_BRLSHFT_0_RANK0_BYTE0_DATA_BRLSHFT_SHIFT 0
#define  EMC_DATA_BRLSHFT_0_RANK0_BYTE1_DATA_BRLSHFT_SHIFT 3
#define  EMC_DATA_BRLSHFT_0_RANK0_BYTE2_DATA_BRLSHFT_SHIFT 6
#define  EMC_DATA_BRLSHFT_0_RANK0_BYTE3_DATA_BRLSHFT_SHIFT 9
#define  EMC_DATA_BRLSHFT_0_RANK0_BYTE4_DATA_BRLSHFT_SHIFT 12
#define  EMC_DATA_BRLSHFT_0_RANK0_BYTE5_DATA_BRLSHFT_SHIFT 15
#define  EMC_DATA_BRLSHFT_0_RANK0_BYTE6_DATA_BRLSHFT_SHIFT 18
#define  EMC_DATA_BRLSHFT_0_RANK0_BYTE7_DATA_BRLSHFT_SHIFT 21

#define EMC_DATA_BRLSHFT_1            0x58C
#define  EMC_DATA_BRLSHFT_1_RANK1_BYTE0_DATA_BRLSHFT_SHIFT 0
#define  EMC_DATA_BRLSHFT_1_RANK1_BYTE1_DATA_BRLSHFT_SHIFT 3
#define  EMC_DATA_BRLSHFT_1_RANK1_BYTE2_DATA_BRLSHFT_SHIFT 6
#define  EMC_DATA_BRLSHFT_1_RANK1_BYTE3_DATA_BRLSHFT_SHIFT 9
#define  EMC_DATA_BRLSHFT_1_RANK1_BYTE4_DATA_BRLSHFT_SHIFT 12
#define  EMC_DATA_BRLSHFT_1_RANK1_BYTE5_DATA_BRLSHFT_SHIFT 15
#define  EMC_DATA_BRLSHFT_1_RANK1_BYTE6_DATA_BRLSHFT_SHIFT 18
#define  EMC_DATA_BRLSHFT_1_RANK1_BYTE7_DATA_BRLSHFT_SHIFT 21

#define EMC_RFCPB                     0x590
#define EMC_DQS_BRLSHFT_0             0x594
#define EMC_DQS_BRLSHFT_1             0x598
#define EMC_CMD_BRLSHFT_0             0x59C
#define EMC_CMD_BRLSHFT_1             0x5A0
#define EMC_CMD_BRLSHFT_2             0x5A4
#define EMC_CMD_BRLSHFT_3             0x5A8
#define EMC_QUSE_BRLSHFT_0            0x5AC
#define EMC_AUTO_CAL_CONFIG4          0x5B0
#define EMC_AUTO_CAL_CONFIG5          0x5B4
#define EMC_QUSE_BRLSHFT_1            0x5B8
#define EMC_QUSE_BRLSHFT_2            0x5BC
#define EMC_CCDMW                     0x5C0
#define EMC_QUSE_BRLSHFT_3            0x5C4
#define EMC_AUTO_CAL_CONFIG6          0x5CC
#define EMC_DLL_CFG_0                 0x5E4
#define EMC_DLL_CFG_1                 0x5E8
#define EMC_CONFIG_SAMPLE_DELAY       0x5F0
#define EMC_CFG_UPDATE                0x5F4

#define EMC_PMACRO_QUSE_DDLL_RANK0_0 0x600
#define EMC_PMACRO_QUSE_DDLL_RANK0_1 0x604
#define EMC_PMACRO_QUSE_DDLL_RANK0_2 0x608
#define EMC_PMACRO_QUSE_DDLL_RANK0_3 0x60C
#define EMC_PMACRO_QUSE_DDLL_RANK0_4 0x610
#define EMC_PMACRO_QUSE_DDLL_RANK0_5 0x614
#define EMC_PMACRO_QUSE_DDLL_RANK1_4 0x630
#define EMC_PMACRO_QUSE_DDLL_RANK1_5 0x634
#define EMC_PMACRO_QUSE_DDLL_RANK1_0 0x620
#define EMC_PMACRO_QUSE_DDLL_RANK1_1 0x624
#define EMC_PMACRO_QUSE_DDLL_RANK1_2 0x628
#define EMC_PMACRO_QUSE_DDLL_RANK1_3 0x62C

#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_0 0x640
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_1 0x644
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_2 0x648
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_3 0x64C
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_4 0x650
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_5 0x654
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_0 0x660
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_1 0x664
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_2 0x668
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_3 0x66C
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_4 0x670
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_5 0x674

#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK0_0 0x680
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK0_1 0x684
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK0_2 0x688
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK0_3 0x68C
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK0_4 0x690
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK0_5 0x694
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK1_0 0x6A0
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK1_1 0x6A4
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK1_2 0x6A8
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK1_3 0x6AC
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK1_4 0x6B0
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK1_5 0x6B4

#define EMC_PMACRO_IB_DDLL_LONG_DQS_RANK0_0 0x6C0
#define EMC_PMACRO_IB_DDLL_LONG_DQS_RANK0_1 0x6C4
#define EMC_PMACRO_IB_DDLL_LONG_DQS_RANK0_2 0x6C8
#define EMC_PMACRO_IB_DDLL_LONG_DQS_RANK0_3 0x6CC
#define EMC_PMACRO_IB_DDLL_LONG_DQS_RANK1_0 0x6E0
#define EMC_PMACRO_IB_DDLL_LONG_DQS_RANK1_1 0x6E4
#define EMC_PMACRO_IB_DDLL_LONG_DQS_RANK1_2 0x6E8
#define EMC_PMACRO_IB_DDLL_LONG_DQS_RANK1_3 0x6EC

#define EMC_PMACRO_TX_PWRD_0 0x720
#define EMC_PMACRO_TX_PWRD_1 0x724
#define EMC_PMACRO_TX_PWRD_2 0x728
#define EMC_PMACRO_TX_PWRD_3 0x72C
#define EMC_PMACRO_TX_PWRD_4 0x730
#define EMC_PMACRO_TX_PWRD_5 0x734

#define EMC_PMACRO_TX_SEL_CLK_SRC_0 0x740
#define EMC_PMACRO_TX_SEL_CLK_SRC_1 0x744
#define EMC_PMACRO_TX_SEL_CLK_SRC_3 0x74C
#define EMC_PMACRO_TX_SEL_CLK_SRC_2 0x748
#define EMC_PMACRO_TX_SEL_CLK_SRC_4 0x750
#define EMC_PMACRO_TX_SEL_CLK_SRC_5 0x754

#define EMC_PMACRO_DDLL_BYPASS 0x760
#define EMC_PMACRO_DDLL_PWRD_0 0x770
#define EMC_PMACRO_DDLL_PWRD_1 0x774
#define EMC_PMACRO_DDLL_PWRD_2 0x778

#define EMC_PMACRO_CMD_CTRL_0 0x780
#define EMC_PMACRO_CMD_CTRL_1 0x784
#define EMC_PMACRO_CMD_CTRL_2 0x788

#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE0_0 0x800
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE0_1 0x804
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE0_2 0x808
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE0_3 0x80C
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE1_0 0x810
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE1_1 0x814
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE1_2 0x818
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE1_3 0x81C
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE2_0 0x820
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE2_1 0x824
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE2_2 0x828
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE2_3 0x82C
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE3_0 0x830
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE3_1 0x834
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE3_2 0x838
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE3_3 0x83C
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE4_0 0x840
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE4_1 0x844
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE4_2 0x848
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE4_3 0x84C
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE5_0 0x850
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE5_1 0x854
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE5_2 0x858
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE5_3 0x85C
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE6_0 0x860
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE6_1 0x864
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE6_2 0x868
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE6_3 0x86C
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE7_0 0x870
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE7_1 0x874
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE7_2 0x878
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE7_3 0x87C

#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD0_0 0x880
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD0_1 0x884
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD0_2 0x888
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD0_3 0x88C
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD1_0 0x890
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD1_1 0x894
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD1_2 0x898
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD1_3 0x89C
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD2_0 0x8A0
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD2_1 0x8A4
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD2_2 0x8A8
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD2_3 0x8AC
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD3_0 0x8B0
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD3_1 0x8B4
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD3_2 0x8B8
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD3_3 0x8BC

#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE0_0 0x900
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE0_1 0x904
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE0_2 0x908
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE0_3 0x90C
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE1_0 0x910
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE1_1 0x914
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE1_2 0x918
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE1_3 0x91C
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE2_0 0x920
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE2_1 0x924
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE2_2 0x928
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE2_3 0x92C
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE3_0 0x930
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE3_1 0x934
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE3_2 0x938
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE3_3 0x93C
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE4_0 0x940
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE4_1 0x944
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE4_2 0x948
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE4_3 0x94C
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE5_0 0x950
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE5_1 0x954
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE5_2 0x958
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE5_3 0x95C
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE6_0 0x960
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE6_1 0x964
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE6_2 0x968
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE6_3 0x96C
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE7_0 0x970
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE7_1 0x974
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE7_2 0x978
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE7_3 0x97C

#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD0_0 0x980
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD0_1 0x984
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD0_2 0x988
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD0_3 0x98C
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD1_0 0x990
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD1_1 0x994
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD1_2 0x998
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD1_3 0x99C
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD2_0 0x9A0
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD2_1 0x9A4
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD2_2 0x9A8
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD2_3 0x9AC
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD3_0 0x9B0
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD3_1 0x9B4
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD3_2 0x9B8
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD3_3 0x9BC

#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE0_0 0xA00
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE0_1 0xA04
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE0_2 0xA08
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE1_0 0xA10
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE1_1 0xA14
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE1_2 0xA18
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE2_0 0xA20
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE2_1 0xA24
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE2_2 0xA28
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE3_0 0xA30
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE3_1 0xA34
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE3_2 0xA38
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE4_0 0xA40
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE4_1 0xA44
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE4_2 0xA48
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE5_0 0xA50
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE5_1 0xA54
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE5_2 0xA58
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE6_0 0xA60
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE6_1 0xA64
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE6_2 0xA68
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE7_0 0xA70
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE7_1 0xA74
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE7_2 0xA78

#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE0_0 0xB00
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE0_1 0xB04
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE0_2 0xB08
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE1_0 0xB10
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE1_1 0xB14
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE1_2 0xB18
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE2_0 0xB20
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE2_1 0xB24
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE2_2 0xB28
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE3_0 0xB30
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE3_1 0xB34
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE3_2 0xB38
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE4_0 0xB40
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE4_1 0xB44
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE4_2 0xB48
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE5_0 0xB50
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE5_1 0xB54
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE5_2 0xB58
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE6_0 0xB60
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE6_1 0xB64
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE6_2 0xB68
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE7_0 0xB70
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE7_1 0xB74
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE7_2 0xB78

#define EMC_PMACRO_IB_VREF_DQ_0  0xBE0
#define EMC_PMACRO_IB_VREF_DQ_1  0xBE4
#define EMC_PMACRO_IB_VREF_DQS_0 0xBF0
#define EMC_PMACRO_IB_VREF_DQS_1 0xBF4

#define EMC_PMACRO_DDLL_LONG_CMD_0 0xC00
#define EMC_PMACRO_DDLL_LONG_CMD_1 0xC04
#define EMC_PMACRO_DDLL_LONG_CMD_2 0xC08
#define EMC_PMACRO_DDLL_LONG_CMD_3 0xC0C
#define EMC_PMACRO_DDLL_LONG_CMD_4 0xC10

#define EMC_PMACRO_DDLL_SHORT_CMD_0 0xC20
#define EMC_PMACRO_DDLL_SHORT_CMD_1 0xC24
#define EMC_PMACRO_DDLL_SHORT_CMD_2 0xC28

#define EMC_PMACRO_CFG_PM_GLOBAL_0    0xC30
#define EMC_PMACRO_VTTGEN_CTRL_0      0xC34
#define EMC_PMACRO_VTTGEN_CTRL_1      0xC38
#define EMC_PMACRO_BG_BIAS_CTRL_0     0xC3C
#define EMC_PMACRO_PAD_CFG_CTRL       0xC40
#define EMC_PMACRO_ZCTRL              0xC44
#define EMC_PMACRO_CMD_PAD_RX_CTRL    0xC50
#define EMC_PMACRO_DATA_PAD_RX_CTRL   0xC54
#define EMC_PMACRO_CMD_RX_TERM_MODE   0xC58
#define EMC_PMACRO_DATA_RX_TERM_MODE  0xC5C
#define EMC_PMACRO_CMD_PAD_TX_CTRL    0xC60
#define EMC_PMACRO_DATA_PAD_TX_CTRL   0xC64
#define EMC_PMACRO_COMMON_PAD_TX_CTRL 0xC68
#define EMC_PMACRO_AUTOCAL_CFG_COMMON 0xC78
#define EMC_PMACRO_VTTGEN_CTRL_2      0xCF0
#define EMC_PMACRO_IB_RXRT            0xCF4
#define EMC_PMACRO_TRAINING_CTRL_0    0xCF8
#define  CH0_TRAINING_E_WRPTR (1 << 3)
#define EMC_PMACRO_TRAINING_CTRL_1    0xCFC

#define EMC_TRAINING_CMD              0xE00
#define EMC_TRAINING_CTRL             0xE04
#define EMC_TRAINING_STATUS           0xE08
#define EMC_TRAINING_QUSE_CORS_CTRL   0xE0C
#define EMC_TRAINING_QUSE_FINE_CTRL   0xE10
#define EMC_TRAINING_QUSE_CTRL_MISC   0xE14
#define EMC_TRAINING_WRITE_FINE_CTRL  0xE18
#define EMC_TRAINING_WRITE_CTRL_MISC  0xE1C
#define EMC_TRAINING_WRITE_VREF_CTRL  0xE20
#define EMC_TRAINING_READ_FINE_CTRL   0xE24
#define EMC_TRAINING_READ_CTRL_MISC   0xE28
#define EMC_TRAINING_READ_VREF_CTRL   0xE2C
#define EMC_TRAINING_CA_FINE_CTRL     0xE30
#define EMC_TRAINING_CA_CTRL_MISC     0xE34
#define EMC_TRAINING_CA_CTRL_MISC1    0xE38
#define EMC_TRAINING_CA_VREF_CTRL     0xE3C
#define EMC_TRAINING_SETTLE           0xE44
#define EMC_TRAINING_MPC              0xE5C
#define EMC_TRAINING_PATRAM_CTRL      0xE60
#define EMC_TRAINING_PATRAM_DQ        0xE64
#define EMC_TRAINING_PATRAM_DMI       0xE68
#define EMC_TRAINING_VREF_SETTLE      0xE6C
#define EMC_TRAINING_OPT_CA_VREF      0xEC0
#define EMC_TRAINING_OPT_DQ_OB_VREF   0xEC4
#define EMC_TRAINING_QUSE_VREF_CTRL   0xED0
#define EMC_TRAINING_OPT_DQS_IB_VREF_RANK0 0xED4
#define EMC_TRAINING_OPT_DQS_IB_VREF_RANK1 0xED8

/* Per channel registers offsets. Should be used with EMC_BASE */
#define EMC0_MRW10 0x34B4
#define EMC0_MRW11 0x34B8
#define EMC0_MRW12 0x34BC
#define EMC0_MRW13 0x34C0
#define EMC0_DATA_BRLSHFT_0 0x3588
#define EMC0_DATA_BRLSHFT_1 0x358C
#define EMC0_CMD_BRLSHFT_0  0x359C
#define EMC0_QUSE_BRLSHFT_0 0x35AC
#define EMC0_QUSE_BRLSHFT_2 0x35BC
#define EMC0_TRAINING_RW_OFFSET_IB_BYTE0 0x3E98
#define EMC0_TRAINING_RW_OFFSET_IB_BYTE1 0x3E9C
#define EMC0_TRAINING_RW_OFFSET_IB_BYTE2 0x3EA0
#define EMC0_TRAINING_RW_OFFSET_IB_BYTE3 0x3EA4
#define EMC0_TRAINING_RW_OFFSET_IB_MISC  0x3EA8
#define EMC0_TRAINING_RW_OFFSET_OB_BYTE0 0x3EAC
#define EMC0_TRAINING_RW_OFFSET_OB_BYTE1 0x3EB0
#define EMC0_TRAINING_RW_OFFSET_OB_BYTE2 0x3EB4
#define EMC0_TRAINING_RW_OFFSET_OB_BYTE3 0x3EB8
#define EMC0_TRAINING_RW_OFFSET_OB_MISC  0x3EBC
#define EMC0_TRAINING_OPT_DQS_IB_VREF_RANK0 0x3ED4
#define EMC0_TRAINING_OPT_DQS_IB_VREF_RANK1 0x3ED8

#define EMC1_MRW10 0x44B4
#define EMC1_MRW11 0x44B8
#define EMC1_MRW12 0x44BC
#define EMC1_MRW13 0x44C0
#define EMC1_DATA_BRLSHFT_0 0x4588
#define EMC1_DATA_BRLSHFT_1 0x458C
#define EMC1_CMD_BRLSHFT_1  0x45A0
#define EMC1_QUSE_BRLSHFT_1 0x45B8
#define EMC1_QUSE_BRLSHFT_3 0x45C4
#define EMC1_TRAINING_RW_OFFSET_IB_BYTE0 0x4E98
#define EMC1_TRAINING_RW_OFFSET_IB_BYTE1 0x4E9C
#define EMC1_TRAINING_RW_OFFSET_IB_BYTE2 0x4EA0
#define EMC1_TRAINING_RW_OFFSET_IB_BYTE3 0x4EA4
#define EMC1_TRAINING_RW_OFFSET_IB_MISC  0x4EA8
#define EMC1_TRAINING_RW_OFFSET_OB_BYTE0 0x4EAC
#define EMC1_TRAINING_RW_OFFSET_OB_BYTE1 0x4EB0
#define EMC1_TRAINING_RW_OFFSET_OB_BYTE2 0x4EB4
#define EMC1_TRAINING_RW_OFFSET_OB_BYTE3 0x4EB8
#define EMC1_TRAINING_RW_OFFSET_OB_MISC  0x4EBC
#define EMC1_TRAINING_OPT_DQS_IB_VREF_RANK0 0x4ED4
#define EMC1_TRAINING_OPT_DQS_IB_VREF_RANK1 0x4ED8

#define EMC_PMACRO_OB_DDLL_LONG_DQ_BYTE0_SHIFT 0
#define EMC_PMACRO_OB_DDLL_LONG_DQ_BYTE1_SHIFT 16
#define EMC_PMACRO_OB_DDLL_LONG_DQ_BYTE2_SHIFT 0
#define EMC_PMACRO_OB_DDLL_LONG_DQ_BYTE3_SHIFT 16
#define EMC_PMACRO_OB_DDLL_LONG_DQ_BYTE4_SHIFT 0
#define EMC_PMACRO_OB_DDLL_LONG_DQ_BYTE5_SHIFT 16
#define EMC_PMACRO_OB_DDLL_LONG_DQ_BYTE6_SHIFT 0
#define EMC_PMACRO_OB_DDLL_LONG_DQ_BYTE7_SHIFT 16

#endif