---
name: Feature Request
about: Suggest a new feature for Atmosphère.
#assignees:
---

## Feature Request

[ If any section does not apply, replace its contents with "N/A". ]</br>
[ If you do not have the information needed for a section, replace its contents with "Unknown". ]</br>
[ Lines between [ ] (square brackets) are to be removed before posting. ]

[ Please search for existing [feature requests](https://github.com/Atmosphere-NX/Atmosphere/issues?utf8=%E2%9C%93&q=is%3Aissue+label%3A%22features%2Ffeature-request%22) before you make your own request. ]</br>
[ Duplicate requests will be marked as such and you will be referred to the original request. ]

### What feature are you suggesting?
#### Overview:
- [ Include the basic, high-level concepts for this feature here. ]</br>

#### Smaller Details: 
- [ These may include specific methods of implementation etc. ]</br>

#### Nature of Request:  
[ Remove all that do not apply to your request. ]
- Addition
  - [ Ex: Addition of certain original features or features from other community projects. ]
  - [ If you are suggesting porting features or including features from other projects, include what license they are distributed under and what, if any libraries those project use. ]
- Change
- Removal
  - [Ex: Removal of certain features or implementation due to a specific issue/bug or because of low quality code, etc.]

### What component do you feel this would best fit within?
- [Fusée](https://github.com/Atmosphere-NX/Atmosphere#components)</br>
  - Atmosphère's custom bootloader.</br>
- [Exosphère](https://github.com/Atmosphere-NX/Atmosphere#components)</br>
  - Fully-featured custom secure monitor.</br>
- [Stratosphère](https://github.com/Atmosphere-NX/Atmosphere#components)</br>
    - Custom system modules.</br>
- [**Thermosphère**](https://github.com/Atmosphere-NX/Atmosphere#components)</br>
  - Atmosphère's emuNAND implementation.</br>
- [**Troposphère**](https://github.com/Atmosphere-NX/Atmosphere#components)</br>
  - Application-level patches to the Horizon OS.</br>

[ Note: **Bolded components are not implemented** or are still at the prototyping phase. ]

### Why would this feature be useful?
[ If this is a feature for an end-user, how does it benefit the end-user? ]</br>
[ If this feature is for developers, what does it add to Atmosphère that did not already exist? ]</br>
