/*
 * Copyright (c) Atmosphère-NX
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

constexpr const u8 T210b01SdevEmcDvfsTableM4gb03[0x681] = {
    0xFF, 0x18, 0x03, 0x00, 0x00, 0x00, 0x30, 0x31, 0x5F, 0x32, 0x30, 0x34, 0x30, 0x30, 0x30, 0x5F,
    0x4E, 0x6F, 0x43, 0x66, 0x67, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6F, 0x6E, 0x5F, 0x56, 0x30, 0x2E,
    0x34, 0x2E, 0x32, 0x5F, 0x56, 0x32, 0x2E, 0x30, 0x00, 0x01, 0x00, 0x06, 0x71, 0xE0, 0x1C, 0x03,
    0x00, 0x4C, 0x04, 0x00, 0x04, 0x00, 0x8F, 0x70, 0x6C, 0x6C, 0x70, 0x5F, 0x6F, 0x75, 0x74, 0x2F,
    0x00, 0x05, 0x5F, 0x02, 0x80, 0x18, 0x40, 0x00, 0x01, 0x00, 0x40, 0xFF, 0x1E, 0x3F, 0x3A, 0x00,
    0x00, 0x0D, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
    0x00, 0x8A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
    0x00, 0x04, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x05, 0x50, 0x00, 0x10, 0x17, 0x0A, 0x04,
    0x00, 0x22, 0x01, 0x00, 0x5C, 0x00, 0x57, 0x3A, 0x00, 0x00, 0x00, 0x1D, 0x24, 0x00, 0x13, 0x09,
    0x54, 0x00, 0x13, 0x0B, 0x20, 0x00, 0x13, 0x08, 0x0C, 0x00, 0x13, 0x00, 0x18, 0x00, 0x53, 0x17,
    0x00, 0x00, 0x00, 0x15, 0x08, 0x00, 0x13, 0x1B, 0x18, 0x00, 0x57, 0x20, 0x00, 0x00, 0x00, 0x06,
    0x04, 0x00, 0x13, 0x03, 0x18, 0x00, 0x13, 0x06, 0x34, 0x00, 0x17, 0x02, 0x40, 0x00, 0x00, 0x50,
    0x00, 0x13, 0x0E, 0xB0, 0x00, 0x18, 0x06, 0x44, 0x01, 0x74, 0x00, 0x00, 0x00, 0x31, 0x31, 0x03,
    0x88, 0xF0, 0x00, 0x40, 0x00, 0x00, 0x00, 0x80, 0x0A, 0x00, 0x13, 0x12, 0xE8, 0x00, 0x54, 0x1A,
    0x00, 0x00, 0x00, 0x16, 0xF4, 0x00, 0x03, 0x61, 0x00, 0x13, 0xC1, 0x50, 0x00, 0x13, 0x08, 0x74,
    0x00, 0x13, 0x0A, 0x08, 0x00, 0x04, 0x10, 0x01, 0x13, 0x02, 0xC4, 0x00, 0x13, 0x3B, 0x04, 0x00,
    0x13, 0x05, 0x04, 0x00, 0x13, 0x04, 0xE8, 0x00, 0x08, 0x0C, 0x00, 0x53, 0x31, 0x31, 0x03, 0xC8,
    0x1C, 0x58, 0x00, 0x40, 0x0D, 0xA0, 0x60, 0x91, 0x7C, 0x01, 0x31, 0xA0, 0x00, 0x2C, 0x86, 0x00,
    0x11, 0x78, 0x16, 0x00, 0x2F, 0xFF, 0x0F, 0x56, 0x01, 0x03, 0xF1, 0x0C, 0x0B, 0x88, 0x16, 0x00,
    0x0D, 0x00, 0x0B, 0x00, 0x17, 0x00, 0x43, 0x00, 0x45, 0x00, 0x45, 0x00, 0x43, 0x00, 0x46, 0x00,
    0x47, 0x00, 0x41, 0x00, 0x46, 0x00, 0x0C, 0x8E, 0x00, 0x1F, 0x0D, 0x18, 0x00, 0x06, 0x20, 0x16,
    0x00, 0x3A, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x3E, 0x00, 0x11, 0x17, 0xE0, 0x00, 0x0F, 0x01, 0x00,
    0x8D, 0x80, 0x1F, 0x22, 0x20, 0x80, 0x0F, 0xF4, 0x20, 0x02, 0x98, 0x01, 0xF0, 0x0E, 0x00, 0x40,
    0x06, 0x00, 0xCC, 0x00, 0x09, 0x00, 0x10, 0x00, 0xCC, 0x00, 0x0A, 0x00, 0x33, 0x00, 0x02, 0x03,
    0xE0, 0xC1, 0x20, 0x41, 0x13, 0x1F, 0x14, 0x00, 0x01, 0x00, 0x99, 0x5C, 0x01, 0x60, 0x08, 0x00,
    0x00, 0x50, 0x50, 0x50, 0x22, 0x02, 0x10, 0xF3, 0x40, 0x01, 0x57, 0x13, 0x07, 0x00, 0x80, 0x0A,
    0x4C, 0x00, 0x13, 0x12, 0x04, 0x00, 0x11, 0x00, 0xB8, 0x01, 0x11, 0x05, 0x9F, 0x01, 0x23, 0x10,
    0x02, 0x51, 0x02, 0x00, 0xE4, 0x02, 0x13, 0x04, 0x92, 0x02, 0x2F, 0x34, 0x10, 0x90, 0x00, 0x06,
    0x03, 0x79, 0x03, 0x09, 0x21, 0x00, 0x9F, 0x80, 0x00, 0x40, 0x00, 0x04, 0x10, 0x80, 0x00, 0x20,
    0xC9, 0x00, 0x09, 0x34, 0xEF, 0x00, 0xEF, 0x0B, 0x00, 0x48, 0x1C, 0x1C, 0x1C, 0x1C, 0x1B, 0x00,
    0x22, 0x10, 0x10, 0x04, 0x00, 0x44, 0x33, 0x60, 0x18, 0x01, 0x14, 0x00, 0x13, 0x18, 0x60, 0x02,
    0x00, 0x88, 0x02, 0x42, 0x14, 0x14, 0x16, 0x88, 0xB8, 0x00, 0xF0, 0x07, 0x01, 0x00, 0x80, 0x90,
    0x00, 0x00, 0x04, 0x04, 0x07, 0x07, 0x65, 0x00, 0x04, 0x00, 0x1F, 0x80, 0x13, 0x05, 0x00, 0x11,
    0x10, 0x1F, 0x80, 0x02, 0xF0, 0x0F, 0x40, 0x72, 0x10, 0x00, 0x00, 0x40, 0x12, 0x01, 0x6A, 0x5B,
    0x12, 0x01, 0x00, 0x10, 0x08, 0x0F, 0x00, 0x58, 0x10, 0x00, 0x00, 0xFC, 0x10, 0x11, 0x00, 0x13,
    0x08, 0x0F, 0x50, 0x7C, 0x0C, 0x00, 0xF3, 0x07, 0x14, 0x11, 0x00, 0x03, 0x00, 0x07, 0x4C, 0x72,
    0x10, 0x00, 0x5A, 0x3C, 0x55, 0x55, 0x14, 0x14, 0x16, 0xC8, 0x5D, 0x5D, 0x0C, 0x88, 0x04, 0x00,
    0x12, 0xC8, 0x04, 0x00, 0x23, 0x0E, 0x8C, 0x04, 0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F, 0xB0, 0x03,
    0xFF, 0x09, 0x1F, 0x99, 0xB0, 0x03, 0xFF, 0x5E, 0x72, 0x00, 0x80, 0x06, 0x06, 0x00, 0x00, 0x05,
    0x13, 0x02, 0x0F, 0xB0, 0x03, 0x78, 0x00, 0x8C, 0x02, 0x10, 0x1F, 0x24, 0x00, 0x03, 0x68, 0x02,
    0x13, 0x1E, 0xB0, 0x03, 0x1F, 0x10, 0xB0, 0x03, 0x40, 0x0F, 0x90, 0x03, 0x09, 0x13, 0x0E, 0x04,
    0x00, 0x0F, 0x90, 0x03, 0x21, 0x13, 0x13, 0x04, 0x00, 0x0F, 0x90, 0x03, 0x14, 0x22, 0x30, 0x02,
    0x04, 0x00, 0x0F, 0x90, 0x03, 0x00, 0x1F, 0x04, 0x40, 0x07, 0xFF, 0xFF, 0x70, 0x1F, 0x01, 0x40,
    0x07, 0x0A, 0x4F, 0x04, 0x00, 0x80, 0xB0, 0x90, 0x03, 0x37, 0x2F, 0x28, 0x00, 0x02, 0x00, 0x0B,
    0x0F, 0x01, 0x00, 0xAD, 0x1B, 0x29, 0x01, 0x00, 0x0C, 0x20, 0x00, 0x04, 0x48, 0x03, 0x0F, 0x01,
    0x00, 0xFF, 0x16, 0x39, 0x49, 0x92, 0x24, 0x04, 0x00, 0x0F, 0x01, 0x00, 0x0D, 0x00, 0xB4, 0x02,
    0x40, 0x04, 0x01, 0x00, 0x00, 0x16, 0x0A, 0x1B, 0x18, 0x10, 0x09, 0x05, 0x50, 0x03, 0x5A, 0x42,
    0x0F, 0x00, 0x60, 0x09, 0x14, 0x00, 0x1E, 0x01, 0x0C, 0x00, 0x0F, 0xFC, 0x00, 0x6E, 0xF5, 0x02,
    0x01, 0x00, 0x00, 0x08, 0x4C, 0x00, 0x00, 0x80, 0x20, 0x10, 0x0A, 0x00, 0x28, 0x10, 0x00, 0x80,
    0x01, 0x48, 0x04, 0x02, 0xA4, 0x00, 0x17, 0x02, 0x08, 0x00, 0x13, 0x05, 0x0C, 0x00, 0x17, 0x01,
    0x84, 0x06, 0x00, 0x14, 0x00, 0x12, 0x07, 0x0A, 0x0A, 0xD3, 0x02, 0x01, 0x02, 0x03, 0x00, 0x04,
    0x05, 0xA3, 0x72, 0x0F, 0x0F, 0x00, 0x70, 0xE6, 0x04, 0x4F, 0x00, 0x1A, 0x00, 0x80, 0x04, 0x00,
    0x0E, 0x11, 0x1B, 0x10, 0x04, 0xF1, 0x02, 0x80, 0x00, 0x4C, 0x02, 0x00, 0x00, 0xB2, 0x00, 0xFF,
    0x00, 0xDA, 0x00, 0xFF, 0x00, 0x9D, 0x00, 0xFF, 0x02, 0x00, 0x17, 0x0C, 0x08, 0x00, 0xF1, 0x02,
    0x49, 0x00, 0x7F, 0x00, 0x80, 0x00, 0xFF, 0x00, 0x04, 0x00, 0xFF, 0x00, 0xAD, 0x00, 0x08, 0x00,
    0xFF, 0x88, 0x00, 0x33, 0xFF, 0x00, 0xC6, 0x04, 0x00, 0x13, 0x6D, 0x2C, 0x00, 0x11, 0xE2, 0x06,
    0x00, 0x01, 0x73, 0x06, 0x01, 0x0A, 0x00, 0x13, 0x14, 0xC0, 0x06, 0x2E, 0xF4, 0x01, 0x78, 0x01,
    0x13, 0x08, 0x44, 0x0F, 0x0F, 0x23, 0x01, 0x08, 0x1F, 0xC0, 0x0C, 0x00, 0x04, 0x06, 0xE8, 0x04,
    0x05, 0x98, 0x07, 0xA0, 0x01, 0x88, 0x00, 0x00, 0x02, 0x88, 0x00, 0x00, 0x0D, 0x88, 0x2C, 0x00,
    0x00, 0xB4, 0x0B, 0x08, 0x28, 0x00, 0xA0, 0xD8, 0x51, 0x1A, 0xA0, 0x00, 0x00, 0x50, 0x05, 0x00,
    0x00, 0x1F, 0x00, 0x31, 0x88, 0x00, 0x20, 0xFD, 0x04, 0x15, 0x88, 0x04, 0x00, 0x50, 0x25, 0x08,
    0x11, 0x00, 0x0C, 0x46, 0x00, 0x07, 0x50, 0x10, 0x00, 0x0C, 0x00, 0x26, 0x5C, 0x0D, 0x94, 0x01,
    0x7F, 0x30, 0x31, 0x5F, 0x31, 0x36, 0x30, 0x30, 0xCD, 0x10, 0x23, 0x28, 0x6A, 0x18, 0xCC, 0x10,
    0x4F, 0x6D, 0x5F, 0x75, 0x64, 0x2C, 0x00, 0x07, 0x21, 0x80, 0x18, 0x0C, 0x02, 0x2F, 0xF0, 0x02,
    0xB4, 0x02, 0x3B, 0x22, 0xFF, 0x3B, 0x6C, 0x06, 0x0F, 0xCC, 0x10, 0x45, 0x10, 0x60, 0x79, 0x01,
    0x47, 0x01, 0x00, 0x00, 0xE0, 0x24, 0x00, 0x13, 0x44, 0x9C, 0x09, 0x13, 0x2A, 0x64, 0x00, 0x57,
    0x0C, 0x00, 0x00, 0x00, 0x2D, 0x4C, 0x09, 0x00, 0xBC, 0x09, 0x97, 0x23, 0x00, 0x00, 0x00, 0x3E,
    0x00, 0x00, 0x00, 0x41, 0x8C, 0x09, 0x13, 0x1D, 0x04, 0x00, 0x13, 0x10, 0x98, 0x00, 0x13, 0x16,
    0xEC, 0x03, 0x13, 0x0E, 0x44, 0x00, 0x17, 0x0A, 0xDC, 0x09, 0x13, 0x0E, 0x44, 0x00, 0x12, 0x09,
    0xD0, 0x09, 0x00, 0x7F, 0x07, 0x10, 0x10, 0xBC, 0x09, 0x57, 0xF1, 0xF1, 0x03, 0x88, 0x1D, 0x8C,
    0x09, 0x93, 0x0B, 0x00, 0x06, 0x00, 0x33, 0x00, 0x00, 0x00, 0x39, 0x4C, 0x09, 0x13, 0x37, 0x0C,
    0x00, 0x23, 0x20, 0x18, 0x90, 0x02, 0x12, 0x06, 0x70, 0x00, 0x13, 0x10, 0xF0, 0x01, 0x13, 0x17,
    0x08, 0x00, 0x13, 0x38, 0x64, 0x00, 0x00, 0x8F, 0x01, 0x62, 0x2E, 0x00, 0x00, 0x00, 0xCC, 0x01,
    0x04, 0x00, 0x13, 0x0D, 0x9C, 0x00, 0x13, 0x0C, 0xC4, 0x07, 0x17, 0x22, 0x40, 0x01, 0x66, 0xF1,
    0xF1, 0x03, 0xC8, 0x60, 0x18, 0x8C, 0x09, 0x00, 0x7C, 0x01, 0x4F, 0xBB, 0x01, 0x00, 0xC0, 0x8C,
    0x09, 0x0D, 0xD3, 0x06, 0x06, 0x0B, 0x88, 0x0D, 0x00, 0x08, 0x00, 0x06, 0x00, 0x0E, 0x00, 0x06,
    0x88, 0x01, 0x13, 0x03, 0xC0, 0x0A, 0x11, 0x07, 0x82, 0x00, 0x1F, 0x08, 0x18, 0x00, 0x06, 0x00,
    0x88, 0x09, 0x11, 0x08, 0x20, 0x00, 0x00, 0x3E, 0x00, 0x3F, 0x0E, 0x00, 0x0D, 0x8C, 0x09, 0xA0,
    0xD0, 0x40, 0x06, 0x31, 0x00, 0x2F, 0x00, 0x40, 0x06, 0x17, 0x00, 0x90, 0x01, 0x09, 0x8C, 0x09,
    0x12, 0x61, 0x8C, 0x09, 0x5B, 0xB0, 0x04, 0x00, 0x00, 0x0D, 0x8C, 0x09, 0x5F, 0x8C, 0x30, 0x00,
    0x80, 0x2B, 0x1C, 0x0D, 0x05, 0x21, 0x00, 0x06, 0xCB, 0x0B, 0x13, 0x11, 0x8C, 0x09, 0x81, 0x84,
    0x10, 0x02, 0x40, 0x85, 0x14, 0x02, 0x40, 0x26, 0x02, 0x1F, 0x20, 0x8C, 0x09, 0x40, 0x1F, 0x00,
    0x8C, 0x09, 0x0F, 0x26, 0x90, 0x61, 0xCC, 0x10, 0x00, 0x78, 0x02, 0x13, 0x2B, 0x88, 0x02, 0x00,
    0x8C, 0x09, 0x11, 0x33, 0xCC, 0x01, 0x15, 0x06, 0x1C, 0x0D, 0x2F, 0x20, 0x03, 0x8C, 0x09, 0x14,
    0x53, 0x53, 0x08, 0x0F, 0x10, 0x42, 0x8C, 0x09, 0x5F, 0x43, 0x00, 0x07, 0x06, 0x23, 0xCC, 0x10,
    0x07, 0x43, 0x48, 0x48, 0x0E, 0x8C, 0x04, 0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F, 0xB0, 0x03, 0xFF,
    0x09, 0x1F, 0x99, 0xB0, 0x03, 0xFF, 0x5F, 0x01, 0xCC, 0x10, 0x03, 0xCF, 0x09, 0x0F, 0xB0, 0x03,
    0x78, 0x04, 0xCC, 0x10, 0x13, 0x3F, 0xB0, 0x03, 0x1F, 0x41, 0xB0, 0x03, 0x48, 0x0F, 0x90, 0x03,
    0x0D, 0x1F, 0x22, 0x40, 0x07, 0xFF, 0xFF, 0xF2, 0x1F, 0x01, 0x40, 0x07, 0x0D, 0x1F, 0xB0, 0x90,
    0x03, 0x37, 0x2F, 0x20, 0x00, 0x02, 0x00, 0x0A, 0x0F, 0xCC, 0x10, 0xBE, 0xF4, 0x01, 0x27, 0x00,
    0x21, 0x00, 0x27, 0x00, 0x20, 0x00, 0x26, 0x00, 0x23, 0x00, 0x2A, 0x00, 0x22, 0x00, 0x48, 0x03,
    0x0C, 0x18, 0x00, 0x0F, 0x01, 0x00, 0xFF, 0x36, 0x08, 0xCC, 0x10, 0x16, 0x07, 0x33, 0x14, 0x0F,
    0xCC, 0x10, 0xA2, 0x12, 0x0C, 0xF4, 0x0F, 0x05, 0xCC, 0x10, 0x13, 0x06, 0x9C, 0x10, 0x00, 0xC3,
    0x05, 0x13, 0x0F, 0x04, 0x00, 0x13, 0x03, 0x04, 0x00, 0x17, 0x0D, 0xCC, 0x10, 0x13, 0x0C, 0x84,
    0x06, 0x13, 0x0A, 0x50, 0x06, 0xBF, 0x00, 0x00, 0x06, 0x05, 0x0C, 0x08, 0x0D, 0x00, 0x19, 0x24,
    0x6C, 0xCC, 0x10, 0x1E, 0x13, 0xD0, 0xCC, 0x10, 0xF7, 0x06, 0x03, 0x12, 0x00, 0x00, 0x3D, 0x00,
    0x80, 0x00, 0x38, 0x00, 0x80, 0x00, 0x41, 0x00, 0x80, 0x00, 0x90, 0x00, 0x80, 0x00, 0x05, 0x08,
    0x00, 0x70, 0x49, 0x00, 0x34, 0x00, 0x80, 0x00, 0x80, 0xFA, 0x14, 0x62, 0x00, 0x16, 0x00, 0x08,
    0x00, 0x80, 0x06, 0x15, 0x23, 0x00, 0x19, 0x04, 0x00, 0x91, 0x18, 0x00, 0x80, 0x00, 0x95, 0x00,
    0x80, 0x00, 0x1D, 0x26, 0x00, 0x31, 0x00, 0x00, 0x2C, 0xDC, 0x00, 0x11, 0x80, 0x98, 0x06, 0x17,
    0x08, 0xCC, 0x10, 0x17, 0x09, 0xBC, 0x17, 0x1F, 0x00, 0xCC, 0x10, 0x10, 0x79, 0x56, 0x01, 0x55,
    0x05, 0x55, 0x05, 0x02, 0x0C, 0x00, 0x00, 0x48, 0x00, 0x04, 0x45, 0x14, 0x13, 0x2F, 0x08, 0x00,
    0x57, 0x54, 0x00, 0x01, 0x88, 0x2D, 0xCC, 0x10, 0x2F, 0x48, 0x48, 0xCC, 0x10, 0x1B, 0x1B, 0x35,
    0xCC, 0x10, 0x00, 0x50, 0x10, 0x00, 0x07, 0x00, 0x80, 0x9C, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00,
};

constexpr const u8 T210b01SdevEmcDvfsTableS4gb01[0x67B] = {
    0xFF, 0x18, 0x03, 0x00, 0x00, 0x00, 0x30, 0x31, 0x5F, 0x32, 0x30, 0x34, 0x30, 0x30, 0x30, 0x5F,
    0x4E, 0x6F, 0x43, 0x66, 0x67, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6F, 0x6E, 0x5F, 0x56, 0x30, 0x2E,
    0x33, 0x2E, 0x31, 0x5F, 0x56, 0x32, 0x2E, 0x30, 0x00, 0x01, 0x00, 0x06, 0x71, 0xE0, 0x1C, 0x03,
    0x00, 0x4C, 0x04, 0x00, 0x04, 0x00, 0x8F, 0x70, 0x6C, 0x6C, 0x70, 0x5F, 0x6F, 0x75, 0x74, 0x2F,
    0x00, 0x05, 0x5F, 0x02, 0x80, 0x18, 0x40, 0x00, 0x01, 0x00, 0x40, 0xFF, 0x1E, 0x3F, 0x3A, 0x00,
    0x00, 0x0D, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
    0x00, 0x8A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
    0x00, 0x04, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x05, 0x50, 0x00, 0x10, 0x17, 0x0A, 0x04,
    0x00, 0x22, 0x01, 0x00, 0x5C, 0x00, 0x57, 0x3A, 0x00, 0x00, 0x00, 0x1D, 0x24, 0x00, 0x13, 0x09,
    0x54, 0x00, 0x13, 0x0B, 0x20, 0x00, 0x13, 0x08, 0x0C, 0x00, 0x13, 0x00, 0x18, 0x00, 0x53, 0x17,
    0x00, 0x00, 0x00, 0x15, 0x08, 0x00, 0x13, 0x1B, 0x18, 0x00, 0x57, 0x20, 0x00, 0x00, 0x00, 0x06,
    0x04, 0x00, 0x13, 0x03, 0x18, 0x00, 0x13, 0x06, 0x34, 0x00, 0x17, 0x02, 0x40, 0x00, 0x00, 0x50,
    0x00, 0x13, 0x0E, 0xB0, 0x00, 0x18, 0x06, 0x44, 0x01, 0x74, 0x00, 0x00, 0x00, 0x31, 0x31, 0x03,
    0x88, 0xF0, 0x00, 0x40, 0x00, 0x00, 0x00, 0x80, 0x0A, 0x00, 0x13, 0x12, 0xE8, 0x00, 0x54, 0x1A,
    0x00, 0x00, 0x00, 0x16, 0xF4, 0x00, 0x03, 0x61, 0x00, 0x13, 0xC1, 0x50, 0x00, 0x13, 0x08, 0x74,
    0x00, 0x13, 0x0A, 0x08, 0x00, 0x04, 0x10, 0x01, 0x13, 0x02, 0xC4, 0x00, 0x13, 0x3B, 0x04, 0x00,
    0x13, 0x05, 0x04, 0x00, 0x13, 0x04, 0xE8, 0x00, 0x08, 0x0C, 0x00, 0x53, 0x31, 0x31, 0x03, 0xC8,
    0x1C, 0x58, 0x00, 0x40, 0x0D, 0xA0, 0x60, 0x91, 0x7C, 0x01, 0x31, 0xA0, 0x00, 0x2C, 0x86, 0x00,
    0x11, 0x78, 0x16, 0x00, 0x2F, 0xFF, 0x0F, 0x56, 0x01, 0x03, 0xF1, 0x0A, 0x0B, 0x88, 0x22, 0x00,
    0x0E, 0x00, 0x10, 0x00, 0x1B, 0x00, 0x43, 0x00, 0x49, 0x00, 0x45, 0x00, 0x42, 0x00, 0x47, 0x00,
    0x49, 0x00, 0x47, 0x00, 0x46, 0xB0, 0x00, 0x3F, 0x00, 0x00, 0x10, 0x18, 0x00, 0x06, 0x20, 0x22,
    0x00, 0x3A, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x3E, 0x00, 0x4F, 0x1B, 0x00, 0x22, 0x00, 0x01, 0x00,
    0x8F, 0x80, 0x1F, 0x22, 0x20, 0x80, 0x0F, 0xF4, 0x20, 0x02, 0x98, 0x01, 0xF0, 0x0E, 0x00, 0x40,
    0x06, 0x00, 0xCC, 0x00, 0x09, 0x00, 0x10, 0x00, 0xCC, 0x00, 0x0A, 0x00, 0x33, 0x00, 0x02, 0x03,
    0xE0, 0xC1, 0x20, 0x41, 0x13, 0x1F, 0x14, 0x00, 0x01, 0x00, 0x99, 0x5C, 0x01, 0xB0, 0x08, 0x00,
    0x00, 0x50, 0x50, 0x50, 0x00, 0x00, 0x00, 0xA0, 0xF3, 0x40, 0x01, 0x22, 0x13, 0x07, 0xA4, 0x01,
    0x04, 0x4C, 0x00, 0x13, 0x12, 0x04, 0x00, 0x11, 0x00, 0xB8, 0x01, 0x11, 0x05, 0x9F, 0x01, 0x23,
    0x10, 0x02, 0x51, 0x02, 0x00, 0xE4, 0x02, 0x13, 0x04, 0x92, 0x02, 0x2F, 0x34, 0x10, 0x90, 0x00,
    0x06, 0x03, 0x79, 0x03, 0x09, 0x21, 0x00, 0x9F, 0x80, 0x00, 0x40, 0x00, 0x04, 0x10, 0x80, 0x00,
    0x20, 0xC9, 0x00, 0x09, 0x34, 0xEF, 0x00, 0xEF, 0x0B, 0x00, 0x48, 0x1C, 0x1C, 0x1C, 0x1C, 0x1B,
    0x00, 0x22, 0x10, 0x10, 0x04, 0x00, 0x44, 0x33, 0x60, 0x18, 0x01, 0x14, 0x00, 0x13, 0x18, 0x60,
    0x02, 0x01, 0x88, 0x02, 0x32, 0x16, 0x16, 0x88, 0xB8, 0x00, 0xF0, 0x07, 0x01, 0x00, 0x80, 0x90,
    0x00, 0x00, 0x04, 0x04, 0x07, 0x07, 0x65, 0x00, 0x04, 0x00, 0x1F, 0x80, 0x13, 0x05, 0x00, 0x11,
    0x10, 0x1F, 0x80, 0x02, 0xF0, 0x0F, 0x40, 0x72, 0x10, 0x00, 0x00, 0x40, 0x12, 0x01, 0x6A, 0x5B,
    0x12, 0x01, 0x00, 0x10, 0x08, 0x0F, 0x00, 0x58, 0x10, 0x00, 0x00, 0xFC, 0x10, 0x11, 0x00, 0x13,
    0x08, 0x0F, 0x50, 0x7C, 0x0C, 0x00, 0xF3, 0x07, 0x14, 0x11, 0x00, 0x03, 0x00, 0x07, 0x4C, 0x72,
    0x10, 0x00, 0x5A, 0x3C, 0x55, 0x55, 0x16, 0x16, 0x16, 0xC8, 0x5D, 0x5D, 0x0C, 0x88, 0x04, 0x00,
    0x12, 0xC8, 0x04, 0x00, 0x23, 0x0E, 0x8C, 0x04, 0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F, 0xB0, 0x03,
    0xFF, 0x09, 0x1F, 0x99, 0xB0, 0x03, 0xFF, 0x5E, 0x72, 0x00, 0x80, 0x06, 0x06, 0x00, 0x00, 0x05,
    0x13, 0x02, 0x0F, 0xB0, 0x03, 0x78, 0x00, 0x8C, 0x02, 0x10, 0x1F, 0x24, 0x00, 0x03, 0x68, 0x02,
    0x13, 0x1E, 0xB0, 0x03, 0x1F, 0x10, 0xB0, 0x03, 0x40, 0x0F, 0x90, 0x03, 0x09, 0x13, 0x0E, 0x04,
    0x00, 0x0F, 0x90, 0x03, 0x21, 0x13, 0x13, 0x04, 0x00, 0x0F, 0x90, 0x03, 0x14, 0x22, 0x30, 0x02,
    0x04, 0x00, 0x0F, 0x90, 0x03, 0x00, 0x1F, 0x04, 0x40, 0x07, 0xFF, 0xFF, 0x70, 0x1F, 0x01, 0x40,
    0x07, 0x0A, 0x4F, 0x04, 0x00, 0x80, 0xB0, 0x90, 0x03, 0x37, 0x2F, 0x28, 0x00, 0x02, 0x00, 0x0B,
    0x0F, 0x01, 0x00, 0xAD, 0x1B, 0x29, 0x01, 0x00, 0x0C, 0x20, 0x00, 0x04, 0x48, 0x03, 0x0F, 0x01,
    0x00, 0xFF, 0x16, 0x39, 0x49, 0x92, 0x24, 0x04, 0x00, 0x0F, 0x01, 0x00, 0x0D, 0x00, 0xB4, 0x02,
    0x40, 0x04, 0x01, 0x00, 0x00, 0x16, 0x0A, 0x1B, 0x18, 0x10, 0x09, 0x05, 0x50, 0x03, 0x5A, 0x42,
    0x0F, 0x00, 0x60, 0x09, 0x14, 0x00, 0x1E, 0x01, 0x0C, 0x00, 0x0F, 0xFC, 0x00, 0x6E, 0xF5, 0x02,
    0x01, 0x00, 0x00, 0x08, 0x4C, 0x00, 0x00, 0x80, 0x20, 0x10, 0x0A, 0x00, 0x28, 0x10, 0x00, 0x80,
    0x01, 0x48, 0x04, 0x02, 0xA4, 0x00, 0x17, 0x02, 0x08, 0x00, 0x13, 0x05, 0x0C, 0x00, 0x17, 0x01,
    0x84, 0x06, 0x00, 0x14, 0x00, 0x12, 0x07, 0x0A, 0x0A, 0xD3, 0x02, 0x01, 0x02, 0x03, 0x00, 0x04,
    0x05, 0xA3, 0x72, 0x0F, 0x0F, 0x00, 0x70, 0xE6, 0x04, 0x4F, 0x00, 0x1A, 0x00, 0x80, 0x04, 0x00,
    0x0E, 0x11, 0x1B, 0x10, 0x04, 0xF1, 0x02, 0x80, 0x00, 0x4C, 0x02, 0x00, 0x00, 0xB2, 0x00, 0xFF,
    0x00, 0xDA, 0x00, 0xFF, 0x00, 0x9D, 0x00, 0xFF, 0x02, 0x00, 0x17, 0x0C, 0x08, 0x00, 0xF1, 0x02,
    0x49, 0x00, 0x7F, 0x00, 0x80, 0x00, 0xFF, 0x00, 0x04, 0x00, 0xFF, 0x00, 0xAD, 0x00, 0x08, 0x00,
    0xFF, 0x88, 0x00, 0x33, 0xFF, 0x00, 0xC6, 0x04, 0x00, 0x13, 0x6D, 0x2C, 0x00, 0x11, 0xE2, 0x06,
    0x00, 0x01, 0x73, 0x06, 0x01, 0x0A, 0x00, 0x13, 0x14, 0xC0, 0x06, 0x2E, 0xF4, 0x01, 0x78, 0x01,
    0x13, 0x08, 0x44, 0x0F, 0x0F, 0x23, 0x01, 0x08, 0x1F, 0xC0, 0x0C, 0x00, 0x04, 0x06, 0xE8, 0x04,
    0x05, 0x98, 0x07, 0xA0, 0x01, 0x88, 0x00, 0x00, 0x02, 0x88, 0x00, 0x00, 0x0D, 0x88, 0x2C, 0x00,
    0x00, 0xB4, 0x0B, 0x08, 0x28, 0x00, 0x42, 0xD8, 0x51, 0x1A, 0xA0, 0x0A, 0x00, 0x11, 0x88, 0x04,
    0x00, 0x26, 0x20, 0x12, 0x0C, 0x00, 0x00, 0x04, 0x00, 0x50, 0x25, 0x08, 0x11, 0x00, 0x0C, 0x46,
    0x00, 0x07, 0x50, 0x10, 0x00, 0x0C, 0x00, 0x26, 0x5C, 0x0D, 0x94, 0x01, 0x7F, 0x30, 0x31, 0x5F,
    0x31, 0x36, 0x30, 0x30, 0xCD, 0x10, 0x23, 0x28, 0x6A, 0x18, 0xCC, 0x10, 0x4F, 0x6D, 0x5F, 0x75,
    0x64, 0x2C, 0x00, 0x07, 0x20, 0x80, 0x18, 0x3F, 0x01, 0x3F, 0x00, 0xF0, 0x02, 0xB4, 0x02, 0x3B,
    0x22, 0xFF, 0x3B, 0x6C, 0x06, 0x0F, 0xCC, 0x10, 0x45, 0x10, 0x60, 0x79, 0x01, 0x47, 0x01, 0x00,
    0x00, 0xE0, 0x24, 0x00, 0x13, 0x44, 0x9C, 0x09, 0x13, 0x2A, 0x64, 0x00, 0x57, 0x0C, 0x00, 0x00,
    0x00, 0x2D, 0x4C, 0x09, 0x00, 0xBC, 0x09, 0x97, 0x23, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00,
    0x41, 0x8C, 0x09, 0x13, 0x1D, 0x04, 0x00, 0x13, 0x10, 0x98, 0x00, 0x13, 0x16, 0xEC, 0x03, 0x13,
    0x0E, 0x44, 0x00, 0x17, 0x0A, 0xDC, 0x09, 0x13, 0x0E, 0x44, 0x00, 0x12, 0x09, 0xD0, 0x09, 0x00,
    0x7F, 0x07, 0x10, 0x10, 0xBC, 0x09, 0x57, 0xF1, 0xF1, 0x03, 0x88, 0x1D, 0x8C, 0x09, 0x93, 0x0B,
    0x00, 0x06, 0x00, 0x33, 0x00, 0x00, 0x00, 0x39, 0x4C, 0x09, 0x13, 0x37, 0x0C, 0x00, 0x23, 0x20,
    0x18, 0x90, 0x02, 0x12, 0x06, 0x70, 0x00, 0x13, 0x10, 0xF0, 0x01, 0x13, 0x17, 0x08, 0x00, 0x13,
    0x38, 0x64, 0x00, 0x00, 0x8F, 0x01, 0x62, 0x2E, 0x00, 0x00, 0x00, 0xCC, 0x01, 0x04, 0x00, 0x13,
    0x0D, 0x9C, 0x00, 0x13, 0x0C, 0xC4, 0x07, 0x17, 0x22, 0x40, 0x01, 0x66, 0xF1, 0xF1, 0x03, 0xC8,
    0x60, 0x18, 0x8C, 0x09, 0x00, 0x7C, 0x01, 0x4F, 0xBB, 0x01, 0x00, 0xC0, 0x8C, 0x09, 0x0D, 0xD5,
    0x06, 0x06, 0x0B, 0x88, 0x15, 0x00, 0x09, 0x00, 0x0A, 0x00, 0x10, 0x00, 0x0A, 0x90, 0x0A, 0x33,
    0x02, 0x00, 0x07, 0x48, 0x03, 0x00, 0xFA, 0x00, 0x0F, 0x18, 0x00, 0x05, 0x20, 0x15, 0x00, 0x3A,
    0x00, 0x11, 0x09, 0x22, 0x00, 0x00, 0x90, 0x09, 0x1F, 0x15, 0x8C, 0x09, 0xA0, 0xD0, 0x40, 0x06,
    0x31, 0x00, 0x2F, 0x00, 0x40, 0x06, 0x17, 0x00, 0x90, 0x01, 0x09, 0x8C, 0x09, 0x12, 0x61, 0x8C,
    0x09, 0x5B, 0xB0, 0x04, 0x00, 0x00, 0x0D, 0x8C, 0x09, 0x5F, 0x8C, 0x30, 0x00, 0x00, 0x2B, 0x1C,
    0x0D, 0x05, 0x21, 0x00, 0x06, 0x23, 0x01, 0x13, 0x11, 0x8C, 0x09, 0x81, 0x84, 0x10, 0x02, 0x40,
    0x85, 0x14, 0x02, 0x40, 0x26, 0x02, 0x1F, 0x20, 0x8C, 0x09, 0x40, 0x1F, 0x00, 0x8C, 0x09, 0x0F,
    0x26, 0x90, 0x61, 0xCC, 0x10, 0x00, 0x78, 0x02, 0x13, 0x2B, 0x88, 0x02, 0x00, 0x8C, 0x09, 0x11,
    0x33, 0xA4, 0x0C, 0x15, 0x06, 0x1C, 0x0D, 0x2F, 0x20, 0x03, 0x8C, 0x09, 0x14, 0x53, 0x53, 0x08,
    0x0F, 0x10, 0x42, 0x8C, 0x09, 0x5F, 0x43, 0x00, 0x07, 0x00, 0x23, 0xCC, 0x10, 0x07, 0x43, 0x48,
    0x48, 0x0E, 0x8C, 0x04, 0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F, 0xB0, 0x03, 0xFF, 0x09, 0x1F, 0x99,
    0xB0, 0x03, 0xFF, 0x5F, 0x01, 0xCC, 0x10, 0x03, 0xCF, 0x09, 0x0F, 0xB0, 0x03, 0x78, 0x04, 0xCC,
    0x10, 0x13, 0x3F, 0xB0, 0x03, 0x1F, 0x41, 0xB0, 0x03, 0x48, 0x0F, 0x90, 0x03, 0x0D, 0x1F, 0x22,
    0x40, 0x07, 0xFF, 0xFF, 0xF2, 0x1F, 0x01, 0x40, 0x07, 0x0D, 0x1F, 0xB0, 0x90, 0x03, 0x37, 0x2F,
    0x20, 0x00, 0x02, 0x00, 0x0A, 0x0F, 0xCC, 0x10, 0xBE, 0xF4, 0x01, 0x2B, 0x00, 0x24, 0x00, 0x28,
    0x00, 0x20, 0x00, 0x29, 0x00, 0x26, 0x00, 0x2A, 0x00, 0x22, 0x00, 0x48, 0x03, 0x0C, 0x18, 0x00,
    0x0F, 0x01, 0x00, 0xFF, 0x36, 0x08, 0xCC, 0x10, 0x16, 0x07, 0x33, 0x14, 0x0F, 0xCC, 0x10, 0xA2,
    0x12, 0x0C, 0xF4, 0x0F, 0x05, 0xCC, 0x10, 0x13, 0x06, 0x9C, 0x10, 0x00, 0xC3, 0x05, 0x13, 0x0F,
    0x04, 0x00, 0x13, 0x03, 0x04, 0x00, 0x17, 0x0D, 0xCC, 0x10, 0x13, 0x0C, 0x84, 0x06, 0x13, 0x0A,
    0x50, 0x06, 0xBF, 0x00, 0x00, 0x06, 0x05, 0x0C, 0x08, 0x0D, 0x00, 0x19, 0x24, 0x6C, 0xCC, 0x10,
    0x1E, 0x13, 0xD0, 0xCC, 0x10, 0xF7, 0x06, 0x03, 0x12, 0x00, 0x00, 0x3D, 0x00, 0x80, 0x00, 0x38,
    0x00, 0x80, 0x00, 0x41, 0x00, 0x80, 0x00, 0x90, 0x00, 0x80, 0x00, 0x05, 0x08, 0x00, 0x70, 0x49,
    0x00, 0x34, 0x00, 0x80, 0x00, 0x80, 0xFA, 0x14, 0x62, 0x00, 0x16, 0x00, 0x08, 0x00, 0x80, 0x06,
    0x15, 0x23, 0x00, 0x19, 0x04, 0x00, 0x91, 0x18, 0x00, 0x80, 0x00, 0x95, 0x00, 0x80, 0x00, 0x1D,
    0x26, 0x00, 0x31, 0x00, 0x00, 0x2C, 0xDC, 0x00, 0x11, 0x80, 0x98, 0x06, 0x17, 0x08, 0xCC, 0x10,
    0x17, 0x09, 0xBC, 0x17, 0x1F, 0x00, 0xCC, 0x10, 0x10, 0x79, 0x56, 0x01, 0x55, 0x05, 0x55, 0x05,
    0x02, 0x0C, 0x00, 0x00, 0x48, 0x00, 0x04, 0x45, 0x14, 0x13, 0x2F, 0x08, 0x00, 0x57, 0x54, 0x00,
    0x01, 0x88, 0x2D, 0xCC, 0x10, 0x2F, 0x48, 0x48, 0xCC, 0x10, 0x1B, 0x1B, 0x35, 0xCC, 0x10, 0x04,
    0x50, 0x10, 0x80, 0x9C, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

constexpr const u8 T210b01SdevEmcDvfsTableS4gbY01[0x688] = {
    0xFF, 0x18, 0x03, 0x00, 0x00, 0x00, 0x30, 0x31, 0x5F, 0x32, 0x30, 0x34, 0x30, 0x30, 0x30, 0x5F,
    0x4E, 0x6F, 0x43, 0x66, 0x67, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6F, 0x6E, 0x5F, 0x56, 0x30, 0x2E,
    0x34, 0x2E, 0x32, 0x5F, 0x56, 0x32, 0x2E, 0x30, 0x00, 0x01, 0x00, 0x06, 0x71, 0xE0, 0x1C, 0x03,
    0x00, 0x4C, 0x04, 0x00, 0x04, 0x00, 0x8F, 0x70, 0x6C, 0x6C, 0x70, 0x5F, 0x6F, 0x75, 0x74, 0x2F,
    0x00, 0x05, 0x5F, 0x02, 0x80, 0x18, 0x40, 0x00, 0x01, 0x00, 0x40, 0xFF, 0x1E, 0x3F, 0x3A, 0x00,
    0x00, 0x0D, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
    0x00, 0x8A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
    0x00, 0x04, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x05, 0x50, 0x00, 0x10, 0x17, 0x0A, 0x04,
    0x00, 0x22, 0x01, 0x00, 0x5C, 0x00, 0x57, 0x3A, 0x00, 0x00, 0x00, 0x1D, 0x24, 0x00, 0x13, 0x09,
    0x54, 0x00, 0x13, 0x0B, 0x20, 0x00, 0x13, 0x08, 0x0C, 0x00, 0x13, 0x00, 0x18, 0x00, 0x53, 0x17,
    0x00, 0x00, 0x00, 0x15, 0x08, 0x00, 0x13, 0x1B, 0x18, 0x00, 0x57, 0x20, 0x00, 0x00, 0x00, 0x06,
    0x04, 0x00, 0x13, 0x03, 0x18, 0x00, 0x13, 0x06, 0x34, 0x00, 0x17, 0x02, 0x40, 0x00, 0x00, 0x50,
    0x00, 0x13, 0x0E, 0xB0, 0x00, 0x18, 0x06, 0x44, 0x01, 0x74, 0x00, 0x00, 0x00, 0x31, 0x31, 0x03,
    0x88, 0xF0, 0x00, 0x40, 0x00, 0x00, 0x00, 0x80, 0x0A, 0x00, 0x13, 0x12, 0xE8, 0x00, 0x54, 0x1A,
    0x00, 0x00, 0x00, 0x16, 0xF4, 0x00, 0x03, 0x61, 0x00, 0x13, 0xC1, 0x50, 0x00, 0x13, 0x08, 0x74,
    0x00, 0x13, 0x0A, 0x08, 0x00, 0x04, 0x10, 0x01, 0x13, 0x02, 0xC4, 0x00, 0x13, 0x3B, 0x04, 0x00,
    0x13, 0x05, 0x04, 0x00, 0x13, 0x04, 0xE8, 0x00, 0x08, 0x0C, 0x00, 0x53, 0x31, 0x31, 0x03, 0xC8,
    0x1C, 0x58, 0x00, 0x40, 0x0D, 0xA0, 0x60, 0x91, 0x7C, 0x01, 0x31, 0xA0, 0x00, 0x2C, 0x86, 0x00,
    0x11, 0x78, 0x16, 0x00, 0x2F, 0xFF, 0x0F, 0x56, 0x01, 0x03, 0xF1, 0x0C, 0x0B, 0x88, 0x18, 0x00,
    0x0F, 0x00, 0x0B, 0x00, 0x17, 0x00, 0x48, 0x00, 0x44, 0x00, 0x45, 0x00, 0x44, 0x00, 0x47, 0x00,
    0x47, 0x00, 0x41, 0x00, 0x46, 0x00, 0x0D, 0x62, 0x00, 0x1F, 0x0D, 0x18, 0x00, 0x06, 0x20, 0x18,
    0x00, 0x3A, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x3E, 0x00, 0x11, 0x17, 0xDC, 0x00, 0x0F, 0x01, 0x00,
    0x8D, 0x80, 0x1F, 0x22, 0x20, 0x80, 0x0F, 0xF4, 0x20, 0x02, 0x98, 0x01, 0xF0, 0x0E, 0x00, 0x40,
    0x06, 0x00, 0xCC, 0x00, 0x09, 0x00, 0x10, 0x00, 0xCC, 0x00, 0x0A, 0x00, 0x33, 0x00, 0x02, 0x03,
    0xE0, 0xC1, 0x20, 0x41, 0x13, 0x1F, 0x14, 0x00, 0x01, 0x00, 0x99, 0x5C, 0x01, 0x60, 0x08, 0x00,
    0x00, 0x50, 0x50, 0x50, 0x22, 0x02, 0x10, 0xF3, 0x40, 0x01, 0x57, 0x13, 0x07, 0x00, 0x80, 0x0A,
    0x4C, 0x00, 0x13, 0x12, 0x04, 0x00, 0x11, 0x00, 0xB8, 0x01, 0x11, 0x05, 0x9F, 0x01, 0x23, 0x10,
    0x02, 0x51, 0x02, 0x00, 0xE4, 0x02, 0x13, 0x04, 0x92, 0x02, 0x2F, 0x34, 0x10, 0x90, 0x00, 0x06,
    0x03, 0x79, 0x03, 0x09, 0x21, 0x00, 0x9F, 0x80, 0x00, 0x40, 0x00, 0x04, 0x10, 0x80, 0x00, 0x20,
    0xC9, 0x00, 0x09, 0x34, 0xEF, 0x00, 0xEF, 0x0B, 0x00, 0x48, 0x1C, 0x1C, 0x1C, 0x1C, 0x1B, 0x00,
    0x22, 0x10, 0x10, 0x04, 0x00, 0x44, 0x33, 0x60, 0x18, 0x01, 0x14, 0x00, 0x13, 0x18, 0x60, 0x02,
    0x00, 0x88, 0x02, 0x42, 0x14, 0x14, 0x16, 0x88, 0xB8, 0x00, 0xF0, 0x07, 0x01, 0x00, 0x80, 0x90,
    0x00, 0x00, 0x04, 0x04, 0x07, 0x07, 0x65, 0x00, 0x04, 0x00, 0x1F, 0x80, 0x13, 0x05, 0x00, 0x11,
    0x10, 0x1F, 0x80, 0x02, 0xF0, 0x0F, 0x40, 0x72, 0x10, 0x00, 0x00, 0x40, 0x12, 0x01, 0x6A, 0x5B,
    0x12, 0x01, 0x00, 0x10, 0x08, 0x0F, 0x00, 0x58, 0x10, 0x00, 0x00, 0xFC, 0x10, 0x11, 0x00, 0x13,
    0x08, 0x0F, 0x50, 0x7C, 0x0C, 0x00, 0xF3, 0x07, 0x14, 0x11, 0x00, 0x03, 0x00, 0x07, 0x4C, 0x72,
    0x10, 0x00, 0x5A, 0x3C, 0x55, 0x55, 0x14, 0x14, 0x16, 0xC8, 0x5D, 0x5D, 0x0C, 0x88, 0x04, 0x00,
    0x12, 0xC8, 0x04, 0x00, 0x23, 0x0E, 0x8C, 0x04, 0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F, 0xB0, 0x03,
    0xFF, 0x09, 0x1F, 0x99, 0xB0, 0x03, 0xFF, 0x5E, 0x72, 0x00, 0x80, 0x06, 0x06, 0x00, 0x00, 0x05,
    0x13, 0x02, 0x0F, 0xB0, 0x03, 0x78, 0x00, 0x8C, 0x02, 0x10, 0x1F, 0x24, 0x00, 0x03, 0x68, 0x02,
    0x13, 0x1E, 0xB0, 0x03, 0x1F, 0x10, 0xB0, 0x03, 0x40, 0x0F, 0x90, 0x03, 0x09, 0x13, 0x0E, 0x04,
    0x00, 0x0F, 0x90, 0x03, 0x21, 0x13, 0x13, 0x04, 0x00, 0x0F, 0x90, 0x03, 0x14, 0x22, 0x30, 0x02,
    0x04, 0x00, 0x0F, 0x90, 0x03, 0x00, 0x1F, 0x04, 0x40, 0x07, 0xFF, 0xFF, 0x70, 0x1F, 0x01, 0x40,
    0x07, 0x0A, 0x4F, 0x04, 0x00, 0x80, 0xB0, 0x90, 0x03, 0x37, 0x2F, 0x78, 0x00, 0x02, 0x00, 0x0B,
    0x0F, 0x01, 0x00, 0xAD, 0x13, 0x29, 0x01, 0x00, 0x13, 0x32, 0x01, 0x00, 0x0C, 0x20, 0x00, 0x04,
    0x48, 0x03, 0x0F, 0x01, 0x00, 0xFF, 0x16, 0x39, 0x49, 0x92, 0x24, 0x04, 0x00, 0x0F, 0x01, 0x00,
    0x0D, 0x00, 0xB4, 0x02, 0x40, 0x04, 0x01, 0x00, 0x00, 0x16, 0x0A, 0x1B, 0x18, 0x10, 0x09, 0x05,
    0x50, 0x03, 0x5A, 0x42, 0x0F, 0x00, 0x60, 0x09, 0x14, 0x00, 0x1E, 0x01, 0x0C, 0x00, 0x0F, 0xFC,
    0x00, 0x6E, 0xF5, 0x02, 0x01, 0x00, 0x00, 0x08, 0x4C, 0x00, 0x00, 0x80, 0x20, 0x10, 0x0A, 0x00,
    0x28, 0x10, 0x00, 0x80, 0x01, 0x48, 0x04, 0x02, 0xA4, 0x00, 0x17, 0x02, 0x08, 0x00, 0x13, 0x05,
    0x0C, 0x00, 0x17, 0x01, 0x84, 0x06, 0x00, 0x14, 0x00, 0x12, 0x07, 0x0A, 0x0A, 0xD3, 0x02, 0x01,
    0x02, 0x03, 0x00, 0x04, 0x05, 0xA3, 0x72, 0x0F, 0x0F, 0x00, 0x70, 0xE6, 0x04, 0x4F, 0x00, 0x1A,
    0x00, 0x80, 0x04, 0x00, 0x0E, 0x11, 0x1B, 0x10, 0x04, 0xF1, 0x02, 0x80, 0x00, 0x4C, 0x02, 0x00,
    0x00, 0xB2, 0x00, 0xFF, 0x00, 0xDA, 0x00, 0xFF, 0x00, 0x9D, 0x00, 0xFF, 0x02, 0x00, 0x17, 0x0C,
    0x08, 0x00, 0xF1, 0x02, 0x49, 0x00, 0x7F, 0x00, 0x80, 0x00, 0xFF, 0x00, 0x04, 0x00, 0xFF, 0x00,
    0xAD, 0x00, 0x08, 0x00, 0xFF, 0x88, 0x00, 0x33, 0xFF, 0x00, 0xC6, 0x04, 0x00, 0x13, 0x6D, 0x2C,
    0x00, 0x11, 0xE2, 0x06, 0x00, 0x01, 0x73, 0x06, 0x01, 0x0A, 0x00, 0x13, 0x14, 0xC0, 0x06, 0x2E,
    0xF4, 0x01, 0x78, 0x01, 0x13, 0x08, 0x44, 0x0F, 0x0F, 0x23, 0x01, 0x08, 0x1F, 0xC0, 0x0C, 0x00,
    0x04, 0x06, 0xE8, 0x04, 0x05, 0x98, 0x07, 0xA0, 0x01, 0x88, 0x00, 0x00, 0x02, 0x88, 0x00, 0x00,
    0x0D, 0x88, 0x2C, 0x00, 0x00, 0xB4, 0x0B, 0x08, 0x28, 0x00, 0xA0, 0xD8, 0x51, 0x1A, 0xA0, 0x00,
    0x00, 0x50, 0x05, 0x00, 0x00, 0x1F, 0x00, 0x31, 0x88, 0x00, 0x20, 0xFD, 0x04, 0x15, 0x88, 0x04,
    0x00, 0x50, 0x25, 0x08, 0x11, 0x00, 0x0C, 0x46, 0x00, 0x07, 0x50, 0x10, 0x00, 0x0C, 0x00, 0x26,
    0x5C, 0x0D, 0x94, 0x01, 0x7F, 0x30, 0x31, 0x5F, 0x31, 0x36, 0x30, 0x30, 0xCD, 0x10, 0x23, 0x28,
    0x6A, 0x18, 0xCC, 0x10, 0x4F, 0x6D, 0x5F, 0x75, 0x64, 0x2C, 0x00, 0x07, 0x21, 0x80, 0x18, 0x0C,
    0x02, 0x2F, 0xF0, 0x02, 0xB4, 0x02, 0x3B, 0x22, 0xFF, 0x3B, 0x6C, 0x06, 0x0F, 0xCC, 0x10, 0x45,
    0x10, 0x60, 0x79, 0x01, 0x47, 0x01, 0x00, 0x00, 0xE0, 0x24, 0x00, 0x13, 0x44, 0x9C, 0x09, 0x13,
    0x29, 0x64, 0x00, 0x57, 0x0C, 0x00, 0x00, 0x00, 0x2D, 0x4C, 0x09, 0x00, 0xBC, 0x09, 0x97, 0x23,
    0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x41, 0x8C, 0x09, 0x13, 0x1D, 0x04, 0x00, 0x13, 0x10,
    0x98, 0x00, 0x13, 0x16, 0xEC, 0x03, 0x13, 0x0E, 0x44, 0x00, 0x17, 0x0A, 0xDC, 0x09, 0x13, 0x0E,
    0x44, 0x00, 0x12, 0x09, 0xD0, 0x09, 0x00, 0x7F, 0x07, 0x10, 0x10, 0xBC, 0x09, 0x57, 0xF1, 0xF1,
    0x03, 0x88, 0x1D, 0x8C, 0x09, 0x93, 0x0B, 0x00, 0x06, 0x00, 0x33, 0x00, 0x00, 0x00, 0x39, 0x4C,
    0x09, 0x13, 0x37, 0x0C, 0x00, 0x13, 0x20, 0xB5, 0x08, 0x22, 0x08, 0x06, 0x70, 0x00, 0x13, 0x10,
    0xF0, 0x01, 0x13, 0x17, 0x08, 0x00, 0x13, 0x38, 0x64, 0x00, 0x00, 0x8F, 0x01, 0x62, 0x2E, 0x00,
    0x00, 0x00, 0xCC, 0x01, 0x04, 0x00, 0x13, 0x0D, 0x9C, 0x00, 0x13, 0x0C, 0xC4, 0x07, 0x17, 0x22,
    0x40, 0x01, 0x66, 0xF1, 0xF1, 0x03, 0xC8, 0x60, 0x18, 0x8C, 0x09, 0x00, 0x7C, 0x01, 0x4F, 0xBB,
    0x01, 0x00, 0xC0, 0x8C, 0x09, 0x0D, 0xD7, 0x06, 0x06, 0x0B, 0x88, 0x0E, 0x00, 0x09, 0x00, 0x07,
    0x00, 0x0E, 0x00, 0x03, 0x1C, 0x0E, 0x11, 0x0B, 0xEC, 0x03, 0x11, 0x03, 0xF2, 0x00, 0x0F, 0x18,
    0x00, 0x05, 0x20, 0x0E, 0x00, 0x3A, 0x00, 0x00, 0x3C, 0x00, 0x11, 0x07, 0x0C, 0x00, 0x1F, 0x0E,
    0x8C, 0x09, 0xA0, 0xD0, 0x40, 0x06, 0x31, 0x00, 0x2F, 0x00, 0x40, 0x06, 0x17, 0x00, 0x90, 0x01,
    0x09, 0x8C, 0x09, 0x12, 0x61, 0x8C, 0x09, 0x5B, 0xB0, 0x04, 0x00, 0x00, 0x0D, 0x8C, 0x09, 0x5F,
    0x8C, 0x30, 0x00, 0x80, 0x2B, 0x1C, 0x0D, 0x05, 0x21, 0x00, 0x06, 0xCB, 0x0B, 0x13, 0x11, 0x8C,
    0x09, 0x81, 0x84, 0x10, 0x02, 0x40, 0x85, 0x14, 0x02, 0x40, 0x26, 0x02, 0x1F, 0x20, 0x8C, 0x09,
    0x40, 0x1F, 0x00, 0x8C, 0x09, 0x0F, 0x26, 0x90, 0x61, 0xCC, 0x10, 0x00, 0x78, 0x02, 0x13, 0x2B,
    0x88, 0x02, 0x00, 0x8C, 0x09, 0x11, 0x33, 0xCC, 0x01, 0x15, 0x06, 0x1C, 0x0D, 0x2F, 0x20, 0x03,
    0x8C, 0x09, 0x14, 0x53, 0x53, 0x08, 0x0F, 0x10, 0x42, 0x8C, 0x09, 0x5F, 0x43, 0x00, 0x07, 0x06,
    0x23, 0xCC, 0x10, 0x07, 0x43, 0x48, 0x48, 0x0E, 0x8C, 0x04, 0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F,
    0xB0, 0x03, 0xFF, 0x09, 0x1F, 0x99, 0xB0, 0x03, 0xFF, 0x5F, 0x01, 0xCC, 0x10, 0x03, 0xCF, 0x09,
    0x0F, 0xB0, 0x03, 0x78, 0x04, 0xCC, 0x10, 0x13, 0x3F, 0xB0, 0x03, 0x1F, 0x41, 0xB0, 0x03, 0x48,
    0x0F, 0x90, 0x03, 0x0D, 0x1F, 0x22, 0x40, 0x07, 0xFF, 0xFF, 0xF2, 0x1F, 0x01, 0x40, 0x07, 0x0D,
    0x1F, 0xB0, 0x90, 0x03, 0x37, 0x2F, 0x20, 0x00, 0x02, 0x00, 0x0A, 0x0F, 0xCC, 0x10, 0xB6, 0x04,
    0x01, 0x00, 0xF4, 0x01, 0x27, 0x00, 0x21, 0x00, 0x28, 0x00, 0x21, 0x00, 0x26, 0x00, 0x23, 0x00,
    0x2A, 0x00, 0x22, 0x00, 0x48, 0x03, 0x0C, 0x18, 0x00, 0x0F, 0x01, 0x00, 0xFF, 0x36, 0x08, 0xCC,
    0x10, 0x16, 0x07, 0x33, 0x14, 0x0F, 0xCC, 0x10, 0xA2, 0x12, 0x0C, 0xF4, 0x0F, 0x05, 0xCC, 0x10,
    0x13, 0x06, 0x9C, 0x10, 0x00, 0xC3, 0x05, 0x13, 0x0F, 0x04, 0x00, 0x13, 0x03, 0x04, 0x00, 0x17,
    0x0D, 0xCC, 0x10, 0x13, 0x0C, 0x84, 0x06, 0x13, 0x0A, 0x50, 0x06, 0xBF, 0x00, 0x00, 0x06, 0x05,
    0x0C, 0x08, 0x0D, 0x00, 0x19, 0x24, 0x6C, 0xCC, 0x10, 0x1E, 0x13, 0xD0, 0xCC, 0x10, 0xF7, 0x06,
    0x03, 0x12, 0x00, 0x00, 0x3D, 0x00, 0x80, 0x00, 0x38, 0x00, 0x80, 0x00, 0x41, 0x00, 0x80, 0x00,
    0x90, 0x00, 0x80, 0x00, 0x05, 0x08, 0x00, 0x70, 0x49, 0x00, 0x34, 0x00, 0x80, 0x00, 0x80, 0xFA,
    0x14, 0x62, 0x00, 0x16, 0x00, 0x08, 0x00, 0x80, 0x06, 0x15, 0x23, 0x00, 0x19, 0x04, 0x00, 0x91,
    0x18, 0x00, 0x80, 0x00, 0x95, 0x00, 0x80, 0x00, 0x1D, 0x26, 0x00, 0x31, 0x00, 0x00, 0x2C, 0xDC,
    0x00, 0x11, 0x80, 0x98, 0x06, 0x17, 0x08, 0xCC, 0x10, 0x17, 0x09, 0xBC, 0x17, 0x1F, 0x00, 0xCC,
    0x10, 0x10, 0x79, 0x56, 0x01, 0x55, 0x05, 0x55, 0x05, 0x02, 0x0C, 0x00, 0x13, 0x01, 0xDC, 0x07,
    0x00, 0x01, 0x00, 0x13, 0x2F, 0x08, 0x00, 0x57, 0x54, 0x00, 0x01, 0x88, 0x2D, 0xCC, 0x10, 0x2F,
    0x48, 0x48, 0xCC, 0x10, 0x1B, 0x1B, 0x35, 0xCC, 0x10, 0x00, 0x50, 0x10, 0x00, 0x07, 0x00, 0x80,
    0x9C, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

constexpr const u8 T210b01SdevEmcDvfsTableS1y8gbY01[0x68C] = {
    0xFF, 0x18, 0x03, 0x00, 0x00, 0x00, 0x30, 0x31, 0x5F, 0x32, 0x30, 0x34, 0x30, 0x30, 0x30, 0x5F,
    0x4E, 0x6F, 0x43, 0x66, 0x67, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6F, 0x6E, 0x5F, 0x56, 0x30, 0x2E,
    0x34, 0x2E, 0x32, 0x5F, 0x56, 0x32, 0x2E, 0x30, 0x00, 0x01, 0x00, 0x06, 0x71, 0xE0, 0x1C, 0x03,
    0x00, 0x4C, 0x04, 0x00, 0x04, 0x00, 0x8F, 0x70, 0x6C, 0x6C, 0x70, 0x5F, 0x6F, 0x75, 0x74, 0x2F,
    0x00, 0x05, 0x5F, 0x02, 0x80, 0x18, 0x40, 0x00, 0x01, 0x00, 0x40, 0xFF, 0x1E, 0x3F, 0x3A, 0x00,
    0x00, 0x0D, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
    0x00, 0x8A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
    0x00, 0x04, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x05, 0x50, 0x00, 0x10, 0x17, 0x0A, 0x04,
    0x00, 0x22, 0x01, 0x00, 0x5C, 0x00, 0x57, 0x3A, 0x00, 0x00, 0x00, 0x1D, 0x24, 0x00, 0x13, 0x09,
    0x54, 0x00, 0x13, 0x0B, 0x20, 0x00, 0x13, 0x08, 0x0C, 0x00, 0x13, 0x00, 0x18, 0x00, 0x53, 0x17,
    0x00, 0x00, 0x00, 0x15, 0x08, 0x00, 0x13, 0x1B, 0x18, 0x00, 0x57, 0x20, 0x00, 0x00, 0x00, 0x06,
    0x04, 0x00, 0x13, 0x03, 0x18, 0x00, 0x13, 0x06, 0x34, 0x00, 0x17, 0x02, 0x40, 0x00, 0x00, 0x50,
    0x00, 0x13, 0x0E, 0xB0, 0x00, 0x18, 0x06, 0x44, 0x01, 0x74, 0x00, 0x00, 0x00, 0x31, 0x31, 0x03,
    0x08, 0xF0, 0x00, 0x40, 0x00, 0x00, 0x00, 0x80, 0x0A, 0x00, 0x13, 0x12, 0xE8, 0x00, 0x54, 0x1A,
    0x00, 0x00, 0x00, 0x16, 0xF4, 0x00, 0x03, 0x61, 0x00, 0x13, 0xC1, 0x50, 0x00, 0x13, 0x08, 0x74,
    0x00, 0x13, 0x0A, 0x08, 0x00, 0x04, 0x10, 0x01, 0x13, 0x02, 0xC4, 0x00, 0x13, 0x3B, 0x04, 0x00,
    0x13, 0x05, 0x04, 0x00, 0x04, 0x88, 0x00, 0x04, 0x0C, 0x00, 0x12, 0x09, 0x7C, 0x00, 0x23, 0x48,
    0x1C, 0x58, 0x00, 0x40, 0x0D, 0xA0, 0x60, 0x91, 0x7C, 0x01, 0x31, 0xA0, 0x00, 0x2C, 0x86, 0x00,
    0x11, 0x78, 0x16, 0x00, 0x2F, 0xFF, 0x0F, 0x56, 0x01, 0x03, 0xF1, 0x0C, 0x0B, 0x08, 0x18, 0x00,
    0x0F, 0x00, 0x0B, 0x00, 0x17, 0x00, 0x48, 0x00, 0x44, 0x00, 0x45, 0x00, 0x44, 0x00, 0x47, 0x00,
    0x47, 0x00, 0x41, 0x00, 0x46, 0x00, 0x0D, 0x62, 0x00, 0x1F, 0x0D, 0x18, 0x00, 0x06, 0x20, 0x18,
    0x00, 0x3A, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x3E, 0x00, 0x11, 0x17, 0xDC, 0x00, 0x0F, 0x01, 0x00,
    0x8D, 0x80, 0x1F, 0x22, 0x20, 0x80, 0x0F, 0xF4, 0x20, 0x02, 0x98, 0x01, 0xF0, 0x0E, 0x00, 0x40,
    0x06, 0x00, 0xCC, 0x00, 0x09, 0x00, 0x10, 0x00, 0xCC, 0x00, 0x0A, 0x00, 0x33, 0x00, 0x02, 0x03,
    0xE0, 0xC1, 0x20, 0x41, 0x13, 0x1F, 0x14, 0x00, 0x01, 0x00, 0x99, 0x5C, 0x01, 0x60, 0x08, 0x00,
    0x00, 0x50, 0x50, 0x50, 0x22, 0x02, 0x10, 0xF3, 0x40, 0x01, 0x22, 0x13, 0x07, 0xA4, 0x01, 0x04,
    0x4C, 0x00, 0x13, 0x12, 0x04, 0x00, 0x11, 0x00, 0xB8, 0x01, 0x11, 0x05, 0x9F, 0x01, 0x23, 0x10,
    0x02, 0x51, 0x02, 0x00, 0xE4, 0x02, 0x13, 0x04, 0x92, 0x02, 0x2F, 0x34, 0x10, 0x90, 0x00, 0x06,
    0x03, 0x79, 0x03, 0x0E, 0x21, 0x00, 0x15, 0x10, 0x47, 0x00, 0x0F, 0xC9, 0x00, 0x03, 0x34, 0xEF,
    0x00, 0xEF, 0x0B, 0x00, 0x49, 0x1C, 0x1C, 0x1C, 0x1C, 0x3B, 0x00, 0x12, 0x10, 0x04, 0x00, 0x44,
    0x33, 0x60, 0x18, 0x01, 0x14, 0x00, 0x13, 0x18, 0x60, 0x02, 0x00, 0x88, 0x02, 0x42, 0x14, 0x14,
    0x16, 0x08, 0xB8, 0x00, 0xF0, 0x07, 0x01, 0x00, 0x80, 0x90, 0x00, 0x00, 0x04, 0x04, 0x07, 0x07,
    0x65, 0x00, 0x04, 0x00, 0x1F, 0x80, 0x13, 0x05, 0x00, 0x11, 0x10, 0x1F, 0x80, 0x02, 0xF0, 0x0F,
    0x40, 0x72, 0x10, 0x00, 0x00, 0x40, 0x12, 0x01, 0x6A, 0x5B, 0x12, 0x01, 0x00, 0x10, 0x08, 0x0F,
    0x00, 0x58, 0x10, 0x00, 0x00, 0xFC, 0x10, 0x11, 0x00, 0x13, 0x08, 0x0F, 0x50, 0x7C, 0x0C, 0x00,
    0xF3, 0x07, 0x14, 0x11, 0x00, 0x03, 0x00, 0x07, 0x4C, 0x72, 0x10, 0x00, 0x5A, 0x3C, 0x55, 0x55,
    0x14, 0x14, 0x16, 0x48, 0x5D, 0x5D, 0x0C, 0x88, 0x04, 0x00, 0x12, 0x48, 0x04, 0x00, 0x23, 0x0E,
    0x8C, 0x04, 0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F, 0xB0, 0x03, 0xFF, 0x09, 0x1F, 0x99, 0xB0, 0x03,
    0xFF, 0x5E, 0x72, 0x00, 0x80, 0x06, 0x06, 0x00, 0x00, 0x05, 0x13, 0x02, 0x0F, 0xB0, 0x03, 0x78,
    0x00, 0x8C, 0x02, 0x10, 0x1F, 0x24, 0x00, 0x03, 0x34, 0x02, 0x13, 0x1E, 0xB0, 0x03, 0x15, 0x10,
    0xB0, 0x03, 0x1F, 0x01, 0xB0, 0x03, 0x36, 0x0F, 0x90, 0x03, 0x09, 0x13, 0x0E, 0x04, 0x00, 0x0F,
    0x90, 0x03, 0x21, 0x13, 0x13, 0x04, 0x00, 0x0F, 0x90, 0x03, 0x14, 0x22, 0x30, 0x02, 0x04, 0x00,
    0x0F, 0x90, 0x03, 0x00, 0x1F, 0x04, 0x40, 0x07, 0xFF, 0xFF, 0x70, 0x1F, 0x01, 0x40, 0x07, 0x0A,
    0x4F, 0x04, 0x00, 0x80, 0xB0, 0x40, 0x07, 0x37, 0x2F, 0x28, 0x00, 0x02, 0x00, 0x0B, 0x0F, 0x01,
    0x00, 0xAD, 0x13, 0x29, 0x01, 0x00, 0x13, 0x32, 0x01, 0x00, 0x0C, 0x20, 0x00, 0x04, 0x48, 0x03,
    0x0F, 0x01, 0x00, 0xFF, 0x16, 0x39, 0x49, 0x92, 0x24, 0x04, 0x00, 0x0F, 0x01, 0x00, 0x0D, 0x00,
    0xB4, 0x02, 0x40, 0x04, 0x01, 0x00, 0x00, 0x16, 0x0A, 0x1B, 0x18, 0x10, 0x09, 0x05, 0x50, 0x03,
    0x5A, 0x42, 0x0F, 0x00, 0x60, 0x09, 0x14, 0x00, 0x1E, 0x01, 0x0C, 0x00, 0x0F, 0xFC, 0x00, 0x6E,
    0xF5, 0x02, 0x01, 0x00, 0x00, 0x08, 0x4C, 0x00, 0x00, 0x80, 0x20, 0x10, 0x0A, 0x00, 0x28, 0x10,
    0x00, 0x80, 0x01, 0x48, 0x04, 0x02, 0xA4, 0x00, 0x04, 0x04, 0x00, 0x17, 0x02, 0x0C, 0x06, 0x1B,
    0x01, 0xFC, 0x05, 0x11, 0x07, 0x14, 0x00, 0xE3, 0x02, 0x02, 0x01, 0x02, 0x03, 0x00, 0x04, 0x05,
    0xA3, 0x72, 0x0F, 0x0F, 0x00, 0x70, 0xE6, 0x04, 0x4F, 0x00, 0x1A, 0x00, 0x80, 0x04, 0x00, 0x0E,
    0x11, 0x1B, 0x10, 0x04, 0xF1, 0x02, 0x80, 0x00, 0x4C, 0x02, 0x00, 0x00, 0xB2, 0x00, 0xFF, 0x00,
    0xDA, 0x00, 0xFF, 0x00, 0x9D, 0x00, 0xFF, 0x02, 0x00, 0x17, 0x0C, 0x08, 0x00, 0xF1, 0x02, 0x49,
    0x00, 0x7F, 0x00, 0x80, 0x00, 0xFF, 0x00, 0x04, 0x00, 0xFF, 0x00, 0xAD, 0x00, 0x08, 0x00, 0xFF,
    0x88, 0x00, 0x33, 0xFF, 0x00, 0xC6, 0x04, 0x00, 0x13, 0x6D, 0x2C, 0x00, 0x11, 0xE2, 0x06, 0x00,
    0x01, 0x73, 0x06, 0x01, 0x0A, 0x00, 0x13, 0x14, 0xC0, 0x06, 0x2E, 0xF4, 0x01, 0x78, 0x01, 0x13,
    0x08, 0x44, 0x0F, 0x0F, 0x23, 0x01, 0x08, 0x1F, 0xC0, 0x0C, 0x00, 0x04, 0x08, 0x23, 0x05, 0x03,
    0xC6, 0x04, 0x90, 0x01, 0x08, 0x00, 0x00, 0x02, 0x08, 0x00, 0x00, 0x0D, 0x57, 0x00, 0x58, 0xC0,
    0x5D, 0x5D, 0x0E, 0x0C, 0x28, 0x00, 0xC0, 0xD8, 0x51, 0x1A, 0xA0, 0x00, 0x00, 0x50, 0x05, 0x00,
    0x00, 0x88, 0x00, 0x04, 0x00, 0x11, 0x20, 0xFD, 0x04, 0x15, 0x88, 0x04, 0x00, 0x50, 0x25, 0x08,
    0x11, 0x00, 0x0C, 0x46, 0x00, 0x07, 0x50, 0x10, 0x00, 0x0C, 0x00, 0x26, 0x5C, 0x0D, 0x94, 0x01,
    0x7F, 0x30, 0x31, 0x5F, 0x31, 0x36, 0x30, 0x30, 0xCD, 0x10, 0x23, 0x28, 0x6A, 0x18, 0xCC, 0x10,
    0x4F, 0x6D, 0x5F, 0x75, 0x64, 0x2C, 0x00, 0x07, 0x21, 0x80, 0x18, 0x0C, 0x02, 0x2F, 0xF0, 0x02,
    0xB4, 0x02, 0x3B, 0x22, 0xFF, 0x3B, 0x6C, 0x06, 0x0F, 0xCC, 0x10, 0x45, 0x10, 0x60, 0x79, 0x01,
    0x47, 0x01, 0x00, 0x00, 0xE0, 0x24, 0x00, 0x13, 0x44, 0x9C, 0x09, 0x13, 0x29, 0x64, 0x00, 0x00,
    0x95, 0x01, 0x17, 0x2D, 0x4C, 0x09, 0x00, 0xBC, 0x09, 0x97, 0x23, 0x00, 0x00, 0x00, 0x3E, 0x00,
    0x00, 0x00, 0x41, 0x8C, 0x09, 0x13, 0x1D, 0x04, 0x00, 0x13, 0x0C, 0x98, 0x00, 0x13, 0x16, 0xEC,
    0x03, 0x13, 0x0E, 0x14, 0x00, 0x17, 0x0A, 0xDC, 0x09, 0x13, 0x0E, 0x44, 0x00, 0x12, 0x09, 0xD0,
    0x09, 0x00, 0x7F, 0x07, 0x10, 0x10, 0xBC, 0x09, 0x57, 0xF1, 0xF1, 0x03, 0x08, 0x1D, 0x8C, 0x09,
    0x93, 0x0B, 0x00, 0x06, 0x00, 0x33, 0x00, 0x00, 0x00, 0x39, 0x4C, 0x09, 0x13, 0x37, 0x0C, 0x00,
    0x13, 0x20, 0xB5, 0x08, 0x22, 0x08, 0x06, 0x50, 0x02, 0x13, 0x10, 0xF0, 0x01, 0x13, 0x17, 0x08,
    0x00, 0x13, 0x38, 0x64, 0x00, 0x00, 0x8F, 0x01, 0x62, 0x2E, 0x00, 0x00, 0x00, 0xCC, 0x01, 0x04,
    0x00, 0x13, 0x0D, 0x9C, 0x00, 0x00, 0x90, 0x00, 0x00, 0xFA, 0x01, 0x17, 0x22, 0x40, 0x01, 0x66,
    0xF1, 0xF1, 0x03, 0x48, 0x60, 0x18, 0x8C, 0x09, 0x00, 0x7C, 0x01, 0x4F, 0xBB, 0x01, 0x00, 0xC0,
    0x8C, 0x09, 0x0D, 0xD7, 0x06, 0x06, 0x0B, 0x08, 0x0E, 0x00, 0x09, 0x00, 0x07, 0x00, 0x0E, 0x00,
    0x03, 0x1C, 0x0E, 0x11, 0x0B, 0xEC, 0x03, 0x11, 0x03, 0xF2, 0x00, 0x0F, 0x18, 0x00, 0x05, 0x20,
    0x0E, 0x00, 0x3A, 0x00, 0x00, 0x3C, 0x00, 0x11, 0x07, 0x0C, 0x00, 0x1F, 0x0E, 0x8C, 0x09, 0xA0,
    0xD0, 0x40, 0x06, 0x31, 0x00, 0x2F, 0x00, 0x40, 0x06, 0x17, 0x00, 0x90, 0x01, 0x09, 0x8C, 0x09,
    0x12, 0x61, 0x8C, 0x09, 0x22, 0xB0, 0x04, 0xDA, 0x03, 0x08, 0x8C, 0x09, 0x5F, 0x8C, 0x30, 0x00,
    0x00, 0x2B, 0x1C, 0x0D, 0x05, 0x21, 0x00, 0x06, 0xCB, 0x0B, 0x13, 0x11, 0x8C, 0x09, 0x81, 0x84,
    0x10, 0x02, 0x40, 0x85, 0x14, 0x02, 0x40, 0x26, 0x02, 0x1F, 0x20, 0x8C, 0x09, 0x40, 0x1F, 0x00,
    0x8C, 0x09, 0x0F, 0x26, 0x90, 0x61, 0xCC, 0x10, 0x00, 0x78, 0x02, 0x13, 0x2B, 0x88, 0x02, 0x00,
    0x8C, 0x09, 0x11, 0x33, 0xCC, 0x01, 0x15, 0x06, 0xCC, 0x10, 0x2F, 0x20, 0x03, 0x8C, 0x09, 0x14,
    0x53, 0x53, 0x08, 0x0F, 0x10, 0x42, 0x8C, 0x09, 0x5F, 0x43, 0x00, 0x07, 0x06, 0x23, 0xCC, 0x10,
    0x07, 0x43, 0x48, 0x48, 0x0E, 0x8C, 0x04, 0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F, 0xB0, 0x03, 0xFF,
    0x09, 0x1F, 0x99, 0xB0, 0x03, 0xFF, 0x5F, 0x01, 0xCC, 0x10, 0x03, 0xCF, 0x09, 0x0F, 0xB0, 0x03,
    0x78, 0x04, 0xCC, 0x10, 0x13, 0x3F, 0xB0, 0x03, 0x1D, 0x41, 0xB0, 0x03, 0x1F, 0x01, 0xB0, 0x03,
    0x36, 0x0F, 0x90, 0x03, 0x0D, 0x1F, 0x22, 0x40, 0x07, 0xFF, 0xFF, 0xF2, 0x1F, 0x01, 0x40, 0x07,
    0x0D, 0x1F, 0xB0, 0x40, 0x07, 0x37, 0x2F, 0x20, 0x00, 0x02, 0x00, 0x0A, 0x0F, 0xCC, 0x10, 0xB6,
    0x04, 0x01, 0x00, 0xF4, 0x01, 0x27, 0x00, 0x21, 0x00, 0x28, 0x00, 0x21, 0x00, 0x26, 0x00, 0x23,
    0x00, 0x2A, 0x00, 0x22, 0x00, 0x48, 0x03, 0x0C, 0x18, 0x00, 0x0F, 0x01, 0x00, 0xFF, 0x36, 0x08,
    0xCC, 0x10, 0x00, 0xC8, 0x0F, 0x1F, 0x20, 0xCC, 0x10, 0xA8, 0x12, 0x0C, 0xF4, 0x0F, 0x05, 0xCC,
    0x10, 0x13, 0x06, 0x9C, 0x10, 0x00, 0xC3, 0x05, 0x13, 0x0F, 0x68, 0x05, 0x13, 0x02, 0x74, 0x05,
    0x13, 0x0D, 0x1C, 0x00, 0x13, 0x07, 0x38, 0x00, 0x13, 0x08, 0x90, 0x06, 0x00, 0x50, 0x06, 0xBF,
    0x03, 0x03, 0x06, 0x05, 0x0C, 0x08, 0x0D, 0x00, 0x19, 0x24, 0x6C, 0xCC, 0x10, 0x1E, 0x13, 0xD0,
    0xCC, 0x10, 0xF7, 0x06, 0x03, 0x12, 0x00, 0x00, 0x3D, 0x00, 0x80, 0x00, 0x38, 0x00, 0x80, 0x00,
    0x41, 0x00, 0x80, 0x00, 0x90, 0x00, 0x80, 0x00, 0x05, 0x08, 0x00, 0x70, 0x49, 0x00, 0x34, 0x00,
    0x80, 0x00, 0x80, 0xFA, 0x14, 0x62, 0x00, 0x16, 0x00, 0x08, 0x00, 0x80, 0x06, 0x15, 0x23, 0x00,
    0x19, 0x04, 0x00, 0x91, 0x18, 0x00, 0x80, 0x00, 0x95, 0x00, 0x80, 0x00, 0x1D, 0x26, 0x00, 0x31,
    0x00, 0x00, 0x2C, 0xDC, 0x00, 0x11, 0x80, 0x98, 0x06, 0x17, 0x08, 0xCC, 0x10, 0x17, 0x09, 0xBC,
    0x17, 0x1F, 0x00, 0xCC, 0x10, 0x10, 0x79, 0x56, 0x01, 0x55, 0x05, 0x55, 0x05, 0x02, 0x0C, 0x00,
    0x13, 0x01, 0xDC, 0x07, 0x00, 0x01, 0x00, 0x13, 0x2F, 0x08, 0x00, 0x57, 0x54, 0x00, 0x01, 0x08,
    0x2D, 0xCC, 0x10, 0x2F, 0x48, 0x48, 0xCC, 0x10, 0x1B, 0x1B, 0x35, 0xCC, 0x10, 0x00, 0x50, 0x10,
    0x00, 0x07, 0x00, 0x80, 0x9C, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

constexpr const u8 T210b01SdevEmcDvfsTableS1y4gbX03[0x67D] = {
    0xFF, 0x18, 0x03, 0x00, 0x00, 0x00, 0x30, 0x31, 0x5F, 0x32, 0x30, 0x34, 0x30, 0x30, 0x30, 0x5F,
    0x4E, 0x6F, 0x43, 0x66, 0x67, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6F, 0x6E, 0x5F, 0x56, 0x30, 0x2E,
    0x34, 0x2E, 0x32, 0x5F, 0x56, 0x32, 0x2E, 0x30, 0x00, 0x01, 0x00, 0x06, 0x71, 0xE0, 0x1C, 0x03,
    0x00, 0x4C, 0x04, 0x00, 0x04, 0x00, 0x8F, 0x70, 0x6C, 0x6C, 0x70, 0x5F, 0x6F, 0x75, 0x74, 0x2F,
    0x00, 0x05, 0x5F, 0x02, 0x80, 0x18, 0x40, 0x00, 0x01, 0x00, 0x40, 0xFF, 0x1E, 0x3F, 0x3A, 0x00,
    0x00, 0x0D, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
    0x00, 0x8A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
    0x00, 0x04, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x05, 0x50, 0x00, 0x10, 0x17, 0x0A, 0x04,
    0x00, 0x22, 0x01, 0x00, 0x5C, 0x00, 0x57, 0x3A, 0x00, 0x00, 0x00, 0x1D, 0x24, 0x00, 0x13, 0x09,
    0x54, 0x00, 0x13, 0x0B, 0x20, 0x00, 0x13, 0x08, 0x0C, 0x00, 0x13, 0x00, 0x18, 0x00, 0x53, 0x17,
    0x00, 0x00, 0x00, 0x15, 0x08, 0x00, 0x13, 0x1B, 0x18, 0x00, 0x57, 0x20, 0x00, 0x00, 0x00, 0x06,
    0x04, 0x00, 0x13, 0x03, 0x18, 0x00, 0x13, 0x06, 0x34, 0x00, 0x17, 0x02, 0x40, 0x00, 0x00, 0x50,
    0x00, 0x13, 0x0E, 0x1C, 0x00, 0x08, 0xB4, 0x00, 0x00, 0x34, 0x00, 0x53, 0x31, 0x31, 0x03, 0x88,
    0x0C, 0x9C, 0x00, 0x40, 0x00, 0x00, 0x00, 0x80, 0x0A, 0x00, 0x13, 0x12, 0xE8, 0x00, 0x54, 0x1A,
    0x00, 0x00, 0x00, 0x16, 0xF4, 0x00, 0x03, 0x61, 0x00, 0x13, 0xC1, 0x50, 0x00, 0x13, 0x08, 0x40,
    0x00, 0x13, 0x0A, 0x08, 0x00, 0x04, 0x10, 0x01, 0x13, 0x02, 0xC4, 0x00, 0x13, 0x3B, 0x04, 0x00,
    0x13, 0x05, 0x04, 0x00, 0x13, 0x04, 0xE8, 0x00, 0x08, 0x0C, 0x00, 0x53, 0x31, 0x31, 0x03, 0xC8,
    0x1C, 0x58, 0x00, 0x40, 0x0D, 0xA0, 0x60, 0x91, 0x7C, 0x01, 0x31, 0xA0, 0x00, 0x2C, 0x86, 0x00,
    0x11, 0x78, 0x16, 0x00, 0x2F, 0xFF, 0x0F, 0x56, 0x01, 0x03, 0xF1, 0x0C, 0x0B, 0x88, 0x16, 0x00,
    0x0D, 0x00, 0x0B, 0x00, 0x17, 0x00, 0x43, 0x00, 0x45, 0x00, 0x45, 0x00, 0x43, 0x00, 0x46, 0x00,
    0x47, 0x00, 0x41, 0x00, 0x46, 0x00, 0x0C, 0x8E, 0x00, 0x1F, 0x0D, 0x18, 0x00, 0x06, 0x20, 0x16,
    0x00, 0x3A, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x3E, 0x00, 0x11, 0x17, 0xE0, 0x00, 0x0F, 0x01, 0x00,
    0x8D, 0x80, 0x1F, 0x22, 0x20, 0x80, 0x0F, 0xF4, 0x20, 0x02, 0x98, 0x01, 0xF0, 0x0E, 0x00, 0x40,
    0x06, 0x00, 0xCC, 0x00, 0x09, 0x00, 0x10, 0x00, 0xCC, 0x00, 0x0A, 0x00, 0x33, 0x00, 0x02, 0x03,
    0xE0, 0xC1, 0x20, 0x41, 0x13, 0x1F, 0x14, 0x00, 0x01, 0x00, 0x99, 0x5C, 0x01, 0x60, 0x08, 0x00,
    0x00, 0x50, 0x50, 0x50, 0x22, 0x02, 0x10, 0xF3, 0x40, 0x01, 0x57, 0x13, 0x07, 0x00, 0x80, 0x0A,
    0x4C, 0x00, 0x13, 0x12, 0x04, 0x00, 0x02, 0x00, 0x02, 0x11, 0x05, 0x9F, 0x01, 0x23, 0x10, 0x02,
    0x51, 0x02, 0x00, 0xE4, 0x02, 0x13, 0x04, 0x92, 0x02, 0x2F, 0x34, 0x10, 0x90, 0x00, 0x06, 0x03,
    0x79, 0x03, 0x09, 0x21, 0x00, 0x9F, 0x80, 0x00, 0x40, 0x00, 0x04, 0x10, 0x80, 0x00, 0x20, 0xC9,
    0x00, 0x09, 0x34, 0xEF, 0x00, 0xEF, 0x0B, 0x00, 0x48, 0x1C, 0x1C, 0x1C, 0x1C, 0x1B, 0x00, 0x22,
    0x10, 0x10, 0x04, 0x00, 0x44, 0x33, 0x60, 0x18, 0x01, 0x14, 0x00, 0x13, 0x18, 0x60, 0x02, 0x00,
    0x88, 0x02, 0x42, 0x14, 0x14, 0x16, 0x88, 0xB8, 0x00, 0xF0, 0x07, 0x01, 0x00, 0x80, 0x90, 0x00,
    0x00, 0x04, 0x04, 0x07, 0x07, 0x65, 0x00, 0x04, 0x00, 0x1F, 0x80, 0x13, 0x05, 0x00, 0x11, 0x10,
    0x1F, 0x80, 0x02, 0xF0, 0x0F, 0x40, 0x72, 0x10, 0x00, 0x00, 0x40, 0x12, 0x01, 0x6A, 0x5B, 0x12,
    0x01, 0x00, 0x10, 0x08, 0x0F, 0x00, 0x58, 0x10, 0x00, 0x00, 0xFC, 0x10, 0x11, 0x00, 0x13, 0x08,
    0x0F, 0x50, 0x7C, 0x0C, 0x00, 0xF3, 0x07, 0x14, 0x11, 0x00, 0x03, 0x00, 0x07, 0x4C, 0x72, 0x10,
    0x00, 0x5A, 0x3C, 0x55, 0x55, 0x14, 0x14, 0x16, 0xC8, 0x5D, 0x5D, 0x0C, 0x88, 0x04, 0x00, 0x12,
    0xC8, 0x04, 0x00, 0x23, 0x0E, 0x8C, 0x04, 0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F, 0xB0, 0x03, 0xFF,
    0x09, 0x1F, 0x99, 0xB0, 0x03, 0xFF, 0x5E, 0x70, 0x00, 0x80, 0x06, 0x06, 0x00, 0x00, 0x05, 0x17,
    0x02, 0x0F, 0xB0, 0x03, 0x7A, 0x00, 0x8C, 0x02, 0x10, 0x1F, 0x24, 0x00, 0x03, 0x68, 0x02, 0x13,
    0x1E, 0xB0, 0x03, 0x1F, 0x10, 0xB0, 0x03, 0x40, 0x0F, 0x90, 0x03, 0x09, 0x13, 0x0E, 0x04, 0x00,
    0x0F, 0x90, 0x03, 0x21, 0x00, 0x64, 0x01, 0x1F, 0x13, 0x90, 0x03, 0x17, 0x00, 0x33, 0x05, 0x1F,
    0x30, 0x90, 0x03, 0x03, 0x1F, 0x04, 0x40, 0x07, 0xFF, 0xFF, 0x70, 0x1F, 0x01, 0x40, 0x07, 0x0A,
    0x4F, 0x04, 0x00, 0x80, 0xB0, 0x90, 0x03, 0x37, 0x2F, 0x28, 0x00, 0x02, 0x00, 0x0B, 0x0F, 0x01,
    0x00, 0xAD, 0x1B, 0x29, 0x01, 0x00, 0x0C, 0x20, 0x00, 0x04, 0x48, 0x03, 0x0F, 0x01, 0x00, 0xFF,
    0x16, 0x39, 0x49, 0x92, 0x24, 0x04, 0x00, 0x0F, 0x01, 0x00, 0x0D, 0x00, 0xB4, 0x02, 0x40, 0x04,
    0x01, 0x00, 0x00, 0x16, 0x0A, 0x13, 0x18, 0x84, 0x05, 0x0D, 0x50, 0x03, 0x5A, 0x42, 0x0F, 0x00,
    0x60, 0x09, 0x14, 0x00, 0x1E, 0x01, 0x0C, 0x00, 0x0F, 0xFC, 0x00, 0x6E, 0xF7, 0x02, 0x01, 0x00,
    0x00, 0x08, 0x4C, 0x00, 0x00, 0x80, 0x20, 0x10, 0x0A, 0x00, 0x28, 0x10, 0x00, 0x80, 0x01, 0xD8,
    0x09, 0x13, 0x01, 0xFC, 0x05, 0x04, 0x08, 0x00, 0x13, 0x05, 0x0C, 0x00, 0x17, 0x01, 0x84, 0x06,
    0x00, 0x14, 0x00, 0x12, 0x07, 0xFE, 0x0E, 0xD3, 0x02, 0x01, 0x02, 0x03, 0x00, 0x04, 0x05, 0xA3,
    0x72, 0x0F, 0x0F, 0x00, 0x70, 0xE6, 0x04, 0x4F, 0x00, 0x1A, 0x00, 0x80, 0x04, 0x00, 0x0E, 0x11,
    0x1B, 0x10, 0x04, 0xF1, 0x02, 0x80, 0x00, 0x4C, 0x02, 0x00, 0x00, 0xB2, 0x00, 0xFF, 0x00, 0xDA,
    0x00, 0xFF, 0x00, 0x9D, 0x00, 0xFF, 0x02, 0x00, 0x17, 0x0C, 0x08, 0x00, 0xF1, 0x02, 0x49, 0x00,
    0x7F, 0x00, 0x80, 0x00, 0xFF, 0x00, 0x04, 0x00, 0xFF, 0x00, 0xAD, 0x00, 0x08, 0x00, 0xFF, 0x88,
    0x00, 0x33, 0xFF, 0x00, 0xC6, 0x04, 0x00, 0x13, 0x6D, 0x2C, 0x00, 0x11, 0xE2, 0x06, 0x00, 0x01,
    0x73, 0x06, 0x01, 0x0A, 0x00, 0x13, 0x14, 0xC0, 0x06, 0x2E, 0xF4, 0x01, 0x78, 0x01, 0x13, 0x08,
    0x44, 0x0F, 0x0F, 0x23, 0x01, 0x08, 0x1F, 0xC0, 0x0C, 0x00, 0x04, 0x06, 0xE8, 0x04, 0x05, 0x98,
    0x07, 0xA0, 0x01, 0x88, 0x00, 0x00, 0x02, 0x88, 0x00, 0x00, 0x0D, 0x88, 0x2C, 0x00, 0x00, 0xB4,
    0x0B, 0x08, 0x28, 0x00, 0xA0, 0xD8, 0x51, 0x1A, 0xA0, 0x00, 0x00, 0x50, 0x05, 0x00, 0x00, 0x1F,
    0x00, 0x31, 0x88, 0x00, 0x20, 0xFD, 0x04, 0x15, 0x88, 0x04, 0x00, 0x50, 0x25, 0x08, 0x11, 0x00,
    0x0C, 0x46, 0x00, 0x07, 0x50, 0x10, 0x00, 0x0C, 0x00, 0x26, 0x5C, 0x0D, 0x94, 0x01, 0x7F, 0x30,
    0x31, 0x5F, 0x31, 0x36, 0x30, 0x30, 0xCD, 0x10, 0x23, 0x28, 0x6A, 0x18, 0xCC, 0x10, 0x4F, 0x6D,
    0x5F, 0x75, 0x64, 0x2C, 0x00, 0x07, 0x21, 0x80, 0x18, 0x0C, 0x02, 0x2F, 0xF0, 0x02, 0xB4, 0x02,
    0x3B, 0x22, 0xFF, 0x3B, 0x6C, 0x06, 0x0F, 0xCC, 0x10, 0x45, 0x10, 0x60, 0x79, 0x01, 0x47, 0x01,
    0x00, 0x00, 0xE0, 0x24, 0x00, 0x13, 0x44, 0x9C, 0x09, 0x13, 0x29, 0x64, 0x00, 0x00, 0x1C, 0x09,
    0x17, 0x2D, 0x4C, 0x09, 0x00, 0xBC, 0x09, 0x97, 0x23, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00,
    0x41, 0x8C, 0x09, 0x13, 0x1D, 0x04, 0x00, 0x13, 0x10, 0xA8, 0x09, 0x13, 0x16, 0xEC, 0x03, 0x13,
    0x0E, 0x44, 0x00, 0x17, 0x0A, 0xDC, 0x09, 0x00, 0x08, 0x00, 0x13, 0x24, 0x0C, 0x00, 0x12, 0x1C,
    0x8C, 0x09, 0x10, 0x10, 0xC4, 0x00, 0x57, 0xF1, 0xF1, 0x03, 0x88, 0x1C, 0x8C, 0x09, 0x93, 0x0C,
    0x00, 0x06, 0x00, 0x33, 0x00, 0x00, 0x00, 0x39, 0x4C, 0x09, 0x13, 0x37, 0x0C, 0x00, 0x23, 0x20,
    0x18, 0x90, 0x02, 0x12, 0x06, 0x70, 0x00, 0x13, 0x10, 0xF0, 0x01, 0x13, 0x17, 0x08, 0x00, 0x13,
    0x38, 0x64, 0x00, 0x00, 0x8F, 0x01, 0x62, 0x2E, 0x00, 0x00, 0x00, 0xCC, 0x01, 0x04, 0x00, 0x13,
    0x0D, 0x34, 0x01, 0x13, 0x0C, 0xC4, 0x07, 0x17, 0x22, 0x40, 0x01, 0x66, 0xF1, 0xF1, 0x03, 0xC8,
    0x60, 0x18, 0x8C, 0x09, 0x00, 0x7C, 0x01, 0x4F, 0xBB, 0x01, 0x00, 0xC0, 0x8C, 0x09, 0x0D, 0xB5,
    0x06, 0x06, 0x0B, 0x88, 0x0D, 0x00, 0x08, 0x00, 0x06, 0x00, 0x0E, 0x60, 0x0A, 0x13, 0x03, 0xC0,
    0x0A, 0x11, 0x07, 0x82, 0x00, 0x1F, 0x08, 0x18, 0x00, 0x06, 0x00, 0x88, 0x09, 0x11, 0x08, 0x20,
    0x00, 0x00, 0x3E, 0x00, 0x3F, 0x0E, 0x00, 0x0D, 0x8C, 0x09, 0xA0, 0xD0, 0x40, 0x06, 0x31, 0x00,
    0x2F, 0x00, 0x40, 0x06, 0x17, 0x00, 0x90, 0x01, 0x09, 0x8C, 0x09, 0x12, 0x61, 0x8C, 0x09, 0x5B,
    0xB0, 0x04, 0x00, 0x00, 0x0D, 0x8C, 0x09, 0x5F, 0x8C, 0x30, 0x00, 0x80, 0x2B, 0x1C, 0x0D, 0x05,
    0x21, 0x00, 0x06, 0xCB, 0x0B, 0x13, 0x11, 0x8C, 0x09, 0x81, 0x84, 0x10, 0x02, 0x40, 0x85, 0x14,
    0x02, 0x40, 0x8C, 0x09, 0x1F, 0x20, 0x8C, 0x09, 0x40, 0x1F, 0x00, 0x8C, 0x09, 0x0F, 0x26, 0x90,
    0x61, 0xCC, 0x10, 0x00, 0x78, 0x02, 0x13, 0x2B, 0x88, 0x02, 0x00, 0x8C, 0x09, 0x11, 0x33, 0x48,
    0x02, 0x15, 0x06, 0x1C, 0x0D, 0x2F, 0x20, 0x03, 0x8C, 0x09, 0x14, 0x53, 0x53, 0x08, 0x0F, 0x10,
    0x42, 0x8C, 0x09, 0x5F, 0x43, 0x00, 0x07, 0x06, 0x23, 0xCC, 0x10, 0x07, 0x43, 0x48, 0x48, 0x0E,
    0x8C, 0x04, 0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F, 0xB0, 0x03, 0xFF, 0x09, 0x1F, 0x99, 0xB0, 0x03,
    0xFF, 0x5F, 0x01, 0xCC, 0x10, 0x03, 0xCF, 0x09, 0x0F, 0xB0, 0x03, 0x78, 0x04, 0xCC, 0x10, 0x13,
    0x3F, 0xB0, 0x03, 0x1F, 0x41, 0xB0, 0x03, 0x48, 0x0F, 0x90, 0x03, 0x0D, 0x1F, 0x22, 0x40, 0x07,
    0xFF, 0xFF, 0xF2, 0x1F, 0x01, 0x40, 0x07, 0x0D, 0x1F, 0xB0, 0x90, 0x03, 0x37, 0x2F, 0x20, 0x00,
    0x02, 0x00, 0x0A, 0x0F, 0xCC, 0x10, 0xBE, 0xF4, 0x01, 0x27, 0x00, 0x21, 0x00, 0x27, 0x00, 0x20,
    0x00, 0x26, 0x00, 0x23, 0x00, 0x2A, 0x00, 0x22, 0x00, 0x48, 0x03, 0x0C, 0x18, 0x00, 0x0F, 0x01,
    0x00, 0xFF, 0x36, 0x08, 0xCC, 0x10, 0x16, 0x07, 0x33, 0x14, 0x0F, 0xCC, 0x10, 0xA2, 0x12, 0x0C,
    0xF4, 0x0F, 0x05, 0xCC, 0x10, 0x13, 0x06, 0x9C, 0x10, 0x00, 0xC3, 0x05, 0x13, 0x0F, 0x04, 0x00,
    0x13, 0x03, 0x04, 0x00, 0x17, 0x0D, 0xCC, 0x10, 0x13, 0x0C, 0x78, 0x06, 0x13, 0x0A, 0x50, 0x06,
    0xBF, 0x00, 0x00, 0x06, 0x05, 0x0C, 0x08, 0x0D, 0x00, 0x19, 0x24, 0x6C, 0xCC, 0x10, 0x1E, 0x13,
    0xD0, 0xCC, 0x10, 0xF7, 0x06, 0x03, 0x12, 0x00, 0x00, 0x3D, 0x00, 0x80, 0x00, 0x38, 0x00, 0x80,
    0x00, 0x41, 0x00, 0x80, 0x00, 0x90, 0x00, 0x80, 0x00, 0x05, 0x08, 0x00, 0x70, 0x49, 0x00, 0x34,
    0x00, 0x80, 0x00, 0x80, 0xFA, 0x14, 0x62, 0x00, 0x16, 0x00, 0x08, 0x00, 0x80, 0x06, 0x15, 0x23,
    0x00, 0x19, 0x04, 0x00, 0x91, 0x18, 0x00, 0x80, 0x00, 0x95, 0x00, 0x80, 0x00, 0x1D, 0x26, 0x00,
    0x31, 0x00, 0x00, 0x2C, 0xDC, 0x00, 0x11, 0x80, 0x98, 0x06, 0x17, 0x08, 0xCC, 0x10, 0x17, 0x09,
    0xBC, 0x17, 0x1F, 0x00, 0xCC, 0x10, 0x10, 0x79, 0x56, 0x01, 0x55, 0x05, 0x55, 0x05, 0x02, 0x0C,
    0x00, 0x13, 0x01, 0xDC, 0x07, 0x00, 0x01, 0x00, 0x13, 0x2F, 0x08, 0x00, 0x57, 0x54, 0x00, 0x01,
    0x88, 0x2D, 0xCC, 0x10, 0x2F, 0x48, 0x48, 0xCC, 0x10, 0x1B, 0x1B, 0x35, 0xCC, 0x10, 0x00, 0x50,
    0x10, 0x00, 0x07, 0x00, 0x80, 0x9C, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

constexpr const u8 T210b01SdevEmcDvfsTableS1z4gb01[0x67B] = {
    0xFF, 0x18, 0x03, 0x00, 0x00, 0x00, 0x30, 0x31, 0x5F, 0x32, 0x30, 0x34, 0x30, 0x30, 0x30, 0x5F,
    0x4E, 0x6F, 0x43, 0x66, 0x67, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6F, 0x6E, 0x5F, 0x56, 0x30, 0x2E,
    0x34, 0x2E, 0x35, 0x5F, 0x56, 0x32, 0x2E, 0x30, 0x00, 0x01, 0x00, 0x06, 0x71, 0xE0, 0x1C, 0x03,
    0x00, 0x4C, 0x04, 0x00, 0x04, 0x00, 0x8F, 0x70, 0x6C, 0x6C, 0x70, 0x5F, 0x6F, 0x75, 0x74, 0x2F,
    0x00, 0x05, 0x5F, 0x02, 0x80, 0x18, 0x40, 0x00, 0x01, 0x00, 0x40, 0xFF, 0x1E, 0x3F, 0x3A, 0x00,
    0x00, 0x0D, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
    0x00, 0x8A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
    0x00, 0x04, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x05, 0x50, 0x00, 0x10, 0x17, 0x0A, 0x04,
    0x00, 0x22, 0x01, 0x00, 0x5C, 0x00, 0x57, 0x3A, 0x00, 0x00, 0x00, 0x1D, 0x24, 0x00, 0x13, 0x09,
    0x54, 0x00, 0x13, 0x0B, 0x20, 0x00, 0x13, 0x08, 0x0C, 0x00, 0x13, 0x00, 0x18, 0x00, 0x53, 0x17,
    0x00, 0x00, 0x00, 0x15, 0x08, 0x00, 0x13, 0x1B, 0x18, 0x00, 0x57, 0x20, 0x00, 0x00, 0x00, 0x06,
    0x04, 0x00, 0x13, 0x03, 0x18, 0x00, 0x13, 0x06, 0x34, 0x00, 0x17, 0x02, 0x40, 0x00, 0x00, 0x50,
    0x00, 0x13, 0x0E, 0x1C, 0x00, 0x08, 0xB4, 0x00, 0x00, 0x34, 0x00, 0x53, 0x31, 0x31, 0x03, 0x88,
    0x0C, 0x9C, 0x00, 0x40, 0x00, 0x00, 0x00, 0x80, 0x0A, 0x00, 0x13, 0x12, 0xE8, 0x00, 0x54, 0x1A,
    0x00, 0x00, 0x00, 0x16, 0xF4, 0x00, 0x03, 0x61, 0x00, 0x13, 0xC1, 0x50, 0x00, 0x13, 0x08, 0x40,
    0x00, 0x13, 0x0A, 0x08, 0x00, 0x04, 0x10, 0x01, 0x13, 0x02, 0xC4, 0x00, 0x13, 0x3B, 0x04, 0x00,
    0x13, 0x05, 0x04, 0x00, 0x13, 0x04, 0xE8, 0x00, 0x08, 0x0C, 0x00, 0x53, 0x31, 0x31, 0x03, 0xC8,
    0x1C, 0x58, 0x00, 0x40, 0x0D, 0xA0, 0x60, 0x91, 0x7C, 0x01, 0x31, 0xA0, 0x00, 0x2C, 0x86, 0x00,
    0x11, 0x78, 0x16, 0x00, 0x2F, 0xFF, 0x0F, 0x56, 0x01, 0x03, 0xF1, 0x0C, 0x0B, 0x88, 0x16, 0x00,
    0x0D, 0x00, 0x0B, 0x00, 0x17, 0x00, 0x43, 0x00, 0x45, 0x00, 0x45, 0x00, 0x43, 0x00, 0x46, 0x00,
    0x47, 0x00, 0x41, 0x00, 0x46, 0x00, 0x0C, 0x8E, 0x00, 0x1F, 0x0D, 0x18, 0x00, 0x06, 0x20, 0x16,
    0x00, 0x3A, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x3E, 0x00, 0x11, 0x17, 0xE0, 0x00, 0x0F, 0x01, 0x00,
    0x8D, 0x80, 0x1F, 0x22, 0x20, 0x80, 0x0F, 0xF4, 0x20, 0x02, 0x98, 0x01, 0xF0, 0x0E, 0x00, 0x40,
    0x06, 0x00, 0xCC, 0x00, 0x09, 0x00, 0x10, 0x00, 0xCC, 0x00, 0x0A, 0x00, 0x33, 0x00, 0x02, 0x03,
    0xE0, 0xC1, 0x20, 0x41, 0x13, 0x1F, 0x14, 0x00, 0x01, 0x00, 0x99, 0x5C, 0x01, 0x60, 0x08, 0x00,
    0x00, 0x50, 0x50, 0x50, 0x22, 0x02, 0x10, 0xF3, 0x40, 0x01, 0x57, 0x13, 0x07, 0x00, 0x80, 0x0A,
    0x4C, 0x00, 0x13, 0x12, 0x04, 0x00, 0x02, 0x00, 0x02, 0x11, 0x05, 0x9F, 0x01, 0x23, 0x10, 0x02,
    0x51, 0x02, 0x00, 0xE4, 0x02, 0x13, 0x04, 0x92, 0x02, 0x2F, 0x34, 0x10, 0x90, 0x00, 0x06, 0x03,
    0x79, 0x03, 0x09, 0x21, 0x00, 0x9F, 0x80, 0x00, 0x40, 0x00, 0x04, 0x10, 0x80, 0x00, 0x20, 0xC9,
    0x00, 0x09, 0x34, 0xEF, 0x00, 0xEF, 0x0B, 0x00, 0x48, 0x1C, 0x1C, 0x1C, 0x1C, 0x1B, 0x00, 0x22,
    0x10, 0x10, 0x04, 0x00, 0x44, 0x33, 0x60, 0x18, 0x01, 0x14, 0x00, 0x13, 0x18, 0x60, 0x02, 0x00,
    0x88, 0x02, 0x42, 0x14, 0x14, 0x16, 0x88, 0xB8, 0x00, 0xF0, 0x07, 0x01, 0x00, 0x80, 0x90, 0x00,
    0x00, 0x04, 0x04, 0x07, 0x07, 0x65, 0x00, 0x04, 0x00, 0x1F, 0x80, 0x13, 0x05, 0x00, 0x11, 0x10,
    0x1F, 0x80, 0x02, 0xF0, 0x0F, 0x40, 0x72, 0x10, 0x00, 0x00, 0x40, 0x12, 0x01, 0x6A, 0x5B, 0x12,
    0x01, 0x00, 0x10, 0x08, 0x0F, 0x00, 0x58, 0x10, 0x00, 0x00, 0xFC, 0x10, 0x11, 0x00, 0x13, 0x08,
    0x0F, 0x50, 0x7C, 0x0C, 0x00, 0xF3, 0x07, 0x14, 0x11, 0x00, 0x03, 0x00, 0x07, 0x4C, 0x72, 0x10,
    0x00, 0x5A, 0x3C, 0x55, 0x55, 0x14, 0x14, 0x16, 0xC8, 0x5D, 0x5D, 0x0C, 0x88, 0x04, 0x00, 0x12,
    0xC8, 0x04, 0x00, 0x23, 0x0E, 0x8C, 0x04, 0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F, 0xB0, 0x03, 0xFF,
    0x09, 0x1F, 0x99, 0xB0, 0x03, 0xFF, 0x5E, 0x9F, 0x00, 0x80, 0x06, 0x06, 0x00, 0x00, 0x05, 0x06,
    0x00, 0xB0, 0x03, 0x7C, 0x00, 0x8C, 0x02, 0x10, 0x1F, 0x24, 0x00, 0x03, 0x68, 0x02, 0x13, 0x1E,
    0xB0, 0x03, 0x1F, 0x10, 0xB0, 0x03, 0x40, 0x0F, 0x90, 0x03, 0x09, 0x13, 0x0E, 0x04, 0x00, 0x0F,
    0x90, 0x03, 0x21, 0x00, 0x64, 0x01, 0x1F, 0x13, 0x90, 0x03, 0x17, 0x00, 0x33, 0x05, 0x1F, 0x30,
    0x90, 0x03, 0x03, 0x1F, 0x04, 0x40, 0x07, 0xFF, 0xFF, 0x70, 0x1F, 0x01, 0x40, 0x07, 0x0A, 0x4F,
    0x04, 0x00, 0x80, 0xB0, 0x90, 0x03, 0x37, 0x2F, 0x28, 0x00, 0x02, 0x00, 0x0B, 0x0F, 0x01, 0x00,
    0xAD, 0x1B, 0x29, 0x01, 0x00, 0x0C, 0x20, 0x00, 0x04, 0x48, 0x03, 0x0F, 0x01, 0x00, 0xFF, 0x16,
    0x39, 0x49, 0x92, 0x24, 0x04, 0x00, 0x0F, 0x01, 0x00, 0x0D, 0x00, 0xB4, 0x02, 0x40, 0x04, 0x01,
    0x00, 0x00, 0x16, 0x0A, 0x13, 0x18, 0x84, 0x05, 0x0D, 0x50, 0x03, 0x5A, 0x42, 0x0F, 0x00, 0x60,
    0x09, 0x14, 0x00, 0x1E, 0x01, 0x0C, 0x00, 0x0F, 0xFC, 0x00, 0x6E, 0xF7, 0x02, 0x01, 0x00, 0x00,
    0x08, 0x4C, 0x00, 0x00, 0x80, 0x20, 0x10, 0x0A, 0x00, 0x28, 0x10, 0x00, 0x80, 0x01, 0xD8, 0x09,
    0x13, 0x01, 0xFC, 0x05, 0x04, 0x08, 0x00, 0x13, 0x05, 0x0C, 0x00, 0x17, 0x01, 0x84, 0x06, 0x00,
    0x14, 0x00, 0x12, 0x07, 0xFE, 0x0E, 0xD3, 0x02, 0x01, 0x02, 0x03, 0x00, 0x04, 0x05, 0xA3, 0x72,
    0x0F, 0x0F, 0x00, 0x70, 0xE6, 0x04, 0x4F, 0x00, 0x1A, 0x00, 0x80, 0x04, 0x00, 0x0E, 0x11, 0x1B,
    0x10, 0x04, 0xF1, 0x02, 0x80, 0x00, 0x4C, 0x02, 0x00, 0x00, 0xB2, 0x00, 0xFF, 0x00, 0xDA, 0x00,
    0xFF, 0x00, 0x9D, 0x00, 0xFF, 0x02, 0x00, 0x17, 0x0C, 0x08, 0x00, 0xF1, 0x02, 0x49, 0x00, 0x7F,
    0x00, 0x80, 0x00, 0xFF, 0x00, 0x04, 0x00, 0xFF, 0x00, 0xAD, 0x00, 0x08, 0x00, 0xFF, 0x88, 0x00,
    0x33, 0xFF, 0x00, 0xC6, 0x04, 0x00, 0x13, 0x6D, 0x2C, 0x00, 0x11, 0xE2, 0x06, 0x00, 0x01, 0x73,
    0x06, 0x01, 0x0A, 0x00, 0x13, 0x14, 0xC0, 0x06, 0x2E, 0xF4, 0x01, 0x78, 0x01, 0x13, 0x08, 0x44,
    0x0F, 0x0F, 0x23, 0x01, 0x08, 0x1F, 0xC0, 0x0C, 0x00, 0x04, 0x06, 0xE8, 0x04, 0x05, 0x98, 0x07,
    0xA0, 0x01, 0x88, 0x00, 0x00, 0x02, 0x88, 0x00, 0x00, 0x0D, 0x88, 0x2C, 0x00, 0x00, 0xB4, 0x0B,
    0x08, 0x28, 0x00, 0xA0, 0xD8, 0x51, 0x1A, 0xA0, 0x00, 0x00, 0x50, 0x05, 0x00, 0x00, 0x1F, 0x00,
    0x31, 0x88, 0x00, 0x20, 0xFD, 0x04, 0x15, 0x88, 0x04, 0x00, 0x50, 0x25, 0x08, 0x11, 0x00, 0x0C,
    0x46, 0x00, 0x07, 0x50, 0x10, 0x00, 0x0C, 0x00, 0x26, 0x5C, 0x0D, 0x94, 0x01, 0x7F, 0x30, 0x31,
    0x5F, 0x31, 0x36, 0x30, 0x30, 0xCD, 0x10, 0x23, 0x28, 0x6A, 0x18, 0xCC, 0x10, 0x4F, 0x6D, 0x5F,
    0x75, 0x64, 0x2C, 0x00, 0x07, 0x21, 0x80, 0x18, 0x0C, 0x02, 0x2F, 0xF0, 0x02, 0xB4, 0x02, 0x3B,
    0x22, 0xFF, 0x3B, 0x6C, 0x06, 0x0F, 0xCC, 0x10, 0x45, 0x10, 0x60, 0x79, 0x01, 0x47, 0x01, 0x00,
    0x00, 0xE0, 0x24, 0x00, 0x13, 0x44, 0x9C, 0x09, 0x13, 0x29, 0x64, 0x00, 0x00, 0x1C, 0x09, 0x17,
    0x2D, 0x4C, 0x09, 0x00, 0xBC, 0x09, 0x97, 0x23, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x41,
    0x8C, 0x09, 0x13, 0x1D, 0x04, 0x00, 0x13, 0x10, 0xA8, 0x09, 0x13, 0x16, 0xEC, 0x03, 0x13, 0x0E,
    0x44, 0x00, 0x17, 0x0A, 0xDC, 0x09, 0x00, 0x08, 0x00, 0x13, 0x24, 0x0C, 0x00, 0x12, 0x1C, 0x8C,
    0x09, 0x10, 0x10, 0xC4, 0x00, 0x57, 0xF1, 0xF1, 0x03, 0x88, 0x1C, 0x8C, 0x09, 0x93, 0x0C, 0x00,
    0x06, 0x00, 0x33, 0x00, 0x00, 0x00, 0x39, 0x4C, 0x09, 0x13, 0x37, 0x0C, 0x00, 0x23, 0x20, 0x18,
    0x90, 0x02, 0x12, 0x06, 0x70, 0x00, 0x13, 0x10, 0xF0, 0x01, 0x13, 0x17, 0x08, 0x00, 0x13, 0x38,
    0x64, 0x00, 0x00, 0x8F, 0x01, 0x62, 0x2E, 0x00, 0x00, 0x00, 0xCC, 0x01, 0x04, 0x00, 0x13, 0x0D,
    0x34, 0x01, 0x13, 0x0C, 0xC4, 0x07, 0x17, 0x22, 0x40, 0x01, 0x66, 0xF1, 0xF1, 0x03, 0xC8, 0x60,
    0x18, 0x8C, 0x09, 0x00, 0x7C, 0x01, 0x4F, 0xBB, 0x01, 0x00, 0xC0, 0x8C, 0x09, 0x0D, 0xB5, 0x06,
    0x06, 0x0B, 0x88, 0x0D, 0x00, 0x08, 0x00, 0x06, 0x00, 0x0E, 0x60, 0x0A, 0x13, 0x03, 0xC0, 0x0A,
    0x11, 0x07, 0x82, 0x00, 0x1F, 0x08, 0x18, 0x00, 0x06, 0x00, 0x88, 0x09, 0x11, 0x08, 0x20, 0x00,
    0x00, 0x3E, 0x00, 0x3F, 0x0E, 0x00, 0x0D, 0x8C, 0x09, 0xA0, 0xD0, 0x40, 0x06, 0x31, 0x00, 0x2F,
    0x00, 0x40, 0x06, 0x17, 0x00, 0x90, 0x01, 0x09, 0x8C, 0x09, 0x12, 0x61, 0x8C, 0x09, 0x5B, 0xB0,
    0x04, 0x00, 0x00, 0x0D, 0x8C, 0x09, 0x5F, 0x8C, 0x30, 0x00, 0x80, 0x2B, 0x1C, 0x0D, 0x05, 0x21,
    0x00, 0x06, 0xCB, 0x0B, 0x13, 0x11, 0x8C, 0x09, 0x81, 0x84, 0x10, 0x02, 0x40, 0x85, 0x14, 0x02,
    0x40, 0x8C, 0x09, 0x1F, 0x20, 0x8C, 0x09, 0x40, 0x1F, 0x00, 0x8C, 0x09, 0x0F, 0x26, 0x90, 0x61,
    0xCC, 0x10, 0x00, 0x78, 0x02, 0x13, 0x2B, 0x88, 0x02, 0x00, 0x8C, 0x09, 0x11, 0x33, 0x48, 0x02,
    0x15, 0x06, 0x1C, 0x0D, 0x2F, 0x20, 0x03, 0x8C, 0x09, 0x14, 0x53, 0x53, 0x08, 0x0F, 0x10, 0x42,
    0x8C, 0x09, 0x5F, 0x43, 0x00, 0x07, 0x06, 0x23, 0xCC, 0x10, 0x07, 0x43, 0x48, 0x48, 0x0E, 0x8C,
    0x04, 0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F, 0xB0, 0x03, 0xFF, 0x09, 0x1F, 0x99, 0xB0, 0x03, 0xFF,
    0x5F, 0x12, 0x80, 0xB0, 0x03, 0x1F, 0x00, 0xB0, 0x03, 0x7C, 0x04, 0xCC, 0x10, 0x13, 0x3F, 0xB0,
    0x03, 0x1F, 0x41, 0xB0, 0x03, 0x48, 0x0F, 0x90, 0x03, 0x0D, 0x1F, 0x22, 0x40, 0x07, 0xFF, 0xFF,
    0xF2, 0x1F, 0x01, 0x40, 0x07, 0x0D, 0x1F, 0xB0, 0x90, 0x03, 0x37, 0x2F, 0x20, 0x00, 0x02, 0x00,
    0x0A, 0x0F, 0xCC, 0x10, 0xBE, 0xF4, 0x01, 0x27, 0x00, 0x21, 0x00, 0x27, 0x00, 0x20, 0x00, 0x26,
    0x00, 0x23, 0x00, 0x2A, 0x00, 0x22, 0x00, 0x48, 0x03, 0x0C, 0x18, 0x00, 0x0F, 0x01, 0x00, 0xFF,
    0x36, 0x08, 0xCC, 0x10, 0x16, 0x07, 0x33, 0x14, 0x0F, 0xCC, 0x10, 0xA2, 0x12, 0x0C, 0xF4, 0x0F,
    0x05, 0xCC, 0x10, 0x13, 0x06, 0x9C, 0x10, 0x00, 0xC3, 0x05, 0x13, 0x0F, 0x04, 0x00, 0x13, 0x03,
    0x04, 0x00, 0x17, 0x0D, 0xCC, 0x10, 0x13, 0x0C, 0x78, 0x06, 0x13, 0x0A, 0x50, 0x06, 0xBF, 0x00,
    0x00, 0x06, 0x05, 0x0C, 0x08, 0x0D, 0x00, 0x19, 0x24, 0x6C, 0xCC, 0x10, 0x1E, 0x13, 0xD0, 0xCC,
    0x10, 0xF7, 0x06, 0x03, 0x12, 0x00, 0x00, 0x3D, 0x00, 0x80, 0x00, 0x38, 0x00, 0x80, 0x00, 0x41,
    0x00, 0x80, 0x00, 0x90, 0x00, 0x80, 0x00, 0x05, 0x08, 0x00, 0x70, 0x49, 0x00, 0x34, 0x00, 0x80,
    0x00, 0x80, 0xFA, 0x14, 0x62, 0x00, 0x16, 0x00, 0x08, 0x00, 0x80, 0x06, 0x15, 0x23, 0x00, 0x19,
    0x04, 0x00, 0x91, 0x18, 0x00, 0x80, 0x00, 0x95, 0x00, 0x80, 0x00, 0x1D, 0x26, 0x00, 0x31, 0x00,
    0x00, 0x2C, 0xDC, 0x00, 0x11, 0x80, 0x98, 0x06, 0x17, 0x08, 0xCC, 0x10, 0x17, 0x09, 0xBC, 0x17,
    0x1F, 0x00, 0xCC, 0x10, 0x10, 0x79, 0x56, 0x01, 0x55, 0x05, 0x55, 0x05, 0x02, 0x0C, 0x00, 0x13,
    0x01, 0xDC, 0x07, 0x00, 0x01, 0x00, 0x13, 0x2F, 0x08, 0x00, 0x57, 0x54, 0x00, 0x01, 0x88, 0x2D,
    0xCC, 0x10, 0x2F, 0x48, 0x48, 0xCC, 0x10, 0x1B, 0x1B, 0x35, 0xCC, 0x10, 0x00, 0x50, 0x10, 0x00,
    0x07, 0x00, 0x80, 0x9C, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

constexpr const u8 T210b01SdevEmcDvfsTableH4gb03[0x67D] = {
    0xFF, 0x18, 0x03, 0x00, 0x00, 0x00, 0x30, 0x31, 0x5F, 0x32, 0x30, 0x34, 0x30, 0x30, 0x30, 0x5F,
    0x4E, 0x6F, 0x43, 0x66, 0x67, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6F, 0x6E, 0x5F, 0x56, 0x30, 0x2E,
    0x33, 0x2E, 0x31, 0x5F, 0x56, 0x32, 0x2E, 0x30, 0x00, 0x01, 0x00, 0x06, 0x71, 0xE0, 0x1C, 0x03,
    0x00, 0x4C, 0x04, 0x00, 0x04, 0x00, 0x8F, 0x70, 0x6C, 0x6C, 0x70, 0x5F, 0x6F, 0x75, 0x74, 0x2F,
    0x00, 0x05, 0x5F, 0x02, 0x80, 0x18, 0x40, 0x00, 0x01, 0x00, 0x40, 0xFF, 0x1E, 0x3F, 0x3A, 0x00,
    0x00, 0x0D, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
    0x00, 0x8A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
    0x00, 0x04, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x05, 0x50, 0x00, 0x10, 0x17, 0x0A, 0x04,
    0x00, 0x22, 0x01, 0x00, 0x5C, 0x00, 0x57, 0x3A, 0x00, 0x00, 0x00, 0x1D, 0x24, 0x00, 0x13, 0x09,
    0x54, 0x00, 0x13, 0x0B, 0x20, 0x00, 0x13, 0x08, 0x0C, 0x00, 0x13, 0x00, 0x18, 0x00, 0x53, 0x17,
    0x00, 0x00, 0x00, 0x15, 0x08, 0x00, 0x13, 0x1B, 0x18, 0x00, 0x57, 0x20, 0x00, 0x00, 0x00, 0x06,
    0x04, 0x00, 0x13, 0x03, 0x18, 0x00, 0x13, 0x06, 0x34, 0x00, 0x17, 0x02, 0x40, 0x00, 0x00, 0x50,
    0x00, 0x13, 0x0E, 0xB0, 0x00, 0x18, 0x06, 0x44, 0x01, 0x74, 0x00, 0x00, 0x00, 0x31, 0x31, 0x03,
    0x88, 0xF0, 0x00, 0x40, 0x00, 0x00, 0x00, 0x80, 0x0A, 0x00, 0x13, 0x12, 0xE8, 0x00, 0x54, 0x1A,
    0x00, 0x00, 0x00, 0x16, 0xF4, 0x00, 0x03, 0x61, 0x00, 0x13, 0xC1, 0x50, 0x00, 0x13, 0x08, 0x74,
    0x00, 0x13, 0x0A, 0x08, 0x00, 0x04, 0x10, 0x01, 0x13, 0x02, 0xC4, 0x00, 0x13, 0x3B, 0x04, 0x00,
    0x13, 0x05, 0x04, 0x00, 0x13, 0x04, 0xE8, 0x00, 0x08, 0x0C, 0x00, 0x53, 0x31, 0x31, 0x03, 0xC8,
    0x1C, 0x58, 0x00, 0x40, 0x0D, 0xA0, 0x60, 0x91, 0x7C, 0x01, 0x31, 0xA0, 0x00, 0x2C, 0x86, 0x00,
    0x11, 0x78, 0x16, 0x00, 0x2F, 0xFF, 0x0F, 0x56, 0x01, 0x03, 0xF1, 0x0C, 0x0B, 0x88, 0x16, 0x00,
    0x0D, 0x00, 0x0B, 0x00, 0x17, 0x00, 0x43, 0x00, 0x45, 0x00, 0x45, 0x00, 0x43, 0x00, 0x46, 0x00,
    0x47, 0x00, 0x41, 0x00, 0x46, 0x00, 0x0C, 0x8E, 0x00, 0x1F, 0x0D, 0x18, 0x00, 0x06, 0x20, 0x16,
    0x00, 0x3A, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x3E, 0x00, 0x11, 0x17, 0xE0, 0x00, 0x0F, 0x01, 0x00,
    0x8D, 0x80, 0x1F, 0x22, 0x20, 0x80, 0x0F, 0xF4, 0x20, 0x02, 0x98, 0x01, 0xF0, 0x0E, 0x00, 0x40,
    0x06, 0x00, 0xCC, 0x00, 0x09, 0x00, 0x10, 0x00, 0xCC, 0x00, 0x0A, 0x00, 0x33, 0x00, 0x02, 0x03,
    0xE0, 0xC1, 0x20, 0x41, 0x13, 0x1F, 0x14, 0x00, 0x01, 0x00, 0x99, 0x5C, 0x01, 0x60, 0x08, 0x00,
    0x00, 0x50, 0x50, 0x50, 0x22, 0x02, 0x10, 0xF3, 0x40, 0x01, 0x22, 0x13, 0x07, 0xA4, 0x01, 0x04,
    0x4C, 0x00, 0x13, 0x12, 0x04, 0x00, 0x11, 0x00, 0xB8, 0x01, 0x11, 0x05, 0x9F, 0x01, 0x23, 0x10,
    0x02, 0x51, 0x02, 0x00, 0xE4, 0x02, 0x13, 0x04, 0x92, 0x02, 0x2F, 0x34, 0x10, 0x90, 0x00, 0x06,
    0x03, 0x79, 0x03, 0x09, 0x21, 0x00, 0x9F, 0x80, 0x00, 0x40, 0x00, 0x04, 0x10, 0x80, 0x00, 0x20,
    0xC9, 0x00, 0x09, 0x34, 0xEF, 0x00, 0xEF, 0x0B, 0x00, 0x48, 0x1C, 0x1C, 0x1C, 0x1C, 0x1B, 0x00,
    0x22, 0x10, 0x10, 0x04, 0x00, 0x44, 0x33, 0x60, 0x18, 0x01, 0x14, 0x00, 0x13, 0x18, 0x60, 0x02,
    0x01, 0x88, 0x02, 0x32, 0x16, 0x16, 0x88, 0xB8, 0x00, 0xF0, 0x07, 0x01, 0x00, 0x80, 0x90, 0x00,
    0x00, 0x04, 0x04, 0x07, 0x07, 0x65, 0x00, 0x04, 0x00, 0x1F, 0x80, 0x13, 0x05, 0x00, 0x11, 0x10,
    0x1F, 0x80, 0x02, 0xF0, 0x0F, 0x40, 0x72, 0x10, 0x00, 0x00, 0x40, 0x12, 0x01, 0x6A, 0x5B, 0x12,
    0x01, 0x00, 0x10, 0x08, 0x0F, 0x00, 0x58, 0x10, 0x00, 0x00, 0xFC, 0x10, 0x11, 0x00, 0x13, 0x08,
    0x0F, 0x50, 0x7C, 0x0C, 0x00, 0xF3, 0x07, 0x14, 0x11, 0x00, 0x03, 0x00, 0x07, 0x4C, 0x72, 0x10,
    0x00, 0x5A, 0x3C, 0x55, 0x55, 0x16, 0x16, 0x16, 0xC8, 0x5D, 0x5D, 0x0C, 0x88, 0x04, 0x00, 0x12,
    0xC8, 0x04, 0x00, 0x23, 0x0E, 0x8C, 0x04, 0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F, 0xB0, 0x03, 0xFF,
    0x09, 0x1F, 0x99, 0xB0, 0x03, 0xFF, 0x5E, 0x72, 0x00, 0x80, 0x06, 0x06, 0x00, 0x00, 0x05, 0x13,
    0x02, 0x0F, 0xB0, 0x03, 0x78, 0x00, 0x8C, 0x02, 0x10, 0x1F, 0x24, 0x00, 0x03, 0x68, 0x02, 0x13,
    0x1E, 0xB0, 0x03, 0x1F, 0x10, 0xB0, 0x03, 0x40, 0x0F, 0x90, 0x03, 0x09, 0x13, 0x0E, 0x04, 0x00,
    0x0F, 0x90, 0x03, 0x21, 0x13, 0x13, 0x04, 0x00, 0x0F, 0x90, 0x03, 0x14, 0x22, 0x30, 0x02, 0x04,
    0x00, 0x0F, 0x90, 0x03, 0x00, 0x1F, 0x04, 0x40, 0x07, 0xFF, 0xFF, 0x70, 0x1F, 0x01, 0x40, 0x07,
    0x0A, 0x4F, 0x04, 0x00, 0x80, 0xB0, 0x90, 0x03, 0x37, 0x2F, 0x28, 0x00, 0x02, 0x00, 0x0B, 0x0F,
    0x01, 0x00, 0xAD, 0x1B, 0x29, 0x01, 0x00, 0x0C, 0x20, 0x00, 0x04, 0x48, 0x03, 0x0F, 0x01, 0x00,
    0xFF, 0x16, 0x39, 0x49, 0x92, 0x24, 0x04, 0x00, 0x0F, 0x01, 0x00, 0x0D, 0x00, 0xB4, 0x02, 0x40,
    0x04, 0x01, 0x00, 0x00, 0x16, 0x0A, 0x1B, 0x18, 0x10, 0x09, 0x05, 0x50, 0x03, 0x5A, 0x42, 0x0F,
    0x00, 0x60, 0x09, 0x14, 0x00, 0x1E, 0x01, 0x0C, 0x00, 0x0F, 0xFC, 0x00, 0x6E, 0xF5, 0x02, 0x01,
    0x00, 0x00, 0x08, 0x4C, 0x00, 0x00, 0x80, 0x20, 0x10, 0x0A, 0x00, 0x28, 0x10, 0x00, 0x80, 0x01,
    0x48, 0x04, 0x02, 0xA4, 0x00, 0x17, 0x02, 0x08, 0x00, 0x13, 0x05, 0x0C, 0x00, 0x17, 0x01, 0x84,
    0x06, 0x00, 0x14, 0x00, 0x12, 0x07, 0x0A, 0x0A, 0xD3, 0x02, 0x01, 0x02, 0x03, 0x00, 0x04, 0x05,
    0xA3, 0x72, 0x0F, 0x0F, 0x00, 0x70, 0xE6, 0x04, 0x4F, 0x00, 0x1A, 0x00, 0x80, 0x04, 0x00, 0x0E,
    0x11, 0x1B, 0x10, 0x04, 0xF1, 0x02, 0x80, 0x00, 0x4C, 0x02, 0x00, 0x00, 0xB2, 0x00, 0xFF, 0x00,
    0xDA, 0x00, 0xFF, 0x00, 0x9D, 0x00, 0xFF, 0x02, 0x00, 0x17, 0x0C, 0x08, 0x00, 0xF1, 0x02, 0x49,
    0x00, 0x7F, 0x00, 0x80, 0x00, 0xFF, 0x00, 0x04, 0x00, 0xFF, 0x00, 0xAD, 0x00, 0x08, 0x00, 0xFF,
    0x88, 0x00, 0x33, 0xFF, 0x00, 0xC6, 0x04, 0x00, 0x13, 0x6D, 0x2C, 0x00, 0x11, 0xE2, 0x06, 0x00,
    0x01, 0x73, 0x06, 0x01, 0x0A, 0x00, 0x13, 0x14, 0xC0, 0x06, 0x2E, 0xF4, 0x01, 0x78, 0x01, 0x13,
    0x08, 0x44, 0x0F, 0x0F, 0x23, 0x01, 0x08, 0x1F, 0xC0, 0x0C, 0x00, 0x04, 0x06, 0xE8, 0x04, 0x05,
    0x98, 0x07, 0xA0, 0x01, 0x88, 0x00, 0x00, 0x02, 0x88, 0x00, 0x00, 0x0D, 0x88, 0x2C, 0x00, 0x00,
    0xB4, 0x0B, 0x08, 0x28, 0x00, 0x42, 0xD8, 0x51, 0x1A, 0xA0, 0x0A, 0x00, 0x11, 0x88, 0x04, 0x00,
    0x26, 0x20, 0x12, 0x0C, 0x00, 0x00, 0x04, 0x00, 0x50, 0x25, 0x08, 0x11, 0x00, 0x0C, 0x46, 0x00,
    0x07, 0x50, 0x10, 0x00, 0x0C, 0x00, 0x26, 0x5C, 0x0D, 0x94, 0x01, 0x7F, 0x30, 0x31, 0x5F, 0x31,
    0x36, 0x30, 0x30, 0xCD, 0x10, 0x23, 0x28, 0x6A, 0x18, 0xCC, 0x10, 0x4F, 0x6D, 0x5F, 0x75, 0x64,
    0x2C, 0x00, 0x07, 0x21, 0x80, 0x18, 0x0C, 0x02, 0x2F, 0xF0, 0x02, 0xB4, 0x02, 0x3B, 0x22, 0xFF,
    0x3B, 0x6C, 0x06, 0x0F, 0xCC, 0x10, 0x45, 0x10, 0x60, 0x79, 0x01, 0x47, 0x01, 0x00, 0x00, 0xE0,
    0x24, 0x00, 0x13, 0x44, 0x9C, 0x09, 0x13, 0x29, 0x64, 0x00, 0x57, 0x0C, 0x00, 0x00, 0x00, 0x2D,
    0x4C, 0x09, 0x00, 0xBC, 0x09, 0x97, 0x23, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x41, 0x8C,
    0x09, 0x13, 0x1D, 0x04, 0x00, 0x13, 0x10, 0x98, 0x00, 0x13, 0x16, 0xEC, 0x03, 0x13, 0x0E, 0x44,
    0x00, 0x17, 0x0A, 0xDC, 0x09, 0x13, 0x0E, 0x44, 0x00, 0x12, 0x09, 0xD0, 0x09, 0x00, 0x7F, 0x07,
    0x10, 0x10, 0xBC, 0x09, 0x57, 0xF1, 0xF1, 0x03, 0x88, 0x1D, 0x8C, 0x09, 0x93, 0x0B, 0x00, 0x06,
    0x00, 0x33, 0x00, 0x00, 0x00, 0x39, 0x4C, 0x09, 0x13, 0x37, 0x0C, 0x00, 0x23, 0x20, 0x18, 0x90,
    0x02, 0x12, 0x06, 0x70, 0x00, 0x13, 0x10, 0xF0, 0x01, 0x13, 0x17, 0x08, 0x00, 0x13, 0x38, 0x64,
    0x00, 0x00, 0x8F, 0x01, 0x62, 0x2E, 0x00, 0x00, 0x00, 0xCC, 0x01, 0x04, 0x00, 0x13, 0x0D, 0x9C,
    0x00, 0x13, 0x0C, 0xC4, 0x07, 0x17, 0x22, 0x40, 0x01, 0x66, 0xF1, 0xF1, 0x03, 0xC8, 0x60, 0x18,
    0x8C, 0x09, 0x00, 0x7C, 0x01, 0x4F, 0xBB, 0x01, 0x00, 0xC0, 0x8C, 0x09, 0x0D, 0xD3, 0x06, 0x06,
    0x0B, 0x88, 0x0D, 0x00, 0x08, 0x00, 0x06, 0x00, 0x0E, 0x00, 0x06, 0x88, 0x01, 0x13, 0x03, 0xC0,
    0x0A, 0x11, 0x07, 0x82, 0x00, 0x1F, 0x08, 0x18, 0x00, 0x06, 0x00, 0x88, 0x09, 0x11, 0x08, 0x20,
    0x00, 0x00, 0x3E, 0x00, 0x3F, 0x0E, 0x00, 0x0D, 0x8C, 0x09, 0xA0, 0xD0, 0x40, 0x06, 0x31, 0x00,
    0x2F, 0x00, 0x40, 0x06, 0x17, 0x00, 0x90, 0x01, 0x09, 0x8C, 0x09, 0x12, 0x61, 0x8C, 0x09, 0x5B,
    0xB0, 0x04, 0x00, 0x00, 0x0D, 0x8C, 0x09, 0x5F, 0x8C, 0x30, 0x00, 0x00, 0x2B, 0x1C, 0x0D, 0x05,
    0x21, 0x00, 0x06, 0xCB, 0x0B, 0x13, 0x11, 0x8C, 0x09, 0x81, 0x84, 0x10, 0x02, 0x40, 0x85, 0x14,
    0x02, 0x40, 0x26, 0x02, 0x1F, 0x20, 0x8C, 0x09, 0x40, 0x1F, 0x00, 0x8C, 0x09, 0x0F, 0x26, 0x90,
    0x61, 0xCC, 0x10, 0x00, 0x78, 0x02, 0x13, 0x2B, 0x88, 0x02, 0x00, 0x8C, 0x09, 0x11, 0x33, 0xCC,
    0x01, 0x15, 0x06, 0x1C, 0x0D, 0x2F, 0x20, 0x03, 0x8C, 0x09, 0x14, 0x53, 0x53, 0x08, 0x0F, 0x10,
    0x42, 0x8C, 0x09, 0x5F, 0x43, 0x00, 0x07, 0x00, 0x23, 0xCC, 0x10, 0x07, 0x43, 0x48, 0x48, 0x0E,
    0x8C, 0x04, 0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F, 0xB0, 0x03, 0xFF, 0x09, 0x1F, 0x99, 0xB0, 0x03,
    0xFF, 0x5F, 0x01, 0xCC, 0x10, 0x03, 0xCF, 0x09, 0x0F, 0xB0, 0x03, 0x78, 0x04, 0xCC, 0x10, 0x13,
    0x3F, 0xB0, 0x03, 0x1F, 0x41, 0xB0, 0x03, 0x48, 0x0F, 0x90, 0x03, 0x0D, 0x1F, 0x22, 0x40, 0x07,
    0xFF, 0xFF, 0xF2, 0x1F, 0x01, 0x40, 0x07, 0x0D, 0x1F, 0xB0, 0x90, 0x03, 0x37, 0x2F, 0x20, 0x00,
    0x02, 0x00, 0x0A, 0x0F, 0xCC, 0x10, 0xBE, 0xF4, 0x01, 0x27, 0x00, 0x21, 0x00, 0x27, 0x00, 0x20,
    0x00, 0x26, 0x00, 0x23, 0x00, 0x2A, 0x00, 0x22, 0x00, 0x48, 0x03, 0x0C, 0x18, 0x00, 0x0F, 0x01,
    0x00, 0xFF, 0x36, 0x08, 0xCC, 0x10, 0x16, 0x07, 0x33, 0x14, 0x0F, 0xCC, 0x10, 0xA2, 0x12, 0x0C,
    0xF4, 0x0F, 0x05, 0xCC, 0x10, 0x13, 0x06, 0x9C, 0x10, 0x00, 0xC3, 0x05, 0x13, 0x0F, 0x04, 0x00,
    0x13, 0x03, 0x04, 0x00, 0x17, 0x0D, 0xCC, 0x10, 0x13, 0x0C, 0x84, 0x06, 0x13, 0x0A, 0x50, 0x06,
    0xBF, 0x00, 0x00, 0x06, 0x05, 0x0C, 0x08, 0x0D, 0x00, 0x19, 0x24, 0x6C, 0xCC, 0x10, 0x1E, 0x13,
    0xD0, 0xCC, 0x10, 0xF7, 0x06, 0x03, 0x12, 0x00, 0x00, 0x3D, 0x00, 0x80, 0x00, 0x38, 0x00, 0x80,
    0x00, 0x41, 0x00, 0x80, 0x00, 0x90, 0x00, 0x80, 0x00, 0x05, 0x08, 0x00, 0x70, 0x49, 0x00, 0x34,
    0x00, 0x80, 0x00, 0x80, 0xFA, 0x14, 0x62, 0x00, 0x16, 0x00, 0x08, 0x00, 0x80, 0x06, 0x15, 0x23,
    0x00, 0x19, 0x04, 0x00, 0x91, 0x18, 0x00, 0x80, 0x00, 0x95, 0x00, 0x80, 0x00, 0x1D, 0x26, 0x00,
    0x31, 0x00, 0x00, 0x2C, 0xDC, 0x00, 0x11, 0x80, 0x98, 0x06, 0x17, 0x08, 0xCC, 0x10, 0x17, 0x09,
    0xBC, 0x17, 0x1F, 0x00, 0xCC, 0x10, 0x10, 0x79, 0x56, 0x01, 0x55, 0x05, 0x55, 0x05, 0x02, 0x0C,
    0x00, 0x13, 0x01, 0xDC, 0x07, 0x00, 0x01, 0x00, 0x13, 0x2F, 0x08, 0x00, 0x57, 0x54, 0x00, 0x01,
    0x88, 0x2D, 0xCC, 0x10, 0x2F, 0x48, 0x48, 0xCC, 0x10, 0x1B, 0x1B, 0x35, 0xCC, 0x10, 0x00, 0x50,
    0x10, 0x00, 0x07, 0x00, 0x80, 0x9C, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

constexpr const u8 T210b01SdevEmcDvfsTableM1y4gb01[0x67B] = {
    0xFF, 0x18, 0x03, 0x00, 0x00, 0x00, 0x30, 0x31, 0x5F, 0x32, 0x30, 0x34, 0x30, 0x30, 0x30, 0x5F,
    0x4E, 0x6F, 0x43, 0x66, 0x67, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6F, 0x6E, 0x5F, 0x56, 0x30, 0x2E,
    0x34, 0x2E, 0x32, 0x5F, 0x56, 0x32, 0x2E, 0x30, 0x00, 0x01, 0x00, 0x06, 0x71, 0xE0, 0x1C, 0x03,
    0x00, 0x4C, 0x04, 0x00, 0x04, 0x00, 0x8F, 0x70, 0x6C, 0x6C, 0x70, 0x5F, 0x6F, 0x75, 0x74, 0x2F,
    0x00, 0x05, 0x5F, 0x02, 0x80, 0x18, 0x40, 0x00, 0x01, 0x00, 0x40, 0xFF, 0x1E, 0x3F, 0x3A, 0x00,
    0x00, 0x0D, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
    0x00, 0x8A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
    0x00, 0x04, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x05, 0x50, 0x00, 0x10, 0x17, 0x0A, 0x04,
    0x00, 0x22, 0x01, 0x00, 0x5C, 0x00, 0x57, 0x3A, 0x00, 0x00, 0x00, 0x1D, 0x24, 0x00, 0x13, 0x09,
    0x54, 0x00, 0x13, 0x0B, 0x20, 0x00, 0x13, 0x08, 0x0C, 0x00, 0x13, 0x00, 0x18, 0x00, 0x53, 0x17,
    0x00, 0x00, 0x00, 0x15, 0x08, 0x00, 0x13, 0x1B, 0x18, 0x00, 0x57, 0x20, 0x00, 0x00, 0x00, 0x06,
    0x04, 0x00, 0x13, 0x03, 0x18, 0x00, 0x13, 0x06, 0x34, 0x00, 0x17, 0x02, 0x40, 0x00, 0x00, 0x50,
    0x00, 0x13, 0x0E, 0x1C, 0x00, 0x08, 0xB4, 0x00, 0x00, 0x34, 0x00, 0x53, 0x31, 0x31, 0x03, 0x88,
    0x0C, 0x9C, 0x00, 0x40, 0x00, 0x00, 0x00, 0x80, 0x0A, 0x00, 0x13, 0x12, 0xE8, 0x00, 0x54, 0x1A,
    0x00, 0x00, 0x00, 0x16, 0xF4, 0x00, 0x03, 0x61, 0x00, 0x13, 0xC1, 0x50, 0x00, 0x13, 0x08, 0x40,
    0x00, 0x13, 0x0A, 0x08, 0x00, 0x04, 0x10, 0x01, 0x13, 0x02, 0xC4, 0x00, 0x13, 0x3B, 0x04, 0x00,
    0x13, 0x05, 0x04, 0x00, 0x04, 0x88, 0x00, 0x04, 0x0C, 0x00, 0x12, 0x09, 0x7C, 0x00, 0x23, 0xC8,
    0x1C, 0x58, 0x00, 0x40, 0x0D, 0xA0, 0x60, 0x91, 0x7C, 0x01, 0x31, 0xA0, 0x00, 0x2C, 0x86, 0x00,
    0x11, 0x78, 0x16, 0x00, 0x2F, 0xFF, 0x0F, 0x56, 0x01, 0x03, 0xF1, 0x0C, 0x0B, 0x88, 0x16, 0x00,
    0x0D, 0x00, 0x0B, 0x00, 0x17, 0x00, 0x43, 0x00, 0x45, 0x00, 0x45, 0x00, 0x43, 0x00, 0x46, 0x00,
    0x47, 0x00, 0x41, 0x00, 0x46, 0x00, 0x0C, 0x8E, 0x00, 0x1F, 0x0D, 0x18, 0x00, 0x06, 0x20, 0x16,
    0x00, 0x3A, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x3E, 0x00, 0x11, 0x17, 0xE0, 0x00, 0x0F, 0x01, 0x00,
    0x8D, 0x80, 0x1F, 0x22, 0x20, 0x80, 0x0F, 0xF4, 0x20, 0x02, 0x98, 0x01, 0xF0, 0x0E, 0x00, 0x40,
    0x06, 0x00, 0xCC, 0x00, 0x09, 0x00, 0x10, 0x00, 0xCC, 0x00, 0x0A, 0x00, 0x33, 0x00, 0x02, 0x03,
    0xE0, 0xC1, 0x20, 0x41, 0x13, 0x1F, 0x14, 0x00, 0x01, 0x00, 0x99, 0x5C, 0x01, 0x60, 0x08, 0x00,
    0x00, 0x50, 0x50, 0x50, 0x22, 0x02, 0x10, 0xF3, 0x40, 0x01, 0x57, 0x13, 0x07, 0x00, 0x80, 0x0A,
    0x4C, 0x00, 0x13, 0x12, 0x04, 0x00, 0x02, 0x00, 0x02, 0x11, 0x05, 0x9F, 0x01, 0x23, 0x10, 0x02,
    0x51, 0x02, 0x00, 0xE4, 0x02, 0x13, 0x04, 0x92, 0x02, 0x2F, 0x34, 0x10, 0x90, 0x00, 0x06, 0x03,
    0x79, 0x03, 0x09, 0x21, 0x00, 0x9F, 0x80, 0x00, 0x40, 0x00, 0x04, 0x10, 0x80, 0x00, 0x20, 0xC9,
    0x00, 0x09, 0x34, 0xEF, 0x00, 0xEF, 0x0B, 0x00, 0x48, 0x1C, 0x1C, 0x1C, 0x1C, 0x1B, 0x00, 0x22,
    0x10, 0x10, 0x04, 0x00, 0x44, 0x33, 0x60, 0x18, 0x01, 0x14, 0x00, 0x13, 0x18, 0x60, 0x02, 0x00,
    0x88, 0x02, 0x42, 0x14, 0x14, 0x16, 0x88, 0xB8, 0x00, 0xF0, 0x07, 0x01, 0x00, 0x80, 0x90, 0x00,
    0x00, 0x04, 0x04, 0x07, 0x07, 0x65, 0x00, 0x04, 0x00, 0x1F, 0x80, 0x13, 0x05, 0x00, 0x11, 0x10,
    0x1F, 0x80, 0x02, 0xF0, 0x0F, 0x40, 0x72, 0x10, 0x00, 0x00, 0x40, 0x12, 0x01, 0x6A, 0x5B, 0x12,
    0x01, 0x00, 0x10, 0x08, 0x0F, 0x00, 0x58, 0x10, 0x00, 0x00, 0xFC, 0x10, 0x11, 0x00, 0x13, 0x08,
    0x0F, 0x50, 0x7C, 0x0C, 0x00, 0xF3, 0x07, 0x14, 0x11, 0x00, 0x03, 0x00, 0x07, 0x4C, 0x72, 0x10,
    0x00, 0x5A, 0x3C, 0x55, 0x55, 0x14, 0x14, 0x16, 0xC8, 0x5D, 0x5D, 0x0C, 0x88, 0x04, 0x00, 0x12,
    0xC8, 0x04, 0x00, 0x23, 0x0E, 0x8C, 0x04, 0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F, 0xB0, 0x03, 0xFF,
    0x09, 0x1F, 0x99, 0xB0, 0x03, 0xFF, 0x5E, 0x70, 0x00, 0x80, 0x06, 0x06, 0x00, 0x00, 0x05, 0x17,
    0x02, 0x0F, 0xB0, 0x03, 0x7A, 0x00, 0x8C, 0x02, 0x10, 0x1F, 0x24, 0x00, 0x03, 0x34, 0x02, 0x13,
    0x1E, 0xB0, 0x03, 0x1F, 0x10, 0xB0, 0x03, 0x40, 0x0F, 0x90, 0x03, 0x09, 0x13, 0x0E, 0x04, 0x00,
    0x0F, 0x90, 0x03, 0x21, 0x00, 0x64, 0x01, 0x1F, 0x13, 0x90, 0x03, 0x17, 0x00, 0x33, 0x05, 0x1F,
    0x30, 0x90, 0x03, 0x03, 0x1F, 0x04, 0x40, 0x07, 0xFF, 0xFF, 0x70, 0x1F, 0x01, 0x40, 0x07, 0x0A,
    0x4F, 0x04, 0x00, 0x80, 0xB0, 0x90, 0x03, 0x37, 0x2F, 0x28, 0x00, 0x02, 0x00, 0x0B, 0x0F, 0x01,
    0x00, 0xAD, 0x1B, 0x29, 0x01, 0x00, 0x0C, 0x20, 0x00, 0x04, 0x48, 0x03, 0x0F, 0x01, 0x00, 0xFF,
    0x16, 0x39, 0x49, 0x92, 0x24, 0x04, 0x00, 0x0F, 0x01, 0x00, 0x0D, 0x00, 0xB4, 0x02, 0x40, 0x04,
    0x01, 0x00, 0x00, 0x16, 0x0A, 0x13, 0x18, 0x84, 0x05, 0x0D, 0x50, 0x03, 0x5A, 0x42, 0x0F, 0x00,
    0x60, 0x09, 0x14, 0x00, 0x1E, 0x01, 0x0C, 0x00, 0x0F, 0xFC, 0x00, 0x6E, 0xF7, 0x02, 0x01, 0x00,
    0x00, 0x08, 0x4C, 0x00, 0x00, 0x80, 0x20, 0x10, 0x0A, 0x00, 0x28, 0x10, 0x00, 0x80, 0x01, 0xD8,
    0x09, 0x17, 0x01, 0x04, 0x00, 0x13, 0x02, 0xE8, 0x05, 0x04, 0x10, 0x00, 0x08, 0xFC, 0x05, 0x12,
    0x07, 0xFE, 0x0E, 0xD3, 0x02, 0x01, 0x02, 0x03, 0x00, 0x04, 0x05, 0xA3, 0x72, 0x0F, 0x0F, 0x00,
    0x70, 0xE6, 0x04, 0x4F, 0x00, 0x1A, 0x00, 0x80, 0x04, 0x00, 0x0E, 0x11, 0x1B, 0x10, 0x04, 0xF1,
    0x02, 0x80, 0x00, 0x4C, 0x02, 0x00, 0x00, 0xB2, 0x00, 0xFF, 0x00, 0xDA, 0x00, 0xFF, 0x00, 0x9D,
    0x00, 0xFF, 0x02, 0x00, 0x17, 0x0C, 0x08, 0x00, 0xF1, 0x02, 0x49, 0x00, 0x7F, 0x00, 0x80, 0x00,
    0xFF, 0x00, 0x04, 0x00, 0xFF, 0x00, 0xAD, 0x00, 0x08, 0x00, 0xFF, 0x88, 0x00, 0x33, 0xFF, 0x00,
    0xC6, 0x04, 0x00, 0x13, 0x6D, 0x2C, 0x00, 0x11, 0xE2, 0x06, 0x00, 0x01, 0x73, 0x06, 0x01, 0x0A,
    0x00, 0x13, 0x14, 0xC0, 0x06, 0x2E, 0xF4, 0x01, 0x78, 0x01, 0x13, 0x08, 0x44, 0x0F, 0x0F, 0x23,
    0x01, 0x08, 0x1F, 0xC0, 0x0C, 0x00, 0x04, 0x06, 0xE8, 0x04, 0x05, 0x98, 0x07, 0xA0, 0x01, 0x88,
    0x00, 0x00, 0x02, 0x88, 0x00, 0x00, 0x0D, 0x88, 0x2C, 0x00, 0x00, 0xB4, 0x0B, 0x08, 0x28, 0x00,
    0xA0, 0xD8, 0x51, 0x1A, 0xA0, 0x00, 0x00, 0x50, 0x05, 0x00, 0x00, 0x1F, 0x00, 0x31, 0x88, 0x00,
    0x20, 0xFD, 0x04, 0x15, 0x88, 0x04, 0x00, 0x50, 0x25, 0x08, 0x11, 0x00, 0x0C, 0x46, 0x00, 0x07,
    0x50, 0x10, 0x00, 0x0C, 0x00, 0x26, 0x5C, 0x0D, 0x94, 0x01, 0x7F, 0x30, 0x31, 0x5F, 0x31, 0x36,
    0x30, 0x30, 0xCD, 0x10, 0x23, 0x28, 0x6A, 0x18, 0xCC, 0x10, 0x4F, 0x6D, 0x5F, 0x75, 0x64, 0x2C,
    0x00, 0x07, 0x21, 0x80, 0x18, 0x0C, 0x02, 0x2F, 0xF0, 0x02, 0xB4, 0x02, 0x3B, 0x22, 0xFF, 0x3B,
    0x6C, 0x06, 0x0F, 0xCC, 0x10, 0x45, 0x10, 0x60, 0x79, 0x01, 0x47, 0x01, 0x00, 0x00, 0xE0, 0x24,
    0x00, 0x13, 0x44, 0x9C, 0x09, 0x13, 0x29, 0x64, 0x00, 0x00, 0x1C, 0x09, 0x17, 0x2D, 0x4C, 0x09,
    0x00, 0xBC, 0x09, 0x97, 0x23, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x41, 0x8C, 0x09, 0x13,
    0x1D, 0x04, 0x00, 0x13, 0x0C, 0xA8, 0x09, 0x13, 0x16, 0xEC, 0x03, 0x13, 0x0E, 0x14, 0x00, 0x17,
    0x0A, 0xDC, 0x09, 0x00, 0x08, 0x00, 0x13, 0x24, 0x0C, 0x00, 0x12, 0x1C, 0x8C, 0x09, 0x10, 0x10,
    0xC4, 0x00, 0x57, 0xF1, 0xF1, 0x03, 0x88, 0x1C, 0x8C, 0x09, 0x93, 0x0C, 0x00, 0x06, 0x00, 0x33,
    0x00, 0x00, 0x00, 0x39, 0x4C, 0x09, 0x13, 0x37, 0x0C, 0x00, 0x23, 0x20, 0x18, 0x90, 0x02, 0x12,
    0x06, 0x50, 0x02, 0x13, 0x10, 0xF0, 0x01, 0x13, 0x17, 0x08, 0x00, 0x13, 0x38, 0x64, 0x00, 0x00,
    0x8F, 0x01, 0x62, 0x2E, 0x00, 0x00, 0x00, 0xCC, 0x01, 0x04, 0x00, 0x13, 0x0D, 0x34, 0x01, 0x00,
    0x90, 0x00, 0x00, 0xFA, 0x01, 0x17, 0x22, 0x40, 0x01, 0x66, 0xF1, 0xF1, 0x03, 0xC8, 0x60, 0x18,
    0x8C, 0x09, 0x00, 0x7C, 0x01, 0x4F, 0xBB, 0x01, 0x00, 0xC0, 0x8C, 0x09, 0x0D, 0xB5, 0x06, 0x06,
    0x0B, 0x88, 0x0D, 0x00, 0x08, 0x00, 0x06, 0x00, 0x0E, 0x60, 0x0A, 0x13, 0x03, 0xC0, 0x0A, 0x11,
    0x07, 0x82, 0x00, 0x1F, 0x08, 0x18, 0x00, 0x06, 0x00, 0x88, 0x09, 0x11, 0x08, 0x20, 0x00, 0x00,
    0x3E, 0x00, 0x3F, 0x0E, 0x00, 0x0D, 0x8C, 0x09, 0xA0, 0xD0, 0x40, 0x06, 0x31, 0x00, 0x2F, 0x00,
    0x40, 0x06, 0x17, 0x00, 0x90, 0x01, 0x09, 0x8C, 0x09, 0x12, 0x61, 0x8C, 0x09, 0x5B, 0xB0, 0x04,
    0x00, 0x00, 0x0D, 0x8C, 0x09, 0x5F, 0x8C, 0x30, 0x00, 0x80, 0x2B, 0x1C, 0x0D, 0x05, 0x21, 0x00,
    0x06, 0xCB, 0x0B, 0x13, 0x11, 0x8C, 0x09, 0x81, 0x84, 0x10, 0x02, 0x40, 0x85, 0x14, 0x02, 0x40,
    0x8C, 0x09, 0x1F, 0x20, 0x8C, 0x09, 0x40, 0x1F, 0x00, 0x8C, 0x09, 0x0F, 0x26, 0x90, 0x61, 0xCC,
    0x10, 0x00, 0x78, 0x02, 0x13, 0x2B, 0x88, 0x02, 0x00, 0x8C, 0x09, 0x11, 0x33, 0x48, 0x02, 0x15,
    0x06, 0x1C, 0x0D, 0x2F, 0x20, 0x03, 0x8C, 0x09, 0x14, 0x53, 0x53, 0x08, 0x0F, 0x10, 0x42, 0x8C,
    0x09, 0x5F, 0x43, 0x00, 0x07, 0x06, 0x23, 0xCC, 0x10, 0x07, 0x43, 0x48, 0x48, 0x0E, 0x8C, 0x04,
    0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F, 0xB0, 0x03, 0xFF, 0x09, 0x1F, 0x99, 0xB0, 0x03, 0xFF, 0x5F,
    0x01, 0xCC, 0x10, 0x03, 0xCF, 0x09, 0x0F, 0xB0, 0x03, 0x78, 0x04, 0xCC, 0x10, 0x13, 0x3F, 0xB0,
    0x03, 0x1F, 0x41, 0xB0, 0x03, 0x48, 0x0F, 0x90, 0x03, 0x0D, 0x1F, 0x22, 0x40, 0x07, 0xFF, 0xFF,
    0xF2, 0x1F, 0x01, 0x40, 0x07, 0x0D, 0x1F, 0xB0, 0x90, 0x03, 0x37, 0x2F, 0x20, 0x00, 0x02, 0x00,
    0x0A, 0x0F, 0xCC, 0x10, 0xBE, 0xF4, 0x01, 0x27, 0x00, 0x21, 0x00, 0x27, 0x00, 0x20, 0x00, 0x26,
    0x00, 0x23, 0x00, 0x2A, 0x00, 0x22, 0x00, 0x48, 0x03, 0x0C, 0x18, 0x00, 0x0F, 0x01, 0x00, 0xFF,
    0x36, 0x08, 0xCC, 0x10, 0x16, 0x07, 0x33, 0x14, 0x0F, 0xCC, 0x10, 0xA2, 0x12, 0x0C, 0xF4, 0x0F,
    0x05, 0xCC, 0x10, 0x13, 0x06, 0x9C, 0x10, 0x00, 0xC3, 0x05, 0x13, 0x0F, 0x68, 0x05, 0x13, 0x02,
    0x74, 0x05, 0x17, 0x0D, 0xCC, 0x10, 0x13, 0x0C, 0x78, 0x06, 0x13, 0x0A, 0x50, 0x06, 0xBF, 0x00,
    0x00, 0x06, 0x05, 0x0C, 0x08, 0x0D, 0x00, 0x19, 0x24, 0x6C, 0xCC, 0x10, 0x1E, 0x13, 0xD0, 0xCC,
    0x10, 0xF7, 0x06, 0x03, 0x12, 0x00, 0x00, 0x3D, 0x00, 0x80, 0x00, 0x38, 0x00, 0x80, 0x00, 0x41,
    0x00, 0x80, 0x00, 0x90, 0x00, 0x80, 0x00, 0x05, 0x08, 0x00, 0x70, 0x49, 0x00, 0x34, 0x00, 0x80,
    0x00, 0x80, 0xFA, 0x14, 0x62, 0x00, 0x16, 0x00, 0x08, 0x00, 0x80, 0x06, 0x15, 0x23, 0x00, 0x19,
    0x04, 0x00, 0x91, 0x18, 0x00, 0x80, 0x00, 0x95, 0x00, 0x80, 0x00, 0x1D, 0x26, 0x00, 0x31, 0x00,
    0x00, 0x2C, 0xDC, 0x00, 0x11, 0x80, 0x98, 0x06, 0x17, 0x08, 0xCC, 0x10, 0x17, 0x09, 0xBC, 0x17,
    0x1F, 0x00, 0xCC, 0x10, 0x10, 0x79, 0x56, 0x01, 0x55, 0x05, 0x55, 0x05, 0x02, 0x0C, 0x00, 0x13,
    0x01, 0xDC, 0x07, 0x00, 0x01, 0x00, 0x13, 0x2F, 0x08, 0x00, 0x57, 0x54, 0x00, 0x01, 0x88, 0x2D,
    0xCC, 0x10, 0x2F, 0x48, 0x48, 0xCC, 0x10, 0x1B, 0x1B, 0x35, 0xCC, 0x10, 0x00, 0x50, 0x10, 0x00,
    0x07, 0x00, 0x80, 0x9C, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

constexpr const u8 T210b01SdevEmcDvfsTableS1y4gb01[0x685] = {
    0xFF, 0x18, 0x03, 0x00, 0x00, 0x00, 0x30, 0x31, 0x5F, 0x32, 0x30, 0x34, 0x30, 0x30, 0x30, 0x5F,
    0x4E, 0x6F, 0x43, 0x66, 0x67, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6F, 0x6E, 0x5F, 0x56, 0x30, 0x2E,
    0x34, 0x2E, 0x35, 0x5F, 0x56, 0x32, 0x2E, 0x30, 0x00, 0x01, 0x00, 0x06, 0x71, 0xE0, 0x1C, 0x03,
    0x00, 0x4C, 0x04, 0x00, 0x04, 0x00, 0x8F, 0x70, 0x6C, 0x6C, 0x70, 0x5F, 0x6F, 0x75, 0x74, 0x2F,
    0x00, 0x05, 0x5F, 0x02, 0x80, 0x18, 0x40, 0x00, 0x01, 0x00, 0x40, 0xFF, 0x1E, 0x3F, 0x3A, 0x00,
    0x00, 0x0D, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
    0x00, 0x8A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
    0x00, 0x04, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x05, 0x50, 0x00, 0x10, 0x17, 0x0A, 0x04,
    0x00, 0x22, 0x01, 0x00, 0x5C, 0x00, 0x57, 0x3A, 0x00, 0x00, 0x00, 0x1D, 0x24, 0x00, 0x13, 0x09,
    0x54, 0x00, 0x13, 0x0B, 0x20, 0x00, 0x13, 0x08, 0x0C, 0x00, 0x13, 0x00, 0x18, 0x00, 0x53, 0x17,
    0x00, 0x00, 0x00, 0x15, 0x08, 0x00, 0x13, 0x1B, 0x18, 0x00, 0x57, 0x20, 0x00, 0x00, 0x00, 0x06,
    0x04, 0x00, 0x13, 0x03, 0x18, 0x00, 0x13, 0x06, 0x34, 0x00, 0x17, 0x02, 0x40, 0x00, 0x00, 0x50,
    0x00, 0x13, 0x0E, 0xB0, 0x00, 0x18, 0x06, 0x44, 0x01, 0x74, 0x00, 0x00, 0x00, 0x31, 0x31, 0x03,
    0x88, 0xF0, 0x00, 0x40, 0x00, 0x00, 0x00, 0x80, 0x0A, 0x00, 0x13, 0x12, 0xE8, 0x00, 0x54, 0x1A,
    0x00, 0x00, 0x00, 0x16, 0xF4, 0x00, 0x03, 0x61, 0x00, 0x13, 0xC1, 0x50, 0x00, 0x13, 0x08, 0x74,
    0x00, 0x13, 0x0A, 0x08, 0x00, 0x04, 0x10, 0x01, 0x13, 0x02, 0xC4, 0x00, 0x13, 0x3B, 0x04, 0x00,
    0x13, 0x05, 0x04, 0x00, 0x04, 0x88, 0x00, 0x04, 0x0C, 0x00, 0x12, 0x09, 0x7C, 0x00, 0x23, 0xC8,
    0x1C, 0x58, 0x00, 0x40, 0x0D, 0xA0, 0x60, 0x91, 0x7C, 0x01, 0x31, 0xA0, 0x00, 0x2C, 0x86, 0x00,
    0x11, 0x78, 0x16, 0x00, 0x2F, 0xFF, 0x0F, 0x56, 0x01, 0x03, 0xFF, 0x12, 0x0B, 0x88, 0x10, 0x00,
    0x14, 0x00, 0x0B, 0x00, 0x13, 0x00, 0x47, 0x00, 0x45, 0x00, 0x4F, 0x00, 0x4D, 0x00, 0x46, 0x00,
    0x46, 0x00, 0x48, 0x00, 0x48, 0x00, 0x08, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0B, 0x18, 0x00, 0x06,
    0x20, 0x10, 0x00, 0x3A, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x3E, 0x00, 0x4F, 0x13, 0x00, 0x10, 0x00,
    0x01, 0x00, 0x8F, 0x80, 0x1F, 0x22, 0x20, 0x80, 0x0F, 0xF4, 0x20, 0x02, 0x98, 0x01, 0xF0, 0x0E,
    0x00, 0x40, 0x06, 0x00, 0xCC, 0x00, 0x09, 0x00, 0x10, 0x00, 0xCC, 0x00, 0x0A, 0x00, 0x33, 0x00,
    0x02, 0x03, 0xE0, 0xC1, 0x20, 0x41, 0x13, 0x1F, 0x14, 0x00, 0x01, 0x00, 0x99, 0x5C, 0x01, 0x60,
    0x08, 0x00, 0x00, 0x50, 0x50, 0x50, 0x22, 0x02, 0x10, 0xF3, 0x40, 0x01, 0x57, 0x13, 0x07, 0x00,
    0x80, 0x0A, 0x4C, 0x00, 0x13, 0x12, 0x04, 0x00, 0x11, 0x00, 0xB8, 0x01, 0x11, 0x05, 0x9F, 0x01,
    0x23, 0x10, 0x02, 0x51, 0x02, 0x00, 0xE4, 0x02, 0x13, 0x04, 0x92, 0x02, 0x1F, 0x34, 0x1A, 0x01,
    0x07, 0x03, 0x79, 0x03, 0x08, 0x21, 0x00, 0xAF, 0x10, 0x08, 0x01, 0x03, 0x00, 0x50, 0x00, 0x40,
    0x01, 0x20, 0xC9, 0x00, 0x09, 0x34, 0xEF, 0x00, 0xEF, 0x0B, 0x00, 0x48, 0x1C, 0x1C, 0x1C, 0x1C,
    0x1B, 0x00, 0x22, 0x10, 0x10, 0x04, 0x00, 0x44, 0x33, 0x60, 0x18, 0x01, 0x14, 0x00, 0x13, 0x18,
    0x60, 0x02, 0x00, 0x88, 0x02, 0x42, 0x14, 0x14, 0x16, 0x88, 0xB8, 0x00, 0xF0, 0x07, 0x01, 0x00,
    0x80, 0x90, 0x00, 0x00, 0x04, 0x04, 0x07, 0x07, 0x65, 0x00, 0x04, 0x00, 0x1F, 0x80, 0x13, 0x05,
    0x00, 0x11, 0x10, 0x1F, 0x80, 0x02, 0xF0, 0x0F, 0x40, 0x72, 0x10, 0x00, 0x00, 0x40, 0x12, 0x01,
    0x6A, 0x5B, 0x12, 0x01, 0x00, 0x10, 0x08, 0x0F, 0x00, 0x58, 0x10, 0x00, 0x00, 0xFC, 0x10, 0x11,
    0x00, 0x13, 0x08, 0x0F, 0x50, 0x7C, 0x0C, 0x00, 0xF3, 0x07, 0x14, 0x11, 0x00, 0x03, 0x00, 0x07,
    0x4C, 0x72, 0x10, 0x00, 0x5A, 0x3C, 0x55, 0x55, 0x14, 0x14, 0x16, 0xC8, 0x5D, 0x5D, 0x0C, 0x88,
    0x04, 0x00, 0x12, 0xC8, 0x04, 0x00, 0x23, 0x0E, 0x8C, 0x04, 0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F,
    0xB0, 0x03, 0xFF, 0x09, 0x1F, 0x99, 0xB0, 0x03, 0xFF, 0x5E, 0x72, 0x00, 0x80, 0x06, 0x06, 0x00,
    0x00, 0x05, 0x13, 0x02, 0x0F, 0xB0, 0x03, 0x78, 0x00, 0x8C, 0x02, 0x10, 0x1F, 0x24, 0x00, 0x03,
    0x34, 0x02, 0x13, 0x1E, 0xB0, 0x03, 0x1F, 0x10, 0xB0, 0x03, 0x40, 0x0F, 0x90, 0x03, 0x09, 0x13,
    0x0E, 0x04, 0x00, 0x0F, 0x90, 0x03, 0x21, 0x13, 0x13, 0x04, 0x00, 0x0F, 0x90, 0x03, 0x14, 0x22,
    0x30, 0x02, 0x04, 0x00, 0x0F, 0x90, 0x03, 0x00, 0x1F, 0x04, 0x40, 0x07, 0xFF, 0xFF, 0x70, 0x1F,
    0x01, 0x40, 0x07, 0x0A, 0x4F, 0x04, 0x00, 0x80, 0xB0, 0x90, 0x03, 0x37, 0x2F, 0x28, 0x00, 0x02,
    0x00, 0x0B, 0x0F, 0x01, 0x00, 0xAD, 0x1B, 0x29, 0x01, 0x00, 0x0C, 0x20, 0x00, 0x04, 0x48, 0x03,
    0x0F, 0x01, 0x00, 0xFF, 0x16, 0x39, 0x49, 0x92, 0x24, 0x04, 0x00, 0x0F, 0x01, 0x00, 0x0D, 0x00,
    0xB4, 0x02, 0x40, 0x04, 0x01, 0x00, 0x00, 0x16, 0x0A, 0x1B, 0x18, 0x10, 0x09, 0x05, 0x50, 0x03,
    0x5A, 0x42, 0x0F, 0x00, 0x60, 0x09, 0x14, 0x00, 0x1E, 0x01, 0x0C, 0x00, 0x0F, 0xFC, 0x00, 0x6E,
    0xF5, 0x02, 0x01, 0x00, 0x00, 0x08, 0x4C, 0x00, 0x00, 0x80, 0x20, 0x10, 0x0A, 0x00, 0x28, 0x10,
    0x00, 0x80, 0x01, 0x48, 0x04, 0x02, 0xA4, 0x00, 0x04, 0x04, 0x00, 0x13, 0x02, 0xE8, 0x05, 0x04,
    0x10, 0x00, 0x08, 0xFC, 0x05, 0x12, 0x07, 0x0A, 0x0A, 0xD3, 0x02, 0x01, 0x02, 0x03, 0x00, 0x04,
    0x05, 0xA3, 0x72, 0x0F, 0x0F, 0x00, 0x70, 0xE6, 0x04, 0x4F, 0x00, 0x1A, 0x00, 0x80, 0x04, 0x00,
    0x0E, 0x11, 0x1B, 0x10, 0x04, 0xF1, 0x02, 0x80, 0x00, 0x4C, 0x02, 0x00, 0x00, 0xB2, 0x00, 0xFF,
    0x00, 0xDA, 0x00, 0xFF, 0x00, 0x9D, 0x00, 0xFF, 0x02, 0x00, 0x17, 0x0C, 0x08, 0x00, 0xF1, 0x02,
    0x49, 0x00, 0x7F, 0x00, 0x80, 0x00, 0xFF, 0x00, 0x04, 0x00, 0xFF, 0x00, 0xAD, 0x00, 0x08, 0x00,
    0xFF, 0x88, 0x00, 0x33, 0xFF, 0x00, 0xC6, 0x04, 0x00, 0x13, 0x6D, 0x2C, 0x00, 0x11, 0xE2, 0x06,
    0x00, 0x01, 0x73, 0x06, 0x01, 0x0A, 0x00, 0x13, 0x14, 0xC0, 0x06, 0x2E, 0xF4, 0x01, 0x78, 0x01,
    0x13, 0x08, 0x44, 0x0F, 0x0F, 0x23, 0x01, 0x08, 0x1F, 0xC0, 0x0C, 0x00, 0x04, 0x07, 0x70, 0x03,
    0x04, 0x98, 0x07, 0xA0, 0x01, 0x88, 0x00, 0x00, 0x02, 0x88, 0x00, 0x00, 0x0D, 0x88, 0x2C, 0x00,
    0x00, 0xB4, 0x0B, 0x08, 0x28, 0x00, 0xA0, 0xD8, 0x51, 0x1A, 0xA0, 0x00, 0x00, 0x50, 0x05, 0x00,
    0x00, 0x1F, 0x00, 0x31, 0x88, 0x00, 0x20, 0xFD, 0x04, 0x15, 0x88, 0x04, 0x00, 0x50, 0x25, 0x08,
    0x11, 0x00, 0x0C, 0x46, 0x00, 0x07, 0x50, 0x10, 0x00, 0x0C, 0x00, 0x26, 0x5C, 0x0D, 0x94, 0x01,
    0x7F, 0x30, 0x31, 0x5F, 0x31, 0x36, 0x30, 0x30, 0xCD, 0x10, 0x23, 0x28, 0x6A, 0x18, 0xCC, 0x10,
    0x4F, 0x6D, 0x5F, 0x75, 0x64, 0x2C, 0x00, 0x07, 0x21, 0x80, 0x18, 0x0C, 0x02, 0x2F, 0xF0, 0x02,
    0xB4, 0x02, 0x3B, 0x22, 0xFF, 0x3B, 0x6C, 0x06, 0x0F, 0xCC, 0x10, 0x45, 0x10, 0x60, 0x79, 0x01,
    0x47, 0x01, 0x00, 0x00, 0xE0, 0x24, 0x00, 0x13, 0x44, 0x9C, 0x09, 0x13, 0x29, 0x64, 0x00, 0x57,
    0x0C, 0x00, 0x00, 0x00, 0x2D, 0x4C, 0x09, 0x00, 0xBC, 0x09, 0x97, 0x23, 0x00, 0x00, 0x00, 0x3E,
    0x00, 0x00, 0x00, 0x41, 0x8C, 0x09, 0x13, 0x1D, 0x04, 0x00, 0x13, 0x0C, 0x98, 0x00, 0x13, 0x16,
    0xEC, 0x03, 0x13, 0x0E, 0x14, 0x00, 0x17, 0x0A, 0xDC, 0x09, 0x13, 0x0E, 0x44, 0x00, 0x12, 0x09,
    0xD0, 0x09, 0x00, 0x7F, 0x07, 0x10, 0x10, 0x82, 0x05, 0x57, 0xF1, 0xF1, 0x03, 0x88, 0x1D, 0x8C,
    0x09, 0x93, 0x0B, 0x00, 0x06, 0x00, 0x33, 0x00, 0x00, 0x00, 0x39, 0x4C, 0x09, 0x13, 0x37, 0x0C,
    0x00, 0x23, 0x20, 0x18, 0x90, 0x02, 0x12, 0x06, 0x50, 0x02, 0x13, 0x10, 0xF0, 0x01, 0x13, 0x17,
    0x08, 0x00, 0x13, 0x38, 0x64, 0x00, 0x00, 0x8F, 0x01, 0x62, 0x2E, 0x00, 0x00, 0x00, 0xCC, 0x01,
    0x04, 0x00, 0x13, 0x0D, 0x9C, 0x00, 0x00, 0x90, 0x00, 0x00, 0xFA, 0x01, 0x17, 0x22, 0x40, 0x01,
    0x66, 0xF1, 0xF1, 0x03, 0xC8, 0x60, 0x18, 0x8C, 0x09, 0x00, 0x7C, 0x01, 0x4F, 0xBB, 0x01, 0x00,
    0xC0, 0x8C, 0x09, 0x0D, 0xB3, 0x06, 0x06, 0x0B, 0x88, 0x0A, 0x00, 0x0C, 0x00, 0x06, 0x00, 0x0B,
    0xDE, 0x03, 0x13, 0x07, 0x8E, 0x01, 0x51, 0x09, 0x00, 0x05, 0x00, 0x07, 0x02, 0x00, 0x0F, 0x18,
    0x00, 0x05, 0x31, 0x0A, 0x00, 0x0A, 0x96, 0x09, 0x11, 0x06, 0x3E, 0x00, 0x3F, 0x0B, 0x00, 0x0A,
    0x8C, 0x09, 0xA0, 0xD0, 0x40, 0x06, 0x31, 0x00, 0x2F, 0x00, 0x40, 0x06, 0x17, 0x00, 0x90, 0x01,
    0x09, 0x8C, 0x09, 0x12, 0x61, 0x8C, 0x09, 0x5B, 0xB0, 0x04, 0x00, 0x00, 0x0D, 0x8C, 0x09, 0x5F,
    0x8C, 0x30, 0x00, 0x80, 0x2B, 0x1C, 0x0D, 0x05, 0x21, 0x00, 0x06, 0xCB, 0x0B, 0x13, 0x11, 0x8C,
    0x09, 0x81, 0x84, 0x10, 0x02, 0x40, 0x85, 0x14, 0x02, 0x40, 0x26, 0x02, 0x1F, 0x20, 0x8C, 0x09,
    0x40, 0x1F, 0x00, 0x8C, 0x09, 0x0F, 0x26, 0x90, 0x61, 0xCC, 0x10, 0x00, 0x78, 0x02, 0x13, 0x2B,
    0x88, 0x02, 0x00, 0x8C, 0x09, 0x11, 0x33, 0xA4, 0x0C, 0x15, 0x06, 0x1C, 0x0D, 0x2F, 0x20, 0x03,
    0x8C, 0x09, 0x14, 0x53, 0x53, 0x08, 0x0F, 0x10, 0x42, 0x8C, 0x09, 0x5F, 0x43, 0x00, 0x07, 0x06,
    0x23, 0xCC, 0x10, 0x07, 0x43, 0x48, 0x48, 0x0E, 0x8C, 0x04, 0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F,
    0xB0, 0x03, 0xFF, 0x09, 0x1F, 0x99, 0xB0, 0x03, 0xFF, 0x5F, 0x01, 0xCC, 0x10, 0x03, 0xCF, 0x09,
    0x0F, 0xB0, 0x03, 0x78, 0x04, 0xCC, 0x10, 0x13, 0x3F, 0xB0, 0x03, 0x1F, 0x41, 0xB0, 0x03, 0x48,
    0x0F, 0x90, 0x03, 0x0D, 0x1F, 0x22, 0x40, 0x07, 0xFF, 0xFF, 0xF2, 0x1F, 0x01, 0x40, 0x07, 0x0D,
    0x1F, 0xB0, 0x90, 0x03, 0x37, 0x2F, 0x20, 0x00, 0x02, 0x00, 0x0A, 0x0F, 0xCC, 0x10, 0xBE, 0xF4,
    0x01, 0x23, 0x00, 0x29, 0x00, 0x27, 0x00, 0x2D, 0x00, 0x22, 0x00, 0x27, 0x00, 0x23, 0x00, 0x2C,
    0x00, 0x48, 0x03, 0x0C, 0x18, 0x00, 0x0F, 0x01, 0x00, 0xFF, 0x36, 0x08, 0xCC, 0x10, 0x16, 0x07,
    0x33, 0x14, 0x0F, 0xCC, 0x10, 0xA2, 0x12, 0x0C, 0xF4, 0x0F, 0x05, 0xCC, 0x10, 0x13, 0x06, 0x62,
    0x05, 0x00, 0xC3, 0x05, 0x13, 0x0F, 0x80, 0x17, 0x13, 0x02, 0x10, 0x06, 0x17, 0x0D, 0xCC, 0x10,
    0x13, 0x0C, 0x84, 0x06, 0x13, 0x0A, 0x50, 0x06, 0xBF, 0x00, 0x00, 0x06, 0x05, 0x0C, 0x08, 0x0D,
    0x00, 0x19, 0x24, 0x6C, 0xCC, 0x10, 0x1E, 0x13, 0xD0, 0xCC, 0x10, 0xF7, 0x06, 0x03, 0x12, 0x00,
    0x00, 0x3D, 0x00, 0x80, 0x00, 0x38, 0x00, 0x80, 0x00, 0x41, 0x00, 0x80, 0x00, 0x90, 0x00, 0x80,
    0x00, 0x05, 0x08, 0x00, 0x70, 0x49, 0x00, 0x34, 0x00, 0x80, 0x00, 0x80, 0xFA, 0x14, 0x62, 0x00,
    0x16, 0x00, 0x08, 0x00, 0x80, 0x06, 0x15, 0x23, 0x00, 0x19, 0x04, 0x00, 0x91, 0x18, 0x00, 0x80,
    0x00, 0x95, 0x00, 0x80, 0x00, 0x1D, 0x26, 0x00, 0x11, 0x00, 0xF2, 0x02, 0x00, 0x0A, 0x00, 0x13,
    0x14, 0xAC, 0x00, 0x04, 0xCC, 0x10, 0x17, 0x09, 0xBC, 0x17, 0x1F, 0x00, 0xCC, 0x10, 0x10, 0x79,
    0x56, 0x01, 0x55, 0x05, 0x55, 0x05, 0x02, 0x0C, 0x00, 0x13, 0x01, 0xDC, 0x07, 0x00, 0x01, 0x00,
    0x13, 0x2F, 0x08, 0x00, 0x57, 0x54, 0x00, 0x01, 0x88, 0x2D, 0xCC, 0x10, 0x2F, 0x48, 0x48, 0xCC,
    0x10, 0x1B, 0x1B, 0x35, 0xCC, 0x10, 0x00, 0x50, 0x10, 0x00, 0x07, 0x00, 0x80, 0x9C, 0x04, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00,
};

constexpr const u8 T210b01SdevEmcDvfsTableH1y4gb01[0x679] = {
    0xFF, 0x18, 0x03, 0x00, 0x00, 0x00, 0x30, 0x31, 0x5F, 0x32, 0x30, 0x34, 0x30, 0x30, 0x30, 0x5F,
    0x4E, 0x6F, 0x43, 0x66, 0x67, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6F, 0x6E, 0x5F, 0x56, 0x30, 0x2E,
    0x34, 0x2E, 0x35, 0x5F, 0x56, 0x32, 0x2E, 0x30, 0x00, 0x01, 0x00, 0x06, 0x71, 0xE0, 0x1C, 0x03,
    0x00, 0x4C, 0x04, 0x00, 0x04, 0x00, 0x8F, 0x70, 0x6C, 0x6C, 0x70, 0x5F, 0x6F, 0x75, 0x74, 0x2F,
    0x00, 0x05, 0x5F, 0x02, 0x80, 0x18, 0x40, 0x00, 0x01, 0x00, 0x40, 0xFF, 0x1E, 0x3F, 0x3A, 0x00,
    0x00, 0x0D, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
    0x00, 0x8A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
    0x00, 0x04, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x05, 0x50, 0x00, 0x10, 0x17, 0x0A, 0x04,
    0x00, 0x22, 0x01, 0x00, 0x5C, 0x00, 0x57, 0x3A, 0x00, 0x00, 0x00, 0x1D, 0x24, 0x00, 0x13, 0x09,
    0x54, 0x00, 0x13, 0x0B, 0x20, 0x00, 0x13, 0x08, 0x0C, 0x00, 0x13, 0x00, 0x18, 0x00, 0x53, 0x17,
    0x00, 0x00, 0x00, 0x15, 0x08, 0x00, 0x13, 0x1B, 0x18, 0x00, 0x57, 0x20, 0x00, 0x00, 0x00, 0x06,
    0x04, 0x00, 0x13, 0x03, 0x18, 0x00, 0x13, 0x06, 0x34, 0x00, 0x17, 0x02, 0x40, 0x00, 0x00, 0x50,
    0x00, 0x13, 0x0E, 0x1C, 0x00, 0x08, 0xB4, 0x00, 0x00, 0x34, 0x00, 0x53, 0x31, 0x31, 0x03, 0x88,
    0x0C, 0x9C, 0x00, 0x40, 0x00, 0x00, 0x00, 0x80, 0x0A, 0x00, 0x13, 0x12, 0xE8, 0x00, 0x54, 0x1A,
    0x00, 0x00, 0x00, 0x16, 0xF4, 0x00, 0x03, 0x61, 0x00, 0x13, 0xC1, 0x50, 0x00, 0x13, 0x08, 0x40,
    0x00, 0x13, 0x0A, 0x08, 0x00, 0x04, 0x10, 0x01, 0x13, 0x02, 0xC4, 0x00, 0x13, 0x3B, 0x04, 0x00,
    0x13, 0x05, 0x04, 0x00, 0x04, 0x88, 0x00, 0x04, 0x0C, 0x00, 0x12, 0x09, 0x7C, 0x00, 0x23, 0xC8,
    0x1C, 0x58, 0x00, 0x40, 0x0D, 0xA0, 0x60, 0x91, 0x7C, 0x01, 0x31, 0xA0, 0x00, 0x2C, 0x86, 0x00,
    0x11, 0x78, 0x16, 0x00, 0x2F, 0xFF, 0x0F, 0x56, 0x01, 0x03, 0xF1, 0x0C, 0x0B, 0x88, 0x16, 0x00,
    0x0D, 0x00, 0x0B, 0x00, 0x17, 0x00, 0x43, 0x00, 0x45, 0x00, 0x45, 0x00, 0x43, 0x00, 0x46, 0x00,
    0x47, 0x00, 0x41, 0x00, 0x46, 0x00, 0x0C, 0x8E, 0x00, 0x1F, 0x0D, 0x18, 0x00, 0x06, 0x20, 0x16,
    0x00, 0x3A, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x3E, 0x00, 0x11, 0x17, 0xE0, 0x00, 0x0F, 0x01, 0x00,
    0x8D, 0x80, 0x1F, 0x22, 0x20, 0x80, 0x0F, 0xF4, 0x20, 0x02, 0x98, 0x01, 0xF0, 0x0E, 0x00, 0x40,
    0x06, 0x00, 0xCC, 0x00, 0x09, 0x00, 0x10, 0x00, 0xCC, 0x00, 0x0A, 0x00, 0x33, 0x00, 0x02, 0x03,
    0xE0, 0xC1, 0x20, 0x41, 0x13, 0x1F, 0x14, 0x00, 0x01, 0x00, 0x99, 0x5C, 0x01, 0x60, 0x08, 0x00,
    0x00, 0x50, 0x50, 0x50, 0x22, 0x02, 0x10, 0xF3, 0x40, 0x01, 0x57, 0x13, 0x07, 0x00, 0x80, 0x0A,
    0x4C, 0x00, 0x13, 0x12, 0x04, 0x00, 0x02, 0x00, 0x02, 0x11, 0x05, 0x9F, 0x01, 0x23, 0x10, 0x02,
    0x51, 0x02, 0x00, 0xE4, 0x02, 0x13, 0x04, 0x92, 0x02, 0x2F, 0x34, 0x10, 0x90, 0x00, 0x06, 0x03,
    0x79, 0x03, 0x09, 0x21, 0x00, 0x9F, 0x80, 0x00, 0x40, 0x00, 0x04, 0x10, 0x80, 0x00, 0x20, 0xC9,
    0x00, 0x09, 0x34, 0xEF, 0x00, 0xEF, 0x0B, 0x00, 0x48, 0x1C, 0x1C, 0x1C, 0x1C, 0x1B, 0x00, 0x22,
    0x10, 0x10, 0x04, 0x00, 0x44, 0x33, 0x60, 0x18, 0x01, 0x14, 0x00, 0x13, 0x18, 0x60, 0x02, 0x00,
    0x88, 0x02, 0x42, 0x14, 0x14, 0x16, 0x88, 0xB8, 0x00, 0xF0, 0x07, 0x01, 0x00, 0x80, 0x90, 0x00,
    0x00, 0x04, 0x04, 0x07, 0x07, 0x65, 0x00, 0x04, 0x00, 0x1F, 0x80, 0x13, 0x05, 0x00, 0x11, 0x10,
    0x1F, 0x80, 0x02, 0xF0, 0x0F, 0x40, 0x72, 0x10, 0x00, 0x00, 0x40, 0x12, 0x01, 0x6A, 0x5B, 0x12,
    0x01, 0x00, 0x10, 0x08, 0x0F, 0x00, 0x58, 0x10, 0x00, 0x00, 0xFC, 0x10, 0x11, 0x00, 0x13, 0x08,
    0x0F, 0x50, 0x7C, 0x0C, 0x00, 0xF3, 0x07, 0x14, 0x11, 0x00, 0x03, 0x00, 0x07, 0x4C, 0x72, 0x10,
    0x00, 0x5A, 0x3C, 0x55, 0x55, 0x14, 0x14, 0x16, 0xC8, 0x5D, 0x5D, 0x0C, 0x88, 0x04, 0x00, 0x12,
    0xC8, 0x04, 0x00, 0x23, 0x0E, 0x8C, 0x04, 0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F, 0xB0, 0x03, 0xFF,
    0x09, 0x1F, 0x99, 0xB0, 0x03, 0xFF, 0x5E, 0x9F, 0x00, 0x80, 0x06, 0x06, 0x00, 0x00, 0x05, 0x06,
    0x00, 0xB0, 0x03, 0x7C, 0x00, 0x8C, 0x02, 0x10, 0x1F, 0x24, 0x00, 0x03, 0x34, 0x02, 0x13, 0x1E,
    0xB0, 0x03, 0x1F, 0x10, 0xB0, 0x03, 0x40, 0x0F, 0x90, 0x03, 0x09, 0x13, 0x0E, 0x04, 0x00, 0x0F,
    0x90, 0x03, 0x21, 0x00, 0x64, 0x01, 0x1F, 0x13, 0x90, 0x03, 0x17, 0x00, 0x33, 0x05, 0x1F, 0x30,
    0x90, 0x03, 0x03, 0x1F, 0x04, 0x40, 0x07, 0xFF, 0xFF, 0x70, 0x1F, 0x01, 0x40, 0x07, 0x0A, 0x4F,
    0x04, 0x00, 0x80, 0xB0, 0x90, 0x03, 0x37, 0x2F, 0x28, 0x00, 0x02, 0x00, 0x0B, 0x0F, 0x01, 0x00,
    0xAD, 0x1B, 0x29, 0x01, 0x00, 0x0C, 0x20, 0x00, 0x04, 0x48, 0x03, 0x0F, 0x01, 0x00, 0xFF, 0x16,
    0x39, 0x49, 0x92, 0x24, 0x04, 0x00, 0x0F, 0x01, 0x00, 0x0D, 0x00, 0xB4, 0x02, 0x40, 0x04, 0x01,
    0x00, 0x00, 0x16, 0x0A, 0x13, 0x18, 0x84, 0x05, 0x0D, 0x50, 0x03, 0x5A, 0x42, 0x0F, 0x00, 0x60,
    0x09, 0x14, 0x00, 0x1E, 0x01, 0x0C, 0x00, 0x0F, 0xFC, 0x00, 0x6E, 0xF7, 0x02, 0x01, 0x00, 0x00,
    0x08, 0x4C, 0x00, 0x00, 0x80, 0x20, 0x10, 0x0A, 0x00, 0x28, 0x10, 0x00, 0x80, 0x01, 0xD8, 0x09,
    0x17, 0x01, 0x04, 0x00, 0x13, 0x02, 0xE8, 0x05, 0x04, 0x10, 0x00, 0x08, 0xFC, 0x05, 0x12, 0x07,
    0xFE, 0x0E, 0xD3, 0x02, 0x01, 0x02, 0x03, 0x00, 0x04, 0x05, 0xA3, 0x72, 0x0F, 0x0F, 0x00, 0x70,
    0xE6, 0x04, 0x4F, 0x00, 0x1A, 0x00, 0x80, 0x04, 0x00, 0x0E, 0x11, 0x1B, 0x10, 0x04, 0xF1, 0x02,
    0x80, 0x00, 0x4C, 0x02, 0x00, 0x00, 0xB2, 0x00, 0xFF, 0x00, 0xDA, 0x00, 0xFF, 0x00, 0x9D, 0x00,
    0xFF, 0x02, 0x00, 0x17, 0x0C, 0x08, 0x00, 0xF1, 0x02, 0x49, 0x00, 0x7F, 0x00, 0x80, 0x00, 0xFF,
    0x00, 0x04, 0x00, 0xFF, 0x00, 0xAD, 0x00, 0x08, 0x00, 0xFF, 0x88, 0x00, 0x33, 0xFF, 0x00, 0xC6,
    0x04, 0x00, 0x13, 0x6D, 0x2C, 0x00, 0x11, 0xE2, 0x06, 0x00, 0x01, 0x73, 0x06, 0x01, 0x0A, 0x00,
    0x13, 0x14, 0xC0, 0x06, 0x2E, 0xF4, 0x01, 0x78, 0x01, 0x13, 0x08, 0x44, 0x0F, 0x0F, 0x23, 0x01,
    0x08, 0x1F, 0xC0, 0x0C, 0x00, 0x04, 0x06, 0xE8, 0x04, 0x05, 0x98, 0x07, 0xA0, 0x01, 0x88, 0x00,
    0x00, 0x02, 0x88, 0x00, 0x00, 0x0D, 0x88, 0x2C, 0x00, 0x00, 0xB4, 0x0B, 0x08, 0x28, 0x00, 0xA0,
    0xD8, 0x51, 0x1A, 0xA0, 0x00, 0x00, 0x50, 0x05, 0x00, 0x00, 0x1F, 0x00, 0x31, 0x88, 0x00, 0x20,
    0xFD, 0x04, 0x15, 0x88, 0x04, 0x00, 0x50, 0x25, 0x08, 0x11, 0x00, 0x0C, 0x46, 0x00, 0x07, 0x50,
    0x10, 0x00, 0x0C, 0x00, 0x26, 0x5C, 0x0D, 0x94, 0x01, 0x7F, 0x30, 0x31, 0x5F, 0x31, 0x36, 0x30,
    0x30, 0xCD, 0x10, 0x23, 0x28, 0x6A, 0x18, 0xCC, 0x10, 0x4F, 0x6D, 0x5F, 0x75, 0x64, 0x2C, 0x00,
    0x07, 0x21, 0x80, 0x18, 0x0C, 0x02, 0x2F, 0xF0, 0x02, 0xB4, 0x02, 0x3B, 0x22, 0xFF, 0x3B, 0x6C,
    0x06, 0x0F, 0xCC, 0x10, 0x45, 0x10, 0x60, 0x79, 0x01, 0x47, 0x01, 0x00, 0x00, 0xE0, 0x24, 0x00,
    0x13, 0x44, 0x9C, 0x09, 0x13, 0x29, 0x64, 0x00, 0x00, 0x1C, 0x09, 0x17, 0x2D, 0x4C, 0x09, 0x00,
    0xBC, 0x09, 0x97, 0x23, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x41, 0x8C, 0x09, 0x13, 0x1D,
    0x04, 0x00, 0x13, 0x0C, 0xA8, 0x09, 0x13, 0x16, 0xEC, 0x03, 0x13, 0x0E, 0x14, 0x00, 0x17, 0x0A,
    0xDC, 0x09, 0x13, 0x0E, 0x44, 0x00, 0x12, 0x08, 0x74, 0x0A, 0x00, 0x7F, 0x07, 0x10, 0x10, 0xC4,
    0x00, 0x57, 0xF1, 0xF1, 0x03, 0x88, 0x1C, 0x8C, 0x09, 0x93, 0x0C, 0x00, 0x06, 0x00, 0x33, 0x00,
    0x00, 0x00, 0x39, 0x4C, 0x09, 0x13, 0x37, 0x0C, 0x00, 0x23, 0x20, 0x18, 0x90, 0x02, 0x12, 0x06,
    0x50, 0x02, 0x13, 0x10, 0xF0, 0x01, 0x13, 0x17, 0x08, 0x00, 0x13, 0x38, 0x64, 0x00, 0x00, 0x8F,
    0x01, 0x62, 0x2E, 0x00, 0x00, 0x00, 0xCC, 0x01, 0x04, 0x00, 0x13, 0x0D, 0x34, 0x01, 0x00, 0x90,
    0x00, 0x00, 0xFA, 0x01, 0x17, 0x22, 0x40, 0x01, 0x66, 0xF1, 0xF1, 0x03, 0xC8, 0x60, 0x18, 0x8C,
    0x09, 0x00, 0x7C, 0x01, 0x4F, 0xBB, 0x01, 0x00, 0xC0, 0x8C, 0x09, 0x0D, 0xB5, 0x06, 0x06, 0x0B,
    0x88, 0x0D, 0x00, 0x08, 0x00, 0x06, 0x00, 0x0E, 0x60, 0x0A, 0x13, 0x03, 0xC0, 0x0A, 0x11, 0x07,
    0x82, 0x00, 0x1F, 0x08, 0x18, 0x00, 0x06, 0x00, 0x88, 0x09, 0x11, 0x08, 0x20, 0x00, 0x00, 0x3E,
    0x00, 0x3F, 0x0E, 0x00, 0x0D, 0x8C, 0x09, 0xA0, 0xD0, 0x40, 0x06, 0x31, 0x00, 0x2F, 0x00, 0x40,
    0x06, 0x17, 0x00, 0x90, 0x01, 0x09, 0x8C, 0x09, 0x12, 0x61, 0x8C, 0x09, 0x5B, 0xB0, 0x04, 0x00,
    0x00, 0x0D, 0x8C, 0x09, 0x5F, 0x8C, 0x30, 0x00, 0x80, 0x2B, 0x1C, 0x0D, 0x05, 0x21, 0x00, 0x06,
    0xCB, 0x0B, 0x13, 0x11, 0x8C, 0x09, 0x81, 0x84, 0x10, 0x02, 0x40, 0x85, 0x14, 0x02, 0x40, 0x8C,
    0x09, 0x1F, 0x20, 0x8C, 0x09, 0x40, 0x1F, 0x00, 0x8C, 0x09, 0x0F, 0x26, 0x90, 0x61, 0xCC, 0x10,
    0x00, 0x78, 0x02, 0x13, 0x2B, 0x88, 0x02, 0x00, 0x8C, 0x09, 0x11, 0x33, 0x48, 0x02, 0x15, 0x06,
    0x1C, 0x0D, 0x2F, 0x20, 0x03, 0x8C, 0x09, 0x14, 0x53, 0x53, 0x08, 0x0F, 0x10, 0x42, 0x8C, 0x09,
    0x5F, 0x43, 0x00, 0x07, 0x06, 0x23, 0xCC, 0x10, 0x07, 0x43, 0x48, 0x48, 0x0E, 0x8C, 0x04, 0x00,
    0x10, 0x4C, 0x04, 0x00, 0x0F, 0xB0, 0x03, 0xFF, 0x09, 0x1F, 0x99, 0xB0, 0x03, 0xFF, 0x5F, 0x12,
    0x80, 0xB0, 0x03, 0x1F, 0x00, 0xB0, 0x03, 0x7C, 0x04, 0xCC, 0x10, 0x13, 0x3F, 0xB0, 0x03, 0x1F,
    0x41, 0xB0, 0x03, 0x48, 0x0F, 0x90, 0x03, 0x0D, 0x1F, 0x22, 0x40, 0x07, 0xFF, 0xFF, 0xF2, 0x1F,
    0x01, 0x40, 0x07, 0x0D, 0x1F, 0xB0, 0x90, 0x03, 0x37, 0x2F, 0x20, 0x00, 0x02, 0x00, 0x0A, 0x0F,
    0xCC, 0x10, 0xBE, 0xF4, 0x01, 0x27, 0x00, 0x21, 0x00, 0x27, 0x00, 0x20, 0x00, 0x26, 0x00, 0x23,
    0x00, 0x2A, 0x00, 0x22, 0x00, 0x48, 0x03, 0x0C, 0x18, 0x00, 0x0F, 0x01, 0x00, 0xFF, 0x36, 0x08,
    0xCC, 0x10, 0x16, 0x07, 0x33, 0x14, 0x0F, 0xCC, 0x10, 0xA2, 0x12, 0x0C, 0xF4, 0x0F, 0x05, 0xCC,
    0x10, 0x13, 0x06, 0x9C, 0x10, 0x00, 0xC3, 0x05, 0x13, 0x0F, 0x68, 0x05, 0x13, 0x02, 0x74, 0x05,
    0x17, 0x0D, 0xCC, 0x10, 0x13, 0x0C, 0x78, 0x06, 0x13, 0x0A, 0x50, 0x06, 0xBF, 0x00, 0x00, 0x06,
    0x05, 0x0C, 0x08, 0x0D, 0x00, 0x19, 0x24, 0x6C, 0xCC, 0x10, 0x1E, 0x13, 0xD0, 0xCC, 0x10, 0xF7,
    0x06, 0x03, 0x12, 0x00, 0x00, 0x3D, 0x00, 0x80, 0x00, 0x38, 0x00, 0x80, 0x00, 0x41, 0x00, 0x80,
    0x00, 0x90, 0x00, 0x80, 0x00, 0x05, 0x08, 0x00, 0x70, 0x49, 0x00, 0x34, 0x00, 0x80, 0x00, 0x80,
    0xFA, 0x14, 0x62, 0x00, 0x16, 0x00, 0x08, 0x00, 0x80, 0x06, 0x15, 0x23, 0x00, 0x19, 0x04, 0x00,
    0x91, 0x18, 0x00, 0x80, 0x00, 0x95, 0x00, 0x80, 0x00, 0x1D, 0x26, 0x00, 0x31, 0x00, 0x00, 0x2C,
    0xDC, 0x00, 0x11, 0x80, 0x98, 0x06, 0x17, 0x08, 0xCC, 0x10, 0x17, 0x09, 0xBC, 0x17, 0x1F, 0x00,
    0xCC, 0x10, 0x10, 0x79, 0x56, 0x01, 0x55, 0x05, 0x55, 0x05, 0x02, 0x0C, 0x00, 0x13, 0x01, 0xDC,
    0x07, 0x00, 0x01, 0x00, 0x13, 0x2F, 0x08, 0x00, 0x57, 0x54, 0x00, 0x01, 0x88, 0x2D, 0xCC, 0x10,
    0x2F, 0x48, 0x48, 0xCC, 0x10, 0x1B, 0x1B, 0x35, 0xCC, 0x10, 0x00, 0x50, 0x10, 0x00, 0x07, 0x00,
    0x80, 0x9C, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

constexpr const u8 T210b01SdevEmcDvfsTableS4gb03[0x67B] = {
    0xFF, 0x18, 0x03, 0x00, 0x00, 0x00, 0x30, 0x31, 0x5F, 0x32, 0x30, 0x34, 0x30, 0x30, 0x30, 0x5F,
    0x4E, 0x6F, 0x43, 0x66, 0x67, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6F, 0x6E, 0x5F, 0x56, 0x30, 0x2E,
    0x33, 0x2E, 0x31, 0x5F, 0x56, 0x32, 0x2E, 0x30, 0x00, 0x01, 0x00, 0x06, 0x71, 0xE0, 0x1C, 0x03,
    0x00, 0x4C, 0x04, 0x00, 0x04, 0x00, 0x8F, 0x70, 0x6C, 0x6C, 0x70, 0x5F, 0x6F, 0x75, 0x74, 0x2F,
    0x00, 0x05, 0x5F, 0x02, 0x80, 0x18, 0x40, 0x00, 0x01, 0x00, 0x40, 0xFF, 0x1E, 0x3F, 0x3A, 0x00,
    0x00, 0x0D, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
    0x00, 0x8A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
    0x00, 0x04, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x05, 0x50, 0x00, 0x10, 0x17, 0x0A, 0x04,
    0x00, 0x22, 0x01, 0x00, 0x5C, 0x00, 0x57, 0x3A, 0x00, 0x00, 0x00, 0x1D, 0x24, 0x00, 0x13, 0x09,
    0x54, 0x00, 0x13, 0x0B, 0x20, 0x00, 0x13, 0x08, 0x0C, 0x00, 0x13, 0x00, 0x18, 0x00, 0x53, 0x17,
    0x00, 0x00, 0x00, 0x15, 0x08, 0x00, 0x13, 0x1B, 0x18, 0x00, 0x57, 0x20, 0x00, 0x00, 0x00, 0x06,
    0x04, 0x00, 0x13, 0x03, 0x18, 0x00, 0x13, 0x06, 0x34, 0x00, 0x17, 0x02, 0x40, 0x00, 0x00, 0x50,
    0x00, 0x13, 0x0E, 0xB0, 0x00, 0x18, 0x06, 0x44, 0x01, 0x74, 0x00, 0x00, 0x00, 0x31, 0x31, 0x03,
    0x88, 0xF0, 0x00, 0x40, 0x00, 0x00, 0x00, 0x80, 0x0A, 0x00, 0x13, 0x12, 0xE8, 0x00, 0x54, 0x1A,
    0x00, 0x00, 0x00, 0x16, 0xF4, 0x00, 0x03, 0x61, 0x00, 0x13, 0xC1, 0x50, 0x00, 0x13, 0x08, 0x74,
    0x00, 0x13, 0x0A, 0x08, 0x00, 0x04, 0x10, 0x01, 0x13, 0x02, 0xC4, 0x00, 0x13, 0x3B, 0x04, 0x00,
    0x13, 0x05, 0x04, 0x00, 0x13, 0x04, 0xE8, 0x00, 0x08, 0x0C, 0x00, 0x53, 0x31, 0x31, 0x03, 0xC8,
    0x1C, 0x58, 0x00, 0x40, 0x0D, 0xA0, 0x60, 0x91, 0x7C, 0x01, 0x31, 0xA0, 0x00, 0x2C, 0x86, 0x00,
    0x11, 0x78, 0x16, 0x00, 0x2F, 0xFF, 0x0F, 0x56, 0x01, 0x03, 0xF1, 0x0C, 0x0B, 0x88, 0x16, 0x00,
    0x0D, 0x00, 0x0B, 0x00, 0x17, 0x00, 0x43, 0x00, 0x45, 0x00, 0x45, 0x00, 0x43, 0x00, 0x46, 0x00,
    0x47, 0x00, 0x41, 0x00, 0x46, 0x00, 0x0C, 0x8E, 0x00, 0x1F, 0x0D, 0x18, 0x00, 0x06, 0x20, 0x16,
    0x00, 0x3A, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x3E, 0x00, 0x11, 0x17, 0xE0, 0x00, 0x0F, 0x01, 0x00,
    0x8D, 0x80, 0x1F, 0x22, 0x20, 0x80, 0x0F, 0xF4, 0x20, 0x02, 0x98, 0x01, 0xF0, 0x0E, 0x00, 0x40,
    0x06, 0x00, 0xCC, 0x00, 0x09, 0x00, 0x10, 0x00, 0xCC, 0x00, 0x0A, 0x00, 0x33, 0x00, 0x02, 0x03,
    0xE0, 0xC1, 0x20, 0x41, 0x13, 0x1F, 0x14, 0x00, 0x01, 0x00, 0x99, 0x5C, 0x01, 0x60, 0x08, 0x00,
    0x00, 0x50, 0x50, 0x50, 0x22, 0x02, 0x10, 0xF3, 0x40, 0x01, 0x22, 0x13, 0x07, 0xA4, 0x01, 0x04,
    0x4C, 0x00, 0x13, 0x12, 0x04, 0x00, 0x11, 0x00, 0xB8, 0x01, 0x11, 0x05, 0x9F, 0x01, 0x23, 0x10,
    0x02, 0x51, 0x02, 0x00, 0xE4, 0x02, 0x13, 0x04, 0x92, 0x02, 0x2F, 0x34, 0x10, 0x90, 0x00, 0x06,
    0x03, 0x79, 0x03, 0x09, 0x21, 0x00, 0x9F, 0x80, 0x00, 0x40, 0x00, 0x04, 0x10, 0x80, 0x00, 0x20,
    0xC9, 0x00, 0x09, 0x34, 0xEF, 0x00, 0xEF, 0x0B, 0x00, 0x48, 0x1C, 0x1C, 0x1C, 0x1C, 0x1B, 0x00,
    0x22, 0x10, 0x10, 0x04, 0x00, 0x44, 0x33, 0x60, 0x18, 0x01, 0x14, 0x00, 0x13, 0x18, 0x60, 0x02,
    0x01, 0x88, 0x02, 0x32, 0x16, 0x16, 0x88, 0xB8, 0x00, 0xF0, 0x07, 0x01, 0x00, 0x80, 0x90, 0x00,
    0x00, 0x04, 0x04, 0x07, 0x07, 0x65, 0x00, 0x04, 0x00, 0x1F, 0x80, 0x13, 0x05, 0x00, 0x11, 0x10,
    0x1F, 0x80, 0x02, 0xF0, 0x0F, 0x40, 0x72, 0x10, 0x00, 0x00, 0x40, 0x12, 0x01, 0x6A, 0x5B, 0x12,
    0x01, 0x00, 0x10, 0x08, 0x0F, 0x00, 0x58, 0x10, 0x00, 0x00, 0xFC, 0x10, 0x11, 0x00, 0x13, 0x08,
    0x0F, 0x50, 0x7C, 0x0C, 0x00, 0xF3, 0x07, 0x14, 0x11, 0x00, 0x03, 0x00, 0x07, 0x4C, 0x72, 0x10,
    0x00, 0x5A, 0x3C, 0x55, 0x55, 0x16, 0x16, 0x16, 0xC8, 0x5D, 0x5D, 0x0C, 0x88, 0x04, 0x00, 0x12,
    0xC8, 0x04, 0x00, 0x23, 0x0E, 0x8C, 0x04, 0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F, 0xB0, 0x03, 0xFF,
    0x09, 0x1F, 0x99, 0xB0, 0x03, 0xFF, 0x5E, 0x72, 0x00, 0x80, 0x06, 0x06, 0x00, 0x00, 0x05, 0x13,
    0x02, 0x0F, 0xB0, 0x03, 0x78, 0x00, 0x8C, 0x02, 0x10, 0x1F, 0x24, 0x00, 0x03, 0x68, 0x02, 0x13,
    0x1E, 0xB0, 0x03, 0x1F, 0x10, 0xB0, 0x03, 0x40, 0x0F, 0x90, 0x03, 0x09, 0x13, 0x0E, 0x04, 0x00,
    0x0F, 0x90, 0x03, 0x21, 0x13, 0x13, 0x04, 0x00, 0x0F, 0x90, 0x03, 0x14, 0x22, 0x30, 0x02, 0x04,
    0x00, 0x0F, 0x90, 0x03, 0x00, 0x1F, 0x04, 0x40, 0x07, 0xFF, 0xFF, 0x70, 0x1F, 0x01, 0x40, 0x07,
    0x0A, 0x4F, 0x04, 0x00, 0x80, 0xB0, 0x90, 0x03, 0x37, 0x2F, 0x28, 0x00, 0x02, 0x00, 0x0B, 0x0F,
    0x01, 0x00, 0xAD, 0x1B, 0x29, 0x01, 0x00, 0x0C, 0x20, 0x00, 0x04, 0x48, 0x03, 0x0F, 0x01, 0x00,
    0xFF, 0x16, 0x39, 0x49, 0x92, 0x24, 0x04, 0x00, 0x0F, 0x01, 0x00, 0x0D, 0x00, 0xB4, 0x02, 0x40,
    0x04, 0x01, 0x00, 0x00, 0x16, 0x0A, 0x1B, 0x18, 0x10, 0x09, 0x05, 0x50, 0x03, 0x5A, 0x42, 0x0F,
    0x00, 0x60, 0x09, 0x14, 0x00, 0x1E, 0x01, 0x0C, 0x00, 0x0F, 0xFC, 0x00, 0x6E, 0xF5, 0x02, 0x01,
    0x00, 0x00, 0x08, 0x4C, 0x00, 0x00, 0x80, 0x20, 0x10, 0x0A, 0x00, 0x28, 0x10, 0x00, 0x80, 0x01,
    0x48, 0x04, 0x02, 0xA4, 0x00, 0x17, 0x02, 0x08, 0x00, 0x13, 0x05, 0x0C, 0x00, 0x17, 0x01, 0x84,
    0x06, 0x00, 0x14, 0x00, 0x12, 0x07, 0x0A, 0x0A, 0xD3, 0x02, 0x01, 0x02, 0x03, 0x00, 0x04, 0x05,
    0xA3, 0x72, 0x0F, 0x0F, 0x00, 0x70, 0xE6, 0x04, 0x4F, 0x00, 0x1A, 0x00, 0x80, 0x04, 0x00, 0x0E,
    0x11, 0x1B, 0x10, 0x04, 0xF1, 0x02, 0x80, 0x00, 0x4C, 0x02, 0x00, 0x00, 0xB2, 0x00, 0xFF, 0x00,
    0xDA, 0x00, 0xFF, 0x00, 0x9D, 0x00, 0xFF, 0x02, 0x00, 0x17, 0x0C, 0x08, 0x00, 0xF1, 0x02, 0x49,
    0x00, 0x7F, 0x00, 0x80, 0x00, 0xFF, 0x00, 0x04, 0x00, 0xFF, 0x00, 0xAD, 0x00, 0x08, 0x00, 0xFF,
    0x88, 0x00, 0x33, 0xFF, 0x00, 0xC6, 0x04, 0x00, 0x13, 0x6D, 0x2C, 0x00, 0x11, 0xE2, 0x06, 0x00,
    0x01, 0x73, 0x06, 0x01, 0x0A, 0x00, 0x13, 0x14, 0xC0, 0x06, 0x2E, 0xF4, 0x01, 0x78, 0x01, 0x13,
    0x08, 0x44, 0x0F, 0x0F, 0x23, 0x01, 0x08, 0x1F, 0xC0, 0x0C, 0x00, 0x04, 0x06, 0xE8, 0x04, 0x05,
    0x98, 0x07, 0xA0, 0x01, 0x88, 0x00, 0x00, 0x02, 0x88, 0x00, 0x00, 0x0D, 0x88, 0x2C, 0x00, 0x00,
    0xB4, 0x0B, 0x08, 0x28, 0x00, 0x42, 0xD8, 0x51, 0x1A, 0xA0, 0x0A, 0x00, 0x11, 0x88, 0x04, 0x00,
    0x26, 0x20, 0x12, 0x0C, 0x00, 0x00, 0x04, 0x00, 0x50, 0x25, 0x08, 0x11, 0x00, 0x0C, 0x46, 0x00,
    0x07, 0x50, 0x10, 0x00, 0x0C, 0x00, 0x26, 0x5C, 0x0D, 0x94, 0x01, 0x7F, 0x30, 0x31, 0x5F, 0x31,
    0x36, 0x30, 0x30, 0xCD, 0x10, 0x23, 0x28, 0x6A, 0x18, 0xCC, 0x10, 0x4F, 0x6D, 0x5F, 0x75, 0x64,
    0x2C, 0x00, 0x07, 0x20, 0x80, 0x18, 0x3F, 0x01, 0x3F, 0x00, 0xF0, 0x02, 0xB4, 0x02, 0x3B, 0x22,
    0xFF, 0x3B, 0x6C, 0x06, 0x0F, 0xCC, 0x10, 0x45, 0x10, 0x60, 0x79, 0x01, 0x47, 0x01, 0x00, 0x00,
    0xE0, 0x24, 0x00, 0x13, 0x44, 0x9C, 0x09, 0x13, 0x29, 0x64, 0x00, 0x57, 0x0C, 0x00, 0x00, 0x00,
    0x2D, 0x4C, 0x09, 0x00, 0xBC, 0x09, 0x97, 0x23, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x41,
    0x8C, 0x09, 0x13, 0x1D, 0x04, 0x00, 0x13, 0x10, 0x98, 0x00, 0x13, 0x16, 0xEC, 0x03, 0x13, 0x0E,
    0x44, 0x00, 0x17, 0x0A, 0xDC, 0x09, 0x13, 0x0E, 0x44, 0x00, 0x12, 0x09, 0xD0, 0x09, 0x00, 0x7F,
    0x07, 0x10, 0x10, 0xBC, 0x09, 0x57, 0xF1, 0xF1, 0x03, 0x88, 0x1D, 0x8C, 0x09, 0x93, 0x0B, 0x00,
    0x06, 0x00, 0x33, 0x00, 0x00, 0x00, 0x39, 0x4C, 0x09, 0x13, 0x37, 0x0C, 0x00, 0x23, 0x20, 0x18,
    0x90, 0x02, 0x12, 0x06, 0x70, 0x00, 0x13, 0x10, 0xF0, 0x01, 0x13, 0x17, 0x08, 0x00, 0x13, 0x38,
    0x64, 0x00, 0x00, 0x8F, 0x01, 0x62, 0x2E, 0x00, 0x00, 0x00, 0xCC, 0x01, 0x04, 0x00, 0x13, 0x0D,
    0x9C, 0x00, 0x13, 0x0C, 0xC4, 0x07, 0x17, 0x22, 0x40, 0x01, 0x66, 0xF1, 0xF1, 0x03, 0xC8, 0x60,
    0x18, 0x8C, 0x09, 0x00, 0x7C, 0x01, 0x4F, 0xBB, 0x01, 0x00, 0xC0, 0x8C, 0x09, 0x0D, 0xD3, 0x06,
    0x06, 0x0B, 0x88, 0x0D, 0x00, 0x08, 0x00, 0x06, 0x00, 0x0E, 0x00, 0x06, 0x88, 0x01, 0x13, 0x03,
    0xC0, 0x0A, 0x11, 0x07, 0x82, 0x00, 0x1F, 0x08, 0x18, 0x00, 0x06, 0x00, 0x88, 0x09, 0x11, 0x08,
    0x20, 0x00, 0x00, 0x3E, 0x00, 0x3F, 0x0E, 0x00, 0x0D, 0x8C, 0x09, 0xA0, 0xD0, 0x40, 0x06, 0x31,
    0x00, 0x2F, 0x00, 0x40, 0x06, 0x17, 0x00, 0x90, 0x01, 0x09, 0x8C, 0x09, 0x12, 0x61, 0x8C, 0x09,
    0x5B, 0xB0, 0x04, 0x00, 0x00, 0x0D, 0x8C, 0x09, 0x5F, 0x8C, 0x30, 0x00, 0x00, 0x2B, 0x1C, 0x0D,
    0x05, 0x21, 0x00, 0x06, 0xCB, 0x0B, 0x13, 0x11, 0x8C, 0x09, 0x81, 0x84, 0x10, 0x02, 0x40, 0x85,
    0x14, 0x02, 0x40, 0x26, 0x02, 0x1F, 0x20, 0x8C, 0x09, 0x40, 0x1F, 0x00, 0x8C, 0x09, 0x0F, 0x26,
    0x90, 0x61, 0xCC, 0x10, 0x00, 0x78, 0x02, 0x13, 0x2B, 0x88, 0x02, 0x00, 0x8C, 0x09, 0x11, 0x33,
    0xCC, 0x01, 0x15, 0x06, 0x1C, 0x0D, 0x2F, 0x20, 0x03, 0x8C, 0x09, 0x14, 0x53, 0x53, 0x08, 0x0F,
    0x10, 0x42, 0x8C, 0x09, 0x5F, 0x43, 0x00, 0x07, 0x00, 0x23, 0xCC, 0x10, 0x07, 0x43, 0x48, 0x48,
    0x0E, 0x8C, 0x04, 0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F, 0xB0, 0x03, 0xFF, 0x09, 0x1F, 0x99, 0xB0,
    0x03, 0xFF, 0x5F, 0x01, 0xCC, 0x10, 0x03, 0xCF, 0x09, 0x0F, 0xB0, 0x03, 0x78, 0x04, 0xCC, 0x10,
    0x13, 0x3F, 0xB0, 0x03, 0x1F, 0x41, 0xB0, 0x03, 0x48, 0x0F, 0x90, 0x03, 0x0D, 0x1F, 0x22, 0x40,
    0x07, 0xFF, 0xFF, 0xF2, 0x1F, 0x01, 0x40, 0x07, 0x0D, 0x1F, 0xB0, 0x90, 0x03, 0x37, 0x2F, 0x20,
    0x00, 0x02, 0x00, 0x0A, 0x0F, 0xCC, 0x10, 0xBE, 0xF4, 0x01, 0x27, 0x00, 0x21, 0x00, 0x27, 0x00,
    0x20, 0x00, 0x26, 0x00, 0x23, 0x00, 0x2A, 0x00, 0x22, 0x00, 0x48, 0x03, 0x0C, 0x18, 0x00, 0x0F,
    0x01, 0x00, 0xFF, 0x36, 0x08, 0xCC, 0x10, 0x16, 0x07, 0x33, 0x14, 0x0F, 0xCC, 0x10, 0xA2, 0x12,
    0x0C, 0xF4, 0x0F, 0x05, 0xCC, 0x10, 0x13, 0x06, 0x9C, 0x10, 0x00, 0xC3, 0x05, 0x13, 0x0F, 0x04,
    0x00, 0x13, 0x03, 0x04, 0x00, 0x17, 0x0D, 0xCC, 0x10, 0x13, 0x0C, 0x84, 0x06, 0x13, 0x0A, 0x50,
    0x06, 0xBF, 0x00, 0x00, 0x06, 0x05, 0x0C, 0x08, 0x0D, 0x00, 0x19, 0x24, 0x6C, 0xCC, 0x10, 0x1E,
    0x13, 0xD0, 0xCC, 0x10, 0xF7, 0x06, 0x03, 0x12, 0x00, 0x00, 0x3D, 0x00, 0x80, 0x00, 0x38, 0x00,
    0x80, 0x00, 0x41, 0x00, 0x80, 0x00, 0x90, 0x00, 0x80, 0x00, 0x05, 0x08, 0x00, 0x70, 0x49, 0x00,
    0x34, 0x00, 0x80, 0x00, 0x80, 0xFA, 0x14, 0x62, 0x00, 0x16, 0x00, 0x08, 0x00, 0x80, 0x06, 0x15,
    0x23, 0x00, 0x19, 0x04, 0x00, 0x91, 0x18, 0x00, 0x80, 0x00, 0x95, 0x00, 0x80, 0x00, 0x1D, 0x26,
    0x00, 0x31, 0x00, 0x00, 0x2C, 0xDC, 0x00, 0x11, 0x80, 0x98, 0x06, 0x17, 0x08, 0xCC, 0x10, 0x17,
    0x09, 0xBC, 0x17, 0x1F, 0x00, 0xCC, 0x10, 0x10, 0x79, 0x56, 0x01, 0x55, 0x05, 0x55, 0x05, 0x02,
    0x0C, 0x00, 0x13, 0x01, 0xDC, 0x07, 0x00, 0x01, 0x00, 0x13, 0x2F, 0x08, 0x00, 0x57, 0x54, 0x00,
    0x01, 0x88, 0x2D, 0xCC, 0x10, 0x2F, 0x48, 0x48, 0xCC, 0x10, 0x1B, 0x1B, 0x35, 0xCC, 0x10, 0x04,
    0x50, 0x10, 0x80, 0x9C, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

constexpr const u8 T210b01SdevEmcDvfsTableS8gb03[0x696] = {
    0xFF, 0x18, 0x03, 0x00, 0x00, 0x00, 0x30, 0x31, 0x5F, 0x32, 0x30, 0x34, 0x30, 0x30, 0x30, 0x5F,
    0x4E, 0x6F, 0x43, 0x66, 0x67, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6F, 0x6E, 0x5F, 0x56, 0x30, 0x2E,
    0x34, 0x2E, 0x32, 0x5F, 0x56, 0x32, 0x2E, 0x30, 0x00, 0x01, 0x00, 0x06, 0x71, 0xE0, 0x1C, 0x03,
    0x00, 0x4C, 0x04, 0x00, 0x04, 0x00, 0x8F, 0x70, 0x6C, 0x6C, 0x70, 0x5F, 0x6F, 0x75, 0x74, 0x2F,
    0x00, 0x05, 0x5F, 0x02, 0x80, 0x18, 0x40, 0x00, 0x01, 0x00, 0x40, 0xFF, 0x1E, 0x3F, 0x3A, 0x00,
    0x00, 0x0D, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
    0x00, 0x8A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
    0x00, 0x04, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x05, 0x50, 0x00, 0x10, 0x17, 0x0A, 0x04,
    0x00, 0x22, 0x01, 0x00, 0x5C, 0x00, 0x57, 0x3A, 0x00, 0x00, 0x00, 0x1D, 0x24, 0x00, 0x13, 0x09,
    0x54, 0x00, 0x13, 0x0B, 0x20, 0x00, 0x13, 0x08, 0x0C, 0x00, 0x13, 0x00, 0x18, 0x00, 0x53, 0x17,
    0x00, 0x00, 0x00, 0x15, 0x08, 0x00, 0x13, 0x1B, 0x18, 0x00, 0x57, 0x20, 0x00, 0x00, 0x00, 0x06,
    0x04, 0x00, 0x13, 0x03, 0x18, 0x00, 0x13, 0x06, 0x34, 0x00, 0x17, 0x02, 0x40, 0x00, 0x00, 0x50,
    0x00, 0x13, 0x0E, 0x1C, 0x00, 0x08, 0xB4, 0x00, 0x00, 0x34, 0x00, 0x53, 0x31, 0x31, 0x03, 0x08,
    0x0C, 0x9C, 0x00, 0x40, 0x00, 0x00, 0x00, 0x80, 0x0A, 0x00, 0x13, 0x12, 0xE8, 0x00, 0x54, 0x1A,
    0x00, 0x00, 0x00, 0x16, 0xF4, 0x00, 0x03, 0x61, 0x00, 0x13, 0xC1, 0x50, 0x00, 0x13, 0x08, 0x40,
    0x00, 0x13, 0x0A, 0x08, 0x00, 0x04, 0x10, 0x01, 0x13, 0x02, 0xC4, 0x00, 0x13, 0x3B, 0x04, 0x00,
    0x13, 0x05, 0x04, 0x00, 0x13, 0x04, 0xE8, 0x00, 0x08, 0x0C, 0x00, 0x53, 0x31, 0x31, 0x03, 0x48,
    0x1C, 0x58, 0x00, 0x40, 0x0D, 0xA0, 0x60, 0x91, 0x7C, 0x01, 0x31, 0xA0, 0x00, 0x2C, 0x86, 0x00,
    0x11, 0x78, 0x16, 0x00, 0x2F, 0xFF, 0x0F, 0x56, 0x01, 0x03, 0xF1, 0x0C, 0x0B, 0x08, 0x16, 0x00,
    0x0D, 0x00, 0x0B, 0x00, 0x17, 0x00, 0x43, 0x00, 0x45, 0x00, 0x45, 0x00, 0x43, 0x00, 0x46, 0x00,
    0x47, 0x00, 0x41, 0x00, 0x46, 0x00, 0x0C, 0x8E, 0x00, 0x1F, 0x0D, 0x18, 0x00, 0x06, 0x20, 0x16,
    0x00, 0x3A, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x3E, 0x00, 0x11, 0x17, 0xE0, 0x00, 0x0F, 0x01, 0x00,
    0x8D, 0x80, 0x1F, 0x22, 0x20, 0x80, 0x0F, 0xF4, 0x20, 0x02, 0x98, 0x01, 0xF0, 0x0E, 0x00, 0x40,
    0x06, 0x00, 0xCC, 0x00, 0x09, 0x00, 0x10, 0x00, 0xCC, 0x00, 0x0A, 0x00, 0x33, 0x00, 0x02, 0x03,
    0xE0, 0xC1, 0x20, 0x41, 0x13, 0x1F, 0x14, 0x00, 0x01, 0x00, 0x99, 0x5C, 0x01, 0x60, 0x08, 0x00,
    0x00, 0x50, 0x50, 0x50, 0x22, 0x02, 0x10, 0xF3, 0x40, 0x01, 0x22, 0x13, 0x07, 0xA4, 0x01, 0x04,
    0x4C, 0x00, 0x13, 0x12, 0x04, 0x00, 0x02, 0x00, 0x02, 0x11, 0x05, 0x9F, 0x01, 0x23, 0x10, 0x02,
    0x51, 0x02, 0x00, 0xE4, 0x02, 0x13, 0x04, 0x92, 0x02, 0x2F, 0x34, 0x10, 0x90, 0x00, 0x06, 0x03,
    0x79, 0x03, 0x0E, 0x21, 0x00, 0x15, 0x10, 0x47, 0x00, 0x0F, 0xC9, 0x00, 0x03, 0x34, 0xEF, 0x00,
    0xEF, 0x0B, 0x00, 0x49, 0x1C, 0x1C, 0x1C, 0x1C, 0x3B, 0x00, 0x12, 0x10, 0x04, 0x00, 0x44, 0x33,
    0x60, 0x18, 0x01, 0x14, 0x00, 0x13, 0x18, 0x60, 0x02, 0x00, 0x88, 0x02, 0x42, 0x14, 0x14, 0x16,
    0x08, 0xB8, 0x00, 0xF0, 0x07, 0x01, 0x00, 0x80, 0x90, 0x00, 0x00, 0x04, 0x04, 0x07, 0x07, 0x65,
    0x00, 0x04, 0x00, 0x1F, 0x80, 0x13, 0x05, 0x00, 0x11, 0x10, 0x1F, 0x80, 0x02, 0xF0, 0x0F, 0x40,
    0x72, 0x10, 0x00, 0x00, 0x40, 0x12, 0x01, 0x6A, 0x5B, 0x12, 0x01, 0x00, 0x10, 0x08, 0x0F, 0x00,
    0x58, 0x10, 0x00, 0x00, 0xFC, 0x10, 0x11, 0x00, 0x13, 0x08, 0x0F, 0x50, 0x7C, 0x0C, 0x00, 0xF3,
    0x07, 0x14, 0x11, 0x00, 0x03, 0x00, 0x07, 0x4C, 0x72, 0x10, 0x00, 0x5A, 0x3C, 0x55, 0x55, 0x14,
    0x14, 0x16, 0x48, 0x5D, 0x5D, 0x0C, 0x88, 0x04, 0x00, 0x12, 0x48, 0x04, 0x00, 0x23, 0x0E, 0x8C,
    0x04, 0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F, 0xB0, 0x03, 0xFF, 0x09, 0x1F, 0x99, 0xB0, 0x03, 0xFF,
    0x5E, 0x70, 0x00, 0x80, 0x06, 0x06, 0x00, 0x00, 0x05, 0x17, 0x02, 0x0F, 0xB0, 0x03, 0x7A, 0x00,
    0x8C, 0x02, 0x10, 0x1F, 0x24, 0x00, 0x03, 0x68, 0x02, 0x13, 0x1E, 0xB0, 0x03, 0x15, 0x10, 0xB0,
    0x03, 0x1F, 0x01, 0xB0, 0x03, 0x36, 0x0F, 0x90, 0x03, 0x09, 0x13, 0x0E, 0x04, 0x00, 0x0F, 0x90,
    0x03, 0x21, 0x00, 0x64, 0x01, 0x1F, 0x13, 0x90, 0x03, 0x17, 0x00, 0x33, 0x05, 0x1F, 0x30, 0x90,
    0x03, 0x03, 0x1F, 0x04, 0x40, 0x07, 0xFF, 0xFF, 0x70, 0x1F, 0x01, 0x40, 0x07, 0x0A, 0x4F, 0x04,
    0x00, 0x80, 0xB0, 0x40, 0x07, 0x37, 0x2F, 0x10, 0x00, 0x02, 0x00, 0x0B, 0x0F, 0x01, 0x00, 0xAD,
    0x13, 0x29, 0x01, 0x00, 0x13, 0x35, 0x01, 0x00, 0x0C, 0x20, 0x00, 0x04, 0x48, 0x03, 0x0F, 0x01,
    0x00, 0xFF, 0x16, 0x39, 0x49, 0x92, 0x24, 0x04, 0x00, 0x0F, 0x01, 0x00, 0x0D, 0x00, 0xB4, 0x02,
    0x40, 0x04, 0x01, 0x00, 0x00, 0x16, 0x0A, 0x13, 0x18, 0x84, 0x05, 0x0D, 0x50, 0x03, 0x5A, 0x42,
    0x0F, 0x00, 0x60, 0x09, 0x14, 0x00, 0x1E, 0x01, 0x0C, 0x00, 0x0F, 0xFC, 0x00, 0x6E, 0xF7, 0x02,
    0x01, 0x00, 0x00, 0x08, 0x4C, 0x00, 0x00, 0x80, 0x20, 0x10, 0x0A, 0x00, 0x28, 0x10, 0x00, 0x80,
    0x01, 0xD8, 0x09, 0x13, 0x01, 0xFC, 0x05, 0x04, 0x08, 0x00, 0x17, 0x05, 0x10, 0x00, 0x04, 0x84,
    0x06, 0x00, 0x14, 0x00, 0x11, 0x07, 0x14, 0x00, 0xE3, 0x02, 0x02, 0x01, 0x02, 0x03, 0x00, 0x04,
    0x05, 0xA3, 0x72, 0x0F, 0x0F, 0x00, 0x70, 0xE6, 0x04, 0x4F, 0x00, 0x1A, 0x00, 0x80, 0x04, 0x00,
    0x0E, 0x11, 0x1B, 0x10, 0x04, 0xF1, 0x02, 0x80, 0x00, 0x4C, 0x02, 0x00, 0x00, 0xB2, 0x00, 0xFF,
    0x00, 0xDA, 0x00, 0xFF, 0x00, 0x9D, 0x00, 0xFF, 0x02, 0x00, 0x17, 0x0C, 0x08, 0x00, 0xF1, 0x02,
    0x49, 0x00, 0x7F, 0x00, 0x80, 0x00, 0xFF, 0x00, 0x04, 0x00, 0xFF, 0x00, 0xAD, 0x00, 0x08, 0x00,
    0xFF, 0x88, 0x00, 0x33, 0xFF, 0x00, 0xC6, 0x04, 0x00, 0x13, 0x6D, 0x2C, 0x00, 0x11, 0xE2, 0x06,
    0x00, 0x01, 0x73, 0x06, 0x01, 0x0A, 0x00, 0x13, 0x14, 0xC0, 0x06, 0x2E, 0xF4, 0x01, 0x78, 0x01,
    0x13, 0x08, 0x44, 0x0F, 0x0F, 0x23, 0x01, 0x08, 0x1F, 0xC0, 0x0C, 0x00, 0x04, 0x08, 0x23, 0x05,
    0x03, 0xC6, 0x04, 0x90, 0x01, 0x08, 0x00, 0x00, 0x02, 0x08, 0x00, 0x00, 0x0D, 0x57, 0x00, 0x58,
    0xC0, 0x5D, 0x5D, 0x0E, 0x0C, 0x28, 0x00, 0xC0, 0xD8, 0x51, 0x1A, 0xA0, 0x00, 0x00, 0x50, 0x05,
    0x00, 0x00, 0x88, 0x00, 0x04, 0x00, 0x11, 0x20, 0xFD, 0x04, 0x15, 0x88, 0x04, 0x00, 0x50, 0x25,
    0x08, 0x11, 0x00, 0x0C, 0x46, 0x00, 0x07, 0x50, 0x10, 0x00, 0x0C, 0x00, 0x26, 0x5C, 0x0D, 0x94,
    0x01, 0x7F, 0x30, 0x31, 0x5F, 0x31, 0x36, 0x30, 0x30, 0xCD, 0x10, 0x23, 0x28, 0x6A, 0x18, 0xCC,
    0x10, 0x4F, 0x6D, 0x5F, 0x75, 0x64, 0x2C, 0x00, 0x07, 0x21, 0x80, 0x18, 0x0C, 0x02, 0x2F, 0xF0,
    0x02, 0xB4, 0x02, 0x3B, 0x22, 0xFF, 0x3B, 0x6C, 0x06, 0x0F, 0xCC, 0x10, 0x45, 0x10, 0x60, 0x79,
    0x01, 0x47, 0x01, 0x00, 0x00, 0xE0, 0x24, 0x00, 0x13, 0x44, 0x9C, 0x09, 0x13, 0x29, 0x64, 0x00,
    0x00, 0x95, 0x01, 0x17, 0x2D, 0x4C, 0x09, 0x00, 0xBC, 0x09, 0x97, 0x23, 0x00, 0x00, 0x00, 0x3E,
    0x00, 0x00, 0x00, 0x41, 0x8C, 0x09, 0x13, 0x1D, 0x04, 0x00, 0x13, 0x10, 0xA8, 0x09, 0x13, 0x16,
    0xEC, 0x03, 0x13, 0x0E, 0x44, 0x00, 0x17, 0x0A, 0xDC, 0x09, 0x00, 0x08, 0x00, 0x13, 0x24, 0x0C,
    0x00, 0x12, 0x1C, 0x8C, 0x09, 0x10, 0x10, 0xC4, 0x00, 0x57, 0xF1, 0xF1, 0x03, 0x08, 0x1C, 0x8C,
    0x09, 0x93, 0x0C, 0x00, 0x06, 0x00, 0x33, 0x00, 0x00, 0x00, 0x39, 0x4C, 0x09, 0x13, 0x37, 0x0C,
    0x00, 0x23, 0x20, 0x18, 0x90, 0x02, 0x12, 0x06, 0x70, 0x00, 0x13, 0x10, 0xF0, 0x01, 0x13, 0x17,
    0x08, 0x00, 0x13, 0x38, 0x64, 0x00, 0x00, 0x8F, 0x01, 0x62, 0x2E, 0x00, 0x00, 0x00, 0xCC, 0x01,
    0x04, 0x00, 0x13, 0x0D, 0x34, 0x01, 0x13, 0x0C, 0xC4, 0x07, 0x17, 0x22, 0x40, 0x01, 0x66, 0xF1,
    0xF1, 0x03, 0x48, 0x60, 0x18, 0x8C, 0x09, 0x00, 0x7C, 0x01, 0x4F, 0xBB, 0x01, 0x00, 0xC0, 0x8C,
    0x09, 0x0D, 0xB5, 0x06, 0x06, 0x0B, 0x08, 0x0D, 0x00, 0x08, 0x00, 0x06, 0x00, 0x0E, 0x60, 0x0A,
    0x13, 0x03, 0xC0, 0x0A, 0x11, 0x07, 0x82, 0x00, 0x1F, 0x08, 0x18, 0x00, 0x06, 0x00, 0x88, 0x09,
    0x11, 0x08, 0x20, 0x00, 0x00, 0x3E, 0x00, 0x3F, 0x0E, 0x00, 0x0D, 0x8C, 0x09, 0xA0, 0xD0, 0x40,
    0x06, 0x31, 0x00, 0x2F, 0x00, 0x40, 0x06, 0x17, 0x00, 0x90, 0x01, 0x09, 0x8C, 0x09, 0x12, 0x61,
    0x8C, 0x09, 0x22, 0xB0, 0x04, 0xDA, 0x03, 0x35, 0x50, 0x50, 0xA0, 0x8C, 0x09, 0x5F, 0x8C, 0x30,
    0x00, 0x00, 0x2B, 0x1C, 0x0D, 0x05, 0x21, 0x00, 0x06, 0xCB, 0x0B, 0x13, 0x11, 0x8C, 0x09, 0x81,
    0x84, 0x10, 0x02, 0x40, 0x85, 0x14, 0x02, 0x40, 0x8C, 0x09, 0x1F, 0x20, 0x8C, 0x09, 0x40, 0x1F,
    0x00, 0x8C, 0x09, 0x0F, 0x26, 0x90, 0x61, 0xCC, 0x10, 0x00, 0x78, 0x02, 0x13, 0x2B, 0x88, 0x02,
    0x00, 0x8C, 0x09, 0x11, 0x33, 0x48, 0x02, 0x15, 0x06, 0xCC, 0x10, 0x2F, 0x20, 0x03, 0x8C, 0x09,
    0x14, 0x53, 0x53, 0x08, 0x0F, 0x10, 0x42, 0x8C, 0x09, 0x5F, 0x43, 0x00, 0x07, 0x06, 0x23, 0xCC,
    0x10, 0x07, 0x43, 0x48, 0x48, 0x0E, 0x8C, 0x04, 0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F, 0xB0, 0x03,
    0xFF, 0x09, 0x1F, 0x99, 0xB0, 0x03, 0xFF, 0x5F, 0x01, 0xCC, 0x10, 0x03, 0xCF, 0x09, 0x0F, 0xB0,
    0x03, 0x78, 0x04, 0xCC, 0x10, 0x13, 0x3F, 0xB0, 0x03, 0x1D, 0x41, 0xB0, 0x03, 0x1F, 0x01, 0xB0,
    0x03, 0x36, 0x0F, 0x90, 0x03, 0x0D, 0x1F, 0x22, 0x40, 0x07, 0xFF, 0xFF, 0xF2, 0x1F, 0x01, 0x40,
    0x07, 0x0D, 0x1F, 0xB0, 0x40, 0x07, 0x37, 0x2F, 0x20, 0x00, 0x02, 0x00, 0x0A, 0x0F, 0xCC, 0x10,
    0xB6, 0x04, 0x01, 0x00, 0xF4, 0x01, 0x27, 0x00, 0x21, 0x00, 0x27, 0x00, 0x20, 0x00, 0x26, 0x00,
    0x23, 0x00, 0x2A, 0x00, 0x22, 0x00, 0x48, 0x03, 0x0C, 0x18, 0x00, 0x0F, 0x01, 0x00, 0xFF, 0x36,
    0x08, 0xCC, 0x10, 0x00, 0xC8, 0x0F, 0x1F, 0x20, 0xCC, 0x10, 0x50, 0x1F, 0x0B, 0x04, 0x00, 0x11,
    0x0F, 0xCC, 0x00, 0x20, 0x12, 0x0C, 0xF4, 0x0F, 0x05, 0xCC, 0x10, 0x13, 0x06, 0x9C, 0x10, 0x00,
    0xC3, 0x05, 0x13, 0x0F, 0x04, 0x00, 0x13, 0x03, 0x04, 0x00, 0x13, 0x0D, 0x1C, 0x00, 0x13, 0x07,
    0x38, 0x00, 0x13, 0x08, 0x90, 0x06, 0x00, 0x50, 0x06, 0xBF, 0x03, 0x03, 0x06, 0x05, 0x0C, 0x08,
    0x0D, 0x00, 0x19, 0x24, 0x6C, 0xCC, 0x10, 0x1E, 0x13, 0xD0, 0xCC, 0x10, 0xF7, 0x06, 0x03, 0x12,
    0x00, 0x00, 0x3D, 0x00, 0x80, 0x00, 0x38, 0x00, 0x80, 0x00, 0x41, 0x00, 0x80, 0x00, 0x90, 0x00,
    0x80, 0x00, 0x05, 0x08, 0x00, 0x70, 0x49, 0x00, 0x34, 0x00, 0x80, 0x00, 0x80, 0xFA, 0x14, 0x62,
    0x00, 0x16, 0x00, 0x08, 0x00, 0x80, 0x06, 0x15, 0x23, 0x00, 0x19, 0x04, 0x00, 0x91, 0x18, 0x00,
    0x80, 0x00, 0x95, 0x00, 0x80, 0x00, 0x1D, 0x26, 0x00, 0x31, 0x00, 0x00, 0x2C, 0xDC, 0x00, 0x11,
    0x80, 0x98, 0x06, 0x17, 0x08, 0xCC, 0x10, 0x17, 0x09, 0xBC, 0x17, 0x1F, 0x00, 0xCC, 0x10, 0x10,
    0x79, 0x56, 0x01, 0x55, 0x05, 0x55, 0x05, 0x02, 0x0C, 0x00, 0x13, 0x01, 0xDC, 0x07, 0x00, 0x01,
    0x00, 0x13, 0x2F, 0x08, 0x00, 0x57, 0x54, 0x00, 0x01, 0x08, 0x2D, 0xCC, 0x10, 0x2F, 0x48, 0x48,
    0xCC, 0x10, 0x1B, 0x1B, 0x35, 0xCC, 0x10, 0x00, 0x50, 0x10, 0x00, 0x07, 0x00, 0x80, 0x9C, 0x04,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

constexpr const u8 T210b01SdevEmcDvfsTableS1y8gb04[0x687] = {
    0xFF, 0x0E, 0x03, 0x00, 0x00, 0x00, 0x30, 0x31, 0x5F, 0x32, 0x30, 0x34, 0x30, 0x30, 0x30, 0x5F,
    0x56, 0x34, 0x5F, 0x56, 0x30, 0x2E, 0x34, 0x2E, 0x35, 0x5F, 0x56, 0x32, 0x2E, 0x30, 0x00, 0x01,
    0x00, 0x10, 0x71, 0xE0, 0x1C, 0x03, 0x00, 0x4C, 0x04, 0x00, 0x04, 0x00, 0x8F, 0x70, 0x6C, 0x6C,
    0x70, 0x5F, 0x6F, 0x75, 0x74, 0x39, 0x00, 0x05, 0x5F, 0x02, 0x80, 0x18, 0x40, 0x00, 0x01, 0x00,
    0x40, 0xFF, 0x1E, 0x3F, 0x3A, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xE4,
    0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x8A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x05,
    0x50, 0x00, 0x10, 0x17, 0x0A, 0x04, 0x00, 0x22, 0x01, 0x00, 0x5C, 0x00, 0x57, 0x3A, 0x00, 0x00,
    0x00, 0x1D, 0x24, 0x00, 0x13, 0x09, 0x54, 0x00, 0x13, 0x0B, 0x20, 0x00, 0x13, 0x08, 0x0C, 0x00,
    0x13, 0x00, 0x18, 0x00, 0x53, 0x17, 0x00, 0x00, 0x00, 0x15, 0x08, 0x00, 0x13, 0x1B, 0x18, 0x00,
    0x57, 0x20, 0x00, 0x00, 0x00, 0x06, 0x04, 0x00, 0x13, 0x03, 0x18, 0x00, 0x13, 0x06, 0x34, 0x00,
    0x17, 0x02, 0x40, 0x00, 0x00, 0x50, 0x00, 0x13, 0x0E, 0xB0, 0x00, 0x18, 0x06, 0x44, 0x01, 0x74,
    0x00, 0x00, 0x00, 0x31, 0x31, 0x03, 0x08, 0xF0, 0x00, 0x40, 0x00, 0x00, 0x00, 0x80, 0x0A, 0x00,
    0x13, 0x12, 0xE8, 0x00, 0x54, 0x1A, 0x00, 0x00, 0x00, 0x16, 0xF4, 0x00, 0x03, 0x61, 0x00, 0x13,
    0xC1, 0x50, 0x00, 0x13, 0x08, 0x74, 0x00, 0x13, 0x0A, 0x08, 0x00, 0x04, 0x10, 0x01, 0x13, 0x02,
    0xC4, 0x00, 0x13, 0x3B, 0x04, 0x00, 0x13, 0x05, 0x04, 0x00, 0x13, 0x04, 0xE8, 0x00, 0x08, 0x0C,
    0x00, 0x53, 0x31, 0x31, 0x03, 0x48, 0x1C, 0x58, 0x00, 0x40, 0x0D, 0xA0, 0x60, 0x91, 0x7C, 0x01,
    0x31, 0xA0, 0x00, 0x2C, 0x86, 0x00, 0x11, 0x78, 0x16, 0x00, 0x2F, 0xFF, 0x0F, 0x56, 0x01, 0x03,
    0xFF, 0x12, 0x0B, 0x08, 0x10, 0x00, 0x14, 0x00, 0x0B, 0x00, 0x13, 0x00, 0x47, 0x00, 0x45, 0x00,
    0x4F, 0x00, 0x4D, 0x00, 0x46, 0x00, 0x46, 0x00, 0x48, 0x00, 0x48, 0x00, 0x08, 0x00, 0x0C, 0x00,
    0x0C, 0x00, 0x0B, 0x18, 0x00, 0x06, 0x20, 0x10, 0x00, 0x3A, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x3E,
    0x00, 0x4F, 0x13, 0x00, 0x10, 0x00, 0x01, 0x00, 0x8F, 0x80, 0x1F, 0x22, 0x20, 0x80, 0x0F, 0xF4,
    0x20, 0x02, 0x98, 0x01, 0xF0, 0x0E, 0x00, 0x40, 0x06, 0x00, 0xCC, 0x00, 0x09, 0x00, 0x10, 0x00,
    0xCC, 0x00, 0x0A, 0x00, 0x33, 0x00, 0x02, 0x03, 0xE0, 0xC1, 0x20, 0x41, 0x13, 0x1F, 0x14, 0x00,
    0x01, 0x00, 0x99, 0x5C, 0x01, 0x60, 0x08, 0x00, 0x00, 0x50, 0x50, 0x50, 0x22, 0x02, 0x10, 0xF3,
    0x40, 0x01, 0x22, 0x13, 0x07, 0xA4, 0x01, 0x04, 0x4C, 0x00, 0x13, 0x12, 0x04, 0x00, 0x11, 0x00,
    0xB8, 0x01, 0x11, 0x05, 0x9F, 0x01, 0x23, 0x10, 0x02, 0x51, 0x02, 0x00, 0xE4, 0x02, 0x13, 0x04,
    0x92, 0x02, 0x1F, 0x34, 0x1A, 0x01, 0x07, 0x03, 0x79, 0x03, 0x08, 0x21, 0x00, 0xAF, 0x10, 0x00,
    0x01, 0x01, 0x00, 0x10, 0x00, 0x40, 0x00, 0x20, 0xC9, 0x00, 0x09, 0x34, 0xEF, 0x00, 0xEF, 0x0B,
    0x00, 0x48, 0x1C, 0x1C, 0x1C, 0x1C, 0x1B, 0x00, 0x22, 0x10, 0x10, 0x04, 0x00, 0x44, 0x33, 0x60,
    0x18, 0x01, 0x14, 0x00, 0x13, 0x18, 0x60, 0x02, 0x00, 0x88, 0x02, 0x42, 0x14, 0x14, 0x16, 0x08,
    0xB8, 0x00, 0xF0, 0x07, 0x01, 0x00, 0x80, 0x90, 0x00, 0x00, 0x04, 0x04, 0x07, 0x07, 0x65, 0x00,
    0x04, 0x00, 0x1F, 0x80, 0x13, 0x05, 0x00, 0x11, 0x10, 0x1F, 0x80, 0x02, 0xF0, 0x0F, 0x40, 0x72,
    0x10, 0x00, 0x00, 0x40, 0x12, 0x01, 0x6A, 0x5B, 0x12, 0x01, 0x00, 0x10, 0x08, 0x0F, 0x00, 0x58,
    0x10, 0x00, 0x00, 0xFC, 0x10, 0x11, 0x00, 0x13, 0x08, 0x0F, 0x50, 0x7C, 0x0C, 0x00, 0xF3, 0x07,
    0x14, 0x11, 0x00, 0x03, 0x00, 0x07, 0x4C, 0x72, 0x10, 0x00, 0x5A, 0x3C, 0x55, 0x55, 0x14, 0x14,
    0x16, 0x48, 0x5D, 0x5D, 0x0C, 0x88, 0x04, 0x00, 0x12, 0x48, 0x04, 0x00, 0x23, 0x0E, 0x8C, 0x04,
    0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F, 0xB0, 0x03, 0xFF, 0x09, 0x1F, 0x99, 0xB0, 0x03, 0xFF, 0x5E,
    0x72, 0x00, 0x80, 0x06, 0x06, 0x00, 0x00, 0x05, 0x13, 0x02, 0x0F, 0xB0, 0x03, 0x78, 0x00, 0x8C,
    0x02, 0x10, 0x1F, 0x24, 0x00, 0x03, 0x68, 0x02, 0x13, 0x1E, 0xB0, 0x03, 0x15, 0x10, 0xB0, 0x03,
    0x1F, 0x01, 0xB0, 0x03, 0x36, 0x0F, 0x90, 0x03, 0x09, 0x13, 0x0E, 0x04, 0x00, 0x0F, 0x90, 0x03,
    0x21, 0x13, 0x13, 0x04, 0x00, 0x0F, 0x90, 0x03, 0x14, 0x22, 0x30, 0x02, 0x04, 0x00, 0x0F, 0x90,
    0x03, 0x00, 0x1F, 0x04, 0x40, 0x07, 0xFF, 0xFF, 0x70, 0x1F, 0x01, 0x40, 0x07, 0x0A, 0x4F, 0x04,
    0x00, 0x80, 0xB0, 0x40, 0x07, 0x37, 0x2F, 0x48, 0x00, 0x02, 0x00, 0x0B, 0x0F, 0x01, 0x00, 0xAD,
    0x1B, 0x35, 0x01, 0x00, 0x0C, 0x20, 0x00, 0x04, 0x48, 0x03, 0x0F, 0x01, 0x00, 0xFF, 0x16, 0x39,
    0x49, 0x92, 0x24, 0x04, 0x00, 0x0F, 0x01, 0x00, 0x0D, 0x00, 0xB4, 0x02, 0x40, 0x04, 0x01, 0x00,
    0x00, 0x16, 0x0A, 0x1B, 0x18, 0x10, 0x09, 0x05, 0x50, 0x03, 0x5A, 0x42, 0x0F, 0x00, 0x60, 0x09,
    0x14, 0x00, 0x1E, 0x01, 0x0C, 0x00, 0x0F, 0xFC, 0x00, 0x6E, 0xF5, 0x02, 0x01, 0x00, 0x00, 0x08,
    0x4C, 0x00, 0x00, 0x80, 0x20, 0x10, 0x0A, 0x00, 0x28, 0x10, 0x00, 0x80, 0x01, 0x48, 0x04, 0x02,
    0xA4, 0x00, 0x17, 0x02, 0x08, 0x00, 0x17, 0x05, 0x10, 0x00, 0x04, 0x84, 0x06, 0x00, 0x14, 0x00,
    0x11, 0x07, 0x14, 0x00, 0xE3, 0x02, 0x02, 0x01, 0x02, 0x03, 0x00, 0x04, 0x05, 0xA3, 0x72, 0x0F,
    0x0F, 0x00, 0x70, 0xE6, 0x04, 0x4F, 0x00, 0x1A, 0x00, 0x80, 0x04, 0x00, 0x0E, 0x11, 0x1B, 0x10,
    0x04, 0xF1, 0x02, 0x80, 0x00, 0x4C, 0x02, 0x00, 0x00, 0xB2, 0x00, 0xFF, 0x00, 0xDA, 0x00, 0xFF,
    0x00, 0x9D, 0x00, 0xFF, 0x02, 0x00, 0x17, 0x0C, 0x08, 0x00, 0xF1, 0x02, 0x49, 0x00, 0x7F, 0x00,
    0x80, 0x00, 0xFF, 0x00, 0x04, 0x00, 0xFF, 0x00, 0xAD, 0x00, 0x08, 0x00, 0xFF, 0x88, 0x00, 0x33,
    0xFF, 0x00, 0xC6, 0x04, 0x00, 0x13, 0x6D, 0x2C, 0x00, 0x11, 0xE2, 0x06, 0x00, 0x01, 0x73, 0x06,
    0x01, 0x0A, 0x00, 0x13, 0x14, 0xC0, 0x06, 0x2E, 0xF4, 0x01, 0x78, 0x01, 0x13, 0x08, 0x44, 0x0F,
    0x0F, 0x23, 0x01, 0x08, 0x1F, 0xC0, 0x0C, 0x00, 0x04, 0x07, 0x70, 0x03, 0x04, 0x98, 0x07, 0x90,
    0x01, 0x08, 0x00, 0x00, 0x02, 0x08, 0x00, 0x00, 0x0D, 0x57, 0x00, 0x58, 0xC0, 0x5D, 0x5D, 0x0E,
    0x0C, 0x28, 0x00, 0xC0, 0xD8, 0x51, 0x1A, 0xA0, 0x00, 0x00, 0x50, 0x05, 0x00, 0x00, 0x88, 0x00,
    0x04, 0x00, 0x11, 0x20, 0xFD, 0x04, 0x15, 0x88, 0x04, 0x00, 0x50, 0x25, 0x08, 0x11, 0x00, 0x0C,
    0x46, 0x00, 0x07, 0x50, 0x10, 0x00, 0x0C, 0x00, 0x26, 0x5C, 0x0D, 0x94, 0x01, 0x7F, 0x30, 0x31,
    0x5F, 0x31, 0x36, 0x30, 0x30, 0xCD, 0x10, 0x23, 0x28, 0x6A, 0x18, 0xCC, 0x10, 0x4F, 0x6D, 0x5F,
    0x75, 0x64, 0x2C, 0x00, 0x07, 0x21, 0x80, 0x18, 0x0C, 0x02, 0x2F, 0xF0, 0x02, 0xB4, 0x02, 0x3B,
    0x22, 0xFF, 0x3B, 0x6C, 0x06, 0x0F, 0xCC, 0x10, 0x45, 0x10, 0x60, 0x79, 0x01, 0x47, 0x01, 0x00,
    0x00, 0xE0, 0x24, 0x00, 0x13, 0x44, 0x9C, 0x09, 0x13, 0x29, 0x64, 0x00, 0x00, 0x95, 0x01, 0x17,
    0x2D, 0x4C, 0x09, 0x00, 0xBC, 0x09, 0x97, 0x23, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x41,
    0x8C, 0x09, 0x13, 0x1D, 0x04, 0x00, 0x13, 0x10, 0x98, 0x00, 0x13, 0x16, 0xEC, 0x03, 0x13, 0x0E,
    0x44, 0x00, 0x17, 0x0A, 0xDC, 0x09, 0x13, 0x0E, 0x44, 0x00, 0x12, 0x09, 0xD0, 0x09, 0x00, 0x7F,
    0x07, 0x10, 0x10, 0x82, 0x05, 0x57, 0xF1, 0xF1, 0x03, 0x08, 0x1D, 0x8C, 0x09, 0x93, 0x0B, 0x00,
    0x06, 0x00, 0x33, 0x00, 0x00, 0x00, 0x39, 0x4C, 0x09, 0x13, 0x37, 0x0C, 0x00, 0x23, 0x20, 0x18,
    0x90, 0x02, 0x12, 0x06, 0x70, 0x00, 0x13, 0x10, 0xF0, 0x01, 0x13, 0x17, 0x08, 0x00, 0x13, 0x38,
    0x64, 0x00, 0x00, 0x8F, 0x01, 0x62, 0x2E, 0x00, 0x00, 0x00, 0xCC, 0x01, 0x04, 0x00, 0x13, 0x0D,
    0x9C, 0x00, 0x13, 0x0C, 0xC4, 0x07, 0x17, 0x22, 0x40, 0x01, 0x66, 0xF1, 0xF1, 0x03, 0x48, 0x60,
    0x18, 0x8C, 0x09, 0x00, 0x7C, 0x01, 0x4F, 0xBB, 0x01, 0x00, 0xC0, 0x8C, 0x09, 0x0D, 0xB3, 0x06,
    0x06, 0x0B, 0x08, 0x0A, 0x00, 0x0C, 0x00, 0x06, 0x00, 0x0B, 0xDE, 0x03, 0x13, 0x07, 0x8E, 0x01,
    0x51, 0x09, 0x00, 0x05, 0x00, 0x07, 0x02, 0x00, 0x0F, 0x18, 0x00, 0x05, 0x31, 0x0A, 0x00, 0x0A,
    0x96, 0x09, 0x11, 0x06, 0x3E, 0x00, 0x3F, 0x0B, 0x00, 0x0A, 0x8C, 0x09, 0xA0, 0xD0, 0x40, 0x06,
    0x31, 0x00, 0x2F, 0x00, 0x40, 0x06, 0x17, 0x00, 0x90, 0x01, 0x09, 0x8C, 0x09, 0x12, 0x61, 0x8C,
    0x09, 0x22, 0xB0, 0x04, 0xDA, 0x03, 0x08, 0x8C, 0x09, 0x5F, 0x8C, 0x30, 0x00, 0x00, 0x2B, 0x1C,
    0x0D, 0x05, 0x21, 0x00, 0x06, 0xCB, 0x0B, 0x13, 0x11, 0x8C, 0x09, 0x81, 0x84, 0x10, 0x02, 0x40,
    0x85, 0x14, 0x02, 0x40, 0x26, 0x02, 0x1F, 0x20, 0x8C, 0x09, 0x40, 0x1F, 0x00, 0x8C, 0x09, 0x0F,
    0x26, 0x90, 0x61, 0xCC, 0x10, 0x00, 0x78, 0x02, 0x13, 0x2B, 0x88, 0x02, 0x00, 0x8C, 0x09, 0x11,
    0x33, 0xA4, 0x0C, 0x15, 0x06, 0xCC, 0x10, 0x2F, 0x20, 0x03, 0x8C, 0x09, 0x14, 0x53, 0x53, 0x08,
    0x0F, 0x10, 0x42, 0x8C, 0x09, 0x5F, 0x43, 0x00, 0x07, 0x06, 0x23, 0xCC, 0x10, 0x07, 0x43, 0x48,
    0x48, 0x0E, 0x8C, 0x04, 0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F, 0xB0, 0x03, 0xFF, 0x09, 0x1F, 0x99,
    0xB0, 0x03, 0xFF, 0x5F, 0x01, 0xCC, 0x10, 0x03, 0xCF, 0x09, 0x0F, 0xB0, 0x03, 0x78, 0x04, 0xCC,
    0x10, 0x13, 0x3F, 0xB0, 0x03, 0x1D, 0x41, 0xB0, 0x03, 0x1F, 0x01, 0xB0, 0x03, 0x36, 0x0F, 0x90,
    0x03, 0x0D, 0x1F, 0x22, 0x40, 0x07, 0xFF, 0xFF, 0xF2, 0x1F, 0x01, 0x40, 0x07, 0x0D, 0x1F, 0xB0,
    0x40, 0x07, 0x37, 0x2F, 0x20, 0x00, 0x02, 0x00, 0x0A, 0x0F, 0x7C, 0x0F, 0xAE, 0x1B, 0x29, 0x01,
    0x00, 0xF4, 0x01, 0x23, 0x00, 0x29, 0x00, 0x27, 0x00, 0x2D, 0x00, 0x22, 0x00, 0x27, 0x00, 0x23,
    0x00, 0x2C, 0x00, 0x48, 0x03, 0x0C, 0x18, 0x00, 0x0F, 0x01, 0x00, 0xFF, 0x36, 0x08, 0xCC, 0x10,
    0x16, 0x07, 0x33, 0x14, 0x0F, 0xCC, 0x10, 0xA2, 0x12, 0x0C, 0xF4, 0x0F, 0x05, 0xCC, 0x10, 0x13,
    0x06, 0x62, 0x05, 0x00, 0xC3, 0x05, 0x13, 0x0F, 0x04, 0x00, 0x13, 0x03, 0x04, 0x00, 0x17, 0x0D,
    0x82, 0x05, 0x13, 0x0C, 0x84, 0x06, 0x13, 0x0A, 0x50, 0x06, 0xBF, 0x03, 0x03, 0x06, 0x05, 0x0C,
    0x08, 0x0D, 0x00, 0x19, 0x24, 0x6C, 0xCC, 0x10, 0x1E, 0x13, 0xD0, 0xCC, 0x10, 0xF7, 0x06, 0x03,
    0x12, 0x00, 0x00, 0x3D, 0x00, 0x80, 0x00, 0x38, 0x00, 0x80, 0x00, 0x41, 0x00, 0x80, 0x00, 0x90,
    0x00, 0x80, 0x00, 0x05, 0x08, 0x00, 0x70, 0x49, 0x00, 0x34, 0x00, 0x80, 0x00, 0x80, 0xFA, 0x14,
    0x62, 0x00, 0x16, 0x00, 0x08, 0x00, 0x80, 0x06, 0x15, 0x23, 0x00, 0x19, 0x04, 0x00, 0x91, 0x18,
    0x00, 0x80, 0x00, 0x95, 0x00, 0x80, 0x00, 0x1D, 0x26, 0x00, 0x11, 0x00, 0xF2, 0x02, 0x00, 0x0A,
    0x00, 0x13, 0x14, 0xAC, 0x00, 0x04, 0xCC, 0x10, 0x17, 0x09, 0xBC, 0x17, 0x1F, 0x00, 0xCC, 0x10,
    0x10, 0x79, 0x56, 0x01, 0x55, 0x05, 0x55, 0x05, 0x02, 0x0C, 0x00, 0x13, 0x01, 0xDC, 0x07, 0x00,
    0x01, 0x00, 0x13, 0x2F, 0x08, 0x00, 0x57, 0x54, 0x00, 0x01, 0x08, 0x2D, 0xCC, 0x10, 0x2F, 0x48,
    0x48, 0xCC, 0x10, 0x1B, 0x1B, 0x35, 0xCC, 0x10, 0x00, 0x50, 0x10, 0x00, 0x07, 0x00, 0x80, 0x9C,
    0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

constexpr const u8 T210b01SdevEmcDvfsTableS1y4gbY01[0x681] = {
    0xFF, 0x18, 0x03, 0x00, 0x00, 0x00, 0x30, 0x31, 0x5F, 0x32, 0x30, 0x34, 0x30, 0x30, 0x30, 0x5F,
    0x4E, 0x6F, 0x43, 0x66, 0x67, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6F, 0x6E, 0x5F, 0x56, 0x30, 0x2E,
    0x34, 0x2E, 0x32, 0x5F, 0x56, 0x32, 0x2E, 0x30, 0x00, 0x01, 0x00, 0x06, 0x71, 0xE0, 0x1C, 0x03,
    0x00, 0x4C, 0x04, 0x00, 0x04, 0x00, 0x8F, 0x70, 0x6C, 0x6C, 0x70, 0x5F, 0x6F, 0x75, 0x74, 0x2F,
    0x00, 0x05, 0x5F, 0x02, 0x80, 0x18, 0x40, 0x00, 0x01, 0x00, 0x40, 0xFF, 0x1E, 0x3F, 0x3A, 0x00,
    0x00, 0x0D, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
    0x00, 0x8A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
    0x00, 0x04, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x05, 0x50, 0x00, 0x10, 0x17, 0x0A, 0x04,
    0x00, 0x22, 0x01, 0x00, 0x5C, 0x00, 0x57, 0x3A, 0x00, 0x00, 0x00, 0x1D, 0x24, 0x00, 0x13, 0x09,
    0x54, 0x00, 0x13, 0x0B, 0x20, 0x00, 0x13, 0x08, 0x0C, 0x00, 0x13, 0x00, 0x18, 0x00, 0x53, 0x17,
    0x00, 0x00, 0x00, 0x15, 0x08, 0x00, 0x13, 0x1B, 0x18, 0x00, 0x57, 0x20, 0x00, 0x00, 0x00, 0x06,
    0x04, 0x00, 0x13, 0x03, 0x18, 0x00, 0x13, 0x06, 0x34, 0x00, 0x17, 0x02, 0x40, 0x00, 0x00, 0x50,
    0x00, 0x13, 0x0E, 0xB0, 0x00, 0x18, 0x06, 0x44, 0x01, 0x74, 0x00, 0x00, 0x00, 0x31, 0x31, 0x03,
    0x88, 0xF0, 0x00, 0x40, 0x00, 0x00, 0x00, 0x80, 0x0A, 0x00, 0x13, 0x12, 0xE8, 0x00, 0x54, 0x1A,
    0x00, 0x00, 0x00, 0x16, 0xF4, 0x00, 0x03, 0x61, 0x00, 0x13, 0xC1, 0x50, 0x00, 0x13, 0x08, 0x74,
    0x00, 0x13, 0x0A, 0x08, 0x00, 0x04, 0x10, 0x01, 0x13, 0x02, 0xC4, 0x00, 0x13, 0x3B, 0x04, 0x00,
    0x13, 0x05, 0x04, 0x00, 0x04, 0x88, 0x00, 0x04, 0x0C, 0x00, 0x12, 0x09, 0x7C, 0x00, 0x23, 0xC8,
    0x1C, 0x58, 0x00, 0x40, 0x0D, 0xA0, 0x60, 0x91, 0x7C, 0x01, 0x31, 0xA0, 0x00, 0x2C, 0x86, 0x00,
    0x11, 0x78, 0x16, 0x00, 0x2F, 0xFF, 0x0F, 0x56, 0x01, 0x03, 0xF1, 0x0C, 0x0B, 0x88, 0x18, 0x00,
    0x0F, 0x00, 0x0B, 0x00, 0x17, 0x00, 0x48, 0x00, 0x44, 0x00, 0x45, 0x00, 0x44, 0x00, 0x47, 0x00,
    0x47, 0x00, 0x41, 0x00, 0x46, 0x00, 0x0D, 0x62, 0x00, 0x1F, 0x0D, 0x18, 0x00, 0x06, 0x20, 0x18,
    0x00, 0x3A, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x3E, 0x00, 0x11, 0x17, 0xDC, 0x00, 0x0F, 0x01, 0x00,
    0x8D, 0x80, 0x1F, 0x22, 0x20, 0x80, 0x0F, 0xF4, 0x20, 0x02, 0x98, 0x01, 0xF0, 0x0E, 0x00, 0x40,
    0x06, 0x00, 0xCC, 0x00, 0x09, 0x00, 0x10, 0x00, 0xCC, 0x00, 0x0A, 0x00, 0x33, 0x00, 0x02, 0x03,
    0xE0, 0xC1, 0x20, 0x41, 0x13, 0x1F, 0x14, 0x00, 0x01, 0x00, 0x99, 0x5C, 0x01, 0x60, 0x08, 0x00,
    0x00, 0x50, 0x50, 0x50, 0x22, 0x02, 0x10, 0xF3, 0x40, 0x01, 0x57, 0x13, 0x07, 0x00, 0x80, 0x0A,
    0x4C, 0x00, 0x13, 0x12, 0x04, 0x00, 0x11, 0x00, 0xB8, 0x01, 0x11, 0x05, 0x9F, 0x01, 0x23, 0x10,
    0x02, 0x51, 0x02, 0x00, 0xE4, 0x02, 0x13, 0x04, 0x92, 0x02, 0x2F, 0x34, 0x10, 0x90, 0x00, 0x06,
    0x03, 0x79, 0x03, 0x09, 0x21, 0x00, 0x9F, 0x80, 0x00, 0x40, 0x00, 0x04, 0x10, 0x80, 0x00, 0x20,
    0xC9, 0x00, 0x09, 0x34, 0xEF, 0x00, 0xEF, 0x0B, 0x00, 0x48, 0x1C, 0x1C, 0x1C, 0x1C, 0x1B, 0x00,
    0x22, 0x10, 0x10, 0x04, 0x00, 0x44, 0x33, 0x60, 0x18, 0x01, 0x14, 0x00, 0x13, 0x18, 0x60, 0x02,
    0x00, 0x88, 0x02, 0x42, 0x14, 0x14, 0x16, 0x88, 0xB8, 0x00, 0xF0, 0x07, 0x01, 0x00, 0x80, 0x90,
    0x00, 0x00, 0x04, 0x04, 0x07, 0x07, 0x65, 0x00, 0x04, 0x00, 0x1F, 0x80, 0x13, 0x05, 0x00, 0x11,
    0x10, 0x1F, 0x80, 0x02, 0xF0, 0x0F, 0x40, 0x72, 0x10, 0x00, 0x00, 0x40, 0x12, 0x01, 0x6A, 0x5B,
    0x12, 0x01, 0x00, 0x10, 0x08, 0x0F, 0x00, 0x58, 0x10, 0x00, 0x00, 0xFC, 0x10, 0x11, 0x00, 0x13,
    0x08, 0x0F, 0x50, 0x7C, 0x0C, 0x00, 0xF3, 0x07, 0x14, 0x11, 0x00, 0x03, 0x00, 0x07, 0x4C, 0x72,
    0x10, 0x00, 0x5A, 0x3C, 0x55, 0x55, 0x14, 0x14, 0x16, 0xC8, 0x5D, 0x5D, 0x0C, 0x88, 0x04, 0x00,
    0x12, 0xC8, 0x04, 0x00, 0x23, 0x0E, 0x8C, 0x04, 0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F, 0xB0, 0x03,
    0xFF, 0x09, 0x1F, 0x99, 0xB0, 0x03, 0xFF, 0x5E, 0x72, 0x00, 0x80, 0x06, 0x06, 0x00, 0x00, 0x05,
    0x13, 0x02, 0x0F, 0xB0, 0x03, 0x78, 0x00, 0x8C, 0x02, 0x10, 0x1F, 0x24, 0x00, 0x03, 0x34, 0x02,
    0x13, 0x1E, 0xB0, 0x03, 0x1F, 0x10, 0xB0, 0x03, 0x40, 0x0F, 0x90, 0x03, 0x09, 0x13, 0x0E, 0x04,
    0x00, 0x0F, 0x90, 0x03, 0x21, 0x13, 0x13, 0x04, 0x00, 0x0F, 0x90, 0x03, 0x14, 0x22, 0x30, 0x02,
    0x04, 0x00, 0x0F, 0x90, 0x03, 0x00, 0x1F, 0x04, 0x40, 0x07, 0xFF, 0xFF, 0x70, 0x1F, 0x01, 0x40,
    0x07, 0x0A, 0x4F, 0x04, 0x00, 0x80, 0xB0, 0x90, 0x03, 0x37, 0x2F, 0x28, 0x00, 0x02, 0x00, 0x0B,
    0x0F, 0x01, 0x00, 0xAD, 0x1B, 0x29, 0x01, 0x00, 0x0C, 0x20, 0x00, 0x04, 0x48, 0x03, 0x0F, 0x01,
    0x00, 0xFF, 0x16, 0x39, 0x49, 0x92, 0x24, 0x04, 0x00, 0x0F, 0x01, 0x00, 0x0D, 0x00, 0xB4, 0x02,
    0x40, 0x04, 0x01, 0x00, 0x00, 0x16, 0x0A, 0x1B, 0x18, 0x10, 0x09, 0x05, 0x50, 0x03, 0x5A, 0x42,
    0x0F, 0x00, 0x60, 0x09, 0x14, 0x00, 0x1E, 0x01, 0x0C, 0x00, 0x0F, 0xFC, 0x00, 0x6E, 0xF5, 0x02,
    0x01, 0x00, 0x00, 0x08, 0x4C, 0x00, 0x00, 0x80, 0x20, 0x10, 0x0A, 0x00, 0x28, 0x10, 0x00, 0x80,
    0x01, 0x48, 0x04, 0x02, 0xA4, 0x00, 0x04, 0x04, 0x00, 0x13, 0x02, 0xE8, 0x05, 0x04, 0x10, 0x00,
    0x08, 0xFC, 0x05, 0x12, 0x07, 0x0A, 0x0A, 0xD3, 0x02, 0x01, 0x02, 0x03, 0x00, 0x04, 0x05, 0xA3,
    0x72, 0x0F, 0x0F, 0x00, 0x70, 0xE6, 0x04, 0x4F, 0x00, 0x1A, 0x00, 0x80, 0x04, 0x00, 0x0E, 0x11,
    0x1B, 0x10, 0x04, 0xF1, 0x02, 0x80, 0x00, 0x4C, 0x02, 0x00, 0x00, 0xB2, 0x00, 0xFF, 0x00, 0xDA,
    0x00, 0xFF, 0x00, 0x9D, 0x00, 0xFF, 0x02, 0x00, 0x17, 0x0C, 0x08, 0x00, 0xF1, 0x02, 0x49, 0x00,
    0x7F, 0x00, 0x80, 0x00, 0xFF, 0x00, 0x04, 0x00, 0xFF, 0x00, 0xAD, 0x00, 0x08, 0x00, 0xFF, 0x88,
    0x00, 0x33, 0xFF, 0x00, 0xC6, 0x04, 0x00, 0x13, 0x6D, 0x2C, 0x00, 0x11, 0xE2, 0x06, 0x00, 0x01,
    0x73, 0x06, 0x01, 0x0A, 0x00, 0x13, 0x14, 0xC0, 0x06, 0x2E, 0xF4, 0x01, 0x78, 0x01, 0x13, 0x08,
    0x44, 0x0F, 0x0F, 0x23, 0x01, 0x08, 0x1F, 0xC0, 0x0C, 0x00, 0x04, 0x06, 0xE8, 0x04, 0x05, 0x98,
    0x07, 0xA0, 0x01, 0x88, 0x00, 0x00, 0x02, 0x88, 0x00, 0x00, 0x0D, 0x88, 0x2C, 0x00, 0x00, 0xB4,
    0x0B, 0x08, 0x28, 0x00, 0xA0, 0xD8, 0x51, 0x1A, 0xA0, 0x00, 0x00, 0x50, 0x05, 0x00, 0x00, 0x1F,
    0x00, 0x31, 0x88, 0x00, 0x20, 0xFD, 0x04, 0x15, 0x88, 0x04, 0x00, 0x50, 0x25, 0x08, 0x11, 0x00,
    0x0C, 0x46, 0x00, 0x07, 0x50, 0x10, 0x00, 0x0C, 0x00, 0x26, 0x5C, 0x0D, 0x94, 0x01, 0x7F, 0x30,
    0x31, 0x5F, 0x31, 0x36, 0x30, 0x30, 0xCD, 0x10, 0x23, 0x28, 0x6A, 0x18, 0xCC, 0x10, 0x4F, 0x6D,
    0x5F, 0x75, 0x64, 0x2C, 0x00, 0x07, 0x21, 0x80, 0x18, 0x0C, 0x02, 0x2F, 0xF0, 0x02, 0xB4, 0x02,
    0x3B, 0x22, 0xFF, 0x3B, 0x6C, 0x06, 0x0F, 0xCC, 0x10, 0x45, 0x10, 0x60, 0x79, 0x01, 0x47, 0x01,
    0x00, 0x00, 0xE0, 0x24, 0x00, 0x13, 0x44, 0x9C, 0x09, 0x13, 0x29, 0x64, 0x00, 0x57, 0x0C, 0x00,
    0x00, 0x00, 0x2D, 0x4C, 0x09, 0x00, 0xBC, 0x09, 0x97, 0x23, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00,
    0x00, 0x41, 0x8C, 0x09, 0x13, 0x1D, 0x04, 0x00, 0x13, 0x0C, 0x98, 0x00, 0x13, 0x16, 0xEC, 0x03,
    0x13, 0x0E, 0x14, 0x00, 0x17, 0x0A, 0xDC, 0x09, 0x13, 0x0E, 0x44, 0x00, 0x12, 0x09, 0xD0, 0x09,
    0x00, 0x7F, 0x07, 0x10, 0x10, 0xBC, 0x09, 0x57, 0xF1, 0xF1, 0x03, 0x88, 0x1D, 0x8C, 0x09, 0x93,
    0x0B, 0x00, 0x06, 0x00, 0x33, 0x00, 0x00, 0x00, 0x39, 0x4C, 0x09, 0x13, 0x37, 0x0C, 0x00, 0x13,
    0x20, 0xB5, 0x08, 0x22, 0x08, 0x06, 0x50, 0x02, 0x13, 0x10, 0xF0, 0x01, 0x13, 0x17, 0x08, 0x00,
    0x13, 0x38, 0x64, 0x00, 0x00, 0x8F, 0x01, 0x62, 0x2E, 0x00, 0x00, 0x00, 0xCC, 0x01, 0x04, 0x00,
    0x13, 0x0D, 0x9C, 0x00, 0x00, 0x90, 0x00, 0x00, 0xFA, 0x01, 0x17, 0x22, 0x40, 0x01, 0x66, 0xF1,
    0xF1, 0x03, 0xC8, 0x60, 0x18, 0x8C, 0x09, 0x00, 0x7C, 0x01, 0x4F, 0xBB, 0x01, 0x00, 0xC0, 0x8C,
    0x09, 0x0D, 0xD7, 0x06, 0x06, 0x0B, 0x88, 0x0E, 0x00, 0x09, 0x00, 0x07, 0x00, 0x0E, 0x00, 0x03,
    0x1C, 0x0E, 0x11, 0x0B, 0xEC, 0x03, 0x11, 0x03, 0xF2, 0x00, 0x0F, 0x18, 0x00, 0x05, 0x20, 0x0E,
    0x00, 0x3A, 0x00, 0x00, 0x3C, 0x00, 0x11, 0x07, 0x0C, 0x00, 0x1F, 0x0E, 0x8C, 0x09, 0xA0, 0xD0,
    0x40, 0x06, 0x31, 0x00, 0x2F, 0x00, 0x40, 0x06, 0x17, 0x00, 0x90, 0x01, 0x09, 0x8C, 0x09, 0x12,
    0x61, 0x8C, 0x09, 0x5B, 0xB0, 0x04, 0x00, 0x00, 0x0D, 0x8C, 0x09, 0x5F, 0x8C, 0x30, 0x00, 0x80,
    0x2B, 0x1C, 0x0D, 0x05, 0x21, 0x00, 0x06, 0xCB, 0x0B, 0x13, 0x11, 0x8C, 0x09, 0x81, 0x84, 0x10,
    0x02, 0x40, 0x85, 0x14, 0x02, 0x40, 0x26, 0x02, 0x1F, 0x20, 0x8C, 0x09, 0x40, 0x1F, 0x00, 0x8C,
    0x09, 0x0F, 0x26, 0x90, 0x61, 0xCC, 0x10, 0x00, 0x78, 0x02, 0x13, 0x2B, 0x88, 0x02, 0x00, 0x8C,
    0x09, 0x11, 0x33, 0xCC, 0x01, 0x15, 0x06, 0x1C, 0x0D, 0x2F, 0x20, 0x03, 0x8C, 0x09, 0x14, 0x53,
    0x53, 0x08, 0x0F, 0x10, 0x42, 0x8C, 0x09, 0x5F, 0x43, 0x00, 0x07, 0x06, 0x23, 0xCC, 0x10, 0x07,
    0x43, 0x48, 0x48, 0x0E, 0x8C, 0x04, 0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F, 0xB0, 0x03, 0xFF, 0x09,
    0x1F, 0x99, 0xB0, 0x03, 0xFF, 0x5F, 0x01, 0xCC, 0x10, 0x03, 0xCF, 0x09, 0x0F, 0xB0, 0x03, 0x78,
    0x04, 0xCC, 0x10, 0x13, 0x3F, 0xB0, 0x03, 0x1F, 0x41, 0xB0, 0x03, 0x48, 0x0F, 0x90, 0x03, 0x0D,
    0x1F, 0x22, 0x40, 0x07, 0xFF, 0xFF, 0xF2, 0x1F, 0x01, 0x40, 0x07, 0x0D, 0x1F, 0xB0, 0x90, 0x03,
    0x37, 0x2F, 0x20, 0x00, 0x02, 0x00, 0x0A, 0x0F, 0xCC, 0x10, 0xBE, 0xF4, 0x01, 0x27, 0x00, 0x21,
    0x00, 0x28, 0x00, 0x21, 0x00, 0x26, 0x00, 0x23, 0x00, 0x2A, 0x00, 0x22, 0x00, 0x48, 0x03, 0x0C,
    0x18, 0x00, 0x0F, 0x01, 0x00, 0xFF, 0x36, 0x08, 0xCC, 0x10, 0x16, 0x07, 0x33, 0x14, 0x0F, 0xCC,
    0x10, 0xA2, 0x12, 0x0C, 0xF4, 0x0F, 0x05, 0xCC, 0x10, 0x13, 0x06, 0x9C, 0x10, 0x00, 0xC3, 0x05,
    0x13, 0x0F, 0x68, 0x05, 0x13, 0x02, 0x74, 0x05, 0x17, 0x0D, 0xCC, 0x10, 0x13, 0x0C, 0x84, 0x06,
    0x13, 0x0A, 0x50, 0x06, 0xBF, 0x00, 0x00, 0x06, 0x05, 0x0C, 0x08, 0x0D, 0x00, 0x19, 0x24, 0x6C,
    0xCC, 0x10, 0x1E, 0x13, 0xD0, 0xCC, 0x10, 0xF7, 0x06, 0x03, 0x12, 0x00, 0x00, 0x3D, 0x00, 0x80,
    0x00, 0x38, 0x00, 0x80, 0x00, 0x41, 0x00, 0x80, 0x00, 0x90, 0x00, 0x80, 0x00, 0x05, 0x08, 0x00,
    0x70, 0x49, 0x00, 0x34, 0x00, 0x80, 0x00, 0x80, 0xFA, 0x14, 0x62, 0x00, 0x16, 0x00, 0x08, 0x00,
    0x80, 0x06, 0x15, 0x23, 0x00, 0x19, 0x04, 0x00, 0x91, 0x18, 0x00, 0x80, 0x00, 0x95, 0x00, 0x80,
    0x00, 0x1D, 0x26, 0x00, 0x31, 0x00, 0x00, 0x2C, 0xDC, 0x00, 0x11, 0x80, 0x98, 0x06, 0x17, 0x08,
    0xCC, 0x10, 0x17, 0x09, 0xBC, 0x17, 0x1F, 0x00, 0xCC, 0x10, 0x10, 0x79, 0x56, 0x01, 0x55, 0x05,
    0x55, 0x05, 0x02, 0x0C, 0x00, 0x13, 0x01, 0xDC, 0x07, 0x00, 0x01, 0x00, 0x13, 0x2F, 0x08, 0x00,
    0x57, 0x54, 0x00, 0x01, 0x88, 0x2D, 0xCC, 0x10, 0x2F, 0x48, 0x48, 0xCC, 0x10, 0x1B, 0x1B, 0x35,
    0xCC, 0x10, 0x00, 0x50, 0x10, 0x00, 0x07, 0x00, 0x80, 0x9C, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00,
};

constexpr const u8 T210b01SdevEmcDvfsTableS1y8gbX03[0x680] = {
    0xFF, 0x18, 0x03, 0x00, 0x00, 0x00, 0x30, 0x31, 0x5F, 0x32, 0x30, 0x34, 0x30, 0x30, 0x30, 0x5F,
    0x4E, 0x6F, 0x43, 0x66, 0x67, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6F, 0x6E, 0x5F, 0x56, 0x30, 0x2E,
    0x34, 0x2E, 0x32, 0x5F, 0x56, 0x32, 0x2E, 0x30, 0x00, 0x01, 0x00, 0x06, 0x71, 0xE0, 0x1C, 0x03,
    0x00, 0x4C, 0x04, 0x00, 0x04, 0x00, 0x8F, 0x70, 0x6C, 0x6C, 0x70, 0x5F, 0x6F, 0x75, 0x74, 0x2F,
    0x00, 0x05, 0x5F, 0x02, 0x80, 0x18, 0x40, 0x00, 0x01, 0x00, 0x40, 0xFF, 0x1E, 0x3F, 0x3A, 0x00,
    0x00, 0x0D, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
    0x00, 0x8A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
    0x00, 0x04, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x05, 0x50, 0x00, 0x10, 0x17, 0x0A, 0x04,
    0x00, 0x22, 0x01, 0x00, 0x5C, 0x00, 0x57, 0x3A, 0x00, 0x00, 0x00, 0x1D, 0x24, 0x00, 0x13, 0x09,
    0x54, 0x00, 0x13, 0x0B, 0x20, 0x00, 0x13, 0x08, 0x0C, 0x00, 0x13, 0x00, 0x18, 0x00, 0x53, 0x17,
    0x00, 0x00, 0x00, 0x15, 0x08, 0x00, 0x13, 0x1B, 0x18, 0x00, 0x57, 0x20, 0x00, 0x00, 0x00, 0x06,
    0x04, 0x00, 0x13, 0x03, 0x18, 0x00, 0x13, 0x06, 0x34, 0x00, 0x17, 0x02, 0x40, 0x00, 0x00, 0x50,
    0x00, 0x13, 0x0E, 0x1C, 0x00, 0x08, 0xB4, 0x00, 0x00, 0x34, 0x00, 0x53, 0x31, 0x31, 0x03, 0x08,
    0x0C, 0x9C, 0x00, 0x40, 0x00, 0x00, 0x00, 0x80, 0x0A, 0x00, 0x13, 0x12, 0xE8, 0x00, 0x54, 0x1A,
    0x00, 0x00, 0x00, 0x16, 0xF4, 0x00, 0x03, 0x61, 0x00, 0x13, 0xC1, 0x50, 0x00, 0x13, 0x08, 0x40,
    0x00, 0x13, 0x0A, 0x08, 0x00, 0x04, 0x10, 0x01, 0x13, 0x02, 0xC4, 0x00, 0x13, 0x3B, 0x04, 0x00,
    0x13, 0x05, 0x04, 0x00, 0x04, 0x88, 0x00, 0x04, 0x0C, 0x00, 0x12, 0x09, 0x7C, 0x00, 0x23, 0x48,
    0x1C, 0x58, 0x00, 0x40, 0x0D, 0xA0, 0x60, 0x91, 0x7C, 0x01, 0x31, 0xA0, 0x00, 0x2C, 0x86, 0x00,
    0x11, 0x78, 0x16, 0x00, 0x2F, 0xFF, 0x0F, 0x56, 0x01, 0x03, 0xF1, 0x0C, 0x0B, 0x08, 0x16, 0x00,
    0x0D, 0x00, 0x0B, 0x00, 0x17, 0x00, 0x43, 0x00, 0x45, 0x00, 0x45, 0x00, 0x43, 0x00, 0x46, 0x00,
    0x47, 0x00, 0x41, 0x00, 0x46, 0x00, 0x0C, 0x8E, 0x00, 0x1F, 0x0D, 0x18, 0x00, 0x06, 0x20, 0x16,
    0x00, 0x3A, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x3E, 0x00, 0x11, 0x17, 0xE0, 0x00, 0x0F, 0x01, 0x00,
    0x8D, 0x80, 0x1F, 0x22, 0x20, 0x80, 0x0F, 0xF4, 0x20, 0x02, 0x98, 0x01, 0xF0, 0x0E, 0x00, 0x40,
    0x06, 0x00, 0xCC, 0x00, 0x09, 0x00, 0x10, 0x00, 0xCC, 0x00, 0x0A, 0x00, 0x33, 0x00, 0x02, 0x03,
    0xE0, 0xC1, 0x20, 0x41, 0x13, 0x1F, 0x14, 0x00, 0x01, 0x00, 0x99, 0x5C, 0x01, 0x60, 0x08, 0x00,
    0x00, 0x50, 0x50, 0x50, 0x22, 0x02, 0x10, 0xF3, 0x40, 0x01, 0x22, 0x13, 0x07, 0xA4, 0x01, 0x04,
    0x4C, 0x00, 0x13, 0x12, 0x04, 0x00, 0x02, 0x00, 0x02, 0x11, 0x05, 0x9F, 0x01, 0x23, 0x10, 0x02,
    0x51, 0x02, 0x00, 0xE4, 0x02, 0x13, 0x04, 0x92, 0x02, 0x2F, 0x34, 0x10, 0x90, 0x00, 0x06, 0x03,
    0x79, 0x03, 0x0E, 0x21, 0x00, 0x15, 0x10, 0x47, 0x00, 0x0F, 0xC9, 0x00, 0x03, 0x34, 0xEF, 0x00,
    0xEF, 0x0B, 0x00, 0x49, 0x1C, 0x1C, 0x1C, 0x1C, 0x3B, 0x00, 0x12, 0x10, 0x04, 0x00, 0x44, 0x33,
    0x60, 0x18, 0x01, 0x14, 0x00, 0x13, 0x18, 0x60, 0x02, 0x00, 0x88, 0x02, 0x42, 0x14, 0x14, 0x16,
    0x08, 0xB8, 0x00, 0xF0, 0x07, 0x01, 0x00, 0x80, 0x90, 0x00, 0x00, 0x04, 0x04, 0x07, 0x07, 0x65,
    0x00, 0x04, 0x00, 0x1F, 0x80, 0x13, 0x05, 0x00, 0x11, 0x10, 0x1F, 0x80, 0x02, 0xF0, 0x0F, 0x40,
    0x72, 0x10, 0x00, 0x00, 0x40, 0x12, 0x01, 0x6A, 0x5B, 0x12, 0x01, 0x00, 0x10, 0x08, 0x0F, 0x00,
    0x58, 0x10, 0x00, 0x00, 0xFC, 0x10, 0x11, 0x00, 0x13, 0x08, 0x0F, 0x50, 0x7C, 0x0C, 0x00, 0xF3,
    0x07, 0x14, 0x11, 0x00, 0x03, 0x00, 0x07, 0x4C, 0x72, 0x10, 0x00, 0x5A, 0x3C, 0x55, 0x55, 0x14,
    0x14, 0x16, 0x48, 0x5D, 0x5D, 0x0C, 0x88, 0x04, 0x00, 0x12, 0x48, 0x04, 0x00, 0x23, 0x0E, 0x8C,
    0x04, 0x00, 0x10, 0x4C, 0x04, 0x00, 0x0F, 0xB0, 0x03, 0xFF, 0x09, 0x1F, 0x99, 0xB0, 0x03, 0xFF,
    0x5E, 0x70, 0x00, 0x80, 0x06, 0x06, 0x00, 0x00, 0x05, 0x17, 0x02, 0x0F, 0xB0, 0x03, 0x7A, 0x00,
    0x8C, 0x02, 0x10, 0x1F, 0x24, 0x00, 0x03, 0x34, 0x02, 0x13, 0x1E, 0xB0, 0x03, 0x15, 0x10, 0xB0,
    0x03, 0x1F, 0x01, 0xB0, 0x03, 0x36, 0x0F, 0x90, 0x03, 0x09, 0x13, 0x0E, 0x04, 0x00, 0x0F, 0x90,
    0x03, 0x21, 0x00, 0x64, 0x01, 0x1F, 0x13, 0x90, 0x03, 0x17, 0x00, 0x33, 0x05, 0x1F, 0x30, 0x90,
    0x03, 0x03, 0x1F, 0x04, 0x40, 0x07, 0xFF, 0xFF, 0x70, 0x1F, 0x01, 0x40, 0x07, 0x0A, 0x4F, 0x04,
    0x00, 0x80, 0xB0, 0x40, 0x07, 0x37, 0x2F, 0x28, 0x00, 0x02, 0x00, 0x0B, 0x0F, 0x01, 0x00, 0xAD,
    0x1B, 0x29, 0x01, 0x00, 0x0C, 0x20, 0x00, 0x04, 0x48, 0x03, 0x0F, 0x01, 0x00, 0xFF, 0x16, 0x39,
    0x49, 0x92, 0x24, 0x04, 0x00, 0x0F, 0x01, 0x00, 0x0D, 0x00, 0xB4, 0x02, 0x40, 0x04, 0x01, 0x00,
    0x00, 0x16, 0x0A, 0x13, 0x18, 0x84, 0x05, 0x0D, 0x50, 0x03, 0x5A, 0x42, 0x0F, 0x00, 0x60, 0x09,
    0x14, 0x00, 0x1E, 0x01, 0x0C, 0x00, 0x0F, 0xFC, 0x00, 0x6E, 0xF7, 0x02, 0x01, 0x00, 0x00, 0x08,
    0x4C, 0x00, 0x00, 0x80, 0x20, 0x10, 0x0A, 0x00, 0x28, 0x10, 0x00, 0x80, 0x01, 0xD8, 0x09, 0x17,
    0x01, 0x04, 0x00, 0x17, 0x02, 0x0C, 0x06, 0x1B, 0x01, 0xFC, 0x05, 0x11, 0x07, 0x14, 0x00, 0xE3,
    0x02, 0x02, 0x01, 0x02, 0x03, 0x00, 0x04, 0x05, 0xA3, 0x72, 0x0F, 0x0F, 0x00, 0x70, 0xE6, 0x04,
    0x4F, 0x00, 0x1A, 0x00, 0x80, 0x04, 0x00, 0x0E, 0x11, 0x1B, 0x10, 0x04, 0xF1, 0x02, 0x80, 0x00,
    0x4C, 0x02, 0x00, 0x00, 0xB2, 0x00, 0xFF, 0x00, 0xDA, 0x00, 0xFF, 0x00, 0x9D, 0x00, 0xFF, 0x02,
    0x00, 0x17, 0x0C, 0x08, 0x00, 0xF1, 0x02, 0x49, 0x00, 0x7F, 0x00, 0x80, 0x00, 0xFF, 0x00, 0x04,
    0x00, 0xFF, 0x00, 0xAD, 0x00, 0x08, 0x00, 0xFF, 0x88, 0x00, 0x33, 0xFF, 0x00, 0xC6, 0x04, 0x00,
    0x13, 0x6D, 0x2C, 0x00, 0x11, 0xE2, 0x06, 0x00, 0x01, 0x73, 0x06, 0x01, 0x0A, 0x00, 0x13, 0x14,
    0xC0, 0x06, 0x2E, 0xF4, 0x01, 0x78, 0x01, 0x13, 0x08, 0x44, 0x0F, 0x0F, 0x23, 0x01, 0x08, 0x1F,
    0xC0, 0x0C, 0x00, 0x04, 0x08, 0x23, 0x05, 0x03, 0xC6, 0x04, 0x90, 0x01, 0x08, 0x00, 0x00, 0x02,
    0x08, 0x00, 0x00, 0x0D, 0x57, 0x00, 0x58, 0xC0, 0x5D, 0x5D, 0x0E, 0x0C, 0x28, 0x00, 0xC0, 0xD8,
    0x51, 0x1A, 0xA0, 0x00, 0x00, 0x50, 0x05, 0x00, 0x00, 0x88, 0x00, 0x04, 0x00, 0x11, 0x20, 0xFD,
    0x04, 0x15, 0x88, 0x04, 0x00, 0x50, 0x25, 0x08, 0x11, 0x00, 0x0C, 0x46, 0x00, 0x07, 0x50, 0x10,
    0x00, 0x0C, 0x00, 0x26, 0x5C, 0x0D, 0x94, 0x01, 0x7F, 0x30, 0x31, 0x5F, 0x31, 0x36, 0x30, 0x30,
    0xCD, 0x10, 0x23, 0x28, 0x6A, 0x18, 0xCC, 0x10, 0x4F, 0x6D, 0x5F, 0x75, 0x64, 0x2C, 0x00, 0x07,
    0x21, 0x80, 0x18, 0x0C, 0x02, 0x2F, 0xF0, 0x02, 0xB4, 0x02, 0x3B, 0x22, 0xFF, 0x3B, 0x6C, 0x06,
    0x0F, 0xCC, 0x10, 0x45, 0x10, 0x60, 0x79, 0x01, 0x47, 0x01, 0x00, 0x00, 0xE0, 0x24, 0x00, 0x13,
    0x44, 0x9C, 0x09, 0x13, 0x29, 0x64, 0x00, 0x00, 0x95, 0x01, 0x17, 0x2D, 0x4C, 0x09, 0x00, 0xBC,
    0x09, 0x97, 0x23, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x41, 0x8C, 0x09, 0x13, 0x1D, 0x04,
    0x00, 0x13, 0x0C, 0xA8, 0x09, 0x13, 0x16, 0xEC, 0x03, 0x13, 0x0E, 0x14, 0x00, 0x17, 0x0A, 0xDC,
    0x09, 0x00, 0x08, 0x00, 0x13, 0x24, 0x0C, 0x00, 0x12, 0x1C, 0x8C, 0x09, 0x10, 0x10, 0xC4, 0x00,
    0x57, 0xF1, 0xF1, 0x03, 0x08, 0x1C, 0x8C, 0x09, 0x93, 0x0C, 0x00, 0x06, 0x00, 0x33, 0x00, 0x00,
    0x00, 0x39, 0x4C, 0x09, 0x13, 0x37, 0x0C, 0x00, 0x23, 0x20, 0x18, 0x90, 0x02, 0x12, 0x06, 0x50,
    0x02, 0x13, 0x10, 0xF0, 0x01, 0x13, 0x17, 0x08, 0x00, 0x13, 0x38, 0x64, 0x00, 0x00, 0x8F, 0x01,
    0x62, 0x2E, 0x00, 0x00, 0x00, 0xCC, 0x01, 0x04, 0x00, 0x13, 0x0D, 0x34, 0x01, 0x00, 0x90, 0x00,
    0x00, 0xFA, 0x01, 0x17, 0x22, 0x40, 0x01, 0x66, 0xF1, 0xF1, 0x03, 0x48, 0x60, 0x18, 0x8C, 0x09,
    0x00, 0x7C, 0x01, 0x4F, 0xBB, 0x01, 0x00, 0xC0, 0x8C, 0x09, 0x0D, 0xB5, 0x06, 0x06, 0x0B, 0x08,
    0x0D, 0x00, 0x08, 0x00, 0x06, 0x00, 0x0E, 0x60, 0x0A, 0x13, 0x03, 0xC0, 0x0A, 0x11, 0x07, 0x82,
    0x00, 0x1F, 0x08, 0x18, 0x00, 0x06, 0x00, 0x88, 0x09, 0x11, 0x08, 0x20, 0x00, 0x00, 0x3E, 0x00,
    0x3F, 0x0E, 0x00, 0x0D, 0x8C, 0x09, 0xA0, 0xD0, 0x40, 0x06, 0x31, 0x00, 0x2F, 0x00, 0x40, 0x06,
    0x17, 0x00, 0x90, 0x01, 0x09, 0x8C, 0x09, 0x12, 0x61, 0x8C, 0x09, 0x22, 0xB0, 0x04, 0xDA, 0x03,
    0x08, 0x8C, 0x09, 0x5F, 0x8C, 0x30, 0x00, 0x00, 0x2B, 0x1C, 0x0D, 0x05, 0x21, 0x00, 0x06, 0xCB,
    0x0B, 0x13, 0x11, 0x8C, 0x09, 0x81, 0x84, 0x10, 0x02, 0x40, 0x85, 0x14, 0x02, 0x40, 0x8C, 0x09,
    0x1F, 0x20, 0x8C, 0x09, 0x40, 0x1F, 0x00, 0x8C, 0x09, 0x0F, 0x26, 0x90, 0x61, 0xCC, 0x10, 0x00,
    0x78, 0x02, 0x13, 0x2B, 0x88, 0x02, 0x00, 0x8C, 0x09, 0x11, 0x33, 0x48, 0x02, 0x15, 0x06, 0xCC,
    0x10, 0x2F, 0x20, 0x03, 0x8C, 0x09, 0x14, 0x53, 0x53, 0x08, 0x0F, 0x10, 0x42, 0x8C, 0x09, 0x5F,
    0x43, 0x00, 0x07, 0x06, 0x23, 0xCC, 0x10, 0x07, 0x43, 0x48, 0x48, 0x0E, 0x8C, 0x04, 0x00, 0x10,
    0x4C, 0x04, 0x00, 0x0F, 0xB0, 0x03, 0xFF, 0x09, 0x1F, 0x99, 0xB0, 0x03, 0xFF, 0x5F, 0x01, 0xCC,
    0x10, 0x03, 0xCF, 0x09, 0x0F, 0xB0, 0x03, 0x78, 0x04, 0xCC, 0x10, 0x13, 0x3F, 0xB0, 0x03, 0x1D,
    0x41, 0xB0, 0x03, 0x1F, 0x01, 0xB0, 0x03, 0x36, 0x0F, 0x90, 0x03, 0x0D, 0x1F, 0x22, 0x40, 0x07,
    0xFF, 0xFF, 0xF2, 0x1F, 0x01, 0x40, 0x07, 0x0D, 0x1F, 0xB0, 0x40, 0x07, 0x37, 0x2F, 0x20, 0x00,
    0x02, 0x00, 0x0A, 0x0F, 0xCC, 0x10, 0xBE, 0xF4, 0x01, 0x27, 0x00, 0x21, 0x00, 0x27, 0x00, 0x20,
    0x00, 0x26, 0x00, 0x23, 0x00, 0x2A, 0x00, 0x22, 0x00, 0x48, 0x03, 0x0C, 0x18, 0x00, 0x0F, 0x01,
    0x00, 0xFF, 0x36, 0x08, 0xCC, 0x10, 0x00, 0xC8, 0x0F, 0x1F, 0x20, 0xCC, 0x10, 0xA8, 0x12, 0x0C,
    0xF4, 0x0F, 0x05, 0xCC, 0x10, 0x13, 0x06, 0x9C, 0x10, 0x00, 0xC3, 0x05, 0x13, 0x0F, 0x68, 0x05,
    0x13, 0x02, 0x74, 0x05, 0x13, 0x0D, 0x1C, 0x00, 0x13, 0x07, 0x38, 0x00, 0x13, 0x08, 0x90, 0x06,
    0x00, 0x50, 0x06, 0xBF, 0x03, 0x03, 0x06, 0x05, 0x0C, 0x08, 0x0D, 0x00, 0x19, 0x24, 0x6C, 0xCC,
    0x10, 0x1E, 0x13, 0xD0, 0xCC, 0x10, 0xF7, 0x06, 0x03, 0x12, 0x00, 0x00, 0x3D, 0x00, 0x80, 0x00,
    0x38, 0x00, 0x80, 0x00, 0x41, 0x00, 0x80, 0x00, 0x90, 0x00, 0x80, 0x00, 0x05, 0x08, 0x00, 0x70,
    0x49, 0x00, 0x34, 0x00, 0x80, 0x00, 0x80, 0xFA, 0x14, 0x62, 0x00, 0x16, 0x00, 0x08, 0x00, 0x80,
    0x06, 0x15, 0x23, 0x00, 0x19, 0x04, 0x00, 0x91, 0x18, 0x00, 0x80, 0x00, 0x95, 0x00, 0x80, 0x00,
    0x1D, 0x26, 0x00, 0x31, 0x00, 0x00, 0x2C, 0xDC, 0x00, 0x11, 0x80, 0x98, 0x06, 0x17, 0x08, 0xCC,
    0x10, 0x17, 0x09, 0xBC, 0x17, 0x1F, 0x00, 0xCC, 0x10, 0x10, 0x79, 0x56, 0x01, 0x55, 0x05, 0x55,
    0x05, 0x02, 0x0C, 0x00, 0x13, 0x01, 0xDC, 0x07, 0x00, 0x01, 0x00, 0x13, 0x2F, 0x08, 0x00, 0x57,
    0x54, 0x00, 0x01, 0x08, 0x2D, 0xCC, 0x10, 0x2F, 0x48, 0x48, 0xCC, 0x10, 0x1B, 0x1B, 0x35, 0xCC,
    0x10, 0x00, 0x50, 0x10, 0x00, 0x07, 0x00, 0x80, 0x9C, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

