/*
 * Copyright (c) Atmosphère-NX
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

constexpr inline const u8 SdramParamsErista0_1[0x3CA] = {
    0xFF, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x2C, 0x01,
    0x00, 0x01, 0x00, 0x0E, 0xFC, 0x05, 0x68, 0xBC, 0x01, 0x70, 0x0A, 0x00, 0x00, 0x00, 0x04, 0xB4,
    0x01, 0x70, 0x01, 0x32, 0x54, 0x76, 0xC8, 0xE6, 0x00, 0x70, 0x24, 0x00, 0xC8, 0x34, 0x00, 0x00,
    0x00, 0x02, 0x80, 0x18, 0x40, 0x00, 0x00, 0x00, 0x40, 0x18, 0x00, 0xFF, 0x01, 0xFF, 0xFF, 0x1F,
    0x00, 0xD8, 0x51, 0x1A, 0xA0, 0x00, 0x00, 0x50, 0x05, 0x00, 0x00, 0x77, 0x00, 0x04, 0x00, 0x01,
    0xD3, 0xA6, 0xA6, 0xAF, 0xB3, 0x3C, 0x9E, 0x00, 0x00, 0x03, 0x03, 0xE0, 0xC1, 0x04, 0x01, 0x00,
    0x00, 0x3C, 0x00, 0x19, 0x1F, 0x01, 0x00, 0x42, 0x00, 0x00, 0x04, 0x08, 0x46, 0x00, 0x57, 0xA1,
    0x01, 0x00, 0x00, 0x32, 0x64, 0x00, 0x00, 0xC3, 0x00, 0x13, 0x02, 0x0C, 0x00, 0x13, 0x03, 0x04,
    0x00, 0xD7, 0x1E, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x13, 0x2C,
    0x00, 0x10, 0x09, 0xC8, 0x00, 0x07, 0x10, 0x00, 0x13, 0x0B, 0x28, 0x00, 0x13, 0x08, 0x0C, 0x00,
    0x00, 0x1C, 0x00, 0x57, 0x20, 0x00, 0x00, 0x00, 0x06, 0x04, 0x00, 0x13, 0x03, 0x2C, 0x00, 0x13,
    0x04, 0x10, 0x00, 0x17, 0x02, 0x10, 0x00, 0x13, 0x08, 0x40, 0x00, 0x13, 0x05, 0x1C, 0x00, 0x04,
    0x58, 0x00, 0x13, 0x02, 0x18, 0x00, 0x04, 0x64, 0x00, 0x00, 0xA6, 0x00, 0xB5, 0x12, 0x00, 0x00,
    0x00, 0x14, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x0C, 0x00, 0x01, 0x58, 0x01, 0x03, 0x61, 0x00,
    0x13, 0xC1, 0x50, 0x00, 0x17, 0x08, 0xC8, 0x00, 0x13, 0x03, 0x28, 0x00, 0x17, 0x05, 0x54, 0x00,
    0x13, 0x27, 0x04, 0x00, 0x13, 0x05, 0x04, 0x00, 0x13, 0x04, 0xD8, 0x00, 0x08, 0x0C, 0x00, 0xA0,
    0x1C, 0x03, 0x00, 0x00, 0x0D, 0xA0, 0x60, 0x91, 0xBF, 0x3B, 0x5A, 0x00, 0xF1, 0x28, 0xF3, 0x0C,
    0x04, 0x05, 0x1B, 0x06, 0x02, 0x03, 0x07, 0x1C, 0x23, 0x25, 0x25, 0x05, 0x08, 0x1D, 0x09, 0x0A,
    0x24, 0x0B, 0x1E, 0x0D, 0x0C, 0x26, 0x26, 0x03, 0x02, 0x1B, 0x1C, 0x23, 0x03, 0x04, 0x07, 0x05,
    0x06, 0x25, 0x25, 0x02, 0x0A, 0x0B, 0x1D, 0x0D, 0x08, 0x0C, 0x09, 0x1E, 0x24, 0x26, 0x26, 0x08,
    0x24, 0x06, 0x07, 0x9A, 0x12, 0xC1, 0x01, 0x2C, 0x00, 0xFF, 0xEC, 0x01, 0xB0, 0x04, 0x00, 0x01,
    0x08, 0x00, 0x00, 0x02, 0x08, 0x00, 0x00, 0x0D, 0xAB, 0x00, 0xD0, 0xC0, 0x71, 0x71, 0x03, 0x08,
    0x00, 0x00, 0x0B, 0x08, 0x72, 0x72, 0x0E, 0x0C, 0x20, 0x00, 0xC2, 0x08, 0x08, 0x0D, 0x0C, 0x00,
    0x00, 0x0D, 0x0C, 0x14, 0x14, 0x16, 0x08, 0x2C, 0x00, 0x2C, 0x11, 0x08, 0x67, 0x02, 0x70, 0x15,
    0x00, 0xCC, 0x00, 0x0A, 0x00, 0x33, 0x6E, 0x01, 0x94, 0xF3, 0x05, 0x08, 0x11, 0x00, 0xFF, 0x0F,
    0xFF, 0x0F, 0xCC, 0x01, 0x80, 0x01, 0x03, 0x00, 0x70, 0x00, 0x0C, 0x00, 0x01, 0x0C, 0x00, 0xC0,
    0x08, 0x44, 0x00, 0x10, 0x04, 0x04, 0x00, 0x06, 0x13, 0x07, 0x00, 0x80, 0x10, 0x00, 0xA2, 0xA0,
    0x00, 0x2C, 0x00, 0x01, 0x37, 0x00, 0x00, 0x00, 0x80, 0x48, 0x00, 0xD3, 0x08, 0x00, 0x04, 0x00,
    0x1F, 0x22, 0x20, 0x80, 0x0F, 0xF4, 0x20, 0x02, 0x28, 0x01, 0x00, 0x13, 0x11, 0x01, 0x00, 0x10,
    0xBE, 0xBF, 0x00, 0x12, 0x0F, 0x02, 0x00, 0x1F, 0x00, 0x01, 0x00, 0x2C, 0x7F, 0x14, 0x00, 0x12,
    0x00, 0x10, 0x00, 0x14, 0x18, 0x00, 0x06, 0xF3, 0x02, 0x30, 0x00, 0x2E, 0x00, 0x33, 0x00, 0x30,
    0x00, 0x33, 0x00, 0x35, 0x00, 0x30, 0x00, 0x32, 0x00, 0x05, 0x20, 0x00, 0x0F, 0x18, 0x00, 0x05,
    0x1F, 0x28, 0x02, 0x00, 0x0C, 0x11, 0x14, 0x5A, 0x00, 0x00, 0x5C, 0x00, 0x11, 0x10, 0x0C, 0x00,
    0x0C, 0x7A, 0x00, 0x05, 0x50, 0x01, 0xA4, 0x40, 0x06, 0x00, 0xCC, 0x00, 0x09, 0x00, 0x4F, 0x00,
    0x51, 0x18, 0x00, 0x00, 0x28, 0x01, 0x23, 0x40, 0x01, 0x3C, 0x02, 0x54, 0xAB, 0x00, 0x0A, 0x04,
    0x11, 0x58, 0x01, 0x03, 0x04, 0x00, 0x0F, 0xEC, 0x00, 0x0D, 0x17, 0x02, 0x0C, 0x00, 0x17, 0x03,
    0x60, 0x03, 0x02, 0xA1, 0x01, 0x68, 0x22, 0x04, 0xFF, 0xFF, 0xAF, 0x4F, 0x74, 0x03, 0x04, 0x38,
    0x00, 0x32, 0x8B, 0xFF, 0x07, 0x84, 0x00, 0xF0, 0x10, 0x32, 0x54, 0x76, 0x10, 0x47, 0x32, 0x65,
    0x10, 0x34, 0x76, 0x25, 0x01, 0x34, 0x67, 0x25, 0x01, 0x75, 0x64, 0x32, 0x01, 0x72, 0x56, 0x34,
    0x10, 0x23, 0x74, 0x56, 0x01, 0x45, 0x32, 0x67, 0x24, 0x00, 0x31, 0x49, 0x92, 0x24, 0x04, 0x00,
    0x0C, 0x01, 0x00, 0x13, 0x1B, 0x04, 0x00, 0x0C, 0x94, 0x00, 0x80, 0x2F, 0x41, 0x13, 0x1F, 0x14,
    0x00, 0x01, 0x00, 0x7C, 0x00, 0x80, 0xFF, 0xFF, 0xFF, 0x7F, 0x0B, 0xD7, 0x06, 0x40, 0x82, 0x00,
    0xB2, 0x08, 0x08, 0x03, 0x00, 0x00, 0x5C, 0x01, 0x00, 0x10, 0x10, 0x10, 0x59, 0x03, 0x0B, 0x94,
    0x04, 0x13, 0x37, 0x72, 0x01, 0x12, 0x10, 0x8D, 0x01, 0x31, 0x00, 0x11, 0x01, 0xB9, 0x02, 0x00,
    0x1F, 0x00, 0x13, 0x0A, 0xA9, 0x04, 0x17, 0x10, 0x77, 0x03, 0x05, 0x12, 0x00, 0x00, 0x04, 0x04,
    0xCF, 0x81, 0x10, 0x09, 0x28, 0x93, 0x32, 0xA5, 0x44, 0x5B, 0x8A, 0x67, 0x76, 0x2C, 0x01, 0x05,
    0x53, 0xFF, 0xEF, 0xFF, 0xEF, 0xC0, 0x01, 0x00, 0x57, 0xDC, 0xDC, 0xDC, 0xDC, 0x0A, 0x01, 0x00,
    0x01, 0x24, 0x01, 0x21, 0x03, 0x07, 0x04, 0x00, 0xF1, 0x03, 0x00, 0x24, 0xFF, 0xFF, 0x00, 0x44,
    0x57, 0x6E, 0x00, 0x28, 0x72, 0x39, 0x00, 0x10, 0x9C, 0x4B, 0x00, 0x10, 0x58, 0x01, 0xB2, 0x08,
    0x4C, 0x00, 0x00, 0x80, 0x20, 0x10, 0x0A, 0x00, 0x28, 0x10, 0xE0, 0x02, 0x0C, 0x74, 0x01, 0x04,
    0x08, 0x00, 0x17, 0x05, 0x10, 0x00, 0x17, 0x04, 0xEC, 0x03, 0xE4, 0x01, 0x00, 0x02, 0x02, 0x01,
    0x02, 0x03, 0x00, 0x04, 0x05, 0xC3, 0x71, 0x0F, 0x0F, 0x98, 0x05, 0x15, 0x1F, 0xF3, 0x00, 0x00,
    0xC0, 0x03, 0x14, 0x01, 0xDD, 0x00, 0x14, 0x80, 0xB6, 0x00, 0x15, 0xF0, 0xD4, 0x03, 0x68, 0x43,
    0xC3, 0xBA, 0xE4, 0xD3, 0x1E, 0xD2, 0x00, 0x2F, 0xF0, 0xFF, 0xEC, 0x00, 0x05, 0x19, 0x08, 0x0E,
    0x00, 0x14, 0x30, 0xAB, 0x00, 0x0F, 0x2C, 0x00, 0x02, 0x4F, 0x76, 0x0C, 0x00, 0x04, 0x50, 0x02,
    0x01, 0x05, 0x34, 0x00, 0x0F, 0x3A, 0x00, 0x04, 0x38, 0x7E, 0x16, 0x40, 0x9F, 0x05, 0x0F, 0x38,
    0x00, 0x17, 0x3F, 0x1E, 0x40, 0x04, 0xA8, 0x00, 0x08, 0x2F, 0x00, 0xC0, 0x55, 0x00, 0x04, 0x3F,
    0x46, 0x24, 0x00, 0x38, 0x00, 0x0A, 0x0F, 0x01, 0x00, 0x05, 0x22, 0x46, 0x2C, 0x38, 0x00, 0x2F,
    0xEC, 0x00, 0x3C, 0x01, 0x07, 0x0F, 0x68, 0x07, 0xF9, 0x1F, 0x0D, 0x68, 0x07, 0x4C, 0x03, 0x5F,
    0x01, 0x1F, 0x80, 0x68, 0x07, 0xFF, 0xFF, 0xFF, 0x71, 0x1F, 0x02, 0x68, 0x07, 0xB7, 0x1F, 0x05,
    0x68, 0x07, 0xFF, 0x90, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
};

constexpr inline const u8 * const SdramParamsErista0 = SdramParamsErista0_1;
constexpr inline const size_t SdramParamsSizeErista0 = sizeof(SdramParamsErista0_1);

constexpr inline const u8 * const SdramParamsErista1 = SdramParamsErista0_1;
constexpr inline const size_t SdramParamsSizeErista1 = sizeof(SdramParamsErista0_1);

constexpr inline const u8 SdramParamsErista2_3[0x3C6] = {
    0xFF, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x2C, 0x01,
    0x00, 0x01, 0x00, 0x0E, 0xFC, 0x05, 0x68, 0xBC, 0x01, 0x70, 0x0A, 0x00, 0x00, 0x00, 0x04, 0xB4,
    0x01, 0x70, 0x01, 0x32, 0x54, 0x76, 0xC8, 0xE6, 0x00, 0x70, 0x24, 0x00, 0xC8, 0x34, 0x00, 0x00,
    0x00, 0x02, 0x80, 0x18, 0x40, 0x00, 0x00, 0x00, 0x40, 0x18, 0x00, 0xFF, 0x01, 0xFF, 0xFF, 0x1F,
    0x00, 0xD8, 0x51, 0x1A, 0xA0, 0x00, 0x00, 0x50, 0x05, 0x00, 0x00, 0x77, 0x00, 0x04, 0x00, 0x01,
    0xD3, 0xA6, 0xA6, 0xAF, 0xB3, 0x3C, 0x9E, 0x00, 0x00, 0x03, 0x03, 0xE0, 0xC1, 0x04, 0x01, 0x00,
    0x00, 0x3C, 0x00, 0x19, 0x1F, 0x01, 0x00, 0x42, 0x00, 0x00, 0x04, 0x08, 0x46, 0x00, 0x57, 0xA1,
    0x01, 0x00, 0x00, 0x32, 0x64, 0x00, 0x00, 0xC3, 0x00, 0x13, 0x02, 0x0C, 0x00, 0x13, 0x03, 0x04,
    0x00, 0xD7, 0x1E, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x13, 0x2C,
    0x00, 0x10, 0x09, 0xC8, 0x00, 0x07, 0x10, 0x00, 0x13, 0x0B, 0x28, 0x00, 0x13, 0x08, 0x0C, 0x00,
    0x00, 0x1C, 0x00, 0x57, 0x20, 0x00, 0x00, 0x00, 0x06, 0x04, 0x00, 0x13, 0x03, 0x2C, 0x00, 0x13,
    0x04, 0x10, 0x00, 0x17, 0x02, 0x10, 0x00, 0x13, 0x08, 0x40, 0x00, 0x13, 0x05, 0x1C, 0x00, 0x04,
    0x58, 0x00, 0x13, 0x02, 0x18, 0x00, 0x04, 0x64, 0x00, 0x00, 0xA6, 0x00, 0xB5, 0x12, 0x00, 0x00,
    0x00, 0x14, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x0C, 0x00, 0x01, 0x58, 0x01, 0x03, 0x61, 0x00,
    0x13, 0xC1, 0x50, 0x00, 0x17, 0x08, 0xC8, 0x00, 0x13, 0x03, 0x28, 0x00, 0x17, 0x05, 0x54, 0x00,
    0x13, 0x27, 0x04, 0x00, 0x13, 0x05, 0x04, 0x00, 0x13, 0x04, 0xD8, 0x00, 0x08, 0x0C, 0x00, 0xA0,
    0x1C, 0x03, 0x00, 0x00, 0x0D, 0xA0, 0x60, 0x91, 0xBF, 0x3B, 0x5A, 0x00, 0xF1, 0x28, 0xF3, 0x0C,
    0x04, 0x05, 0x1B, 0x06, 0x02, 0x03, 0x07, 0x1C, 0x23, 0x25, 0x25, 0x05, 0x08, 0x1D, 0x09, 0x0A,
    0x24, 0x0B, 0x1E, 0x0D, 0x0C, 0x26, 0x26, 0x03, 0x02, 0x1B, 0x1C, 0x23, 0x03, 0x04, 0x07, 0x05,
    0x06, 0x25, 0x25, 0x02, 0x0A, 0x0B, 0x1D, 0x0D, 0x08, 0x0C, 0x09, 0x1E, 0x24, 0x26, 0x26, 0x08,
    0x24, 0x06, 0x07, 0x9A, 0x12, 0xC1, 0x01, 0x2C, 0x00, 0xFF, 0xEC, 0x01, 0xB0, 0x04, 0x00, 0x01,
    0x08, 0x00, 0x00, 0x02, 0x08, 0x00, 0x00, 0x0D, 0xAB, 0x00, 0xD0, 0xC0, 0x71, 0x71, 0x03, 0x08,
    0x00, 0x00, 0x0B, 0x08, 0x72, 0x72, 0x0E, 0x0C, 0x20, 0x00, 0xC2, 0x08, 0x08, 0x0D, 0x0C, 0x00,
    0x00, 0x0D, 0x0C, 0x14, 0x14, 0x16, 0x08, 0x2C, 0x00, 0x2C, 0x11, 0x08, 0x67, 0x02, 0x70, 0x15,
    0x00, 0xCC, 0x00, 0x0A, 0x00, 0x33, 0x6E, 0x01, 0x94, 0xF3, 0x05, 0x08, 0x11, 0x00, 0xFF, 0x0F,
    0xFF, 0x0F, 0xCC, 0x01, 0x80, 0x01, 0x03, 0x00, 0x70, 0x00, 0x0C, 0x00, 0x01, 0x0C, 0x00, 0xC0,
    0x08, 0x44, 0x00, 0x10, 0x04, 0x04, 0x00, 0x06, 0x13, 0x07, 0x00, 0x80, 0x10, 0x00, 0xA2, 0xA0,
    0x00, 0x2C, 0x00, 0x01, 0x37, 0x00, 0x00, 0x00, 0x80, 0x48, 0x00, 0xD3, 0x08, 0x00, 0x04, 0x00,
    0x1F, 0x22, 0x20, 0x80, 0x0F, 0xF4, 0x20, 0x02, 0x28, 0x01, 0x00, 0x13, 0x11, 0x01, 0x00, 0x10,
    0xBE, 0xBF, 0x00, 0x12, 0x0F, 0x02, 0x00, 0x1F, 0x00, 0x01, 0x00, 0x2C, 0x7F, 0x14, 0x00, 0x12,
    0x00, 0x10, 0x00, 0x14, 0x18, 0x00, 0x06, 0xF3, 0x02, 0x30, 0x00, 0x2E, 0x00, 0x33, 0x00, 0x30,
    0x00, 0x33, 0x00, 0x35, 0x00, 0x30, 0x00, 0x32, 0x00, 0x05, 0x20, 0x00, 0x0F, 0x18, 0x00, 0x05,
    0x1F, 0x28, 0x02, 0x00, 0x0C, 0x11, 0x14, 0x5A, 0x00, 0x00, 0x5C, 0x00, 0x11, 0x10, 0x0C, 0x00,
    0x0C, 0x7A, 0x00, 0x05, 0x50, 0x01, 0xA4, 0x40, 0x06, 0x00, 0xCC, 0x00, 0x09, 0x00, 0x4F, 0x00,
    0x51, 0x18, 0x00, 0x00, 0x28, 0x01, 0x23, 0x40, 0x01, 0x3C, 0x02, 0x54, 0xAB, 0x00, 0x0A, 0x04,
    0x11, 0x58, 0x01, 0x03, 0x04, 0x00, 0x0F, 0xEC, 0x00, 0x0D, 0x17, 0x02, 0x0C, 0x00, 0x17, 0x03,
    0x60, 0x03, 0x02, 0xA1, 0x01, 0x68, 0x22, 0x04, 0xFF, 0xFF, 0xAF, 0x4F, 0x74, 0x03, 0x04, 0x38,
    0x00, 0x32, 0x8B, 0xFF, 0x07, 0x84, 0x00, 0xF0, 0x10, 0x32, 0x54, 0x76, 0x10, 0x47, 0x32, 0x65,
    0x10, 0x34, 0x76, 0x25, 0x01, 0x34, 0x67, 0x25, 0x01, 0x75, 0x64, 0x32, 0x01, 0x72, 0x56, 0x34,
    0x10, 0x23, 0x74, 0x56, 0x01, 0x45, 0x32, 0x67, 0x24, 0x00, 0x31, 0x49, 0x92, 0x24, 0x04, 0x00,
    0x0C, 0x01, 0x00, 0x13, 0x1B, 0x04, 0x00, 0x0C, 0x94, 0x00, 0x80, 0x2F, 0x41, 0x13, 0x1F, 0x14,
    0x00, 0x01, 0x00, 0x7C, 0x00, 0x80, 0xFF, 0xFF, 0xFF, 0x7F, 0x0B, 0xD7, 0x06, 0x40, 0x82, 0x00,
    0xB2, 0x08, 0x08, 0x03, 0x00, 0x00, 0x5C, 0x01, 0x00, 0x10, 0x10, 0x10, 0x59, 0x03, 0x0B, 0x94,
    0x04, 0x13, 0x37, 0x72, 0x01, 0x12, 0x10, 0x8D, 0x01, 0x31, 0x00, 0x11, 0x01, 0xB9, 0x02, 0x00,
    0x1F, 0x00, 0x13, 0x0A, 0xA9, 0x04, 0x17, 0x10, 0x77, 0x03, 0x05, 0x12, 0x00, 0x00, 0x04, 0x04,
    0xCF, 0x81, 0x10, 0x09, 0x28, 0x93, 0x32, 0xA5, 0x44, 0x5B, 0x8A, 0x67, 0x76, 0x2C, 0x01, 0x05,
    0x53, 0xFF, 0xEF, 0xFF, 0xEF, 0xC0, 0x01, 0x00, 0x57, 0xDC, 0xDC, 0xDC, 0xDC, 0x0A, 0x01, 0x00,
    0x01, 0x24, 0x01, 0x21, 0x03, 0x07, 0x04, 0x00, 0xF1, 0x03, 0x00, 0x24, 0xFF, 0xFF, 0x00, 0x44,
    0x57, 0x6E, 0x00, 0x28, 0x72, 0x39, 0x00, 0x10, 0x9C, 0x4B, 0x00, 0x10, 0x58, 0x01, 0xB2, 0x08,
    0x4C, 0x00, 0x00, 0x80, 0x20, 0x10, 0x0A, 0x00, 0x28, 0x10, 0xE0, 0x02, 0x0C, 0x74, 0x01, 0x04,
    0x08, 0x00, 0x17, 0x05, 0x10, 0x00, 0x17, 0x04, 0xEC, 0x03, 0xE4, 0x01, 0x00, 0x02, 0x02, 0x01,
    0x02, 0x03, 0x00, 0x04, 0x05, 0xC3, 0x71, 0x0F, 0x0F, 0x98, 0x05, 0x15, 0x1F, 0xF3, 0x00, 0x00,
    0xC0, 0x03, 0x14, 0x01, 0xDD, 0x00, 0x14, 0x80, 0xB6, 0x00, 0x15, 0xF0, 0xD4, 0x03, 0x68, 0x43,
    0xC3, 0xBA, 0xE4, 0xD3, 0x1E, 0xD2, 0x00, 0x2F, 0xF0, 0xFF, 0xEC, 0x00, 0x05, 0x19, 0x08, 0x0E,
    0x00, 0x14, 0x30, 0xAB, 0x00, 0x0F, 0x2C, 0x00, 0x02, 0x4F, 0x76, 0x0C, 0x00, 0x04, 0x50, 0x02,
    0x01, 0x05, 0x34, 0x00, 0x0F, 0x3A, 0x00, 0x04, 0x38, 0x7E, 0x16, 0x40, 0x9F, 0x05, 0x0F, 0x38,
    0x00, 0x17, 0x3F, 0x1E, 0x40, 0x04, 0xA8, 0x00, 0x08, 0x2F, 0x00, 0xC0, 0x55, 0x00, 0x04, 0x3F,
    0x46, 0x24, 0x00, 0x38, 0x00, 0x0A, 0x0F, 0x01, 0x00, 0x05, 0x22, 0x46, 0x2C, 0x38, 0x00, 0x2F,
    0xEC, 0x00, 0x3C, 0x01, 0x07, 0x0F, 0x68, 0x07, 0xFF, 0x9E, 0x1F, 0x12, 0x68, 0x07, 0x18, 0x1F,
    0x03, 0x68, 0x07, 0xFF, 0xFF, 0xAE, 0x13, 0x12, 0x04, 0x00, 0x0F, 0x68, 0x07, 0xFF, 0xFF, 0xAE,
    0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
};

constexpr inline const u8 * const SdramParamsErista2 = SdramParamsErista2_3;
constexpr inline const size_t SdramParamsSizeErista2 = sizeof(SdramParamsErista2_3);

constexpr inline const u8 * const SdramParamsErista3 = SdramParamsErista2_3;
constexpr inline const size_t SdramParamsSizeErista3 = sizeof(SdramParamsErista2_3);

constexpr inline const u8 SdramParamsErista4_5[0x417] = {
    0xFF, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x2C, 0x01,
    0x00, 0x01, 0x00, 0x0E, 0xFC, 0x05, 0x68, 0xBC, 0x01, 0x70, 0x0A, 0x00, 0x00, 0x00, 0x04, 0xB4,
    0x01, 0x70, 0x01, 0x32, 0x54, 0x76, 0xC8, 0xE6, 0x00, 0x70, 0x24, 0x00, 0xC8, 0x34, 0x00, 0x00,
    0x00, 0x02, 0x80, 0x18, 0x40, 0x00, 0x00, 0x00, 0x40, 0x18, 0x00, 0xFF, 0x01, 0xFF, 0xFF, 0x1F,
    0x00, 0xD8, 0x51, 0x1A, 0xA0, 0x00, 0x00, 0x50, 0x05, 0x00, 0x00, 0x77, 0x00, 0x04, 0x00, 0x01,
    0xD3, 0xA6, 0xA6, 0xAF, 0xB3, 0x3C, 0x9E, 0x00, 0x00, 0x03, 0x03, 0xE0, 0xC1, 0x04, 0x01, 0x00,
    0x00, 0x3C, 0x00, 0x19, 0x1F, 0x01, 0x00, 0x42, 0x00, 0x00, 0x04, 0x08, 0x46, 0x00, 0x57, 0xA1,
    0x01, 0x00, 0x00, 0x32, 0x64, 0x00, 0x00, 0xC3, 0x00, 0x13, 0x02, 0x0C, 0x00, 0x13, 0x03, 0x04,
    0x00, 0xD7, 0x1E, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x13, 0x2C,
    0x00, 0x10, 0x09, 0xC8, 0x00, 0x07, 0x10, 0x00, 0x13, 0x0B, 0x28, 0x00, 0x13, 0x08, 0x0C, 0x00,
    0x00, 0x1C, 0x00, 0x57, 0x20, 0x00, 0x00, 0x00, 0x06, 0x04, 0x00, 0x13, 0x03, 0x2C, 0x00, 0x13,
    0x04, 0x10, 0x00, 0x17, 0x02, 0x10, 0x00, 0x13, 0x08, 0x40, 0x00, 0x13, 0x05, 0x1C, 0x00, 0x04,
    0x58, 0x00, 0x13, 0x02, 0x18, 0x00, 0x04, 0x64, 0x00, 0x00, 0xA6, 0x00, 0xB5, 0x12, 0x00, 0x00,
    0x00, 0x14, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x0C, 0x00, 0x01, 0x58, 0x01, 0x03, 0x61, 0x00,
    0x13, 0xC1, 0x50, 0x00, 0x17, 0x08, 0xC8, 0x00, 0x13, 0x03, 0x28, 0x00, 0x17, 0x05, 0x54, 0x00,
    0x13, 0x27, 0x04, 0x00, 0x13, 0x05, 0x04, 0x00, 0x13, 0x04, 0xD8, 0x00, 0x08, 0x0C, 0x00, 0xA0,
    0x1C, 0x03, 0x00, 0x00, 0x0D, 0xA0, 0x60, 0x91, 0xBF, 0x3B, 0x5A, 0x00, 0xF1, 0x28, 0xF3, 0x0C,
    0x04, 0x05, 0x1B, 0x06, 0x02, 0x03, 0x07, 0x1C, 0x23, 0x25, 0x25, 0x05, 0x08, 0x1D, 0x09, 0x0A,
    0x24, 0x0B, 0x1E, 0x0D, 0x0C, 0x26, 0x26, 0x03, 0x02, 0x1B, 0x1C, 0x23, 0x03, 0x04, 0x07, 0x05,
    0x06, 0x25, 0x25, 0x02, 0x0A, 0x0B, 0x1D, 0x0D, 0x08, 0x0C, 0x09, 0x1E, 0x24, 0x26, 0x26, 0x08,
    0x24, 0x06, 0x07, 0x9A, 0x12, 0xC1, 0x01, 0x2C, 0x00, 0xFF, 0xEC, 0x01, 0xB0, 0x04, 0x00, 0x01,
    0x08, 0x00, 0x00, 0x02, 0x08, 0x00, 0x00, 0x0D, 0xAB, 0x00, 0xD0, 0xC0, 0x71, 0x71, 0x03, 0x08,
    0x00, 0x00, 0x0B, 0x08, 0x72, 0x72, 0x0E, 0x0C, 0x20, 0x00, 0xC2, 0x08, 0x08, 0x0D, 0x0C, 0x00,
    0x00, 0x0D, 0x0C, 0x14, 0x14, 0x16, 0x08, 0x2C, 0x00, 0x2C, 0x11, 0x08, 0x67, 0x02, 0x70, 0x15,
    0x00, 0xCC, 0x00, 0x0A, 0x00, 0x33, 0x6E, 0x01, 0x94, 0xF3, 0x05, 0x08, 0x11, 0x00, 0xFF, 0x0F,
    0xFF, 0x0F, 0xCC, 0x01, 0x80, 0x01, 0x03, 0x00, 0x70, 0x00, 0x0C, 0x00, 0x01, 0x0C, 0x00, 0xC0,
    0x08, 0x44, 0x00, 0x10, 0x04, 0x04, 0x00, 0x06, 0x13, 0x07, 0x00, 0x80, 0x10, 0x00, 0xA2, 0xA0,
    0x00, 0x2C, 0x00, 0x01, 0x37, 0x00, 0x00, 0x00, 0x80, 0x48, 0x00, 0xD3, 0x08, 0x00, 0x04, 0x00,
    0x1F, 0x22, 0x20, 0x80, 0x0F, 0xF4, 0x20, 0x02, 0x28, 0x01, 0x00, 0x13, 0x11, 0x01, 0x00, 0x10,
    0xBE, 0xBF, 0x00, 0x12, 0x0F, 0x02, 0x00, 0x1F, 0x00, 0x01, 0x00, 0x2C, 0x7F, 0x14, 0x00, 0x12,
    0x00, 0x10, 0x00, 0x14, 0x18, 0x00, 0x06, 0xF3, 0x02, 0x30, 0x00, 0x2E, 0x00, 0x33, 0x00, 0x30,
    0x00, 0x33, 0x00, 0x35, 0x00, 0x30, 0x00, 0x32, 0x00, 0x05, 0x20, 0x00, 0x0F, 0x18, 0x00, 0x05,
    0x1F, 0x28, 0x02, 0x00, 0x0C, 0x11, 0x14, 0x5A, 0x00, 0x00, 0x5C, 0x00, 0x11, 0x10, 0x0C, 0x00,
    0x0C, 0x7A, 0x00, 0x05, 0x50, 0x01, 0xA4, 0x40, 0x06, 0x00, 0xCC, 0x00, 0x09, 0x00, 0x4F, 0x00,
    0x51, 0x18, 0x00, 0x00, 0x28, 0x01, 0x23, 0x40, 0x01, 0x3C, 0x02, 0x54, 0xAB, 0x00, 0x0A, 0x04,
    0x11, 0x58, 0x01, 0x03, 0x04, 0x00, 0x0F, 0xEC, 0x00, 0x0D, 0x17, 0x02, 0x0C, 0x00, 0x17, 0x03,
    0x60, 0x03, 0x02, 0xA1, 0x01, 0x68, 0x22, 0x04, 0xFF, 0xFF, 0xAF, 0x4F, 0x74, 0x03, 0x04, 0x38,
    0x00, 0x32, 0x8B, 0xFF, 0x07, 0x84, 0x00, 0xF0, 0x10, 0x32, 0x54, 0x76, 0x10, 0x47, 0x32, 0x65,
    0x10, 0x34, 0x76, 0x25, 0x01, 0x34, 0x67, 0x25, 0x01, 0x75, 0x64, 0x32, 0x01, 0x72, 0x56, 0x34,
    0x10, 0x23, 0x74, 0x56, 0x01, 0x45, 0x32, 0x67, 0x24, 0x00, 0x31, 0x49, 0x92, 0x24, 0x04, 0x00,
    0x0C, 0x01, 0x00, 0x13, 0x1B, 0x04, 0x00, 0x0C, 0x94, 0x00, 0x80, 0x2F, 0x41, 0x13, 0x1F, 0x14,
    0x00, 0x01, 0x00, 0x7C, 0x00, 0x80, 0xFF, 0xFF, 0xFF, 0x7F, 0x0B, 0xD7, 0x06, 0x40, 0x82, 0x00,
    0xB2, 0x08, 0x08, 0x03, 0x00, 0x00, 0x5C, 0x01, 0x00, 0x10, 0x10, 0x10, 0x59, 0x03, 0x0B, 0x94,
    0x04, 0x13, 0x37, 0x72, 0x01, 0x12, 0x10, 0x8D, 0x01, 0x31, 0x00, 0x11, 0x01, 0xB9, 0x02, 0x00,
    0x1F, 0x00, 0x13, 0x0A, 0xA9, 0x04, 0x17, 0x10, 0x77, 0x03, 0x05, 0x12, 0x00, 0x00, 0x04, 0x04,
    0xCF, 0x81, 0x10, 0x09, 0x28, 0x93, 0x32, 0xA5, 0x44, 0x5B, 0x8A, 0x67, 0x76, 0x2C, 0x01, 0x05,
    0x53, 0xFF, 0xEF, 0xFF, 0xEF, 0xC0, 0x01, 0x00, 0x57, 0xDC, 0xDC, 0xDC, 0xDC, 0x0A, 0x01, 0x00,
    0x01, 0x24, 0x01, 0x21, 0x03, 0x0C, 0x04, 0x00, 0xF1, 0x03, 0x00, 0x24, 0xFF, 0xFF, 0x00, 0x44,
    0x57, 0x6E, 0x00, 0x28, 0x72, 0x39, 0x00, 0x10, 0x9C, 0x4B, 0x00, 0x18, 0x58, 0x01, 0xB2, 0x08,
    0x4C, 0x00, 0x00, 0x80, 0x20, 0x10, 0x0A, 0x00, 0x28, 0x10, 0xE0, 0x02, 0x0C, 0x74, 0x01, 0x04,
    0x08, 0x00, 0x17, 0x05, 0x10, 0x00, 0x17, 0x04, 0xEC, 0x03, 0xE4, 0x01, 0x00, 0x02, 0x02, 0x01,
    0x02, 0x03, 0x00, 0x04, 0x05, 0xC3, 0x71, 0x0F, 0x0F, 0x98, 0x05, 0x15, 0x1F, 0xF3, 0x00, 0x00,
    0xC0, 0x03, 0x14, 0x01, 0xDD, 0x00, 0x14, 0x80, 0xB6, 0x00, 0x15, 0xF0, 0xD4, 0x03, 0x68, 0x43,
    0xC3, 0xBA, 0xE4, 0xD3, 0x1E, 0xD2, 0x00, 0x2F, 0xF0, 0xFF, 0xEC, 0x00, 0x05, 0x19, 0x08, 0x0E,
    0x00, 0x14, 0x30, 0xAB, 0x00, 0x0F, 0x2C, 0x00, 0x02, 0x4F, 0x76, 0x0C, 0x00, 0x04, 0x50, 0x02,
    0x01, 0x05, 0x34, 0x00, 0x0F, 0x3A, 0x00, 0x04, 0x38, 0x7E, 0x16, 0x40, 0x9F, 0x05, 0x0F, 0x38,
    0x00, 0x17, 0x3F, 0x1E, 0x40, 0x04, 0xA8, 0x00, 0x08, 0x2F, 0x00, 0xC0, 0x55, 0x00, 0x04, 0x3F,
    0x46, 0x24, 0x00, 0x38, 0x00, 0x0A, 0x0F, 0x01, 0x00, 0x05, 0x22, 0x46, 0x2C, 0x38, 0x00, 0x2F,
    0xEC, 0x00, 0x3C, 0x01, 0x07, 0x0F, 0x68, 0x07, 0xF9, 0x1F, 0x0D, 0x68, 0x07, 0x4C, 0x03, 0x5F,
    0x01, 0x1F, 0x80, 0x68, 0x07, 0x29, 0x1F, 0x12, 0x68, 0x07, 0x18, 0x1F, 0x03, 0x68, 0x07, 0xFF,
    0x45, 0x11, 0x15, 0xF6, 0x06, 0x1F, 0x16, 0x18, 0x00, 0x06, 0xF5, 0x00, 0x32, 0x00, 0x2F, 0x00,
    0x32, 0x00, 0x31, 0x00, 0x34, 0x00, 0x36, 0x00, 0x2F, 0x00, 0x33, 0x0C, 0x02, 0x0E, 0x18, 0x00,
    0x0F, 0x68, 0x07, 0x13, 0x13, 0x15, 0x5A, 0x00, 0x02, 0x5E, 0x00, 0x3F, 0x16, 0x00, 0x15, 0x68,
    0x07, 0xD4, 0x13, 0x12, 0x04, 0x00, 0x0F, 0x68, 0x07, 0x3E, 0x1F, 0x02, 0x68, 0x07, 0x65, 0x11,
    0x07, 0x04, 0x00, 0x0D, 0x68, 0x07, 0x1F, 0x10, 0x68, 0x07, 0x27, 0x1F, 0x05, 0x68, 0x07, 0xFF,
    0x90, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
};

constexpr inline const u8 * const SdramParamsErista4 = SdramParamsErista4_5;
constexpr inline const size_t SdramParamsSizeErista4 = sizeof(SdramParamsErista4_5);

constexpr inline const u8 * const SdramParamsErista5 = SdramParamsErista4_5;
constexpr inline const size_t SdramParamsSizeErista5 = sizeof(SdramParamsErista4_5);

constexpr inline const u8 SdramParamsErista6_7[0x3BC] = {
    0xFF, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x2C, 0x01,
    0x00, 0x01, 0x00, 0x0E, 0xFC, 0x05, 0x68, 0xBC, 0x01, 0x70, 0x0A, 0x00, 0x00, 0x00, 0x04, 0xB4,
    0x01, 0x70, 0x01, 0x32, 0x54, 0x76, 0xC8, 0xE6, 0x00, 0x70, 0x24, 0x00, 0xC8, 0x34, 0x00, 0x00,
    0x00, 0x02, 0x80, 0x18, 0x40, 0x00, 0x00, 0x00, 0x40, 0x18, 0x00, 0xFF, 0x01, 0xFF, 0xFF, 0x1F,
    0x00, 0xD8, 0x51, 0x1A, 0xA0, 0x00, 0x00, 0x50, 0x05, 0x00, 0x00, 0x77, 0x00, 0x04, 0x00, 0x01,
    0xD3, 0xA6, 0xA6, 0xAF, 0xB3, 0x3C, 0x9E, 0x00, 0x00, 0x03, 0x03, 0xE0, 0xC1, 0x04, 0x01, 0x00,
    0x00, 0x3C, 0x00, 0x19, 0x1F, 0x01, 0x00, 0x42, 0x00, 0x00, 0x04, 0x08, 0x46, 0x00, 0x57, 0xA1,
    0x01, 0x00, 0x00, 0x32, 0x64, 0x00, 0x00, 0xC3, 0x00, 0x13, 0x02, 0x0C, 0x00, 0x13, 0x03, 0x04,
    0x00, 0xD7, 0x1E, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x1D, 0x2C,
    0x00, 0x10, 0x09, 0xC8, 0x00, 0x07, 0x10, 0x00, 0x13, 0x0B, 0x28, 0x00, 0x13, 0x08, 0x0C, 0x00,
    0x00, 0x1C, 0x00, 0x57, 0x20, 0x00, 0x00, 0x00, 0x06, 0x04, 0x00, 0x13, 0x03, 0x2C, 0x00, 0x13,
    0x04, 0x10, 0x00, 0x17, 0x02, 0x10, 0x00, 0x13, 0x08, 0x40, 0x00, 0x13, 0x05, 0x1C, 0x00, 0x04,
    0x58, 0x00, 0x13, 0x02, 0x18, 0x00, 0x04, 0x64, 0x00, 0x00, 0xA6, 0x00, 0xB5, 0x12, 0x00, 0x00,
    0x00, 0x14, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x0C, 0x00, 0x01, 0x58, 0x01, 0x03, 0x61, 0x00,
    0x13, 0xC1, 0x50, 0x00, 0x17, 0x08, 0xC8, 0x00, 0x13, 0x03, 0x2C, 0x00, 0x17, 0x05, 0x54, 0x00,
    0x13, 0x3B, 0x04, 0x00, 0x13, 0x05, 0x04, 0x00, 0x13, 0x04, 0xD8, 0x00, 0x13, 0x05, 0x30, 0x00,
    0x00, 0x0C, 0x00, 0x90, 0x1C, 0x03, 0x00, 0x00, 0x0D, 0xA0, 0x60, 0x91, 0xBF, 0x29, 0x00, 0xF1,
    0x29, 0x00, 0xF3, 0x0C, 0x04, 0x05, 0x1B, 0x06, 0x02, 0x03, 0x07, 0x1C, 0x23, 0x25, 0x25, 0x05,
    0x08, 0x1D, 0x09, 0x0A, 0x24, 0x0B, 0x1E, 0x0D, 0x0C, 0x26, 0x26, 0x03, 0x02, 0x1B, 0x1C, 0x23,
    0x03, 0x04, 0x07, 0x05, 0x06, 0x25, 0x25, 0x02, 0x0A, 0x0B, 0x1D, 0x0D, 0x08, 0x0C, 0x09, 0x1E,
    0x24, 0x26, 0x26, 0x08, 0x24, 0x06, 0x07, 0x9A, 0x12, 0xC1, 0x01, 0x2C, 0x00, 0xFF, 0xEC, 0x01,
    0xB0, 0x04, 0x00, 0x01, 0x08, 0x00, 0x00, 0x02, 0x08, 0x00, 0x00, 0x0D, 0xAB, 0x00, 0xD0, 0xC0,
    0x71, 0x71, 0x03, 0x08, 0x00, 0x00, 0x0B, 0x08, 0x72, 0x72, 0x0E, 0x0C, 0x20, 0x00, 0xC2, 0x08,
    0x08, 0x0D, 0x0C, 0x00, 0x00, 0x0D, 0x0C, 0x14, 0x14, 0x16, 0x08, 0x2C, 0x00, 0x2C, 0x11, 0x08,
    0x67, 0x02, 0x70, 0x15, 0x00, 0xCC, 0x00, 0x0A, 0x00, 0x33, 0x6E, 0x01, 0x94, 0xF3, 0x05, 0x08,
    0x11, 0x00, 0xFF, 0x0F, 0xFF, 0x0F, 0xCC, 0x01, 0x80, 0x01, 0x03, 0x00, 0x70, 0x00, 0x0C, 0x00,
    0x01, 0x0C, 0x00, 0xC0, 0x08, 0x44, 0x00, 0x10, 0x04, 0x04, 0x00, 0x06, 0x13, 0x07, 0x00, 0x80,
    0x10, 0x00, 0xA2, 0xA0, 0x00, 0x2C, 0x00, 0x01, 0x37, 0x00, 0x00, 0x00, 0x80, 0x48, 0x00, 0xD3,
    0x08, 0x00, 0x04, 0x00, 0x1F, 0x22, 0x20, 0x80, 0x0F, 0xF4, 0x20, 0x02, 0x28, 0x01, 0x00, 0x13,
    0x11, 0x01, 0x00, 0x10, 0xBE, 0xBF, 0x00, 0x12, 0x0F, 0x02, 0x00, 0x1F, 0x00, 0x01, 0x00, 0x2C,
    0x7F, 0x15, 0x00, 0x12, 0x00, 0x12, 0x00, 0x16, 0x18, 0x00, 0x06, 0xF5, 0x00, 0x32, 0x00, 0x2F,
    0x00, 0x32, 0x00, 0x31, 0x00, 0x34, 0x00, 0x36, 0x00, 0x2F, 0x00, 0x33, 0x0C, 0x02, 0x0F, 0x18,
    0x00, 0x05, 0x1F, 0x28, 0x02, 0x00, 0x0C, 0x13, 0x15, 0x5A, 0x00, 0x02, 0x5E, 0x00, 0x3B, 0x16,
    0x00, 0x15, 0x78, 0x00, 0x05, 0x50, 0x01, 0xA4, 0x40, 0x06, 0x00, 0xCC, 0x00, 0x09, 0x00, 0x4F,
    0x00, 0x51, 0x18, 0x00, 0x00, 0x28, 0x01, 0x23, 0x40, 0x01, 0x0C, 0x02, 0x54, 0xAB, 0x00, 0x0A,
    0x04, 0x11, 0x58, 0x01, 0x03, 0x04, 0x00, 0x0F, 0xEC, 0x00, 0x0D, 0x17, 0x02, 0x0C, 0x00, 0x17,
    0x03, 0x60, 0x03, 0x02, 0xA1, 0x01, 0x68, 0x22, 0x04, 0xFF, 0xFF, 0xAF, 0x4F, 0x74, 0x03, 0x04,
    0x38, 0x00, 0x32, 0x8B, 0xFF, 0x07, 0x84, 0x00, 0xF0, 0x10, 0x32, 0x54, 0x76, 0x10, 0x47, 0x32,
    0x65, 0x10, 0x34, 0x76, 0x25, 0x01, 0x34, 0x67, 0x25, 0x01, 0x75, 0x64, 0x32, 0x01, 0x72, 0x56,
    0x34, 0x10, 0x23, 0x74, 0x56, 0x01, 0x45, 0x32, 0x67, 0x24, 0x00, 0x31, 0x49, 0x92, 0x24, 0x04,
    0x00, 0x0C, 0x01, 0x00, 0x13, 0x12, 0x04, 0x00, 0x0C, 0x94, 0x00, 0x80, 0x2F, 0x41, 0x13, 0x1F,
    0x14, 0x00, 0x01, 0x00, 0x7C, 0x00, 0x80, 0xFF, 0xFF, 0xFF, 0x7F, 0x0B, 0xD7, 0x06, 0x40, 0x82,
    0x00, 0xB2, 0x08, 0x08, 0x03, 0x00, 0x00, 0x5C, 0x01, 0x00, 0x10, 0x10, 0x10, 0x59, 0x03, 0x0B,
    0x94, 0x04, 0x11, 0x37, 0x16, 0x03, 0x30, 0x00, 0x00, 0x10, 0x05, 0x00, 0x51, 0x30, 0x00, 0x00,
    0x11, 0x01, 0xB9, 0x02, 0x00, 0x1F, 0x00, 0x13, 0x0A, 0xA9, 0x04, 0x17, 0x10, 0x77, 0x03, 0x05,
    0x12, 0x00, 0x00, 0x04, 0x04, 0xCF, 0x81, 0x10, 0x09, 0x28, 0x93, 0x32, 0xA5, 0x44, 0x5B, 0x8A,
    0x67, 0x76, 0x2C, 0x01, 0x05, 0x53, 0xFF, 0xEF, 0xFF, 0xEF, 0xC0, 0x01, 0x00, 0x57, 0xDC, 0xDC,
    0xDC, 0xDC, 0x0A, 0x01, 0x00, 0x01, 0x24, 0x01, 0x21, 0x03, 0x07, 0x04, 0x00, 0xF1, 0x03, 0x00,
    0x24, 0xFF, 0xFF, 0x00, 0x44, 0x57, 0x6E, 0x00, 0x28, 0x72, 0x39, 0x00, 0x10, 0x9C, 0x4B, 0x00,
    0x10, 0x58, 0x01, 0xB2, 0x08, 0x4C, 0x00, 0x00, 0x80, 0x20, 0x10, 0x0A, 0x00, 0x28, 0x10, 0xE0,
    0x02, 0x0C, 0x74, 0x01, 0x04, 0x08, 0x00, 0x17, 0x05, 0x10, 0x00, 0x13, 0x04, 0x10, 0x00, 0x11,
    0x07, 0x10, 0x00, 0xC4, 0x02, 0x02, 0x01, 0x02, 0x03, 0x00, 0x04, 0x05, 0xA3, 0x72, 0x0F, 0x0F,
    0x98, 0x05, 0x15, 0x1F, 0xF3, 0x00, 0x00, 0xC0, 0x03, 0x14, 0x01, 0xDD, 0x00, 0x14, 0x80, 0xB6,
    0x00, 0x15, 0xF0, 0xD4, 0x03, 0x68, 0x43, 0xC3, 0xBA, 0xE4, 0xD3, 0x1E, 0xD2, 0x00, 0x2F, 0xF0,
    0xFF, 0xEC, 0x00, 0x05, 0x19, 0x08, 0x0E, 0x00, 0x14, 0x30, 0xAB, 0x00, 0x0F, 0x2C, 0x00, 0x02,
    0x4F, 0x76, 0x0C, 0x00, 0x04, 0x50, 0x02, 0x01, 0x05, 0x34, 0x00, 0x0F, 0x3A, 0x00, 0x04, 0x38,
    0x7E, 0x16, 0x40, 0x9F, 0x05, 0x0F, 0x38, 0x00, 0x17, 0x3F, 0x1E, 0x40, 0x04, 0xA8, 0x00, 0x08,
    0x2F, 0x00, 0xC0, 0x55, 0x00, 0x04, 0x3F, 0x46, 0x24, 0x00, 0x38, 0x00, 0x0A, 0x0F, 0x01, 0x00,
    0x05, 0x22, 0x46, 0x2C, 0x38, 0x00, 0x2E, 0xEC, 0x00, 0x3C, 0x01, 0x0F, 0x01, 0x00, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
};

constexpr inline const u8 * const SdramParamsErista6 = SdramParamsErista6_7;
constexpr inline const size_t SdramParamsSizeErista6 = sizeof(SdramParamsErista6_7);

constexpr inline const u8 * const SdramParamsErista7 = SdramParamsErista6_7;
constexpr inline const size_t SdramParamsSizeErista7 = sizeof(SdramParamsErista6_7);

constexpr inline const u8 SdramParamsMariko0_1[0x3EC] = {
    0xFF, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x2C, 0x01,
    0x00, 0x01, 0x00, 0x96, 0x88, 0x02, 0x80, 0x18, 0x40, 0x00, 0x00, 0x00, 0x40, 0x14, 0x00, 0x82,
    0xFF, 0xFF, 0x1F, 0x00, 0xD8, 0x51, 0x1A, 0xA0, 0x0E, 0x00, 0x11, 0x88, 0x04, 0x00, 0x26, 0x20,
    0x12, 0x0C, 0x00, 0x02, 0x04, 0x00, 0xF7, 0x00, 0x00, 0x00, 0xBC, 0xBC, 0xC5, 0xB3, 0x3C, 0x9E,
    0x00, 0x00, 0x02, 0x03, 0xE0, 0xC1, 0x04, 0x01, 0x00, 0x17, 0x3F, 0x01, 0x00, 0x00, 0x38, 0x00,
    0xD0, 0x04, 0x08, 0x00, 0x00, 0x50, 0x50, 0x50, 0x00, 0xA1, 0x01, 0x00, 0x00, 0x30, 0x39, 0x00,
    0x62, 0x10, 0x00, 0x16, 0x00, 0x10, 0x90, 0x80, 0x00, 0x03, 0x74, 0x00, 0x13, 0x03, 0x04, 0x00,
    0xD7, 0x1E, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x1D, 0x94, 0x00,
    0x57, 0x09, 0x00, 0x00, 0x00, 0x04, 0x10, 0x00, 0x13, 0x0B, 0x28, 0x00, 0x13, 0x08, 0x0C, 0x00,
    0x00, 0x1C, 0x00, 0x53, 0x17, 0x00, 0x00, 0x00, 0x15, 0x08, 0x00, 0x13, 0x1B, 0x28, 0x00, 0x57,
    0x20, 0x00, 0x00, 0x00, 0x06, 0x04, 0x00, 0x13, 0x03, 0x18, 0x00, 0x13, 0x04, 0x10, 0x00, 0x17,
    0x02, 0x10, 0x00, 0x00, 0x4C, 0x00, 0x53, 0x0E, 0x00, 0x00, 0x00, 0x05, 0x1C, 0x00, 0x05, 0x24,
    0x01, 0x03, 0x6C, 0x00, 0x03, 0xD7, 0x01, 0x10, 0x80, 0x0A, 0x00, 0x00, 0x0F, 0x01, 0x93, 0x18,
    0x00, 0x00, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x16, 0x0C, 0x00, 0x10, 0x0A, 0x48, 0x00, 0x03, 0x61,
    0x00, 0x13, 0xC1, 0x50, 0x00, 0x13, 0x08, 0x74, 0x00, 0x13, 0x0A, 0x08, 0x00, 0x13, 0x14, 0x60,
    0x00, 0x04, 0x54, 0x00, 0x13, 0x3B, 0x04, 0x00, 0x13, 0x05, 0x04, 0x00, 0x13, 0x04, 0xEC, 0x00,
    0x08, 0x0C, 0x00, 0x90, 0x1C, 0x03, 0x00, 0x00, 0x0D, 0xA0, 0x60, 0x91, 0x3F, 0x15, 0x01, 0xF1,
    0x28, 0x00, 0xF3, 0x0C, 0x04, 0x05, 0x1B, 0x06, 0x02, 0x03, 0x07, 0x1C, 0x23, 0x25, 0x25, 0x05,
    0x08, 0x1D, 0x09, 0x0A, 0x24, 0x0B, 0x1E, 0x0D, 0x0C, 0x26, 0x26, 0x03, 0x02, 0x1B, 0x1C, 0x23,
    0x03, 0x04, 0x07, 0x05, 0x06, 0x25, 0x25, 0x02, 0x0A, 0x0B, 0x1D, 0x0D, 0x08, 0x0C, 0x09, 0x1E,
    0x24, 0x26, 0x26, 0x08, 0x24, 0x06, 0x07, 0x9A, 0xBF, 0x01, 0x3C, 0xFF, 0x00, 0xFF, 0x00, 0x02,
    0xB0, 0x04, 0x00, 0x01, 0x88, 0x00, 0x00, 0x02, 0x88, 0x00, 0x00, 0x0D, 0xD5, 0x01, 0xF2, 0x0E,
    0xC0, 0x31, 0x31, 0x03, 0x88, 0x00, 0x00, 0x0B, 0x88, 0x5D, 0x5D, 0x0E, 0x8C, 0x5D, 0x5D, 0x0C,
    0x88, 0x08, 0x08, 0x0D, 0x8C, 0x00, 0x00, 0x0D, 0x8C, 0x16, 0x16, 0x16, 0x88, 0x2C, 0x00, 0x2C,
    0x11, 0x08, 0xDF, 0x02, 0x70, 0x10, 0x00, 0xCC, 0x00, 0x0A, 0x00, 0x33, 0x6E, 0x01, 0x40, 0xF3,
    0x25, 0x08, 0x11, 0x69, 0x00, 0x23, 0x0F, 0x00, 0x30, 0x01, 0x80, 0x01, 0x03, 0x00, 0x70, 0x00,
    0x0C, 0x00, 0x01, 0x0C, 0x00, 0xA2, 0x08, 0x44, 0x00, 0x10, 0x04, 0x04, 0x00, 0x06, 0x13, 0x07,
    0x1C, 0x00, 0x71, 0xA0, 0x00, 0x2C, 0x00, 0x01, 0x37, 0x0F, 0x52, 0x01, 0x00, 0x10, 0x01, 0xDB,
    0x0C, 0x00, 0x04, 0x00, 0x1F, 0x22, 0x20, 0x80, 0x0F, 0xF4, 0x20, 0x02, 0x29, 0x01, 0x00, 0x12,
    0x78, 0x9A, 0x02, 0x1F, 0x0F, 0xF4, 0x02, 0x31, 0x7F, 0x22, 0x00, 0x0E, 0x00, 0x10, 0x00, 0x1B,
    0x18, 0x00, 0x06, 0xF3, 0x02, 0x43, 0x00, 0x49, 0x00, 0x45, 0x00, 0x42, 0x00, 0x47, 0x00, 0x49,
    0x00, 0x47, 0x00, 0x46, 0x00, 0x16, 0xE6, 0x00, 0x0F, 0x18, 0x00, 0x05, 0x1F, 0x28, 0x02, 0x00,
    0x0C, 0x11, 0x22, 0x5A, 0x00, 0x00, 0x5C, 0x00, 0x00, 0x5E, 0x00, 0x3F, 0x1B, 0x00, 0x22, 0x94,
    0x00, 0x00, 0x05, 0x54, 0x01, 0xB3, 0x40, 0x06, 0x00, 0xCC, 0x00, 0x09, 0x00, 0x4F, 0x00, 0x51,
    0x80, 0x18, 0x00, 0x04, 0x08, 0x00, 0x01, 0x40, 0x02, 0x54, 0xAB, 0x00, 0x0A, 0x04, 0x11, 0x5C,
    0x01, 0x03, 0x04, 0x00, 0x0F, 0xE4, 0x03, 0x0E, 0x07, 0x0C, 0x00, 0x04, 0xA8, 0x04, 0x01, 0x14,
    0x00, 0x75, 0x01, 0x22, 0x04, 0xFF, 0x9F, 0xAF, 0x4F, 0x10, 0x00, 0x07, 0x34, 0x00, 0x32, 0x9F,
    0xFF, 0x37, 0x98, 0x00, 0xF0, 0x10, 0x32, 0x54, 0x76, 0x10, 0x47, 0x32, 0x65, 0x10, 0x34, 0x76,
    0x25, 0x01, 0x34, 0x67, 0x25, 0x01, 0x75, 0x64, 0x32, 0x01, 0x72, 0x56, 0x34, 0x10, 0x23, 0x74,
    0x56, 0x01, 0x45, 0x32, 0x67, 0x24, 0x00, 0x31, 0x49, 0x92, 0x24, 0x04, 0x00, 0x0C, 0x01, 0x00,
    0x13, 0x12, 0x04, 0x00, 0x0C, 0x90, 0x00, 0x80, 0x20, 0x41, 0x13, 0x1F, 0x14, 0x00, 0x01, 0x00,
    0x7C, 0x00, 0x85, 0xFF, 0xFF, 0xFF, 0x7F, 0x1F, 0xD7, 0x36, 0x40, 0xE6, 0x03, 0x25, 0x34, 0x10,
    0xF0, 0x03, 0x0F, 0xCC, 0x00, 0x01, 0x31, 0x03, 0x00, 0x05, 0x2B, 0x03, 0x22, 0x10, 0x02, 0xDD,
    0x03, 0x13, 0x21, 0x15, 0x04, 0x14, 0x40, 0x8B, 0x02, 0x07, 0x01, 0x00, 0x71, 0x80, 0x00, 0x40,
    0x00, 0x04, 0x10, 0x80, 0x04, 0x04, 0xCF, 0x81, 0x10, 0x09, 0x28, 0x93, 0x32, 0xA5, 0x44, 0x5B,
    0x8A, 0x67, 0x76, 0x54, 0x05, 0x4D, 0x22, 0x10, 0x10, 0x04, 0x00, 0x44, 0x00, 0xEF, 0x00, 0xEF,
    0x14, 0x00, 0x4D, 0x1C, 0x1C, 0x1C, 0x1C, 0x98, 0x01, 0x21, 0x03, 0x08, 0x04, 0x00, 0xF1, 0x03,
    0x00, 0x24, 0xFF, 0xFF, 0x00, 0x44, 0x57, 0x6E, 0x00, 0x28, 0x72, 0x39, 0x00, 0x10, 0x9C, 0x4B,
    0x00, 0x10, 0xA4, 0x01, 0xEF, 0x08, 0x4C, 0x00, 0x00, 0x80, 0x20, 0x10, 0x0A, 0x00, 0x28, 0x10,
    0x00, 0x80, 0x01, 0xC0, 0x01, 0x00, 0x04, 0x08, 0x00, 0x17, 0x05, 0x0C, 0x02, 0x13, 0x04, 0x10,
    0x00, 0x12, 0x07, 0x62, 0x00, 0xD2, 0x02, 0x01, 0x02, 0x03, 0x00, 0x04, 0x05, 0xA3, 0x72, 0x0F,
    0x0F, 0x00, 0x70, 0x42, 0x00, 0x16, 0x1F, 0x28, 0x01, 0x43, 0xFF, 0x00, 0xFF, 0x01, 0xA4, 0x04,
    0x24, 0x00, 0x80, 0x96, 0x00, 0x15, 0xF0, 0x24, 0x04, 0x68, 0x43, 0xC3, 0xBA, 0xE4, 0xD3, 0x1E,
    0x0B, 0x05, 0x2F, 0xF0, 0xFF, 0xF4, 0x00, 0x05, 0x19, 0x08, 0x0E, 0x00, 0x01, 0xE6, 0x05, 0x1F,
    0x03, 0x2C, 0x00, 0x05, 0x10, 0x76, 0xE9, 0x03, 0x0F, 0x9C, 0x02, 0x00, 0x05, 0x34, 0x00, 0x0F,
    0x3A, 0x00, 0x04, 0x38, 0x7E, 0x16, 0x40, 0x03, 0x06, 0x0F, 0x38, 0x00, 0x17, 0x3F, 0x1E, 0x40,
    0x04, 0xA8, 0x00, 0x08, 0x2F, 0x00, 0xC0, 0x55, 0x00, 0x04, 0x3F, 0x46, 0x24, 0x00, 0x38, 0x00,
    0x0A, 0x0F, 0x01, 0x00, 0x05, 0x22, 0x46, 0x2C, 0x38, 0x00, 0x19, 0xEC, 0x16, 0x00, 0x0F, 0x3C,
    0x01, 0x03, 0x0F, 0x38, 0x08, 0xFF, 0xFF, 0xFF, 0x9C, 0x7F, 0x16, 0x00, 0x0D, 0x00, 0x0B, 0x00,
    0x17, 0x18, 0x00, 0x06, 0xF1, 0x02, 0x43, 0x00, 0x45, 0x00, 0x45, 0x00, 0x43, 0x00, 0x46, 0x00,
    0x47, 0x00, 0x41, 0x00, 0x46, 0x00, 0x0C, 0xBA, 0x01, 0x1F, 0x0D, 0x18, 0x00, 0x06, 0x0F, 0x38,
    0x08, 0x0D, 0x11, 0x16, 0x5A, 0x00, 0x00, 0x5C, 0x00, 0x00, 0x5E, 0x00, 0x3F, 0x17, 0x00, 0x16,
    0x38, 0x08, 0xFF, 0xFF, 0xFF, 0xF6, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
};

constexpr inline const u8 * const SdramParamsMariko0 = SdramParamsMariko0_1;
constexpr inline const size_t SdramParamsSizeMariko0 = sizeof(SdramParamsMariko0_1);

constexpr inline const u8 * const SdramParamsMariko1 = SdramParamsMariko0_1;
constexpr inline const size_t SdramParamsSizeMariko1 = sizeof(SdramParamsMariko0_1);

constexpr inline const u8 SdramParamsMariko2_3[0x447] = {
    0xFF, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x2C, 0x01,
    0x00, 0x01, 0x00, 0x96, 0x88, 0x02, 0x80, 0x18, 0x40, 0x00, 0x00, 0x00, 0x40, 0x14, 0x00, 0xF0,
    0x01, 0xFF, 0xFF, 0x1F, 0x00, 0xD8, 0x51, 0x1A, 0xA0, 0x00, 0x00, 0x50, 0x05, 0x00, 0x00, 0x88,
    0x00, 0x04, 0x00, 0x20, 0x20, 0x12, 0x1A, 0x00, 0x17, 0x88, 0x04, 0x00, 0xF7, 0x00, 0x00, 0x00,
    0xBC, 0xBC, 0xAF, 0xC9, 0x3C, 0x9E, 0x00, 0x00, 0x02, 0x03, 0xE0, 0xC1, 0x04, 0x01, 0x00, 0x17,
    0x3F, 0x01, 0x00, 0x00, 0x38, 0x00, 0xD0, 0x04, 0x08, 0x00, 0x00, 0x50, 0x50, 0x50, 0x00, 0xA1,
    0x01, 0x00, 0x00, 0x30, 0x39, 0x00, 0x61, 0x10, 0x00, 0x16, 0x00, 0x10, 0x90, 0x30, 0x01, 0x13,
    0x02, 0x74, 0x00, 0x13, 0x03, 0x04, 0x00, 0xD7, 0x1E, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00,
    0x3A, 0x00, 0x00, 0x00, 0x1D, 0x94, 0x00, 0x57, 0x09, 0x00, 0x00, 0x00, 0x04, 0x10, 0x00, 0x13,
    0x0B, 0x28, 0x00, 0x13, 0x08, 0x0C, 0x00, 0x00, 0x1C, 0x00, 0x53, 0x17, 0x00, 0x00, 0x00, 0x15,
    0x08, 0x00, 0x13, 0x1B, 0x28, 0x00, 0x57, 0x20, 0x00, 0x00, 0x00, 0x06, 0x04, 0x00, 0x13, 0x03,
    0x18, 0x00, 0x13, 0x04, 0x10, 0x00, 0x17, 0x02, 0x10, 0x00, 0x00, 0x4C, 0x00, 0x13, 0x0E, 0x18,
    0x00, 0x17, 0x05, 0x6C, 0x00, 0x00, 0x34, 0x00, 0x13, 0x0C, 0xE0, 0x01, 0x40, 0x00, 0x00, 0x00,
    0x80, 0x0A, 0x00, 0x00, 0x0F, 0x01, 0x93, 0x18, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x16,
    0x0C, 0x00, 0x10, 0x0A, 0x48, 0x00, 0x03, 0x61, 0x00, 0x13, 0xC1, 0x50, 0x00, 0x13, 0x08, 0x40,
    0x00, 0x13, 0x0A, 0x08, 0x00, 0x13, 0x14, 0x5C, 0x00, 0x13, 0x02, 0xC0, 0x00, 0x13, 0x3B, 0x04,
    0x00, 0x13, 0x05, 0x04, 0x00, 0x13, 0x04, 0xEC, 0x00, 0x08, 0x0C, 0x00, 0x90, 0x1C, 0x03, 0x00,
    0x00, 0x0D, 0xA0, 0x60, 0x91, 0x3F, 0x15, 0x01, 0xF1, 0x28, 0x00, 0xF3, 0x0C, 0x04, 0x05, 0x1B,
    0x06, 0x02, 0x03, 0x07, 0x1C, 0x23, 0x25, 0x25, 0x05, 0x08, 0x1D, 0x09, 0x0A, 0x24, 0x0B, 0x1E,
    0x0D, 0x0C, 0x26, 0x26, 0x03, 0x02, 0x1B, 0x1C, 0x23, 0x03, 0x04, 0x07, 0x05, 0x06, 0x25, 0x25,
    0x02, 0x0A, 0x0B, 0x1D, 0x0D, 0x08, 0x0C, 0x09, 0x1E, 0x24, 0x26, 0x26, 0x08, 0x24, 0x06, 0x07,
    0x9A, 0xBF, 0x01, 0x3C, 0xFF, 0x00, 0xFF, 0x00, 0x02, 0xB0, 0x04, 0x00, 0x01, 0x08, 0x00, 0x00,
    0x02, 0x08, 0x00, 0x00, 0x0D, 0xAB, 0x00, 0xF2, 0x0E, 0xC0, 0x31, 0x31, 0x03, 0x08, 0x00, 0x00,
    0x0B, 0x08, 0x5D, 0x5D, 0x0E, 0x0C, 0x5D, 0x5D, 0x0C, 0x08, 0x08, 0x08, 0x0D, 0x0C, 0x00, 0x00,
    0x0D, 0x0C, 0x14, 0x14, 0x16, 0x08, 0x2C, 0x00, 0x2C, 0x11, 0x08, 0xDF, 0x02, 0x70, 0x10, 0x00,
    0xCC, 0x00, 0x0A, 0x00, 0x33, 0x6E, 0x01, 0x40, 0xF3, 0x25, 0x08, 0x11, 0x69, 0x00, 0x23, 0x0F,
    0x00, 0x30, 0x01, 0x80, 0x01, 0x03, 0x00, 0x70, 0x00, 0x0C, 0x00, 0x01, 0x0C, 0x00, 0xA2, 0x08,
    0x44, 0x00, 0x10, 0x04, 0x04, 0x00, 0x06, 0x13, 0x07, 0x1C, 0x00, 0x71, 0xA0, 0x00, 0x2C, 0x00,
    0x01, 0x37, 0x0F, 0x52, 0x01, 0x11, 0x00, 0x64, 0x01, 0xB3, 0x04, 0x00, 0x1F, 0x22, 0x20, 0x80,
    0x0F, 0xF4, 0x20, 0x02, 0x35, 0x01, 0x00, 0x13, 0x29, 0x01, 0x00, 0x12, 0x78, 0x9A, 0x02, 0x1F,
    0x0F, 0xF4, 0x02, 0x31, 0x7F, 0x16, 0x00, 0x0D, 0x00, 0x0B, 0x00, 0x17, 0x18, 0x00, 0x06, 0xF1,
    0x02, 0x43, 0x00, 0x45, 0x00, 0x45, 0x00, 0x43, 0x00, 0x46, 0x00, 0x47, 0x00, 0x41, 0x00, 0x46,
    0x00, 0x0C, 0xBA, 0x01, 0x1F, 0x0D, 0x18, 0x00, 0x06, 0x1F, 0x10, 0x02, 0x00, 0x0C, 0x11, 0x16,
    0x5A, 0x00, 0x00, 0x5C, 0x00, 0x00, 0x5E, 0x00, 0x3F, 0x17, 0x00, 0x16, 0x94, 0x00, 0x00, 0x05,
    0x54, 0x01, 0xA4, 0x40, 0x06, 0x00, 0xCC, 0x00, 0x09, 0x00, 0x4F, 0x00, 0x51, 0x18, 0x00, 0x63,
    0x80, 0x01, 0x00, 0x00, 0x40, 0x01, 0x40, 0x02, 0x54, 0xAB, 0x00, 0x0A, 0x04, 0x11, 0x5C, 0x01,
    0x03, 0x04, 0x00, 0x0F, 0xE4, 0x03, 0x0E, 0x0B, 0xCC, 0x02, 0x05, 0x78, 0x03, 0x78, 0x01, 0x22,
    0x04, 0xFF, 0x9F, 0xAF, 0x4F, 0x88, 0x03, 0x04, 0x34, 0x00, 0x32, 0x9F, 0xFF, 0x37, 0x80, 0x00,
    0xF0, 0x10, 0x32, 0x54, 0x76, 0x10, 0x47, 0x32, 0x65, 0x10, 0x34, 0x76, 0x25, 0x01, 0x34, 0x67,
    0x25, 0x01, 0x75, 0x64, 0x32, 0x01, 0x72, 0x56, 0x34, 0x10, 0x23, 0x74, 0x56, 0x01, 0x45, 0x32,
    0x67, 0x24, 0x00, 0x31, 0x49, 0x92, 0x24, 0x04, 0x00, 0x0C, 0x01, 0x00, 0x13, 0x12, 0x04, 0x00,
    0x0C, 0x90, 0x00, 0x80, 0x20, 0x41, 0x13, 0x1F, 0x14, 0x00, 0x01, 0x00, 0x7C, 0x00, 0x85, 0xFF,
    0xFF, 0xFF, 0x7F, 0x1F, 0xD7, 0x36, 0x40, 0xE6, 0x03, 0x25, 0x34, 0x10, 0xF0, 0x03, 0x0F, 0xCC,
    0x00, 0x01, 0x31, 0x03, 0x00, 0x05, 0x2B, 0x03, 0x22, 0x10, 0x02, 0xDD, 0x03, 0x13, 0x21, 0x15,
    0x04, 0x14, 0x40, 0x8B, 0x02, 0x1D, 0x00, 0x9D, 0x02, 0x01, 0x04, 0x04, 0xCF, 0x81, 0x10, 0x09,
    0x28, 0x93, 0x32, 0xA5, 0x44, 0x5B, 0x8A, 0x67, 0x76, 0x54, 0x05, 0x4D, 0x22, 0x10, 0x10, 0x04,
    0x00, 0x44, 0x00, 0xEF, 0x00, 0xEF, 0x14, 0x00, 0x4C, 0x1C, 0x1C, 0x1C, 0x1C, 0xF0, 0x01, 0x31,
    0x02, 0x03, 0x08, 0x04, 0x00, 0xF1, 0x03, 0x00, 0x24, 0xFF, 0xFF, 0x00, 0x44, 0x57, 0x6E, 0x00,
    0x28, 0x72, 0x39, 0x00, 0x10, 0x9C, 0x4B, 0x00, 0x20, 0x20, 0x00, 0xB1, 0x08, 0x4C, 0x00, 0x00,
    0x80, 0x20, 0x10, 0x0A, 0x00, 0x28, 0x10, 0x04, 0x02, 0x0D, 0xC0, 0x01, 0x04, 0x08, 0x00, 0x17,
    0x05, 0x10, 0x00, 0x13, 0x04, 0x10, 0x00, 0x11, 0x07, 0x10, 0x00, 0xE2, 0x02, 0x02, 0x01, 0x02,
    0x03, 0x00, 0x04, 0x05, 0xA3, 0x72, 0x0F, 0x0F, 0x00, 0x70, 0x42, 0x00, 0x16, 0x1F, 0x28, 0x01,
    0x43, 0xFF, 0x00, 0xFF, 0x01, 0xA4, 0x04, 0x04, 0x84, 0x03, 0x35, 0x00, 0x00, 0xF0, 0x24, 0x04,
    0x60, 0x43, 0xC3, 0xBA, 0xE4, 0xD3, 0x1E, 0x0F, 0x05, 0x3B, 0x80, 0x2A, 0x02, 0x1C, 0x00, 0x0C,
    0xF4, 0x00, 0x19, 0x08, 0x0E, 0x00, 0x01, 0xE6, 0x05, 0x1F, 0x03, 0x2C, 0x00, 0x05, 0x10, 0x76,
    0xE9, 0x03, 0x0F, 0x9C, 0x02, 0x00, 0x05, 0x34, 0x00, 0x0F, 0x3A, 0x00, 0x04, 0x38, 0x7E, 0x16,
    0x40, 0x03, 0x06, 0x0F, 0x38, 0x00, 0x17, 0x3F, 0x1E, 0x40, 0x04, 0xA8, 0x00, 0x08, 0x2F, 0x00,
    0xC0, 0x55, 0x00, 0x04, 0x3F, 0x46, 0x24, 0x00, 0x38, 0x00, 0x0A, 0x0F, 0x01, 0x00, 0x05, 0x22,
    0x46, 0x2C, 0x38, 0x00, 0x19, 0xEC, 0x16, 0x00, 0x0F, 0x3C, 0x01, 0x03, 0x0F, 0x38, 0x08, 0xC3,
    0x2F, 0x00, 0x00, 0x38, 0x08, 0x0B, 0x2F, 0xC5, 0xB3, 0x38, 0x08, 0x29, 0x1F, 0x00, 0x38, 0x08,
    0x84, 0x13, 0x05, 0x1C, 0x00, 0x08, 0x78, 0x05, 0x1F, 0x0D, 0x38, 0x08, 0xC7, 0x93, 0x88, 0x00,
    0x00, 0x02, 0x88, 0x00, 0x00, 0x0D, 0x88, 0x38, 0x08, 0xF2, 0x0A, 0x88, 0x00, 0x00, 0x0B, 0x88,
    0x5D, 0x5D, 0x0E, 0x8C, 0x5D, 0x5D, 0x0C, 0x88, 0x08, 0x08, 0x0D, 0x8C, 0x00, 0x00, 0x0D, 0x8C,
    0x16, 0x16, 0x16, 0x88, 0x2C, 0x00, 0x0F, 0x38, 0x08, 0x43, 0x1B, 0x02, 0x38, 0x08, 0x04, 0x30,
    0x08, 0x0F, 0x38, 0x08, 0x91, 0x1F, 0x28, 0x02, 0x00, 0x0C, 0x0F, 0x38, 0x08, 0x24, 0x14, 0x80,
    0x38, 0x08, 0x04, 0x20, 0x00, 0x0F, 0x38, 0x08, 0xFF, 0x1E, 0x7F, 0x80, 0x00, 0x40, 0x00, 0x04,
    0x10, 0x80, 0x38, 0x08, 0x82, 0x1F, 0x00, 0x38, 0x08, 0x09, 0x1F, 0x10, 0x38, 0x08, 0x1F, 0x1F,
    0x01, 0x38, 0x08, 0x00, 0x1F, 0x00, 0x38, 0x08, 0x36, 0x0E, 0xFC, 0x06, 0x0F, 0x38, 0x08, 0xFF,
    0x31, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
};

constexpr inline const u8 * const SdramParamsMariko2 = SdramParamsMariko2_3;
constexpr inline const size_t SdramParamsSizeMariko2 = sizeof(SdramParamsMariko2_3);

constexpr inline const u8 * const SdramParamsMariko3 = SdramParamsMariko2_3;
constexpr inline const size_t SdramParamsSizeMariko3 = sizeof(SdramParamsMariko2_3);

constexpr inline const u8 SdramParamsMariko4_5[0x3F5] = {
    0xFF, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x2C, 0x01,
    0x00, 0x01, 0x00, 0x96, 0x88, 0x02, 0x80, 0x18, 0x40, 0x00, 0x00, 0x00, 0x40, 0x14, 0x00, 0xF0,
    0x01, 0xFF, 0xFF, 0x1F, 0x00, 0xD8, 0x51, 0x1A, 0xA0, 0x00, 0x00, 0x50, 0x05, 0x00, 0x00, 0x88,
    0x00, 0x04, 0x00, 0x20, 0x20, 0x12, 0x1A, 0x00, 0x17, 0x88, 0x04, 0x00, 0xF7, 0x00, 0x00, 0x00,
    0xBC, 0xBC, 0xAF, 0xC9, 0x3C, 0x9E, 0x00, 0x00, 0x02, 0x03, 0xE0, 0xC1, 0x04, 0x01, 0x00, 0x17,
    0x3F, 0x01, 0x00, 0x00, 0x38, 0x00, 0xD0, 0x04, 0x08, 0x00, 0x00, 0x50, 0x50, 0x50, 0x00, 0xA1,
    0x01, 0x00, 0x00, 0x30, 0x39, 0x00, 0x62, 0x10, 0x00, 0x16, 0x00, 0x10, 0x90, 0x80, 0x00, 0x03,
    0x74, 0x00, 0x13, 0x03, 0x04, 0x00, 0xD7, 0x1E, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x3A,
    0x00, 0x00, 0x00, 0x1D, 0x94, 0x00, 0x57, 0x09, 0x00, 0x00, 0x00, 0x04, 0x10, 0x00, 0x13, 0x0B,
    0x28, 0x00, 0x13, 0x08, 0x0C, 0x00, 0x00, 0x1C, 0x00, 0x53, 0x17, 0x00, 0x00, 0x00, 0x15, 0x08,
    0x00, 0x13, 0x1B, 0x28, 0x00, 0x57, 0x20, 0x00, 0x00, 0x00, 0x06, 0x04, 0x00, 0x13, 0x03, 0x18,
    0x00, 0x13, 0x04, 0x10, 0x00, 0x17, 0x02, 0x10, 0x00, 0x00, 0x4C, 0x00, 0x53, 0x0E, 0x00, 0x00,
    0x00, 0x05, 0x1C, 0x00, 0x05, 0x24, 0x01, 0x03, 0x6C, 0x00, 0x03, 0xD7, 0x01, 0x10, 0x80, 0x0A,
    0x00, 0x00, 0x0F, 0x01, 0x93, 0x18, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x16, 0x0C, 0x00,
    0x10, 0x0A, 0x48, 0x00, 0x03, 0x61, 0x00, 0x13, 0xC1, 0x50, 0x00, 0x13, 0x08, 0x74, 0x00, 0x13,
    0x0A, 0x08, 0x00, 0x13, 0x14, 0x60, 0x00, 0x04, 0x54, 0x00, 0x13, 0x3B, 0x04, 0x00, 0x13, 0x05,
    0x04, 0x00, 0x13, 0x04, 0xEC, 0x00, 0x08, 0x0C, 0x00, 0x90, 0x1C, 0x03, 0x00, 0x00, 0x0D, 0xA0,
    0x60, 0x91, 0x3F, 0x15, 0x01, 0xF1, 0x28, 0x00, 0xF3, 0x0C, 0x04, 0x05, 0x1B, 0x06, 0x02, 0x03,
    0x07, 0x1C, 0x23, 0x25, 0x25, 0x05, 0x08, 0x1D, 0x09, 0x0A, 0x24, 0x0B, 0x1E, 0x0D, 0x0C, 0x26,
    0x26, 0x03, 0x02, 0x1B, 0x1C, 0x23, 0x03, 0x04, 0x07, 0x05, 0x06, 0x25, 0x25, 0x02, 0x0A, 0x0B,
    0x1D, 0x0D, 0x08, 0x0C, 0x09, 0x1E, 0x24, 0x26, 0x26, 0x08, 0x24, 0x06, 0x07, 0x9A, 0xBF, 0x01,
    0x3C, 0xFF, 0x00, 0xFF, 0x00, 0x02, 0xB0, 0x04, 0x00, 0x01, 0x88, 0x00, 0x00, 0x02, 0x88, 0x00,
    0x00, 0x0D, 0xD5, 0x01, 0xF2, 0x0E, 0xC0, 0x31, 0x31, 0x03, 0x88, 0x00, 0x00, 0x0B, 0x88, 0x5D,
    0x5D, 0x0E, 0x8C, 0x5D, 0x5D, 0x0C, 0x88, 0x08, 0x08, 0x0D, 0x8C, 0x00, 0x00, 0x0D, 0x8C, 0x14,
    0x14, 0x16, 0x88, 0x2C, 0x00, 0x2C, 0x11, 0x08, 0xDF, 0x02, 0x70, 0x10, 0x00, 0xCC, 0x00, 0x0A,
    0x00, 0x33, 0x6E, 0x01, 0x40, 0xF3, 0x25, 0x08, 0x11, 0x69, 0x00, 0x23, 0x0F, 0x00, 0x30, 0x01,
    0x80, 0x01, 0x03, 0x00, 0x70, 0x00, 0x0C, 0x00, 0x01, 0x0C, 0x00, 0xC0, 0x08, 0x44, 0x00, 0x10,
    0x04, 0x04, 0x00, 0x06, 0x13, 0x07, 0x00, 0x80, 0x10, 0x00, 0x71, 0xA0, 0x00, 0x2C, 0x00, 0x01,
    0x37, 0x0F, 0x52, 0x01, 0x00, 0x10, 0x01, 0xDB, 0x0C, 0x00, 0x04, 0x00, 0x1F, 0x22, 0x20, 0x80,
    0x0F, 0xF4, 0x20, 0x02, 0x29, 0x01, 0x00, 0x12, 0x78, 0x9A, 0x02, 0x1F, 0x0F, 0xF4, 0x02, 0x31,
    0x7F, 0x16, 0x00, 0x0D, 0x00, 0x0B, 0x00, 0x17, 0x18, 0x00, 0x06, 0xF1, 0x02, 0x43, 0x00, 0x45,
    0x00, 0x45, 0x00, 0x43, 0x00, 0x46, 0x00, 0x47, 0x00, 0x41, 0x00, 0x46, 0x00, 0x0C, 0xBA, 0x01,
    0x1F, 0x0D, 0x18, 0x00, 0x06, 0x1F, 0x28, 0x02, 0x00, 0x0C, 0x11, 0x16, 0x5A, 0x00, 0x00, 0x5C,
    0x00, 0x00, 0x5E, 0x00, 0x3F, 0x17, 0x00, 0x16, 0x94, 0x00, 0x00, 0x05, 0x54, 0x01, 0xB3, 0x40,
    0x06, 0x00, 0xCC, 0x00, 0x09, 0x00, 0x4F, 0x00, 0x51, 0x80, 0x18, 0x00, 0x04, 0x08, 0x00, 0x01,
    0x6E, 0x00, 0x54, 0xAB, 0x00, 0x0A, 0x04, 0x11, 0x5C, 0x01, 0x03, 0x04, 0x00, 0x0F, 0xE4, 0x03,
    0x0E, 0x07, 0x0C, 0x00, 0x04, 0xA8, 0x04, 0x01, 0x14, 0x00, 0x75, 0x01, 0x22, 0x04, 0xFF, 0x9F,
    0xAF, 0x4F, 0x10, 0x00, 0x07, 0x34, 0x00, 0x32, 0x9F, 0xFF, 0x37, 0x98, 0x00, 0xF0, 0x10, 0x32,
    0x54, 0x76, 0x10, 0x47, 0x32, 0x65, 0x10, 0x34, 0x76, 0x25, 0x01, 0x34, 0x67, 0x25, 0x01, 0x75,
    0x64, 0x32, 0x01, 0x72, 0x56, 0x34, 0x10, 0x23, 0x74, 0x56, 0x01, 0x45, 0x32, 0x67, 0x24, 0x00,
    0x31, 0x49, 0x92, 0x24, 0x04, 0x00, 0x0C, 0x01, 0x00, 0x13, 0x12, 0x04, 0x00, 0x0C, 0x90, 0x00,
    0x80, 0x20, 0x41, 0x13, 0x1F, 0x14, 0x00, 0x01, 0x00, 0x7C, 0x00, 0x85, 0xFF, 0xFF, 0xFF, 0x7F,
    0x1F, 0xD7, 0x36, 0x40, 0xE6, 0x03, 0x25, 0x34, 0x10, 0xF0, 0x03, 0x0F, 0xCC, 0x00, 0x01, 0x31,
    0x03, 0x00, 0x05, 0x2B, 0x03, 0x22, 0x10, 0x02, 0xDD, 0x03, 0x13, 0x21, 0x15, 0x04, 0x14, 0x40,
    0x8B, 0x02, 0x07, 0x01, 0x00, 0x71, 0x80, 0x00, 0x40, 0x00, 0x04, 0x10, 0x80, 0x04, 0x04, 0xCF,
    0x81, 0x10, 0x09, 0x28, 0x93, 0x32, 0xA5, 0x44, 0x5B, 0x8A, 0x67, 0x76, 0x54, 0x05, 0x4D, 0x22,
    0x10, 0x10, 0x04, 0x00, 0x44, 0x00, 0xEF, 0x00, 0xEF, 0x14, 0x00, 0x4D, 0x1C, 0x1C, 0x1C, 0x1C,
    0x98, 0x01, 0x21, 0x03, 0x08, 0x04, 0x00, 0xF1, 0x03, 0x00, 0x24, 0xFF, 0xFF, 0x00, 0x44, 0x57,
    0x6E, 0x00, 0x28, 0x72, 0x39, 0x00, 0x10, 0x9C, 0x4B, 0x00, 0x10, 0xA4, 0x01, 0xB2, 0x08, 0x4C,
    0x00, 0x00, 0x80, 0x20, 0x10, 0x0A, 0x00, 0x28, 0x10, 0x30, 0x03, 0x0C, 0xC0, 0x01, 0x04, 0x08,
    0x00, 0x17, 0x05, 0x0C, 0x02, 0x13, 0x04, 0x10, 0x00, 0x12, 0x07, 0x62, 0x00, 0xD2, 0x02, 0x01,
    0x02, 0x03, 0x00, 0x04, 0x05, 0xA3, 0x72, 0x0F, 0x0F, 0x00, 0x70, 0x42, 0x00, 0x16, 0x1F, 0x28,
    0x01, 0x43, 0xFF, 0x00, 0xFF, 0x01, 0xA4, 0x04, 0x24, 0x00, 0x80, 0x96, 0x00, 0x15, 0xF0, 0x24,
    0x04, 0x60, 0x43, 0xC3, 0xBA, 0xE4, 0xD3, 0x1E, 0x0B, 0x05, 0x3B, 0x80, 0x2A, 0x02, 0x1C, 0x00,
    0x0C, 0xF4, 0x00, 0x19, 0x08, 0x0E, 0x00, 0x01, 0xE6, 0x05, 0x1F, 0x03, 0x2C, 0x00, 0x05, 0x10,
    0x76, 0xE9, 0x03, 0x0F, 0x9C, 0x02, 0x00, 0x05, 0x34, 0x00, 0x0F, 0x3A, 0x00, 0x04, 0x38, 0x7E,
    0x16, 0x40, 0x03, 0x06, 0x0F, 0x38, 0x00, 0x17, 0x3F, 0x1E, 0x40, 0x04, 0xA8, 0x00, 0x08, 0x2F,
    0x00, 0xC0, 0x55, 0x00, 0x04, 0x3F, 0x46, 0x24, 0x00, 0x38, 0x00, 0x0A, 0x0F, 0x01, 0x00, 0x05,
    0x22, 0x46, 0x2C, 0x38, 0x00, 0x19, 0xEC, 0x16, 0x00, 0x0F, 0x3C, 0x01, 0x03, 0x0F, 0x38, 0x08,
    0xFF, 0xFF, 0xFF, 0x40, 0x13, 0x32, 0x01, 0x00, 0x0F, 0x38, 0x08, 0x41, 0x3E, 0x18, 0x00, 0x0F,
    0x38, 0x08, 0x07, 0x18, 0x00, 0x93, 0x48, 0x00, 0x44, 0x00, 0x45, 0x00, 0x44, 0x00, 0x47, 0x20,
    0x08, 0x11, 0x0D, 0x8E, 0x01, 0x1F, 0x0D, 0x18, 0x00, 0x06, 0x1F, 0x78, 0x02, 0x00, 0x0C, 0x11,
    0x18, 0x5A, 0x00, 0x15, 0x0F, 0x38, 0x08, 0x1F, 0x18, 0x38, 0x08, 0xFF, 0xFF, 0xFF, 0xF6, 0x50,
    0x00, 0x00, 0x00, 0x00, 0x00,
};

constexpr inline const u8 * const SdramParamsMariko4 = SdramParamsMariko4_5;
constexpr inline const size_t SdramParamsSizeMariko4 = sizeof(SdramParamsMariko4_5);

constexpr inline const u8 * const SdramParamsMariko5 = SdramParamsMariko4_5;
constexpr inline const size_t SdramParamsSizeMariko5 = sizeof(SdramParamsMariko4_5);

constexpr inline const u8 SdramParamsMariko6_7[0x425] = {
    0xFF, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x2C, 0x01,
    0x00, 0x01, 0x00, 0x96, 0x88, 0x02, 0x80, 0x18, 0x40, 0x00, 0x00, 0x00, 0x40, 0x14, 0x00, 0xF0,
    0x01, 0xFF, 0xFF, 0x1F, 0x00, 0xD8, 0x51, 0x1A, 0xA0, 0x00, 0x00, 0x50, 0x05, 0x00, 0x00, 0x88,
    0x00, 0x04, 0x00, 0x20, 0x20, 0x12, 0x1A, 0x00, 0x17, 0x88, 0x04, 0x00, 0xF7, 0x00, 0x00, 0x00,
    0xBC, 0xBC, 0xAF, 0xC9, 0x3C, 0x9E, 0x00, 0x00, 0x02, 0x03, 0xE0, 0xC1, 0x04, 0x01, 0x00, 0x17,
    0x3F, 0x01, 0x00, 0x00, 0x38, 0x00, 0xD0, 0x04, 0x08, 0x00, 0x00, 0x50, 0x50, 0x50, 0x00, 0xA1,
    0x01, 0x00, 0x00, 0x30, 0x39, 0x00, 0x62, 0x10, 0x00, 0x16, 0x00, 0x10, 0x90, 0x80, 0x00, 0x03,
    0x74, 0x00, 0x13, 0x03, 0x04, 0x00, 0xD7, 0x1E, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x3A,
    0x00, 0x00, 0x00, 0x1D, 0x94, 0x00, 0x57, 0x09, 0x00, 0x00, 0x00, 0x04, 0x10, 0x00, 0x13, 0x0B,
    0x28, 0x00, 0x13, 0x08, 0x0C, 0x00, 0x00, 0x1C, 0x00, 0x53, 0x17, 0x00, 0x00, 0x00, 0x15, 0x08,
    0x00, 0x13, 0x1B, 0x28, 0x00, 0x57, 0x20, 0x00, 0x00, 0x00, 0x06, 0x04, 0x00, 0x13, 0x03, 0x18,
    0x00, 0x13, 0x04, 0x10, 0x00, 0x17, 0x02, 0x10, 0x00, 0x00, 0x4C, 0x00, 0x13, 0x0E, 0x18, 0x00,
    0x17, 0x05, 0x6C, 0x00, 0x00, 0x34, 0x00, 0x13, 0x0C, 0xE0, 0x01, 0x40, 0x00, 0x00, 0x00, 0x80,
    0x0A, 0x00, 0x00, 0x0F, 0x01, 0x93, 0x18, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x16, 0x0C,
    0x00, 0x10, 0x0A, 0x48, 0x00, 0x03, 0x61, 0x00, 0x13, 0xC1, 0x50, 0x00, 0x13, 0x08, 0x40, 0x00,
    0x13, 0x0A, 0x08, 0x00, 0x13, 0x14, 0x5C, 0x00, 0x13, 0x02, 0xC0, 0x00, 0x13, 0x3B, 0x04, 0x00,
    0x13, 0x05, 0x04, 0x00, 0x13, 0x04, 0xEC, 0x00, 0x08, 0x0C, 0x00, 0x90, 0x1C, 0x03, 0x00, 0x00,
    0x0D, 0xA0, 0x60, 0x91, 0x3F, 0x15, 0x01, 0xF1, 0x28, 0x00, 0xF3, 0x0C, 0x04, 0x05, 0x1B, 0x06,
    0x02, 0x03, 0x07, 0x1C, 0x23, 0x25, 0x25, 0x05, 0x08, 0x1D, 0x09, 0x0A, 0x24, 0x0B, 0x1E, 0x0D,
    0x0C, 0x26, 0x26, 0x03, 0x02, 0x1B, 0x1C, 0x23, 0x03, 0x04, 0x07, 0x05, 0x06, 0x25, 0x25, 0x02,
    0x0A, 0x0B, 0x1D, 0x0D, 0x08, 0x0C, 0x09, 0x1E, 0x24, 0x26, 0x26, 0x08, 0x24, 0x06, 0x07, 0x9A,
    0xBF, 0x01, 0x3C, 0xFF, 0x00, 0xFF, 0x00, 0x02, 0xB0, 0x04, 0x00, 0x01, 0x88, 0x00, 0x00, 0x02,
    0x88, 0x00, 0x00, 0x0D, 0xD5, 0x01, 0xF2, 0x0E, 0xC0, 0x31, 0x31, 0x03, 0x88, 0x00, 0x00, 0x0B,
    0x88, 0x5D, 0x5D, 0x0E, 0x8C, 0x5D, 0x5D, 0x0C, 0x88, 0x08, 0x08, 0x0D, 0x8C, 0x00, 0x00, 0x0D,
    0x8C, 0x14, 0x14, 0x16, 0x88, 0x2C, 0x00, 0x2C, 0x11, 0x08, 0xDF, 0x02, 0x70, 0x10, 0x00, 0xCC,
    0x00, 0x0A, 0x00, 0x33, 0x6E, 0x01, 0x40, 0xF3, 0x25, 0x08, 0x11, 0x69, 0x00, 0x23, 0x0F, 0x00,
    0x30, 0x01, 0x80, 0x01, 0x03, 0x00, 0x70, 0x00, 0x0C, 0x00, 0x01, 0x0C, 0x00, 0xC0, 0x08, 0x44,
    0x00, 0x10, 0x04, 0x04, 0x00, 0x06, 0x13, 0x07, 0x00, 0x80, 0x10, 0x00, 0x71, 0xA0, 0x00, 0x2C,
    0x00, 0x01, 0x37, 0x0F, 0x52, 0x01, 0x11, 0x02, 0x64, 0x01, 0xBB, 0x04, 0x00, 0x1F, 0x22, 0x20,
    0x80, 0x0F, 0xF4, 0x20, 0x02, 0x29, 0x01, 0x00, 0x12, 0x78, 0x9A, 0x02, 0x1F, 0x0F, 0xF4, 0x02,
    0x31, 0x7F, 0x16, 0x00, 0x0D, 0x00, 0x0B, 0x00, 0x17, 0x18, 0x00, 0x06, 0xF1, 0x02, 0x43, 0x00,
    0x45, 0x00, 0x45, 0x00, 0x43, 0x00, 0x46, 0x00, 0x47, 0x00, 0x41, 0x00, 0x46, 0x00, 0x0C, 0xBA,
    0x01, 0x1F, 0x0D, 0x18, 0x00, 0x06, 0x1F, 0x28, 0x02, 0x00, 0x0C, 0x11, 0x16, 0x5A, 0x00, 0x00,
    0x5C, 0x00, 0x00, 0x5E, 0x00, 0x3F, 0x17, 0x00, 0x16, 0x94, 0x00, 0x00, 0x05, 0x54, 0x01, 0xB3,
    0x40, 0x06, 0x00, 0xCC, 0x00, 0x09, 0x00, 0x4F, 0x00, 0x51, 0x80, 0x18, 0x00, 0x04, 0x08, 0x00,
    0x01, 0x6E, 0x00, 0x54, 0xAB, 0x00, 0x0A, 0x04, 0x11, 0x5C, 0x01, 0x03, 0x04, 0x00, 0x0F, 0xE4,
    0x03, 0x0E, 0x0B, 0xCC, 0x02, 0x14, 0x01, 0x14, 0x00, 0x75, 0x01, 0x22, 0x04, 0xFF, 0x9F, 0xAF,
    0x4F, 0x10, 0x00, 0x07, 0x34, 0x00, 0x32, 0x9F, 0xFF, 0x37, 0x98, 0x00, 0xF0, 0x10, 0x32, 0x54,
    0x76, 0x10, 0x47, 0x32, 0x65, 0x10, 0x34, 0x76, 0x25, 0x01, 0x34, 0x67, 0x25, 0x01, 0x75, 0x64,
    0x32, 0x01, 0x72, 0x56, 0x34, 0x10, 0x23, 0x74, 0x56, 0x01, 0x45, 0x32, 0x67, 0x24, 0x00, 0x31,
    0x49, 0x92, 0x24, 0x04, 0x00, 0x0C, 0x01, 0x00, 0x13, 0x12, 0x04, 0x00, 0x0C, 0x90, 0x00, 0x80,
    0x20, 0x41, 0x13, 0x1F, 0x14, 0x00, 0x01, 0x00, 0x7C, 0x00, 0x85, 0xFF, 0xFF, 0xFF, 0x7F, 0x1F,
    0xD7, 0x36, 0x40, 0xE6, 0x03, 0x25, 0x34, 0x10, 0xF0, 0x03, 0x0F, 0xCC, 0x00, 0x01, 0x31, 0x03,
    0x00, 0x05, 0x2B, 0x03, 0x22, 0x10, 0x02, 0xDD, 0x03, 0x13, 0x21, 0x15, 0x04, 0x14, 0x40, 0x8B,
    0x02, 0x07, 0x01, 0x00, 0x71, 0x80, 0x00, 0x40, 0x00, 0x04, 0x10, 0x80, 0x04, 0x04, 0xCF, 0x81,
    0x10, 0x09, 0x28, 0x93, 0x32, 0xA5, 0x44, 0x5B, 0x8A, 0x67, 0x76, 0x54, 0x05, 0x4D, 0x22, 0x10,
    0x10, 0x04, 0x00, 0x44, 0x00, 0xEF, 0x00, 0xEF, 0x14, 0x00, 0x4D, 0x1C, 0x1C, 0x1C, 0x1C, 0x98,
    0x01, 0x21, 0x03, 0x08, 0x04, 0x00, 0xF1, 0x03, 0x00, 0x24, 0xFF, 0xFF, 0x00, 0x44, 0x57, 0x6E,
    0x00, 0x28, 0x72, 0x39, 0x00, 0x10, 0x9C, 0x4B, 0x00, 0x10, 0xA4, 0x01, 0xB2, 0x08, 0x4C, 0x00,
    0x00, 0x80, 0x20, 0x10, 0x0A, 0x00, 0x28, 0x10, 0x30, 0x03, 0x0C, 0xC0, 0x01, 0x04, 0x08, 0x00,
    0x17, 0x05, 0x0C, 0x02, 0x13, 0x04, 0x10, 0x00, 0x12, 0x07, 0x62, 0x00, 0xD2, 0x02, 0x01, 0x02,
    0x03, 0x00, 0x04, 0x05, 0xA3, 0x72, 0x0F, 0x0F, 0x00, 0x70, 0x42, 0x00, 0x16, 0x1F, 0x28, 0x01,
    0x43, 0xFF, 0x00, 0xFF, 0x01, 0xA4, 0x04, 0x24, 0x00, 0x80, 0x96, 0x00, 0x15, 0xF0, 0x24, 0x04,
    0x60, 0x43, 0xC3, 0xBA, 0xE4, 0xD3, 0x1E, 0x0F, 0x05, 0x3B, 0x80, 0x2A, 0x02, 0x1C, 0x00, 0x0C,
    0xF4, 0x00, 0x19, 0x08, 0x0E, 0x00, 0x01, 0xE6, 0x05, 0x1F, 0x03, 0x2C, 0x00, 0x05, 0x10, 0x76,
    0xE9, 0x03, 0x0F, 0x9C, 0x02, 0x00, 0x05, 0x34, 0x00, 0x0F, 0x3A, 0x00, 0x04, 0x38, 0x7E, 0x16,
    0x40, 0x03, 0x06, 0x0F, 0x38, 0x00, 0x17, 0x3F, 0x1E, 0x40, 0x04, 0xA8, 0x00, 0x08, 0x2F, 0x00,
    0xC0, 0x55, 0x00, 0x04, 0x3F, 0x46, 0x24, 0x00, 0x38, 0x00, 0x0A, 0x0F, 0x01, 0x00, 0x05, 0x22,
    0x46, 0x2C, 0x38, 0x00, 0x19, 0xEC, 0x16, 0x00, 0x0F, 0x3C, 0x01, 0x03, 0x0F, 0x38, 0x08, 0xFF,
    0x22, 0x1F, 0x01, 0x38, 0x08, 0xFF, 0x05, 0x1F, 0x08, 0x38, 0x08, 0x5B, 0x93, 0x08, 0x00, 0x00,
    0x02, 0x08, 0x00, 0x00, 0x0D, 0x08, 0x38, 0x08, 0xF2, 0x0A, 0x08, 0x00, 0x00, 0x0B, 0x08, 0x5D,
    0x5D, 0x0E, 0x0C, 0x5D, 0x5D, 0x0C, 0x08, 0x08, 0x08, 0x0D, 0x0C, 0x00, 0x00, 0x0D, 0x0C, 0x14,
    0x14, 0x16, 0x08, 0x2C, 0x00, 0x0F, 0x38, 0x08, 0x32, 0x1C, 0x00, 0x38, 0x08, 0x1F, 0x00, 0x38,
    0x08, 0xFF, 0x00, 0x04, 0x18, 0x00, 0x00, 0x34, 0x06, 0x1F, 0x40, 0x38, 0x08, 0xFF, 0x22, 0x04,
    0x12, 0x00, 0x0F, 0x38, 0x08, 0x81, 0x1F, 0x01, 0x38, 0x08, 0x09, 0x1F, 0x20, 0x38, 0x08, 0x0F,
    0x1B, 0x01, 0x38, 0x08, 0x1F, 0x02, 0x38, 0x08, 0x00, 0x1F, 0x01, 0x38, 0x08, 0xFF, 0x8C, 0x50,
    0x00, 0x00, 0x00, 0x00, 0x00,
};

constexpr inline const u8 * const SdramParamsMariko6 = SdramParamsMariko6_7;
constexpr inline const size_t SdramParamsSizeMariko6 = sizeof(SdramParamsMariko6_7);

constexpr inline const u8 * const SdramParamsMariko7 = SdramParamsMariko6_7;
constexpr inline const size_t SdramParamsSizeMariko7 = sizeof(SdramParamsMariko6_7);

constexpr inline const u8 SdramParamsMariko8_9[0x426] = {
    0xFF, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x2C, 0x01,
    0x00, 0x01, 0x00, 0x96, 0x88, 0x02, 0x80, 0x18, 0x40, 0x00, 0x00, 0x00, 0x40, 0x14, 0x00, 0xF0,
    0x01, 0xFF, 0xFF, 0x1F, 0x00, 0xD8, 0x51, 0x1A, 0xA0, 0x00, 0x00, 0x50, 0x05, 0x00, 0x00, 0x88,
    0x00, 0x04, 0x00, 0x20, 0x20, 0x12, 0x1A, 0x00, 0x17, 0x88, 0x04, 0x00, 0xF7, 0x00, 0x00, 0x00,
    0xBC, 0xBC, 0xAF, 0xC9, 0x3C, 0x9E, 0x00, 0x00, 0x02, 0x03, 0xE0, 0xC1, 0x04, 0x01, 0x00, 0x17,
    0x3F, 0x01, 0x00, 0x00, 0x38, 0x00, 0xD0, 0x04, 0x08, 0x00, 0x00, 0x50, 0x50, 0x50, 0x00, 0xA1,
    0x01, 0x00, 0x00, 0x30, 0x39, 0x00, 0x62, 0x10, 0x00, 0x16, 0x00, 0x10, 0x90, 0x80, 0x00, 0x03,
    0x74, 0x00, 0x13, 0x03, 0x04, 0x00, 0xD7, 0x1E, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x3A,
    0x00, 0x00, 0x00, 0x1D, 0x94, 0x00, 0x57, 0x09, 0x00, 0x00, 0x00, 0x04, 0x10, 0x00, 0x13, 0x0B,
    0x28, 0x00, 0x13, 0x08, 0x0C, 0x00, 0x00, 0x1C, 0x00, 0x53, 0x17, 0x00, 0x00, 0x00, 0x15, 0x08,
    0x00, 0x13, 0x1B, 0x28, 0x00, 0x57, 0x20, 0x00, 0x00, 0x00, 0x06, 0x04, 0x00, 0x13, 0x03, 0x18,
    0x00, 0x13, 0x04, 0x10, 0x00, 0x17, 0x02, 0x10, 0x00, 0x00, 0x4C, 0x00, 0x53, 0x0E, 0x00, 0x00,
    0x00, 0x05, 0x1C, 0x00, 0x05, 0x24, 0x01, 0x03, 0x6C, 0x00, 0x03, 0xD7, 0x01, 0x10, 0x80, 0x0A,
    0x00, 0x00, 0x0F, 0x01, 0x93, 0x18, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x16, 0x0C, 0x00,
    0x10, 0x0A, 0x48, 0x00, 0x03, 0x61, 0x00, 0x13, 0xC1, 0x50, 0x00, 0x13, 0x08, 0x74, 0x00, 0x13,
    0x0A, 0x08, 0x00, 0x13, 0x14, 0x60, 0x00, 0x04, 0x54, 0x00, 0x13, 0x3B, 0x04, 0x00, 0x13, 0x05,
    0x04, 0x00, 0x04, 0x88, 0x00, 0x04, 0x0C, 0x00, 0x00, 0xF8, 0x00, 0x90, 0x1C, 0x03, 0x00, 0x00,
    0x0D, 0xA0, 0x60, 0x91, 0x3F, 0x15, 0x01, 0xF1, 0x28, 0x00, 0xF3, 0x0C, 0x04, 0x05, 0x1B, 0x06,
    0x02, 0x03, 0x07, 0x1C, 0x23, 0x25, 0x25, 0x05, 0x08, 0x1D, 0x09, 0x0A, 0x24, 0x0B, 0x1E, 0x0D,
    0x0C, 0x26, 0x26, 0x03, 0x02, 0x1B, 0x1C, 0x23, 0x03, 0x04, 0x07, 0x05, 0x06, 0x25, 0x25, 0x02,
    0x0A, 0x0B, 0x1D, 0x0D, 0x08, 0x0C, 0x09, 0x1E, 0x24, 0x26, 0x26, 0x08, 0x24, 0x06, 0x07, 0x9A,
    0xBF, 0x01, 0x3C, 0xFF, 0x00, 0xFF, 0x00, 0x02, 0xB0, 0x04, 0x00, 0x01, 0x88, 0x00, 0x00, 0x02,
    0x88, 0x00, 0x00, 0x0D, 0xD5, 0x01, 0xF2, 0x0E, 0xC0, 0x31, 0x31, 0x03, 0x88, 0x00, 0x00, 0x0B,
    0x88, 0x5D, 0x5D, 0x0E, 0x8C, 0x5D, 0x5D, 0x0C, 0x88, 0x08, 0x08, 0x0D, 0x8C, 0x00, 0x00, 0x0D,
    0x8C, 0x14, 0x14, 0x16, 0x88, 0x2C, 0x00, 0x2C, 0x11, 0x08, 0xDF, 0x02, 0x70, 0x10, 0x00, 0xCC,
    0x00, 0x0A, 0x00, 0x33, 0x6E, 0x01, 0x40, 0xF3, 0x25, 0x08, 0x11, 0x69, 0x00, 0x23, 0x0F, 0x00,
    0x30, 0x01, 0x80, 0x01, 0x03, 0x00, 0x70, 0x00, 0x0C, 0x00, 0x01, 0x0C, 0x00, 0xC0, 0x08, 0x44,
    0x00, 0x10, 0x04, 0x04, 0x00, 0x06, 0x13, 0x07, 0x00, 0x80, 0x10, 0x00, 0x71, 0xA0, 0x00, 0x2C,
    0x00, 0x01, 0x37, 0x0F, 0x52, 0x01, 0x00, 0x10, 0x01, 0xDB, 0x0C, 0x00, 0x04, 0x00, 0x1F, 0x22,
    0x20, 0x80, 0x0F, 0xF4, 0x20, 0x02, 0x29, 0x01, 0x00, 0x12, 0x78, 0x9A, 0x02, 0x1F, 0x0F, 0xF4,
    0x02, 0x31, 0x7F, 0x18, 0x00, 0x0F, 0x00, 0x0B, 0x00, 0x17, 0x18, 0x00, 0x06, 0xF1, 0x02, 0x48,
    0x00, 0x44, 0x00, 0x45, 0x00, 0x44, 0x00, 0x47, 0x00, 0x47, 0x00, 0x41, 0x00, 0x46, 0x00, 0x0D,
    0x8E, 0x01, 0x1F, 0x0D, 0x18, 0x00, 0x06, 0x1F, 0x28, 0x02, 0x00, 0x0C, 0x11, 0x18, 0x5A, 0x00,
    0x00, 0x5C, 0x00, 0x00, 0x5E, 0x00, 0x3F, 0x17, 0x00, 0x18, 0x94, 0x00, 0x00, 0x05, 0x54, 0x01,
    0xB3, 0x40, 0x06, 0x00, 0xCC, 0x00, 0x09, 0x00, 0x4F, 0x00, 0x51, 0x80, 0x18, 0x00, 0x04, 0x08,
    0x00, 0x01, 0x40, 0x02, 0x54, 0xAB, 0x00, 0x0A, 0x04, 0x11, 0x5C, 0x01, 0x03, 0x04, 0x00, 0x0F,
    0xE4, 0x03, 0x0E, 0x07, 0x0C, 0x00, 0x04, 0xA8, 0x04, 0x01, 0x14, 0x00, 0x75, 0x01, 0x22, 0x04,
    0xFF, 0x9F, 0xAF, 0x4F, 0x10, 0x00, 0x07, 0x34, 0x00, 0x32, 0x9F, 0xFF, 0x37, 0x98, 0x00, 0xF0,
    0x10, 0x32, 0x54, 0x76, 0x10, 0x47, 0x32, 0x65, 0x10, 0x34, 0x76, 0x25, 0x01, 0x34, 0x67, 0x25,
    0x01, 0x75, 0x64, 0x32, 0x01, 0x72, 0x56, 0x34, 0x10, 0x23, 0x74, 0x56, 0x01, 0x45, 0x32, 0x67,
    0x24, 0x00, 0x31, 0x49, 0x92, 0x24, 0x04, 0x00, 0x0C, 0x01, 0x00, 0x13, 0x12, 0x04, 0x00, 0x0C,
    0x90, 0x00, 0x80, 0x20, 0x41, 0x13, 0x1F, 0x14, 0x00, 0x01, 0x00, 0x7C, 0x00, 0x85, 0xFF, 0xFF,
    0xFF, 0x7F, 0x1F, 0xD7, 0x36, 0x40, 0xE6, 0x03, 0x25, 0x34, 0x10, 0xF0, 0x03, 0x0F, 0xCC, 0x00,
    0x01, 0x31, 0x03, 0x00, 0x05, 0x2B, 0x03, 0x22, 0x10, 0x02, 0xDD, 0x03, 0x13, 0x21, 0x15, 0x04,
    0x14, 0x40, 0x8B, 0x02, 0x07, 0x01, 0x00, 0x71, 0x80, 0x00, 0x40, 0x00, 0x04, 0x10, 0x80, 0x04,
    0x04, 0xCF, 0x81, 0x10, 0x09, 0x28, 0x93, 0x32, 0xA5, 0x44, 0x5B, 0x8A, 0x67, 0x76, 0x54, 0x05,
    0x4D, 0x22, 0x10, 0x10, 0x04, 0x00, 0x44, 0x00, 0xEF, 0x00, 0xEF, 0x14, 0x00, 0x4D, 0x1C, 0x1C,
    0x1C, 0x1C, 0x98, 0x01, 0x21, 0x03, 0x08, 0x04, 0x00, 0xF1, 0x03, 0x00, 0x24, 0xFF, 0xFF, 0x00,
    0x44, 0x57, 0x6E, 0x00, 0x28, 0x72, 0x39, 0x00, 0x10, 0x9C, 0x4B, 0x00, 0x10, 0xA4, 0x01, 0xB2,
    0x08, 0x4C, 0x00, 0x00, 0x80, 0x20, 0x10, 0x0A, 0x00, 0x28, 0x10, 0x30, 0x03, 0x08, 0xC0, 0x01,
    0x17, 0x01, 0xC8, 0x01, 0x17, 0x05, 0x10, 0x00, 0x13, 0x04, 0x10, 0x00, 0x12, 0x07, 0x62, 0x00,
    0xD2, 0x02, 0x01, 0x02, 0x03, 0x00, 0x04, 0x05, 0xA3, 0x72, 0x0F, 0x0F, 0x00, 0x70, 0x42, 0x00,
    0x16, 0x1F, 0x28, 0x01, 0x43, 0xFF, 0x00, 0xFF, 0x01, 0x70, 0x04, 0x24, 0x00, 0x80, 0x96, 0x00,
    0x15, 0xF0, 0x24, 0x04, 0x60, 0x43, 0xC3, 0xBA, 0xE4, 0xD3, 0x1E, 0x0B, 0x05, 0x3B, 0x80, 0x2A,
    0x02, 0x1C, 0x00, 0x0C, 0xF4, 0x00, 0x19, 0x08, 0x0E, 0x00, 0x01, 0xE6, 0x05, 0x1F, 0x03, 0x2C,
    0x00, 0x05, 0x10, 0x76, 0xE9, 0x03, 0x0F, 0x9C, 0x02, 0x00, 0x05, 0x34, 0x00, 0x0F, 0x3A, 0x00,
    0x04, 0x38, 0x7E, 0x16, 0x40, 0x03, 0x06, 0x0F, 0x38, 0x00, 0x17, 0x3F, 0x1E, 0x40, 0x04, 0xA8,
    0x00, 0x08, 0x2F, 0x00, 0xC0, 0x55, 0x00, 0x04, 0x3F, 0x46, 0x24, 0x00, 0x38, 0x00, 0x0A, 0x0F,
    0x01, 0x00, 0x05, 0x22, 0x46, 0x2C, 0x38, 0x00, 0x19, 0xEC, 0x16, 0x00, 0x0F, 0x3C, 0x01, 0x03,
    0x0F, 0x38, 0x08, 0xFF, 0x22, 0x1F, 0x01, 0x38, 0x08, 0xFF, 0x74, 0x93, 0x08, 0x00, 0x00, 0x02,
    0x08, 0x00, 0x00, 0x0D, 0x08, 0x38, 0x08, 0xF2, 0x0A, 0x08, 0x00, 0x00, 0x0B, 0x08, 0x5D, 0x5D,
    0x0E, 0x0C, 0x5D, 0x5D, 0x0C, 0x08, 0x08, 0x08, 0x0D, 0x0C, 0x00, 0x00, 0x0D, 0x0C, 0x14, 0x14,
    0x16, 0x08, 0x2C, 0x00, 0x0F, 0x38, 0x08, 0x32, 0x1C, 0x00, 0x38, 0x08, 0x1B, 0x00, 0x38, 0x08,
    0x13, 0x32, 0x01, 0x00, 0x0F, 0x38, 0x08, 0xE8, 0x04, 0x18, 0x00, 0x00, 0x34, 0x06, 0x1F, 0x40,
    0x38, 0x08, 0xFF, 0x22, 0x04, 0x12, 0x00, 0x0F, 0x38, 0x08, 0x81, 0x1F, 0x01, 0x38, 0x08, 0x09,
    0x1F, 0x20, 0x38, 0x08, 0x1F, 0x1F, 0x02, 0x38, 0x08, 0x00, 0x1F, 0x01, 0x38, 0x08, 0xFF, 0x8C,
    0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
};

constexpr inline const u8 * const SdramParamsMariko8 = SdramParamsMariko8_9;
constexpr inline const size_t SdramParamsSizeMariko8 = sizeof(SdramParamsMariko8_9);

constexpr inline const u8 * const SdramParamsMariko9 = SdramParamsMariko8_9;
constexpr inline const size_t SdramParamsSizeMariko9 = sizeof(SdramParamsMariko8_9);

constexpr inline const u8 SdramParamsMariko10_11[0x3D0] = {
    0xFF, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x2C, 0x01,
    0x00, 0x01, 0x00, 0x96, 0x88, 0x02, 0x80, 0x18, 0x40, 0x00, 0x00, 0x00, 0x40, 0x14, 0x00, 0xF0,
    0x01, 0xFF, 0xFF, 0x1F, 0x00, 0xD8, 0x51, 0x1A, 0xA0, 0x00, 0x00, 0x50, 0x05, 0x00, 0x00, 0x88,
    0x00, 0x04, 0x00, 0x20, 0x20, 0x12, 0x1A, 0x00, 0x17, 0x88, 0x04, 0x00, 0xF7, 0x00, 0x00, 0x00,
    0xBC, 0xBC, 0xAF, 0xC9, 0x3C, 0x9E, 0x00, 0x00, 0x02, 0x03, 0xE0, 0xC1, 0x04, 0x01, 0x00, 0x17,
    0x3F, 0x01, 0x00, 0x00, 0x38, 0x00, 0xD0, 0x04, 0x08, 0x00, 0x00, 0x50, 0x50, 0x50, 0x00, 0xA1,
    0x01, 0x00, 0x00, 0x30, 0x39, 0x00, 0x62, 0x10, 0x00, 0x16, 0x00, 0x10, 0x90, 0x80, 0x00, 0x03,
    0x74, 0x00, 0x13, 0x03, 0x04, 0x00, 0xD7, 0x1E, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x3A,
    0x00, 0x00, 0x00, 0x1D, 0x94, 0x00, 0x57, 0x09, 0x00, 0x00, 0x00, 0x04, 0x10, 0x00, 0x13, 0x0B,
    0x28, 0x00, 0x13, 0x08, 0x0C, 0x00, 0x00, 0x1C, 0x00, 0x53, 0x17, 0x00, 0x00, 0x00, 0x15, 0x08,
    0x00, 0x13, 0x1B, 0x28, 0x00, 0x57, 0x20, 0x00, 0x00, 0x00, 0x06, 0x04, 0x00, 0x13, 0x03, 0x18,
    0x00, 0x13, 0x04, 0x10, 0x00, 0x17, 0x02, 0x10, 0x00, 0x00, 0x4C, 0x00, 0x13, 0x0E, 0x18, 0x00,
    0x17, 0x05, 0x6C, 0x00, 0x00, 0x34, 0x00, 0x13, 0x0C, 0xE0, 0x01, 0x40, 0x00, 0x00, 0x00, 0x80,
    0x0A, 0x00, 0x00, 0x0F, 0x01, 0x93, 0x18, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x16, 0x0C,
    0x00, 0x10, 0x0A, 0x48, 0x00, 0x03, 0x61, 0x00, 0x13, 0xC1, 0x50, 0x00, 0x13, 0x08, 0x40, 0x00,
    0x13, 0x0A, 0x08, 0x00, 0x13, 0x14, 0x5C, 0x00, 0x13, 0x02, 0xC0, 0x00, 0x13, 0x3B, 0x04, 0x00,
    0x13, 0x05, 0x04, 0x00, 0x13, 0x04, 0xEC, 0x00, 0x08, 0x0C, 0x00, 0x90, 0x1C, 0x03, 0x00, 0x00,
    0x0D, 0xA0, 0x60, 0x91, 0x3F, 0x15, 0x01, 0xF1, 0x28, 0x00, 0xF3, 0x0C, 0x04, 0x05, 0x1B, 0x06,
    0x02, 0x03, 0x07, 0x1C, 0x23, 0x25, 0x25, 0x05, 0x08, 0x1D, 0x09, 0x0A, 0x24, 0x0B, 0x1E, 0x0D,
    0x0C, 0x26, 0x26, 0x03, 0x02, 0x1B, 0x1C, 0x23, 0x03, 0x04, 0x07, 0x05, 0x06, 0x25, 0x25, 0x02,
    0x0A, 0x0B, 0x1D, 0x0D, 0x08, 0x0C, 0x09, 0x1E, 0x24, 0x26, 0x26, 0x08, 0x24, 0x06, 0x07, 0x9A,
    0xBF, 0x01, 0x3C, 0xFF, 0x00, 0xFF, 0x00, 0x02, 0xB0, 0x04, 0x00, 0x01, 0x88, 0x00, 0x00, 0x02,
    0x88, 0x00, 0x00, 0x0D, 0xD5, 0x01, 0xF2, 0x0E, 0xC0, 0x31, 0x31, 0x03, 0x88, 0x00, 0x00, 0x0B,
    0x88, 0x5D, 0x5D, 0x0E, 0x8C, 0x5D, 0x5D, 0x0C, 0x88, 0x08, 0x08, 0x0D, 0x8C, 0x00, 0x00, 0x0D,
    0x8C, 0x14, 0x14, 0x16, 0x88, 0x2C, 0x00, 0x2C, 0x11, 0x08, 0xDF, 0x02, 0x70, 0x10, 0x00, 0xCC,
    0x00, 0x0A, 0x00, 0x33, 0x6E, 0x01, 0x40, 0xF3, 0x25, 0x08, 0x11, 0x69, 0x00, 0x23, 0x0F, 0x00,
    0x30, 0x01, 0x80, 0x01, 0x03, 0x00, 0x70, 0x00, 0x0C, 0x00, 0x01, 0x0C, 0x00, 0xC0, 0x08, 0x44,
    0x00, 0x10, 0x04, 0x04, 0x00, 0x06, 0x13, 0x07, 0x00, 0x80, 0x10, 0x00, 0x71, 0xA0, 0x00, 0x2C,
    0x00, 0x01, 0x37, 0x0F, 0x52, 0x01, 0x11, 0x02, 0x64, 0x01, 0xBB, 0x04, 0x00, 0x1F, 0x22, 0x20,
    0x80, 0x0F, 0xF4, 0x20, 0x02, 0x29, 0x01, 0x00, 0x12, 0x78, 0x9A, 0x02, 0x1F, 0x0F, 0xF4, 0x02,
    0x31, 0x7F, 0x16, 0x00, 0x0D, 0x00, 0x0B, 0x00, 0x17, 0x18, 0x00, 0x06, 0xF1, 0x02, 0x43, 0x00,
    0x45, 0x00, 0x45, 0x00, 0x43, 0x00, 0x46, 0x00, 0x47, 0x00, 0x41, 0x00, 0x46, 0x00, 0x0C, 0xBA,
    0x01, 0x1F, 0x0D, 0x18, 0x00, 0x06, 0x1F, 0x28, 0x02, 0x00, 0x0C, 0x11, 0x16, 0x5A, 0x00, 0x00,
    0x5C, 0x00, 0x00, 0x5E, 0x00, 0x3F, 0x17, 0x00, 0x16, 0x94, 0x00, 0x00, 0x05, 0x54, 0x01, 0xB3,
    0x40, 0x06, 0x00, 0xCC, 0x00, 0x09, 0x00, 0x4F, 0x00, 0x51, 0x80, 0x18, 0x00, 0x04, 0x08, 0x00,
    0x01, 0x6E, 0x00, 0x54, 0xAB, 0x00, 0x0A, 0x04, 0x11, 0x5C, 0x01, 0x03, 0x04, 0x00, 0x0F, 0xE4,
    0x03, 0x0E, 0x0B, 0xCC, 0x02, 0x14, 0x01, 0x14, 0x00, 0x75, 0x01, 0x22, 0x04, 0xFF, 0x9F, 0xAF,
    0x4F, 0x10, 0x00, 0x07, 0x34, 0x00, 0x32, 0x9F, 0xFF, 0x37, 0x98, 0x00, 0xF0, 0x10, 0x32, 0x54,
    0x76, 0x10, 0x47, 0x32, 0x65, 0x10, 0x34, 0x76, 0x25, 0x01, 0x34, 0x67, 0x25, 0x01, 0x75, 0x64,
    0x32, 0x01, 0x72, 0x56, 0x34, 0x10, 0x23, 0x74, 0x56, 0x01, 0x45, 0x32, 0x67, 0x24, 0x00, 0x31,
    0x49, 0x92, 0x24, 0x04, 0x00, 0x0C, 0x01, 0x00, 0x13, 0x12, 0x04, 0x00, 0x0C, 0x90, 0x00, 0x80,
    0x20, 0x41, 0x13, 0x1F, 0x14, 0x00, 0x01, 0x00, 0x7C, 0x00, 0x85, 0xFF, 0xFF, 0xFF, 0x7F, 0x1F,
    0xD7, 0x36, 0x40, 0xE6, 0x03, 0x25, 0x34, 0x10, 0xF0, 0x03, 0x0F, 0xCC, 0x00, 0x01, 0x31, 0x03,
    0x00, 0x05, 0x2B, 0x03, 0x22, 0x10, 0x02, 0xDD, 0x03, 0x13, 0x21, 0x15, 0x04, 0x14, 0x40, 0x8B,
    0x02, 0x07, 0x01, 0x00, 0x71, 0x80, 0x00, 0x40, 0x00, 0x04, 0x10, 0x80, 0x04, 0x04, 0xCF, 0x81,
    0x10, 0x09, 0x28, 0x93, 0x32, 0xA5, 0x44, 0x5B, 0x8A, 0x67, 0x76, 0x54, 0x05, 0x4D, 0x22, 0x10,
    0x10, 0x04, 0x00, 0x44, 0x00, 0xEF, 0x00, 0xEF, 0x14, 0x00, 0x4D, 0x1C, 0x1C, 0x1C, 0x1C, 0x98,
    0x01, 0x21, 0x03, 0x08, 0x04, 0x00, 0xF1, 0x03, 0x00, 0x24, 0xFF, 0xFF, 0x00, 0x44, 0x57, 0x6E,
    0x00, 0x28, 0x72, 0x39, 0x00, 0x10, 0x9C, 0x4B, 0x00, 0x10, 0xA4, 0x01, 0xB2, 0x08, 0x4C, 0x00,
    0x00, 0x80, 0x20, 0x10, 0x0A, 0x00, 0x28, 0x10, 0x30, 0x03, 0x0C, 0xC0, 0x01, 0x04, 0x08, 0x00,
    0x17, 0x05, 0x0C, 0x02, 0x13, 0x04, 0x10, 0x00, 0x12, 0x07, 0x62, 0x00, 0xD2, 0x02, 0x01, 0x02,
    0x03, 0x00, 0x04, 0x05, 0xA3, 0x72, 0x0F, 0x0F, 0x00, 0x70, 0x42, 0x00, 0x16, 0x1F, 0x28, 0x01,
    0x43, 0xFF, 0x00, 0xFF, 0x01, 0xA4, 0x04, 0x24, 0x00, 0x80, 0x96, 0x00, 0x15, 0xF0, 0x24, 0x04,
    0x60, 0x43, 0xCB, 0xFA, 0xE4, 0xD3, 0xFE, 0x0F, 0x05, 0x3B, 0x80, 0x2A, 0x02, 0x1C, 0x00, 0x0C,
    0xF4, 0x00, 0x19, 0x08, 0x0E, 0x00, 0x01, 0xE6, 0x05, 0x1F, 0x03, 0x2C, 0x00, 0x05, 0x10, 0x76,
    0xE9, 0x03, 0x0F, 0x9C, 0x02, 0x00, 0x05, 0x34, 0x00, 0x0F, 0x3A, 0x00, 0x04, 0x38, 0x7E, 0x16,
    0x40, 0x03, 0x06, 0x0F, 0x38, 0x00, 0x17, 0x3F, 0x1E, 0x40, 0x04, 0xA8, 0x00, 0x08, 0x2F, 0x00,
    0xC0, 0x55, 0x00, 0x04, 0x3F, 0x46, 0x24, 0x00, 0x38, 0x00, 0x0A, 0x0F, 0x01, 0x00, 0x05, 0x22,
    0x46, 0x2C, 0x38, 0x00, 0x19, 0xEC, 0x16, 0x00, 0x0F, 0x3C, 0x01, 0x03, 0x0F, 0x38, 0x08, 0xFF,
    0xFF, 0x3B, 0x1F, 0x08, 0x38, 0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0x14, 0x1F, 0x01, 0x38, 0x08, 0x51,
    0x5F, 0xC3, 0xBA, 0xE4, 0xD3, 0x1E, 0x38, 0x08, 0xFF, 0x47, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
};

constexpr inline const u8 * const SdramParamsMariko10 = SdramParamsMariko10_11;
constexpr inline const size_t SdramParamsSizeMariko10 = sizeof(SdramParamsMariko10_11);

constexpr inline const u8 * const SdramParamsMariko11 = SdramParamsMariko10_11;
constexpr inline const size_t SdramParamsSizeMariko11 = sizeof(SdramParamsMariko10_11);

constexpr inline const u8 SdramParamsMariko12_13[0x3C0] = {
    0xFF, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x2C, 0x01,
    0x00, 0x01, 0x00, 0x96, 0x88, 0x02, 0x80, 0x18, 0x40, 0x00, 0x00, 0x00, 0x40, 0x14, 0x00, 0xF0,
    0x01, 0xFF, 0xFF, 0x1F, 0x00, 0xD8, 0x51, 0x1A, 0xA0, 0x00, 0x00, 0x50, 0x05, 0x00, 0x00, 0x88,
    0x00, 0x04, 0x00, 0x20, 0x20, 0x12, 0x1A, 0x00, 0x17, 0x88, 0x04, 0x00, 0xF7, 0x00, 0x00, 0x00,
    0xBC, 0xBC, 0xAF, 0xC9, 0x3C, 0x9E, 0x00, 0x00, 0x02, 0x03, 0xE0, 0xC1, 0x04, 0x01, 0x00, 0x17,
    0x3F, 0x01, 0x00, 0x00, 0x38, 0x00, 0xD0, 0x04, 0x08, 0x00, 0x00, 0x50, 0x50, 0x50, 0x00, 0xA1,
    0x01, 0x00, 0x00, 0x30, 0x39, 0x00, 0x62, 0x10, 0x00, 0x16, 0x00, 0x10, 0x90, 0x80, 0x00, 0x03,
    0x74, 0x00, 0x13, 0x03, 0x04, 0x00, 0xD7, 0x1E, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x3A,
    0x00, 0x00, 0x00, 0x1D, 0x94, 0x00, 0x57, 0x09, 0x00, 0x00, 0x00, 0x04, 0x10, 0x00, 0x13, 0x0B,
    0x28, 0x00, 0x13, 0x08, 0x0C, 0x00, 0x00, 0x1C, 0x00, 0x53, 0x17, 0x00, 0x00, 0x00, 0x15, 0x08,
    0x00, 0x13, 0x1B, 0x28, 0x00, 0x57, 0x20, 0x00, 0x00, 0x00, 0x06, 0x04, 0x00, 0x13, 0x03, 0x18,
    0x00, 0x13, 0x04, 0x10, 0x00, 0x17, 0x02, 0x10, 0x00, 0x00, 0x4C, 0x00, 0x13, 0x0E, 0x18, 0x00,
    0x17, 0x05, 0x6C, 0x00, 0x00, 0x34, 0x00, 0x13, 0x0C, 0xE0, 0x01, 0x40, 0x00, 0x00, 0x00, 0x80,
    0x0A, 0x00, 0x00, 0x0F, 0x01, 0x93, 0x18, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x16, 0x0C,
    0x00, 0x10, 0x0A, 0x48, 0x00, 0x03, 0x61, 0x00, 0x13, 0xC1, 0x50, 0x00, 0x13, 0x08, 0x40, 0x00,
    0x13, 0x0A, 0x08, 0x00, 0x13, 0x14, 0x5C, 0x00, 0x13, 0x02, 0xC0, 0x00, 0x13, 0x3B, 0x04, 0x00,
    0x13, 0x05, 0x04, 0x00, 0x04, 0x88, 0x00, 0x04, 0x0C, 0x00, 0x00, 0xF8, 0x00, 0x90, 0x1C, 0x03,
    0x00, 0x00, 0x0D, 0xA0, 0x60, 0x91, 0x3F, 0x15, 0x01, 0xF1, 0x28, 0x00, 0xF3, 0x0C, 0x04, 0x05,
    0x1B, 0x06, 0x02, 0x03, 0x07, 0x1C, 0x23, 0x25, 0x25, 0x05, 0x08, 0x1D, 0x09, 0x0A, 0x24, 0x0B,
    0x1E, 0x0D, 0x0C, 0x26, 0x26, 0x03, 0x02, 0x1B, 0x1C, 0x23, 0x03, 0x04, 0x07, 0x05, 0x06, 0x25,
    0x25, 0x02, 0x0A, 0x0B, 0x1D, 0x0D, 0x08, 0x0C, 0x09, 0x1E, 0x24, 0x26, 0x26, 0x08, 0x24, 0x06,
    0x07, 0x9A, 0xBF, 0x01, 0x3C, 0xFF, 0x00, 0xFF, 0x00, 0x02, 0xB0, 0x04, 0x00, 0x01, 0x88, 0x00,
    0x00, 0x02, 0x88, 0x00, 0x00, 0x0D, 0xD5, 0x01, 0xF2, 0x0E, 0xC0, 0x31, 0x31, 0x03, 0x88, 0x00,
    0x00, 0x0B, 0x88, 0x5D, 0x5D, 0x0E, 0x8C, 0x5D, 0x5D, 0x0C, 0x88, 0x08, 0x08, 0x0D, 0x8C, 0x00,
    0x00, 0x0D, 0x8C, 0x14, 0x14, 0x16, 0x88, 0x2C, 0x00, 0x2C, 0x11, 0x08, 0xDF, 0x02, 0x70, 0x10,
    0x00, 0xCC, 0x00, 0x0A, 0x00, 0x33, 0x6E, 0x01, 0x40, 0xF3, 0x25, 0x08, 0x11, 0x69, 0x00, 0x23,
    0x0F, 0x00, 0x30, 0x01, 0x80, 0x01, 0x03, 0x00, 0x70, 0x00, 0x0C, 0x00, 0x01, 0x0C, 0x00, 0xC0,
    0x08, 0x44, 0x00, 0x10, 0x04, 0x04, 0x00, 0x06, 0x13, 0x07, 0x00, 0x80, 0x10, 0x00, 0x71, 0xA0,
    0x00, 0x2C, 0x00, 0x01, 0x37, 0x0F, 0x52, 0x01, 0x11, 0x02, 0x64, 0x01, 0xBB, 0x04, 0x00, 0x1F,
    0x22, 0x20, 0x80, 0x0F, 0xF4, 0x20, 0x02, 0x29, 0x01, 0x00, 0x12, 0x78, 0x9A, 0x02, 0x1F, 0x0F,
    0xF4, 0x02, 0x31, 0x7F, 0x16, 0x00, 0x0D, 0x00, 0x0B, 0x00, 0x17, 0x18, 0x00, 0x06, 0xF1, 0x02,
    0x43, 0x00, 0x45, 0x00, 0x45, 0x00, 0x43, 0x00, 0x46, 0x00, 0x47, 0x00, 0x41, 0x00, 0x46, 0x00,
    0x0C, 0xBA, 0x01, 0x1F, 0x0D, 0x18, 0x00, 0x06, 0x1F, 0x28, 0x02, 0x00, 0x0C, 0x11, 0x16, 0x5A,
    0x00, 0x00, 0x5C, 0x00, 0x00, 0x5E, 0x00, 0x3F, 0x17, 0x00, 0x16, 0x94, 0x00, 0x00, 0x05, 0x54,
    0x01, 0xB3, 0x40, 0x06, 0x00, 0xCC, 0x00, 0x09, 0x00, 0x4F, 0x00, 0x51, 0x80, 0x18, 0x00, 0x04,
    0x08, 0x00, 0x01, 0x6E, 0x00, 0x54, 0xAB, 0x00, 0x0A, 0x04, 0x11, 0x5C, 0x01, 0x03, 0x04, 0x00,
    0x0F, 0xE4, 0x03, 0x0E, 0x0B, 0xCC, 0x02, 0x14, 0x01, 0x14, 0x00, 0x75, 0x01, 0x22, 0x04, 0xFF,
    0x9F, 0xAF, 0x4F, 0x10, 0x00, 0x07, 0x34, 0x00, 0x32, 0x9F, 0xFF, 0x37, 0x98, 0x00, 0xF0, 0x10,
    0x32, 0x54, 0x76, 0x10, 0x47, 0x32, 0x65, 0x10, 0x34, 0x76, 0x25, 0x01, 0x34, 0x67, 0x25, 0x01,
    0x75, 0x64, 0x32, 0x01, 0x72, 0x56, 0x34, 0x10, 0x23, 0x74, 0x56, 0x01, 0x45, 0x32, 0x67, 0x24,
    0x00, 0x31, 0x49, 0x92, 0x24, 0x04, 0x00, 0x0C, 0x01, 0x00, 0x13, 0x12, 0x04, 0x00, 0x0C, 0x90,
    0x00, 0x80, 0x20, 0x41, 0x13, 0x1F, 0x14, 0x00, 0x01, 0x00, 0x7C, 0x00, 0x85, 0xFF, 0xFF, 0xFF,
    0x7F, 0x1F, 0xD7, 0x36, 0x40, 0xE6, 0x03, 0x25, 0x34, 0x10, 0xF0, 0x03, 0x0F, 0xCC, 0x00, 0x01,
    0x31, 0x03, 0x00, 0x05, 0x2B, 0x03, 0x22, 0x10, 0x02, 0xDD, 0x03, 0x13, 0x21, 0x15, 0x04, 0x14,
    0x40, 0x8B, 0x02, 0x07, 0x01, 0x00, 0x71, 0x80, 0x00, 0x40, 0x00, 0x04, 0x10, 0x80, 0x04, 0x04,
    0xCF, 0x81, 0x10, 0x09, 0x28, 0x93, 0x32, 0xA5, 0x44, 0x5B, 0x8A, 0x67, 0x76, 0x54, 0x05, 0x4D,
    0x22, 0x10, 0x10, 0x04, 0x00, 0x44, 0x00, 0xEF, 0x00, 0xEF, 0x14, 0x00, 0x4D, 0x1C, 0x1C, 0x1C,
    0x1C, 0x98, 0x01, 0x21, 0x03, 0x08, 0x04, 0x00, 0xF1, 0x03, 0x00, 0x24, 0xFF, 0xFF, 0x00, 0x44,
    0x57, 0x6E, 0x00, 0x28, 0x72, 0x39, 0x00, 0x10, 0x9C, 0x4B, 0x00, 0x10, 0xA4, 0x01, 0xB2, 0x08,
    0x4C, 0x00, 0x00, 0x80, 0x20, 0x10, 0x0A, 0x00, 0x28, 0x10, 0x30, 0x03, 0x08, 0xC0, 0x01, 0x17,
    0x01, 0xC8, 0x01, 0x17, 0x05, 0x10, 0x00, 0x13, 0x04, 0x10, 0x00, 0x12, 0x07, 0x62, 0x00, 0xD2,
    0x02, 0x01, 0x02, 0x03, 0x00, 0x04, 0x05, 0xA3, 0x72, 0x0F, 0x0F, 0x00, 0x70, 0x42, 0x00, 0x16,
    0x1F, 0x28, 0x01, 0x43, 0xFF, 0x00, 0xFF, 0x01, 0x70, 0x04, 0x24, 0x00, 0x80, 0x96, 0x00, 0x15,
    0xF0, 0x24, 0x04, 0x60, 0x43, 0xCB, 0xFA, 0xE4, 0xD3, 0xFE, 0x0F, 0x05, 0x3B, 0x80, 0x2A, 0x02,
    0x1C, 0x00, 0x0C, 0xF4, 0x00, 0x19, 0x08, 0x0E, 0x00, 0x01, 0xE6, 0x05, 0x1F, 0x03, 0x2C, 0x00,
    0x05, 0x10, 0x76, 0xE9, 0x03, 0x0F, 0x9C, 0x02, 0x00, 0x05, 0x34, 0x00, 0x0F, 0x3A, 0x00, 0x04,
    0x38, 0x7E, 0x16, 0x40, 0x03, 0x06, 0x0F, 0x38, 0x00, 0x17, 0x3F, 0x1E, 0x40, 0x04, 0xA8, 0x00,
    0x08, 0x2F, 0x00, 0xC0, 0x55, 0x00, 0x04, 0x3F, 0x46, 0x24, 0x00, 0x38, 0x00, 0x0A, 0x0F, 0x01,
    0x00, 0x05, 0x22, 0x46, 0x2C, 0x38, 0x00, 0x19, 0xEC, 0x16, 0x00, 0x0E, 0x3C, 0x01, 0x0F, 0x01,
    0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x2C, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
};

constexpr inline const u8 * const SdramParamsMariko12 = SdramParamsMariko12_13;
constexpr inline const size_t SdramParamsSizeMariko12 = sizeof(SdramParamsMariko12_13);

constexpr inline const u8 * const SdramParamsMariko13 = SdramParamsMariko12_13;
constexpr inline const size_t SdramParamsSizeMariko13 = sizeof(SdramParamsMariko12_13);

