/*
 * Copyright (c) Atmosphre-NX
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#define FOREACH_SDRAM_SCRATCH_REGISTER_ERISTA(HANDLER)               \
    /* PMC SCRATCH fields. */                                        \
    HANDLER(EmcClockSource, 6, 7:0, 15:8)                            \
    HANDLER(EmcClockSourceDll, 6, 7:0, 23:16)                        \
    HANDLER(EmcClockSource, 6, 31:29, 26:24)                         \
    HANDLER(EmcClockSourceDll, 6, 31:29, 29:27)                      \
    HANDLER(EmcClockSourceDll, 6, 11:10, 31:30)                      \
    HANDLER(ClkRstControllerPllmMisc2Override, 7, 9:8, 1:0)          \
    HANDLER(ClkRstControllerPllmMisc2Override, 7, 2:1, 3:2)          \
    HANDLER(EmcZqCalLpDdr4WarmBoot, 7, 31:30, 5:4)                   \
    HANDLER(EmcClockSource, 7, 15:15, 6:6)                           \
    HANDLER(EmcClockSource, 7, 26:26, 7:7)                           \
    HANDLER(EmcClockSource, 7, 20:20, 8:8)                           \
    HANDLER(EmcClockSource, 7, 19:19, 9:9)                           \
    HANDLER(ClkRstControllerPllmMisc2Override, 7, 13:13, 10:10)      \
    HANDLER(ClkRstControllerPllmMisc2Override, 7, 12:12, 11:11)      \
    HANDLER(ClkRstControllerPllmMisc2Override, 7, 11:11, 12:12)      \
    HANDLER(ClkRstControllerPllmMisc2Override, 7, 10:10, 13:13)      \
    HANDLER(ClkRstControllerPllmMisc2Override, 7, 5:5, 14:14)        \
    HANDLER(ClkRstControllerPllmMisc2Override, 7, 4:4, 15:15)        \
    HANDLER(ClkRstControllerPllmMisc2Override, 7, 3:3, 16:16)        \
    HANDLER(ClkRstControllerPllmMisc2Override, 7, 0:0, 17:17)        \
    HANDLER(EmcZqCalLpDdr4WarmBoot, 7, 1:0, 19:18)                   \
    HANDLER(EmcZqCalLpDdr4WarmBoot, 7, 4:4, 20:20)                   \
    HANDLER(EmcOdtWrite, 7, 5:0, 26:21)                              \
    HANDLER(EmcOdtWrite, 7, 11:8, 30:27)                             \
    HANDLER(EmcOdtWrite, 7, 31:31, 31:31)                            \
    HANDLER(EmcFdpdCtrlCmdNoRamp, 13, 0:0, 30:30)                    \
    HANDLER(EmcCfgPipeClk, 13, 0:0, 31:31)                           \
    HANDLER(McEmemArbMisc2, 14, 0:0, 30:30)                          \
    HANDLER(McDaCfg0, 14, 0:0, 31:31)                                \
    HANDLER(EmcQRst, 15, 6:0, 26:20)                                 \
    HANDLER(EmcQRst, 15, 20:16, 31:27)                               \
    HANDLER(EmcPmacroCmdTxDrv, 16, 5:0, 25:20)                       \
    HANDLER(EmcPmacroCmdTxDrv, 16, 13:8, 31:26)                      \
    HANDLER(EmcPmacroAutocalCfg0, 17, 2:0, 22:20)                    \
    HANDLER(EmcPmacroAutocalCfg0, 17, 10:8, 25:23)                   \
    HANDLER(EmcPmacroAutocalCfg0, 17, 18:16, 28:26)                  \
    HANDLER(EmcPmacroAutocalCfg0, 17, 26:24, 31:29)                  \
    HANDLER(EmcPmacroAutocalCfg1, 18, 2:0, 22:20)                    \
    HANDLER(EmcPmacroAutocalCfg1, 18, 10:8, 25:23)                   \
    HANDLER(EmcPmacroAutocalCfg1, 18, 18:16, 28:26)                  \
    HANDLER(EmcPmacroAutocalCfg1, 18, 26:24, 31:29)                  \
    HANDLER(EmcPmacroAutocalCfg2, 19, 2:0, 22:20)                    \
    HANDLER(EmcPmacroAutocalCfg2, 19, 10:8, 25:23)                   \
    HANDLER(EmcPmacroAutocalCfg2, 19, 18:16, 28:26)                  \
    HANDLER(EmcPmacroAutocalCfg2, 19, 26:24, 31:29)                  \
    HANDLER(EmcCfgRsv, 22, 31:0, 31:0)                               \
    HANDLER(EmcAutoCalConfig, 23, 31:0, 31:0)                        \
    HANDLER(EmcAutoCalVrefSel0, 24, 31:0, 31:0)                      \
    HANDLER(EmcPmacroBrickCtrlRfu1, 25, 31:0, 31:0)                  \
    HANDLER(EmcPmacroBrickCtrlRfu2, 26, 31:0, 31:0)                  \
    HANDLER(EmcPmcScratch1, 27, 31:0, 31:0)                          \
    HANDLER(EmcPmcScratch2, 28, 31:0, 31:0)                          \
    HANDLER(EmcPmcScratch3, 29, 31:0, 31:0)                          \
    HANDLER(McEmemArbDaTurns, 30, 31:0, 31:0)                        \
    HANDLER(EmcFbioSpare, 58, 31:24, 7:0)                            \
    HANDLER(EmcFbioSpare, 58, 23:16, 15:8)                           \
    HANDLER(EmcFbioSpare, 58, 15:8, 23:16)                           \
    HANDLER(EmcFbioSpare, 58, 7:2, 29:24)                            \
    HANDLER(EmcFbioSpare, 58, 0:0, 30:30)                            \
    HANDLER(EmcDllCfg0, 59, 29:0, 29:0)                              \
    HANDLER(EmcPmacroDdllBypass, 60, 11:0, 11:0)                     \
    HANDLER(EmcPmacroDdllBypass, 60, 27:13, 26:12)                   \
    HANDLER(EmcPmacroDdllBypass, 60, 31:29, 29:27)                   \
    HANDLER(McEmemArbMisc0, 61, 14:0, 14:0)                          \
    HANDLER(McEmemArbMisc0, 61, 30:16, 29:15)                        \
    HANDLER(EmcFdpdCtrlCmd, 62, 16:0, 16:0)                          \
    HANDLER(EmcFdpdCtrlCmd, 62, 31:20, 28:17)                        \
    HANDLER(EmcAutoCalConfig2, 63, 27:0, 27:0)                       \
    HANDLER(EmcBurstRefreshNum, 63, 3:0, 31:28)                      \
    HANDLER(EmcPmacroZctrl, 64, 27:0, 27:0)                          \
    HANDLER(EmcTppd, 64, 3:0, 31:28)                                 \
    HANDLER(EmcCfgDigDll, 65, 10:0, 10:0)                            \
    HANDLER(EmcCfgDigDll, 65, 25:12, 24:11)                          \
    HANDLER(EmcCfgDigDll, 65, 27:27, 25:25)                          \
    HANDLER(EmcCfgDigDll, 65, 31:30, 27:26)                          \
    HANDLER(EmcR2r, 65, 3:0, 31:28)                                  \
    HANDLER(EmcFdpdCtrlDq, 66, 16:0, 16:0)                           \
    HANDLER(EmcFdpdCtrlDq, 66, 28:20, 25:17)                         \
    HANDLER(EmcFdpdCtrlDq, 66, 31:30, 27:26)                         \
    HANDLER(EmcW2w, 66, 3:0, 31:28)                                  \
    HANDLER(EmcPmacroTxPwrd4, 67, 13:0, 13:0)                        \
    HANDLER(EmcPmacroTxPwrd4, 67, 29:16, 27:14)                      \
    HANDLER(EmcPmacroCommonPadTxCtrl, 67, 3:0, 31:28)                \
    HANDLER(EmcPmacroTxPwrd5, 68, 13:0, 13:0)                        \
    HANDLER(EmcPmacroTxPwrd5, 68, 29:16, 27:14)                      \
    HANDLER(EmcPmacroDdllPwrd0, 69, 4:0, 4:0)                        \
    HANDLER(EmcPmacroDdllPwrd0, 69, 12:6, 11:5)                      \
    HANDLER(EmcPmacroDdllPwrd0, 69, 20:14, 18:12)                    \
    HANDLER(EmcPmacroDdllPwrd0, 69, 28:22, 25:19)                    \
    HANDLER(EmcPmacroDdllPwrd0, 69, 31:30, 27:26)                    \
    HANDLER(EmcCfg, 69, 4:4, 31:31)                                  \
    HANDLER(EmcPmacroDdllPwrd1, 70, 4:0, 4:0)                        \
    HANDLER(EmcPmacroDdllPwrd1, 70, 12:6, 11:5)                      \
    HANDLER(EmcPmacroDdllPwrd1, 70, 20:14, 18:12)                    \
    HANDLER(EmcPmacroDdllPwrd1, 70, 28:22, 25:19)                    \
    HANDLER(EmcPmacroDdllPwrd1, 70, 31:30, 27:26)                    \
    HANDLER(EmcCfg, 70, 5:5, 31:31)                                  \
    HANDLER(EmcPmacroDdllPwrd2, 71, 4:0, 4:0)                        \
    HANDLER(EmcPmacroDdllPwrd2, 71, 12:6, 11:5)                      \
    HANDLER(EmcPmacroDdllPwrd2, 71, 20:14, 18:12)                    \
    HANDLER(EmcPmacroDdllPwrd2, 71, 28:22, 25:19)                    \
    HANDLER(EmcPmacroDdllPwrd2, 71, 31:30, 27:26)                    \
    HANDLER(EmcFbioCfg5, 71, 23:20, 31:28)                           \
    HANDLER(EmcPmacroIbVrefDq_0, 72, 6:0, 6:0)                       \
    HANDLER(EmcPmacroIbVrefDq_0, 72, 14:8, 13:7)                     \
    HANDLER(EmcPmacroIbVrefDq_0, 72, 22:16, 20:14)                   \
    HANDLER(EmcPmacroIbVrefDq_0, 72, 30:24, 27:21)                   \
    HANDLER(EmcFbioCfg5, 72, 15:13, 30:28)                           \
    HANDLER(EmcCfg, 72, 6:6, 31:31)                                  \
    HANDLER(EmcPmacroIbVrefDq_1, 73, 6:0, 6:0)                       \
    HANDLER(EmcPmacroIbVrefDq_1, 73, 14:8, 13:7)                     \
    HANDLER(EmcPmacroIbVrefDq_1, 73, 22:16, 20:14)                   \
    HANDLER(EmcPmacroIbVrefDq_1, 73, 30:24, 27:21)                   \
    HANDLER(EmcCfg2, 73, 5:3, 30:28)                                 \
    HANDLER(EmcCfg, 73, 7:7, 31:31)                                  \
    HANDLER(EmcPmacroIbVrefDqs_0, 74, 6:0, 6:0)                      \
    HANDLER(EmcPmacroIbVrefDqs_0, 74, 14:8, 13:7)                    \
    HANDLER(EmcPmacroIbVrefDqs_0, 74, 22:16, 20:14)                  \
    HANDLER(EmcPmacroIbVrefDqs_0, 74, 30:24, 27:21)                  \
    HANDLER(EmcCfg, 74, 17:16, 29:28)                                \
    HANDLER(EmcFbioCfg5, 74, 1:0, 31:30)                             \
    HANDLER(EmcPmacroIbVrefDqs_1, 75, 6:0, 6:0)                      \
    HANDLER(EmcPmacroIbVrefDqs_1, 75, 14:8, 13:7)                    \
    HANDLER(EmcPmacroIbVrefDqs_1, 75, 22:16, 20:14)                  \
    HANDLER(EmcPmacroIbVrefDqs_1, 75, 30:24, 27:21)                  \
    HANDLER(EmcFbioCfg5, 75, 3:2, 29:28)                             \
    HANDLER(EmcCfg2, 75, 27:26, 31:30)                               \
    HANDLER(EmcPmacroDdllShortCmd_0, 76, 6:0, 6:0)                   \
    HANDLER(EmcPmacroDdllShortCmd_0, 76, 14:8, 13:7)                 \
    HANDLER(EmcPmacroDdllShortCmd_0, 76, 22:16, 20:14)               \
    HANDLER(EmcPmacroDdllShortCmd_0, 76, 30:24, 27:21)               \
    HANDLER(EmcPmacroCmdPadTxCtrl, 76, 3:2, 29:28)                   \
    HANDLER(EmcPmacroCmdPadTxCtrl, 76, 7:6, 31:30)                   \
    HANDLER(EmcPmacroDdllShortCmd_1, 77, 6:0, 6:0)                   \
    HANDLER(EmcPmacroDdllShortCmd_1, 77, 14:8, 13:7)                 \
    HANDLER(EmcPmacroDdllShortCmd_1, 77, 22:16, 20:14)               \
    HANDLER(EmcPmacroDdllShortCmd_1, 77, 30:24, 27:21)               \
    HANDLER(EmcPmacroCmdPadTxCtrl, 77, 11:10, 29:28)                 \
    HANDLER(EmcPmacroCmdPadTxCtrl, 77, 15:14, 31:30)                 \
    HANDLER(EmcAutoCalChannel, 78, 5:0, 5:0)                         \
    HANDLER(EmcAutoCalChannel, 78, 11:8, 9:6)                        \
    HANDLER(EmcAutoCalChannel, 78, 27:16, 21:10)                     \
    HANDLER(EmcAutoCalChannel, 78, 31:29, 24:22)                     \
    HANDLER(EmcConfigSampleDelay, 78, 6:0, 31:25)                    \
    HANDLER(EmcPmacroRxTerm, 79, 5:0, 5:0)                           \
    HANDLER(EmcPmacroRxTerm, 79, 13:8, 11:6)                         \
    HANDLER(EmcPmacroRxTerm, 79, 21:16, 17:12)                       \
    HANDLER(EmcPmacroRxTerm, 79, 29:24, 23:18)                       \
    HANDLER(EmcRc, 79, 7:0, 31:24)                                   \
    HANDLER(EmcPmacroDqTxDrv, 80, 5:0, 5:0)                          \
    HANDLER(EmcPmacroDqTxDrv, 80, 13:8, 11:6)                        \
    HANDLER(EmcPmacroDqTxDrv, 80, 21:16, 17:12)                      \
    HANDLER(EmcPmacroDqTxDrv, 80, 29:24, 23:18)                      \
    HANDLER(EmcSelDpdCtrl, 80, 5:2, 27:24)                           \
    HANDLER(EmcSelDpdCtrl, 80, 8:8, 28:28)                           \
    HANDLER(EmcSelDpdCtrl, 80, 18:16, 31:29)                         \
    HANDLER(EmcPmacroCaTxDrv, 81, 5:0, 5:0)                          \
    HANDLER(EmcPmacroCaTxDrv, 81, 13:8, 11:6)                        \
    HANDLER(EmcPmacroCaTxDrv, 81, 21:16, 17:12)                      \
    HANDLER(EmcPmacroCaTxDrv, 81, 29:24, 23:18)                      \
    HANDLER(EmcObdly, 81, 5:0, 29:24)                                \
    HANDLER(EmcObdly, 81, 29:28, 31:30)                              \
    HANDLER(EmcZcalInterval, 82, 23:10, 13:0)                        \
    HANDLER(EmcZcalInterval, 82, 9:0, 23:14)                         \
    HANDLER(EmcPmacroCmdRxTermMode, 82, 1:0, 25:24)                  \
    HANDLER(EmcPmacroCmdRxTermMode, 82, 5:4, 27:26)                  \
    HANDLER(EmcPmacroCmdRxTermMode, 82, 9:8, 29:28)                  \
    HANDLER(EmcPmacroCmdRxTermMode, 82, 13:12, 31:30)                \
    HANDLER(EmcDataBrlshft0, 83, 23:0, 23:0)                         \
    HANDLER(EmcPmacroDataRxTermMode, 83, 1:0, 25:24)                 \
    HANDLER(EmcPmacroDataRxTermMode, 83, 5:4, 27:26)                 \
    HANDLER(EmcPmacroDataRxTermMode, 83, 9:8, 29:28)                 \
    HANDLER(EmcPmacroDataRxTermMode, 83, 13:12, 31:30)               \
    HANDLER(EmcDataBrlshft1, 84, 23:0, 23:0)                         \
    HANDLER(McEmemArbTimingRc, 84, 7:0, 31:24)                       \
    HANDLER(EmcDqsBrlshft0, 85, 23:0, 23:0)                          \
    HANDLER(McEmemArbRsv, 85, 7:0, 31:24)                            \
    HANDLER(EmcDqsBrlshft1, 86, 23:0, 23:0)                          \
    HANDLER(EmcCfgPipe2, 87, 11:0, 11:0)                             \
    HANDLER(EmcCfgPipe2, 87, 27:16, 23:12)                           \
    HANDLER(EmcCfgPipe1, 88, 11:0, 11:0)                             \
    HANDLER(EmcCfgPipe1, 88, 27:16, 23:12)                           \
    HANDLER(EmcPmacroCmdCtrl0, 89, 5:0, 5:0)                         \
    HANDLER(EmcPmacroCmdCtrl0, 89, 13:8, 11:6)                       \
    HANDLER(EmcPmacroCmdCtrl0, 89, 21:16, 17:12)                     \
    HANDLER(EmcPmacroCmdCtrl0, 89, 29:24, 23:18)                     \
    HANDLER(EmcPmacroCmdCtrl1, 90, 5:0, 5:0)                         \
    HANDLER(EmcPmacroCmdCtrl1, 90, 13:8, 11:6)                       \
    HANDLER(EmcPmacroCmdCtrl1, 90, 21:16, 17:12)                     \
    HANDLER(EmcPmacroCmdCtrl1, 90, 29:24, 23:18)                     \
    HANDLER(EmcRas, 90, 6:0, 30:24)                                  \
    HANDLER(EmcCfg, 90, 8:8, 31:31)                                  \
    HANDLER(EmcPmacroVttgenCtrl2, 91, 23:0, 23:0)                    \
    HANDLER(EmcW2p, 91, 6:0, 30:24)                                  \
    HANDLER(EmcCfg, 91, 9:9, 31:31)                                  \
    HANDLER(EmcPmacroCmdPadRxCtrl, 92, 2:0, 2:0)                     \
    HANDLER(EmcPmacroCmdPadRxCtrl, 92, 5:4, 4:3)                     \
    HANDLER(EmcPmacroCmdPadRxCtrl, 92, 10:8, 7:5)                    \
    HANDLER(EmcPmacroCmdPadRxCtrl, 92, 22:12, 18:8)                  \
    HANDLER(EmcPmacroCmdPadRxCtrl, 92, 28:24, 23:19)                 \
    HANDLER(EmcQSafe, 92, 6:0, 30:24)                                \
    HANDLER(EmcCfg, 92, 18:18, 31:31)                                \
    HANDLER(EmcPmacroDataPadRxCtrl, 93, 2:0, 2:0)                    \
    HANDLER(EmcPmacroDataPadRxCtrl, 93, 5:4, 4:3)                    \
    HANDLER(EmcPmacroDataPadRxCtrl, 93, 10:8, 7:5)                   \
    HANDLER(EmcPmacroDataPadRxCtrl, 93, 22:12, 18:8)                 \
    HANDLER(EmcPmacroDataPadRxCtrl, 93, 28:24, 23:19)                \
    HANDLER(EmcRdv, 93, 6:0, 30:24)                                  \
    HANDLER(EmcCfg, 93, 21:21, 31:31)                                \
    HANDLER(McEmemArbDaCovers, 94, 23:0, 23:0)                       \
    HANDLER(EmcRw2Pden, 94, 6:0, 30:24)                              \
    HANDLER(EmcCfg, 94, 22:22, 31:31)                                \
    HANDLER(EmcPmacroCmdCtrl2, 95, 5:0, 5:0)                         \
    HANDLER(EmcPmacroCmdCtrl2, 95, 13:9, 10:6)                       \
    HANDLER(EmcPmacroCmdCtrl2, 95, 21:16, 16:11)                     \
    HANDLER(EmcPmacroCmdCtrl2, 95, 29:24, 22:17)                     \
    HANDLER(EmcRfcPb, 95, 8:0, 31:23)                                \
    HANDLER(EmcPmacroQuseDdllRank0_0, 96, 10:0, 10:0)                \
    HANDLER(EmcPmacroQuseDdllRank0_0, 96, 26:16, 21:11)              \
    HANDLER(EmcCfgUpdate, 96, 2:0, 24:22)                            \
    HANDLER(EmcCfgUpdate, 96, 10:8, 27:25)                           \
    HANDLER(EmcCfgUpdate, 96, 31:28, 31:28)                          \
    HANDLER(EmcPmacroQuseDdllRank0_1, 97, 10:0, 10:0)                \
    HANDLER(EmcPmacroQuseDdllRank0_1, 97, 26:16, 21:11)              \
    HANDLER(EmcRfc, 97, 9:0, 31:22)                                  \
    HANDLER(EmcPmacroQuseDdllRank0_2, 98, 10:0, 10:0)                \
    HANDLER(EmcPmacroQuseDdllRank0_2, 98, 26:16, 21:11)              \
    HANDLER(EmcTxsr, 98, 9:0, 31:22)                                 \
    HANDLER(EmcPmacroQuseDdllRank0_3, 99, 10:0, 10:0)                \
    HANDLER(EmcPmacroQuseDdllRank0_3, 99, 26:16, 21:11)              \
    HANDLER(EmcMc2EmcQ, 99, 2:0, 24:22)                              \
    HANDLER(EmcMc2EmcQ, 99, 10:8, 27:25)                             \
    HANDLER(EmcMc2EmcQ, 99, 27:24, 31:28)                            \
    HANDLER(EmcPmacroQuseDdllRank0_4, 100, 10:0, 10:0)               \
    HANDLER(EmcPmacroQuseDdllRank0_4, 100, 26:16, 21:11)             \
    HANDLER(McEmemArbRing1Throttle, 100, 4:0, 26:22)                 \
    HANDLER(McEmemArbRing1Throttle, 100, 20:16, 31:27)               \
    HANDLER(EmcPmacroQuseDdllRank0_5, 101, 10:0, 10:0)               \
    HANDLER(EmcPmacroQuseDdllRank0_5, 101, 26:16, 21:11)             \
    HANDLER(EmcPmacroQuseDdllRank1_0, 102, 10:0, 10:0)               \
    HANDLER(EmcPmacroQuseDdllRank1_0, 102, 26:16, 21:11)             \
    HANDLER(EmcAr2Pden, 102, 8:0, 30:22)                             \
    HANDLER(EmcCfg, 102, 23:23, 31:31)                               \
    HANDLER(EmcPmacroQuseDdllRank1_1, 103, 10:0, 10:0)               \
    HANDLER(EmcPmacroQuseDdllRank1_1, 103, 26:16, 21:11)             \
    HANDLER(EmcRfcSlr, 103, 8:0, 30:22)                              \
    HANDLER(EmcCfg, 103, 24:24, 31:31)                               \
    HANDLER(EmcPmacroQuseDdllRank1_2, 104, 10:0, 10:0)               \
    HANDLER(EmcPmacroQuseDdllRank1_2, 104, 26:16, 21:11)             \
    HANDLER(EmcIbdly, 104, 6:0, 28:22)                               \
    HANDLER(EmcIbdly, 104, 29:28, 30:29)                             \
    HANDLER(EmcCfg, 104, 25:25, 31:31)                               \
    HANDLER(EmcPmacroQuseDdllRank1_3, 105, 10:0, 10:0)               \
    HANDLER(EmcPmacroQuseDdllRank1_3, 105, 26:16, 21:11)             \
    HANDLER(McEmemArbTimingRFCPB, 105, 8:0, 30:22)                   \
    HANDLER(EmcCfg, 105, 26:26, 31:31)                               \
    HANDLER(EmcPmacroQuseDdllRank1_4, 106, 10:0, 10:0)               \
    HANDLER(EmcPmacroQuseDdllRank1_4, 106, 26:16, 21:11)             \
    HANDLER(EmcTfaw, 106, 6:0, 28:22)                                \
    HANDLER(EmcPmacroDataPadTxCtrl, 106, 3:2, 30:29)                 \
    HANDLER(EmcCfg, 106, 28:28, 31:31)                               \
    HANDLER(EmcPmacroQuseDdllRank1_5, 107, 10:0, 10:0)               \
    HANDLER(EmcPmacroQuseDdllRank1_5, 107, 26:16, 21:11)             \
    HANDLER(EmcTClkStable, 107, 6:0, 28:22)                          \
    HANDLER(EmcPmacroDataPadTxCtrl, 107, 7:6, 30:29)                 \
    HANDLER(EmcCfg, 107, 29:29, 31:31)                               \
    HANDLER(EmcPmacroObDdllLongDqRank0_0, 108, 10:0, 10:0)           \
    HANDLER(EmcPmacroObDdllLongDqRank0_0, 108, 26:16, 21:11)         \
    HANDLER(EmcPdex2Mrr, 108, 6:0, 28:22)                            \
    HANDLER(EmcPmacroDataPadTxCtrl, 108, 11:10, 30:29)               \
    HANDLER(EmcCfg, 108, 30:30, 31:31)                               \
    HANDLER(EmcPmacroObDdllLongDqRank0_1, 109, 10:0, 10:0)           \
    HANDLER(EmcPmacroObDdllLongDqRank0_1, 109, 26:16, 21:11)         \
    HANDLER(EmcRdvMask, 109, 6:0, 28:22)                             \
    HANDLER(EmcPmacroDataPadTxCtrl, 109, 15:14, 30:29)               \
    HANDLER(EmcCfg, 109, 31:31, 31:31)                               \
    HANDLER(EmcPmacroObDdllLongDqRank0_2, 110, 10:0, 10:0)           \
    HANDLER(EmcPmacroObDdllLongDqRank0_2, 110, 26:16, 21:11)         \
    HANDLER(EmcRdvEarlyMask, 110, 6:0, 28:22)                        \
    HANDLER(EmcFbioCfg5, 110, 4:4, 29:29)                            \
    HANDLER(EmcFbioCfg5, 110, 8:8, 30:30)                            \
    HANDLER(EmcFbioCfg5, 110, 10:10, 31:31)                          \
    HANDLER(EmcPmacroObDdllLongDqRank0_3, 111, 10:0, 10:0)           \
    HANDLER(EmcPmacroObDdllLongDqRank0_3, 111, 26:16, 21:11)         \
    HANDLER(EmcRdvEarly, 111, 6:0, 28:22)                            \
    HANDLER(EmcFbioCfg5, 111, 12:12, 29:29)                          \
    HANDLER(EmcFbioCfg5, 111, 25:24, 31:30)                          \
    HANDLER(EmcPmacroObDdllLongDqRank0_4, 112, 10:0, 10:0)           \
    HANDLER(EmcPmacroObDdllLongDqRank0_4, 112, 26:16, 21:11)         \
    HANDLER(EmcPmacroDdllShortCmd_2, 112, 6:0, 28:22)                \
    HANDLER(EmcFbioCfg5, 112, 28:26, 31:29)                          \
    HANDLER(EmcPmacroObDdllLongDqRank0_5, 113, 10:0, 10:0)           \
    HANDLER(EmcPmacroObDdllLongDqRank0_5, 113, 26:16, 21:11)         \
    HANDLER(McEmemArbTimingRp, 113, 6:0, 28:22)                      \
    HANDLER(EmcFbioCfg5, 113, 31:30, 30:29)                          \
    HANDLER(EmcCfg2, 113, 0:0, 31:31)                                \
    HANDLER(EmcPmacroObDdllLongDqRank1_0, 114, 10:0, 10:0)           \
    HANDLER(EmcPmacroObDdllLongDqRank1_0, 114, 26:16, 21:11)         \
    HANDLER(McEmemArbTimingRas, 114, 6:0, 28:22)                     \
    HANDLER(EmcCfg2, 114, 2:1, 30:29)                                \
    HANDLER(EmcCfg2, 114, 7:7, 31:31)                                \
    HANDLER(EmcPmacroObDdllLongDqRank1_1, 115, 10:0, 10:0)           \
    HANDLER(EmcPmacroObDdllLongDqRank1_1, 115, 26:16, 21:11)         \
    HANDLER(McEmemArbTimingFaw, 115, 6:0, 28:22)                     \
    HANDLER(EmcCfg2, 115, 11:10, 30:29)                              \
    HANDLER(EmcCfg2, 115, 14:14, 31:31)                              \
    HANDLER(EmcPmacroObDdllLongDqRank1_2, 123, 10:0, 10:0)           \
    HANDLER(EmcPmacroObDdllLongDqRank1_2, 123, 26:16, 21:11)         \
    HANDLER(McEmemArbTimingRap2Pre, 123, 6:0, 28:22)                 \
    HANDLER(EmcCfg2, 123, 16:15, 30:29)                              \
    HANDLER(EmcCfg2, 123, 20:20, 31:31)                              \
    HANDLER(EmcPmacroObDdllLongDqRank1_3, 124, 10:0, 10:0)           \
    HANDLER(EmcPmacroObDdllLongDqRank1_3, 124, 26:16, 21:11)         \
    HANDLER(McEmemArbTimingWap2Pre, 124, 6:0, 28:22)                 \
    HANDLER(EmcCfg2, 124, 24:22, 31:29)                              \
    HANDLER(EmcPmacroObDdllLongDqRank1_4, 125, 10:0, 10:0)           \
    HANDLER(EmcPmacroObDdllLongDqRank1_4, 125, 26:16, 21:11)         \
    HANDLER(McEmemArbTimingR2W, 125, 6:0, 28:22)                     \
    HANDLER(EmcCfg2, 125, 25:25, 29:29)                              \
    HANDLER(EmcCfg2, 125, 29:28, 31:30)                              \
    HANDLER(EmcPmacroObDdllLongDqRank1_5, 126, 10:0, 10:0)           \
    HANDLER(EmcPmacroObDdllLongDqRank1_5, 126, 26:16, 21:11)         \
    HANDLER(McEmemArbTimingW2R, 126, 6:0, 28:22)                     \
    HANDLER(EmcCfg2, 126, 31:30, 30:29)                              \
    HANDLER(EmcCfgPipe, 126, 0:0, 31:31)                             \
    HANDLER(EmcPmacroObDdllLongDqsRank0_0, 127, 10:0, 10:0)          \
    HANDLER(EmcPmacroObDdllLongDqsRank0_0, 127, 26:16, 21:11)        \
    HANDLER(EmcRp, 127, 5:0, 27:22)                                  \
    HANDLER(EmcCfgPipe, 127, 4:1, 31:28)                             \
    HANDLER(EmcPmacroObDdllLongDqsRank0_1, 128, 10:0, 10:0)          \
    HANDLER(EmcPmacroObDdllLongDqsRank0_1, 128, 26:16, 21:11)        \
    HANDLER(EmcR2w, 128, 5:0, 27:22)                                 \
    HANDLER(EmcCfgPipe, 128, 8:5, 31:28)                             \
    HANDLER(EmcPmacroObDdllLongDqsRank0_2, 129, 10:0, 10:0)          \
    HANDLER(EmcPmacroObDdllLongDqsRank0_2, 129, 26:16, 21:11)        \
    HANDLER(EmcW2r, 129, 5:0, 27:22)                                 \
    HANDLER(EmcCfgPipe, 129, 11:9, 30:28)                            \
    HANDLER(EmcCfgPipe, 129, 16:16, 31:31)                           \
    HANDLER(EmcPmacroObDdllLongDqsRank0_3, 130, 10:0, 10:0)          \
    HANDLER(EmcPmacroObDdllLongDqsRank0_3, 130, 26:16, 21:11)        \
    HANDLER(EmcR2p, 130, 5:0, 27:22)                                 \
    HANDLER(EmcCfgPipe, 130, 20:17, 31:28)                           \
    HANDLER(EmcPmacroObDdllLongDqsRank0_4, 131, 10:0, 10:0)          \
    HANDLER(EmcPmacroObDdllLongDqsRank0_4, 131, 26:16, 21:11)        \
    HANDLER(EmcCcdmw, 131, 5:0, 27:22)                               \
    HANDLER(EmcCfgPipe, 131, 24:21, 31:28)                           \
    HANDLER(EmcPmacroObDdllLongDqsRank0_5, 132, 10:0, 10:0)          \
    HANDLER(EmcPmacroObDdllLongDqsRank0_5, 132, 26:16, 21:11)        \
    HANDLER(EmcRdRcd, 132, 5:0, 27:22)                               \
    HANDLER(EmcCfgPipe, 132, 27:25, 30:28)                           \
    HANDLER(EmcPmacroTxPwrd0, 132, 0:0, 31:31)                       \
    HANDLER(EmcPmacroObDdllLongDqsRank1_0, 133, 10:0, 10:0)          \
    HANDLER(EmcPmacroObDdllLongDqsRank1_0, 133, 26:16, 21:11)        \
    HANDLER(EmcWrRcd, 133, 5:0, 27:22)                               \
    HANDLER(EmcPmacroTxPwrd0, 133, 4:1, 31:28)                       \
    HANDLER(EmcPmacroObDdllLongDqsRank1_1, 134, 10:0, 10:0)          \
    HANDLER(EmcPmacroObDdllLongDqsRank1_1, 134, 26:16, 21:11)        \
    HANDLER(EmcWdv, 134, 5:0, 27:22)                                 \
    HANDLER(EmcPmacroTxPwrd0, 134, 8:5, 31:28)                       \
    HANDLER(EmcPmacroObDdllLongDqsRank1_2, 135, 10:0, 10:0)          \
    HANDLER(EmcPmacroObDdllLongDqsRank1_2, 135, 26:16, 21:11)        \
    HANDLER(EmcQUse, 135, 5:0, 27:22)                                \
    HANDLER(EmcPmacroTxPwrd0, 135, 12:9, 31:28)                      \
    HANDLER(EmcPmacroObDdllLongDqsRank1_3, 136, 10:0, 10:0)          \
    HANDLER(EmcPmacroObDdllLongDqsRank1_3, 136, 26:16, 21:11)        \
    HANDLER(EmcPdEx2Wr, 136, 5:0, 27:22)                             \
    HANDLER(EmcPmacroTxPwrd0, 136, 13:13, 28:28)                     \
    HANDLER(EmcPmacroTxPwrd0, 136, 18:16, 31:29)                     \
    HANDLER(EmcPmacroObDdllLongDqsRank1_4, 137, 10:0, 10:0)          \
    HANDLER(EmcPmacroObDdllLongDqsRank1_4, 137, 26:16, 21:11)        \
    HANDLER(EmcPdEx2Rd, 137, 5:0, 27:22)                             \
    HANDLER(EmcPmacroTxPwrd0, 137, 22:19, 31:28)                     \
    HANDLER(EmcPmacroObDdllLongDqsRank1_5, 138, 10:0, 10:0)          \
    HANDLER(EmcPmacroObDdllLongDqsRank1_5, 138, 26:16, 21:11)        \
    HANDLER(EmcPdex2Cke, 138, 5:0, 27:22)                            \
    HANDLER(EmcPmacroTxPwrd0, 138, 26:23, 31:28)                     \
    HANDLER(EmcPmacroIbDdllLongDqsRank0_0, 139, 10:0, 10:0)          \
    HANDLER(EmcPmacroIbDdllLongDqsRank0_0, 139, 26:16, 21:11)        \
    HANDLER(EmcPChg2Pden, 139, 5:0, 27:22)                           \
    HANDLER(EmcPmacroTxPwrd0, 139, 29:27, 30:28)                     \
    HANDLER(EmcPmacroTxPwrd1, 139, 0:0, 31:31)                       \
    HANDLER(EmcPmacroIbDdllLongDqsRank0_1, 140, 10:0, 10:0)          \
    HANDLER(EmcPmacroIbDdllLongDqsRank0_1, 140, 26:16, 21:11)        \
    HANDLER(EmcAct2Pden, 140, 5:0, 27:22)                            \
    HANDLER(EmcPmacroTxPwrd1, 140, 4:1, 31:28)                       \
    HANDLER(EmcPmacroIbDdllLongDqsRank0_2, 141, 10:0, 10:0)          \
    HANDLER(EmcPmacroIbDdllLongDqsRank0_2, 141, 26:16, 21:11)        \
    HANDLER(EmcCke2Pden, 141, 5:0, 27:22)                            \
    HANDLER(EmcPmacroTxPwrd1, 141, 8:5, 31:28)                       \
    HANDLER(EmcPmacroIbDdllLongDqsRank0_3, 142, 10:0, 10:0)          \
    HANDLER(EmcPmacroIbDdllLongDqsRank0_3, 142, 26:16, 21:11)        \
    HANDLER(EmcTcke, 142, 5:0, 27:22)                                \
    HANDLER(EmcPmacroTxPwrd1, 142, 12:9, 31:28)                      \
    HANDLER(EmcPmacroIbDdllLongDqsRank1_0, 143, 10:0, 10:0)          \
    HANDLER(EmcPmacroIbDdllLongDqsRank1_0, 143, 26:16, 21:11)        \
    HANDLER(EmcTrpab, 143, 5:0, 27:22)                               \
    HANDLER(EmcPmacroTxPwrd1, 143, 13:13, 28:28)                     \
    HANDLER(EmcPmacroTxPwrd1, 143, 18:16, 31:29)                     \
    HANDLER(EmcPmacroIbDdllLongDqsRank1_1, 144, 10:0, 10:0)          \
    HANDLER(EmcPmacroIbDdllLongDqsRank1_1, 144, 26:16, 21:11)        \
    HANDLER(EmcClkenOverride, 144, 3:1, 24:22)                       \
    HANDLER(EmcClkenOverride, 144, 8:6, 27:25)                       \
    HANDLER(EmcPmacroTxPwrd1, 144, 22:19, 31:28)                     \
    HANDLER(EmcPmacroIbDdllLongDqsRank1_2, 145, 10:0, 10:0)          \
    HANDLER(EmcPmacroIbDdllLongDqsRank1_2, 145, 26:16, 21:11)        \
    HANDLER(EmcEInput, 145, 5:0, 27:22)                              \
    HANDLER(EmcPmacroTxPwrd1, 145, 26:23, 31:28)                     \
    HANDLER(EmcPmacroIbDdllLongDqsRank1_3, 146, 10:0, 10:0)          \
    HANDLER(EmcPmacroIbDdllLongDqsRank1_3, 146, 26:16, 21:11)        \
    HANDLER(EmcEInputDuration, 146, 5:0, 27:22)                      \
    HANDLER(EmcPmacroTxPwrd1, 146, 29:27, 30:28)                     \
    HANDLER(EmcPmacroTxPwrd2, 146, 0:0, 31:31)                       \
    HANDLER(EmcPmacroDdllLongCmd_0, 147, 10:0, 10:0)                 \
    HANDLER(EmcPmacroDdllLongCmd_0, 147, 26:16, 21:11)               \
    HANDLER(EmcPutermExtra, 147, 5:0, 27:22)                         \
    HANDLER(EmcPmacroTxPwrd2, 147, 4:1, 31:28)                       \
    HANDLER(EmcPmacroDdllLongCmd_1, 148, 10:0, 10:0)                 \
    HANDLER(EmcPmacroDdllLongCmd_1, 148, 26:16, 21:11)               \
    HANDLER(EmcTckesr, 148, 5:0, 27:22)                              \
    HANDLER(EmcPmacroTxPwrd2, 148, 8:5, 31:28)                       \
    HANDLER(EmcPmacroDdllLongCmd_2, 149, 10:0, 10:0)                 \
    HANDLER(EmcPmacroDdllLongCmd_2, 149, 26:16, 21:11)               \
    HANDLER(EmcTpd, 149, 5:0, 27:22)                                 \
    HANDLER(EmcPmacroTxPwrd2, 149, 12:9, 31:28)                      \
    HANDLER(EmcPmacroDdllLongCmd_3, 150, 10:0, 10:0)                 \
    HANDLER(EmcPmacroDdllLongCmd_3, 150, 26:16, 21:11)               \
    HANDLER(EmcWdvMask, 150, 5:0, 27:22)                             \
    HANDLER(EmcPmacroTxPwrd2, 150, 13:13, 28:28)                     \
    HANDLER(EmcPmacroTxPwrd2, 150, 18:16, 31:29)                     \
    HANDLER(McEmemArbCfg, 151, 8:0, 8:0)                             \
    HANDLER(McEmemArbCfg, 151, 20:16, 13:9)                          \
    HANDLER(McEmemArbCfg, 151, 31:24, 21:14)                         \
    HANDLER(EmcWdvChk, 151, 5:0, 27:22)                              \
    HANDLER(EmcPmacroTxPwrd2, 151, 22:19, 31:28)                     \
    HANDLER(McEmemArbMisc1, 152, 12:0, 12:0)                         \
    HANDLER(McEmemArbMisc1, 152, 25:21, 17:13)                       \
    HANDLER(McEmemArbMisc1, 152, 31:28, 21:18)                       \
    HANDLER(EmcCmdBrlshft0, 152, 5:0, 27:22)                         \
    HANDLER(EmcPmacroTxPwrd2, 152, 26:23, 31:28)                     \
    HANDLER(EmcMrsWaitCnt2, 153, 9:0, 9:0)                           \
    HANDLER(EmcMrsWaitCnt2, 153, 26:16, 20:10)                       \
    HANDLER(EmcPmacroIbRxrt, 153, 10:0, 31:21)                       \
    HANDLER(EmcMrsWaitCnt, 154, 9:0, 9:0)                            \
    HANDLER(EmcMrsWaitCnt, 154, 26:16, 20:10)                        \
    HANDLER(EmcPmacroDdllLongCmd_4, 154, 10:0, 31:21)                \
    HANDLER(EmcAutoCalInterval, 155, 20:0, 20:0)                     \
    HANDLER(McEmemArbOutstandingReq, 155, 8:0, 29:21)                \
    HANDLER(McEmemArbOutstandingReq, 155, 31:30, 31:30)              \
    HANDLER(McEmemArbRefpbHpCtrl, 156, 6:0, 6:0)                     \
    HANDLER(McEmemArbRefpbHpCtrl, 156, 14:8, 13:7)                   \
    HANDLER(McEmemArbRefpbHpCtrl, 156, 22:16, 20:14)                 \
    HANDLER(EmcCmdBrlshft1, 156, 5:0, 26:21)                         \
    HANDLER(EmcRrd, 156, 4:0, 31:27)                                 \
    HANDLER(EmcQuseBrlshft0, 157, 19:0, 19:0)                        \
    HANDLER(EmcFbioCfg8, 157, 27:16, 31:20)                          \
    HANDLER(EmcQuseBrlshft1, 158, 19:0, 19:0)                        \
    HANDLER(EmcTxsrDll, 158, 11:0, 31:20)                            \
    HANDLER(EmcQuseBrlshft2, 159, 19:0, 19:0)                        \
    HANDLER(EmcTxdsrvttgen, 159, 11:0, 31:20)                        \
    HANDLER(EmcQuseBrlshft3, 160, 19:0, 19:0)                        \
    HANDLER(EmcPmacroVttgenCtrl0, 160, 3:0, 23:20)                   \
    HANDLER(EmcPmacroVttgenCtrl0, 160, 11:8, 27:24)                  \
    HANDLER(EmcPmacroVttgenCtrl0, 160, 19:16, 31:28)                 \
    HANDLER(EmcPmacroVttgenCtrl1, 161, 19:0, 19:0)                   \
    HANDLER(EmcCmdBrlshft2, 161, 5:0, 25:20)                         \
    HANDLER(EmcCmdBrlshft3, 161, 5:0, 31:26)                         \
    HANDLER(EmcAutoCalConfig3, 162, 5:0, 5:0)                        \
    HANDLER(EmcAutoCalConfig3, 162, 13:8, 11:6)                      \
    HANDLER(EmcAutoCalConfig3, 162, 18:16, 14:12)                    \
    HANDLER(EmcAutoCalConfig3, 162, 22:20, 17:15)                    \
    HANDLER(EmcTRefBw, 162, 13:0, 31:18)                             \
    HANDLER(EmcAutoCalConfig4, 163, 5:0, 5:0)                        \
    HANDLER(EmcAutoCalConfig4, 163, 13:8, 11:6)                      \
    HANDLER(EmcAutoCalConfig4, 163, 18:16, 14:12)                    \
    HANDLER(EmcAutoCalConfig4, 163, 22:20, 17:15)                    \
    HANDLER(EmcQpop, 163, 6:0, 24:18)                                \
    HANDLER(EmcQpop, 163, 22:16, 31:25)                              \
    HANDLER(EmcAutoCalConfig5, 164, 5:0, 5:0)                        \
    HANDLER(EmcAutoCalConfig5, 164, 13:8, 11:6)                      \
    HANDLER(EmcAutoCalConfig5, 164, 18:16, 14:12)                    \
    HANDLER(EmcAutoCalConfig5, 164, 22:20, 17:15)                    \
    HANDLER(EmcPmacroAutocalCfgCommon, 164, 5:0, 23:18)              \
    HANDLER(EmcPmacroAutocalCfgCommon, 164, 13:8, 29:24)             \
    HANDLER(EmcPmacroAutocalCfgCommon, 164, 16:16, 30:30)            \
    HANDLER(EmcPmacroTxPwrd2, 164, 27:27, 31:31)                     \
    HANDLER(EmcAutoCalConfig6, 165, 5:0, 5:0)                        \
    HANDLER(EmcAutoCalConfig6, 165, 13:8, 11:6)                      \
    HANDLER(EmcAutoCalConfig6, 165, 18:16, 14:12)                    \
    HANDLER(EmcAutoCalConfig6, 165, 22:20, 17:15)                    \
    HANDLER(EmcWev, 165, 5:0, 23:18)                                 \
    HANDLER(EmcWsv, 165, 5:0, 29:24)                                 \
    HANDLER(EmcPmacroTxPwrd2, 165, 29:28, 31:30)                     \
    HANDLER(EmcAutoCalConfig7, 166, 5:0, 5:0)                        \
    HANDLER(EmcAutoCalConfig7, 166, 13:8, 11:6)                      \
    HANDLER(EmcAutoCalConfig7, 166, 18:16, 14:12)                    \
    HANDLER(EmcAutoCalConfig7, 166, 22:20, 17:15)                    \
    HANDLER(EmcCfg3, 166, 2:0, 20:18)                                \
    HANDLER(EmcCfg3, 166, 6:4, 23:21)                                \
    HANDLER(EmcQuseWidth, 166, 3:0, 27:24)                           \
    HANDLER(EmcQuseWidth, 166, 29:28, 29:28)                         \
    HANDLER(EmcPmacroTxPwrd3, 166, 1:0, 31:30)                       \
    HANDLER(EmcAutoCalConfig8, 167, 5:0, 5:0)                        \
    HANDLER(EmcAutoCalConfig8, 167, 13:8, 11:6)                      \
    HANDLER(EmcAutoCalConfig8, 167, 18:16, 14:12)                    \
    HANDLER(EmcAutoCalConfig8, 167, 22:20, 17:15)                    \
    HANDLER(EmcPmacroBgBiasCtrl0, 167, 2:0, 20:18)                   \
    HANDLER(EmcPmacroBgBiasCtrl0, 167, 6:4, 23:21)                   \
    HANDLER(McEmemArbTimingRcd, 167, 5:0, 29:24)                     \
    HANDLER(EmcPmacroTxPwrd3, 167, 3:2, 31:30)                       \
    HANDLER(EmcXm2CompPadCtrl2, 168, 17:0, 17:0)                     \
    HANDLER(McEmemArbTimingCcdmw, 168, 5:0, 23:18)                   \
    HANDLER(McEmemArbOverride, 168, 27:27, 24:24)                    \
    HANDLER(McEmemArbOverride, 168, 26:26, 25:25)                    \
    HANDLER(McEmemArbOverride, 168, 16:16, 26:26)                    \
    HANDLER(McEmemArbOverride, 168, 10:10, 27:27)                    \
    HANDLER(McEmemArbOverride, 168, 4:4, 28:28)                      \
    HANDLER(McEmemArbOverride, 168, 3:3, 29:29)                      \
    HANDLER(EmcPmacroTxPwrd3, 168, 5:4, 31:30)                       \
    HANDLER(EmcXm2CompPadCtrl3, 169, 17:0, 17:0)                     \
    HANDLER(EmcRext, 169, 4:0, 22:18)                                \
    HANDLER(EmcTClkStop, 169, 4:0, 27:23)                            \
    HANDLER(EmcPmacroTxPwrd3, 169, 9:6, 31:28)                       \
    HANDLER(EmcZcalWaitCnt, 170, 10:0, 10:0)                         \
    HANDLER(EmcZcalWaitCnt, 170, 21:16, 16:11)                       \
    HANDLER(EmcZcalWaitCnt, 170, 31:31, 17:17)                       \
    HANDLER(EmcWext, 170, 4:0, 22:18)                                \
    HANDLER(EmcRefctrl2, 170, 0:0, 23:23)                            \
    HANDLER(EmcRefctrl2, 170, 26:24, 26:24)                          \
    HANDLER(EmcRefctrl2, 170, 31:31, 27:27)                          \
    HANDLER(EmcPmacroTxPwrd3, 170, 13:10, 31:28)                     \
    HANDLER(EmcZcalMrwCmd, 171, 7:0, 7:0)                            \
    HANDLER(EmcZcalMrwCmd, 171, 23:16, 15:8)                         \
    HANDLER(EmcZcalMrwCmd, 171, 31:30, 17:16)                        \
    HANDLER(EmcWeDuration, 171, 4:0, 22:18)                          \
    HANDLER(EmcWsDuration, 171, 4:0, 27:23)                          \
    HANDLER(EmcPmacroTxPwrd3, 171, 19:16, 31:28)                     \
    HANDLER(EmcSwizzleRank0Byte0, 172, 2:0, 2:0)                     \
    HANDLER(EmcSwizzleRank0Byte0, 172, 6:4, 5:3)                     \
    HANDLER(EmcSwizzleRank0Byte0, 172, 10:8, 8:6)                    \
    HANDLER(EmcSwizzleRank0Byte0, 172, 14:12, 11:9)                  \
    HANDLER(EmcSwizzleRank0Byte0, 172, 18:16, 14:12)                 \
    HANDLER(EmcSwizzleRank0Byte0, 172, 22:20, 17:15)                 \
    HANDLER(EmcPutermWidth, 172, 31:31, 18:18)                       \
    HANDLER(EmcPutermWidth, 172, 3:0, 22:19)                         \
    HANDLER(McEmemArbTimingRrd, 172, 4:0, 27:23)                     \
    HANDLER(EmcPmacroTxPwrd3, 172, 23:20, 31:28)                     \
    HANDLER(EmcSwizzleRank0Byte1, 173, 2:0, 2:0)                     \
    HANDLER(EmcSwizzleRank0Byte1, 173, 6:4, 5:3)                     \
    HANDLER(EmcSwizzleRank0Byte1, 173, 10:8, 8:6)                    \
    HANDLER(EmcSwizzleRank0Byte1, 173, 14:12, 11:9)                  \
    HANDLER(EmcSwizzleRank0Byte1, 173, 18:16, 14:12)                 \
    HANDLER(EmcSwizzleRank0Byte1, 173, 22:20, 17:15)                 \
    HANDLER(McEmemArbTimingR2R, 173, 4:0, 22:18)                     \
    HANDLER(McEmemArbTimingW2W, 173, 4:0, 27:23)                     \
    HANDLER(EmcPmacroTxPwrd3, 173, 27:24, 31:28)                     \
    HANDLER(EmcSwizzleRank0Byte2, 174, 2:0, 2:0)                     \
    HANDLER(EmcSwizzleRank0Byte2, 174, 6:4, 5:3)                     \
    HANDLER(EmcSwizzleRank0Byte2, 174, 10:8, 8:6)                    \
    HANDLER(EmcSwizzleRank0Byte2, 174, 14:12, 11:9)                  \
    HANDLER(EmcSwizzleRank0Byte2, 174, 18:16, 14:12)                 \
    HANDLER(EmcSwizzleRank0Byte2, 174, 22:20, 17:15)                 \
    HANDLER(EmcPmacroTxPwrd3, 174, 29:28, 19:18)                     \
    HANDLER(EmcPmacroTxSelClkSrc0, 174, 11:0, 31:20)                 \
    HANDLER(EmcSwizzleRank0Byte3, 175, 2:0, 2:0)                     \
    HANDLER(EmcSwizzleRank0Byte3, 175, 6:4, 5:3)                     \
    HANDLER(EmcSwizzleRank0Byte3, 175, 10:8, 8:6)                    \
    HANDLER(EmcSwizzleRank0Byte3, 175, 14:12, 11:9)                  \
    HANDLER(EmcSwizzleRank0Byte3, 175, 18:16, 14:12)                 \
    HANDLER(EmcSwizzleRank0Byte3, 175, 22:20, 17:15)                 \
    HANDLER(EmcPmacroTxSelClkSrc0, 175, 27:16, 29:18)                \
    HANDLER(EmcPmacroTxSelClkSrc1, 175, 1:0, 31:30)                  \
    HANDLER(EmcSwizzleRank1Byte0, 176, 2:0, 2:0)                     \
    HANDLER(EmcSwizzleRank1Byte0, 176, 6:4, 5:3)                     \
    HANDLER(EmcSwizzleRank1Byte0, 176, 10:8, 8:6)                    \
    HANDLER(EmcSwizzleRank1Byte0, 176, 14:12, 11:9)                  \
    HANDLER(EmcSwizzleRank1Byte0, 176, 18:16, 14:12)                 \
    HANDLER(EmcSwizzleRank1Byte0, 176, 22:20, 17:15)                 \
    HANDLER(EmcPmacroTxSelClkSrc1, 176, 11:2, 27:18)                 \
    HANDLER(EmcPmacroTxSelClkSrc1, 176, 19:16, 31:28)                \
    HANDLER(EmcSwizzleRank1Byte1, 177, 2:0, 2:0)                     \
    HANDLER(EmcSwizzleRank1Byte1, 177, 6:4, 5:3)                     \
    HANDLER(EmcSwizzleRank1Byte1, 177, 10:8, 8:6)                    \
    HANDLER(EmcSwizzleRank1Byte1, 177, 14:12, 11:9)                  \
    HANDLER(EmcSwizzleRank1Byte1, 177, 18:16, 14:12)                 \
    HANDLER(EmcSwizzleRank1Byte1, 177, 22:20, 17:15)                 \
    HANDLER(EmcPmacroTxSelClkSrc1, 177, 27:20, 25:18)                \
    HANDLER(EmcPmacroTxSelClkSrc3, 177, 5:0, 31:26)                  \
    HANDLER(EmcSwizzleRank1Byte2, 178, 2:0, 2:0)                     \
    HANDLER(EmcSwizzleRank1Byte2, 178, 6:4, 5:3)                     \
    HANDLER(EmcSwizzleRank1Byte2, 178, 10:8, 8:6)                    \
    HANDLER(EmcSwizzleRank1Byte2, 178, 14:12, 11:9)                  \
    HANDLER(EmcSwizzleRank1Byte2, 178, 18:16, 14:12)                 \
    HANDLER(EmcSwizzleRank1Byte2, 178, 22:20, 17:15)                 \
    HANDLER(EmcPmacroTxSelClkSrc3, 178, 11:6, 23:18)                 \
    HANDLER(EmcPmacroTxSelClkSrc3, 178, 23:16, 31:24)                \
    HANDLER(EmcSwizzleRank1Byte3, 179, 2:0, 2:0)                     \
    HANDLER(EmcSwizzleRank1Byte3, 179, 6:4, 5:3)                     \
    HANDLER(EmcSwizzleRank1Byte3, 179, 10:8, 8:6)                    \
    HANDLER(EmcSwizzleRank1Byte3, 179, 14:12, 11:9)                  \
    HANDLER(EmcSwizzleRank1Byte3, 179, 18:16, 14:12)                 \
    HANDLER(EmcSwizzleRank1Byte3, 179, 22:20, 17:15)                 \
    HANDLER(EmcPmacroTxSelClkSrc3, 179, 27:24, 21:18)                \
    HANDLER(EmcPmacroTxSelClkSrc2, 179, 9:0, 31:22)                  \
    HANDLER(EmcPmacroCmdBrickCtrlFdpd, 180, 17:0, 17:0)              \
    HANDLER(EmcPmacroTxSelClkSrc2, 180, 11:10, 19:18)                \
    HANDLER(EmcPmacroTxSelClkSrc2, 180, 27:16, 31:20)                \
    HANDLER(EmcPmacroDataBrickCtrlFdpd, 181, 17:0, 17:0)             \
    HANDLER(EmcPmacroTxSelClkSrc4, 181, 11:0, 29:18)                 \
    HANDLER(EmcPmacroTxSelClkSrc4, 181, 17:16, 31:30)                \
    HANDLER(EmcFbioCfg7, 182, 16:0, 16:0)                            \
    HANDLER(McEmemArbRefpbBankCtrl, 182, 6:0, 23:17)                 \
    HANDLER(McEmemArbRefpbBankCtrl, 182, 14:8, 30:24)                \
    HANDLER(McEmemArbRefpbBankCtrl, 182, 31:31, 31:31)               \
    HANDLER(EmcDynSelfRefControl, 183, 15:0, 15:0)                   \
    HANDLER(EmcDynSelfRefControl, 183, 31:31, 16:16)                 \
    HANDLER(EmcPmacroTxSelClkSrc4, 183, 27:18, 26:17)                \
    HANDLER(EmcPmacroTxSelClkSrc5, 183, 4:0, 31:27)                  \
    HANDLER(EmcDllCfg1, 184, 16:0, 16:0)                             \
    HANDLER(EmcPmacroTxSelClkSrc5, 184, 11:5, 23:17)                 \
    HANDLER(EmcPmacroTxSelClkSrc5, 184, 23:16, 31:24)                \
    HANDLER(EmcPmacroPadCfgCtrl, 185, 1:0, 1:0)                      \
    HANDLER(EmcPmacroPadCfgCtrl, 185, 6:5, 3:2)                      \
    HANDLER(EmcPmacroPadCfgCtrl, 185, 11:9, 6:4)                     \
    HANDLER(EmcPmacroPadCfgCtrl, 185, 13:13, 7:7)                    \
    HANDLER(EmcPmacroPadCfgCtrl, 185, 17:16, 9:8)                    \
    HANDLER(EmcPmacroPadCfgCtrl, 185, 21:20, 11:10)                  \
    HANDLER(EmcPmacroPadCfgCtrl, 185, 25:24, 13:12)                  \
    HANDLER(EmcPmacroPadCfgCtrl, 185, 30:28, 16:14)                  \
    HANDLER(EmcPmacroTxSelClkSrc5, 185, 27:24, 20:17)                \
    HANDLER(EmcPmacroCmdPadTxCtrl, 185, 1:0, 22:21)                  \
    HANDLER(EmcPmacroCmdPadTxCtrl, 185, 5:4, 24:23)                  \
    HANDLER(EmcPmacroCmdPadTxCtrl, 185, 9:8, 26:25)                  \
    HANDLER(EmcPmacroCmdPadTxCtrl, 185, 13:12, 28:27)                \
    HANDLER(EmcPmacroCmdPadTxCtrl, 185, 16:16, 29:29)                \
    HANDLER(EmcPmacroCmdPadTxCtrl, 185, 21:20, 31:30)                \
    HANDLER(EmcRefresh, 186, 15:0, 15:0)                             \
    HANDLER(EmcCmdQ, 186, 4:0, 20:16)                                \
    HANDLER(EmcCmdQ, 186, 10:8, 23:21)                               \
    HANDLER(EmcCmdQ, 186, 14:12, 26:24)                              \
    HANDLER(EmcCmdQ, 186, 28:24, 31:27)                              \
    HANDLER(EmcAcpdControl, 187, 15:0, 15:0)                         \
    HANDLER(EmcAutoCalVrefSel1, 187, 15:0, 31:16)                    \
    HANDLER(EmcXm2CompPadCtrl, 188, 1:0, 1:0)                        \
    HANDLER(EmcXm2CompPadCtrl, 188, 6:3, 5:2)                        \
    HANDLER(EmcXm2CompPadCtrl, 188, 9:9, 6:6)                        \
    HANDLER(EmcXm2CompPadCtrl, 188, 19:11, 15:7)                     \
    HANDLER(EmcCfgDigDllPeriod, 188, 15:0, 31:16)                    \
    HANDLER(EmcCfgDigDll_1, 189, 15:0, 15:0)                         \
    HANDLER(EmcPreRefreshReqCnt, 189, 15:0, 31:16)                   \
    HANDLER(EmcPmacroCmdPadTxCtrl, 190, 27:24, 19:16)                \
    HANDLER(EmcPmacroDataPadTxCtrl, 190, 1:0, 21:20)                 \
    HANDLER(EmcPmacroDataPadTxCtrl, 190, 5:4, 23:22)                 \
    HANDLER(EmcPmacroDataPadTxCtrl, 190, 9:8, 25:24)                 \
    HANDLER(EmcPmacroDataPadTxCtrl, 190, 13:12, 27:26)               \
    HANDLER(EmcPmacroDataPadTxCtrl, 190, 16:16, 28:28)               \
    HANDLER(EmcPmacroDataPadTxCtrl, 190, 21:20, 30:29)               \
    HANDLER(EmcPmacroDataPadTxCtrl, 190, 24:24, 31:31)               \
    HANDLER(EmcPmacroDataPadTxCtrl, 191, 27:25, 2:0)                 \
    HANDLER(EmcPinGpio, 8, 1:0, 31:30)                               \
    HANDLER(EmcPinGpioEn, 9, 1:0, 31:30)                             \
    HANDLER(EmcDevSelect, 10, 1:0, 31:30)                            \
    HANDLER(EmcZcalWarmColdBootEnables, 11, 1:0, 31:30)              \
    HANDLER(EmcCfgDigDllPeriodWarmBoot, 12, 1:0, 31:30)              \
    HANDLER(EmcBctSpare13, 31, 31:0, 31:0)                           \
    HANDLER(EmcBctSpare12, 32, 31:0, 31:0)                           \
    HANDLER(EmcBctSpare7, 33, 31:0, 31:0)                            \
    HANDLER(EmcBctSpare6, 40, 31:0, 31:0)                            \
    HANDLER(EmcBctSpare5, 42, 31:0, 31:0)                            \
    HANDLER(EmcBctSpare4, 44, 31:0, 31:0)                            \
    HANDLER(EmcBctSpare3, 45, 31:0, 31:0)                            \
    HANDLER(EmcBctSpare2, 46, 31:0, 31:0)                            \
    HANDLER(EmcBctSpare1, 47, 31:0, 31:0)                            \
    HANDLER(EmcBctSpare0, 48, 31:0, 31:0)                            \
    HANDLER(EmcBctSpare9, 50, 31:0, 31:0)                            \
    HANDLER(EmcBctSpare8, 51, 31:0, 31:0)                            \
    HANDLER(BootRomPatchData, 56, 31:0, 31:0)                        \
    HANDLER(BootRomPatchControl, 57, 31:0, 31:0)                     \
    HANDLER(McClkenOverrideAllWarmBoot, 58, 0:0, 31:31)              \
    HANDLER(EmcClkenOverrideAllWarmBoot, 59, 0:0, 30:30)             \
    HANDLER(EmcMrsWarmBootEnable, 59, 0:0, 31:31)                    \
    HANDLER(ClearClk2Mc1, 60, 0:0, 30:30)                            \
    HANDLER(EmcWarmBootExtraModeRegWriteEnable, 60, 0:0, 31:31)      \
    HANDLER(ClkRstControllerPllmMisc2OverrideEnable, 61, 0:0, 30:30) \
    HANDLER(EmcDbgWriteMux, 61, 0:0, 31:31)                          \
    HANDLER(EmcExtraRefreshNum, 62, 2:0, 31:29)                      \
    HANDLER(PmcIoDpd3ReqWait, 68, 2:0, 30:28)                        \
    HANDLER(AhbArbitrationXbarCtrlMemInitDone, 68, 0:0, 31:31)       \
    HANDLER(MemoryType, 69, 2:0, 30:28)                              \
    HANDLER(PmcIoDpd4ReqWait, 70, 2:0, 30:28)                        \
    HANDLER(EmcTimingControlWait, 86, 7:0, 31:24)                    \
    HANDLER(EmcZcalWarmBootWait, 87, 7:0, 31:24)                     \
    HANDLER(WarmBootWait, 88, 7:0, 31:24)                            \
    HANDLER(EmcPinProgramWait, 89, 7:0, 31:24)                       \
    HANDLER(EmcAutoCalWait, 101, 9:0, 31:22)                         \
    HANDLER(SwizzleRankByteEncode, 190, 15:0, 15:0)                  \
                                                                     \
    /* PMC SCRATCH fields for LPDDR2. */                             \
    HANDLER(EmcMrwLpddr2ZcalWarmBoot, 5, 23:16, 7:0)                 \
    HANDLER(EmcMrwLpddr2ZcalWarmBoot, 5, 7:0, 15:8)                  \
    HANDLER(EmcWarmBootMrwExtra, 5, 23:16, 23:16)                    \
    HANDLER(EmcWarmBootMrwExtra, 5, 7:0, 31:24)                      \
    HANDLER(EmcMrwLpddr2ZcalWarmBoot, 6, 31:30, 1:0)                 \
    HANDLER(EmcWarmBootMrwExtra, 6, 31:30, 3:2)                      \
    HANDLER(EmcMrwLpddr2ZcalWarmBoot, 6, 27:26, 5:4)                 \
    HANDLER(EmcWarmBootMrwExtra, 6, 27:26, 7:6)                      \
    HANDLER(EmcMrw6, 8, 27:0, 27:0)                                  \
    HANDLER(EmcMrw6, 8, 31:30, 29:28)                                \
    HANDLER(EmcMrw8, 9, 27:0, 27:0)                                  \
    HANDLER(EmcMrw8, 9, 31:30, 29:28)                                \
    HANDLER(EmcMrw9, 10, 27:0, 27:0)                                 \
    HANDLER(EmcMrw9, 10, 31:30, 29:28)                               \
    HANDLER(EmcMrw10, 11, 27:0, 27:0)                                \
    HANDLER(EmcMrw10, 11, 31:30, 29:28)                              \
    HANDLER(EmcMrw12, 12, 27:0, 27:0)                                \
    HANDLER(EmcMrw12, 12, 31:30, 29:28)                              \
    HANDLER(EmcMrw13, 13, 27:0, 27:0)                                \
    HANDLER(EmcMrw13, 13, 31:30, 29:28)                              \
    HANDLER(EmcMrw14, 14, 27:0, 27:0)                                \
    HANDLER(EmcMrw14, 14, 31:30, 29:28)                              \
    HANDLER(EmcMrw1, 15, 7:0, 7:0)                                   \
    HANDLER(EmcMrw1, 15, 23:16, 15:8)                                \
    HANDLER(EmcMrw1, 15, 27:26, 17:16)                               \
    HANDLER(EmcMrw1, 15, 31:30, 19:18)                               \
    HANDLER(EmcWarmBootMrwExtra, 16, 7:0, 7:0)                       \
    HANDLER(EmcWarmBootMrwExtra, 16, 23:16, 15:8)                    \
    HANDLER(EmcWarmBootMrwExtra, 16, 27:26, 17:16)                   \
    HANDLER(EmcWarmBootMrwExtra, 16, 31:30, 19:18)                   \
    HANDLER(EmcMrw2, 17, 7:0, 7:0)                                   \
    HANDLER(EmcMrw2, 17, 23:16, 15:8)                                \
    HANDLER(EmcMrw2, 17, 27:26, 17:16)                               \
    HANDLER(EmcMrw2, 17, 31:30, 19:18)                               \
    HANDLER(EmcMrw3, 18, 7:0, 7:0)                                   \
    HANDLER(EmcMrw3, 18, 23:16, 15:8)                                \
    HANDLER(EmcMrw3, 18, 27:26, 17:16)                               \
    HANDLER(EmcMrw3, 18, 31:30, 19:18)                               \
    HANDLER(EmcMrw4, 19, 7:0, 7:0)                                   \
    HANDLER(EmcMrw4, 19, 23:16, 15:8)                                \
    HANDLER(EmcMrw4, 19, 27:26, 17:16)                               \
    HANDLER(EmcMrw4, 19, 31:30, 19:18)

#define FOREACH_SDRAM_SECURE_SCRATCH_REGISTER_ERISTA(HANDLER)            \
    /* PMC SECURE_SCRATCH fields. */                                     \
    HANDLER(EmcCmdMappingByte, 8, 31:0, 31:0)                            \
    HANDLER(EmcPmacroBrickMapping0, 9, 31:0, 31:0)                       \
    HANDLER(EmcPmacroBrickMapping1, 10, 31:0, 31:0)                      \
    HANDLER(EmcPmacroBrickMapping2, 11, 31:0, 31:0)                      \
    HANDLER(McVideoProtectGpuOverride0, 12, 31:0, 31:0)                  \
    HANDLER(EmcCmdMappingCmd0_0, 13, 6:0, 6:0)                           \
    HANDLER(EmcCmdMappingCmd0_0, 13, 14:8, 13:7)                         \
    HANDLER(EmcCmdMappingCmd0_0, 13, 22:16, 20:14)                       \
    HANDLER(EmcCmdMappingCmd0_0, 13, 30:24, 27:21)                       \
    HANDLER(McVideoProtectBomAdrHi, 13, 1:0, 29:28)                      \
    HANDLER(McVideoProtectWriteAccess, 13, 1:0, 31:30)                   \
    HANDLER(EmcCmdMappingCmd0_1, 14, 6:0, 6:0)                           \
    HANDLER(EmcCmdMappingCmd0_1, 14, 14:8, 13:7)                         \
    HANDLER(EmcCmdMappingCmd0_1, 14, 22:16, 20:14)                       \
    HANDLER(EmcCmdMappingCmd0_1, 14, 30:24, 27:21)                       \
    HANDLER(McSecCarveoutAdrHi, 14, 1:0, 29:28)                          \
    HANDLER(McMtsCarveoutAdrHi, 14, 1:0, 31:30)                          \
    HANDLER(EmcCmdMappingCmd1_0, 15, 6:0, 6:0)                           \
    HANDLER(EmcCmdMappingCmd1_0, 15, 14:8, 13:7)                         \
    HANDLER(EmcCmdMappingCmd1_0, 15, 22:16, 20:14)                       \
    HANDLER(EmcCmdMappingCmd1_0, 15, 30:24, 27:21)                       \
    HANDLER(McGeneralizedCarveout5BomHi, 15, 1:0, 29:28)                 \
    HANDLER(McGeneralizedCarveout3BomHi, 15, 1:0, 31:30)                 \
    HANDLER(EmcCmdMappingCmd1_1, 16, 6:0, 6:0)                           \
    HANDLER(EmcCmdMappingCmd1_1, 16, 14:8, 13:7)                         \
    HANDLER(EmcCmdMappingCmd1_1, 16, 22:16, 20:14)                       \
    HANDLER(EmcCmdMappingCmd1_1, 16, 30:24, 27:21)                       \
    HANDLER(McGeneralizedCarveout2BomHi, 16, 1:0, 29:28)                 \
    HANDLER(McGeneralizedCarveout4BomHi, 16, 1:0, 31:30)                 \
    HANDLER(EmcCmdMappingCmd2_0, 17, 6:0, 6:0)                           \
    HANDLER(EmcCmdMappingCmd2_0, 17, 14:8, 13:7)                         \
    HANDLER(EmcCmdMappingCmd2_0, 17, 22:16, 20:14)                       \
    HANDLER(EmcCmdMappingCmd2_0, 17, 30:24, 27:21)                       \
    HANDLER(McGeneralizedCarveout1BomHi, 17, 1:0, 29:28)                 \
    HANDLER(EmcAdrCfg, 17, 0:0, 30:30)                                   \
    HANDLER(EmcFbioSpare, 17, 1:1, 31:31)                                \
    HANDLER(EmcCmdMappingCmd2_1, 18, 6:0, 6:0)                           \
    HANDLER(EmcCmdMappingCmd2_1, 18, 14:8, 13:7)                         \
    HANDLER(EmcCmdMappingCmd2_1, 18, 22:16, 20:14)                       \
    HANDLER(EmcCmdMappingCmd2_1, 18, 30:24, 27:21)                       \
    HANDLER(EmcFbioCfg8, 18, 15:15, 28:28)                               \
    HANDLER(McEmemAdrCfg, 18, 0:0, 29:29)                                \
    HANDLER(McSecCarveoutProtectWriteAccess, 18, 0:0, 30:30)             \
    HANDLER(McMtsCarveoutRegCtrl, 18, 0:0, 31:31)                        \
    HANDLER(EmcCmdMappingCmd3_0, 19, 6:0, 6:0)                           \
    HANDLER(EmcCmdMappingCmd3_0, 19, 14:8, 13:7)                         \
    HANDLER(EmcCmdMappingCmd3_0, 19, 22:16, 20:14)                       \
    HANDLER(EmcCmdMappingCmd3_0, 19, 30:24, 27:21)                       \
    HANDLER(McGeneralizedCarveout2Cfg0, 19, 6:3, 31:28)                  \
    HANDLER(EmcCmdMappingCmd3_1, 20, 6:0, 6:0)                           \
    HANDLER(EmcCmdMappingCmd3_1, 20, 14:8, 13:7)                         \
    HANDLER(EmcCmdMappingCmd3_1, 20, 22:16, 20:14)                       \
    HANDLER(EmcCmdMappingCmd3_1, 20, 30:24, 27:21)                       \
    HANDLER(McGeneralizedCarveout2Cfg0, 20, 10:7, 31:28)                 \
    HANDLER(McGeneralizedCarveout4Cfg0, 39, 26:0, 26:0)                  \
    HANDLER(McGeneralizedCarveout2Cfg0, 39, 17:14, 30:27)                \
    HANDLER(McVideoProtectVprOverride, 39, 0:0, 31:31)                   \
    HANDLER(McGeneralizedCarveout5Cfg0, 40, 26:0, 26:0)                  \
    HANDLER(McGeneralizedCarveout2Cfg0, 40, 21:18, 30:27)                \
    HANDLER(McVideoProtectVprOverride, 40, 1:1, 31:31)                   \
    HANDLER(EmcCmdMappingCmd0_2, 41, 6:0, 6:0)                           \
    HANDLER(EmcCmdMappingCmd0_2, 41, 14:8, 13:7)                         \
    HANDLER(EmcCmdMappingCmd0_2, 41, 22:16, 20:14)                       \
    HANDLER(EmcCmdMappingCmd0_2, 41, 27:24, 24:21)                       \
    HANDLER(McGeneralizedCarveout1Cfg0, 41, 6:3, 28:25)                  \
    HANDLER(McGeneralizedCarveout2Cfg0, 41, 13:11, 31:29)                \
    HANDLER(EmcCmdMappingCmd1_2, 42, 6:0, 6:0)                           \
    HANDLER(EmcCmdMappingCmd1_2, 42, 14:8, 13:7)                         \
    HANDLER(EmcCmdMappingCmd1_2, 42, 22:16, 20:14)                       \
    HANDLER(EmcCmdMappingCmd1_2, 42, 27:24, 24:21)                       \
    HANDLER(McGeneralizedCarveout1Cfg0, 42, 13:7, 31:25)                 \
    HANDLER(EmcCmdMappingCmd2_2, 43, 6:0, 6:0)                           \
    HANDLER(EmcCmdMappingCmd2_2, 43, 14:8, 13:7)                         \
    HANDLER(EmcCmdMappingCmd2_2, 43, 22:16, 20:14)                       \
    HANDLER(EmcCmdMappingCmd2_2, 43, 27:24, 24:21)                       \
    HANDLER(McGeneralizedCarveout1Cfg0, 43, 17:14, 28:25)                \
    HANDLER(McGeneralizedCarveout3Cfg0, 43, 13:11, 31:29)                \
    HANDLER(EmcCmdMappingCmd3_2, 44, 6:0, 6:0)                           \
    HANDLER(EmcCmdMappingCmd3_2, 44, 14:8, 13:7)                         \
    HANDLER(EmcCmdMappingCmd3_2, 44, 22:16, 20:14)                       \
    HANDLER(EmcCmdMappingCmd3_2, 44, 27:24, 24:21)                       \
    HANDLER(McGeneralizedCarveout1Cfg0, 44, 21:18, 28:25)                \
    HANDLER(McVideoProtectVprOverride, 44, 3:2, 30:29)                   \
    HANDLER(McVideoProtectVprOverride, 44, 6:6, 31:31)                   \
    HANDLER(McEmemAdrCfgChannelMask, 45, 31:9, 22:0)                     \
    HANDLER(McEmemAdrCfgDev0, 45, 2:0, 25:23)                            \
    HANDLER(McEmemAdrCfgDev0, 45, 9:8, 27:26)                            \
    HANDLER(McEmemAdrCfgDev0, 45, 19:16, 31:28)                          \
    HANDLER(McEmemAdrCfgBankMask0, 46, 31:10, 21:0)                      \
    HANDLER(McEmemAdrCfgDev1, 46, 2:0, 24:22)                            \
    HANDLER(McEmemAdrCfgDev1, 46, 9:8, 26:25)                            \
    HANDLER(McEmemAdrCfgDev1, 46, 19:16, 30:27)                          \
    HANDLER(McVideoProtectVprOverride, 46, 7:7, 31:31)                   \
    HANDLER(McEmemAdrCfgBankMask1, 47, 31:10, 21:0)                      \
    HANDLER(McGeneralizedCarveout3Cfg0, 47, 10:3, 29:22)                 \
    HANDLER(McVideoProtectVprOverride, 47, 9:8, 31:30)                   \
    HANDLER(McEmemAdrCfgBankMask2, 48, 31:10, 21:0)                      \
    HANDLER(McGeneralizedCarveout3Cfg0, 48, 21:14, 29:22)                \
    HANDLER(McVideoProtectVprOverride, 48, 11:11, 30:30)                 \
    HANDLER(McVideoProtectVprOverride, 48, 14:14, 31:31)                 \
    HANDLER(McVideoProtectGpuOverride1, 49, 15:0, 15:0)                  \
    HANDLER(McEmemCfg, 49, 13:0, 29:16)                                  \
    HANDLER(McEmemCfg, 49, 31:31, 30:30)                                 \
    HANDLER(McVideoProtectVprOverride, 49, 15:15, 31:31)                 \
    HANDLER(McGeneralizedCarveout3Bom, 50, 31:17, 14:0)                  \
    HANDLER(McGeneralizedCarveout1Bom, 50, 31:17, 29:15)                 \
    HANDLER(McVideoProtectVprOverride, 50, 18:17, 31:30)                 \
    HANDLER(McGeneralizedCarveout4Bom, 51, 31:17, 14:0)                  \
    HANDLER(McGeneralizedCarveout2Bom, 51, 31:17, 29:15)                 \
    HANDLER(McVideoProtectVprOverride, 51, 20:19, 31:30)                 \
    HANDLER(McGeneralizedCarveout5Bom, 52, 31:17, 14:0)                  \
    HANDLER(McVideoProtectBom, 52, 31:20, 26:15)                         \
    HANDLER(McVideoProtectVprOverride, 52, 23:21, 29:27)                 \
    HANDLER(McVideoProtectVprOverride, 52, 26:26, 30:30)                 \
    HANDLER(McVideoProtectVprOverride, 52, 29:29, 31:31)                 \
    HANDLER(McVideoProtectSizeMb, 53, 11:0, 11:0)                        \
    HANDLER(McSecCarveoutBom, 53, 31:20, 23:12)                          \
    HANDLER(McVideoProtectVprOverride, 53, 31:30, 25:24)                 \
    HANDLER(McVideoProtectVprOverride1, 53, 1:0, 27:26)                  \
    HANDLER(McVideoProtectVprOverride1, 53, 7:4, 31:28)                  \
    HANDLER(McSecCarveoutSizeMb, 54, 11:0, 11:0)                         \
    HANDLER(McMtsCarveoutBom, 54, 31:20, 23:12)                          \
    HANDLER(McVideoProtectVprOverride1, 54, 15:8, 31:24)                 \
    HANDLER(McMtsCarveoutSizeMb, 55, 11:0, 11:0)                         \
    HANDLER(McGeneralizedCarveout4Size128kb, 55, 11:0, 23:12)            \
    HANDLER(McVideoProtectVprOverride1, 55, 16:16, 24:24)                \
    HANDLER(McGeneralizedCarveout2Cfg0, 55, 2:0, 27:25)                  \
    HANDLER(McGeneralizedCarveout2Cfg0, 55, 25:22, 31:28)                \
    HANDLER(McGeneralizedCarveout3Size128kb, 56, 11:0, 11:0)             \
    HANDLER(McGeneralizedCarveout2Size128kb, 56, 11:0, 23:12)            \
    HANDLER(McGeneralizedCarveout2Cfg0, 56, 26:26, 24:24)                \
    HANDLER(McGeneralizedCarveout1Cfg0, 56, 2:0, 27:25)                  \
    HANDLER(McGeneralizedCarveout1Cfg0, 56, 25:22, 31:28)                \
    HANDLER(McGeneralizedCarveout1Size128kb, 57, 11:0, 11:0)             \
    HANDLER(McGeneralizedCarveout5Size128kb, 57, 11:0, 23:12)            \
    HANDLER(McGeneralizedCarveout1Cfg0, 57, 26:26, 24:24)                \
    HANDLER(McGeneralizedCarveout3Cfg0, 57, 2:0, 27:25)                  \
    HANDLER(McGeneralizedCarveout3Cfg0, 57, 25:22, 31:28)                \
    HANDLER(McGeneralizedCarveout3Cfg0, 58, 26:26, 0:0)                  \
    HANDLER(McGeneralizedCarveout1Access0, 59, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout1Access1, 60, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout1Access2, 61, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout1Access3, 62, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout1Access4, 63, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout2Access0, 64, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout2Access1, 65, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout2Access2, 66, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout2Access3, 67, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout2Access4, 68, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout3Access0, 69, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout3Access1, 70, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout3Access2, 71, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout3Access3, 72, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout3Access4, 73, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout4Access0, 74, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout4Access1, 75, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout4Access2, 76, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout4Access3, 77, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout4Access4, 78, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout5Access0, 79, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout5Access1, 80, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout5Access2, 81, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout5Access3, 82, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout1ForceInternalAccess0, 84, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout1ForceInternalAccess1, 85, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout1ForceInternalAccess2, 86, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout1ForceInternalAccess3, 87, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout1ForceInternalAccess4, 88, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout2ForceInternalAccess0, 89, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout2ForceInternalAccess1, 90, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout2ForceInternalAccess2, 91, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout2ForceInternalAccess3, 92, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout2ForceInternalAccess4, 93, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout3ForceInternalAccess0, 94, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout3ForceInternalAccess1, 95, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout3ForceInternalAccess2, 96, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout3ForceInternalAccess3, 97, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout3ForceInternalAccess4, 98, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout4ForceInternalAccess0, 99, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout4ForceInternalAccess1, 100, 31:0, 31:0) \
    HANDLER(McGeneralizedCarveout4ForceInternalAccess2, 101, 31:0, 31:0) \
    HANDLER(McGeneralizedCarveout4ForceInternalAccess3, 102, 31:0, 31:0) \
    HANDLER(McGeneralizedCarveout4ForceInternalAccess4, 103, 31:0, 31:0) \
    HANDLER(McGeneralizedCarveout5ForceInternalAccess0, 104, 31:0, 31:0) \
    HANDLER(McGeneralizedCarveout5ForceInternalAccess1, 105, 31:0, 31:0) \
    HANDLER(McGeneralizedCarveout5ForceInternalAccess2, 106, 31:0, 31:0) \
    HANDLER(McGeneralizedCarveout5ForceInternalAccess3, 107, 31:0, 31:0)
