/*
 * Copyright (c) Atmosphre-NX
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#define FOREACH_SDRAM_SCRATCH_REGISTER_MARIKO(HANDLER)               \
    /* PMC SCRATCH fields. */                                        \
    HANDLER(EmcClockSource, 6, 7:0, 15:8)                            \
    HANDLER(EmcClockSourceDll, 6, 7:0, 23:16)                        \
    HANDLER(EmcClockSource, 6, 31:29, 26:24)                         \
    HANDLER(EmcClockSourceDll, 6, 31:29, 29:27)                      \
    HANDLER(EmcClockSourceDll, 6, 11:10, 31:30)                      \
    HANDLER(ClkRstControllerPllmMisc2Override, 7, 9:8, 1:0)          \
    HANDLER(ClkRstControllerPllmMisc2Override, 7, 2:1, 3:2)          \
    HANDLER(EmcZqCalLpDdr4WarmBoot, 7, 31:30, 5:4)                   \
    HANDLER(EmcClockSource, 7, 27:27, 6:6)                           \
    HANDLER(EmcClockSource, 7, 26:26, 7:7)                           \
    HANDLER(EmcClockSource, 7, 15:15, 8:8)                           \
    HANDLER(EmcClockSource, 7, 25:25, 9:9)                           \
    HANDLER(EmcClockSource, 7, 20:19, 11:10)                         \
    HANDLER(EmcClockSource, 7, 16:16, 12:12)                         \
    HANDLER(ClkRstControllerPllmMisc2Override, 7, 13:13, 13:13)      \
    HANDLER(ClkRstControllerPllmMisc2Override, 7, 12:12, 14:14)      \
    HANDLER(ClkRstControllerPllmMisc2Override, 7, 11:11, 15:15)      \
    HANDLER(ClkRstControllerPllmMisc2Override, 7, 10:10, 16:16)      \
    HANDLER(ClkRstControllerPllmMisc2Override, 7, 5:5, 17:17)        \
    HANDLER(ClkRstControllerPllmMisc2Override, 7, 4:4, 18:18)        \
    HANDLER(ClkRstControllerPllmMisc2Override, 7, 3:3, 19:19)        \
    HANDLER(ClkRstControllerPllmMisc2Override, 7, 0:0, 20:20)        \
    HANDLER(EmcZqCalLpDdr4WarmBoot, 7, 1:0, 22:21)                   \
    HANDLER(EmcZqCalLpDdr4WarmBoot, 7, 4:4, 23:23)                   \
    HANDLER(EmcRc, 7, 7:0, 31:24)                                    \
    HANDLER(EmcPmacroBgBiasCtrl0, 8, 13:12, 31:30)                   \
    HANDLER(EmcFdpdCtrlCmdNoRamp, 14, 0:0, 30:30)                    \
    HANDLER(EmcCfgPipeClk, 14, 0:0, 31:31)                           \
    HANDLER(EmcQRst, 15, 6:0, 26:20)                                 \
    HANDLER(EmcQRst, 15, 20:16, 31:27)                               \
    HANDLER(EmcPmacroCmdTxDrv, 16, 5:0, 25:20)                       \
    HANDLER(EmcPmacroCmdTxDrv, 16, 13:8, 31:26)                      \
    HANDLER(EmcFbioCfg8, 17, 27:16, 31:20)                           \
    HANDLER(EmcTxsrDll, 18, 11:0, 31:20)                             \
    HANDLER(EmcTxdsrvttgen, 19, 11:0, 31:20)                         \
    HANDLER(EmcCfgRsv, 22, 31:0, 31:0)                               \
    HANDLER(EmcAutoCalConfig, 23, 31:0, 31:0)                        \
    HANDLER(EmcAutoCalVrefSel0, 24, 31:0, 31:0)                      \
    HANDLER(EmcPmacroBrickCtrlRfu1, 25, 31:0, 31:0)                  \
    HANDLER(EmcPmacroBrickCtrlRfu2, 26, 31:0, 31:0)                  \
    HANDLER(EmcPmcScratch1, 27, 31:0, 31:0)                          \
    HANDLER(EmcPmcScratch2, 28, 31:0, 31:0)                          \
    HANDLER(EmcPmcScratch3, 29, 31:0, 31:0)                          \
    HANDLER(EmcPmacroPerbitRfuCtrl0, 30, 31:0, 31:0)                 \
    HANDLER(EmcPmacroPerbitRfuCtrl1, 31, 31:0, 31:0)                 \
    HANDLER(EmcPmacroPerbitRfuCtrl2, 32, 31:0, 31:0)                 \
    HANDLER(EmcPmacroPerbitRfuCtrl3, 33, 31:0, 31:0)                 \
    HANDLER(EmcPmacroPerbitRfuCtrl4, 40, 31:0, 31:0)                 \
    HANDLER(EmcPmacroPerbitRfuCtrl5, 42, 31:0, 31:0)                 \
    HANDLER(McEmemArbDaTurns, 44, 31:0, 31:0)                        \
    HANDLER(EmcFbioSpare, 64, 31:24, 7:0)                            \
    HANDLER(EmcFbioSpare, 64, 23:16, 15:8)                           \
    HANDLER(EmcFbioSpare, 64, 15:8, 23:16)                           \
    HANDLER(EmcFbioSpare, 64, 7:2, 29:24)                            \
    HANDLER(EmcFbioSpare, 64, 0:0, 30:30)                            \
    HANDLER(McEmemArbMisc2, 64, 0:0, 31:31)                          \
    HANDLER(McEmemArbMisc0, 65, 14:0, 14:0)                          \
    HANDLER(McEmemArbMisc0, 65, 30:16, 29:15)                        \
    HANDLER(McDaCfg0, 65, 0:0, 30:30)                                \
    HANDLER(EmcFdpdCtrlCmd, 66, 16:0, 16:0)                          \
    HANDLER(EmcFdpdCtrlCmd, 66, 31:20, 28:17)                        \
    HANDLER(EmcAutoCalConfig2, 67, 27:0, 27:0)                       \
    HANDLER(EmcBurstRefreshNum, 67, 3:0, 31:28)                      \
    HANDLER(EmcCfgDigDll, 68, 10:0, 10:0)                            \
    HANDLER(EmcCfgDigDll, 68, 25:12, 24:11)                          \
    HANDLER(EmcCfgDigDll, 68, 27:27, 25:25)                          \
    HANDLER(EmcCfgDigDll, 68, 31:30, 27:26)                          \
    HANDLER(EmcTppd, 68, 3:0, 31:28)                                 \
    HANDLER(EmcFdpdCtrlDq, 69, 16:0, 16:0)                           \
    HANDLER(EmcFdpdCtrlDq, 69, 28:20, 25:17)                         \
    HANDLER(EmcFdpdCtrlDq, 69, 31:30, 27:26)                         \
    HANDLER(EmcR2r, 69, 3:0, 31:28)                                  \
    HANDLER(EmcPmacroIbVrefDq_0, 70, 6:0, 6:0)                       \
    HANDLER(EmcPmacroIbVrefDq_0, 70, 14:8, 13:7)                     \
    HANDLER(EmcPmacroIbVrefDq_0, 70, 22:16, 20:14)                   \
    HANDLER(EmcPmacroIbVrefDq_0, 70, 30:24, 27:21)                   \
    HANDLER(EmcW2w, 70, 3:0, 31:28)                                  \
    HANDLER(EmcPmacroIbVrefDq_1, 71, 6:0, 6:0)                       \
    HANDLER(EmcPmacroIbVrefDq_1, 71, 14:8, 13:7)                     \
    HANDLER(EmcPmacroIbVrefDq_1, 71, 22:16, 20:14)                   \
    HANDLER(EmcPmacroIbVrefDq_1, 71, 30:24, 27:21)                   \
    HANDLER(EmcPmacroVttgenCtrl0, 71, 19:16, 31:28)                  \
    HANDLER(EmcPmacroIbVrefDqs_0, 72, 6:0, 6:0)                      \
    HANDLER(EmcPmacroIbVrefDqs_0, 72, 14:8, 13:7)                    \
    HANDLER(EmcPmacroIbVrefDqs_0, 72, 22:16, 20:14)                  \
    HANDLER(EmcPmacroIbVrefDqs_0, 72, 30:24, 27:21)                  \
    HANDLER(EmcPmacroIbVrefDqs_1, 73, 6:0, 6:0)                      \
    HANDLER(EmcPmacroIbVrefDqs_1, 73, 14:8, 13:7)                    \
    HANDLER(EmcPmacroIbVrefDqs_1, 73, 22:16, 20:14)                  \
    HANDLER(EmcPmacroIbVrefDqs_1, 73, 30:24, 27:21)                  \
    HANDLER(EmcPmacroDdllShortCmd_0, 74, 6:0, 6:0)                   \
    HANDLER(EmcPmacroDdllShortCmd_0, 74, 14:8, 13:7)                 \
    HANDLER(EmcPmacroDdllShortCmd_0, 74, 22:16, 20:14)               \
    HANDLER(EmcPmacroDdllShortCmd_0, 74, 30:24, 27:21)               \
    HANDLER(EmcPmacroDdllShortCmd_1, 75, 6:0, 6:0)                   \
    HANDLER(EmcPmacroDdllShortCmd_1, 75, 14:8, 13:7)                 \
    HANDLER(EmcPmacroDdllShortCmd_1, 75, 22:16, 20:14)               \
    HANDLER(EmcPmacroDdllShortCmd_1, 75, 30:24, 27:21)               \
    HANDLER(EmcPmacroDllCfg0, 76, 29:4, 25:0)                        \
    HANDLER(EmcRp, 76, 5:0, 31:26)                                   \
    HANDLER(EmcPmacroTxPwrd0, 77, 10:0, 10:0)                        \
    HANDLER(EmcPmacroTxPwrd0, 77, 13:12, 12:11)                      \
    HANDLER(EmcPmacroTxPwrd0, 77, 26:16, 23:13)                      \
    HANDLER(EmcPmacroTxPwrd0, 77, 29:28, 25:24)                      \
    HANDLER(EmcR2w, 77, 5:0, 31:26)                                  \
    HANDLER(EmcPmacroTxPwrd1, 78, 10:0, 10:0)                        \
    HANDLER(EmcPmacroTxPwrd1, 78, 13:12, 12:11)                      \
    HANDLER(EmcPmacroTxPwrd1, 78, 26:16, 23:13)                      \
    HANDLER(EmcPmacroTxPwrd1, 78, 29:28, 25:24)                      \
    HANDLER(EmcW2r, 78, 5:0, 31:26)                                  \
    HANDLER(EmcPmacroTxPwrd2, 79, 10:0, 10:0)                        \
    HANDLER(EmcPmacroTxPwrd2, 79, 13:12, 12:11)                      \
    HANDLER(EmcPmacroTxPwrd2, 79, 26:16, 23:13)                      \
    HANDLER(EmcPmacroTxPwrd2, 79, 29:28, 25:24)                      \
    HANDLER(EmcR2p, 79, 5:0, 31:26)                                  \
    HANDLER(EmcPmacroTxPwrd3, 80, 10:0, 10:0)                        \
    HANDLER(EmcPmacroTxPwrd3, 80, 13:12, 12:11)                      \
    HANDLER(EmcPmacroTxPwrd3, 80, 26:16, 23:13)                      \
    HANDLER(EmcPmacroTxPwrd3, 80, 29:28, 25:24)                      \
    HANDLER(EmcCcdmw, 80, 5:0, 31:26)                                \
    HANDLER(EmcPmacroTxPwrd4, 81, 10:0, 10:0)                        \
    HANDLER(EmcPmacroTxPwrd4, 81, 13:12, 12:11)                      \
    HANDLER(EmcPmacroTxPwrd4, 81, 26:16, 23:13)                      \
    HANDLER(EmcPmacroTxPwrd4, 81, 29:28, 25:24)                      \
    HANDLER(EmcRdRcd, 81, 5:0, 31:26)                                \
    HANDLER(EmcPmacroTxPwrd5, 82, 10:0, 10:0)                        \
    HANDLER(EmcPmacroTxPwrd5, 82, 13:12, 12:11)                      \
    HANDLER(EmcPmacroTxPwrd5, 82, 26:16, 23:13)                      \
    HANDLER(EmcPmacroTxPwrd5, 82, 29:28, 25:24)                      \
    HANDLER(EmcWrRcd, 82, 5:0, 31:26)                                \
    HANDLER(EmcAutoCalChannel, 83, 5:0, 5:0)                         \
    HANDLER(EmcAutoCalChannel, 83, 11:8, 9:6)                        \
    HANDLER(EmcAutoCalChannel, 83, 27:16, 21:10)                     \
    HANDLER(EmcAutoCalChannel, 83, 31:29, 24:22)                     \
    HANDLER(EmcConfigSampleDelay, 83, 6:0, 31:25)                    \
    HANDLER(EmcPmacroRxTerm, 84, 5:0, 5:0)                           \
    HANDLER(EmcPmacroRxTerm, 84, 13:8, 11:6)                         \
    HANDLER(EmcPmacroRxTerm, 84, 21:16, 17:12)                       \
    HANDLER(EmcPmacroRxTerm, 84, 29:24, 23:18)                       \
    HANDLER(EmcSelDpdCtrl, 84, 5:2, 27:24)                           \
    HANDLER(EmcSelDpdCtrl, 84, 8:8, 28:28)                           \
    HANDLER(EmcSelDpdCtrl, 84, 18:16, 31:29)                         \
    HANDLER(EmcPmacroDqTxDrv, 85, 5:0, 5:0)                          \
    HANDLER(EmcPmacroDqTxDrv, 85, 13:8, 11:6)                        \
    HANDLER(EmcPmacroDqTxDrv, 85, 21:16, 17:12)                      \
    HANDLER(EmcPmacroDqTxDrv, 85, 29:24, 23:18)                      \
    HANDLER(EmcObdly, 85, 5:0, 29:24)                                \
    HANDLER(EmcObdly, 85, 29:28, 31:30)                              \
    HANDLER(EmcPmacroCaTxDrv, 86, 5:0, 5:0)                          \
    HANDLER(EmcPmacroCaTxDrv, 86, 13:8, 11:6)                        \
    HANDLER(EmcPmacroCaTxDrv, 86, 21:16, 17:12)                      \
    HANDLER(EmcPmacroCaTxDrv, 86, 29:24, 23:18)                      \
    HANDLER(EmcPmacroVttgenCtrl1, 86, 15:10, 29:24)                  \
    HANDLER(EmcPmacroVttgenCtrl1, 86, 21:20, 31:30)                  \
    HANDLER(EmcPmacroZctrl, 87, 27:4, 23:0)                          \
    HANDLER(EmcPmacroVttgenCtrl2, 87, 23:16, 31:24)                  \
    HANDLER(EmcZcalInterval, 88, 23:10, 13:0)                        \
    HANDLER(EmcZcalInterval, 88, 9:0, 23:14)                         \
    HANDLER(McEmemArbTimingRc, 88, 7:0, 31:24)                       \
    HANDLER(EmcDataBrlshft0, 89, 23:0, 23:0)                         \
    HANDLER(McEmemArbRsv, 89, 7:0, 31:24)                            \
    HANDLER(EmcDataBrlshft1, 90, 23:0, 23:0)                         \
    HANDLER(EmcDqsBrlshft0, 91, 23:0, 23:0)                          \
    HANDLER(EmcDqsBrlshft1, 92, 23:0, 23:0)                          \
    HANDLER(EmcSwizzleRank0Byte0, 93, 2:0, 2:0)                      \
    HANDLER(EmcSwizzleRank0Byte0, 93, 6:4, 5:3)                      \
    HANDLER(EmcSwizzleRank0Byte0, 93, 10:8, 8:6)                     \
    HANDLER(EmcSwizzleRank0Byte0, 93, 14:12, 11:9)                   \
    HANDLER(EmcSwizzleRank0Byte0, 93, 18:16, 14:12)                  \
    HANDLER(EmcSwizzleRank0Byte0, 93, 22:20, 17:15)                  \
    HANDLER(EmcSwizzleRank0Byte0, 93, 26:24, 20:18)                  \
    HANDLER(EmcSwizzleRank0Byte0, 93, 30:28, 23:21)                  \
    HANDLER(EmcSwizzleRank0Byte1, 94, 2:0, 2:0)                      \
    HANDLER(EmcSwizzleRank0Byte1, 94, 6:4, 5:3)                      \
    HANDLER(EmcSwizzleRank0Byte1, 94, 10:8, 8:6)                     \
    HANDLER(EmcSwizzleRank0Byte1, 94, 14:12, 11:9)                   \
    HANDLER(EmcSwizzleRank0Byte1, 94, 18:16, 14:12)                  \
    HANDLER(EmcSwizzleRank0Byte1, 94, 22:20, 17:15)                  \
    HANDLER(EmcSwizzleRank0Byte1, 94, 26:24, 20:18)                  \
    HANDLER(EmcSwizzleRank0Byte1, 94, 30:28, 23:21)                  \
    HANDLER(EmcRas, 94, 6:0, 30:24)                                  \
    HANDLER(EmcCfg, 94, 4:4, 31:31)                                  \
    HANDLER(EmcSwizzleRank0Byte2, 95, 2:0, 2:0)                      \
    HANDLER(EmcSwizzleRank0Byte2, 95, 6:4, 5:3)                      \
    HANDLER(EmcSwizzleRank0Byte2, 95, 10:8, 8:6)                     \
    HANDLER(EmcSwizzleRank0Byte2, 95, 14:12, 11:9)                   \
    HANDLER(EmcSwizzleRank0Byte2, 95, 18:16, 14:12)                  \
    HANDLER(EmcSwizzleRank0Byte2, 95, 22:20, 17:15)                  \
    HANDLER(EmcSwizzleRank0Byte2, 95, 26:24, 20:18)                  \
    HANDLER(EmcSwizzleRank0Byte2, 95, 30:28, 23:21)                  \
    HANDLER(EmcW2p, 95, 6:0, 30:24)                                  \
    HANDLER(EmcCfg, 95, 5:5, 31:31)                                  \
    HANDLER(EmcSwizzleRank0Byte3, 96, 2:0, 2:0)                      \
    HANDLER(EmcSwizzleRank0Byte3, 96, 6:4, 5:3)                      \
    HANDLER(EmcSwizzleRank0Byte3, 96, 10:8, 8:6)                     \
    HANDLER(EmcSwizzleRank0Byte3, 96, 14:12, 11:9)                   \
    HANDLER(EmcSwizzleRank0Byte3, 96, 18:16, 14:12)                  \
    HANDLER(EmcSwizzleRank0Byte3, 96, 22:20, 17:15)                  \
    HANDLER(EmcSwizzleRank0Byte3, 96, 26:24, 20:18)                  \
    HANDLER(EmcSwizzleRank0Byte3, 96, 30:28, 23:21)                  \
    HANDLER(EmcQSafe, 96, 6:0, 30:24)                                \
    HANDLER(EmcCfg, 96, 6:6, 31:31)                                  \
    HANDLER(EmcSwizzleRank1Byte0, 97, 2:0, 2:0)                      \
    HANDLER(EmcSwizzleRank1Byte0, 97, 6:4, 5:3)                      \
    HANDLER(EmcSwizzleRank1Byte0, 97, 10:8, 8:6)                     \
    HANDLER(EmcSwizzleRank1Byte0, 97, 14:12, 11:9)                   \
    HANDLER(EmcSwizzleRank1Byte0, 97, 18:16, 14:12)                  \
    HANDLER(EmcSwizzleRank1Byte0, 97, 22:20, 17:15)                  \
    HANDLER(EmcSwizzleRank1Byte0, 97, 26:24, 20:18)                  \
    HANDLER(EmcSwizzleRank1Byte0, 97, 30:28, 23:21)                  \
    HANDLER(EmcRdv, 97, 6:0, 30:24)                                  \
    HANDLER(EmcCfg, 97, 7:7, 31:31)                                  \
    HANDLER(EmcSwizzleRank1Byte1, 98, 2:0, 2:0)                      \
    HANDLER(EmcSwizzleRank1Byte1, 98, 6:4, 5:3)                      \
    HANDLER(EmcSwizzleRank1Byte1, 98, 10:8, 8:6)                     \
    HANDLER(EmcSwizzleRank1Byte1, 98, 14:12, 11:9)                   \
    HANDLER(EmcSwizzleRank1Byte1, 98, 18:16, 14:12)                  \
    HANDLER(EmcSwizzleRank1Byte1, 98, 22:20, 17:15)                  \
    HANDLER(EmcSwizzleRank1Byte1, 98, 26:24, 20:18)                  \
    HANDLER(EmcSwizzleRank1Byte1, 98, 30:28, 23:21)                  \
    HANDLER(EmcRw2Pden, 98, 6:0, 30:24)                              \
    HANDLER(EmcCfg, 98, 8:8, 31:31)                                  \
    HANDLER(EmcSwizzleRank1Byte2, 99, 2:0, 2:0)                      \
    HANDLER(EmcSwizzleRank1Byte2, 99, 6:4, 5:3)                      \
    HANDLER(EmcSwizzleRank1Byte2, 99, 10:8, 8:6)                     \
    HANDLER(EmcSwizzleRank1Byte2, 99, 14:12, 11:9)                   \
    HANDLER(EmcSwizzleRank1Byte2, 99, 18:16, 14:12)                  \
    HANDLER(EmcSwizzleRank1Byte2, 99, 22:20, 17:15)                  \
    HANDLER(EmcSwizzleRank1Byte2, 99, 26:24, 20:18)                  \
    HANDLER(EmcSwizzleRank1Byte2, 99, 30:28, 23:21)                  \
    HANDLER(EmcTfaw, 99, 6:0, 30:24)                                 \
    HANDLER(EmcCfg, 99, 9:9, 31:31)                                  \
    HANDLER(EmcSwizzleRank1Byte3, 100, 2:0, 2:0)                     \
    HANDLER(EmcSwizzleRank1Byte3, 100, 6:4, 5:3)                     \
    HANDLER(EmcSwizzleRank1Byte3, 100, 10:8, 8:6)                    \
    HANDLER(EmcSwizzleRank1Byte3, 100, 14:12, 11:9)                  \
    HANDLER(EmcSwizzleRank1Byte3, 100, 18:16, 14:12)                 \
    HANDLER(EmcSwizzleRank1Byte3, 100, 22:20, 17:15)                 \
    HANDLER(EmcSwizzleRank1Byte3, 100, 26:24, 20:18)                 \
    HANDLER(EmcSwizzleRank1Byte3, 100, 30:28, 23:21)                 \
    HANDLER(EmcTClkStable, 100, 6:0, 30:24)                          \
    HANDLER(EmcCfg, 100, 18:18, 31:31)                               \
    HANDLER(EmcCfgPipe2, 101, 11:0, 11:0)                            \
    HANDLER(EmcCfgPipe2, 101, 27:16, 23:12)                          \
    HANDLER(EmcTrtm, 101, 6:0, 30:24)                                \
    HANDLER(EmcCfg, 101, 21:21, 31:31)                               \
    HANDLER(EmcCfgPipe1, 102, 11:0, 11:0)                            \
    HANDLER(EmcCfgPipe1, 102, 27:16, 23:12)                          \
    HANDLER(EmcTwtm, 102, 6:0, 30:24)                                \
    HANDLER(EmcCfg, 102, 22:22, 31:31)                               \
    HANDLER(EmcPmacroDdllPwrd0, 103, 4:1, 3:0)                       \
    HANDLER(EmcPmacroDdllPwrd0, 103, 7:6, 5:4)                       \
    HANDLER(EmcPmacroDdllPwrd0, 103, 12:9, 9:6)                      \
    HANDLER(EmcPmacroDdllPwrd0, 103, 15:14, 11:10)                   \
    HANDLER(EmcPmacroDdllPwrd0, 103, 20:17, 15:12)                   \
    HANDLER(EmcPmacroDdllPwrd0, 103, 23:22, 17:16)                   \
    HANDLER(EmcPmacroDdllPwrd0, 103, 28:25, 21:18)                   \
    HANDLER(EmcPmacroDdllPwrd0, 103, 31:30, 23:22)                   \
    HANDLER(EmcTratm, 103, 6:0, 30:24)                               \
    HANDLER(EmcCfg, 103, 23:23, 31:31)                               \
    HANDLER(EmcPmacroDdllPwrd1, 104, 4:1, 3:0)                       \
    HANDLER(EmcPmacroDdllPwrd1, 104, 7:6, 5:4)                       \
    HANDLER(EmcPmacroDdllPwrd1, 104, 12:9, 9:6)                      \
    HANDLER(EmcPmacroDdllPwrd1, 104, 15:14, 11:10)                   \
    HANDLER(EmcPmacroDdllPwrd1, 104, 20:17, 15:12)                   \
    HANDLER(EmcPmacroDdllPwrd1, 104, 23:22, 17:16)                   \
    HANDLER(EmcPmacroDdllPwrd1, 104, 28:25, 21:18)                   \
    HANDLER(EmcPmacroDdllPwrd1, 104, 31:30, 23:22)                   \
    HANDLER(EmcTwatm, 104, 6:0, 30:24)                               \
    HANDLER(EmcCfg, 104, 24:24, 31:31)                               \
    HANDLER(EmcPmacroDdllPwrd2, 105, 4:1, 3:0)                       \
    HANDLER(EmcPmacroDdllPwrd2, 105, 7:6, 5:4)                       \
    HANDLER(EmcPmacroDdllPwrd2, 105, 12:9, 9:6)                      \
    HANDLER(EmcPmacroDdllPwrd2, 105, 15:14, 11:10)                   \
    HANDLER(EmcPmacroDdllPwrd2, 105, 20:17, 15:12)                   \
    HANDLER(EmcPmacroDdllPwrd2, 105, 23:22, 17:16)                   \
    HANDLER(EmcPmacroDdllPwrd2, 105, 28:25, 21:18)                   \
    HANDLER(EmcPmacroDdllPwrd2, 105, 31:30, 23:22)                   \
    HANDLER(EmcTr2ref, 105, 6:0, 30:24)                              \
    HANDLER(EmcCfg, 105, 25:25, 31:31)                               \
    HANDLER(EmcPmacroDdllPeriodicOffset, 106, 5:0, 5:0)              \
    HANDLER(EmcPmacroDdllPeriodicOffset, 106, 16:8, 14:6)            \
    HANDLER(EmcPmacroDdllPeriodicOffset, 106, 28:20, 23:15)          \
    HANDLER(EmcPdex2Mrr, 106, 6:0, 30:24)                            \
    HANDLER(EmcCfg, 106, 26:26, 31:31)                               \
    HANDLER(McEmemArbDaCovers, 107, 23:0, 23:0)                      \
    HANDLER(EmcClkenOverride, 107, 3:1, 26:24)                       \
    HANDLER(EmcClkenOverride, 107, 8:6, 29:27)                       \
    HANDLER(EmcClkenOverride, 107, 16:16, 30:30)                     \
    HANDLER(EmcCfg, 107, 28:28, 31:31)                               \
    HANDLER(EmcXm2CompPadCtrl, 108, 1:0, 1:0)                        \
    HANDLER(EmcXm2CompPadCtrl, 108, 6:4, 4:2)                        \
    HANDLER(EmcXm2CompPadCtrl, 108, 9:9, 5:5)                        \
    HANDLER(EmcXm2CompPadCtrl, 108, 19:11, 14:6)                     \
    HANDLER(EmcXm2CompPadCtrl, 108, 31:24, 22:15)                    \
    HANDLER(EmcRfcPb, 108, 8:0, 31:23)                               \
    HANDLER(EmcAutoCalConfig3, 109, 6:0, 6:0)                        \
    HANDLER(EmcAutoCalConfig3, 109, 14:8, 13:7)                      \
    HANDLER(EmcAutoCalConfig3, 109, 23:16, 21:14)                    \
    HANDLER(EmcCfgUpdate, 109, 2:0, 24:22)                           \
    HANDLER(EmcCfgUpdate, 109, 10:8, 27:25)                          \
    HANDLER(EmcCfgUpdate, 109, 31:28, 31:28)                         \
    HANDLER(EmcAutoCalConfig4, 110, 6:0, 6:0)                        \
    HANDLER(EmcAutoCalConfig4, 110, 14:8, 13:7)                      \
    HANDLER(EmcAutoCalConfig4, 110, 23:16, 21:14)                    \
    HANDLER(EmcRfc, 110, 9:0, 31:22)                                 \
    HANDLER(EmcAutoCalConfig5, 111, 6:0, 6:0)                        \
    HANDLER(EmcAutoCalConfig5, 111, 14:8, 13:7)                      \
    HANDLER(EmcAutoCalConfig5, 111, 23:16, 21:14)                    \
    HANDLER(EmcTxsr, 111, 9:0, 31:22)                                \
    HANDLER(EmcAutoCalConfig6, 112, 6:0, 6:0)                        \
    HANDLER(EmcAutoCalConfig6, 112, 14:8, 13:7)                      \
    HANDLER(EmcAutoCalConfig6, 112, 23:16, 21:14)                    \
    HANDLER(EmcMc2EmcQ, 112, 2:0, 24:22)                             \
    HANDLER(EmcMc2EmcQ, 112, 10:8, 27:25)                            \
    HANDLER(EmcMc2EmcQ, 112, 27:24, 31:28)                           \
    HANDLER(EmcAutoCalConfig7, 113, 6:0, 6:0)                        \
    HANDLER(EmcAutoCalConfig7, 113, 14:8, 13:7)                      \
    HANDLER(EmcAutoCalConfig7, 113, 23:16, 21:14)                    \
    HANDLER(McEmemArbRing1Throttle, 113, 4:0, 26:22)                 \
    HANDLER(McEmemArbRing1Throttle, 113, 20:16, 31:27)               \
    HANDLER(EmcAutoCalConfig8, 114, 6:0, 6:0)                        \
    HANDLER(EmcAutoCalConfig8, 114, 14:8, 13:7)                      \
    HANDLER(EmcAutoCalConfig8, 114, 23:16, 21:14)                    \
    HANDLER(EmcFbioCfg7, 115, 21:0, 21:0)                            \
    HANDLER(EmcAr2Pden, 115, 8:0, 30:22)                             \
    HANDLER(EmcCfg, 115, 29:29, 31:31)                               \
    HANDLER(EmcPmacroQuseDdllRank0_0, 123, 10:0, 10:0)               \
    HANDLER(EmcPmacroQuseDdllRank0_0, 123, 26:16, 21:11)             \
    HANDLER(EmcRfcSlr, 123, 8:0, 30:22)                              \
    HANDLER(EmcCfg, 123, 30:30, 31:31)                               \
    HANDLER(EmcPmacroQuseDdllRank0_1, 124, 10:0, 10:0)               \
    HANDLER(EmcPmacroQuseDdllRank0_1, 124, 26:16, 21:11)             \
    HANDLER(EmcIbdly, 124, 6:0, 28:22)                               \
    HANDLER(EmcIbdly, 124, 29:28, 30:29)                             \
    HANDLER(EmcCfg, 124, 31:31, 31:31)                               \
    HANDLER(EmcPmacroQuseDdllRank0_2, 125, 10:0, 10:0)               \
    HANDLER(EmcPmacroQuseDdllRank0_2, 125, 26:16, 21:11)             \
    HANDLER(McEmemArbTimingRFCPB, 125, 8:0, 30:22)                   \
    HANDLER(EmcFbioCfg5, 125, 4:4, 31:31)                            \
    HANDLER(EmcPmacroQuseDdllRank0_3, 126, 10:0, 10:0)               \
    HANDLER(EmcPmacroQuseDdllRank0_3, 126, 26:16, 21:11)             \
    HANDLER(EmcAutoCalConfig9, 126, 6:0, 28:22)                      \
    HANDLER(EmcFbioCfg5, 126, 15:13, 31:29)                          \
    HANDLER(EmcPmacroQuseDdllRank0_4, 127, 10:0, 10:0)               \
    HANDLER(EmcPmacroQuseDdllRank0_4, 127, 26:16, 21:11)             \
    HANDLER(EmcRdvMask, 127, 6:0, 28:22)                             \
    HANDLER(EmcCfg2, 127, 5:3, 31:29)                                \
    HANDLER(EmcPmacroQuseDdllRank0_5, 128, 10:0, 10:0)               \
    HANDLER(EmcPmacroQuseDdllRank0_5, 128, 26:16, 21:11)             \
    HANDLER(EmcRdvEarlyMask, 128, 6:0, 28:22)                        \
    HANDLER(EmcPmacroCmdPadTxCtrl, 128, 4:2, 31:29)                  \
    HANDLER(EmcPmacroQuseDdllRank1_0, 129, 10:0, 10:0)               \
    HANDLER(EmcPmacroQuseDdllRank1_0, 129, 26:16, 21:11)             \
    HANDLER(EmcRdvEarly, 129, 6:0, 28:22)                            \
    HANDLER(EmcPmacroCmdPadTxCtrl, 129, 9:7, 31:29)                  \
    HANDLER(EmcPmacroQuseDdllRank1_1, 130, 10:0, 10:0)               \
    HANDLER(EmcPmacroQuseDdllRank1_1, 130, 26:16, 21:11)             \
    HANDLER(EmcQuseWidth, 130, 4:0, 26:22)                           \
    HANDLER(EmcQuseWidth, 130, 29:28, 28:27)                         \
    HANDLER(EmcPmacroCmdPadTxCtrl, 130, 14:12, 31:29)                \
    HANDLER(EmcPmacroQuseDdllRank1_2, 131, 10:0, 10:0)               \
    HANDLER(EmcPmacroQuseDdllRank1_2, 131, 26:16, 21:11)             \
    HANDLER(EmcPmacroDdllShortCmd_2, 131, 6:0, 28:22)                \
    HANDLER(EmcPmacroCmdPadTxCtrl, 131, 19:17, 31:29)                \
    HANDLER(EmcPmacroQuseDdllRank1_3, 132, 10:0, 10:0)               \
    HANDLER(EmcPmacroQuseDdllRank1_3, 132, 26:16, 21:11)             \
    HANDLER(EmcPmacroCmdRxTermMode, 132, 1:0, 23:22)                 \
    HANDLER(EmcPmacroCmdRxTermMode, 132, 5:4, 25:24)                 \
    HANDLER(EmcPmacroCmdRxTermMode, 132, 9:8, 27:26)                 \
    HANDLER(EmcPmacroCmdRxTermMode, 132, 13:13, 28:28)               \
    HANDLER(EmcPmacroDataPadTxCtrl, 132, 4:2, 31:29)                 \
    HANDLER(EmcPmacroQuseDdllRank1_4, 133, 10:0, 10:0)               \
    HANDLER(EmcPmacroQuseDdllRank1_4, 133, 26:16, 21:11)             \
    HANDLER(EmcPmacroDataRxTermMode, 133, 1:0, 23:22)                \
    HANDLER(EmcPmacroDataRxTermMode, 133, 5:4, 25:24)                \
    HANDLER(EmcPmacroDataRxTermMode, 133, 9:8, 27:26)                \
    HANDLER(EmcPmacroDataRxTermMode, 133, 13:13, 28:28)              \
    HANDLER(EmcPmacroDataPadTxCtrl, 133, 9:7, 31:29)                 \
    HANDLER(EmcPmacroQuseDdllRank1_5, 134, 10:0, 10:0)               \
    HANDLER(EmcPmacroQuseDdllRank1_5, 134, 26:16, 21:11)             \
    HANDLER(McEmemArbTimingRp, 134, 6:0, 28:22)                      \
    HANDLER(EmcPmacroDataPadTxCtrl, 134, 14:12, 31:29)               \
    HANDLER(EmcPmacroObDdllLongDqRank0_0, 135, 10:0, 10:0)           \
    HANDLER(EmcPmacroObDdllLongDqRank0_0, 135, 26:16, 21:11)         \
    HANDLER(McEmemArbTimingRas, 135, 6:0, 28:22)                     \
    HANDLER(EmcPmacroDataPadTxCtrl, 135, 19:17, 31:29)               \
    HANDLER(EmcPmacroObDdllLongDqRank0_1, 136, 10:0, 10:0)           \
    HANDLER(EmcPmacroObDdllLongDqRank0_1, 136, 26:16, 21:11)         \
    HANDLER(McEmemArbTimingFaw, 136, 6:0, 28:22)                     \
    HANDLER(EmcCfg, 136, 17:16, 30:29)                               \
    HANDLER(EmcFbioCfg5, 136, 8:8, 31:31)                            \
    HANDLER(EmcPmacroObDdllLongDqRank0_2, 137, 10:0, 10:0)           \
    HANDLER(EmcPmacroObDdllLongDqRank0_2, 137, 26:16, 21:11)         \
    HANDLER(McEmemArbTimingRap2Pre, 137, 6:0, 28:22)                 \
    HANDLER(EmcFbioCfg5, 137, 1:0, 30:29)                            \
    HANDLER(EmcFbioCfg5, 137, 10:10, 31:31)                          \
    HANDLER(EmcPmacroObDdllLongDqRank0_3, 138, 10:0, 10:0)           \
    HANDLER(EmcPmacroObDdllLongDqRank0_3, 138, 26:16, 21:11)         \
    HANDLER(McEmemArbTimingWap2Pre, 138, 6:0, 28:22)                 \
    HANDLER(EmcFbioCfg5, 138, 3:2, 30:29)                            \
    HANDLER(EmcFbioCfg5, 138, 12:12, 31:31)                          \
    HANDLER(EmcPmacroObDdllLongDqRank0_4, 139, 10:0, 10:0)           \
    HANDLER(EmcPmacroObDdllLongDqRank0_4, 139, 26:16, 21:11)         \
    HANDLER(McEmemArbTimingR2W, 139, 6:0, 28:22)                     \
    HANDLER(EmcCfg2, 139, 27:26, 30:29)                              \
    HANDLER(EmcFbioCfg5, 139, 24:24, 31:31)                          \
    HANDLER(EmcPmacroObDdllLongDqRank0_5, 140, 10:0, 10:0)           \
    HANDLER(EmcPmacroObDdllLongDqRank0_5, 140, 26:16, 21:11)         \
    HANDLER(McEmemArbTimingW2R, 140, 6:0, 28:22)                     \
    HANDLER(EmcFbioCfg5, 140, 27:25, 31:29)                          \
    HANDLER(EmcPmacroObDdllLongDqRank1_0, 141, 10:0, 10:0)           \
    HANDLER(EmcPmacroObDdllLongDqRank1_0, 141, 26:16, 21:11)         \
    HANDLER(EmcWdv, 141, 5:0, 27:22)                                 \
    HANDLER(EmcFbioCfg5, 141, 23:20, 31:28)                          \
    HANDLER(EmcPmacroObDdllLongDqRank1_1, 142, 10:0, 10:0)           \
    HANDLER(EmcPmacroObDdllLongDqRank1_1, 142, 26:16, 21:11)         \
    HANDLER(EmcQUse, 142, 5:0, 27:22)                                \
    HANDLER(EmcFbioCfg5, 142, 28:28, 28:28)                          \
    HANDLER(EmcFbioCfg5, 142, 31:30, 30:29)                          \
    HANDLER(EmcCfg2, 142, 0:0, 31:31)                                \
    HANDLER(EmcPmacroObDdllLongDqRank1_2, 143, 10:0, 10:0)           \
    HANDLER(EmcPmacroObDdllLongDqRank1_2, 143, 26:16, 21:11)         \
    HANDLER(EmcPdEx2Wr, 143, 5:0, 27:22)                             \
    HANDLER(EmcCfg2, 143, 2:1, 29:28)                                \
    HANDLER(EmcCfg2, 143, 7:7, 30:30)                                \
    HANDLER(EmcCfg2, 143, 10:10, 31:31)                              \
    HANDLER(EmcPmacroObDdllLongDqRank1_3, 144, 10:0, 10:0)           \
    HANDLER(EmcPmacroObDdllLongDqRank1_3, 144, 26:16, 21:11)         \
    HANDLER(EmcPdEx2Rd, 144, 5:0, 27:22)                             \
    HANDLER(EmcCfg2, 144, 11:11, 28:28)                              \
    HANDLER(EmcCfg2, 144, 16:14, 31:29)                              \
    HANDLER(EmcPmacroObDdllLongDqRank1_4, 145, 10:0, 10:0)           \
    HANDLER(EmcPmacroObDdllLongDqRank1_4, 145, 26:16, 21:11)         \
    HANDLER(EmcPdex2Cke, 145, 5:0, 27:22)                            \
    HANDLER(EmcCfg2, 145, 20:20, 28:28)                              \
    HANDLER(EmcCfg2, 145, 24:22, 31:29)                              \
    HANDLER(EmcPmacroObDdllLongDqRank1_5, 146, 10:0, 10:0)           \
    HANDLER(EmcPmacroObDdllLongDqRank1_5, 146, 26:16, 21:11)         \
    HANDLER(EmcPChg2Pden, 146, 5:0, 27:22)                           \
    HANDLER(EmcCfg2, 146, 25:25, 28:28)                              \
    HANDLER(EmcCfg2, 146, 30:28, 31:29)                              \
    HANDLER(EmcPmacroObDdllLongDqsRank0_0, 147, 10:0, 10:0)          \
    HANDLER(EmcPmacroObDdllLongDqsRank0_0, 147, 26:16, 21:11)        \
    HANDLER(EmcAct2Pden, 147, 5:0, 27:22)                            \
    HANDLER(EmcCfg2, 147, 31:31, 28:28)                              \
    HANDLER(EmcCfgPipe, 147, 2:0, 31:29)                             \
    HANDLER(EmcPmacroObDdllLongDqsRank0_1, 148, 10:0, 10:0)          \
    HANDLER(EmcPmacroObDdllLongDqsRank0_1, 148, 26:16, 21:11)        \
    HANDLER(EmcCke2Pden, 148, 5:0, 27:22)                            \
    HANDLER(EmcCfgPipe, 148, 6:3, 31:28)                             \
    HANDLER(EmcPmacroObDdllLongDqsRank0_2, 149, 10:0, 10:0)          \
    HANDLER(EmcPmacroObDdllLongDqsRank0_2, 149, 26:16, 21:11)        \
    HANDLER(EmcTcke, 149, 5:0, 27:22)                                \
    HANDLER(EmcCfgPipe, 149, 10:7, 31:28)                            \
    HANDLER(EmcPmacroObDdllLongDqsRank0_3, 150, 10:0, 10:0)          \
    HANDLER(EmcPmacroObDdllLongDqsRank0_3, 150, 26:16, 21:11)        \
    HANDLER(EmcTrpab, 150, 5:0, 27:22)                               \
    HANDLER(EmcCfgPipe, 150, 11:11, 28:28)                           \
    HANDLER(EmcCfgPipe, 150, 18:16, 31:29)                           \
    HANDLER(EmcPmacroObDdllLongDqsRank0_4, 151, 10:0, 10:0)          \
    HANDLER(EmcPmacroObDdllLongDqsRank0_4, 151, 26:16, 21:11)        \
    HANDLER(EmcEInput, 151, 5:0, 27:22)                              \
    HANDLER(EmcCfgPipe, 151, 22:19, 31:28)                           \
    HANDLER(EmcPmacroObDdllLongDqsRank0_5, 152, 10:0, 10:0)          \
    HANDLER(EmcPmacroObDdllLongDqsRank0_5, 152, 26:16, 21:11)        \
    HANDLER(EmcEInputDuration, 152, 5:0, 27:22)                      \
    HANDLER(EmcCfgPipe, 152, 26:23, 31:28)                           \
    HANDLER(EmcPmacroObDdllLongDqsRank1_0, 153, 10:0, 10:0)          \
    HANDLER(EmcPmacroObDdllLongDqsRank1_0, 153, 26:16, 21:11)        \
    HANDLER(EmcPutermExtra, 153, 5:0, 27:22)                         \
    HANDLER(EmcCfgPipe, 153, 27:27, 28:28)                           \
    HANDLER(EmcPmacroTxSelClkSrc0, 153, 2:0, 31:29)                  \
    HANDLER(EmcPmacroObDdllLongDqsRank1_1, 154, 10:0, 10:0)          \
    HANDLER(EmcPmacroObDdllLongDqsRank1_1, 154, 26:16, 21:11)        \
    HANDLER(EmcTckesr, 154, 5:0, 27:22)                              \
    HANDLER(EmcPmacroTxSelClkSrc0, 154, 6:3, 31:28)                  \
    HANDLER(EmcPmacroObDdllLongDqsRank1_2, 155, 10:0, 10:0)          \
    HANDLER(EmcPmacroObDdllLongDqsRank1_2, 155, 26:16, 21:11)        \
    HANDLER(EmcTpd, 155, 5:0, 27:22)                                 \
    HANDLER(EmcPmacroTxSelClkSrc0, 155, 10:7, 31:28)                 \
    HANDLER(EmcPmacroObDdllLongDqsRank1_3, 156, 10:0, 10:0)          \
    HANDLER(EmcPmacroObDdllLongDqsRank1_3, 156, 26:16, 21:11)        \
    HANDLER(EmcWdvMask, 156, 5:0, 27:22)                             \
    HANDLER(EmcPmacroTxSelClkSrc0, 156, 19:16, 31:28)                \
    HANDLER(EmcPmacroObDdllLongDqsRank1_4, 157, 10:0, 10:0)          \
    HANDLER(EmcPmacroObDdllLongDqsRank1_4, 157, 26:16, 21:11)        \
    HANDLER(EmcWdvChk, 157, 5:0, 27:22)                              \
    HANDLER(EmcPmacroTxSelClkSrc0, 157, 23:20, 31:28)                \
    HANDLER(EmcPmacroObDdllLongDqsRank1_5, 158, 10:0, 10:0)          \
    HANDLER(EmcPmacroObDdllLongDqsRank1_5, 158, 26:16, 21:11)        \
    HANDLER(EmcCmdBrlshft0, 158, 5:0, 27:22)                         \
    HANDLER(EmcPmacroTxSelClkSrc0, 158, 26:24, 30:28)                \
    HANDLER(EmcPmacroTxSelClkSrc1, 158, 0:0, 31:31)                  \
    HANDLER(EmcPmacroIbDdllLongDqsRank0_0, 159, 10:0, 10:0)          \
    HANDLER(EmcPmacroIbDdllLongDqsRank0_0, 159, 26:16, 21:11)        \
    HANDLER(EmcCmdBrlshft1, 159, 5:0, 27:22)                         \
    HANDLER(EmcPmacroTxSelClkSrc1, 159, 4:1, 31:28)                  \
    HANDLER(EmcPmacroIbDdllLongDqsRank0_1, 160, 10:0, 10:0)          \
    HANDLER(EmcPmacroIbDdllLongDqsRank0_1, 160, 26:16, 21:11)        \
    HANDLER(EmcCmdBrlshft2, 160, 5:0, 27:22)                         \
    HANDLER(EmcPmacroTxSelClkSrc1, 160, 8:5, 31:28)                  \
    HANDLER(EmcPmacroIbDdllLongDqsRank0_2, 161, 10:0, 10:0)          \
    HANDLER(EmcPmacroIbDdllLongDqsRank0_2, 161, 26:16, 21:11)        \
    HANDLER(EmcCmdBrlshft3, 161, 5:0, 27:22)                         \
    HANDLER(EmcPmacroTxSelClkSrc1, 161, 10:9, 29:28)                 \
    HANDLER(EmcPmacroTxSelClkSrc1, 161, 17:16, 31:30)                \
    HANDLER(EmcPmacroIbDdllLongDqsRank0_3, 162, 10:0, 10:0)          \
    HANDLER(EmcPmacroIbDdllLongDqsRank0_3, 162, 26:16, 21:11)        \
    HANDLER(EmcWev, 162, 5:0, 27:22)                                 \
    HANDLER(EmcPmacroTxSelClkSrc1, 162, 21:18, 31:28)                \
    HANDLER(EmcPmacroIbDdllLongDqsRank1_0, 163, 10:0, 10:0)          \
    HANDLER(EmcPmacroIbDdllLongDqsRank1_0, 163, 26:16, 21:11)        \
    HANDLER(EmcWsv, 163, 5:0, 27:22)                                 \
    HANDLER(EmcPmacroTxSelClkSrc1, 163, 25:22, 31:28)                \
    HANDLER(EmcPmacroIbDdllLongDqsRank1_1, 164, 10:0, 10:0)          \
    HANDLER(EmcPmacroIbDdllLongDqsRank1_1, 164, 26:16, 21:11)        \
    HANDLER(EmcCfg3, 164, 2:0, 24:22)                                \
    HANDLER(EmcCfg3, 164, 6:4, 27:25)                                \
    HANDLER(EmcPmacroTxSelClkSrc1, 164, 26:26, 28:28)                \
    HANDLER(EmcPmacroTxSelClkSrc3, 164, 2:0, 31:29)                  \
    HANDLER(EmcPmacroIbDdllLongDqsRank1_2, 165, 10:0, 10:0)          \
    HANDLER(EmcPmacroIbDdllLongDqsRank1_2, 165, 26:16, 21:11)        \
    HANDLER(EmcPutermWidth, 165, 31:31, 22:22)                       \
    HANDLER(EmcPutermWidth, 165, 4:0, 27:23)                         \
    HANDLER(EmcPmacroTxSelClkSrc3, 165, 6:3, 31:28)                  \
    HANDLER(EmcPmacroIbDdllLongDqsRank1_3, 166, 10:0, 10:0)          \
    HANDLER(EmcPmacroIbDdllLongDqsRank1_3, 166, 26:16, 21:11)        \
    HANDLER(McEmemArbTimingRcd, 166, 5:0, 27:22)                     \
    HANDLER(EmcPmacroTxSelClkSrc3, 166, 10:7, 31:28)                 \
    HANDLER(EmcPmacroDdllLongCmd_0, 167, 10:0, 10:0)                 \
    HANDLER(EmcPmacroDdllLongCmd_0, 167, 26:16, 21:11)               \
    HANDLER(McEmemArbTimingCcdmw, 167, 5:0, 27:22)                   \
    HANDLER(EmcPmacroTxSelClkSrc3, 167, 19:16, 31:28)                \
    HANDLER(EmcPmacroDdllLongCmd_1, 168, 10:0, 10:0)                 \
    HANDLER(EmcPmacroDdllLongCmd_1, 168, 26:16, 21:11)               \
    HANDLER(McEmemArbOverride, 168, 27:27, 22:22)                    \
    HANDLER(McEmemArbOverride, 168, 26:26, 23:23)                    \
    HANDLER(McEmemArbOverride, 168, 16:16, 24:24)                    \
    HANDLER(McEmemArbOverride, 168, 10:10, 25:25)                    \
    HANDLER(McEmemArbOverride, 168, 4:4, 26:26)                      \
    HANDLER(McEmemArbOverride, 168, 3:3, 27:27)                      \
    HANDLER(EmcPmacroTxSelClkSrc3, 168, 23:20, 31:28)                \
    HANDLER(EmcPmacroDdllLongCmd_2, 169, 10:0, 10:0)                 \
    HANDLER(EmcPmacroDdllLongCmd_2, 169, 26:16, 21:11)               \
    HANDLER(EmcRrd, 169, 4:0, 26:22)                                 \
    HANDLER(EmcRext, 169, 4:0, 31:27)                                \
    HANDLER(EmcPmacroDdllLongCmd_3, 170, 10:0, 10:0)                 \
    HANDLER(EmcPmacroDdllLongCmd_3, 170, 26:16, 21:11)               \
    HANDLER(EmcTClkStop, 170, 4:0, 26:22)                            \
    HANDLER(EmcWext, 170, 4:0, 31:27)                                \
    HANDLER(EmcPmacroPerbitFgcgCtrl0, 171, 10:0, 10:0)               \
    HANDLER(EmcPmacroPerbitFgcgCtrl0, 171, 26:16, 21:11)             \
    HANDLER(EmcRefctrl2, 171, 0:0, 22:22)                            \
    HANDLER(EmcRefctrl2, 171, 26:24, 25:23)                          \
    HANDLER(EmcRefctrl2, 171, 31:31, 26:26)                          \
    HANDLER(EmcWeDuration, 171, 4:0, 31:27)                          \
    HANDLER(EmcPmacroPerbitFgcgCtrl1, 172, 10:0, 10:0)               \
    HANDLER(EmcPmacroPerbitFgcgCtrl1, 172, 26:16, 21:11)             \
    HANDLER(EmcWsDuration, 172, 4:0, 26:22)                          \
    HANDLER(EmcPmacroPadCfgCtrl, 172, 0:0, 27:27)                    \
    HANDLER(EmcPmacroPadCfgCtrl, 172, 9:9, 28:28)                    \
    HANDLER(EmcPmacroPadCfgCtrl, 172, 13:13, 29:29)                  \
    HANDLER(EmcPmacroPadCfgCtrl, 172, 17:16, 31:30)                  \
    HANDLER(EmcPmacroPerbitFgcgCtrl2, 173, 10:0, 10:0)               \
    HANDLER(EmcPmacroPerbitFgcgCtrl2, 173, 26:16, 21:11)             \
    HANDLER(McEmemArbTimingRrd, 173, 4:0, 26:22)                     \
    HANDLER(McEmemArbTimingR2R, 173, 4:0, 31:27)                     \
    HANDLER(EmcPmacroPerbitFgcgCtrl3, 174, 10:0, 10:0)               \
    HANDLER(EmcPmacroPerbitFgcgCtrl3, 174, 26:16, 21:11)             \
    HANDLER(McEmemArbTimingW2W, 174, 4:0, 26:22)                     \
    HANDLER(EmcPmacroTxSelClkSrc3, 174, 26:24, 29:27)                \
    HANDLER(EmcPmacroTxSelClkSrc2, 174, 1:0, 31:30)                  \
    HANDLER(EmcPmacroPerbitFgcgCtrl4, 175, 10:0, 10:0)               \
    HANDLER(EmcPmacroPerbitFgcgCtrl4, 175, 26:16, 21:11)             \
    HANDLER(EmcPmacroTxSelClkSrc2, 175, 10:2, 30:22)                 \
    HANDLER(EmcPmacroTxSelClkSrc2, 175, 16:16, 31:31)                \
    HANDLER(EmcPmacroPerbitFgcgCtrl5, 176, 10:0, 10:0)               \
    HANDLER(EmcPmacroPerbitFgcgCtrl5, 176, 26:16, 21:11)             \
    HANDLER(EmcPmacroTxSelClkSrc2, 176, 26:17, 31:22)                \
    HANDLER(McEmemArbCfg, 177, 8:0, 8:0)                             \
    HANDLER(McEmemArbCfg, 177, 20:16, 13:9)                          \
    HANDLER(McEmemArbCfg, 177, 31:24, 21:14)                         \
    HANDLER(EmcPmacroTxSelClkSrc4, 177, 9:0, 31:22)                  \
    HANDLER(McEmemArbMisc1, 178, 12:0, 12:0)                         \
    HANDLER(McEmemArbMisc1, 178, 25:21, 17:13)                       \
    HANDLER(McEmemArbMisc1, 178, 31:28, 21:18)                       \
    HANDLER(EmcPmacroTxSelClkSrc4, 178, 10:10, 22:22)                \
    HANDLER(EmcPmacroTxSelClkSrc4, 178, 24:16, 31:23)                \
    HANDLER(EmcMrsWaitCnt2, 179, 9:0, 9:0)                           \
    HANDLER(EmcMrsWaitCnt2, 179, 26:16, 20:10)                       \
    HANDLER(EmcOdtWrite, 179, 5:0, 26:21)                            \
    HANDLER(EmcOdtWrite, 179, 11:8, 30:27)                           \
    HANDLER(EmcOdtWrite, 179, 31:31, 31:31)                          \
    HANDLER(EmcMrsWaitCnt, 180, 9:0, 9:0)                            \
    HANDLER(EmcMrsWaitCnt, 180, 26:16, 20:10)                        \
    HANDLER(EmcPmacroIbRxrt, 180, 10:0, 31:21)                       \
    HANDLER(EmcAutoCalInterval, 181, 20:0, 20:0)                     \
    HANDLER(EmcPmacroDdllLongCmd_4, 181, 10:0, 31:21)                \
    HANDLER(McEmemArbRefpbHpCtrl, 182, 6:0, 6:0)                     \
    HANDLER(McEmemArbRefpbHpCtrl, 182, 14:8, 13:7)                   \
    HANDLER(McEmemArbRefpbHpCtrl, 182, 22:16, 20:14)                 \
    HANDLER(McEmemArbOutstandingReq, 182, 8:0, 29:21)                \
    HANDLER(McEmemArbOutstandingReq, 182, 31:30, 31:30)              \
    HANDLER(EmcXm2CompPadCtrl2, 183, 5:0, 5:0)                       \
    HANDLER(EmcXm2CompPadCtrl2, 183, 17:12, 11:6)                    \
    HANDLER(EmcXm2CompPadCtrl2, 183, 21:20, 13:12)                   \
    HANDLER(EmcXm2CompPadCtrl2, 183, 29:24, 19:14)                   \
    HANDLER(EmcPmacroCmdCtrl0, 183, 0:0, 20:20)                      \
    HANDLER(EmcPmacroCmdCtrl0, 183, 5:4, 22:21)                      \
    HANDLER(EmcPmacroCmdCtrl0, 183, 8:8, 23:23)                      \
    HANDLER(EmcPmacroCmdCtrl0, 183, 13:12, 25:24)                    \
    HANDLER(EmcPmacroCmdCtrl0, 183, 16:16, 26:26)                    \
    HANDLER(EmcPmacroCmdCtrl0, 183, 21:20, 28:27)                    \
    HANDLER(EmcPmacroCmdCtrl0, 183, 24:24, 29:29)                    \
    HANDLER(EmcPmacroCmdCtrl0, 183, 29:28, 31:30)                    \
    HANDLER(EmcCfgDigDll_1, 184, 19:0, 19:0)                         \
    HANDLER(EmcPmacroCmdCtrl1, 184, 0:0, 20:20)                      \
    HANDLER(EmcPmacroCmdCtrl1, 184, 5:4, 22:21)                      \
    HANDLER(EmcPmacroCmdCtrl1, 184, 8:8, 23:23)                      \
    HANDLER(EmcPmacroCmdCtrl1, 184, 13:12, 25:24)                    \
    HANDLER(EmcPmacroCmdCtrl1, 184, 16:16, 26:26)                    \
    HANDLER(EmcPmacroCmdCtrl1, 184, 21:20, 28:27)                    \
    HANDLER(EmcPmacroCmdCtrl1, 184, 24:24, 29:29)                    \
    HANDLER(EmcPmacroCmdCtrl1, 184, 29:28, 31:30)                    \
    HANDLER(EmcQuseBrlshft0, 185, 19:0, 19:0)                        \
    HANDLER(EmcPmacroCmdCtrl2, 185, 0:0, 20:20)                      \
    HANDLER(EmcPmacroCmdCtrl2, 185, 5:4, 22:21)                      \
    HANDLER(EmcPmacroCmdCtrl2, 185, 8:8, 23:23)                      \
    HANDLER(EmcPmacroCmdCtrl2, 185, 13:12, 25:24)                    \
    HANDLER(EmcPmacroCmdCtrl2, 185, 16:16, 26:26)                    \
    HANDLER(EmcPmacroCmdCtrl2, 185, 21:20, 28:27)                    \
    HANDLER(EmcPmacroCmdCtrl2, 185, 24:24, 29:29)                    \
    HANDLER(EmcPmacroCmdCtrl2, 185, 29:28, 31:30)                    \
    HANDLER(EmcQuseBrlshft1, 186, 19:0, 19:0)                        \
    HANDLER(EmcPmacroDsrVttgenCtrl0, 186, 3:0, 23:20)                \
    HANDLER(EmcPmacroDsrVttgenCtrl0, 186, 15:8, 31:24)               \
    HANDLER(EmcQuseBrlshft2, 187, 19:0, 19:0)                        \
    HANDLER(EmcPmacroPerbitRfu1Ctrl0, 187, 5:0, 25:20)               \
    HANDLER(EmcPmacroPerbitRfu1Ctrl0, 187, 21:16, 31:26)             \
    HANDLER(EmcQuseBrlshft3, 188, 19:0, 19:0)                        \
    HANDLER(EmcPmacroPerbitRfu1Ctrl1, 188, 5:0, 25:20)               \
    HANDLER(EmcPmacroPerbitRfu1Ctrl1, 188, 21:16, 31:26)             \
    HANDLER(EmcDbg, 189, 4:0, 4:0)                                   \
    HANDLER(EmcDbg, 189, 13:9, 9:5)                                  \
    HANDLER(EmcDbg, 189, 31:24, 17:10)                               \
    HANDLER(EmcTRefBw, 189, 13:0, 31:18)                             \
    HANDLER(EmcZcalWaitCnt, 191, 10:0, 10:0)                         \
    HANDLER(EmcZcalWaitCnt, 191, 21:16, 16:11)                       \
    HANDLER(EmcZcalWaitCnt, 191, 31:31, 17:17)                       \
    HANDLER(EmcQpop, 191, 6:0, 24:18)                                \
    HANDLER(EmcQpop, 191, 22:16, 31:25)                              \
    HANDLER(EmcZcalMrwCmd, 192, 7:0, 7:0)                            \
    HANDLER(EmcZcalMrwCmd, 192, 23:16, 15:8)                         \
    HANDLER(EmcZcalMrwCmd, 192, 31:30, 17:16)                        \
    HANDLER(EmcPmacroAutocalCfgCommon, 192, 5:0, 23:18)              \
    HANDLER(EmcPmacroAutocalCfgCommon, 192, 13:8, 29:24)             \
    HANDLER(EmcPmacroAutocalCfgCommon, 192, 16:16, 30:30)            \
    HANDLER(EmcPmacroTxSelClkSrc4, 192, 25:25, 31:31)                \
    HANDLER(EmcPmacroDllCfg1, 193, 10:0, 10:0)                       \
    HANDLER(EmcPmacroDllCfg1, 193, 13:12, 12:11)                     \
    HANDLER(EmcPmacroDllCfg1, 193, 17:16, 14:13)                     \
    HANDLER(EmcPmacroDllCfg1, 193, 21:20, 16:15)                     \
    HANDLER(EmcPmacroDllCfg1, 193, 24:24, 17:17)                     \
    HANDLER(EmcPmacroPerbitRfu1Ctrl2, 193, 5:0, 23:18)               \
    HANDLER(EmcPmacroPerbitRfu1Ctrl2, 193, 21:16, 29:24)             \
    HANDLER(EmcPmacroTxSelClkSrc4, 193, 26:26, 30:30)                \
    HANDLER(EmcPmacroTxSelClkSrc5, 193, 0:0, 31:31)                  \
    HANDLER(EmcPmacroCmdBrickCtrlFdpd, 194, 17:0, 17:0)              \
    HANDLER(EmcPmacroPerbitRfu1Ctrl3, 194, 5:0, 23:18)               \
    HANDLER(EmcPmacroPerbitRfu1Ctrl3, 194, 21:16, 29:24)             \
    HANDLER(EmcPmacroTxSelClkSrc5, 194, 2:1, 31:30)                  \
    HANDLER(EmcPmacroDataBrickCtrlFdpd, 195, 17:0, 17:0)             \
    HANDLER(EmcPmacroPerbitRfu1Ctrl4, 195, 5:0, 23:18)               \
    HANDLER(EmcPmacroPerbitRfu1Ctrl4, 195, 21:16, 29:24)             \
    HANDLER(EmcPmacroTxSelClkSrc5, 195, 4:3, 31:30)                  \
    HANDLER(EmcDynSelfRefControl, 196, 15:0, 15:0)                   \
    HANDLER(EmcDynSelfRefControl, 196, 31:31, 16:16)                 \
    HANDLER(McEmemArbRefpbBankCtrl, 196, 6:0, 23:17)                 \
    HANDLER(McEmemArbRefpbBankCtrl, 196, 14:8, 30:24)                \
    HANDLER(McEmemArbRefpbBankCtrl, 196, 31:31, 31:31)               \
    HANDLER(EmcPmacroCmdPadRxCtrl, 197, 1:0, 1:0)                    \
    HANDLER(EmcPmacroCmdPadRxCtrl, 197, 5:4, 3:2)                    \
    HANDLER(EmcPmacroCmdPadRxCtrl, 197, 12:12, 4:4)                  \
    HANDLER(EmcPmacroCmdPadRxCtrl, 197, 19:15, 9:5)                  \
    HANDLER(EmcPmacroCmdPadRxCtrl, 197, 27:21, 16:10)                \
    HANDLER(EmcPmacroPerbitRfu1Ctrl5, 197, 5:0, 22:17)               \
    HANDLER(EmcPmacroPerbitRfu1Ctrl5, 197, 21:16, 28:23)             \
    HANDLER(EmcPmacroTxSelClkSrc5, 197, 7:5, 31:29)                  \
    HANDLER(EmcPmacroDataPadRxCtrl, 198, 1:0, 1:0)                   \
    HANDLER(EmcPmacroDataPadRxCtrl, 198, 5:4, 3:2)                   \
    HANDLER(EmcPmacroDataPadRxCtrl, 198, 12:12, 4:4)                 \
    HANDLER(EmcPmacroDataPadRxCtrl, 198, 19:15, 9:5)                 \
    HANDLER(EmcPmacroDataPadRxCtrl, 198, 27:21, 16:10)               \
    HANDLER(EmcPmacroTxSelClkSrc5, 198, 10:8, 19:17)                 \
    HANDLER(EmcPmacroTxSelClkSrc5, 198, 26:16, 30:20)                \
    HANDLER(EmcPmacroCmdPadTxCtrl, 198, 0:0, 31:31)                  \
    HANDLER(EmcRefresh, 199, 15:0, 15:0)                             \
    HANDLER(EmcCmdQ, 199, 4:0, 20:16)                                \
    HANDLER(EmcCmdQ, 199, 10:8, 23:21)                               \
    HANDLER(EmcCmdQ, 199, 14:12, 26:24)                              \
    HANDLER(EmcCmdQ, 199, 28:24, 31:27)                              \
    HANDLER(EmcAcpdControl, 210, 15:0, 15:0)                         \
    HANDLER(EmcAutoCalVrefSel1, 210, 15:0, 31:16)                    \
    HANDLER(EmcPmacroAutocalCfg0, 211, 3:0, 3:0)                     \
    HANDLER(EmcPmacroAutocalCfg0, 211, 11:8, 7:4)                    \
    HANDLER(EmcPmacroAutocalCfg0, 211, 19:16, 11:8)                  \
    HANDLER(EmcPmacroAutocalCfg0, 211, 27:24, 15:12)                 \
    HANDLER(EmcPmacroAutocalCfg1, 211, 3:0, 19:16)                   \
    HANDLER(EmcPmacroAutocalCfg1, 211, 11:8, 23:20)                  \
    HANDLER(EmcPmacroAutocalCfg1, 211, 19:16, 27:24)                 \
    HANDLER(EmcPmacroAutocalCfg1, 211, 27:24, 31:28)                 \
    HANDLER(EmcPmacroAutocalCfg2, 212, 3:0, 3:0)                     \
    HANDLER(EmcPmacroAutocalCfg2, 212, 11:8, 7:4)                    \
    HANDLER(EmcPmacroAutocalCfg2, 212, 19:16, 11:8)                  \
    HANDLER(EmcPmacroAutocalCfg2, 212, 27:24, 15:12)                 \
    HANDLER(EmcXm2CompPadCtrl3, 212, 5:0, 21:16)                     \
    HANDLER(EmcXm2CompPadCtrl3, 212, 17:12, 27:22)                   \
    HANDLER(EmcXm2CompPadCtrl3, 212, 23:20, 31:28)                   \
    HANDLER(EmcCfgDigDllPeriod, 213, 15:0, 15:0)                     \
    HANDLER(EmcPreRefreshReqCnt, 213, 15:0, 31:16)                   \
    HANDLER(EmcPmacroDdllBypass, 214, 0:0, 0:0)                      \
    HANDLER(EmcPmacroDdllBypass, 214, 11:8, 4:1)                     \
    HANDLER(EmcPmacroDdllBypass, 214, 16:13, 8:5)                    \
    HANDLER(EmcPmacroDdllBypass, 214, 27:24, 12:9)                   \
    HANDLER(EmcPmacroDdllBypass, 214, 31:29, 15:13)                  \
    HANDLER(EmcPmacroDataPiCtrl, 214, 4:0, 20:16)                    \
    HANDLER(EmcPmacroDataPiCtrl, 214, 12:8, 25:21)                   \
    HANDLER(EmcPmacroDataPiCtrl, 214, 21:16, 31:26)                  \
    HANDLER(EmcPmacroCmdPiCtrl, 215, 4:0, 4:0)                       \
    HANDLER(EmcPmacroCmdPiCtrl, 215, 12:8, 9:5)                      \
    HANDLER(EmcPmacroCmdPiCtrl, 215, 21:16, 15:10)                   \
    HANDLER(EmcPmacroCmdPadTxCtrl, 216, 6:5, 1:0)                    \
    HANDLER(EmcPmacroCmdPadTxCtrl, 216, 10:10, 2:2)                  \
    HANDLER(EmcPmacroCmdPadTxCtrl, 216, 16:15, 4:3)                  \
    HANDLER(EmcPmacroCmdPadTxCtrl, 216, 30:21, 14:5)                 \
    HANDLER(EmcPmacroDataPadTxCtrl, 216, 0:0, 15:15)                 \
    HANDLER(EmcPmacroDataPadTxCtrl, 216, 6:5, 17:16)                 \
    HANDLER(EmcPmacroDataPadTxCtrl, 216, 10:10, 18:18)               \
    HANDLER(EmcPmacroDataPadTxCtrl, 216, 16:15, 20:19)               \
    HANDLER(EmcPmacroDataPadTxCtrl, 216, 30:21, 30:21)               \
    HANDLER(EmcPinGpio, 9, 1:0, 31:30)                               \
    HANDLER(EmcPinGpioEn, 10, 1:0, 31:30)                            \
    HANDLER(EmcDevSelect, 11, 1:0, 31:30)                            \
    HANDLER(EmcZcalWarmColdBootEnables, 12, 1:0, 31:30)              \
    HANDLER(EmcCfgDigDllPeriodWarmBoot, 13, 1:0, 31:30)              \
    HANDLER(EmcBctSpare13, 45, 31:0, 31:0)                           \
    HANDLER(EmcBctSpare12, 46, 31:0, 31:0)                           \
    HANDLER(EmcBctSpare7, 47, 31:0, 31:0)                            \
    HANDLER(EmcBctSpare6, 48, 31:0, 31:0)                            \
    HANDLER(EmcBctSpare5, 50, 31:0, 31:0)                            \
    HANDLER(EmcBctSpare4, 51, 31:0, 31:0)                            \
    HANDLER(EmcBctSpare3, 56, 31:0, 31:0)                            \
    HANDLER(EmcBctSpare2, 57, 31:0, 31:0)                            \
    HANDLER(EmcBctSpare1, 58, 31:0, 31:0)                            \
    HANDLER(EmcBctSpare0, 59, 31:0, 31:0)                            \
    HANDLER(EmcBctSpare9, 60, 31:0, 31:0)                            \
    HANDLER(EmcBctSpare8, 61, 31:0, 31:0)                            \
    HANDLER(BootRomPatchData, 62, 31:0, 31:0)                        \
    HANDLER(BootRomPatchControl, 63, 31:0, 31:0)                     \
    HANDLER(McClkenOverrideAllWarmBoot, 65, 0:0, 31:31)              \
    HANDLER(EmcExtraRefreshNum, 66, 2:0, 31:29)                      \
    HANDLER(PmcIoDpd3ReqWait, 72, 2:0, 30:28)                        \
    HANDLER(EmcClkenOverrideAllWarmBoot, 72, 0:0, 31:31)             \
    HANDLER(MemoryType, 73, 2:0, 30:28)                              \
    HANDLER(EmcMrsWarmBootEnable, 73, 0:0, 31:31)                    \
    HANDLER(PmcIoDpd4ReqWait, 74, 2:0, 30:28)                        \
    HANDLER(ClearClk2Mc1, 74, 0:0, 31:31)                            \
    HANDLER(EmcWarmBootExtraModeRegWriteEnable, 75, 0:0, 28:28)      \
    HANDLER(ClkRstControllerPllmMisc2OverrideEnable, 75, 0:0, 29:29) \
    HANDLER(EmcDbgWriteMux, 75, 0:0, 30:30)                          \
    HANDLER(AhbArbitrationXbarCtrlMemInitDone, 75, 0:0, 31:31)       \
    HANDLER(EmcTimingControlWait, 90, 7:0, 31:24)                    \
    HANDLER(EmcZcalWarmBootWait, 91, 7:0, 31:24)                     \
    HANDLER(WarmBootWait, 92, 7:0, 31:24)                            \
    HANDLER(EmcPinProgramWait, 93, 7:0, 31:24)                       \
    HANDLER(EmcAutoCalWait, 114, 9:0, 31:22)                         \
    HANDLER(SwizzleRankByteEncode, 215, 15:0, 31:16)                 \
                                                                     \
    /* PMC SCRATCH fields for LPDDR2. */                             \
    HANDLER(EmcMrwLpddr2ZcalWarmBoot, 5, 23:16, 7:0)                 \
    HANDLER(EmcMrwLpddr2ZcalWarmBoot, 5, 7:0, 15:8)                  \
    HANDLER(EmcWarmBootMrwExtra, 5, 23:16, 23:16)                    \
    HANDLER(EmcWarmBootMrwExtra, 5, 7:0, 31:24)                      \
    HANDLER(EmcMrwLpddr2ZcalWarmBoot, 6, 31:30, 1:0)                 \
    HANDLER(EmcWarmBootMrwExtra, 6, 31:30, 3:2)                      \
    HANDLER(EmcMrwLpddr2ZcalWarmBoot, 6, 27:26, 5:4)                 \
    HANDLER(EmcWarmBootMrwExtra, 6, 27:26, 7:6)                      \
    HANDLER(EmcMrw6, 8, 27:0, 27:0)                                  \
    HANDLER(EmcMrw6, 8, 31:30, 29:28)                                \
    HANDLER(EmcMrw8, 9, 27:0, 27:0)                                  \
    HANDLER(EmcMrw8, 9, 31:30, 29:28)                                \
    HANDLER(EmcMrw9, 10, 27:0, 27:0)                                 \
    HANDLER(EmcMrw9, 10, 31:30, 29:28)                               \
    HANDLER(EmcMrw10, 11, 27:0, 27:0)                                \
    HANDLER(EmcMrw10, 11, 31:30, 29:28)                              \
    HANDLER(EmcMrw12, 12, 27:0, 27:0)                                \
    HANDLER(EmcMrw12, 12, 31:30, 29:28)                              \
    HANDLER(EmcMrw13, 13, 27:0, 27:0)                                \
    HANDLER(EmcMrw13, 13, 31:30, 29:28)                              \
    HANDLER(EmcMrw14, 14, 27:0, 27:0)                                \
    HANDLER(EmcMrw14, 14, 31:30, 29:28)                              \
    HANDLER(EmcMrw1, 15, 7:0, 7:0)                                   \
    HANDLER(EmcMrw1, 15, 23:16, 15:8)                                \
    HANDLER(EmcMrw1, 15, 27:26, 17:16)                               \
    HANDLER(EmcMrw1, 15, 31:30, 19:18)                               \
    HANDLER(EmcWarmBootMrwExtra, 16, 7:0, 7:0)                       \
    HANDLER(EmcWarmBootMrwExtra, 16, 23:16, 15:8)                    \
    HANDLER(EmcWarmBootMrwExtra, 16, 27:26, 17:16)                   \
    HANDLER(EmcWarmBootMrwExtra, 16, 31:30, 19:18)                   \
    HANDLER(EmcMrw2, 17, 7:0, 7:0)                                   \
    HANDLER(EmcMrw2, 17, 23:16, 15:8)                                \
    HANDLER(EmcMrw2, 17, 27:26, 17:16)                               \
    HANDLER(EmcMrw2, 17, 31:30, 19:18)                               \
    HANDLER(EmcMrw3, 18, 7:0, 7:0)                                   \
    HANDLER(EmcMrw3, 18, 23:16, 15:8)                                \
    HANDLER(EmcMrw3, 18, 27:26, 17:16)                               \
    HANDLER(EmcMrw3, 18, 31:30, 19:18)                               \
    HANDLER(EmcMrw4, 19, 7:0, 7:0)                                   \
    HANDLER(EmcMrw4, 19, 23:16, 15:8)                                \
    HANDLER(EmcMrw4, 19, 27:26, 17:16)                               \
    HANDLER(EmcMrw4, 19, 31:30, 19:18)

#define FOREACH_SDRAM_SECURE_SCRATCH_REGISTER_MARIKO(HANDLER)            \
    /* PMC SECURE_SCRATCH fields. */                                     \
    HANDLER(EmcCmdMappingByte, 8, 31:0, 31:0)                            \
    HANDLER(EmcPmacroBrickMapping0, 9, 31:0, 31:0)                       \
    HANDLER(EmcPmacroBrickMapping1, 10, 31:0, 31:0)                      \
    HANDLER(EmcPmacroBrickMapping2, 11, 31:0, 31:0)                      \
    HANDLER(McVideoProtectGpuOverride0, 12, 31:0, 31:0)                  \
    HANDLER(EmcCmdMappingCmd0_0, 13, 6:0, 6:0)                           \
    HANDLER(EmcCmdMappingCmd0_0, 13, 14:8, 13:7)                         \
    HANDLER(EmcCmdMappingCmd0_0, 13, 22:16, 20:14)                       \
    HANDLER(EmcCmdMappingCmd0_0, 13, 30:24, 27:21)                       \
    HANDLER(McUntranslatedRegionCheck, 13, 0:0, 28:28)                   \
    HANDLER(McUntranslatedRegionCheck, 13, 9:8, 30:29)                   \
    HANDLER(EmcAdrCfg, 13, 0:0, 31:31)                                   \
    HANDLER(EmcCmdMappingCmd0_1, 14, 6:0, 6:0)                           \
    HANDLER(EmcCmdMappingCmd0_1, 14, 14:8, 13:7)                         \
    HANDLER(EmcCmdMappingCmd0_1, 14, 22:16, 20:14)                       \
    HANDLER(EmcCmdMappingCmd0_1, 14, 30:24, 27:21)                       \
    HANDLER(McVideoProtectBomAdrHi, 14, 1:0, 29:28)                      \
    HANDLER(McVideoProtectWriteAccess, 14, 1:0, 31:30)                   \
    HANDLER(EmcCmdMappingCmd1_0, 15, 6:0, 6:0)                           \
    HANDLER(EmcCmdMappingCmd1_0, 15, 14:8, 13:7)                         \
    HANDLER(EmcCmdMappingCmd1_0, 15, 22:16, 20:14)                       \
    HANDLER(EmcCmdMappingCmd1_0, 15, 30:24, 27:21)                       \
    HANDLER(McSecCarveoutAdrHi, 15, 1:0, 29:28)                          \
    HANDLER(McMtsCarveoutAdrHi, 15, 1:0, 31:30)                          \
    HANDLER(EmcCmdMappingCmd1_1, 16, 6:0, 6:0)                           \
    HANDLER(EmcCmdMappingCmd1_1, 16, 14:8, 13:7)                         \
    HANDLER(EmcCmdMappingCmd1_1, 16, 22:16, 20:14)                       \
    HANDLER(EmcCmdMappingCmd1_1, 16, 30:24, 27:21)                       \
    HANDLER(McGeneralizedCarveout5BomHi, 16, 1:0, 29:28)                 \
    HANDLER(McGeneralizedCarveout3BomHi, 16, 1:0, 31:30)                 \
    HANDLER(EmcCmdMappingCmd2_0, 17, 6:0, 6:0)                           \
    HANDLER(EmcCmdMappingCmd2_0, 17, 14:8, 13:7)                         \
    HANDLER(EmcCmdMappingCmd2_0, 17, 22:16, 20:14)                       \
    HANDLER(EmcCmdMappingCmd2_0, 17, 30:24, 27:21)                       \
    HANDLER(McGeneralizedCarveout2BomHi, 17, 1:0, 29:28)                 \
    HANDLER(McGeneralizedCarveout4BomHi, 17, 1:0, 31:30)                 \
    HANDLER(EmcCmdMappingCmd2_1, 18, 6:0, 6:0)                           \
    HANDLER(EmcCmdMappingCmd2_1, 18, 14:8, 13:7)                         \
    HANDLER(EmcCmdMappingCmd2_1, 18, 22:16, 20:14)                       \
    HANDLER(EmcCmdMappingCmd2_1, 18, 30:24, 27:21)                       \
    HANDLER(McGeneralizedCarveout1BomHi, 18, 1:0, 29:28)                 \
    HANDLER(EmcFbioSpare, 18, 1:1, 30:30)                                \
    HANDLER(EmcFbioCfg8, 18, 15:15, 31:31)                               \
    HANDLER(EmcCmdMappingCmd3_0, 19, 6:0, 6:0)                           \
    HANDLER(EmcCmdMappingCmd3_0, 19, 14:8, 13:7)                         \
    HANDLER(EmcCmdMappingCmd3_0, 19, 22:16, 20:14)                       \
    HANDLER(EmcCmdMappingCmd3_0, 19, 30:24, 27:21)                       \
    HANDLER(McEmemAdrCfg, 19, 0:0, 28:28)                                \
    HANDLER(McSecCarveoutProtectWriteAccess, 19, 0:0, 29:29)             \
    HANDLER(McMtsCarveoutRegCtrl, 19, 0:0, 30:30)                        \
    HANDLER(McVideoProtectVprOverride, 19, 0:0, 31:31)                   \
    HANDLER(EmcCmdMappingCmd3_1, 20, 6:0, 6:0)                           \
    HANDLER(EmcCmdMappingCmd3_1, 20, 14:8, 13:7)                         \
    HANDLER(EmcCmdMappingCmd3_1, 20, 22:16, 20:14)                       \
    HANDLER(EmcCmdMappingCmd3_1, 20, 30:24, 27:21)                       \
    HANDLER(McGeneralizedCarveout2Cfg0, 20, 6:3, 31:28)                  \
    HANDLER(McGeneralizedCarveout4Cfg0, 39, 26:0, 26:0)                  \
    HANDLER(McGeneralizedCarveout2Cfg0, 39, 10:7, 30:27)                 \
    HANDLER(McVideoProtectVprOverride, 39, 1:1, 31:31)                   \
    HANDLER(McGeneralizedCarveout5Cfg0, 40, 26:0, 26:0)                  \
    HANDLER(McGeneralizedCarveout2Cfg0, 40, 17:14, 30:27)                \
    HANDLER(McVideoProtectVprOverride, 40, 2:2, 31:31)                   \
    HANDLER(EmcCmdMappingCmd0_2, 41, 6:0, 6:0)                           \
    HANDLER(EmcCmdMappingCmd0_2, 41, 14:8, 13:7)                         \
    HANDLER(EmcCmdMappingCmd0_2, 41, 22:16, 20:14)                       \
    HANDLER(EmcCmdMappingCmd0_2, 41, 27:24, 24:21)                       \
    HANDLER(McGeneralizedCarveout2Cfg0, 41, 21:18, 28:25)                \
    HANDLER(McGeneralizedCarveout2Cfg0, 41, 13:11, 31:29)                \
    HANDLER(EmcCmdMappingCmd1_2, 42, 6:0, 6:0)                           \
    HANDLER(EmcCmdMappingCmd1_2, 42, 14:8, 13:7)                         \
    HANDLER(EmcCmdMappingCmd1_2, 42, 22:16, 20:14)                       \
    HANDLER(EmcCmdMappingCmd1_2, 42, 27:24, 24:21)                       \
    HANDLER(McGeneralizedCarveout1Cfg0, 42, 6:3, 28:25)                  \
    HANDLER(McGeneralizedCarveout1Cfg0, 42, 13:11, 31:29)                \
    HANDLER(EmcCmdMappingCmd2_2, 43, 6:0, 6:0)                           \
    HANDLER(EmcCmdMappingCmd2_2, 43, 14:8, 13:7)                         \
    HANDLER(EmcCmdMappingCmd2_2, 43, 22:16, 20:14)                       \
    HANDLER(EmcCmdMappingCmd2_2, 43, 27:24, 24:21)                       \
    HANDLER(McGeneralizedCarveout1Cfg0, 43, 10:7, 28:25)                 \
    HANDLER(McGeneralizedCarveout3Cfg0, 43, 13:11, 31:29)                \
    HANDLER(EmcCmdMappingCmd3_2, 44, 6:0, 6:0)                           \
    HANDLER(EmcCmdMappingCmd3_2, 44, 14:8, 13:7)                         \
    HANDLER(EmcCmdMappingCmd3_2, 44, 22:16, 20:14)                       \
    HANDLER(EmcCmdMappingCmd3_2, 44, 27:24, 24:21)                       \
    HANDLER(McGeneralizedCarveout1Cfg0, 44, 17:14, 28:25)                \
    HANDLER(McVideoProtectVprOverride, 44, 3:3, 29:29)                   \
    HANDLER(McVideoProtectVprOverride, 44, 7:6, 31:30)                   \
    HANDLER(McEmemAdrCfgChannelMask, 45, 31:9, 22:0)                     \
    HANDLER(McEmemAdrCfgDev0, 45, 2:0, 25:23)                            \
    HANDLER(McEmemAdrCfgDev0, 45, 9:8, 27:26)                            \
    HANDLER(McEmemAdrCfgDev0, 45, 19:16, 31:28)                          \
    HANDLER(McEmemAdrCfgBankMask0, 46, 31:10, 21:0)                      \
    HANDLER(McEmemAdrCfgDev1, 46, 2:0, 24:22)                            \
    HANDLER(McEmemAdrCfgDev1, 46, 9:8, 26:25)                            \
    HANDLER(McEmemAdrCfgDev1, 46, 19:16, 30:27)                          \
    HANDLER(McVideoProtectVprOverride, 46, 8:8, 31:31)                   \
    HANDLER(McEmemAdrCfgBankMask1, 47, 31:10, 21:0)                      \
    HANDLER(McGeneralizedCarveout1Cfg0, 47, 21:18, 25:22)                \
    HANDLER(McGeneralizedCarveout3Cfg0, 47, 6:3, 29:26)                  \
    HANDLER(McVideoProtectVprOverride, 47, 9:9, 30:30)                   \
    HANDLER(McVideoProtectVprOverride, 47, 11:11, 31:31)                 \
    HANDLER(McEmemAdrCfgBankMask2, 48, 31:10, 21:0)                      \
    HANDLER(McGeneralizedCarveout3Cfg0, 48, 10:7, 25:22)                 \
    HANDLER(McGeneralizedCarveout3Cfg0, 48, 17:14, 29:26)                \
    HANDLER(McVideoProtectVprOverride, 48, 15:14, 31:30)                 \
    HANDLER(McVideoProtectGpuOverride1, 49, 15:0, 15:0)                  \
    HANDLER(McEmemCfg, 49, 13:0, 29:16)                                  \
    HANDLER(McEmemCfg, 49, 31:31, 30:30)                                 \
    HANDLER(McVideoProtectVprOverride, 49, 17:17, 31:31)                 \
    HANDLER(McGeneralizedCarveout3Bom, 50, 31:17, 14:0)                  \
    HANDLER(McGeneralizedCarveout1Bom, 50, 31:17, 29:15)                 \
    HANDLER(McVideoProtectVprOverride, 50, 19:18, 31:30)                 \
    HANDLER(McGeneralizedCarveout4Bom, 51, 31:17, 14:0)                  \
    HANDLER(McGeneralizedCarveout2Bom, 51, 31:17, 29:15)                 \
    HANDLER(McVideoProtectVprOverride, 51, 21:20, 31:30)                 \
    HANDLER(McGeneralizedCarveout5Bom, 52, 31:17, 14:0)                  \
    HANDLER(McVideoProtectBom, 52, 31:20, 26:15)                         \
    HANDLER(McGeneralizedCarveout3Cfg0, 52, 21:18, 30:27)                \
    HANDLER(McVideoProtectVprOverride, 52, 22:22, 31:31)                 \
    HANDLER(McVideoProtectSizeMb, 53, 11:0, 11:0)                        \
    HANDLER(McSecCarveoutBom, 53, 31:20, 23:12)                          \
    HANDLER(McVideoProtectVprOverride, 53, 23:23, 24:24)                 \
    HANDLER(McVideoProtectVprOverride, 53, 26:26, 25:25)                 \
    HANDLER(McVideoProtectVprOverride, 53, 31:29, 28:26)                 \
    HANDLER(McVideoProtectVprOverride1, 53, 1:0, 30:29)                  \
    HANDLER(McVideoProtectVprOverride1, 53, 4:4, 31:31)                  \
    HANDLER(McSecCarveoutSizeMb, 54, 11:0, 11:0)                         \
    HANDLER(McMtsCarveoutBom, 54, 31:20, 23:12)                          \
    HANDLER(McVideoProtectVprOverride1, 54, 12:5, 31:24)                 \
    HANDLER(McMtsCarveoutSizeMb, 55, 11:0, 11:0)                         \
    HANDLER(McGeneralizedCarveout4Size128kb, 55, 11:0, 23:12)            \
    HANDLER(McVideoProtectVprOverride1, 55, 16:13, 27:24)                \
    HANDLER(McVideoProtectVprOverride1, 55, 26:25, 29:28)                \
    HANDLER(McGeneralizedCarveout2Cfg0, 55, 1:0, 31:30)                  \
    HANDLER(McGeneralizedCarveout3Size128kb, 56, 11:0, 11:0)             \
    HANDLER(McGeneralizedCarveout2Size128kb, 56, 11:0, 23:12)            \
    HANDLER(McGeneralizedCarveout2Cfg0, 56, 2:2, 24:24)                  \
    HANDLER(McGeneralizedCarveout2Cfg0, 56, 26:22, 29:25)                \
    HANDLER(McGeneralizedCarveout1Cfg0, 56, 1:0, 31:30)                  \
    HANDLER(McGeneralizedCarveout1Size128kb, 57, 11:0, 11:0)             \
    HANDLER(McGeneralizedCarveout5Size128kb, 57, 11:0, 23:12)            \
    HANDLER(McGeneralizedCarveout1Cfg0, 57, 2:2, 24:24)                  \
    HANDLER(McGeneralizedCarveout1Cfg0, 57, 26:22, 29:25)                \
    HANDLER(McGeneralizedCarveout3Cfg0, 57, 1:0, 31:30)                  \
    HANDLER(McGeneralizedCarveout3Cfg0, 58, 2:2, 0:0)                    \
    HANDLER(McGeneralizedCarveout3Cfg0, 58, 26:22, 5:1)                  \
    HANDLER(McGeneralizedCarveout1Access0, 59, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout1Access1, 60, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout1Access2, 61, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout1Access3, 62, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout1Access4, 63, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout2Access0, 64, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout2Access1, 65, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout2Access2, 66, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout2Access3, 67, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout2Access4, 68, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout3Access0, 69, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout3Access1, 70, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout3Access2, 71, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout3Access3, 72, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout3Access4, 73, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout4Access0, 74, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout4Access1, 75, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout4Access2, 76, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout4Access3, 77, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout4Access4, 78, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout5Access0, 79, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout5Access1, 80, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout5Access2, 81, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout5Access3, 82, 31:0, 31:0)               \
    HANDLER(McGeneralizedCarveout1ForceInternalAccess0, 84, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout1ForceInternalAccess1, 85, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout1ForceInternalAccess2, 86, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout1ForceInternalAccess3, 87, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout1ForceInternalAccess4, 88, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout2ForceInternalAccess0, 89, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout2ForceInternalAccess1, 90, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout2ForceInternalAccess2, 91, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout2ForceInternalAccess3, 92, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout2ForceInternalAccess4, 93, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout3ForceInternalAccess0, 94, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout3ForceInternalAccess1, 95, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout3ForceInternalAccess2, 96, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout3ForceInternalAccess3, 97, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout3ForceInternalAccess4, 98, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout4ForceInternalAccess0, 99, 31:0, 31:0)  \
    HANDLER(McGeneralizedCarveout4ForceInternalAccess1, 100, 31:0, 31:0) \
    HANDLER(McGeneralizedCarveout4ForceInternalAccess2, 101, 31:0, 31:0) \
    HANDLER(McGeneralizedCarveout4ForceInternalAccess3, 102, 31:0, 31:0) \
    HANDLER(McGeneralizedCarveout4ForceInternalAccess4, 103, 31:0, 31:0) \
    HANDLER(McGeneralizedCarveout5ForceInternalAccess0, 104, 31:0, 31:0) \
    HANDLER(McGeneralizedCarveout5ForceInternalAccess1, 105, 31:0, 31:0) \
    HANDLER(McGeneralizedCarveout5ForceInternalAccess2, 106, 31:0, 31:0) \
    HANDLER(McGeneralizedCarveout5ForceInternalAccess3, 107, 31:0, 31:0)
