/*
 * Copyright (c) Atmosphère-NX
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#pragma once
#include <vapours.hpp>
#include <exosphere/br/impl/br_common_types.hpp>

namespace ams::br::erista {

    struct BootSdramParams {
        BootMemoryType MemoryType;
        u32 PllMInputDivider;
        u32 PllMFeedbackDivider;
        u32 PllMStableTime;
        u32 PllMSetupControl;
        u32 PllMPostDivider;
        u32 PllMKCP;
        u32 PllMKVCO;
        u32 EmcBctSpare0;
        u32 EmcBctSpare1;
        u32 EmcBctSpare2;
        u32 EmcBctSpare3;
        u32 EmcBctSpare4;
        u32 EmcBctSpare5;
        u32 EmcBctSpare6;
        u32 EmcBctSpare7;
        u32 EmcBctSpare8;
        u32 EmcBctSpare9;
        u32 EmcBctSpare10;
        u32 EmcBctSpare11;
        u32 EmcBctSpare12;
        u32 EmcBctSpare13;
        u32 EmcClockSource;
        u32 EmcClockSourceDll;
        u32 ClkRstControllerPllmMisc2Override;
        u32 ClkRstControllerPllmMisc2OverrideEnable;
        u32 ClearClk2Mc1;
        u32 EmcAutoCalInterval;
        u32 EmcAutoCalConfig;
        u32 EmcAutoCalConfig2;
        u32 EmcAutoCalConfig3;
        u32 EmcAutoCalConfig4;
        u32 EmcAutoCalConfig5;
        u32 EmcAutoCalConfig6;
        u32 EmcAutoCalConfig7;
        u32 EmcAutoCalConfig8;
        u32 EmcAutoCalVrefSel0;
        u32 EmcAutoCalVrefSel1;
        u32 EmcAutoCalChannel;
        u32 EmcPmacroAutocalCfg0;
        u32 EmcPmacroAutocalCfg1;
        u32 EmcPmacroAutocalCfg2;
        u32 EmcPmacroRxTerm;
        u32 EmcPmacroDqTxDrv;
        u32 EmcPmacroCaTxDrv;
        u32 EmcPmacroCmdTxDrv;
        u32 EmcPmacroAutocalCfgCommon;
        u32 EmcPmacroZctrl;
        u32 EmcAutoCalWait;
        u32 EmcXm2CompPadCtrl;
        u32 EmcXm2CompPadCtrl2;
        u32 EmcXm2CompPadCtrl3;
        u32 EmcAdrCfg;
        u32 EmcPinProgramWait;
        u32 EmcPinExtraWait;
        u32 EmcPinGpioEn;
        u32 EmcPinGpio;
        u32 EmcTimingControlWait;
        u32 EmcRc;
        u32 EmcRfc;
        u32 EmcRfcPb;
        u32 EmcRefctrl2;
        u32 EmcRfcSlr;
        u32 EmcRas;
        u32 EmcRp;
        u32 EmcR2r;
        u32 EmcW2w;
        u32 EmcR2w;
        u32 EmcW2r;
        u32 EmcR2p;
        u32 EmcW2p;
        u32 EmcTppd;
        u32 EmcCcdmw;
        u32 EmcRdRcd;
        u32 EmcWrRcd;
        u32 EmcRrd;
        u32 EmcRext;
        u32 EmcWext;
        u32 EmcWdv;
        u32 EmcWdvChk;
        u32 EmcWsv;
        u32 EmcWev;
        u32 EmcWdvMask;
        u32 EmcWsDuration;
        u32 EmcWeDuration;
        u32 EmcQUse;
        u32 EmcQuseWidth;
        u32 EmcIbdly;
        u32 EmcObdly;
        u32 EmcEInput;
        u32 EmcEInputDuration;
        u32 EmcPutermExtra;
        u32 EmcPutermWidth;
        u32 EmcQRst;
        u32 EmcQSafe;
        u32 EmcRdv;
        u32 EmcRdvMask;
        u32 EmcRdvEarly;
        u32 EmcRdvEarlyMask;
        u32 EmcQpop;
        u32 EmcRefresh;
        u32 EmcBurstRefreshNum;
        u32 EmcPreRefreshReqCnt;
        u32 EmcPdEx2Wr;
        u32 EmcPdEx2Rd;
        u32 EmcPChg2Pden;
        u32 EmcAct2Pden;
        u32 EmcAr2Pden;
        u32 EmcRw2Pden;
        u32 EmcCke2Pden;
        u32 EmcPdex2Cke;
        u32 EmcPdex2Mrr;
        u32 EmcTxsr;
        u32 EmcTxsrDll;
        u32 EmcTcke;
        u32 EmcTckesr;
        u32 EmcTpd;
        u32 EmcTfaw;
        u32 EmcTrpab;
        u32 EmcTClkStable;
        u32 EmcTClkStop;
        u32 EmcTRefBw;
        u32 EmcFbioCfg5;
        u32 EmcFbioCfg7;
        u32 EmcFbioCfg8;
        u32 EmcCmdMappingCmd0_0;
        u32 EmcCmdMappingCmd0_1;
        u32 EmcCmdMappingCmd0_2;
        u32 EmcCmdMappingCmd1_0;
        u32 EmcCmdMappingCmd1_1;
        u32 EmcCmdMappingCmd1_2;
        u32 EmcCmdMappingCmd2_0;
        u32 EmcCmdMappingCmd2_1;
        u32 EmcCmdMappingCmd2_2;
        u32 EmcCmdMappingCmd3_0;
        u32 EmcCmdMappingCmd3_1;
        u32 EmcCmdMappingCmd3_2;
        u32 EmcCmdMappingByte;
        u32 EmcFbioSpare;
        u32 EmcCfgRsv;
        u32 EmcMrs;
        u32 EmcEmrs;
        u32 EmcEmrs2;
        u32 EmcEmrs3;
        u32 EmcMrw1;
        u32 EmcMrw2;
        u32 EmcMrw3;
        u32 EmcMrw4;
        u32 EmcMrw6;
        u32 EmcMrw8;
        u32 EmcMrw9;
        u32 EmcMrw10;
        u32 EmcMrw12;
        u32 EmcMrw13;
        u32 EmcMrw14;
        u32 EmcMrwExtra;
        u32 EmcWarmBootMrwExtra;
        u32 EmcWarmBootExtraModeRegWriteEnable;
        u32 EmcExtraModeRegWriteEnable;
        u32 EmcMrwResetCommand;
        u32 EmcMrwResetNInitWait;
        u32 EmcMrsWaitCnt;
        u32 EmcMrsWaitCnt2;
        u32 EmcCfg;
        u32 EmcCfg2;
        u32 EmcCfgPipe;
        u32 EmcCfgPipeClk;
        u32 EmcFdpdCtrlCmdNoRamp;
        u32 EmcCfgUpdate;
        u32 EmcDbg;
        u32 EmcDbgWriteMux;
        u32 EmcCmdQ;
        u32 EmcMc2EmcQ;
        u32 EmcDynSelfRefControl;
        u32 AhbArbitrationXbarCtrlMemInitDone;
        u32 EmcCfgDigDll;
        u32 EmcCfgDigDll_1;
        u32 EmcCfgDigDllPeriod;
        u32 EmcDevSelect;
        u32 EmcSelDpdCtrl;
        u32 EmcFdpdCtrlDq;
        u32 EmcFdpdCtrlCmd;
        u32 EmcPmacroIbVrefDq_0;
        u32 EmcPmacroIbVrefDq_1;
        u32 EmcPmacroIbVrefDqs_0;
        u32 EmcPmacroIbVrefDqs_1;
        u32 EmcPmacroIbRxrt;
        u32 EmcCfgPipe1;
        u32 EmcCfgPipe2;
        u32 EmcPmacroQuseDdllRank0_0;
        u32 EmcPmacroQuseDdllRank0_1;
        u32 EmcPmacroQuseDdllRank0_2;
        u32 EmcPmacroQuseDdllRank0_3;
        u32 EmcPmacroQuseDdllRank0_4;
        u32 EmcPmacroQuseDdllRank0_5;
        u32 EmcPmacroQuseDdllRank1_0;
        u32 EmcPmacroQuseDdllRank1_1;
        u32 EmcPmacroQuseDdllRank1_2;
        u32 EmcPmacroQuseDdllRank1_3;
        u32 EmcPmacroQuseDdllRank1_4;
        u32 EmcPmacroQuseDdllRank1_5;
        u32 EmcPmacroObDdllLongDqRank0_0;
        u32 EmcPmacroObDdllLongDqRank0_1;
        u32 EmcPmacroObDdllLongDqRank0_2;
        u32 EmcPmacroObDdllLongDqRank0_3;
        u32 EmcPmacroObDdllLongDqRank0_4;
        u32 EmcPmacroObDdllLongDqRank0_5;
        u32 EmcPmacroObDdllLongDqRank1_0;
        u32 EmcPmacroObDdllLongDqRank1_1;
        u32 EmcPmacroObDdllLongDqRank1_2;
        u32 EmcPmacroObDdllLongDqRank1_3;
        u32 EmcPmacroObDdllLongDqRank1_4;
        u32 EmcPmacroObDdllLongDqRank1_5;
        u32 EmcPmacroObDdllLongDqsRank0_0;
        u32 EmcPmacroObDdllLongDqsRank0_1;
        u32 EmcPmacroObDdllLongDqsRank0_2;
        u32 EmcPmacroObDdllLongDqsRank0_3;
        u32 EmcPmacroObDdllLongDqsRank0_4;
        u32 EmcPmacroObDdllLongDqsRank0_5;
        u32 EmcPmacroObDdllLongDqsRank1_0;
        u32 EmcPmacroObDdllLongDqsRank1_1;
        u32 EmcPmacroObDdllLongDqsRank1_2;
        u32 EmcPmacroObDdllLongDqsRank1_3;
        u32 EmcPmacroObDdllLongDqsRank1_4;
        u32 EmcPmacroObDdllLongDqsRank1_5;
        u32 EmcPmacroIbDdllLongDqsRank0_0;
        u32 EmcPmacroIbDdllLongDqsRank0_1;
        u32 EmcPmacroIbDdllLongDqsRank0_2;
        u32 EmcPmacroIbDdllLongDqsRank0_3;
        u32 EmcPmacroIbDdllLongDqsRank1_0;
        u32 EmcPmacroIbDdllLongDqsRank1_1;
        u32 EmcPmacroIbDdllLongDqsRank1_2;
        u32 EmcPmacroIbDdllLongDqsRank1_3;
        u32 EmcPmacroDdllLongCmd_0;
        u32 EmcPmacroDdllLongCmd_1;
        u32 EmcPmacroDdllLongCmd_2;
        u32 EmcPmacroDdllLongCmd_3;
        u32 EmcPmacroDdllLongCmd_4;
        u32 EmcPmacroDdllShortCmd_0;
        u32 EmcPmacroDdllShortCmd_1;
        u32 EmcPmacroDdllShortCmd_2;
        u32 WarmBootWait;
        u32 EmcOdtWrite;
        u32 EmcZcalInterval;
        u32 EmcZcalWaitCnt;
        u32 EmcZcalMrwCmd;
        u32 EmcMrsResetDll;
        u32 EmcZcalInitDev0;
        u32 EmcZcalInitDev1;
        u32 EmcZcalInitWait;
        u32 EmcZcalWarmColdBootEnables;
        u32 EmcMrwLpddr2ZcalWarmBoot;
        u32 EmcZqCalDdr3WarmBoot;
        u32 EmcZqCalLpDdr4WarmBoot;
        u32 EmcZcalWarmBootWait;
        u32 EmcMrsWarmBootEnable;
        u32 EmcMrsResetDllWait;
        u32 EmcMrsExtra;
        u32 EmcWarmBootMrsExtra;
        u32 EmcEmrsDdr2DllEnable;
        u32 EmcMrsDdr2DllReset;
        u32 EmcEmrsDdr2OcdCalib;
        u32 EmcDdr2Wait;
        u32 EmcClkenOverride;
        u32 EmcExtraRefreshNum;
        u32 EmcClkenOverrideAllWarmBoot;
        u32 McClkenOverrideAllWarmBoot;
        u32 EmcCfgDigDllPeriodWarmBoot;
        u32 PmcVddpSel;
        u32 PmcVddpSelWait;
        u32 PmcDdrPwr;
        u32 PmcDdrCfg;
        u32 PmcIoDpd3Req;
        u32 PmcIoDpd3ReqWait;
        u32 PmcIoDpd4ReqWait;
        u32 PmcRegShort;
        u32 PmcNoIoPower;
        u32 PmcDdrCntrlWait;
        u32 PmcDdrCntrl;
        u32 EmcAcpdControl;
        u32 EmcSwizzleRank0Byte0;
        u32 EmcSwizzleRank0Byte1;
        u32 EmcSwizzleRank0Byte2;
        u32 EmcSwizzleRank0Byte3;
        u32 EmcSwizzleRank1Byte0;
        u32 EmcSwizzleRank1Byte1;
        u32 EmcSwizzleRank1Byte2;
        u32 EmcSwizzleRank1Byte3;
        u32 EmcTxdsrvttgen;
        u32 EmcDataBrlshft0;
        u32 EmcDataBrlshft1;
        u32 EmcDqsBrlshft0;
        u32 EmcDqsBrlshft1;
        u32 EmcCmdBrlshft0;
        u32 EmcCmdBrlshft1;
        u32 EmcCmdBrlshft2;
        u32 EmcCmdBrlshft3;
        u32 EmcQuseBrlshft0;
        u32 EmcQuseBrlshft1;
        u32 EmcQuseBrlshft2;
        u32 EmcQuseBrlshft3;
        u32 EmcDllCfg0;
        u32 EmcDllCfg1;
        u32 EmcPmcScratch1;
        u32 EmcPmcScratch2;
        u32 EmcPmcScratch3;
        u32 EmcPmacroPadCfgCtrl;
        u32 EmcPmacroVttgenCtrl0;
        u32 EmcPmacroVttgenCtrl1;
        u32 EmcPmacroVttgenCtrl2;
        u32 EmcPmacroBrickCtrlRfu1;
        u32 EmcPmacroCmdBrickCtrlFdpd;
        u32 EmcPmacroBrickCtrlRfu2;
        u32 EmcPmacroDataBrickCtrlFdpd;
        u32 EmcPmacroBgBiasCtrl0;
        u32 EmcPmacroDataPadRxCtrl;
        u32 EmcPmacroCmdPadRxCtrl;
        u32 EmcPmacroDataRxTermMode;
        u32 EmcPmacroCmdRxTermMode;
        u32 EmcPmacroDataPadTxCtrl;
        u32 EmcPmacroCommonPadTxCtrl;
        u32 EmcPmacroCmdPadTxCtrl;
        u32 EmcCfg3;
        u32 EmcPmacroTxPwrd0;
        u32 EmcPmacroTxPwrd1;
        u32 EmcPmacroTxPwrd2;
        u32 EmcPmacroTxPwrd3;
        u32 EmcPmacroTxPwrd4;
        u32 EmcPmacroTxPwrd5;
        u32 EmcConfigSampleDelay;
        u32 EmcPmacroBrickMapping0;
        u32 EmcPmacroBrickMapping1;
        u32 EmcPmacroBrickMapping2;
        u32 EmcPmacroTxSelClkSrc0;
        u32 EmcPmacroTxSelClkSrc1;
        u32 EmcPmacroTxSelClkSrc2;
        u32 EmcPmacroTxSelClkSrc3;
        u32 EmcPmacroTxSelClkSrc4;
        u32 EmcPmacroTxSelClkSrc5;
        u32 EmcPmacroDdllBypass;
        u32 EmcPmacroDdllPwrd0;
        u32 EmcPmacroDdllPwrd1;
        u32 EmcPmacroDdllPwrd2;
        u32 EmcPmacroCmdCtrl0;
        u32 EmcPmacroCmdCtrl1;
        u32 EmcPmacroCmdCtrl2;
        u32 McEmemAdrCfg;
        u32 McEmemAdrCfgDev0;
        u32 McEmemAdrCfgDev1;
        u32 McEmemAdrCfgChannelMask;
        u32 McEmemAdrCfgBankMask0;
        u32 McEmemAdrCfgBankMask1;
        u32 McEmemAdrCfgBankMask2;
        u32 McEmemCfg;
        u32 McEmemArbCfg;
        u32 McEmemArbOutstandingReq;
        u32 McEmemArbRefpbHpCtrl;
        u32 McEmemArbRefpbBankCtrl;
        u32 McEmemArbTimingRcd;
        u32 McEmemArbTimingRp;
        u32 McEmemArbTimingRc;
        u32 McEmemArbTimingRas;
        u32 McEmemArbTimingFaw;
        u32 McEmemArbTimingRrd;
        u32 McEmemArbTimingRap2Pre;
        u32 McEmemArbTimingWap2Pre;
        u32 McEmemArbTimingR2R;
        u32 McEmemArbTimingW2W;
        u32 McEmemArbTimingR2W;
        u32 McEmemArbTimingW2R;
        u32 McEmemArbTimingRFCPB;
        u32 McEmemArbDaTurns;
        u32 McEmemArbDaCovers;
        u32 McEmemArbMisc0;
        u32 McEmemArbMisc1;
        u32 McEmemArbMisc2;
        u32 McEmemArbRing1Throttle;
        u32 McEmemArbOverride;
        u32 McEmemArbOverride1;
        u32 McEmemArbRsv;
        u32 McDaCfg0;
        u32 McEmemArbTimingCcdmw;
        u32 McClkenOverride;
        u32 McStatControl;
        u32 McVideoProtectBom;
        u32 McVideoProtectBomAdrHi;
        u32 McVideoProtectSizeMb;
        u32 McVideoProtectVprOverride;
        u32 McVideoProtectVprOverride1;
        u32 McVideoProtectGpuOverride0;
        u32 McVideoProtectGpuOverride1;
        u32 McSecCarveoutBom;
        u32 McSecCarveoutAdrHi;
        u32 McSecCarveoutSizeMb;
        u32 McVideoProtectWriteAccess;
        u32 McSecCarveoutProtectWriteAccess;
        u32 McGeneralizedCarveout1Bom;
        u32 McGeneralizedCarveout1BomHi;
        u32 McGeneralizedCarveout1Size128kb;
        u32 McGeneralizedCarveout1Access0;
        u32 McGeneralizedCarveout1Access1;
        u32 McGeneralizedCarveout1Access2;
        u32 McGeneralizedCarveout1Access3;
        u32 McGeneralizedCarveout1Access4;
        u32 McGeneralizedCarveout1ForceInternalAccess0;
        u32 McGeneralizedCarveout1ForceInternalAccess1;
        u32 McGeneralizedCarveout1ForceInternalAccess2;
        u32 McGeneralizedCarveout1ForceInternalAccess3;
        u32 McGeneralizedCarveout1ForceInternalAccess4;
        u32 McGeneralizedCarveout1Cfg0;
        u32 McGeneralizedCarveout2Bom;
        u32 McGeneralizedCarveout2BomHi;
        u32 McGeneralizedCarveout2Size128kb;
        u32 McGeneralizedCarveout2Access0;
        u32 McGeneralizedCarveout2Access1;
        u32 McGeneralizedCarveout2Access2;
        u32 McGeneralizedCarveout2Access3;
        u32 McGeneralizedCarveout2Access4;
        u32 McGeneralizedCarveout2ForceInternalAccess0;
        u32 McGeneralizedCarveout2ForceInternalAccess1;
        u32 McGeneralizedCarveout2ForceInternalAccess2;
        u32 McGeneralizedCarveout2ForceInternalAccess3;
        u32 McGeneralizedCarveout2ForceInternalAccess4;
        u32 McGeneralizedCarveout2Cfg0;
        u32 McGeneralizedCarveout3Bom;
        u32 McGeneralizedCarveout3BomHi;
        u32 McGeneralizedCarveout3Size128kb;
        u32 McGeneralizedCarveout3Access0;
        u32 McGeneralizedCarveout3Access1;
        u32 McGeneralizedCarveout3Access2;
        u32 McGeneralizedCarveout3Access3;
        u32 McGeneralizedCarveout3Access4;
        u32 McGeneralizedCarveout3ForceInternalAccess0;
        u32 McGeneralizedCarveout3ForceInternalAccess1;
        u32 McGeneralizedCarveout3ForceInternalAccess2;
        u32 McGeneralizedCarveout3ForceInternalAccess3;
        u32 McGeneralizedCarveout3ForceInternalAccess4;
        u32 McGeneralizedCarveout3Cfg0;
        u32 McGeneralizedCarveout4Bom;
        u32 McGeneralizedCarveout4BomHi;
        u32 McGeneralizedCarveout4Size128kb;
        u32 McGeneralizedCarveout4Access0;
        u32 McGeneralizedCarveout4Access1;
        u32 McGeneralizedCarveout4Access2;
        u32 McGeneralizedCarveout4Access3;
        u32 McGeneralizedCarveout4Access4;
        u32 McGeneralizedCarveout4ForceInternalAccess0;
        u32 McGeneralizedCarveout4ForceInternalAccess1;
        u32 McGeneralizedCarveout4ForceInternalAccess2;
        u32 McGeneralizedCarveout4ForceInternalAccess3;
        u32 McGeneralizedCarveout4ForceInternalAccess4;
        u32 McGeneralizedCarveout4Cfg0;
        u32 McGeneralizedCarveout5Bom;
        u32 McGeneralizedCarveout5BomHi;
        u32 McGeneralizedCarveout5Size128kb;
        u32 McGeneralizedCarveout5Access0;
        u32 McGeneralizedCarveout5Access1;
        u32 McGeneralizedCarveout5Access2;
        u32 McGeneralizedCarveout5Access3;
        u32 McGeneralizedCarveout5Access4;
        u32 McGeneralizedCarveout5ForceInternalAccess0;
        u32 McGeneralizedCarveout5ForceInternalAccess1;
        u32 McGeneralizedCarveout5ForceInternalAccess2;
        u32 McGeneralizedCarveout5ForceInternalAccess3;
        u32 McGeneralizedCarveout5ForceInternalAccess4;
        u32 McGeneralizedCarveout5Cfg0;
        u32 EmcCaTrainingEnable;
        u32 SwizzleRankByteEncode;
        u32 BootRomPatchControl;
        u32 BootRomPatchData;
        u32 McMtsCarveoutBom;
        u32 McMtsCarveoutAdrHi;
        u32 McMtsCarveoutSizeMb;
        u32 McMtsCarveoutRegCtrl;
    };
    static_assert(sizeof(BootSdramParams) == 0x768);

}
