/*
 * Copyright (c) Atmosphère-NX
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#pragma once
#include <vapours.hpp>
#include <stratosphere/sf.hpp>
#include <stratosphere/erpt/erpt_types.hpp>
#include <stratosphere/erpt/erpt_multiple_category_context.hpp>
#include <stratosphere/time/time_steady_clock_time_point.hpp>

#define AMS_ERPT_I_CONTEXT_INTERFACE_INFO(C, H)                                                                                                                                                                                                                                                                                                                                                                            \
    AMS_SF_METHOD_INFO(C, H,  0, Result, SubmitContext,                             (const ams::sf::InBuffer &ctx_buffer, const ams::sf::InBuffer &str_buffer),                                                                                                                                     (ctx_buffer, str_buffer))                                                                                              \
    AMS_SF_METHOD_INFO(C, H,  1, Result, CreateReportV0,                            (erpt::ReportType report_type, const ams::sf::InBuffer &ctx_buffer, const ams::sf::InBuffer &str_buffer, const ams::sf::InBuffer &meta_buffer),                                                                 (report_type, ctx_buffer, str_buffer, meta_buffer))                                                                    \
    AMS_SF_METHOD_INFO(C, H,  2, Result, SetInitialLaunchSettingsCompletionTime,    (const time::SteadyClockTimePoint &time_point),                                                                                                                                                                 (time_point),                                                                hos::Version_3_0_0)                       \
    AMS_SF_METHOD_INFO(C, H,  3, Result, ClearInitialLaunchSettingsCompletionTime,  (),                                                                                                                                                                                                             (),                                                                          hos::Version_3_0_0)                       \
    AMS_SF_METHOD_INFO(C, H,  4, Result, UpdatePowerOnTime,                         (),                                                                                                                                                                                                             (),                                                                          hos::Version_3_0_0)                       \
    AMS_SF_METHOD_INFO(C, H,  5, Result, UpdateAwakeTime,                           (),                                                                                                                                                                                                             (),                                                                          hos::Version_3_0_0,  hos::Version_12_0_0) \
    AMS_SF_METHOD_INFO(C, H,  6, Result, SubmitMultipleCategoryContext,             (const erpt::MultipleCategoryContextEntry &ctx_entry, const ams::sf::InBuffer &str_buffer),                                                                                                                     (ctx_entry, str_buffer),                                                     hos::Version_5_0_0,  hos::Version_12_0_0) \
    AMS_SF_METHOD_INFO(C, H,  7, Result, UpdateApplicationLaunchTime,               (),                                                                                                                                                                                                             (),                                                                          hos::Version_6_0_0)                       \
    AMS_SF_METHOD_INFO(C, H,  8, Result, ClearApplicationLaunchTime,                (),                                                                                                                                                                                                             (),                                                                          hos::Version_6_0_0)                       \
    AMS_SF_METHOD_INFO(C, H,  9, Result, SubmitAttachment,                          (ams::sf::Out<erpt::AttachmentId> out, const ams::sf::InBuffer &attachment_name, const ams::sf::InBuffer &attachment_data),                                                                                     (out, attachment_name, attachment_data),                                     hos::Version_8_0_0)                       \
    AMS_SF_METHOD_INFO(C, H, 10, Result, CreateReportWithAttachmentsDeprecated,     (erpt::ReportType report_type, const ams::sf::InBuffer &ctx_buffer, const ams::sf::InBuffer &str_buffer, const ams::sf::InBuffer &attachment_ids_buffer),                                                       (report_type, ctx_buffer, str_buffer, attachment_ids_buffer),                hos::Version_8_0_0,  hos::Version_10_2_0) \
    AMS_SF_METHOD_INFO(C, H, 10, Result, CreateReportWithAttachmentsDeprecated2,    (erpt::ReportType report_type, const ams::sf::InBuffer &ctx_buffer, const ams::sf::InBuffer &str_buffer, const ams::sf::InBuffer &attachment_ids_buffer, Result result),                                        (report_type, ctx_buffer, str_buffer, attachment_ids_buffer, result),        hos::Version_11_0_0, hos::Version_16_1_0) \
    AMS_SF_METHOD_INFO(C, H, 10, Result, CreateReportWithAttachments,               (erpt::ReportType report_type, const ams::sf::InBuffer &ctx_buffer, const ams::sf::InBuffer &str_buffer, const ams::sf::InBuffer &attachment_ids_buffer, Result result, erpt::CreateReportOptionFlagSet flags), (report_type, ctx_buffer, str_buffer, attachment_ids_buffer, result, flags), hos::Version_17_0_0)                      \
    AMS_SF_METHOD_INFO(C, H, 11, Result, CreateReportV1,                            (erpt::ReportType report_type, const ams::sf::InBuffer &ctx_buffer, const ams::sf::InBuffer &str_buffer, const ams::sf::InBuffer &meta_buffer, Result result),                                                  (report_type, ctx_buffer, str_buffer, meta_buffer, result),                  hos::Version_11_0_0)                      \
    AMS_SF_METHOD_INFO(C, H, 12, Result, CreateReport,                              (erpt::ReportType report_type, const ams::sf::InBuffer &ctx_buffer, const ams::sf::InBuffer &str_buffer, const ams::sf::InBuffer &meta_buffer, Result result, erpt::CreateReportOptionFlagSet flags),           (report_type, ctx_buffer, str_buffer, meta_buffer, result, flags),           hos::Version_17_0_0)                      \
    AMS_SF_METHOD_INFO(C, H, 20, Result, RegisterRunningApplet,                     (ncm::ProgramId program_id),                                                                                                                                                                                    (program_id),                                                                hos::Version_12_0_0)                      \
    AMS_SF_METHOD_INFO(C, H, 21, Result, UnregisterRunningApplet,                   (ncm::ProgramId program_id),                                                                                                                                                                                    (program_id),                                                                hos::Version_12_0_0)                      \
    AMS_SF_METHOD_INFO(C, H, 22, Result, UpdateAppletSuspendedDuration,             (ncm::ProgramId program_id, TimeSpanType duration),                                                                                                                                                             (program_id, duration),                                                      hos::Version_12_0_0)                      \
    AMS_SF_METHOD_INFO(C, H, 30, Result, InvalidateForcedShutdownDetection,         (),                                                                                                                                                                                                             (),                                                                          hos::Version_12_0_0)


AMS_SF_DEFINE_INTERFACE(ams::erpt::sf, IContext, AMS_ERPT_I_CONTEXT_INTERFACE_INFO, 0xDD41DD03)
