/*
 * Copyright (c) Atmosphère-NX
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#pragma once
#include <vapours.hpp>
#include <stratosphere/sf.hpp>
#include <stratosphere/fssrv/sf/fssrv_sf_ifilesystem.hpp>
#include <stratosphere/fssrv/sf/fssrv_sf_istorage.hpp>
#include <stratosphere/fssrv/sf/fssrv_sf_i_device_operator.hpp>
#include <stratosphere/fssrv/sf/fssrv_sf_i_event_notifier.hpp>
#include <stratosphere/fs/fs_error_info.hpp>
#include <stratosphere/fs/fs_memory_report_info.hpp>

/* ACCURATE_TO_VERSION: 13.4.0.0 */
#define AMS_FSSRV_I_FILE_SYSTEM_PROXY_INTERFACE_INFO(C, H) \
    AMS_SF_METHOD_INFO(C, H,    0, Result, OpenFileSystem,                                              (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IFileSystem>> out, const fssrv::sf::FspPath &path, u32 type),                                             (out, path, type),                                      hos::Version_Min,    hos::Version_1_0_0)    \
    AMS_SF_METHOD_INFO(C, H,    1, Result, SetCurrentProcess,                                           (const ams::sf::ClientProcessId &client_pid),                                                                                                             (client_pid))                                                                                       \
    AMS_SF_METHOD_INFO(C, H,    2, Result, OpenDataFileSystemByCurrentProcess,                          (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IFileSystem>> out),                                                                                       (out))                                                                                              \
    AMS_SF_METHOD_INFO(C, H,    7, Result, OpenFileSystemWithPatch,                                     (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IFileSystem>> out, ncm::ProgramId program_id, u32 type),                                                  (out, program_id, type),                                hos::Version_2_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,    8, Result, OpenFileSystemWithIdObsolete,                                (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IFileSystem>> out, const fssrv::sf::FspPath &path, u64 program_id, u32 type),                             (out, path, program_id, type),                          hos::Version_2_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,    9, Result, OpenDataFileSystemByProgramId,                               (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IFileSystem>> out, ncm::ProgramId program_id),                                                            (out, program_id),                                      hos::Version_3_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,    8, Result, OpenFileSystemWithId,                                        (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IFileSystem>> out, const fssrv::sf::FspPath &path, fs::ContentAttributes attr, u64 program_id, u32 type), (out, path, attr, program_id, type),                    hos::Version_16_0_0)                        \
    AMS_SF_METHOD_INFO(C, H,   11, Result, OpenBisFileSystem,                                           (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IFileSystem>> out, const fssrv::sf::FspPath &path, u32 id),                                               (out, path, id))                                                                                    \
    AMS_SF_METHOD_INFO(C, H,   12, Result, OpenBisStorage,                                              (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IStorage>> out, u32 id),                                                                                  (out, id))                                                                                          \
    AMS_SF_METHOD_INFO(C, H,   13, Result, InvalidateBisCache,                                          (),                                                                                                                                                       ())                                                                                                 \
    AMS_SF_METHOD_INFO(C, H,   17, Result, OpenHostFileSystem,                                          (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IFileSystem>> out, const fssrv::sf::FspPath &path),                                                       (out, path))                                                                                        \
    AMS_SF_METHOD_INFO(C, H,   18, Result, OpenSdCardFileSystem,                                        (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IFileSystem>> out),                                                                                       (out))                                                                                              \
    AMS_SF_METHOD_INFO(C, H,   19, Result, FormatSdCardFileSystem,                                      (),                                                                                                                                                       (),                                                     hos::Version_2_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,   21, Result, DeleteSaveDataFileSystem,                                    (u64 save_data_id),                                                                                                                                       (save_data_id))                                                                                     \
    AMS_SF_METHOD_INFO(C, H,   22, Result, CreateSaveDataFileSystem,                                    (const fs::SaveDataAttribute &attribute, const fs::SaveDataCreationInfo &creation_info, const fs::SaveDataMetaInfo &meta_info),                           (attribute, creation_info, meta_info))                                                              \
    AMS_SF_METHOD_INFO(C, H,   23, Result, CreateSaveDataFileSystemBySystemSaveDataId,                  (const fs::SaveDataAttribute &attribute, const fs::SaveDataCreationInfo &creation_info),                                                                  (attribute, creation_info))                                                                         \
    AMS_SF_METHOD_INFO(C, H,   24, Result, RegisterSaveDataFileSystemAtomicDeletion,                    (const ams::sf::InBuffer &save_data_ids),                                                                                                                 (save_data_ids))                                                                                    \
    AMS_SF_METHOD_INFO(C, H,   25, Result, DeleteSaveDataFileSystemBySaveDataSpaceId,                   (u8 indexer_space_id, u64 save_data_id),                                                                                                                  (indexer_space_id, save_data_id),                       hos::Version_2_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,   26, Result, FormatSdCardDryRun,                                          (),                                                                                                                                                       (),                                                     hos::Version_2_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,   27, Result, IsExFatSupported,                                            (ams::sf::Out<bool> out),                                                                                                                                 (out),                                                  hos::Version_2_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,   28, Result, DeleteSaveDataFileSystemBySaveDataAttribute,                 (u8 space_id, const fs::SaveDataAttribute &attribute),                                                                                                    (space_id, attribute),                                  hos::Version_4_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,   30, Result, OpenGameCardStorage,                                         (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IStorage>> out, u32 handle, u32 partition),                                                               (out, handle, partition))                                                                           \
    AMS_SF_METHOD_INFO(C, H,   31, Result, OpenGameCardFileSystem,                                      (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IFileSystem>> out, u32 handle, u32 partition),                                                            (out, handle, partition))                                                                           \
    AMS_SF_METHOD_INFO(C, H,   32, Result, ExtendSaveDataFileSystem,                                    (u8 space_id, u64 save_data_id, s64 available_size, s64 journal_size),                                                                                    (space_id, save_data_id, available_size, journal_size), hos::Version_3_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,   33, Result, DeleteCacheStorage,                                          (u16 index),                                                                                                                                              (index),                                                hos::Version_5_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,   34, Result, GetCacheStorageSize,                                         (ams::sf::Out<s64> out_size, ams::sf::Out<s64> out_journal_size, u16 index),                                                                              (out_size, out_journal_size, index),                    hos::Version_5_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,   35, Result, CreateSaveDataFileSystemWithHashSalt,                        (const fs::SaveDataAttribute &attribute, const fs::SaveDataCreationInfo &creation_info, const fs::SaveDataMetaInfo &meta_info, const fs::HashSalt &salt), (attribute, creation_info, meta_info, salt),            hos::Version_6_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,   36, Result, OpenHostFileSystemWithOption,                                (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IFileSystem>> out, const fssrv::sf::FspPath &path, u32 option),                                           (out, path, option),                                    hos::Version_9_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,   51, Result, OpenSaveDataFileSystem,                                      (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IFileSystem>> out, u8 space_id, const fs::SaveDataAttribute &attribute),                                  (out, space_id, attribute))                                                                         \
    AMS_SF_METHOD_INFO(C, H,   52, Result, OpenSaveDataFileSystemBySystemSaveDataId,                    (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IFileSystem>> out, u8 space_id, const fs::SaveDataAttribute &attribute),                                  (out, space_id, attribute))                                                                         \
    AMS_SF_METHOD_INFO(C, H,   53, Result, OpenReadOnlySaveDataFileSystem,                              (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IFileSystem>> out, u8 space_id, const fs::SaveDataAttribute &attribute),                                  (out, space_id, attribute),                             hos::Version_2_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,   57, Result, ReadSaveDataFileSystemExtraDataBySaveDataSpaceId,            (const ams::sf::OutBuffer &buffer, u8 space_id, u64 save_data_id),                                                                                        (buffer, space_id, save_data_id),                       hos::Version_3_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,   58, Result, ReadSaveDataFileSystemExtraData,                             (const ams::sf::OutBuffer &buffer, u64 save_data_id),                                                                                                     (buffer, save_data_id))                                                                             \
    AMS_SF_METHOD_INFO(C, H,   59, Result, WriteSaveDataFileSystemExtraData,                            (u64 save_data_id, u8 space_id, const ams::sf::InBuffer &buffer),                                                                                         (save_data_id, space_id, buffer),                       hos::Version_2_0_0)                         \
 /* AMS_SF_METHOD_INFO(C, H,   60, Result, OpenSaveDataInfoReader,                                      (),                                                                                                                                                       ())                                                                                              */ \
 /* AMS_SF_METHOD_INFO(C, H,   61, Result, OpenSaveDataInfoReaderBySaveDataSpaceId,                     (),                                                                                                                                                       ())                                                                                              */ \
 /* AMS_SF_METHOD_INFO(C, H,   62, Result, OpenSaveDataInfoReaderOnlyCacheStorage,                      (),                                                                                                                                                       (),                                                     hos::Version_5_0_0)                      */ \
 /* AMS_SF_METHOD_INFO(C, H,   64, Result, OpenSaveDataInternalStorageFileSystem,                       (),                                                                                                                                                       (),                                                     hos::Version_5_0_0)                      */ \
 /* AMS_SF_METHOD_INFO(C, H,   65, Result, UpdateSaveDataMacForDebug,                                   (),                                                                                                                                                       (),                                                     hos::Version_5_0_0)                      */ \
 /* AMS_SF_METHOD_INFO(C, H,   66, Result, WriteSaveDataFileSystemExtraDataWithMask,                    (),                                                                                                                                                       (),                                                     hos::Version_5_0_0)                      */ \
 /* AMS_SF_METHOD_INFO(C, H,   67, Result, FindSaveDataWithFilter,                                      (),                                                                                                                                                       (),                                                     hos::Version_6_0_0)                      */ \
 /* AMS_SF_METHOD_INFO(C, H,   68, Result, OpenSaveDataInfoReaderWithFilter,                            (),                                                                                                                                                       (),                                                     hos::Version_6_0_0)                      */ \
 /* AMS_SF_METHOD_INFO(C, H,   69, Result, ReadSaveDataFileSystemExtraDataBySaveDataAttribute,          (),                                                                                                                                                       (),                                                     hos::Version_8_0_0)                      */ \
 /* AMS_SF_METHOD_INFO(C, H,   70, Result, WriteSaveDataFileSystemExtraDataWithMaskBySaveDataAttribute, (),                                                                                                                                                       (),                                                     hos::Version_8_0_0)                      */ \
 /* AMS_SF_METHOD_INFO(C, H,   71, Result, ReadSaveDataFileSystemExtraDataWithMaskBySaveDataAttribute,  (),                                                                                                                                                       (),                                                     hos::Version_10_0_0)                     */ \
 /* AMS_SF_METHOD_INFO(C, H,   80, Result, OpenSaveDataMetaFile,                                        (),                                                                                                                                                       ())                                                                                              */ \
 /* AMS_SF_METHOD_INFO(C, H,   81, Result, OpenSaveDataTransferManager,                                 (),                                                                                                                                                       (),                                                     hos::Version_4_0_0)                      */ \
 /* AMS_SF_METHOD_INFO(C, H,   82, Result, OpenSaveDataTransferManagerVersion2,                         (),                                                                                                                                                       (),                                                     hos::Version_5_0_0)                      */ \
 /* AMS_SF_METHOD_INFO(C, H,   83, Result, OpenSaveDataTransferProhibiter,                              (),                                                                                                                                                       (),                                                     hos::Version_6_0_0)                      */ \
 /* AMS_SF_METHOD_INFO(C, H,   84, Result, ListAccessibleSaveDataOwnerId,                               (),                                                                                                                                                       (),                                                     hos::Version_6_0_0)                      */ \
 /* AMS_SF_METHOD_INFO(C, H,   85, Result, OpenSaveDataTransferManagerForSaveDataRepair,                (),                                                                                                                                                       (),                                                     hos::Version_9_0_0)                      */ \
 /* AMS_SF_METHOD_INFO(C, H,   86, Result, OpenSaveDataMover,                                           (),                                                                                                                                                       (),                                                     hos::Version_10_0_0)                     */ \
 /* AMS_SF_METHOD_INFO(C, H,   87, Result, OpenSaveDataTransferManagerForRepair,                        (),                                                                                                                                                       (),                                                     hos::Version_11_0_0)                     */ \
    AMS_SF_METHOD_INFO(C, H,  100, Result, OpenImageDirectoryFileSystem,                                (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IFileSystem>> out, u32 id),                                                                               (out, id))                                                                                          \
 /* AMS_SF_METHOD_INFO(C, H,  101, Result, OpenBaseFileSystem,                                          (),                                                                                                                                                       (),                                                     hos::Version_11_0_0)                     */ \
 /* AMS_SF_METHOD_INFO(C, H,  102, Result, FormatBaseFileSystem,                                        (),                                                                                                                                                       (),                                                     hos::Version_12_0_0)                     */ \
    AMS_SF_METHOD_INFO(C, H,  110, Result, OpenContentStorageFileSystem,                                (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IFileSystem>> out, u32 id),                                                                               (out, id))                                                                                          \
 /* AMS_SF_METHOD_INFO(C, H,  120, Result, OpenCloudBackupWorkStorageFileSystem,                        (),                                                                                                                                                       (),                                                     hos::Version_6_0_0,  hos::Version_9_2_0) */ \
 /* AMS_SF_METHOD_INFO(C, H,  130, Result, OpenCustomStorageFileSystem,                                 (),                                                                                                                                                       (),                                                     hos::Version_7_0_0)                      */ \
    AMS_SF_METHOD_INFO(C, H,  200, Result, OpenDataStorageByCurrentProcess,                             (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IStorage>> out),                                                                                          (out))                                                                                              \
    AMS_SF_METHOD_INFO(C, H,  201, Result, OpenDataStorageByProgramId,                                  (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IStorage>> out, ncm::ProgramId program_id),                                                               (out, program_id),                                      hos::Version_3_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,  202, Result, OpenDataStorageByDataId,                                     (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IStorage>> out, ncm::DataId data_id, u8 storage_id),                                                      (out, data_id, storage_id))                                                                         \
    AMS_SF_METHOD_INFO(C, H,  203, Result, OpenPatchDataStorageByCurrentProcess,                        (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IStorage>> out),                                                                                          (out))                                                                                              \
    AMS_SF_METHOD_INFO(C, H,  204, Result, OpenDataFileSystemWithProgramIndex,                          (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IFileSystem>> out, u8 index),                                                                             (out, index),                                           hos::Version_7_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,  205, Result, OpenDataStorageWithProgramIndex,                             (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IStorage>> out, u8 index),                                                                                (out, index),                                           hos::Version_7_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,  206, Result, OpenDataStorageByPathObsolete,                               (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IStorage>> out, const fssrv::sf::FspPath &path, u32 type),                                                (out, path, type),                                      hos::Version_13_0_0, hos::Version_15_0_1)   \
    AMS_SF_METHOD_INFO(C, H,  206, Result, OpenDataStorageByPath,                                       (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IStorage>> out, const fssrv::sf::FspPath &path, fs::ContentAttributes attr, u32 type),                    (out, path, attr, type),                                hos::Version_16_0_0)                        \
    AMS_SF_METHOD_INFO(C, H,  400, Result, OpenDeviceOperator,                                          (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IDeviceOperator>> out),                                                                                   (out))                                                                                              \
    AMS_SF_METHOD_INFO(C, H,  500, Result, OpenSdCardDetectionEventNotifier,                            (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IEventNotifier>> out),                                                                                    (out))                                                                                              \
    AMS_SF_METHOD_INFO(C, H,  501, Result, OpenGameCardDetectionEventNotifier,                          (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IEventNotifier>> out),                                                                                    (out))                                                                                              \
    AMS_SF_METHOD_INFO(C, H,  510, Result, OpenSystemDataUpdateEventNotifier,                           (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IEventNotifier>> out),                                                                                    (out),                                                  hos::Version_5_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,  511, Result, NotifySystemDataUpdateEvent,                                 (),                                                                                                                                                       (),                                                     hos::Version_5_0_0)                         \
 /* AMS_SF_METHOD_INFO(C, H,  520, Result, SimulateDeviceDetectionEvent,                                (),                                                                                                                                                       (),                                                     hos::Version_6_0_0) */                      \
    AMS_SF_METHOD_INFO(C, H,  600, Result, SetCurrentPosixTime,                                         (s64 posix_time),                                                                                                                                         (posix_time),                                           hos::Version_Min,    hos::Version_3_0_2)    \
 /* AMS_SF_METHOD_INFO(C, H,  601, Result, QuerySaveDataTotalSize,                                      (),                                                                                                                                                       ()) */                                                                                              \
 /* AMS_SF_METHOD_INFO(C, H,  602, Result, VerifySaveDataFileSystem,                                    (),                                                                                                                                                       ()) */                                                                                              \
 /* AMS_SF_METHOD_INFO(C, H,  603, Result, CorruptSaveDataFileSystem,                                   (),                                                                                                                                                       ()) */                                                                                              \
 /* AMS_SF_METHOD_INFO(C, H,  604, Result, CreatePaddingFile,                                           (),                                                                                                                                                       ()) */                                                                                              \
 /* AMS_SF_METHOD_INFO(C, H,  605, Result, DeleteAllPaddingFiles,                                       (),                                                                                                                                                       ()) */                                                                                              \
    AMS_SF_METHOD_INFO(C, H,  606, Result, GetRightsId,                                                 (ams::sf::Out<fs::RightsId> out, ncm::ProgramId program_id, ncm::StorageId storage_id),                                                                   (out, program_id, storage_id),                          hos::Version_2_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,  607, Result, RegisterExternalKey,                                         (const fs::RightsId &rights_id, const spl::AccessKey &access_key),                                                                                        (rights_id, access_key),                                hos::Version_2_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,  608, Result, UnregisterAllExternalKey,                                    (),                                                                                                                                                       (),                                                     hos::Version_2_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,  609, Result, GetRightsIdByPath,                                           (ams::sf::Out<fs::RightsId> out, const fssrv::sf::FspPath &path),                                                                                         (out, path),                                            hos::Version_2_0_0,  hos::Version_15_0_1)   \
    AMS_SF_METHOD_INFO(C, H,  610, Result, GetRightsIdAndKeyGenerationByPathObsolete,                   (ams::sf::Out<fs::RightsId> out, ams::sf::Out<u8> out_key_generation, const fssrv::sf::FspPath &path),                                                    (out, out_key_generation, path),                        hos::Version_3_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,  610, Result, GetRightsIdAndKeyGenerationByPath,                           (ams::sf::Out<fs::RightsId> out, ams::sf::Out<u8> out_key_generation, const fssrv::sf::FspPath &path, fs::ContentAttributes attr),                        (out, out_key_generation, path, attr),                  hos::Version_16_0_0)                        \
    AMS_SF_METHOD_INFO(C, H,  611, Result, SetCurrentPosixTimeWithTimeDifference,                       (s64 posix_time, s32 time_difference),                                                                                                                    (posix_time, time_difference),                          hos::Version_4_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,  612, Result, GetFreeSpaceSizeForSaveData,                                 (ams::sf::Out<s64> out, u8 space_id),                                                                                                                     (out, space_id),                                        hos::Version_4_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,  613, Result, VerifySaveDataFileSystemBySaveDataSpaceId,                   (),                                                                                                                                                       (),                                                     hos::Version_4_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,  614, Result, CorruptSaveDataFileSystemBySaveDataSpaceId,                  (),                                                                                                                                                       (),                                                     hos::Version_4_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,  615, Result, QuerySaveDataInternalStorageTotalSize,                       (),                                                                                                                                                       (),                                                     hos::Version_5_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,  616, Result, GetSaveDataCommitId,                                         (),                                                                                                                                                       (),                                                     hos::Version_6_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,  617, Result, UnregisterExternalKey,                                       (const fs::RightsId &rights_id),                                                                                                                          (rights_id),                                            hos::Version_7_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,  618, Result, GetProgramId,                                                (ams::sf::Out<ncm::ProgramId> out, const fssrv::sf::FspPath &path, fs::ContentAttributes attr),                                                           (out, path, attr),                                      hos::Version_17_0_0)                        \
    AMS_SF_METHOD_INFO(C, H,  620, Result, SetSdCardEncryptionSeed,                                     (const fs::EncryptionSeed &seed),                                                                                                                         (seed),                                                 hos::Version_2_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,  630, Result, SetSdCardAccessibility,                                      (bool accessible),                                                                                                                                        (accessible),                                           hos::Version_4_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,  631, Result, IsSdCardAccessible,                                          (ams::sf::Out<bool> out),                                                                                                                                 (out),                                                  hos::Version_4_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,  640, Result, IsSignedSystemPartitionOnSdCardValid,                        (ams::sf::Out<bool> out),                                                                                                                                 (out),                                                  hos::Version_4_0_0,  hos::Version_7_0_1)    \
    AMS_SF_METHOD_INFO(C, H,  700, Result, OpenAccessFailureDetectionEventNotifier,                     (),                                                                                                                                                       (),                                                     hos::Version_5_0_0)                         \
 /* AMS_SF_METHOD_INFO(C, H,  701, Result, GetAccessFailureDetectionEvent,                              (),                                                                                                                                                       (),                                                     hos::Version_5_0_0) */                      \
 /* AMS_SF_METHOD_INFO(C, H,  702, Result, IsAccessFailureDetected,                                     (),                                                                                                                                                       (),                                                     hos::Version_5_0_0) */                      \
 /* AMS_SF_METHOD_INFO(C, H,  710, Result, ResolveAccessFailure,                                        (),                                                                                                                                                       (),                                                     hos::Version_5_0_0) */                      \
 /* AMS_SF_METHOD_INFO(C, H,  720, Result, AbandonAccessFailure,                                        (),                                                                                                                                                       (),                                                     hos::Version_5_0_0) */                      \
    AMS_SF_METHOD_INFO(C, H,  800, Result, GetAndClearErrorInfo,                                        (ams::sf::Out<fs::FileSystemProxyErrorInfo> out),                                                                                                         (out),                                                  hos::Version_2_0_0)                         \
    AMS_SF_METHOD_INFO(C, H,  810, Result, RegisterProgramIndexMapInfo,                                 (const ams::sf::InBuffer &buffer, s32 count),                                                                                                             (buffer, count),                                        hos::Version_7_0_0)                         \
    AMS_SF_METHOD_INFO(C, H, 1000, Result, SetBisRootForHost,                                           (u32 id, const fssrv::sf::FspPath &path),                                                                                                                 (id, path),                                             hos::Version_Min,    hos::Version_9_2_0)    \
    AMS_SF_METHOD_INFO(C, H, 1001, Result, SetSaveDataSize,                                             (s64 size, s64 journal_size),                                                                                                                             (size, journal_size))                                                                               \
    AMS_SF_METHOD_INFO(C, H, 1002, Result, SetSaveDataRootPath,                                         (const fssrv::sf::FspPath &path),                                                                                                                         (path))                                                                                             \
    AMS_SF_METHOD_INFO(C, H, 1003, Result, DisableAutoSaveDataCreation,                                 (),                                                                                                                                                       ())                                                                                                 \
    AMS_SF_METHOD_INFO(C, H, 1004, Result, SetGlobalAccessLogMode,                                      (u32 mode),                                                                                                                                               (mode))                                                                                             \
    AMS_SF_METHOD_INFO(C, H, 1005, Result, GetGlobalAccessLogMode,                                      (ams::sf::Out<u32> out),                                                                                                                                  (out))                                                                                              \
    AMS_SF_METHOD_INFO(C, H, 1006, Result, OutputAccessLogToSdCard,                                     (const ams::sf::InBuffer &buf),                                                                                                                           (buf))                                                                                              \
    AMS_SF_METHOD_INFO(C, H, 1007, Result, RegisterUpdatePartition,                                     (),                                                                                                                                                       (),                                                     hos::Version_4_0_0)                         \
    AMS_SF_METHOD_INFO(C, H, 1008, Result, OpenRegisteredUpdatePartition,                               (ams::sf::Out<ams::sf::SharedPointer<fssrv::sf::IFileSystem>> out),                                                                                       (out),                                                  hos::Version_4_0_0)                         \
    AMS_SF_METHOD_INFO(C, H, 1009, Result, GetAndClearMemoryReportInfo,                                 (ams::sf::Out<fs::MemoryReportInfo> out),                                                                                                                 (out),                                                  hos::Version_4_0_0)                         \
 /* AMS_SF_METHOD_INFO(C, H, 1010, Result, SetDataStorageRedirectTarget,                                (),                                                                                                                                                       (),                                                     hos::Version_5_1_0, hos::Version_6_2_0) */  \
    AMS_SF_METHOD_INFO(C, H, 1011, Result, GetProgramIndexForAccessLog,                                 (ams::sf::Out<u32> out_idx, ams::sf::Out<u32> out_count),                                                                                                 (out_idx, out_count),                                   hos::Version_7_0_0)                         \
    AMS_SF_METHOD_INFO(C, H, 1012, Result, GetFsStackUsage,                                             (ams::sf::Out<u32> out, u32 type),                                                                                                                        (out, type),                                            hos::Version_9_0_0)                         \
    AMS_SF_METHOD_INFO(C, H, 1013, Result, UnsetSaveDataRootPath,                                       (),                                                                                                                                                       (),                                                     hos::Version_9_0_0)                         \
    AMS_SF_METHOD_INFO(C, H, 1014, Result, OutputMultiProgramTagAccessLog,                              (),                                                                                                                                                       (),                                                     hos::Version_10_0_0, hos::Version_10_2_0)   \
    AMS_SF_METHOD_INFO(C, H, 1016, Result, FlushAccessLogOnSdCard,                                      (),                                                                                                                                                       (),                                                     hos::Version_11_0_0)                        \
    AMS_SF_METHOD_INFO(C, H, 1017, Result, OutputApplicationInfoAccessLog,                              (),                                                                                                                                                       (),                                                     hos::Version_11_0_0)                        \
    AMS_SF_METHOD_INFO(C, H, 1018, Result, RegisterDebugConfiguration,                                  (u32 key, s64 value),                                                                                                                                     (key, value),                                           hos::Version_13_0_0)                        \
    AMS_SF_METHOD_INFO(C, H, 1019, Result, UnregisterDebugConfiguration,                                (u32 key),                                                                                                                                                (key),                                                  hos::Version_13_0_0)                        \
    AMS_SF_METHOD_INFO(C, H, 1100, Result, OverrideSaveDataTransferTokenSignVerificationKey,            (const ams::sf::InBuffer &buf),                                                                                                                           (buf),                                                  hos::Version_4_0_0)                         \
    AMS_SF_METHOD_INFO(C, H, 1110, Result, CorruptSaveDataFileSystemByOffset,                           (u8 space_id, u64 save_data_id, s64 offset),                                                                                                              (space_id, save_data_id, offset),                       hos::Version_6_0_0)                         \
 /* AMS_SF_METHOD_INFO(C, H, 1200, Result, OpenMultiCommitManager,                                      (),                                                                                                                                                       (),                                                     hos::Version_6_0_0) */                      \
 /* AMS_SF_METHOD_INFO(C, H, 1300, Result, OpenBisWiper,                                                (),                                                                                                                                                       (),                                                     hos::Version_10_0_0) */

AMS_SF_DEFINE_INTERFACE(ams::fssrv::sf, IFileSystemProxy, AMS_FSSRV_I_FILE_SYSTEM_PROXY_INTERFACE_INFO, 0x7DF34ED2)
