/*
 * Copyright (c) Atmosphère-NX
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#pragma once

namespace ams::ncm {

    enum class InstallProgressState : u8 {
        NotPrepared     = 0,
        DataPrepared    = 1,
        Prepared        = 2,
        Downloaded      = 3,
        Committed       = 4,
        Fatal           = 5,
    };

    struct InstallProgress {
        InstallProgressState state;
        u8 pad[3];
        util::TypedStorage<Result> last_result;
        s64 installed_size;
        s64 total_size;

        Result GetLastResult() const {
            return util::GetReference(last_result);
        }

        void SetLastResult(Result result) {
            *util::GetPointer(last_result) = result;
        }
    };

}
