/*
 * Copyright (c) Atmosphère-NX
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#pragma once
#include <vapours.hpp>
#include <stratosphere/time/time_common.hpp>
#include <stratosphere/time/time_steady_clock_time_point.hpp>

namespace ams::time {

    class StandardSteadyClock {
        public:
            using rep        = s64;
            using period     = std::ratio<1>;
            using duration   = std::chrono::duration<rep, period>;
            using time_point = std::chrono::time_point<StandardSteadyClock>;
            static constexpr bool is_steady = true;
        public:
            static time_point now();
        public:
            static Result GetCurrentTimePoint(SteadyClockTimePoint *out);
    };

    Result GetStandardSteadyClockCurrentTimePoint(SteadyClockTimePoint *out);
    TimeSpan GetStandardSteadyClockInternalOffset();

}
