/*
 * Copyright (c) Atmosphère-NX
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once
#include <vapours.hpp>
#include <stratosphere/htcs/htcs_types.hpp>
#include <stratosphere/tma/tma_i_socket.hpp>

/* NOTE: Minimum firmware version not enforced for any commands. */
#define AMS_TMA_I_SOCKET_INTERFACE_INFO(C, H)                                                                                                                                                                                                                                                                                                                                       \
    AMS_SF_METHOD_INFO(C, H,   0, Result, Close,           (sf::Out<s32> out_err, sf::Out<s32> out_res),                                                                                                                                                            (out_err, out_res))                                                                                             \
    AMS_SF_METHOD_INFO(C, H,   1, Result, Connect,         (sf::Out<s32> out_err, sf::Out<s32> out_res, const htcs::SockAddrHtcs &address),                                                                                                                         (out_err, out_res, address))                                                                                    \
    AMS_SF_METHOD_INFO(C, H,   2, Result, Bind,            (sf::Out<s32> out_err, sf::Out<s32> out_res, const htcs::SockAddrHtcs &address),                                                                                                                         (out_err, out_res, address))                                                                                    \
    AMS_SF_METHOD_INFO(C, H,   3, Result, Listen,          (sf::Out<s32> out_err, sf::Out<s32> out_res, s32 backlog_count),                                                                                                                                         (out_err, out_res, backlog_count))                                                                              \
    AMS_SF_METHOD_INFO(C, H,   4, Result, Accept,          (sf::Out<s32> out_err, sf::Out<sf::SharedPointer<tma::ISocket>> out, sf::Out<htcs::SockAddrHtcs> out_address),                                                                                           (out_err, out, out_address))                                                                                    \
    AMS_SF_METHOD_INFO(C, H,   5, Result, Recv,            (sf::Out<s32> out_err, sf::Out<s64> out_size, const sf::OutAutoSelectBuffer &buffer, s32 flags),                                                                                                         (out_err, out_size, buffer, flags))                                                                             \
    AMS_SF_METHOD_INFO(C, H,   6, Result, Send,            (sf::Out<s32> out_err, sf::Out<s64> out_size, const sf::InAutoSelectBuffer &buffer, s32 flags),                                                                                                          (out_err, out_size, buffer, flags))                                                                             \
    AMS_SF_METHOD_INFO(C, H,   7, Result, Shutdown,        (sf::Out<s32> out_err, sf::Out<s32> out_res, s32 how),                                                                                                                                                   (out_err, out_res, how))                                                                                        \
    AMS_SF_METHOD_INFO(C, H,   8, Result, Fcntl,           (sf::Out<s32> out_err, sf::Out<s32> out_res, s32 command, s32 value),                                                                                                                                    (out_err, out_res, command, value))                                                                             \
    AMS_SF_METHOD_INFO(C, H,   9, Result, AcceptStart,     (sf::Out<u32> out_task_id, sf::OutCopyHandle out_event),                                                                                                                                                 (out_task_id, out_event))                                                                                       \
    AMS_SF_METHOD_INFO(C, H,  10, Result, AcceptResults,   (sf::Out<s32> out_err, sf::Out<sf::SharedPointer<tma::ISocket>> out, sf::Out<htcs::SockAddrHtcs> out_address, u32 task_id),                                                                              (out_err, out, out_address, task_id))                                                                           \
    AMS_SF_METHOD_INFO(C, H,  11, Result, RecvStart,       (sf::Out<u32> out_task_id, sf::OutCopyHandle out_event, s32 mem_size, s32 flags),                                                                                                                        (out_task_id, out_event, mem_size, flags))                                                                      \
    AMS_SF_METHOD_INFO(C, H,  12, Result, RecvResults,     (sf::Out<s32> out_err, sf::Out<s64> out_size, const sf::OutAutoSelectBuffer &buffer, u32 task_id),                                                                                                       (out_err, out_size, buffer, task_id))                                                                           \
    AMS_SF_METHOD_INFO(C, H,  13, Result, RecvLargeStart,  (sf::Out<u32> out_task_id, sf::OutCopyHandle out_event, s32 unaligned_size_start, s32 unaligned_size_end, s64 aligned_size, sf::CopyHandle &&mem_handle, s32 flags),                                     (out_task_id, out_event, unaligned_size_start, unaligned_size_end, aligned_size, std::move(mem_handle), flags)) \
    AMS_SF_METHOD_INFO(C, H,  14, Result, SendStartOld,    (sf::Out<u32> out_task_id, sf::OutCopyHandle out_event, const sf::InAutoSelectBuffer &buffer, s32 flags),                                                                                                (out_task_id, out_event, buffer, flags))                                                                        \
    AMS_SF_METHOD_INFO(C, H,  15, Result, SendLargeStart,  (sf::Out<u32> out_task_id, sf::OutCopyHandle out_event, const sf::InAutoSelectBuffer &start_buffer, const sf::InAutoSelectBuffer &end_buffer, sf::CopyHandle &&mem_handle, s64 aligned_size, s32 flags), (out_task_id, out_event, start_buffer, end_buffer, std::move(mem_handle), aligned_size, flags))                 \
    AMS_SF_METHOD_INFO(C, H,  16, Result, SendResults,     (sf::Out<s32> out_err, sf::Out<s64> out_size, u32 task_id),                                                                                                                                              (out_err, out_size, task_id))                                                                                   \
    AMS_SF_METHOD_INFO(C, H,  17, Result, StartSend,       (sf::Out<u32> out_task_id, sf::OutCopyHandle out_event, sf::Out<s64> out_max_size, s64 size, s32 flags),                                                                                                 (out_task_id, out_event, out_max_size, size, flags))                                                            \
    AMS_SF_METHOD_INFO(C, H,  18, Result, ContinueSendOld, (sf::Out<s64> out_size, sf::Out<bool> out_wait, const sf::InAutoSelectBuffer &buffer, u32 task_id),                                                                                                      (out_size, out_wait, buffer, task_id))                                                                          \
    AMS_SF_METHOD_INFO(C, H,  19, Result, EndSend,         (sf::Out<s32> out_err, sf::Out<s64> out_size, u32 task_id),                                                                                                                                              (out_err, out_size, task_id))                                                                                   \
    AMS_SF_METHOD_INFO(C, H,  20, Result, StartRecv,       (sf::Out<u32> out_task_id, sf::OutCopyHandle out_event, s64 size, s32 flags),                                                                                                                            (out_task_id, out_event, size, flags))                                                                          \
    AMS_SF_METHOD_INFO(C, H,  21, Result, EndRecv,         (sf::Out<s32> out_err, sf::Out<s64> out_size, const sf::OutAutoSelectBuffer &buffer, u32 task_id),                                                                                                       (out_err, out_size, buffer, task_id))                                                                           \
    AMS_SF_METHOD_INFO(C, H,  22, Result, SendStart,       (sf::Out<u32> out_task_id, sf::OutCopyHandle out_event, const sf::InNonSecureAutoSelectBuffer &buffer, s32 flags),                                                                                       (out_task_id, out_event, buffer, flags))                                                                        \
    AMS_SF_METHOD_INFO(C, H,  23, Result, ContinueSend,    (sf::Out<s64> out_size, sf::Out<bool> out_wait, const sf::InNonSecureAutoSelectBuffer &buffer, u32 task_id),                                                                                             (out_size, out_wait, buffer, task_id))                                                                          \
    AMS_SF_METHOD_INFO(C, H, 130, Result, GetPrimitive,    (sf::Out<s32> out),                                                                                                                                                                                      (out))

AMS_SF_DEFINE_INTERFACE(ams::tma, ISocket, AMS_TMA_I_SOCKET_INTERFACE_INFO, 0x34CFC7C1)
