/*
 * Copyright (c) Atmosphère-NX
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#pragma once
#include <stratosphere.hpp>
#include "erpt_srv_allocator.hpp"
#include "erpt_srv_cipher.hpp"

namespace ams::erpt::srv {

    class ContextRecord;
    class Report;

    class Context : public Allocator, public util::IntrusiveListBaseNode<Context> {
        private:
            const CategoryId m_category;
            std::unique_ptr<ContextRecord> m_record;
        public:
            Context(CategoryId cat);
            ~Context();

            Result AddCategoryToReport(Report *report);
        public:
            static Result SubmitContext(const ContextEntry *entry, const u8 *data, u32 data_size);
            static Result SubmitContextRecord(std::unique_ptr<ContextRecord> record);
            static Result WriteContextsToReport(Report *report);
            static Result ClearContext(CategoryId cat);
    };

}
