/*
 * Copyright (c) Atmosphère-NX
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include <stratosphere.hpp>
#include "htcfs_client.hpp"

namespace ams::htcfs {

    Result GetWorkingDirectory(char *dst, size_t dst_size) {
        R_RETURN(htcfs::GetClient().GetWorkingDirectory(dst, dst_size));
    }

    Result GetWorkingDirectorySize(s32 *out) {
        R_RETURN(htcfs::GetClient().GetWorkingDirectorySize(out));
    }

}
