/*
 * Copyright (c) Atmosphère-NX
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#pragma once
#include "os_multiple_wait_holder_base.hpp"
#include "os_multiple_wait_impl.hpp"

namespace ams::os::impl {

    class MultiWaitObjectList {
        public:
            using ListType = util::IntrusiveListMemberTraitsByNonConstexprOffsetOf<&MultiWaitHolderBase::m_object_list_node>::ListType;
        private:
            ListType m_object_list;
        public:
            void WakeupAllMultiWaitThreadsUnsafe() {
                for (MultiWaitHolderBase &holder_base : m_object_list) {
                    holder_base.GetMultiWait()->NotifyAndWakeupThread(std::addressof(holder_base));
                }
            }

            void BroadcastToUpdateObjectStateUnsafe() {
                for (MultiWaitHolderBase &holder_base : m_object_list) {
                    holder_base.GetMultiWait()->NotifyAndWakeupThread(nullptr);
                }
            }

            bool IsEmpty() const {
                return m_object_list.empty();
            }

            void PushBackToList(MultiWaitHolderBase &holder_base) {
                m_object_list.push_back(holder_base);
            }

            void EraseFromList(MultiWaitHolderBase &holder_base) {
                m_object_list.erase(m_object_list.iterator_to(holder_base));
            }
    };

}
