/*
 * Copyright (c) Atmosphère-NX
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by charger_parameters.py, do not edit manually. */

constexpr inline const ChargeParametersRule ChargeParametersRulesForBatteryVersion0[] = {
    { BatteryTemperatureLevel::TooLow,   Min, 3320,  Min,  Max, FloatMin,      3.0, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, false, 4208,  512,    0,    0 },
    { BatteryTemperatureLevel::TooLow,  3320,  Max,  Min,  Max,      3.0, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, false, 4208,  768,    0,    0 },
    { BatteryTemperatureLevel::Low,      Min, 3320,  Min,  Max, FloatMin,      3.0, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, true,  4208,  512,    0,    0 },
    { BatteryTemperatureLevel::Low,     3320,  Max,  Min,  Max,      3.0, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, true,  4208,  768,    0,    0 },
    { BatteryTemperatureLevel::Medium,   Min, 3320,  Min,  Max, FloatMin,      3.0, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, true,  4208,  512,    0,    0 },
    { BatteryTemperatureLevel::Medium,  3320,  Max,  Min,  Max,      3.0, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, true,  4208, 2048,    0,    0 },
    { BatteryTemperatureLevel::High,     Min, 3320,  Min,  Max, FloatMin,      3.0, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, true,  3952,  512,    0,    0 },
    { BatteryTemperatureLevel::High,    3320, 4050,  Min,  Max,      3.0, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, true,  3952, 2048,    0,    0 },
    { BatteryTemperatureLevel::High,    4050,  Max,  Min,  Max,      3.0, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, false, 4208, 2048,    0,    0 },
    { BatteryTemperatureLevel::TooHigh,  Min, 3320,  Min,  Max, FloatMin,      3.0, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, false, 3952,  512,    0,    0 },
    { BatteryTemperatureLevel::TooHigh, 3320, 4050,  Min,  Max,      3.0, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, false, 3952, 2048,    0,    0 },
    { BatteryTemperatureLevel::TooHigh, 4050,  Max,  Min,  Max,      3.0, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, false, 4208, 2048,    0,    0 },
};

constexpr inline const ChargeParametersRule ChargeParametersRulesForBatteryVersion1[] = {
    { BatteryTemperatureLevel::TooLow,   Min,  Max,  Min,  Max, FloatMin, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, false, 4208,  576,    0,    0 },
    { BatteryTemperatureLevel::Low,      Min,  Max,  Min,  Max, FloatMin, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, true,  4208,  576,    0,    0 },
    { BatteryTemperatureLevel::Medium,   Min,  Max,  Min,  Max, FloatMin, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, true,  4208, 1536,    0,    0 },
    { BatteryTemperatureLevel::High,     Min, 3984,  Min,  Max, FloatMin, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, true,  3984, 1536,    0,    0 },
    { BatteryTemperatureLevel::High,    3984,  Max,  Min,  Max, FloatMin, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, false, 4208, 1536,    0,    0 },
    { BatteryTemperatureLevel::TooHigh,  Min, 3984,  Min,  Max, FloatMin, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, false, 3984, 1536,    0,    0 },
    { BatteryTemperatureLevel::TooHigh, 3984,  Max,  Min,  Max, FloatMin, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, false, 4208, 1536,    0,    0 },
};

constexpr inline const ChargeParametersRule ChargeParametersRulesForBatteryVersion2[] = {
    { BatteryTemperatureLevel::TooLow,   Min,  Max,  Min,  Max, FloatMin, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, false, 4320,  640,    0,    0 },
    { BatteryTemperatureLevel::Low,      Min,  Max,  Min,  Max, FloatMin, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, true,  4320,  640,    0,    0 },
    { BatteryTemperatureLevel::Medium,   Min,  Max,  Min,  Max, FloatMin, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, true,  4320, 1664,    0,    0 },
    { BatteryTemperatureLevel::High,     Min, 4080,  Min,  Max, FloatMin, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, true,  4080, 1664,    0,    0 },
    { BatteryTemperatureLevel::High,    4080,  Max,  Min,  Max, FloatMin, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, false, 4320, 1664,    0,    0 },
    { BatteryTemperatureLevel::TooHigh,  Min, 4080,  Min,  Max, FloatMin, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, false, 4080, 1664,    0,    0 },
    { BatteryTemperatureLevel::TooHigh, 4080,  Max,  Min,  Max, FloatMin, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, false, 4320, 1664,    0,    0 },
};

constexpr inline const ChargeParametersRule ChargeParametersRulesForBatteryVersion0ForAula[] = {
    { BatteryTemperatureLevel::TooLow,   Min,  Max,  Min,  Max, FloatMin, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, false, 4208,  768,    0,    0 },
    { BatteryTemperatureLevel::Low,      Min,  Max,  Min,  Max, FloatMin, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, true,  4208,  768,    0,    0 },
    { BatteryTemperatureLevel::Medium,   Min,  Max, 2049,  Max, FloatMin, FloatMax, FloatMin,     23.0, AcceptablePowerStatesForNotAwakeCharge, util::size(AcceptablePowerStatesForNotAwakeCharge), true,  true,  4000, 3072,   40,  112 },
    { BatteryTemperatureLevel::Medium,   Min,  Max,  Min,  Max, FloatMin, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, true,  4208, 2048,    0,    0 },
    { BatteryTemperatureLevel::High,     Min, 4050,  Min,  Max, FloatMin, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, true,  3952, 2048,    0,    0 },
    { BatteryTemperatureLevel::High,    4050,  Max,  Min,  Max, FloatMin, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, false, 4208, 2048,    0,    0 },
    { BatteryTemperatureLevel::TooHigh,  Min, 4050,  Min,  Max, FloatMin, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, false, 3952, 2048,    0,    0 },
    { BatteryTemperatureLevel::TooHigh, 4050,  Max,  Min,  Max, FloatMin, FloatMax, FloatMin, FloatMax, AcceptablePowerStates,                  util::size(AcceptablePowerStates),                  false, false, 4208, 2048,    0,    0 },
};

constexpr inline const ChargeParameters ChargeParametersForBatteryVersion0 = {
     4, 17, 51, 60,  512, 4208,                         nullptr,                                           0,  95.0,  99.0,        ChargeParametersRulesForBatteryVersion0, util::size(ChargeParametersRulesForBatteryVersion0)
};

constexpr inline const ChargeParameters ChargeParametersForBatteryVersion1 = {
     1, 19, 48, 59, 1536, 4208,                         nullptr,                                           0,  95.0,  99.0,        ChargeParametersRulesForBatteryVersion1, util::size(ChargeParametersRulesForBatteryVersion1)
};

constexpr inline const ChargeParameters ChargeParametersForBatteryVersion2 = {
     1, 19, 48, 59, 1664, 4320, UnknownXTableForBatteryVersion2, util::size(UnknownXTableForBatteryVersion2),  95.0, 100.4,        ChargeParametersRulesForBatteryVersion2, util::size(ChargeParametersRulesForBatteryVersion2)
};

constexpr inline const ChargeParameters ChargeParametersForBatteryVersion0ForAula = {
     4, 17, 51, 60,  512, 4208,                         nullptr,                                           0,  95.0,  99.0, ChargeParametersRulesForBatteryVersion0ForAula, util::size(ChargeParametersRulesForBatteryVersion0ForAula)
};

