/*
 * Copyright (c) Atmosphère-NX
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#pragma once
#include <stratosphere.hpp>

namespace ams::usb {

    #if defined(ATMOSPHERE_OS_HORIZON)
    class RemoteDsRootSession {
        private:
            using Allocator     = sf::ExpHeapAllocator;
            using ObjectFactory = sf::ObjectFactory<Allocator::Policy>;
        private:
            Service m_srv;
            Allocator *m_allocator;
        public:
            RemoteDsRootSession(Service &srv, sf::ExpHeapAllocator *allocator) : m_srv(srv), m_allocator(allocator) { /* ... */ }
            virtual ~RemoteDsRootSession() { serviceClose(std::addressof(m_srv)); }
        public:
            Result GetService(sf::Out<sf::SharedPointer<usb::ds::IDsService>> out);
    };
    static_assert(ds::IsIDsRootSession<RemoteDsRootSession>);
    #endif

}
