/*
 * Copyright (c) Atmosphère-NX
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#pragma once
#include <vapours/common.hpp>
#include <vapours/assert.hpp>
#include <vapours/literals.hpp>
#include <vapours/util.hpp>
#include <vapours/results.hpp>
#include <vapours/reg.hpp>

#define EMC_ADDRESS(x)  (0x7001B000 + x)
#define EMC0_ADDRESS(x) (0x7001E000 + x)
#define EMC1_ADDRESS(x) (0x7001F000 + x)

#define EMC_INTSTATUS                             (0x000)
#define EMC_DBG                                   (0x008)
#define EMC_CFG                                   (0x00C)
#define EMC_ADR_CFG                               (0x010)
#define EMC_REFCTRL                               (0x020)
#define EMC_PIN                                   (0x024)
#define EMC_TIMING_CONTROL                        (0x028)
#define EMC_RC                                    (0x02C)
#define EMC_RFC                                   (0x030)
#define EMC_RAS                                   (0x034)
#define EMC_RP                                    (0x038)
#define EMC_R2W                                   (0x03C)
#define EMC_W2R                                   (0x040)
#define EMC_R2P                                   (0x044)
#define EMC_W2P                                   (0x048)
#define EMC_RD_RCD                                (0x04C)
#define EMC_WR_RCD                                (0x050)
#define EMC_RRD                                   (0x054)
#define EMC_REXT                                  (0x058)
#define EMC_WDV                                   (0x05C)
#define EMC_QUSE                                  (0x060)
#define EMC_QRST                                  (0x064)
#define EMC_QSAFE                                 (0x068)
#define EMC_RDV                                   (0x06C)
#define EMC_REFRESH                               (0x070)
#define EMC_BURST_REFRESH_NUM                     (0x074)
#define EMC_PDEX2WR                               (0x078)
#define EMC_PDEX2RD                               (0x07C)
#define EMC_PCHG2PDEN                             (0x080)
#define EMC_ACT2PDEN                              (0x084)
#define EMC_AR2PDEN                               (0x088)
#define EMC_RW2PDEN                               (0x08C)
#define EMC_TXSR                                  (0x090)
#define EMC_TCKE                                  (0x094)
#define EMC_TFAW                                  (0x098)
#define EMC_TRPAB                                 (0x09C)
#define EMC_TCLKSTABLE                            (0x0A0)
#define EMC_TCLKSTOP                              (0x0A4)
#define EMC_TREFBW                                (0x0A8)
#define EMC_TPPD                                  (0x0AC)
#define EMC_ODT_WRITE                             (0x0B0)
#define EMC_PDEX2MRR                              (0x0B4)
#define EMC_WEXT                                  (0x0B8)
#define EMC_TRTM                                  (0x0BC)
#define EMC_RFC_SLR                               (0x0C0)
#define EMC_MRS_WAIT_CNT2                         (0x0C4)
#define EMC_MRS_WAIT_CNT                          (0x0C8)
#define EMC_MRS                                   (0x0CC)
#define EMC_EMRS                                  (0x0D0)
#define EMC_REF                                   (0x0D4)
#define EMC_NOP                                   (0x0DC)
#define EMC_SELF_REF                              (0x0E0)
#define EMC_MRW                                   (0x0E8)
#define EMC_MRR                                   (0x0EC)
#define EMC_CMDQ                                  (0x0F0)
#define EMC_MC2EMCQ                               (0x0F4)
#define EMC_TWTM                                  (0x0F8)
#define EMC_TRATM                                 (0x0FC)
#define EMC_FBIO_SPARE                            (0x100)
#define EMC_FBIO_CFG5                             (0x104)
#define EMC_TWATM                                 (0x108)
#define EMC_TR2REF                                (0x10C)
#define EMC_PMACRO_DATA_PI_CTRL                   (0x110)
#define EMC_PMACRO_CMD_PI_CTRL                    (0x114)
#define EMC_PDEX2CKE                              (0x118)
#define EMC_CKE2PDEN                              (0x11C)
#define EMC_CFG_RSV                               (0x120)
#define EMC_ACPD_CONTROL                          (0x124)
#define EMC_MPC                                   (0x128)
#define EMC_EMRS2                                 (0x12C)
#define EMC_MRW2                                  (0x134)
#define EMC_MRW3                                  (0x138)
#define EMC_MRW3                                  (0x138)
#define EMC_MRW4                                  (0x13C)
#define EMC_CLKEN_OVERRIDE                        (0x140)
#define EMC_R2R                                   (0x144)
#define EMC_W2W                                   (0x148)
#define EMC_EINPUT                                (0x14C)
#define EMC_EINPUT_DURATION                       (0x150)
#define EMC_PUTERM_EXTRA                          (0x154)
#define EMC_TCKESR                                (0x158)
#define EMC_TPD                                   (0x15C)
#define EMC_AUTO_CAL_CONFIG                       (0x2A4)
#define EMC_AUTO_CAL_INTERVAL                     (0x2A8)
#define EMC_REQ_CTRL                              (0x2B0)
#define EMC_EMC_STATUS                            (0x2B4)
#define EMC_CFG_2                                 (0x2B8)
#define EMC_CFG_DIG_DLL                           (0x2BC)
#define EMC_CFG_DIG_DLL_PERIOD                    (0x2C0)
#define EMC_DIG_DLL_STATUS                        (0x2C4)
#define EMC_CFG_DIG_DLL_1                         (0x2C8)
#define EMC_RDV_MASK                              (0x2CC)
#define EMC_WDV_MASK                              (0x2D0)
#define EMC_RDV_EARLY_MASK                        (0x2D4)
#define EMC_RDV_EARLY                             (0x2D8)
#define EMC_AUTO_CAL_CONFIG8                      (0x2DC)
#define EMC_ZCAL_INTERVAL                         (0x2E0)
#define EMC_ZCAL_WAIT_CNT                         (0x2E4)
#define EMC_ZCAL_MRW_CMD                          (0x2E8)
#define EMC_ZQ_CAL                                (0x2EC)
#define EMC_XM2COMPPADCTRL3                       (0x2F4)
#define EMC_AUTO_CAL_VREF_SEL_0                   (0x2F8)
#define EMC_AUTO_CAL_VREF_SEL_1                   (0x300)
#define EMC_XM2COMPPADCTRL                        (0x30C)
#define EMC_FDPD_CTRL_DQ                          (0x310)
#define EMC_FDPD_CTRL_CMD                         (0x314)
#define EMC_PMACRO_CMD_BRICK_CTRL_FDPD            (0x318)
#define EMC_PMACRO_DATA_BRICK_CTRL_FDPD           (0x31C)
#define EMC_SCRATCH0                              (0x324)
#define EMC_PMACRO_BRICK_CTRL_RFU1                (0x330)
#define EMC_PMACRO_BRICK_CTRL_RFU2                (0x334)
#define EMC_CMD_MAPPING_CMD0_0                    (0x380)
#define EMC_CMD_MAPPING_CMD0_1                    (0x384)
#define EMC_CMD_MAPPING_CMD0_2                    (0x388)
#define EMC_CMD_MAPPING_CMD1_0                    (0x38C)
#define EMC_CMD_MAPPING_CMD1_1                    (0x390)
#define EMC_CMD_MAPPING_CMD1_2                    (0x394)
#define EMC_CMD_MAPPING_CMD2_0                    (0x398)
#define EMC_CMD_MAPPING_CMD2_1                    (0x39C)
#define EMC_CMD_MAPPING_CMD2_2                    (0x3A0)
#define EMC_CMD_MAPPING_CMD3_0                    (0x3A4)
#define EMC_CMD_MAPPING_CMD3_1                    (0x3A8)
#define EMC_CMD_MAPPING_CMD3_2                    (0x3AC)
#define EMC_CMD_MAPPING_BYTE                      (0x3B0)
#define EMC_TR_TIMING_0                           (0x3B4)
#define EMC_TR_CTRL_0                             (0x3B8)
#define EMC_TR_CTRL_1                             (0x3BC)
#define EMC_SWITCH_BACK_CTRL                      (0x3C0)
#define EMC_TR_RDV                                (0x3C4)
#define EMC_STALL_THEN_EXE_AFTER_CLKCHANGE        (0x3CC)
#define EMC_SEL_DPD_CTRL                          (0x3D8)
#define EMC_PRE_REFRESH_REQ_CNT                   (0x3DC)
#define EMC_DYN_SELF_REF_CONTROL                  (0x3E0)
#define EMC_TXSRDLL                               (0x3E4)
#define EMC_CCFIFO_ADDR                           (0x3E8)
#define EMC_CCFIFO_DATA                           (0x3EC)
#define EMC_CCFIFO_STATUS                         (0x3F0)
#define EMC_TR_QPOP                               (0x3F4)
#define EMC_TR_RDV_MASK                           (0x3F8)
#define EMC_TR_QSAFE                              (0x3FC)
#define EMC_TR_QRST                               (0x400)
#define EMC_SWIZZLE_RANK0_BYTE0                   (0x404)
#define EMC_SWIZZLE_RANK0_BYTE1                   (0x408)
#define EMC_SWIZZLE_RANK0_BYTE2                   (0x40C)
#define EMC_SWIZZLE_RANK0_BYTE3                   (0x410)
#define EMC_SWIZZLE_RANK1_BYTE0                   (0x418)
#define EMC_SWIZZLE_RANK1_BYTE1                   (0x41C)
#define EMC_SWIZZLE_RANK1_BYTE2                   (0x420)
#define EMC_SWIZZLE_RANK1_BYTE3                   (0x424)
#define EMC_ISSUE_QRST                            (0x428)
#define EMC_AUTO_CAL_CONFIG9                      (0x42C)
#define EMC_PMC_SCRATCH1                          (0x440)
#define EMC_PMC_SCRATCH2                          (0x444)
#define EMC_PMC_SCRATCH3                          (0x448)
#define EMC_AUTO_CAL_CONFIG2                      (0x458)
#define EMC_AUTO_CAL_CONFIG3                      (0x45C)
#define EMC_TR_DVFS                               (0x460)
#define EMC_AUTO_CAL_CHANNEL                      (0x464)
#define EMC_IBDLY                                 (0x468)
#define EMC_OBDLY                                 (0x46C)
#define EMC_TXDSRVTTGEN                           (0x480)
#define EMC_WE_DURATION                           (0x48C)
#define EMC_WS_DURATION                           (0x490)
#define EMC_WEV                                   (0x494)
#define EMC_WSV                                   (0x498)
#define EMC_CFG_3                                 (0x49C)
#define EMC_MRW5                                  (0x4A0)
#define EMC_MRW6                                  (0x4A4)
#define EMC_MRW7                                  (0x4A8)
#define EMC_MRW8                                  (0x4AC)
#define EMC_MRW9                                  (0x4B0)
#define EMC_MRW10                                 (0x4B4)
#define EMC_MRW11                                 (0x4B8)
#define EMC_MRW12                                 (0x4BC)
#define EMC_MRW13                                 (0x4C0)
#define EMC_MRW14                                 (0x4C4)
#define EMC_MRW15                                 (0x4D0)
#define EMC_CFG_SYNC                              (0x4D4)
#define EMC_FDPD_CTRL_CMD_NO_RAMP                 (0x4D8)
#define EMC_WDV_CHK                               (0x4E0)
#define EMC_CFG_PIPE_2                            (0x554)
#define EMC_CFG_PIPE_CLK                          (0x558)
#define EMC_CFG_PIPE_1                            (0x55C)
#define EMC_CFG_PIPE                              (0x560)
#define EMC_QPOP                                  (0x564)
#define EMC_QUSE_WIDTH                            (0x568)
#define EMC_PUTERM_WIDTH                          (0x56C)
#define EMC_AUTO_CAL_CONFIG7                      (0x574)
#define EMC_XM2COMPPADCTRL2                       (0x578)
#define EMC_REFCTRL2                              (0x580)
#define EMC_FBIO_CFG7                             (0x584)
#define EMC_DATA_BRLSHFT_0                        (0x588)
#define EMC_DATA_BRLSHFT_1                        (0x58C)
#define EMC_RFCPB                                 (0x590)
#define EMC_DQS_BRLSHFT_0                         (0x594)
#define EMC_DQS_BRLSHFT_1                         (0x598)
#define EMC_CMD_BRLSHFT_0                         (0x59C)
#define EMC_CMD_BRLSHFT_1                         (0x5A0)
#define EMC_CMD_BRLSHFT_2                         (0x5A4)
#define EMC_CMD_BRLSHFT_3                         (0x5A8)
#define EMC_QUSE_BRLSHFT_0                        (0x5AC)
#define EMC_AUTO_CAL_CONFIG4                      (0x5B0)
#define EMC_AUTO_CAL_CONFIG5                      (0x5B4)
#define EMC_QUSE_BRLSHFT_1                        (0x5B8)
#define EMC_QUSE_BRLSHFT_2                        (0x5BC)
#define EMC_CCDMW                                 (0x5C0)
#define EMC_QUSE_BRLSHFT_3                        (0x5C4)
#define EMC_FBIO_CFG8                             (0x5C8)
#define EMC_AUTO_CAL_CONFIG6                      (0x5CC)

/* Erista */
#define EMC_DLL_CFG_0                             (0x5E4)
#define EMC_DLL_CFG_1                             (0x5E8)

/* Mariko */
#define EMC_PMACRO_DLL_CFG_0                      (0x5E4)
#define EMC_PMACRO_DLL_CFG_1                      (0x5E8)
#define EMC_PMACRO_DLL_CFG_2                      (0x5F8)

#define EMC_CONFIG_SAMPLE_DELAY                   (0x5F0)
#define EMC_CFG_UPDATE                            (0x5F4)
#define EMC_PMACRO_QUSE_DDLL_RANK0_0              (0x600)
#define EMC_PMACRO_QUSE_DDLL_RANK0_1              (0x604)
#define EMC_PMACRO_QUSE_DDLL_RANK0_2              (0x608)
#define EMC_PMACRO_QUSE_DDLL_RANK0_3              (0x60C)
#define EMC_PMACRO_QUSE_DDLL_RANK0_4              (0x610)
#define EMC_PMACRO_QUSE_DDLL_RANK0_5              (0x614)
#define EMC_PMACRO_QUSE_DDLL_RANK1_4              (0x630)
#define EMC_PMACRO_QUSE_DDLL_RANK1_5              (0x634)
#define EMC_PMACRO_QUSE_DDLL_RANK1_0              (0x620)
#define EMC_PMACRO_QUSE_DDLL_RANK1_1              (0x624)
#define EMC_PMACRO_QUSE_DDLL_RANK1_2              (0x628)
#define EMC_PMACRO_QUSE_DDLL_RANK1_3              (0x62C)
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_0        (0x640)
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_1        (0x644)
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_2        (0x648)
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_3        (0x64C)
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_4        (0x650)
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_5        (0x654)
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_0        (0x660)
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_1        (0x664)
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_2        (0x668)
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_3        (0x66C)
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_4        (0x670)
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_5        (0x674)
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK0_0       (0x680)
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK0_1       (0x684)
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK0_2       (0x688)
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK0_3       (0x68C)
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK0_4       (0x690)
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK0_5       (0x694)
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK1_0       (0x6A0)
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK1_1       (0x6A4)
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK1_2       (0x6A8)
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK1_3       (0x6AC)
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK1_4       (0x6B0)
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK1_5       (0x6B4)
#define EMC_PMACRO_IB_DDLL_LONG_DQS_RANK0_0       (0x6C0)
#define EMC_PMACRO_IB_DDLL_LONG_DQS_RANK0_1       (0x6C4)
#define EMC_PMACRO_IB_DDLL_LONG_DQS_RANK0_2       (0x6C8)
#define EMC_PMACRO_IB_DDLL_LONG_DQS_RANK0_3       (0x6CC)
#define EMC_PMACRO_IB_DDLL_LONG_DQS_RANK1_0       (0x6E0)
#define EMC_PMACRO_IB_DDLL_LONG_DQS_RANK1_1       (0x6E4)
#define EMC_PMACRO_IB_DDLL_LONG_DQS_RANK1_2       (0x6E8)
#define EMC_PMACRO_IB_DDLL_LONG_DQS_RANK1_3       (0x6EC)
#define EMC_PMACRO_AUTOCAL_CFG_0                  (0x700)
#define EMC_PMACRO_AUTOCAL_CFG_1                  (0x704)
#define EMC_PMACRO_AUTOCAL_CFG_2                  (0x708)
#define EMC_PMACRO_TX_PWRD_0                      (0x720)
#define EMC_PMACRO_TX_PWRD_1                      (0x724)
#define EMC_PMACRO_TX_PWRD_2                      (0x728)
#define EMC_PMACRO_TX_PWRD_3                      (0x72C)
#define EMC_PMACRO_TX_PWRD_4                      (0x730)
#define EMC_PMACRO_TX_PWRD_5                      (0x734)
#define EMC_PMACRO_TX_SEL_CLK_SRC_0               (0x740)
#define EMC_PMACRO_TX_SEL_CLK_SRC_1               (0x744)
#define EMC_PMACRO_TX_SEL_CLK_SRC_3               (0x74C)
#define EMC_PMACRO_TX_SEL_CLK_SRC_2               (0x748)
#define EMC_PMACRO_TX_SEL_CLK_SRC_4               (0x750)
#define EMC_PMACRO_TX_SEL_CLK_SRC_5               (0x754)
#define EMC_PMACRO_DDLL_BYPASS                    (0x760)
#define EMC_PMACRO_DDLL_PWRD_0                    (0x770)
#define EMC_PMACRO_DDLL_PWRD_1                    (0x774)
#define EMC_PMACRO_DDLL_PWRD_2                    (0x778)
#define EMC_PMACRO_CMD_CTRL_0                     (0x780)
#define EMC_PMACRO_CMD_CTRL_1                     (0x784)
#define EMC_PMACRO_CMD_CTRL_2                     (0x788)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE0_0 (0x800)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE0_1 (0x804)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE0_2 (0x808)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE0_3 (0x80C)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE1_0 (0x810)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE1_1 (0x814)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE1_2 (0x818)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE1_3 (0x81C)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE2_0 (0x820)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE2_1 (0x824)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE2_2 (0x828)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE2_3 (0x82C)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE3_0 (0x830)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE3_1 (0x834)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE3_2 (0x838)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE3_3 (0x83C)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE4_0 (0x840)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE4_1 (0x844)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE4_2 (0x848)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE4_3 (0x84C)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE5_0 (0x850)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE5_1 (0x854)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE5_2 (0x858)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE5_3 (0x85C)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE6_0 (0x860)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE6_1 (0x864)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE6_2 (0x868)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE6_3 (0x86C)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE7_0 (0x870)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE7_1 (0x874)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE7_2 (0x878)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE7_3 (0x87C)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD0_0  (0x880)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD0_1  (0x884)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD0_2  (0x888)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD0_3  (0x88C)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD1_0  (0x890)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD1_1  (0x894)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD1_2  (0x898)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD1_3  (0x89C)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD2_0  (0x8A0)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD2_1  (0x8A4)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD2_2  (0x8A8)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD2_3  (0x8AC)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD3_0  (0x8B0)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD3_1  (0x8B4)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD3_2  (0x8B8)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD3_3  (0x8BC)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE0_0 (0x900)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE0_1 (0x904)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE0_2 (0x908)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE0_3 (0x90C)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE1_0 (0x910)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE1_1 (0x914)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE1_2 (0x918)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE1_3 (0x91C)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE2_0 (0x920)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE2_1 (0x924)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE2_2 (0x928)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE2_3 (0x92C)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE3_0 (0x930)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE3_1 (0x934)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE3_2 (0x938)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE3_3 (0x93C)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE4_0 (0x940)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE4_1 (0x944)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE4_2 (0x948)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE4_3 (0x94C)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE5_0 (0x950)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE5_1 (0x954)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE5_2 (0x958)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE5_3 (0x95C)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE6_0 (0x960)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE6_1 (0x964)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE6_2 (0x968)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE6_3 (0x96C)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE7_0 (0x970)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE7_1 (0x974)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE7_2 (0x978)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE7_3 (0x97C)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD0_0  (0x980)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD0_1  (0x984)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD0_2  (0x988)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD0_3  (0x98C)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD1_0  (0x990)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD1_1  (0x994)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD1_2  (0x998)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD1_3  (0x99C)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD2_0  (0x9A0)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD2_1  (0x9A4)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD2_2  (0x9A8)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD2_3  (0x9AC)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD3_0  (0x9B0)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD3_1  (0x9B4)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD3_2  (0x9B8)
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD3_3  (0x9BC)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE0_0 (0xA00)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE0_1 (0xA04)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE0_2 (0xA08)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE1_0 (0xA10)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE1_1 (0xA14)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE1_2 (0xA18)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE2_0 (0xA20)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE2_1 (0xA24)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE2_2 (0xA28)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE3_0 (0xA30)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE3_1 (0xA34)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE3_2 (0xA38)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE4_0 (0xA40)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE4_1 (0xA44)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE4_2 (0xA48)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE5_0 (0xA50)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE5_1 (0xA54)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE5_2 (0xA58)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE6_0 (0xA60)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE6_1 (0xA64)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE6_2 (0xA68)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE7_0 (0xA70)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE7_1 (0xA74)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE7_2 (0xA78)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE0_0 (0xB00)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE0_1 (0xB04)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE0_2 (0xB08)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE1_0 (0xB10)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE1_1 (0xB14)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE1_2 (0xB18)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE2_0 (0xB20)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE2_1 (0xB24)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE2_2 (0xB28)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE3_0 (0xB30)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE3_1 (0xB34)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE3_2 (0xB38)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE4_0 (0xB40)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE4_1 (0xB44)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE4_2 (0xB48)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE5_0 (0xB50)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE5_1 (0xB54)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE5_2 (0xB58)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE6_0 (0xB60)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE6_1 (0xB64)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE6_2 (0xB68)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE7_0 (0xB70)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE7_1 (0xB74)
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE7_2 (0xB78)
#define EMC_PMACRO_IB_VREF_DQ_0                   (0xBE0)
#define EMC_PMACRO_IB_VREF_DQ_1                   (0xBE4)
#define EMC_PMACRO_IB_VREF_DQS_0                  (0xBF0)
#define EMC_PMACRO_IB_VREF_DQS_1                  (0xBF4)
#define EMC_PMACRO_DDLL_LONG_CMD_0                (0xC00)
#define EMC_PMACRO_DDLL_LONG_CMD_1                (0xC04)
#define EMC_PMACRO_DDLL_LONG_CMD_2                (0xC08)
#define EMC_PMACRO_DDLL_LONG_CMD_3                (0xC0C)
#define EMC_PMACRO_DDLL_LONG_CMD_4                (0xC10)
#define EMC_PMACRO_DDLL_SHORT_CMD_0               (0xC20)
#define EMC_PMACRO_DDLL_SHORT_CMD_1               (0xC24)
#define EMC_PMACRO_DDLL_SHORT_CMD_2               (0xC28)
#define EMC_PMACRO_CFG_PM_GLOBAL_0                (0xC30)
#define EMC_PMACRO_VTTGEN_CTRL_0                  (0xC34)
#define EMC_PMACRO_VTTGEN_CTRL_1                  (0xC38)
#define EMC_PMACRO_BG_BIAS_CTRL_0                 (0xC3C)
#define EMC_PMACRO_PAD_CFG_CTRL                   (0xC40)
#define EMC_PMACRO_ZCTRL                          (0xC44)
#define EMC_PMACRO_RX_TERM                        (0xC48)
#define EMC_PMACRO_CMD_TX_DRV                     (0xC4C)
#define EMC_PMACRO_CMD_PAD_RX_CTRL                (0xC50)
#define EMC_PMACRO_DATA_PAD_RX_CTRL               (0xC54)
#define EMC_PMACRO_CMD_RX_TERM_MODE               (0xC58)
#define EMC_PMACRO_DATA_RX_TERM_MODE              (0xC5C)
#define EMC_PMACRO_CMD_PAD_TX_CTRL                (0xC60)
#define EMC_PMACRO_DATA_PAD_TX_CTRL               (0xC64)
#define EMC_PMACRO_COMMON_PAD_TX_CTRL             (0xC68)
#define EMC_PMACRO_DSR_VTTGEN_CTRL_0              (0xC6C)
#define EMC_PMACRO_DQ_TX_DRV                      (0xC70)
#define EMC_PMACRO_CA_TX_DRV                      (0xC74)
#define EMC_PMACRO_AUTOCAL_CFG_COMMON             (0xC78)
#define EMC_PMACRO_BRICK_MAPPING_0                (0xC80)
#define EMC_PMACRO_BRICK_MAPPING_1                (0xC84)
#define EMC_PMACRO_BRICK_MAPPING_2                (0xC88)
#define EMC_PMACRO_DDLL_PERIODIC_OFFSET           (0xCE8)
#define EMC_PMACRO_VTTGEN_CTRL_2                  (0xCF0)
#define EMC_PMACRO_IB_RXRT                        (0xCF4)
#define EMC_PMACRO_TRAINING_CTRL_0                (0xCF8)
#define EMC_PMACRO_TRAINING_CTRL_1                (0xCFC)
#define EMC_PMACRO_DIG_DLL_STATUS_0               (0xD20)
#define EMC_PMACRO_PERBIT_FGCG_CTRL_0             (0xD40)
#define EMC_PMACRO_PERBIT_FGCG_CTRL_1             (0xD44)
#define EMC_PMACRO_PERBIT_FGCG_CTRL_2             (0xD48)
#define EMC_PMACRO_PERBIT_FGCG_CTRL_3             (0xD4C)
#define EMC_PMACRO_PERBIT_FGCG_CTRL_4             (0xD50)
#define EMC_PMACRO_PERBIT_FGCG_CTRL_5             (0xD54)
#define EMC_PMACRO_PERBIT_RFU_CTRL_0              (0xD60)
#define EMC_PMACRO_PERBIT_RFU_CTRL_1              (0xD64)
#define EMC_PMACRO_PERBIT_RFU_CTRL_2              (0xD68)
#define EMC_PMACRO_PERBIT_RFU_CTRL_3              (0xD6C)
#define EMC_PMACRO_PERBIT_RFU_CTRL_4              (0xD70)
#define EMC_PMACRO_PERBIT_RFU_CTRL_5              (0xD74)
#define EMC_PMACRO_PERBIT_RFU1_CTRL_0             (0xD80)
#define EMC_PMACRO_PERBIT_RFU1_CTRL_1             (0xD84)
#define EMC_PMACRO_PERBIT_RFU1_CTRL_2             (0xD88)
#define EMC_PMACRO_PERBIT_RFU1_CTRL_3             (0xD8C)
#define EMC_PMACRO_PERBIT_RFU1_CTRL_4             (0xD90)
#define EMC_PMACRO_PERBIT_RFU1_CTRL_5             (0xD94)
#define EMC_TRAINING_CMD                          (0xE00)
#define EMC_TRAINING_CTRL                         (0xE04)
#define EMC_TRAINING_STATUS                       (0xE08)
#define EMC_TRAINING_QUSE_CORS_CTRL               (0xE0C)
#define EMC_TRAINING_QUSE_FINE_CTRL               (0xE10)
#define EMC_TRAINING_QUSE_CTRL_MISC               (0xE14)
#define EMC_TRAINING_WRITE_FINE_CTRL              (0xE18)
#define EMC_TRAINING_WRITE_CTRL_MISC              (0xE1C)
#define EMC_TRAINING_WRITE_VREF_CTRL              (0xE20)
#define EMC_TRAINING_READ_FINE_CTRL               (0xE24)
#define EMC_TRAINING_READ_CTRL_MISC               (0xE28)
#define EMC_TRAINING_READ_VREF_CTRL               (0xE2C)
#define EMC_TRAINING_CA_FINE_CTRL                 (0xE30)
#define EMC_TRAINING_CA_CTRL_MISC                 (0xE34)
#define EMC_TRAINING_CA_CTRL_MISC1                (0xE38)
#define EMC_TRAINING_CA_VREF_CTRL                 (0xE3C)
#define EMC_TRAINING_SETTLE                       (0xE44)
#define EMC_TRAINING_MPC                          (0xE5C)
#define EMC_TRAINING_PATRAM_CTRL                  (0xE60)
#define EMC_TRAINING_PATRAM_DQ                    (0xE64)
#define EMC_TRAINING_PATRAM_DMI                   (0xE68)
#define EMC_TRAINING_VREF_SETTLE                  (0xE6C)
#define EMC_TRAINING_RW_OFFSET_IB_BYTE0           (0xE98)
#define EMC_TRAINING_RW_OFFSET_IB_BYTE1           (0xE9C)
#define EMC_TRAINING_RW_OFFSET_IB_BYTE2           (0xEA0)
#define EMC_TRAINING_RW_OFFSET_IB_BYTE3           (0xEA4)
#define EMC_TRAINING_RW_OFFSET_IB_MISC            (0xEA8)
#define EMC_TRAINING_RW_OFFSET_OB_BYTE0           (0xEAC)
#define EMC_TRAINING_RW_OFFSET_OB_BYTE1           (0xEB0)
#define EMC_TRAINING_RW_OFFSET_OB_BYTE2           (0xEB4)
#define EMC_TRAINING_RW_OFFSET_OB_BYTE3           (0xEB8)
#define EMC_TRAINING_RW_OFFSET_OB_MISC            (0xEBC)
#define EMC_TRAINING_OPT_CA_VREF                  (0xEC0)
#define EMC_TRAINING_OPT_DQ_OB_VREF               (0xEC4)
#define EMC_TRAINING_QUSE_VREF_CTRL               (0xED0)
#define EMC_TRAINING_OPT_DQS_IB_VREF_RANK0        (0xED4)
#define EMC_TRAINING_OPT_DQS_IB_VREF_RANK1        (0xED8)


#define EMC_REG_BITS_MASK(NAME)                                      REG_NAMED_BITS_MASK    (EMC, NAME)
#define EMC_REG_BITS_VALUE(NAME, VALUE)                              REG_NAMED_BITS_VALUE   (EMC, NAME, VALUE)
#define EMC_REG_BITS_ENUM(NAME, ENUM)                                REG_NAMED_BITS_ENUM    (EMC, NAME, ENUM)
#define EMC_REG_BITS_ENUM_SEL(NAME, __COND__, TRUE_ENUM, FALSE_ENUM) REG_NAMED_BITS_ENUM_SEL(EMC, NAME, __COND__, TRUE_ENUM, FALSE_ENUM)

#define DEFINE_EMC_REG(NAME, __OFFSET__, __WIDTH__)                                                                                                                  REG_DEFINE_NAMED_REG           (EMC, NAME, __OFFSET__, __WIDTH__)
#define DEFINE_EMC_REG_BIT_ENUM(NAME, __OFFSET__, ZERO, ONE)                                                                                                         REG_DEFINE_NAMED_BIT_ENUM      (EMC, NAME, __OFFSET__, ZERO, ONE)
#define DEFINE_EMC_REG_TWO_BIT_ENUM(NAME, __OFFSET__, ZERO, ONE, TWO, THREE)                                                                                         REG_DEFINE_NAMED_TWO_BIT_ENUM  (EMC, NAME, __OFFSET__, ZERO, ONE, TWO, THREE)
#define DEFINE_EMC_REG_THREE_BIT_ENUM(NAME, __OFFSET__, ZERO, ONE, TWO, THREE, FOUR, FIVE, SIX, SEVEN)                                                               REG_DEFINE_NAMED_THREE_BIT_ENUM(EMC, NAME, __OFFSET__, ZERO, ONE, TWO, THREE, FOUR, FIVE, SIX, SEVEN)
#define DEFINE_EMC_REG_FOUR_BIT_ENUM(NAME, __OFFSET__, ZERO, ONE, TWO, THREE, FOUR, FIVE, SIX, SEVEN, EIGHT, NINE, TEN, ELEVEN, TWELVE, THIRTEEN, FOURTEEN, FIFTEEN) REG_DEFINE_NAMED_FOUR_BIT_ENUM (EMC, NAME, __OFFSET__, ZERO, ONE, TWO, THREE, FOUR, FIVE, SIX, SEVEN, EIGHT, NINE, TEN, ELEVEN, TWELVE, THIRTEEN, FOURTEEN, FIFTEEN)

DEFINE_EMC_REG_BIT_ENUM(DBG_WRITE_MUX, 1, ASSEMBLY, ACTIVE);

DEFINE_EMC_REG_BIT_ENUM(CFG_DYN_SELF_REF, 28, DISABLED, ENABLED);
DEFINE_EMC_REG_BIT_ENUM(CFG_DRAM_ACPD,    29, NO_POWERDOWN, ACTIVE_POWERDOWN);

DEFINE_EMC_REG_BIT_ENUM(ADR_CFG_EMEM_NUMDEV, 0, N1, N2);

DEFINE_EMC_REG_BIT_ENUM(TIMING_CONTROL_TIMING_UPDATE, 0, DISABLED, ENABLED);

DEFINE_EMC_REG_BIT_ENUM(SELF_REF_SELF_REF_CMD, 0, DISABLED, ENABLED);
DEFINE_EMC_REG_BIT_ENUM(SELF_REF_ACTIVE_SELF_REF, 8, DISABLED, ENABLED);
DEFINE_EMC_REG_TWO_BIT_ENUM(SELF_REF_SREF_DEV_SELECTN, 30, BOTH, DEV1, DEV0, RESERVED);

DEFINE_EMC_REG(MRW_OP,  0, 8);
DEFINE_EMC_REG(MRW_MA, 16, 8);
DEFINE_EMC_REG_TWO_BIT_ENUM(MRW_CNT, 26, SHORT, LONG, EXT1, EXT2);
DEFINE_EMC_REG_TWO_BIT_ENUM(MRW_DEV_SELECTN, 30, BOTH, DEV1, DEV0, RESERVED);

DEFINE_EMC_REG_TWO_BIT_ENUM(FBIO_CFG5_DRAM_TYPE, 0, DDR4, LPDDR4, LPDDR2, DDR2);

DEFINE_EMC_REG_BIT_ENUM(AUTO_CAL_CONFIG_AUTO_CAL_MEASURE_STALL,  9, DISABLE, ENABLE);
DEFINE_EMC_REG_BIT_ENUM(AUTO_CAL_CONFIG_AUTO_CAL_UPDATE_STALL,  10, DISABLE, ENABLE);
DEFINE_EMC_REG_BIT_ENUM(AUTO_CAL_CONFIG_AUTO_CAL_START,         31, DISABLE, ENABLE);

DEFINE_EMC_REG(REQ_CTRL_STALL_ALL_READS,  0, 1);
DEFINE_EMC_REG(REQ_CTRL_STALL_ALL_WRITES, 1, 1);

DEFINE_EMC_REG_TWO_BIT_ENUM(EMC_STATUS_DRAM_IN_SELF_REFRESH, 8, DISABLED, DEV0_ENABLED, DEV1_ENABLED, BOTH_ENABLED);

DEFINE_EMC_REG_BIT_ENUM(EMC_STATUS_DRAM_DEV0_IN_SELF_REFRESH, 8, DISABLED, ENABLED);

DEFINE_EMC_REG_BIT_ENUM(EMC_STATUS_NO_OUTSTANDING_TRANSACTIONS, 2, WAITING, COMPLETED);
DEFINE_EMC_REG_BIT_ENUM(EMC_STATUS_TIMING_UPDATE_STALLED, 23, DONE, BUSY);

DEFINE_EMC_REG_BIT_ENUM(CFG_DIG_DLL_CFG_DLL_EN, 0, DISABLED, ENABLED);

DEFINE_EMC_REG(ZCAL_INTERVAL_LO,  0, 10);
DEFINE_EMC_REG(ZCAL_INTERVAL_HI, 10, 14);

DEFINE_EMC_REG(PMC_SCRATCH3_DDR_CNTRL, 0, 19);
DEFINE_EMC_REG_BIT_ENUM(PMC_SCRATCH3_WEAK_BIAS, 30, DISABLED, ENABLED);

DEFINE_EMC_REG_BIT_ENUM(FBIO_CFG7_CH0_ENABLE, 1, DISABLE, ENABLE);
DEFINE_EMC_REG_BIT_ENUM(FBIO_CFG7_CH1_ENABLE, 2, DISABLE, ENABLE);

DEFINE_EMC_REG_BIT_ENUM(PMACRO_CFG_PM_GLOBAL_0_DISABLE_CFG_BYTE0, 16, DISABLE, ENABLE);
DEFINE_EMC_REG_BIT_ENUM(PMACRO_CFG_PM_GLOBAL_0_DISABLE_CFG_BYTE1, 17, DISABLE, ENABLE);
DEFINE_EMC_REG_BIT_ENUM(PMACRO_CFG_PM_GLOBAL_0_DISABLE_CFG_BYTE2, 18, DISABLE, ENABLE);
DEFINE_EMC_REG_BIT_ENUM(PMACRO_CFG_PM_GLOBAL_0_DISABLE_CFG_BYTE3, 19, DISABLE, ENABLE);
DEFINE_EMC_REG_BIT_ENUM(PMACRO_CFG_PM_GLOBAL_0_DISABLE_CFG_BYTE4, 20, DISABLE, ENABLE);
DEFINE_EMC_REG_BIT_ENUM(PMACRO_CFG_PM_GLOBAL_0_DISABLE_CFG_BYTE5, 21, DISABLE, ENABLE);
DEFINE_EMC_REG_BIT_ENUM(PMACRO_CFG_PM_GLOBAL_0_DISABLE_CFG_BYTE6, 22, DISABLE, ENABLE);
DEFINE_EMC_REG_BIT_ENUM(PMACRO_CFG_PM_GLOBAL_0_DISABLE_CFG_BYTE7, 23, DISABLE, ENABLE);
DEFINE_EMC_REG_BIT_ENUM(PMACRO_CFG_PM_GLOBAL_0_DISABLE_CFG_CMD0,  24, DISABLE, ENABLE);
DEFINE_EMC_REG_BIT_ENUM(PMACRO_CFG_PM_GLOBAL_0_DISABLE_CFG_CMD1,  25, DISABLE, ENABLE);
DEFINE_EMC_REG_BIT_ENUM(PMACRO_CFG_PM_GLOBAL_0_DISABLE_CFG_CMD2,  26, DISABLE, ENABLE);
DEFINE_EMC_REG_BIT_ENUM(PMACRO_CFG_PM_GLOBAL_0_DISABLE_CFG_CMD3,  27, DISABLE, ENABLE);

DEFINE_EMC_REG_BIT_ENUM(PMACRO_TRAINING_CTRL_0_CH0_TRAINING_ENABLED,        0, DISABLED, ENABLED);
DEFINE_EMC_REG_BIT_ENUM(PMACRO_TRAINING_CTRL_0_CH0_TRAINING_TRAIN_QPOP,     1, DISABLED, ENABLED);
DEFINE_EMC_REG_BIT_ENUM(PMACRO_TRAINING_CTRL_0_CH0_TRAINING_RX_E_DIRECT_ZI, 2, DISABLED, ENABLED);
DEFINE_EMC_REG_BIT_ENUM(PMACRO_TRAINING_CTRL_0_CH0_TRAINING_E_WRPTR,        3, DISABLED, ENABLED);
DEFINE_EMC_REG_BIT_ENUM(PMACRO_TRAINING_CTRL_0_CH0_TRAINING_DRV_DQS,        4, DISABLED, ENABLED);

DEFINE_EMC_REG_BIT_ENUM(PMACRO_TRAINING_CTRL_1_CH1_TRAINING_ENABLED,        0, DISABLED, ENABLED);
DEFINE_EMC_REG_BIT_ENUM(PMACRO_TRAINING_CTRL_1_CH1_TRAINING_TRAIN_QPOP,     1, DISABLED, ENABLED);
DEFINE_EMC_REG_BIT_ENUM(PMACRO_TRAINING_CTRL_1_CH1_TRAINING_RX_E_DIRECT_ZI, 2, DISABLED, ENABLED);
DEFINE_EMC_REG_BIT_ENUM(PMACRO_TRAINING_CTRL_1_CH1_TRAINING_E_WRPTR,        3, DISABLED, ENABLED);
DEFINE_EMC_REG_BIT_ENUM(PMACRO_TRAINING_CTRL_1_CH1_TRAINING_DRV_DQS,        4, DISABLED, ENABLED);

