/*
 * Copyright (c) Atmosphère-NX
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#pragma once
#include <vapours/common.hpp>
#include <vapours/assert.hpp>
#include <vapours/literals.hpp>
#include <vapours/util.hpp>
#include <vapours/results.hpp>
#include <vapours/reg.hpp>

#define APBDEV_PMC_CNTRL                 (0x000)
#define APBDEV_PMC_WAKE_MASK             (0x00C)
#define APBDEV_PMC_WAKE_LVL              (0x010)
#define APBDEV_PMC_WAKE_STATUS           (0x014)
#define APBDEV_PMC_DPD_PADS_ORIDE        (0x01C)
#define APBDEV_PMC_DPD_SAMPLE            (0x020)
#define APBDEV_PMC_DPD_ENABLE            (0x024)
#define APBDEV_PMC_CLAMP_STATUS          (0x02C)
#define APBDEV_PMC_PWRGATE_TOGGLE        (0x030)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD   (0x034)
#define APBDEV_PMC_PWRGATE_STATUS        (0x038)
#define APBDEV_PMC_PWRGOOD_TIMER         (0x03C)
#define APBDEV_PMC_BLINK_TIMER           (0x040)
#define APBDEV_PMC_NO_IOPOWER            (0x044)
#define APBDEV_PMC_PWR_DET               (0x048)
#define APBDEV_PMC_AUTO_WAKE_LVL_MASK    (0x0DC)
#define APBDEV_PMC_WAKE_DELAY            (0x0E0)
#define APBDEV_PMC_PWR_DET_VAL           (0x0E4)
#define APBDEV_PMC_DDR_PWR               (0x0E8)
#define APBDEV_PMC_CRYPTO_OP             (0x0F4)
#define APBDEV_PMC_WAKE2_MASK            (0x160)
#define APBDEV_PMC_WAKE2_LVL             (0x164)
#define APBDEV_PMC_WAKE2_STATUS          (0x168)
#define APBDEV_PMC_AUTO_WAKE2_LVL_MASK   (0x170)
#define APBDEV_PMC_OSC_EDPD_OVER         (0x1A4)
#define APBDEV_PMC_CLK_OUT_CNTRL         (0x1A8)
#define APBDEV_PMC_RST_STATUS            (0x1B4)
#define APBDEV_PMC_IO_DPD_REQ            (0x1B8)
#define APBDEV_PMC_IO_DPD_STATUS         (0x1BC)
#define APBDEV_PMC_IO_DPD2_REQ           (0x1C0)
#define APBDEV_PMC_IO_DPD2_STATUS        (0x1C4)
#define APBDEV_PMC_SEL_DPD_TIM           (0x1C8)
#define APBDEV_PMC_VDDP_SEL              (0x1CC)
#define APBDEV_PMC_DDR_CFG               (0x1D0)
#define APBDEV_PMC_TSC_MULT              (0x2B4)
#define APBDEV_PMC_STICKY_BITS           (0x2C0)
#define APBDEV_PMC_WEAK_BIAS             (0x2C8)
#define APBDEV_PMC_REG_SHORT             (0x2CC)
#define APBDEV_PMC_GPU_RG_CNTRL          (0x2D4)
#define APBDEV_PMC_CNTRL2                (0x440)
#define APBDEV_PMC_FUSE_CTRL             (0x450)
#define APBDEV_PMC_IO_DPD3_REQ           (0x45C)
#define APBDEV_PMC_IO_DPD3_STATUS        (0x460)
#define APBDEV_PMC_IO_DPD4_REQ           (0x464)
#define APBDEV_PMC_IO_DPD4_STATUS        (0x468)
#define APBDEV_PMC_SET_SW_CLAMP          (0x47C)
#define APBDEV_PMC_WAKE_DEBOUNCE_EN      (0x4D8)
#define APBDEV_PMC_DDR_CNTRL             (0x4E4)

#define APBDEV_PMC_SEC_DISABLE           (0x004)
#define APBDEV_PMC_SEC_DISABLE2          (0x2C4)
#define APBDEV_PMC_SEC_DISABLE3          (0x2D8)
#define APBDEV_PMC_SEC_DISABLE4          (0x5B0)
#define APBDEV_PMC_SEC_DISABLE5          (0x5B4)
#define APBDEV_PMC_SEC_DISABLE6          (0x5B8)
#define APBDEV_PMC_SEC_DISABLE7          (0x5BC)
#define APBDEV_PMC_SEC_DISABLE8          (0x5C0)

/* Mariko. */
#define APBDEV_PMC_TZRAM_PWR_CNTRL       (0xBE8)
#define APBDEV_PMC_TZRAM_SEC_DISABLE     (0xBEC)
#define APBDEV_PMC_TZRAM_NON_SEC_DISABLE (0xBF0)

#define APBDEV_PMC_SCRATCH0              (0x050)
#define APBDEV_PMC_SCRATCH1              (0x054)
#define APBDEV_PMC_SCRATCH2              (0x058)
#define APBDEV_PMC_SCRATCH3              (0x05C)
#define APBDEV_PMC_SCRATCH4              (0x060)
#define APBDEV_PMC_SCRATCH5              (0x064)
#define APBDEV_PMC_SCRATCH6              (0x068)
#define APBDEV_PMC_SCRATCH7              (0x06C)
#define APBDEV_PMC_SCRATCH8              (0x070)
#define APBDEV_PMC_SCRATCH9              (0x074)
#define APBDEV_PMC_SCRATCH10             (0x078)
#define APBDEV_PMC_SCRATCH11             (0x07C)
#define APBDEV_PMC_SCRATCH12             (0x080)
#define APBDEV_PMC_SCRATCH13             (0x084)
#define APBDEV_PMC_SCRATCH14             (0x088)
#define APBDEV_PMC_SCRATCH15             (0x08C)
#define APBDEV_PMC_SCRATCH16             (0x090)
#define APBDEV_PMC_SCRATCH17             (0x094)
#define APBDEV_PMC_SCRATCH18             (0x098)
#define APBDEV_PMC_SCRATCH19             (0x09C)
#define APBDEV_PMC_SCRATCH20             (0x0A0)
#define APBDEV_PMC_SCRATCH21             (0x0A4)
#define APBDEV_PMC_SCRATCH22             (0x0A8)
#define APBDEV_PMC_SCRATCH23             (0x0AC)
#define APBDEV_PMC_SCRATCH24             (0x0FC)
#define APBDEV_PMC_SCRATCH25             (0x100)
#define APBDEV_PMC_SCRATCH26             (0x104)
#define APBDEV_PMC_SCRATCH27             (0x108)
#define APBDEV_PMC_SCRATCH28             (0x10C)
#define APBDEV_PMC_SCRATCH29             (0x110)
#define APBDEV_PMC_SCRATCH30             (0x114)
#define APBDEV_PMC_SCRATCH31             (0x118)
#define APBDEV_PMC_SCRATCH32             (0x11C)
#define APBDEV_PMC_SCRATCH33             (0x120)
#define APBDEV_PMC_SCRATCH34             (0x124)
#define APBDEV_PMC_SCRATCH35             (0x128)
#define APBDEV_PMC_SCRATCH36             (0x12C)
#define APBDEV_PMC_SCRATCH37             (0x130)
#define APBDEV_PMC_SCRATCH38             (0x134)
#define APBDEV_PMC_SCRATCH39             (0x138)
#define APBDEV_PMC_SCRATCH40             (0x13C)
#define APBDEV_PMC_SCRATCH41             (0x140)
#define APBDEV_PMC_SCRATCH42             (0x144)
#define APBDEV_PMC_SCRATCH43             (0x22C)
#define APBDEV_PMC_SCRATCH44             (0x230)
#define APBDEV_PMC_SCRATCH45             (0x234)
#define APBDEV_PMC_SCRATCH46             (0x238)
#define APBDEV_PMC_SCRATCH47             (0x23C)
#define APBDEV_PMC_SCRATCH48             (0x240)
#define APBDEV_PMC_SCRATCH49             (0x244)
#define APBDEV_PMC_SCRATCH50             (0x248)
#define APBDEV_PMC_SCRATCH51             (0x24C)
#define APBDEV_PMC_SCRATCH52             (0x250)
#define APBDEV_PMC_SCRATCH53             (0x254)
#define APBDEV_PMC_SCRATCH54             (0x258)
#define APBDEV_PMC_SCRATCH55             (0x25C)
#define APBDEV_PMC_SCRATCH56             (0x600)
#define APBDEV_PMC_SCRATCH57             (0x604)
#define APBDEV_PMC_SCRATCH58             (0x608)
#define APBDEV_PMC_SCRATCH59             (0x60C)
#define APBDEV_PMC_SCRATCH60             (0x610)
#define APBDEV_PMC_SCRATCH61             (0x614)
#define APBDEV_PMC_SCRATCH62             (0x618)
#define APBDEV_PMC_SCRATCH63             (0x61C)
#define APBDEV_PMC_SCRATCH64             (0x620)
#define APBDEV_PMC_SCRATCH65             (0x624)
#define APBDEV_PMC_SCRATCH66             (0x628)
#define APBDEV_PMC_SCRATCH67             (0x62C)
#define APBDEV_PMC_SCRATCH68             (0x630)
#define APBDEV_PMC_SCRATCH69             (0x634)
#define APBDEV_PMC_SCRATCH70             (0x638)
#define APBDEV_PMC_SCRATCH71             (0x63C)
#define APBDEV_PMC_SCRATCH72             (0x640)
#define APBDEV_PMC_SCRATCH73             (0x644)
#define APBDEV_PMC_SCRATCH74             (0x648)
#define APBDEV_PMC_SCRATCH75             (0x64C)
#define APBDEV_PMC_SCRATCH76             (0x650)
#define APBDEV_PMC_SCRATCH77             (0x654)
#define APBDEV_PMC_SCRATCH78             (0x658)
#define APBDEV_PMC_SCRATCH79             (0x65C)
#define APBDEV_PMC_SCRATCH80             (0x660)
#define APBDEV_PMC_SCRATCH81             (0x664)
#define APBDEV_PMC_SCRATCH82             (0x668)
#define APBDEV_PMC_SCRATCH83             (0x66C)
#define APBDEV_PMC_SCRATCH84             (0x670)
#define APBDEV_PMC_SCRATCH85             (0x674)
#define APBDEV_PMC_SCRATCH86             (0x678)
#define APBDEV_PMC_SCRATCH87             (0x67C)
#define APBDEV_PMC_SCRATCH88             (0x680)
#define APBDEV_PMC_SCRATCH89             (0x684)
#define APBDEV_PMC_SCRATCH90             (0x688)
#define APBDEV_PMC_SCRATCH91             (0x68C)
#define APBDEV_PMC_SCRATCH92             (0x690)
#define APBDEV_PMC_SCRATCH93             (0x694)
#define APBDEV_PMC_SCRATCH94             (0x698)
#define APBDEV_PMC_SCRATCH95             (0x69C)
#define APBDEV_PMC_SCRATCH96             (0x6A0)
#define APBDEV_PMC_SCRATCH97             (0x6A4)
#define APBDEV_PMC_SCRATCH98             (0x6A8)
#define APBDEV_PMC_SCRATCH99             (0x6AC)
#define APBDEV_PMC_SCRATCH100            (0x6B0)
#define APBDEV_PMC_SCRATCH101            (0x6B4)
#define APBDEV_PMC_SCRATCH102            (0x6B8)
#define APBDEV_PMC_SCRATCH103            (0x6BC)
#define APBDEV_PMC_SCRATCH104            (0x6C0)
#define APBDEV_PMC_SCRATCH105            (0x6C4)
#define APBDEV_PMC_SCRATCH106            (0x6C8)
#define APBDEV_PMC_SCRATCH107            (0x6CC)
#define APBDEV_PMC_SCRATCH108            (0x6D0)
#define APBDEV_PMC_SCRATCH109            (0x6D4)
#define APBDEV_PMC_SCRATCH110            (0x6D8)
#define APBDEV_PMC_SCRATCH111            (0x6DC)
#define APBDEV_PMC_SCRATCH112            (0x6E0)
#define APBDEV_PMC_SCRATCH113            (0x6E4)
#define APBDEV_PMC_SCRATCH114            (0x6E8)
#define APBDEV_PMC_SCRATCH115            (0x6EC)
#define APBDEV_PMC_SCRATCH116            (0x6F0)
#define APBDEV_PMC_SCRATCH117            (0x6F4)
#define APBDEV_PMC_SCRATCH118            (0x6F8)
#define APBDEV_PMC_SCRATCH119            (0x6FC)
#define APBDEV_PMC_SCRATCH120            (0x700)
#define APBDEV_PMC_SCRATCH121            (0x704)
#define APBDEV_PMC_SCRATCH122            (0x708)
#define APBDEV_PMC_SCRATCH123            (0x70C)
#define APBDEV_PMC_SCRATCH124            (0x710)
#define APBDEV_PMC_SCRATCH125            (0x714)
#define APBDEV_PMC_SCRATCH126            (0x718)
#define APBDEV_PMC_SCRATCH127            (0x71C)
#define APBDEV_PMC_SCRATCH128            (0x720)
#define APBDEV_PMC_SCRATCH129            (0x724)
#define APBDEV_PMC_SCRATCH130            (0x728)
#define APBDEV_PMC_SCRATCH131            (0x72C)
#define APBDEV_PMC_SCRATCH132            (0x730)
#define APBDEV_PMC_SCRATCH133            (0x734)
#define APBDEV_PMC_SCRATCH134            (0x738)
#define APBDEV_PMC_SCRATCH135            (0x73C)
#define APBDEV_PMC_SCRATCH136            (0x740)
#define APBDEV_PMC_SCRATCH137            (0x744)
#define APBDEV_PMC_SCRATCH138            (0x748)
#define APBDEV_PMC_SCRATCH139            (0x74C)
#define APBDEV_PMC_SCRATCH140            (0x750)
#define APBDEV_PMC_SCRATCH141            (0x754)
#define APBDEV_PMC_SCRATCH142            (0x758)
#define APBDEV_PMC_SCRATCH143            (0x75C)
#define APBDEV_PMC_SCRATCH144            (0x760)
#define APBDEV_PMC_SCRATCH145            (0x764)
#define APBDEV_PMC_SCRATCH146            (0x768)
#define APBDEV_PMC_SCRATCH147            (0x76C)
#define APBDEV_PMC_SCRATCH148            (0x770)
#define APBDEV_PMC_SCRATCH149            (0x774)
#define APBDEV_PMC_SCRATCH150            (0x778)
#define APBDEV_PMC_SCRATCH151            (0x77C)
#define APBDEV_PMC_SCRATCH152            (0x780)
#define APBDEV_PMC_SCRATCH153            (0x784)
#define APBDEV_PMC_SCRATCH154            (0x788)
#define APBDEV_PMC_SCRATCH155            (0x78C)
#define APBDEV_PMC_SCRATCH156            (0x790)
#define APBDEV_PMC_SCRATCH157            (0x794)
#define APBDEV_PMC_SCRATCH158            (0x798)
#define APBDEV_PMC_SCRATCH159            (0x79C)
#define APBDEV_PMC_SCRATCH160            (0x7A0)
#define APBDEV_PMC_SCRATCH161            (0x7A4)
#define APBDEV_PMC_SCRATCH162            (0x7A8)
#define APBDEV_PMC_SCRATCH163            (0x7AC)
#define APBDEV_PMC_SCRATCH164            (0x7B0)
#define APBDEV_PMC_SCRATCH165            (0x7B4)
#define APBDEV_PMC_SCRATCH166            (0x7B8)
#define APBDEV_PMC_SCRATCH167            (0x7BC)
#define APBDEV_PMC_SCRATCH168            (0x7C0)
#define APBDEV_PMC_SCRATCH169            (0x7C4)
#define APBDEV_PMC_SCRATCH170            (0x7C8)
#define APBDEV_PMC_SCRATCH171            (0x7CC)
#define APBDEV_PMC_SCRATCH172            (0x7D0)
#define APBDEV_PMC_SCRATCH173            (0x7D4)
#define APBDEV_PMC_SCRATCH174            (0x7D8)
#define APBDEV_PMC_SCRATCH175            (0x7DC)
#define APBDEV_PMC_SCRATCH176            (0x7E0)
#define APBDEV_PMC_SCRATCH177            (0x7E4)
#define APBDEV_PMC_SCRATCH178            (0x7E8)
#define APBDEV_PMC_SCRATCH179            (0x7EC)
#define APBDEV_PMC_SCRATCH180            (0x7F0)
#define APBDEV_PMC_SCRATCH181            (0x7F4)
#define APBDEV_PMC_SCRATCH182            (0x7F8)
#define APBDEV_PMC_SCRATCH183            (0x7FC)
#define APBDEV_PMC_SCRATCH184            (0x800)
#define APBDEV_PMC_SCRATCH185            (0x804)
#define APBDEV_PMC_SCRATCH186            (0x808)
#define APBDEV_PMC_SCRATCH187            (0x80C)
#define APBDEV_PMC_SCRATCH188            (0x810)
#define APBDEV_PMC_SCRATCH189            (0x814)
#define APBDEV_PMC_SCRATCH190            (0x818)
#define APBDEV_PMC_SCRATCH191            (0x81C)
#define APBDEV_PMC_SCRATCH192            (0x820)
#define APBDEV_PMC_SCRATCH193            (0x824)
#define APBDEV_PMC_SCRATCH194            (0x828)
#define APBDEV_PMC_SCRATCH195            (0x82C)
#define APBDEV_PMC_SCRATCH196            (0x830)
#define APBDEV_PMC_SCRATCH197            (0x834)
#define APBDEV_PMC_SCRATCH198            (0x838)
#define APBDEV_PMC_SCRATCH199            (0x83C)
#define APBDEV_PMC_SCRATCH200            (0x840)
#define APBDEV_PMC_SCRATCH201            (0x844)
#define APBDEV_PMC_SCRATCH202            (0x848)
#define APBDEV_PMC_SCRATCH203            (0x84C)
#define APBDEV_PMC_SCRATCH204            (0x850)
#define APBDEV_PMC_SCRATCH205            (0x854)
#define APBDEV_PMC_SCRATCH206            (0x858)
#define APBDEV_PMC_SCRATCH207            (0x85C)
#define APBDEV_PMC_SCRATCH208            (0x860)
#define APBDEV_PMC_SCRATCH209            (0x864)
#define APBDEV_PMC_SCRATCH210            (0x868)
#define APBDEV_PMC_SCRATCH211            (0x86C)
#define APBDEV_PMC_SCRATCH212            (0x870)
#define APBDEV_PMC_SCRATCH213            (0x874)
#define APBDEV_PMC_SCRATCH214            (0x878)
#define APBDEV_PMC_SCRATCH215            (0x87C)
#define APBDEV_PMC_SCRATCH216            (0x880)
#define APBDEV_PMC_SCRATCH217            (0x884)
#define APBDEV_PMC_SCRATCH218            (0x888)
#define APBDEV_PMC_SCRATCH219            (0x88C)
#define APBDEV_PMC_SCRATCH220            (0x890)
#define APBDEV_PMC_SCRATCH221            (0x894)
#define APBDEV_PMC_SCRATCH222            (0x898)
#define APBDEV_PMC_SCRATCH223            (0x89C)
#define APBDEV_PMC_SCRATCH224            (0x8A0)
#define APBDEV_PMC_SCRATCH225            (0x8A4)
#define APBDEV_PMC_SCRATCH226            (0x8A8)
#define APBDEV_PMC_SCRATCH227            (0x8AC)
#define APBDEV_PMC_SCRATCH228            (0x8B0)
#define APBDEV_PMC_SCRATCH229            (0x8B4)
#define APBDEV_PMC_SCRATCH230            (0x8B8)
#define APBDEV_PMC_SCRATCH231            (0x8BC)
#define APBDEV_PMC_SCRATCH232            (0x8C0)
#define APBDEV_PMC_SCRATCH233            (0x8C4)
#define APBDEV_PMC_SCRATCH234            (0x8C8)
#define APBDEV_PMC_SCRATCH235            (0x8CC)
#define APBDEV_PMC_SCRATCH236            (0x8D0)
#define APBDEV_PMC_SCRATCH237            (0x8D4)
#define APBDEV_PMC_SCRATCH238            (0x8D8)
#define APBDEV_PMC_SCRATCH239            (0x8DC)
#define APBDEV_PMC_SCRATCH240            (0x8E0)
#define APBDEV_PMC_SCRATCH241            (0x8E4)
#define APBDEV_PMC_SCRATCH242            (0x8E8)
#define APBDEV_PMC_SCRATCH243            (0x8EC)
#define APBDEV_PMC_SCRATCH244            (0x8F0)
#define APBDEV_PMC_SCRATCH245            (0x8F4)
#define APBDEV_PMC_SCRATCH246            (0x8F8)
#define APBDEV_PMC_SCRATCH247            (0x8FC)
#define APBDEV_PMC_SCRATCH248            (0x900)
#define APBDEV_PMC_SCRATCH249            (0x904)
#define APBDEV_PMC_SCRATCH250            (0x908)
#define APBDEV_PMC_SCRATCH251            (0x90C)
#define APBDEV_PMC_SCRATCH252            (0x910)
#define APBDEV_PMC_SCRATCH253            (0x914)
#define APBDEV_PMC_SCRATCH254            (0x918)
#define APBDEV_PMC_SCRATCH255            (0x91C)
#define APBDEV_PMC_SCRATCH256            (0x920)
#define APBDEV_PMC_SCRATCH257            (0x924)
#define APBDEV_PMC_SCRATCH258            (0x928)
#define APBDEV_PMC_SCRATCH259            (0x92C)
#define APBDEV_PMC_SCRATCH260            (0x930)
#define APBDEV_PMC_SCRATCH261            (0x934)
#define APBDEV_PMC_SCRATCH262            (0x938)
#define APBDEV_PMC_SCRATCH263            (0x93C)
#define APBDEV_PMC_SCRATCH264            (0x940)
#define APBDEV_PMC_SCRATCH265            (0x944)
#define APBDEV_PMC_SCRATCH266            (0x948)
#define APBDEV_PMC_SCRATCH267            (0x94C)
#define APBDEV_PMC_SCRATCH268            (0x950)
#define APBDEV_PMC_SCRATCH269            (0x954)
#define APBDEV_PMC_SCRATCH270            (0x958)
#define APBDEV_PMC_SCRATCH271            (0x95C)
#define APBDEV_PMC_SCRATCH272            (0x960)
#define APBDEV_PMC_SCRATCH273            (0x964)
#define APBDEV_PMC_SCRATCH274            (0x968)
#define APBDEV_PMC_SCRATCH275            (0x96C)
#define APBDEV_PMC_SCRATCH276            (0x970)
#define APBDEV_PMC_SCRATCH277            (0x974)
#define APBDEV_PMC_SCRATCH278            (0x978)
#define APBDEV_PMC_SCRATCH279            (0x97C)
#define APBDEV_PMC_SCRATCH280            (0x980)
#define APBDEV_PMC_SCRATCH281            (0x984)
#define APBDEV_PMC_SCRATCH282            (0x988)
#define APBDEV_PMC_SCRATCH283            (0x98C)
#define APBDEV_PMC_SCRATCH284            (0x990)
#define APBDEV_PMC_SCRATCH285            (0x994)
#define APBDEV_PMC_SCRATCH286            (0x998)
#define APBDEV_PMC_SCRATCH287            (0x99C)
#define APBDEV_PMC_SCRATCH288            (0x9A0)
#define APBDEV_PMC_SCRATCH289            (0x9A4)
#define APBDEV_PMC_SCRATCH290            (0x9A8)
#define APBDEV_PMC_SCRATCH291            (0x9AC)
#define APBDEV_PMC_SCRATCH292            (0x9B0)
#define APBDEV_PMC_SCRATCH293            (0x9B4)
#define APBDEV_PMC_SCRATCH294            (0x9B8)
#define APBDEV_PMC_SCRATCH295            (0x9BC)
#define APBDEV_PMC_SCRATCH296            (0x9C0)
#define APBDEV_PMC_SCRATCH297            (0x9C4)
#define APBDEV_PMC_SCRATCH298            (0x9C8)
#define APBDEV_PMC_SCRATCH299            (0x9CC)

#define APBDEV_PMC_SECURE_SCRATCH0       (0x0B0)
#define APBDEV_PMC_SECURE_SCRATCH1       (0x0B4)
#define APBDEV_PMC_SECURE_SCRATCH2       (0x0B8)
#define APBDEV_PMC_SECURE_SCRATCH3       (0x0BC)
#define APBDEV_PMC_SECURE_SCRATCH4       (0x0C0)
#define APBDEV_PMC_SECURE_SCRATCH5       (0x0C4)
#define APBDEV_PMC_SECURE_SCRATCH6       (0x224)
#define APBDEV_PMC_SECURE_SCRATCH7       (0x228)
#define APBDEV_PMC_SECURE_SCRATCH8       (0x300)
#define APBDEV_PMC_SECURE_SCRATCH9       (0x304)
#define APBDEV_PMC_SECURE_SCRATCH10      (0x308)
#define APBDEV_PMC_SECURE_SCRATCH11      (0x30C)
#define APBDEV_PMC_SECURE_SCRATCH12      (0x310)
#define APBDEV_PMC_SECURE_SCRATCH13      (0x314)
#define APBDEV_PMC_SECURE_SCRATCH14      (0x318)
#define APBDEV_PMC_SECURE_SCRATCH15      (0x31C)
#define APBDEV_PMC_SECURE_SCRATCH16      (0x320)
#define APBDEV_PMC_SECURE_SCRATCH17      (0x324)
#define APBDEV_PMC_SECURE_SCRATCH18      (0x328)
#define APBDEV_PMC_SECURE_SCRATCH19      (0x32C)
#define APBDEV_PMC_SECURE_SCRATCH20      (0x330)
#define APBDEV_PMC_SECURE_SCRATCH21      (0x334)
#define APBDEV_PMC_SECURE_SCRATCH22      (0x338)
#define APBDEV_PMC_SECURE_SCRATCH23      (0x33C)
#define APBDEV_PMC_SECURE_SCRATCH24      (0x340)
#define APBDEV_PMC_SECURE_SCRATCH25      (0x344)
#define APBDEV_PMC_SECURE_SCRATCH26      (0x348)
#define APBDEV_PMC_SECURE_SCRATCH27      (0x34C)
#define APBDEV_PMC_SECURE_SCRATCH28      (0x350)
#define APBDEV_PMC_SECURE_SCRATCH29      (0x354)
#define APBDEV_PMC_SECURE_SCRATCH30      (0x358)
#define APBDEV_PMC_SECURE_SCRATCH31      (0x35C)
#define APBDEV_PMC_SECURE_SCRATCH32      (0x360)
#define APBDEV_PMC_SECURE_SCRATCH33      (0x364)
#define APBDEV_PMC_SECURE_SCRATCH34      (0x368)
#define APBDEV_PMC_SECURE_SCRATCH35      (0x36C)
#define APBDEV_PMC_SECURE_SCRATCH36      (0x370)
#define APBDEV_PMC_SECURE_SCRATCH37      (0x374)
#define APBDEV_PMC_SECURE_SCRATCH38      (0x378)
#define APBDEV_PMC_SECURE_SCRATCH39      (0x37C)
#define APBDEV_PMC_SECURE_SCRATCH40      (0x380)
#define APBDEV_PMC_SECURE_SCRATCH41      (0x384)
#define APBDEV_PMC_SECURE_SCRATCH42      (0x388)
#define APBDEV_PMC_SECURE_SCRATCH43      (0x38C)
#define APBDEV_PMC_SECURE_SCRATCH44      (0x390)
#define APBDEV_PMC_SECURE_SCRATCH45      (0x394)
#define APBDEV_PMC_SECURE_SCRATCH46      (0x398)
#define APBDEV_PMC_SECURE_SCRATCH47      (0x39C)
#define APBDEV_PMC_SECURE_SCRATCH48      (0x3A0)
#define APBDEV_PMC_SECURE_SCRATCH49      (0x3A4)
#define APBDEV_PMC_SECURE_SCRATCH50      (0x3A8)
#define APBDEV_PMC_SECURE_SCRATCH51      (0x3AC)
#define APBDEV_PMC_SECURE_SCRATCH52      (0x3B0)
#define APBDEV_PMC_SECURE_SCRATCH53      (0x3B4)
#define APBDEV_PMC_SECURE_SCRATCH54      (0x3B8)
#define APBDEV_PMC_SECURE_SCRATCH55      (0x3BC)
#define APBDEV_PMC_SECURE_SCRATCH56      (0x3C0)
#define APBDEV_PMC_SECURE_SCRATCH57      (0x3C4)
#define APBDEV_PMC_SECURE_SCRATCH58      (0x3C8)
#define APBDEV_PMC_SECURE_SCRATCH59      (0x3CC)
#define APBDEV_PMC_SECURE_SCRATCH60      (0x3D0)
#define APBDEV_PMC_SECURE_SCRATCH61      (0x3D4)
#define APBDEV_PMC_SECURE_SCRATCH62      (0x3D8)
#define APBDEV_PMC_SECURE_SCRATCH63      (0x3DC)
#define APBDEV_PMC_SECURE_SCRATCH64      (0x3E0)
#define APBDEV_PMC_SECURE_SCRATCH65      (0x3E4)
#define APBDEV_PMC_SECURE_SCRATCH66      (0x3E8)
#define APBDEV_PMC_SECURE_SCRATCH67      (0x3EC)
#define APBDEV_PMC_SECURE_SCRATCH68      (0x3F0)
#define APBDEV_PMC_SECURE_SCRATCH69      (0x3F4)
#define APBDEV_PMC_SECURE_SCRATCH70      (0x3F8)
#define APBDEV_PMC_SECURE_SCRATCH71      (0x3FC)
#define APBDEV_PMC_SECURE_SCRATCH72      (0x400)
#define APBDEV_PMC_SECURE_SCRATCH73      (0x404)
#define APBDEV_PMC_SECURE_SCRATCH74      (0x408)
#define APBDEV_PMC_SECURE_SCRATCH75      (0x40C)
#define APBDEV_PMC_SECURE_SCRATCH76      (0x410)
#define APBDEV_PMC_SECURE_SCRATCH77      (0x414)
#define APBDEV_PMC_SECURE_SCRATCH78      (0x418)
#define APBDEV_PMC_SECURE_SCRATCH79      (0x41C)
#define APBDEV_PMC_SECURE_SCRATCH80      (0xA98)
#define APBDEV_PMC_SECURE_SCRATCH81      (0xA9C)
#define APBDEV_PMC_SECURE_SCRATCH82      (0xAA0)
#define APBDEV_PMC_SECURE_SCRATCH83      (0xAA4)
#define APBDEV_PMC_SECURE_SCRATCH84      (0xAA8)
#define APBDEV_PMC_SECURE_SCRATCH85      (0xAAC)
#define APBDEV_PMC_SECURE_SCRATCH86      (0xAB0)
#define APBDEV_PMC_SECURE_SCRATCH87      (0xAB4)
#define APBDEV_PMC_SECURE_SCRATCH88      (0xAB8)
#define APBDEV_PMC_SECURE_SCRATCH89      (0xABC)
#define APBDEV_PMC_SECURE_SCRATCH90      (0xAC0)
#define APBDEV_PMC_SECURE_SCRATCH91      (0xAC4)
#define APBDEV_PMC_SECURE_SCRATCH92      (0xAC8)
#define APBDEV_PMC_SECURE_SCRATCH93      (0xACC)
#define APBDEV_PMC_SECURE_SCRATCH94      (0xAD0)
#define APBDEV_PMC_SECURE_SCRATCH95      (0xAD4)
#define APBDEV_PMC_SECURE_SCRATCH96      (0xAD8)
#define APBDEV_PMC_SECURE_SCRATCH97      (0xADC)
#define APBDEV_PMC_SECURE_SCRATCH98      (0xAE0)
#define APBDEV_PMC_SECURE_SCRATCH99      (0xAE4)
#define APBDEV_PMC_SECURE_SCRATCH100     (0xAE8)
#define APBDEV_PMC_SECURE_SCRATCH101     (0xAEC)
#define APBDEV_PMC_SECURE_SCRATCH102     (0xAF0)
#define APBDEV_PMC_SECURE_SCRATCH103     (0xAF4)
#define APBDEV_PMC_SECURE_SCRATCH104     (0xAF8)
#define APBDEV_PMC_SECURE_SCRATCH105     (0xAFC)
#define APBDEV_PMC_SECURE_SCRATCH106     (0xB00)
#define APBDEV_PMC_SECURE_SCRATCH107     (0xB04)
#define APBDEV_PMC_SECURE_SCRATCH108     (0xB08)
#define APBDEV_PMC_SECURE_SCRATCH109     (0xB0C)
#define APBDEV_PMC_SECURE_SCRATCH110     (0xB10)
#define APBDEV_PMC_SECURE_SCRATCH111     (0xB14)
#define APBDEV_PMC_SECURE_SCRATCH112     (0xB18)
#define APBDEV_PMC_SECURE_SCRATCH113     (0xB1C)
#define APBDEV_PMC_SECURE_SCRATCH114     (0xB20)
#define APBDEV_PMC_SECURE_SCRATCH115     (0xB24)
#define APBDEV_PMC_SECURE_SCRATCH116     (0xB28)
#define APBDEV_PMC_SECURE_SCRATCH117     (0xB2C)
#define APBDEV_PMC_SECURE_SCRATCH118     (0xB30)
#define APBDEV_PMC_SECURE_SCRATCH119     (0xB34)

/* Mariko. */
#define APBDEV_PMC_SECURE_SCRATCH120     (0xB38)
#define APBDEV_PMC_SECURE_SCRATCH121     (0xB3C)
#define APBDEV_PMC_SECURE_SCRATCH122     (0xB40)
#define APBDEV_PMC_SECURE_SCRATCH123     (0xB44)
#define APBDEV_PMC_SECURE_SCRATCH124     (0xB68)
#define APBDEV_PMC_SECURE_SCRATCH125     (0xB6C)
#define APBDEV_PMC_SECURE_SCRATCH126     (0xB70)
#define APBDEV_PMC_SECURE_SCRATCH127     (0xB74)
#define APBDEV_PMC_SECURE_SCRATCH128     (0xB78)
#define APBDEV_PMC_SECURE_SCRATCH129     (0xB7C)
#define APBDEV_PMC_SECURE_SCRATCH130     (0xB80)
#define APBDEV_PMC_SECURE_SCRATCH131     (0xB84)
#define APBDEV_PMC_SECURE_SCRATCH132     (0xB88)
#define APBDEV_PMC_SECURE_SCRATCH133     (0xB8C)
#define APBDEV_PMC_SECURE_SCRATCH134     (0xB90)
#define APBDEV_PMC_SECURE_SCRATCH135     (0xB94)
#define APBDEV_PMC_SECURE_SCRATCH136     (0xB98)
#define APBDEV_PMC_SECURE_SCRATCH137     (0xB9C)
#define APBDEV_PMC_SECURE_SCRATCH138     (0xBA0)
#define APBDEV_PMC_SECURE_SCRATCH139     (0xBA4)

#define PMC_REG_BITS_MASK(NAME)                                      REG_NAMED_BITS_MASK    (APBDEV_PMC, NAME)
#define PMC_REG_BITS_VALUE(NAME, VALUE)                              REG_NAMED_BITS_VALUE   (APBDEV_PMC, NAME, VALUE)
#define PMC_REG_BITS_ENUM(NAME, ENUM)                                REG_NAMED_BITS_ENUM    (APBDEV_PMC, NAME, ENUM)
#define PMC_REG_BITS_ENUM_SEL(NAME, __COND__, TRUE_ENUM, FALSE_ENUM) REG_NAMED_BITS_ENUM_SEL(APBDEV_PMC, NAME, __COND__, TRUE_ENUM, FALSE_ENUM)

#define DEFINE_PMC_REG(NAME, __OFFSET__, __WIDTH__)                                                                                                                  REG_DEFINE_NAMED_REG           (APBDEV_PMC, NAME, __OFFSET__, __WIDTH__)
#define DEFINE_PMC_REG_BIT_ENUM(NAME, __OFFSET__, ZERO, ONE)                                                                                                         REG_DEFINE_NAMED_BIT_ENUM      (APBDEV_PMC, NAME, __OFFSET__, ZERO, ONE)
#define DEFINE_PMC_REG_TWO_BIT_ENUM(NAME, __OFFSET__, ZERO, ONE, TWO, THREE)                                                                                         REG_DEFINE_NAMED_TWO_BIT_ENUM  (APBDEV_PMC, NAME, __OFFSET__, ZERO, ONE, TWO, THREE)
#define DEFINE_PMC_REG_THREE_BIT_ENUM(NAME, __OFFSET__, ZERO, ONE, TWO, THREE, FOUR, FIVE, SIX, SEVEN)                                                               REG_DEFINE_NAMED_THREE_BIT_ENUM(APBDEV_PMC, NAME, __OFFSET__, ZERO, ONE, TWO, THREE, FOUR, FIVE, SIX, SEVEN)
#define DEFINE_PMC_REG_FOUR_BIT_ENUM(NAME, __OFFSET__, ZERO, ONE, TWO, THREE, FOUR, FIVE, SIX, SEVEN, EIGHT, NINE, TEN, ELEVEN, TWELVE, THIRTEEN, FOURTEEN, FIFTEEN) REG_DEFINE_NAMED_FOUR_BIT_ENUM (APBDEV_PMC, NAME, __OFFSET__, ZERO, ONE, TWO, THREE, FOUR, FIVE, SIX, SEVEN, EIGHT, NINE, TEN, ELEVEN, TWELVE, THIRTEEN, FOURTEEN, FIFTEEN)

DEFINE_PMC_REG_BIT_ENUM(CNTRL_MAIN_RESET, 4, DISABLE, ENABLE)

DEFINE_PMC_REG_BIT_ENUM(DPD_SAMPLE_ON, 0, DISABLE, ENABLE);

DEFINE_PMC_REG_BIT_ENUM(DPD_ENABLE_ON,          0, DISABLE, ENABLE);
DEFINE_PMC_REG_BIT_ENUM(DPD_ENABLE_TSC_MULT_EN, 1, DISABLE, ENABLE);

DEFINE_PMC_REG_BIT_ENUM(PWRGATE_TOGGLE_START, 8, DISABLE, ENABLE);

DEFINE_PMC_REG(PWRGATE_TOGGLE_PARTID, 0, 5);

enum APBDEV_PMC_PWRGATE_TOGGLE_PARTID : u8 {
    APBDEV_PMC_PWRGATE_TOGGLE_PARTID_CRAIL  =  0,
    APBDEV_PMC_PWRGATE_TOGGLE_PARTID_VE     =  2,
    APBDEV_PMC_PWRGATE_TOGGLE_PARTID_PCX    =  3,
    APBDEV_PMC_PWRGATE_TOGGLE_PARTID_MPE    =  6,
    APBDEV_PMC_PWRGATE_TOGGLE_PARTID_SAX    =  8,
    APBDEV_PMC_PWRGATE_TOGGLE_PARTID_CE1    =  9,
    APBDEV_PMC_PWRGATE_TOGGLE_PARTID_CE2    = 10,
    APBDEV_PMC_PWRGATE_TOGGLE_PARTID_CE3    = 11,
    APBDEV_PMC_PWRGATE_TOGGLE_PARTID_CE0    = 14,
    APBDEV_PMC_PWRGATE_TOGGLE_PARTID_C0NC   = 15,
    APBDEV_PMC_PWRGATE_TOGGLE_PARTID_SOR    = 17,
    APBDEV_PMC_PWRGATE_TOGGLE_PARTID_DIS    = 18,
    APBDEV_PMC_PWRGATE_TOGGLE_PARTID_DISB   = 19,
    APBDEV_PMC_PWRGATE_TOGGLE_PARTID_XUSBA  = 20,
    APBDEV_PMC_PWRGATE_TOGGLE_PARTID_XUSBB  = 21,
    APBDEV_PMC_PWRGATE_TOGGLE_PARTID_XUSBC  = 22,
    APBDEV_PMC_PWRGATE_TOGGLE_PARTID_VIC    = 23,
    APBDEV_PMC_PWRGATE_TOGGLE_PARTID_IRAM   = 24,
    APBDEV_PMC_PWRGATE_TOGGLE_PARTID_NVDEC  = 25,
    APBDEV_PMC_PWRGATE_TOGGLE_PARTID_NVJPG  = 26,
    APBDEV_PMC_PWRGATE_TOGGLE_PARTID_AUD    = 27,
    APBDEV_PMC_PWRGATE_TOGGLE_PARTID_DFD    = 28,
    APBDEV_PMC_PWRGATE_TOGGLE_PARTID_VE2    = 29,
};

DEFINE_PMC_REG_BIT_ENUM(REMOVE_CLAMPING_COMMAND_CRAIL, 0, DISABLE, ENABLE);

enum APBDEV_PMC_PWRGATE_STATUS_STATUS {
    APBDEV_PMC_PWRGATE_STATUS_STATUS_OFF = 0,
    APBDEV_PMC_PWRGATE_STATUS_STATUS_ON  = 1,
};

DEFINE_PMC_REG_BIT_ENUM(PWRGATE_STATUS_CRAIL,  0, OFF, ON);
DEFINE_PMC_REG_BIT_ENUM(PWRGATE_STATUS_VE,     2, OFF, ON);
DEFINE_PMC_REG_BIT_ENUM(PWRGATE_STATUS_PCX,    3, OFF, ON);
DEFINE_PMC_REG_BIT_ENUM(PWRGATE_STATUS_MPE,    6, OFF, ON);
DEFINE_PMC_REG_BIT_ENUM(PWRGATE_STATUS_SAX,    8, OFF, ON);
DEFINE_PMC_REG_BIT_ENUM(PWRGATE_STATUS_CE1,    9, OFF, ON);
DEFINE_PMC_REG_BIT_ENUM(PWRGATE_STATUS_CE2,   10, OFF, ON);
DEFINE_PMC_REG_BIT_ENUM(PWRGATE_STATUS_CE3,   11, OFF, ON);
DEFINE_PMC_REG_BIT_ENUM(PWRGATE_STATUS_CE0,   14, OFF, ON);
DEFINE_PMC_REG_BIT_ENUM(PWRGATE_STATUS_C0NC,  15, OFF, ON);
DEFINE_PMC_REG_BIT_ENUM(PWRGATE_STATUS_SOR,   17, OFF, ON);
DEFINE_PMC_REG_BIT_ENUM(PWRGATE_STATUS_DIS,   18, OFF, ON);
DEFINE_PMC_REG_BIT_ENUM(PWRGATE_STATUS_DISB,  19, OFF, ON);
DEFINE_PMC_REG_BIT_ENUM(PWRGATE_STATUS_XUSBA, 20, OFF, ON);
DEFINE_PMC_REG_BIT_ENUM(PWRGATE_STATUS_XUSBB, 21, OFF, ON);
DEFINE_PMC_REG_BIT_ENUM(PWRGATE_STATUS_XUSBC, 22, OFF, ON);
DEFINE_PMC_REG_BIT_ENUM(PWRGATE_STATUS_VIC,   23, OFF, ON);
DEFINE_PMC_REG_BIT_ENUM(PWRGATE_STATUS_IRAM,  24, OFF, ON);
DEFINE_PMC_REG_BIT_ENUM(PWRGATE_STATUS_NVDEC, 25, OFF, ON);
DEFINE_PMC_REG_BIT_ENUM(PWRGATE_STATUS_NVJPG, 26, OFF, ON);
DEFINE_PMC_REG_BIT_ENUM(PWRGATE_STATUS_AUD,   27, OFF, ON);
DEFINE_PMC_REG_BIT_ENUM(PWRGATE_STATUS_DFD,   28, OFF, ON);
DEFINE_PMC_REG_BIT_ENUM(PWRGATE_STATUS_VE2,   29, OFF, ON);

DEFINE_PMC_REG(PWRGATE_STATUS_CE123, 9, 3);

DEFINE_PMC_REG_BIT_ENUM(NO_IOPOWER_SDMMC1,  12, DISABLE, ENABLE);
DEFINE_PMC_REG_BIT_ENUM(PWR_DET_SDMMC1,     12, DISABLE, ENABLE);
DEFINE_PMC_REG_BIT_ENUM(PWR_DET_VAL_SDMMC1, 12, DISABLE, ENABLE);

DEFINE_PMC_REG(SET_SW_CLAMP_CRAIL, 0, 1);

DEFINE_PMC_REG_TWO_BIT_ENUM(IO_DPD_REQ_CODE,  30, IDLE, DPD_OFF, DPD_ON, RESERVED3);
DEFINE_PMC_REG_TWO_BIT_ENUM(IO_DPD2_REQ_CODE, 30, IDLE, DPD_OFF, DPD_ON, RESERVED3);

DEFINE_PMC_REG_BIT_ENUM(CLAMP_STATUS_CRAIL,  0, DISABLE, ENABLE);
DEFINE_PMC_REG_BIT_ENUM(CLAMP_STATUS_TE,     1, DISABLE, ENABLE);
DEFINE_PMC_REG_BIT_ENUM(CLAMP_STATUS_VE,     2, DISABLE, ENABLE);
DEFINE_PMC_REG_BIT_ENUM(CLAMP_STATUS_PCX,    3, DISABLE, ENABLE);
DEFINE_PMC_REG_BIT_ENUM(CLAMP_STATUS_VDE,    4, DISABLE, ENABLE);
DEFINE_PMC_REG_BIT_ENUM(CLAMP_STATUS_MPE,    6, DISABLE, ENABLE);
DEFINE_PMC_REG_BIT_ENUM(CLAMP_STATUS_HEG,    7, DISABLE, ENABLE);
DEFINE_PMC_REG_BIT_ENUM(CLAMP_STATUS_SAX,    8, DISABLE, ENABLE);
DEFINE_PMC_REG_BIT_ENUM(CLAMP_STATUS_CE1,    9, DISABLE, ENABLE);
DEFINE_PMC_REG_BIT_ENUM(CLAMP_STATUS_CE2,   10, DISABLE, ENABLE);
DEFINE_PMC_REG_BIT_ENUM(CLAMP_STATUS_CE3,   11, DISABLE, ENABLE);
DEFINE_PMC_REG_BIT_ENUM(CLAMP_STATUS_CELP,  12, DISABLE, ENABLE);
DEFINE_PMC_REG_BIT_ENUM(CLAMP_STATUS_CE0,   14, DISABLE, ENABLE);
DEFINE_PMC_REG_BIT_ENUM(CLAMP_STATUS_C0NC,  15, DISABLE, ENABLE);
DEFINE_PMC_REG_BIT_ENUM(CLAMP_STATUS_SOR,   17, DISABLE, ENABLE);
DEFINE_PMC_REG_BIT_ENUM(CLAMP_STATUS_C1NC,  16, DISABLE, ENABLE);
DEFINE_PMC_REG_BIT_ENUM(CLAMP_STATUS_DIS,   18, DISABLE, ENABLE);
DEFINE_PMC_REG_BIT_ENUM(CLAMP_STATUS_DISB,  19, DISABLE, ENABLE);
DEFINE_PMC_REG_BIT_ENUM(CLAMP_STATUS_XUSBA, 20, DISABLE, ENABLE);
DEFINE_PMC_REG_BIT_ENUM(CLAMP_STATUS_XUSBB, 21, DISABLE, ENABLE);
DEFINE_PMC_REG_BIT_ENUM(CLAMP_STATUS_XUSBC, 22, DISABLE, ENABLE);
DEFINE_PMC_REG_BIT_ENUM(CLAMP_STATUS_VIC,   23, DISABLE, ENABLE);
DEFINE_PMC_REG_BIT_ENUM(CLAMP_STATUS_IRAM,  24, DISABLE, ENABLE);

DEFINE_PMC_REG(OSC_EDPD_OVER_XOFS, 1, 6);
DEFINE_PMC_REG_BIT_ENUM(OSC_EDPD_OVER_OSC_CTRL_SELECT, 22, CAR, PMC);

DEFINE_PMC_REG(TSC_MULT_MULT_VAL, 0, 16);

DEFINE_PMC_REG_BIT_ENUM(STICKY_BITS_HDA_LPBK_DIS, 0, DISABLE, ENABLE);
DEFINE_PMC_REG_BIT_ENUM(STICKY_BITS_JTAG_STS, 6, ENABLE, DISABLE);

DEFINE_PMC_REG_BIT_ENUM(CNTRL2_WAKE_DET_EN,  9, DISABLE, ENABLE);
DEFINE_PMC_REG_BIT_ENUM(CNTRL2_HOLD_CKE_LOW_EN, 12, DISABLE, ENABLE);

DEFINE_PMC_REG_BIT_ENUM(SEC_DISABLE2_WRITE21, 26, OFF, ON);

DEFINE_PMC_REG(TZRAM_PWR_CNTRL_TZRAM_SD, 0, 1);
DEFINE_PMC_REG(TZRAM_PWR_CNTRL_TZRAM_SLCG_OVR, 1, 1);

DEFINE_PMC_REG_BIT_ENUM(TZRAM_SEC_DISABLE_SD_WRITE, 0, OFF, ON);
DEFINE_PMC_REG_BIT_ENUM(TZRAM_SEC_DISABLE_SD_READ, 1, OFF, ON);

DEFINE_PMC_REG_BIT_ENUM(TZRAM_NON_SEC_DISABLE_SD_WRITE, 0, OFF, ON);
DEFINE_PMC_REG_BIT_ENUM(TZRAM_NON_SEC_DISABLE_SD_READ, 1, OFF, ON);
