/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.hostid;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.HostId;

public abstract class SimpleHostId
extends HostId
implements FlexlmConstants {
    private String value;

    public SimpleHostId(String string) throws FlexlmException {
        this.initHostId(string);
    }

    protected void initHostId(String string) throws FlexlmException {
        String string2 = this.getKeyword();
        if (!string.startsWith(string2 + "=")) {
            throw new FlexlmException(-504, 2014);
        }
        String string3 = string.substring(string.indexOf("=") + 1);
        this.initHostIdValue(string3);
    }

    protected void initHostIdValue(String string) throws FlexlmException {
        if (string == null || string.length() < 1) {
            throw new FlexlmException(-503, 2015);
        }
        this.value = string;
    }

    public HostId createNew(String string) throws FlexlmException {
        try {
            SimpleHostId simpleHostId = (SimpleHostId)this.getClass().newInstance();
            simpleHostId.initHostId(string);
            return simpleHostId;
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException.getClass().getName() + ": " + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.getClass().getName() + ": " + illegalAccessException.getMessage());
        }
    }

    public boolean isCurrentHost() {
        HostId[] hostIdArray = this.getCurrentHostIds();
        if (hostIdArray == null) {
            return false;
        }
        int n = 0;
        while (n < hostIdArray.length) {
            if (this.matches(hostIdArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public HostId[] getCurrentHostIds() {
        try {
            HostId hostId = this.getCurrentHostId();
            if (hostId == null) {
                return null;
            }
            HostId[] hostIdArray = new HostId[]{hostId};
            return hostIdArray;
        }
        catch (FlexlmException flexlmException) {
            return null;
        }
    }

    protected HostId getCurrentHostId() throws FlexlmException {
        return null;
    }

    public Object getValue() {
        return this.value;
    }
}

