/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.lictext;

import com.certicom.ecc.jcae.Certicom;
import com.certicom.ecc.system.SystemConfig;
import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.VendorInfo;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

public class PriKey
implements FlexlmConstants {
    static final String CVSId = "$Id";
    protected static String certicomName;
    protected static final String signatureAlgorithmName = "ECDSA";

    public static boolean pubkeyVerify(byte[] byArray, byte[] byArray2, VendorInfo vendorInfo, int n) throws FlexlmException {
        boolean bl;
        PublicKey publicKey;
        KeyFactory keyFactory;
        String string;
        String string2 = PriKey.initCerticom();
        if (string2 == null) {
            throw new FlexlmException(-514, 4026);
        }
        switch (n) {
            case 2: {
                string = "sect113r1";
                break;
            }
            case 3: {
                string = "ec163a02";
                break;
            }
            case 4: {
                string = "ec239a03";
                break;
            }
            default: {
                throw new FlexlmException(-515, 4027);
            }
        }
        SystemConfig systemConfig = SystemConfig.getConfig();
        systemConfig.setCurve(string);
        systemConfig.setConformance(16);
        systemConfig.setPtCompression(2);
        systemConfig.setFormat(10);
        PublicKey publicKey2 = vendorInfo.getPublicKey(n);
        if (publicKey2 == null) {
            throw new FlexlmException(-515, 4028);
        }
        byte[] byArray3 = publicKey2.getEncoded();
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray3);
        try {
            keyFactory = KeyFactory.getInstance(signatureAlgorithmName);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new FlexlmException(-515, 4029);
        }
        try {
            publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new FlexlmException(-515, 4030);
        }
        try {
            Signature signature = Signature.getInstance(signatureAlgorithmName, string2);
            signature.initVerify(publicKey);
            signature.update(byArray);
            bl = signature.verify(byArray2);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new FlexlmException(-515, 4031);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new FlexlmException(-515, 4032);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new FlexlmException(-515, 4033);
        }
        catch (SignatureException signatureException) {
            throw new FlexlmException(-515, 4034);
        }
        return bl;
    }

    protected static String initCerticom() {
        if (certicomName != null) {
            return certicomName;
        }
        Certicom certicom = new Certicom();
        if (Security.addProvider((Provider)certicom) >= 0) {
            // empty if block
        }
        certicomName = certicom.getName();
        return certicomName;
    }

    public static void printBytes(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            System.out.print(Integer.toString(byArray[i] & 0xFF, 16));
            System.out.print(" ");
        }
    }

    public static void printBytes(String string, byte[] byArray) {
        System.out.print(string + " = { ");
        PriKey.printBytes(byArray);
        System.out.println(" }");
    }
}

