/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.btbeacon;

import com.aastra.oamp.btbeacon.BtBeaconConfigMainPanel;
import com.aastra.oamp.btbeacon.BtBeaconDetailPanel;
import com.aastra.oamp.guiutil.GuiUtilChangeHandler;
import com.aastra.oamp.guiutil.GuiUtilTextField;
import com.aastra.oamp.guiutil.GuiUtilTristateCheckBox;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilMisc;
import com.aastra.omilib.BluetoothBeaconHandler;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.OmiMessage;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraSlider;
import com.aastra.util.UtilSpy;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BtBeaconConfigDetailPanel
extends BtBeaconDetailPanel {
    private static final long serialVersionUID = 1L;
    private CommonDataHandler commonDataHandler = null;
    private BtBeaconConfigMainPanel btBeaconMainPanel = null;
    private BluetoothBeaconHandler.BtBeaconRec[] btBeaconRecords = null;
    private UtilErrorComp utilErrorComp = null;
    private int selectedBtBeacon = -1;
    private boolean actionListenerRssiThreshold = false;
    private int selectedBtBeaconNum = 0;
    private int oldRSSIThreshold = 0;
    private ActionModeEnum actionMode;
    private static final int TAB_GENERAL = 0;

    public BtBeaconConfigDetailPanel(BtBeaconConfigMainPanel btBeaconConfigMainPanel, CommonDataHandler commonDataHandler, UtilErrorComp utilErrorComp) {
        this.btBeaconMainPanel = btBeaconConfigMainPanel;
        this.commonDataHandler = commonDataHandler;
        this.utilErrorComp = utilErrorComp;
        this.initialize();
    }

    private void initialize() {
        this.utilChangeHandler = new GuiUtilChangeHandler(this.getButtonOK(), this.getButtonCancel(), false);
        this.panelTabbed.addTab(UtilLocale.getString("TXT_GENERAL"), null, this.getTabGeneral(), null);
        this.panelTabbed.addTab(UtilLocale.getString("TXT_SENSITIVITY"), null, this.getTabSensitivity(), null);
        this.panelButtonBar.add((Component)this.getButtonOK(), null);
        this.panelButtonBar.add((Component)this.getButtonCancel(), null);
    }

    @Override
    protected AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            super.getButtonOK();
            this.buttonOK.setBounds(70, 15, 90, 25);
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BtBeaconConfigDetailPanel.this.utilChangeHandler.deactivate();
                    BtBeaconConfigDetailPanel.this.utilErrorComp.clearComponents();
                    if (BtBeaconConfigDetailPanel.this.actionMode == ActionModeEnum.CHANGE) {
                        BtBeaconConfigDetailPanel.this.btBeaconMainPanel.changeBtBeacon();
                    } else {
                        BtBeaconConfigDetailPanel.this.btBeaconMainPanel.createBtBeacon();
                    }
                }
            });
        }
        return this.buttonOK;
    }

    @Override
    protected AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            super.getButtonCancel();
            this.buttonCancel.setBounds(230, 15, 90, 25);
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BtBeaconConfigDetailPanel.this.utilChangeHandler.deactivate();
                    BtBeaconConfigDetailPanel.this.btBeaconMainPanel.removeBtBeaconDetailPanel();
                }
            });
        }
        return this.buttonCancel;
    }

    public void setBtBeaconDetailData(DataRecord[] dataRecordArray) {
        CommonDataHandler.BlueToothSensitivityClass blueToothSensitivityClass = this.getBTSensitivity();
        if (blueToothSensitivityClass != null) {
            this.sliderRSSIThreshold.setTicksAndLabels(blueToothSensitivityClass.rfpSens.high, blueToothSensitivityClass.rfpSens.low);
            this.sliderRSSIThreshold.setMinorTickSpacing(-(blueToothSensitivityClass.rfpSens.high - blueToothSensitivityClass.rfpSens.low) / 4);
        }
        if (dataRecordArray != null) {
            this.btBeaconRecords = new BluetoothBeaconHandler.BtBeaconRec[dataRecordArray.length];
            for (int i = 0; i < this.btBeaconRecords.length; ++i) {
                this.btBeaconRecords[i] = (BluetoothBeaconHandler.BtBeaconRec)dataRecordArray[i].clone();
            }
            this.selectedBtBeacon = (Integer)dataRecordArray[0].getField(0);
            this.selectedBtBeaconNum = dataRecordArray.length;
            this.textFieldName.setText((String)UtilMisc.getRecordsFieldObject(dataRecordArray, 3));
            if (dataRecordArray.length == 1) {
                this.labelHeaderBar.setText(String.format(UtilLocale.getString("TXT_BLUETOOTH_BEACON") + " #0x%03X", (Integer)dataRecordArray[0].getField(0)));
                String string = (String)dataRecordArray[0].getField(4);
                if (string.length() <= 0) {
                    this.textFieldBuilding.setText("");
                    this.disableTextFieldFloor();
                    this.disableTextFieldRoom();
                } else {
                    this.textFieldBuilding.setText(string);
                    this.textFieldFloor.setEditable(true);
                    String string2 = (String)dataRecordArray[0].getField(5);
                    if (string2.length() <= 0) {
                        this.textFieldFloor.setText("");
                        this.disableTextFieldRoom();
                    } else {
                        this.textFieldFloor.setText(string2);
                        this.textFieldRoom.setEditable(true);
                        this.textFieldRoom.setText((String)dataRecordArray[0].getField(6));
                    }
                }
            } else if (dataRecordArray.length > 1) {
                String string = " ";
                for (int i = 0; i < dataRecordArray.length; ++i) {
                    string = string + String.format("#0x%03X ", (Integer)dataRecordArray[i].getField(0));
                    if (i <= 3) continue;
                    string = string + " ...";
                    break;
                }
                this.labelHeaderBar.setText(UtilLocale.getString("TXT_BLUETOOTH_BEACONS") + string);
                this.textFieldBuilding.setText((String)UtilMisc.getRecordsFieldObject(dataRecordArray, 4));
                this.disableTextFieldFloor();
                this.disableTextFieldRoom();
            }
            this.checkBoxCheckpoint.setState(UtilMisc.getRecordsFieldState(dataRecordArray, 11));
            Integer n = (Integer)UtilMisc.getRecordsFieldObject(dataRecordArray, 8);
            this.actionListenerRssiThreshold = false;
            if (n != 0) {
                this.sliderRSSIThreshold.setValue(n);
                this.labelRssiThresholdValue.setText("" + n + " dBm");
            } else {
                this.sliderRSSIThreshold.setValue(-64);
                this.labelRssiThresholdValue.setText(AastraCommon.AastraTriStateText + " dBm");
            }
            this.actionListenerRssiThreshold = true;
            this.actionMode = ActionModeEnum.CHANGE;
        } else {
            this.btBeaconRecords = new BluetoothBeaconHandler.BtBeaconRec[1];
            this.btBeaconRecords[0] = new BluetoothBeaconHandler.BtBeaconRec();
            this.labelHeaderBar.setText(UtilLocale.getString("TXT_NEW_BLUETOOTH_BEACON"));
            this.textFieldName.setText("");
            this.textFieldBuilding.setText("");
            this.disableTextFieldFloor();
            this.disableTextFieldRoom();
            this.actionListenerRssiThreshold = false;
            this.sliderRSSIThreshold.setValue(-64);
            this.actionListenerRssiThreshold = true;
            this.labelRssiThresholdValue.setText(String.format("%s dBm", -64));
            this.checkBoxCheckpoint.setSelected(false);
            this.actionMode = ActionModeEnum.CREATE;
        }
        this.utilChangeHandler.initRootPane(this.getRootPane());
        this.utilChangeHandler.deactivate();
    }

    public DataRecord[] getBtBeaconDetailData() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!this.textFieldName.getText().equals(AastraCommon.AastraTriStateText)) {
            bl = true;
        }
        bl2 = this.textFieldBuilding.isChange();
        String string = this.textFieldBuilding.getText();
        if (!string.equals(AastraCommon.AastraTriStateText)) {
            if (bl2) {
                bl3 = true;
                bl4 = true;
            }
            if (this.textFieldFloor.isChange()) {
                bl3 = true;
                bl4 = true;
            }
            if (this.textFieldRoom.isChange()) {
                bl4 = true;
            }
        }
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (bl2 && (string = this.textFieldBuilding.getText()) != null) {
            string2 = string;
        }
        if (bl3 && (string = this.textFieldFloor.getText()) != null) {
            string3 = string;
        }
        if (bl4 && (string = this.textFieldRoom.getText()) != null) {
            string4 = string;
        }
        boolean bl5 = !this.labelRssiThresholdValue.getText().contains(AastraCommon.AastraTriStateText);
        for (int i = 0; i < this.btBeaconRecords.length; ++i) {
            if (bl) {
                this.btBeaconRecords[i].setField(3, this.textFieldName.getText());
            }
            if (bl2) {
                this.btBeaconRecords[i].setField(4, string2);
            }
            if (bl3) {
                this.btBeaconRecords[i].setField(5, string3);
            }
            if (bl4) {
                this.btBeaconRecords[i].setField(6, string4);
            }
            if (bl5) {
                this.btBeaconRecords[i].setField(8, this.sliderRSSIThreshold.getValue());
            }
            UtilMisc.setRecordFromTristateCheckbox(this.btBeaconRecords[i], this.checkBoxCheckpoint, 11);
        }
        return this.btBeaconRecords;
    }

    public int getSelectedBtBeacon() {
        return this.selectedBtBeacon;
    }

    @Override
    protected AastraPanel getTabGeneral() {
        if (this.tabGeneral == null) {
            super.getTabGeneral();
            this.utilErrorComp.putWithTab(OmiMessage.BtBeaconType.name.toString(), this.labelName, this.textFieldName, 0);
            this.utilErrorComp.putWithTab(OmiMessage.BtBeaconType.hierarchy1.toString(), this.labelBuilding, this.textFieldBuilding, 0);
            this.utilErrorComp.putWithTab(OmiMessage.BtBeaconType.hierarchy2.toString(), this.labelFloor, this.textFieldFloor, 0);
            this.utilErrorComp.putWithTab(OmiMessage.BtBeaconType.hierarchy3.toString(), this.labelRoom, this.textFieldRoom, 0);
        }
        return this.tabGeneral;
    }

    @Override
    protected GuiUtilTextField getTextFieldBuilding() {
        if (this.textFieldBuilding == null) {
            super.getTextFieldBuilding();
            this.textFieldBuilding.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    String string;
                    char c = keyEvent.getKeyChar();
                    if (c != '\n' && BtBeaconConfigDetailPanel.this.utilChangeHandler != null) {
                        BtBeaconConfigDetailPanel.this.utilChangeHandler.activate();
                    }
                    if ((string = BtBeaconConfigDetailPanel.this.textFieldBuilding.getText()).length() > 0) {
                        BtBeaconConfigDetailPanel.this.textFieldFloor.setEditable(true);
                    } else {
                        BtBeaconConfigDetailPanel.this.disableTextFieldFloor();
                        BtBeaconConfigDetailPanel.this.disableTextFieldRoom();
                    }
                }
            });
        }
        return this.textFieldBuilding;
    }

    @Override
    protected GuiUtilTextField getTextFieldFloor() {
        if (this.textFieldFloor == null) {
            super.getTextFieldFloor();
            this.textFieldFloor.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    String string;
                    char c = keyEvent.getKeyChar();
                    if (c != '\n' && BtBeaconConfigDetailPanel.this.utilChangeHandler != null) {
                        BtBeaconConfigDetailPanel.this.utilChangeHandler.activate();
                    }
                    if ((string = BtBeaconConfigDetailPanel.this.textFieldFloor.getText()).length() > 0) {
                        BtBeaconConfigDetailPanel.this.textFieldRoom.setEditable(true);
                    } else {
                        BtBeaconConfigDetailPanel.this.disableTextFieldRoom();
                    }
                }
            });
        }
        return this.textFieldFloor;
    }

    @Override
    protected GuiUtilTextField getTextFieldRoom() {
        if (this.textFieldRoom == null) {
            super.getTextFieldRoom();
            this.textFieldRoom.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    char c = keyEvent.getKeyChar();
                    if (c != '\n' && BtBeaconConfigDetailPanel.this.utilChangeHandler != null) {
                        BtBeaconConfigDetailPanel.this.utilChangeHandler.activate();
                    }
                }
            });
        }
        return this.textFieldRoom;
    }

    @Override
    protected BtBeaconDetailPanel.TabSensitivityPanel getTabSensitivity() {
        if (this.tabSensitivity == null) {
            super.getTabSensitivity();
        }
        return this.tabSensitivity;
    }

    @Override
    protected GuiUtilTristateCheckBox getCheckBoxCheckpoint() {
        if (this.checkBoxCheckpoint == null) {
            super.getCheckBoxCheckpoint();
            this.checkBoxCheckpoint.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    CommonDataHandler.BlueToothSensitivityClass blueToothSensitivityClass = BtBeaconConfigDetailPanel.this.getBTSensitivity();
                    if (blueToothSensitivityClass != null) {
                        if (itemEvent.getStateChange() == 1) {
                            BtBeaconConfigDetailPanel.this.sliderRSSIThreshold.setTicksAndLabels(-99, -3);
                            BtBeaconConfigDetailPanel.this.oldRSSIThreshold = BtBeaconConfigDetailPanel.this.sliderRSSIThreshold.getValue();
                            BtBeaconConfigDetailPanel.this.sliderRSSIThreshold.setValue(blueToothSensitivityClass.rfpSens.checkpoint);
                            BtBeaconConfigDetailPanel.this.sliderRSSIThreshold.setMinorTickSpacing(12);
                        } else {
                            BtBeaconConfigDetailPanel.this.sliderRSSIThreshold.setTicksAndLabels(blueToothSensitivityClass.rfpSens.high, blueToothSensitivityClass.rfpSens.low);
                            if (BtBeaconConfigDetailPanel.this.selectedBtBeaconNum > 1) {
                                BtBeaconConfigDetailPanel.this.sliderRSSIThreshold.setValue(-99);
                            } else if (BtBeaconConfigDetailPanel.this.oldRSSIThreshold != 0) {
                                BtBeaconConfigDetailPanel.this.sliderRSSIThreshold.setValue(BtBeaconConfigDetailPanel.this.oldRSSIThreshold);
                            } else {
                                BtBeaconConfigDetailPanel.this.sliderRSSIThreshold.setValue(-99);
                            }
                            BtBeaconConfigDetailPanel.this.sliderRSSIThreshold.setMinorTickSpacing(-(blueToothSensitivityClass.rfpSens.high - blueToothSensitivityClass.rfpSens.low) / 4);
                        }
                    }
                }
            });
        }
        return this.checkBoxCheckpoint;
    }

    @Override
    protected AastraSlider getSliderRssiThreshold() {
        if (this.sliderRSSIThreshold == null) {
            super.getSliderRssiThreshold();
            this.sliderRSSIThreshold.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    BtBeaconConfigDetailPanel.this.labelRssiThresholdValue.setText("" + ((AastraSlider)changeEvent.getSource()).getValue() + " dBm");
                    if (BtBeaconConfigDetailPanel.this.actionListenerRssiThreshold) {
                        BtBeaconConfigDetailPanel.this.getButtonOK().setEnabled(true);
                        BtBeaconConfigDetailPanel.this.getButtonCancel().setEnabled(true);
                    }
                }
            });
        }
        return this.sliderRSSIThreshold;
    }

    private CommonDataHandler.BlueToothSensitivityClass getBTSensitivity() {
        CommonDataHandler.BlueToothSensitivityClass blueToothSensitivityClass = null;
        try {
            blueToothSensitivityClass = (CommonDataHandler.BlueToothSensitivityClass)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.BlueToothSensitivity);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.BlueToothSensitivity.toString() + "='" + blueToothSensitivityClass + "'");
        }
        catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.BlueToothSensitivity.toString() + " failed");
        }
        return blueToothSensitivityClass;
    }

    public void requestDefaultFocusInWindow() {
        this.textFieldName.requestFocusInWindow();
    }

    public void markErrorComponent(String string) {
        JComponent jComponent = this.utilErrorComp.getField(string);
        if (jComponent != null) {
            this.panelTabbed.setSelectedIndex(this.utilErrorComp.getTab(string));
            this.utilErrorComp.markComponent(jComponent);
        }
    }

    public String getErrorLabelText(String string) {
        if (string == null) {
            return null;
        }
        return this.utilErrorComp.getLabelText(string);
    }

    private void disableTextFieldFloor() {
        this.textFieldFloor.setText("");
        this.textFieldFloor.setEditable(false);
        this.utilErrorComp.clearComponent(this.textFieldFloor);
    }

    private void disableTextFieldRoom() {
        this.textFieldRoom.setText("");
        this.textFieldRoom.setEditable(false);
        this.utilErrorComp.clearComponent(this.textFieldRoom);
    }

    private static enum ActionModeEnum {
        CREATE,
        CHANGE;

    }
}

