/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.btbeacon;

import com.aastra.oamp.btbeacon.BtBeaconConfigDetailPanel;
import com.aastra.oamp.btbeacon.BtBeaconConfigTaskPanel;
import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.gui.GuiProgressDlgCancel;
import com.aastra.oamp.gui.GuiStatusBar;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilFilterTable;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.oamp.util.UtilPrint;
import com.aastra.omilib.BluetoothBeaconHandler;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.BitSet;
import java.util.HashMap;

public class BtBeaconConfigMainPanel
extends AastraPanel
implements CommonDataHandler.CommonDataNotificationInterface,
BluetoothBeaconHandler.BtBeaconNotificationInterface,
ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface,
GuiComponentActivationInterface,
DataHandler.DataHandlerSendBulkInterface,
GuiProgressDlgCancel.GuiProgressDlgCancelInterface {
    private static final long serialVersionUID = 1L;
    public static final int SLIDER_RSSI_THRESHOLD_EMPTY_VALUE = -64;
    protected static final int xSizeDetailPanelSurcharge = 285;
    protected static final int ySizeDetailPanelSurcharge = 100;
    protected static final int ySizeDetailPanel = 310;
    private BluetoothBeaconHandler btBeaconHandler = null;
    private BluetoothBeaconHandler.BtBeaconDatabase btBeaconDatabase = null;
    private GuiStatusBar guiStatusBar = null;
    private GuiUtilDetailSplitPanel btBeaconDetailSplitPane = null;
    private AastraScrollPane btBeaconTablePane = null;
    private BtBeaconConfigDetailPanel btBeaconDetailPanel = null;
    private BtBeaconConfigTaskPanel btBeaconTaskPanel = null;
    private GuiUtilConfiguratorTable btBeaconTable = null;
    private boolean detailPanelPending = false;
    private HashMap<Integer, Boolean> btBeaconIdsPending = new HashMap();
    private int dividerLocation = 0;
    private GuiProgressDlgCancel guiProgressDlg = null;
    private int cntNotificationsToReceive = 0;
    private BluetoothBeaconHandler.BtBeaconRec[] btBeaconRecordsChange = null;
    private CommonDataHandler commonDataHandler = null;
    private int cntBtBeaconsSendBulkTotal;
    private DataHandler.SendBulkActionType sendBulkAction = null;
    private UtilErrorComp utilErrorComp = null;
    public static int[] btBeaconTableConfigIdxArray = new int[]{0, 1, 2, 8, 11, 3, 4, 5, 6, 10};
    public static int[] btBeaconTableConfigIdxArrayDefault = new int[]{0, 2, 3, 4, 5, 6, 10};

    public BtBeaconConfigMainPanel(BluetoothBeaconHandler bluetoothBeaconHandler, CommonDataHandler commonDataHandler) {
        this.guiStatusBar = GuiMain.getGuiStatusBarObject();
        this.btBeaconHandler = bluetoothBeaconHandler;
        this.commonDataHandler = commonDataHandler;
        this.btBeaconHandler.registerDataNotificationListener(this);
        this.btBeaconDatabase = (BluetoothBeaconHandler.BtBeaconDatabase)this.btBeaconHandler.getDb();
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.BlueToothGlobal, this);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getBtBeaconDetailSplitPane(), "Center");
        this.add((Component)this.getBtBeaconTaskPanel(), "East");
        this.utilErrorComp = new UtilErrorComp();
    }

    public void setDetailPanelPending() {
        this.detailPanelPending = true;
    }

    public void clearDetailPanelPending() {
        this.detailPanelPending = false;
        this.btBeaconIdsPending.clear();
    }

    private void processTableEvent() {
        boolean bl;
        boolean bl2;
        int n = this.btBeaconTable.getSelectedRowCount();
        int[] nArray = this.btBeaconTable.getSelectedRows();
        if (n > 0) {
            bl2 = true;
            DataRecord[] dataRecordArray = new DataRecord[n];
            for (int i = 0; i < n; ++i) {
                int n2 = this.btBeaconTable.convertRowIndexToModel(nArray[i]);
                dataRecordArray[i] = this.btBeaconDatabase.getRecordByIdx(n2);
                OmiMessage.BtBeaconStateType btBeaconStateType = (OmiMessage.BtBeaconStateType)((Object)((BluetoothBeaconHandler.BtBeaconRec)dataRecordArray[i]).getField(10));
                if (btBeaconStateType == null || btBeaconStateType == OmiMessage.BtBeaconStateType.unplugged) continue;
                bl2 = false;
            }
            if (this.btBeaconDetailSplitPane.getBottomComponent() != null) {
                this.createBtBeaconDetailPanel(dataRecordArray);
                bl = false;
            } else {
                bl = true;
            }
        } else {
            bl = false;
            bl2 = false;
            if (this.btBeaconDetailSplitPane.getBottomComponent() != null) {
                this.removeBtBeaconDetailPanel();
            }
        }
        this.btBeaconTaskPanel.setTaskButtonConfigure(bl);
        this.btBeaconTaskPanel.setTaskButtonDelete(bl2);
    }

    public void configureBtBeacon() {
        int n = this.btBeaconTable.getSelectedRowCount();
        DataRecord[] dataRecordArray = new DataRecord[n];
        int[] nArray = this.btBeaconTable.getSelectedRows();
        for (int i = 0; i < n; ++i) {
            int n2 = this.btBeaconTable.convertRowIndexToModel(nArray[i]);
            BluetoothBeaconHandler.BtBeaconRec btBeaconRec = (BluetoothBeaconHandler.BtBeaconRec)this.btBeaconDatabase.getRecordByIdx(n2);
            dataRecordArray[i] = btBeaconRec;
        }
        this.createBtBeaconDetailPanel(dataRecordArray);
    }

    private GuiUtilDetailSplitPanel getBtBeaconDetailSplitPane() {
        if (this.btBeaconDetailSplitPane == null) {
            this.btBeaconDetailSplitPane = new GuiUtilDetailSplitPanel(310);
            this.btBeaconDetailSplitPane.setTopComponent(this.getBtBeaconTablePane());
            this.btBeaconDetailSplitPane.setBottomComponent(null);
        }
        return this.btBeaconDetailSplitPane;
    }

    private GuiUtilConfiguratorTable getBtBeaconTable() {
        if (this.btBeaconTable == null) {
            this.btBeaconTable = new GuiUtilConfiguratorTable((Object)this, (Database)this.btBeaconDatabase, btBeaconTableConfigIdxArray, this.getActiveBtBeaconConfigColumns(), UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthBtBeaconConfig);
            this.btBeaconTable.setColumnFormatString(0, "0x%03X");
            this.btBeaconTable.setColumnFormatString(2, "0x%03X");
            this.btBeaconTable.setColumnFormatString(8, "%d dBm");
            this.btBeaconTable.setIconArray(11, GuiUtilIcon.getIconArrayInactiveActive());
            this.btBeaconTable.setIconArray(10, GuiUtilIcon.getIconArray_Disconnect_OK_Error());
        }
        return this.btBeaconTable;
    }

    private AastraScrollPane getBtBeaconTablePane() {
        if (this.btBeaconTablePane == null) {
            this.btBeaconTablePane = new AastraScrollPane(this.getBtBeaconTable());
            this.dividerLocation = this.btBeaconDetailSplitPane.getHeight() - 310;
            this.btBeaconTablePane.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.btBeaconTablePane;
    }

    private int[] getActiveBtBeaconConfigColumns() {
        int n = 0;
        int[] nArray = null;
        int[] nArray2 = btBeaconTableConfigIdxArray;
        BitSet bitSet = UtilPreferences.getTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectBtBeaconConfig);
        if (bitSet != null) {
            nArray = new int[bitSet.cardinality()];
            for (int i = 0; i < nArray2.length; ++i) {
                if (!bitSet.get(i)) continue;
                nArray[n++] = nArray2[i];
            }
        } else {
            nArray = btBeaconTableConfigIdxArrayDefault;
            if (bitSet == null) {
                bitSet = new BitSet();
            }
            block1: for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray2.length; ++j) {
                    if (nArray[i] != nArray2[j]) continue;
                    bitSet.set(j);
                    continue block1;
                }
            }
            UtilPreferences.setTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectBtBeaconConfig, bitSet);
        }
        return nArray;
    }

    private void enableTableAccess() {
        this.btBeaconTable.setActive(true);
        this.btBeaconTaskPanel.setTaskButtonCreate(true);
        this.btBeaconTaskPanel.setTaskButtonFilter(true);
        this.btBeaconTaskPanel.setTaskButtonConfigureTable(true);
    }

    private void disableTableAccess() {
        this.btBeaconTable.setActive(false);
        this.btBeaconTaskPanel.setTaskButtonCreate(false);
        this.btBeaconTaskPanel.setTaskButtonConfigure(false);
        this.btBeaconTaskPanel.setTaskButtonDelete(false);
        this.btBeaconTaskPanel.setTaskButtonFilter(false);
        this.btBeaconTaskPanel.setTaskButtonConfigureTable(false);
    }

    protected void configureTableFilter() {
        boolean bl = UtilFilterTable.setFilterItems(this.btBeaconTable, btBeaconTableConfigIdxArray, UtilPreferences.getTableFilterValues(UtilPreferences.TableFilterValuesKeyTypeEnum.TableFilterValuesBtBeaconConfig));
        this.btBeaconTaskPanel.setTaskButtonFilterState(bl, null);
    }

    private AastraPanel getBtBeaconDetailPanel() {
        if (this.btBeaconDetailPanel == null) {
            this.btBeaconDetailPanel = new BtBeaconConfigDetailPanel(this, this.commonDataHandler, this.utilErrorComp);
        }
        return this.btBeaconDetailPanel;
    }

    private AastraPanel getBtBeaconTaskPanel() {
        if (this.btBeaconTaskPanel == null) {
            this.btBeaconTaskPanel = new BtBeaconConfigTaskPanel(this, this.btBeaconTable);
        }
        return this.btBeaconTaskPanel;
    }

    public void startBtBeaconCreation() {
        this.btBeaconTable.removeRowSelectionAll();
        this.createBtBeaconDetailPanel(null);
    }

    private void createBtBeaconDetailPanel(DataRecord[] dataRecordArray) {
        if (this.btBeaconDetailSplitPane.getBottomComponent() != null) {
            this.clearDetailPanelPending();
            this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
            this.utilErrorComp.clearComponents();
            this.dividerLocation = this.btBeaconDetailSplitPane.getDividerLocation();
            if (dataRecordArray == null) {
                this.btBeaconDetailPanel.setDefaultTab();
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Updating BT beacon config detail panel");
        } else {
            this.btBeaconDetailSplitPane.setBottomComponent(this.getBtBeaconDetailPanel());
            this.btBeaconDetailPanel.setDefaultTab();
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating BT beacon config detail panel");
        }
        if (dataRecordArray != null) {
            for (int i = 0; i < dataRecordArray.length; ++i) {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading BT beacon[" + (Integer)dataRecordArray[i].getField(0) + "]:");
                UtilPrint.printBtBeaconRecordString((BluetoothBeaconHandler.BtBeaconRec)dataRecordArray[i], this);
            }
            this.btBeaconDetailPanel.setBtBeaconDetailData(dataRecordArray);
        } else {
            this.btBeaconDetailPanel.setBtBeaconDetailData(null);
        }
        this.btBeaconDetailPanel.requestDefaultFocusInWindow();
        this.btBeaconDetailSplitPane.setDividerLocation(this.dividerLocation);
        this.btBeaconDetailSplitPane.validate();
        this.btBeaconTaskPanel.setTaskButtonConfigure(false);
    }

    public void removeBtBeaconDetailPanel() {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing BT beacon config detail panel");
        this.clearDetailPanelPending();
        this.dividerLocation = this.btBeaconDetailSplitPane.getDividerLocation();
        this.btBeaconDetailSplitPane.setBottomComponent(null);
        this.utilErrorComp.clearComponents();
        this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
        if (this.btBeaconTable.getSelectedRow() >= 0) {
            this.btBeaconTaskPanel.setTaskButtonConfigure(true);
        } else {
            this.btBeaconTaskPanel.setTaskButtonConfigure(false);
        }
    }

    public boolean createBtBeacon() {
        DataRecord[] dataRecordArray = this.btBeaconDetailPanel.getBtBeaconDetailData();
        this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_BUSY, null);
        BluetoothBeaconHandler.BtBeaconRec btBeaconRec = (BluetoothBeaconHandler.BtBeaconRec)dataRecordArray[0];
        if (btBeaconRec != null) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Creating BT beacon:");
            UtilPrint.printBtBeaconRecordString(btBeaconRec, this);
            this.btBeaconHandler.sendCreateBluetoothBeacon(btBeaconRec);
            this.setDetailPanelPending();
        } else {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Creating BT beacon failed: No BT beacon data record");
            this.removeBtBeaconDetailPanel();
        }
        return true;
    }

    public boolean changeBtBeacon() {
        int n;
        DataRecord[] dataRecordArray = this.btBeaconDetailPanel.getBtBeaconDetailData();
        this.cntBtBeaconsSendBulkTotal = 0;
        for (n = 0; n < dataRecordArray.length; ++n) {
            if (!((BluetoothBeaconHandler.BtBeaconRec)dataRecordArray[n]).getRecordChanged()) continue;
            ++this.cntBtBeaconsSendBulkTotal;
            ++this.cntNotificationsToReceive;
            this.btBeaconIdsPending.put((Integer)dataRecordArray[n].getField(0), false);
        }
        if (this.cntBtBeaconsSendBulkTotal > 0) {
            n = 0;
            this.btBeaconRecordsChange = new BluetoothBeaconHandler.BtBeaconRec[this.cntBtBeaconsSendBulkTotal];
            for (int i = 0; i < dataRecordArray.length; ++i) {
                if (!((BluetoothBeaconHandler.BtBeaconRec)dataRecordArray[i]).getRecordChanged()) continue;
                this.btBeaconRecordsChange[n++] = (BluetoothBeaconHandler.BtBeaconRec)dataRecordArray[i];
            }
            if (this.cntBtBeaconsSendBulkTotal == 1) {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, String.format("Changing bluetooth beacon[%d]\n", this.btBeaconRecordsChange[0].getField(0)));
            } else {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, String.format("Changing %d bluetooth beacons\n", this.cntBtBeaconsSendBulkTotal));
            }
            this.sendBulkAction = DataHandler.SendBulkActionType.Change;
            this.btBeaconHandler.sendChangeDeleteBtBeacon(this.sendBulkAction, this.btBeaconRecordsChange, this);
            this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_BUSY, null);
            this.setDetailPanelPending();
            if (this.cntBtBeaconsSendBulkTotal > 1) {
                this.guiProgressDlg = new GuiProgressDlgCancel(UtilLocale.getString("TXT_CHANGING_BLUETOOTH_BEACONS_IN_PROGRESS"), false, true, this);
                this.guiProgressDlg.setValue(0);
                this.guiProgressDlg.setVisible(true);
            }
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Changing bluetooth beacon(s): OMILIB told us there is nothing to do (all attributes are unchanged)");
            this.removeBtBeaconDetailPanel();
        }
        return true;
    }

    public void deleteBtBeacon() {
        GuiUtilDialog guiUtilDialog;
        int n = this.btBeaconTable.getSelectedRowCount();
        if (n > 0 && (guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_DELETE_SELECTED_BLUETOOTH_BEACONS_?"), true)).getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
            int[] nArray = this.btBeaconTable.getSelectedRows();
            this.cntBtBeaconsSendBulkTotal = nArray.length;
            this.cntNotificationsToReceive = nArray.length;
            this.btBeaconRecordsChange = new BluetoothBeaconHandler.BtBeaconRec[this.cntBtBeaconsSendBulkTotal];
            for (int i = 0; i < this.cntBtBeaconsSendBulkTotal; ++i) {
                int n2 = this.btBeaconTable.convertRowIndexToModel(nArray[i]);
                this.btBeaconRecordsChange[i] = (BluetoothBeaconHandler.BtBeaconRec)this.btBeaconDatabase.getRecordByIdx(n2);
                if (this.btBeaconDetailSplitPane.getBottomComponent() == null) continue;
                int n3 = (Integer)this.btBeaconRecordsChange[i].getField(0);
                if (this.btBeaconDetailPanel.getSelectedBtBeacon() != n3) continue;
                this.btBeaconIdsPending.put(n3, false);
                this.setDetailPanelPending();
            }
            this.sendBulkAction = DataHandler.SendBulkActionType.Delete;
            this.btBeaconHandler.sendChangeDeleteBtBeacon(this.sendBulkAction, this.btBeaconRecordsChange, this);
            if (this.cntBtBeaconsSendBulkTotal > 1) {
                this.guiProgressDlg = new GuiProgressDlgCancel(UtilLocale.getString("TXT_DELETING_BLUETOOTH_BEACONS_IN_PROGRESS"), false, true, this);
                this.guiProgressDlg.setValue(0);
                this.guiProgressDlg.setVisible(true);
            }
        }
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
        if (this.btBeaconDetailSplitPane.getBottomComponent() != null) {
            this.createBtBeaconDetailPanel(dataRecordArray);
        }
    }

    @Override
    public void componentActivated(Component component) {
        this.btBeaconHandler.start();
        this.configureTableFilter();
    }

    @Override
    public void componentDeactivated() {
    }

    @Override
    public void processBtdDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "BT beacon notification: " + dataNotificationEnum.toString() + ",btBeaconId=" + n);
        if (this.btBeaconTable.getSelectedRowCount() == 0) {
            this.btBeaconTaskPanel.setTaskButtonConfigure(false);
            this.btBeaconTaskPanel.setTaskButtonDelete(false);
        }
        switch (dataNotificationEnum) {
            case DATA_DELETED_ALL: {
                this.disableTableAccess();
                break;
            }
            case DATA_BULK_READY: {
                this.enableTableAccess();
                this.guiStatusBar.showAppStateResetOverride(GuiStatusBar.AppStateEnum.APP_STATE_OK, "");
                break;
            }
            case NEW_DATA: {
                if (this.detailPanelPending) {
                    this.btBeaconIdsPending.remove(n);
                    this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
                    this.removeBtBeaconDetailPanel();
                    this.btBeaconHandler.sendBluetoothBeaconReq(n);
                }
                this.configureTaskButtonDelete();
                break;
            }
            case DATA_CHANGED_CNF: {
                this.configureTaskButtonDelete();
                break;
            }
            case DATA_CHANGED_RESP: {
                if (this.detailPanelPending) {
                    if (this.btBeaconIdsPending.containsKey(n) && this.cntNotificationsToReceive > 0) {
                        --this.cntNotificationsToReceive;
                    }
                    this.btBeaconIdsPending.remove(n);
                    if (this.btBeaconIdsPending.isEmpty()) {
                        this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
                        this.removeBtBeaconDetailPanel();
                        this.cntNotificationsToReceive = 0;
                    }
                }
                this.configureTaskButtonDelete();
                break;
            }
            case DATA_DELETED: {
                if (!this.detailPanelPending) break;
                if (this.btBeaconIdsPending.containsKey(n) && this.cntNotificationsToReceive > 0) {
                    --this.cntNotificationsToReceive;
                }
                this.btBeaconIdsPending.remove(n);
                if (!this.btBeaconIdsPending.isEmpty()) break;
                this.removeBtBeaconDetailPanel();
                this.cntNotificationsToReceive = 0;
                break;
            }
        }
    }

    @Override
    public void processBtdDataErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        String string4 = null;
        OmiMessage.errorCodes errorCodes2 = null;
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "BT beacon error notification: " + dataNotificationEnum.toString() + ",btBeaconId=" + String.valueOf(n) + ",errCode=" + string + ",bad=" + string2 + ",maxLen=" + string3);
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCodes2 = null;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "BT beacon error notification: Unknown errorCode=" + string);
        }
        if (this.detailPanelPending) {
            String string5 = null;
            if (errorCodes2 != null) {
                this.btBeaconDetailPanel.markErrorComponent(string2);
                string5 = this.btBeaconDetailPanel.getErrorLabelText(string2);
                string4 = UtilErrorHandling.getErrorMessage(errorCodes2, string5, string3);
            }
            if (this.btBeaconIdsPending.containsKey(n) && this.cntNotificationsToReceive > 0) {
                --this.cntNotificationsToReceive;
            }
            if (dataNotificationEnum == DataNotificationEnum.DATA_CHANGED) {
                if (!this.btBeaconIdsPending.containsKey(n)) {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "btBeaconId=" + n + " does not exist in send map anymore");
                    return;
                }
                this.btBeaconIdsPending.put(n, true);
                int n2 = 0;
                for (Integer object2 : this.btBeaconIdsPending.keySet()) {
                    if (!this.btBeaconIdsPending.get(object2).booleanValue()) continue;
                    ++n2;
                }
                BluetoothBeaconHandler.BtBeaconRec[] btBeaconRecArray = new BluetoothBeaconHandler.BtBeaconRec[n2];
                n2 = 0;
                for (Integer n3 : this.btBeaconIdsPending.keySet()) {
                    if (!this.btBeaconIdsPending.get(n3).booleanValue()) continue;
                    btBeaconRecArray[n2] = this.btBeaconDatabase.getRecordById(n3);
                    ++n2;
                }
                this.btBeaconDetailPanel.setBtBeaconDetailData(btBeaconRecArray);
            }
        } else if (errorCodes2 != null) {
            string4 = UtilErrorHandling.getErrorMessage(errorCodes2, string2, string3);
        }
        if (string4 != null) {
            GuiInfoConsole.showError(string4);
        } else {
            GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
        }
        if (this.cntNotificationsToReceive == 0) {
            this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
        }
    }

    private void configureTaskButtonDelete() {
        boolean bl;
        int n = this.btBeaconTable.getSelectedRowCount();
        int[] nArray = this.btBeaconTable.getSelectedRows();
        if (n > 0) {
            bl = true;
            for (int i = 0; i < n; ++i) {
                int n2 = this.btBeaconTable.convertRowIndexToModel(nArray[i]);
                OmiMessage.BtBeaconStateType btBeaconStateType = (OmiMessage.BtBeaconStateType)((Object)this.btBeaconDatabase.getRecordByIdx(n2).getField(10));
                if (btBeaconStateType == null || btBeaconStateType == OmiMessage.BtBeaconStateType.unplugged) continue;
                bl = false;
                break;
            }
        } else {
            bl = false;
        }
        this.btBeaconTaskPanel.setTaskButtonDelete(bl);
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent();
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        int n = this.btBeaconTable.getSelectedRowCount();
        DataRecord[] dataRecordArray = new DataRecord[n];
        if (n < 1) {
            return;
        }
        int[] nArray = this.btBeaconTable.getSelectedRows();
        for (int i = 0; i < n; ++i) {
            int n2 = this.btBeaconTable.convertRowIndexToModel(nArray[i]);
            dataRecordArray[i] = this.btBeaconDatabase.getRecordByIdx(n2);
        }
        this.createBtBeaconDetailPanel(dataRecordArray);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent();
    }

    @Override
    public void notifyProgress(int n, boolean bl) {
        if (bl || n == this.cntBtBeaconsSendBulkTotal) {
            if (this.guiProgressDlg != null) {
                this.guiProgressDlg.dispose();
            }
            GuiMain.getGuiStatusBarObject().showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
            if (bl) {
                if (this.sendBulkAction == DataHandler.SendBulkActionType.Change) {
                    GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_CHANGING_CANCELED_AFTER_*_OF_*_BLUETOOTH_BEACONS"), n, this.cntBtBeaconsSendBulkTotal));
                } else {
                    GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_DELETING_CANCELED_AFTER_*_OF_*_BLUETOOTH_BEACONS"), n, this.cntBtBeaconsSendBulkTotal));
                }
            }
        } else {
            this.guiProgressDlg.setValue(100 * n / this.cntBtBeaconsSendBulkTotal);
        }
    }

    @Override
    public void timeout(int n) {
        if (this.guiProgressDlg != null) {
            this.guiProgressDlg.dispose();
        }
        GuiMain.getGuiStatusBarObject().showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
        if (this.sendBulkAction == DataHandler.SendBulkActionType.Change) {
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_CHANGING_CANCELED_BY_TIMEOUT_AFTER_*_OF_*_BLUETOOTH_BEACONS"), n, this.cntBtBeaconsSendBulkTotal));
        } else {
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_DELETING_CANCELED_BY_TIMEOUT_AFTER_*_OF_*_BLUETOOTH_BEACONS"), n, this.cntBtBeaconsSendBulkTotal));
        }
    }

    @Override
    public void canceled() {
        this.btBeaconHandler.cancelChangeDeleteBtBeacon();
    }

    @Override
    public void processCommonDataNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum) {
        if (commonDataItemEnum == CommonDataHandler.CommonDataItemEnum.BlueToothGlobal) {
            Boolean bl = null;
            try {
                bl = (Boolean)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.BlueToothGlobal);
            }
            catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                bl = false;
            }
            this.btBeaconTaskPanel.setTaskButtonEnableBluetoothIcon(bl);
        }
    }

    @Override
    public void processCommonDataErrorNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage) {
    }

    protected void sendBluetoothEnable() {
        try {
            Boolean bl = (Boolean)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.BlueToothGlobal);
            this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.BlueToothGlobal, bl == false);
            this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.BlueToothGlobal);
        }
        catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
            // empty catch block
        }
    }

    public static enum BtBeaconTableConfigTypeEnum {
        BT_BEACON_TABLE_CONFIG,
        BT_BEACON_TABLE_MONITOR;

    }
}

