/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.btbeacon;

import com.aastra.oamp.btbeacon.BtBeaconDetailPanel;
import com.aastra.oamp.btbeacon.BtBeaconMonitorMainPanel;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilSetPanelEditable;
import com.aastra.omilib.BluetoothBeaconHandler;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.OmiMessage;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraSlider;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BtBeaconMonitorDetailPanel
extends BtBeaconDetailPanel
implements CommonDataHandler.CommonDataNotificationInterface {
    private static final long serialVersionUID = 1L;
    private BtBeaconMonitorMainPanel btBeaconMainPanel = null;
    private CommonDataHandler commonDataHandler = null;

    public BtBeaconMonitorDetailPanel(BtBeaconMonitorMainPanel btBeaconMonitorMainPanel, CommonDataHandler commonDataHandler) {
        this.btBeaconMainPanel = btBeaconMonitorMainPanel;
        this.commonDataHandler = commonDataHandler;
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.BlueToothSensitivity, this);
        this.panelTabbed.addTab(UtilLocale.getString("TXT_STATUS"), null, this.getTabStatus(), null);
        this.panelTabbed.addTab(UtilLocale.getString("TXT_GENERAL"), null, this.getTabGeneral(), null);
        this.panelTabbed.addTab(UtilLocale.getString("TXT_SENSITIVITY"), null, this.getTabSensitivity(), null);
        this.panelButtonBar.add(this.getButtonCancel());
    }

    @Override
    protected AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            super.getButtonCancel();
            this.buttonCancel.setBounds(120, 15, 90, 25);
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (BtBeaconMonitorDetailPanel.this.btBeaconMainPanel != null) {
                        BtBeaconMonitorDetailPanel.this.btBeaconMainPanel.removeBtBeaconDetailPanel();
                    }
                }
            });
        }
        return this.buttonCancel;
    }

    public void setBtBeaconDetailData(BluetoothBeaconHandler.BtBeaconRec btBeaconRec) {
        if (btBeaconRec != null) {
            this.labelHeaderBar.setText(String.format(UtilLocale.getString("TXT_BLUETOOTH_BEACON") + " #0x%03X", (Integer)btBeaconRec.getField(0)));
            this.textFieldMACAddress.setText((String)btBeaconRec.getField(1));
            this.textFieldRfpId.setText(String.format("0x%03X", (Integer)btBeaconRec.getField(2)));
            OmiMessage.BtBeaconStateType btBeaconStateType = (OmiMessage.BtBeaconStateType)((Object)btBeaconRec.getField(10));
            if (btBeaconStateType != null) {
                this.labelStateIcon.setIcon(GuiUtilIcon.getIconArray_Disconnect_OK_Error()[btBeaconStateType.ordinal()]);
                this.labelStateIcon.setToolTipText(btBeaconStateType.toString());
            } else {
                this.labelStateIcon.setIcon(null);
                this.labelStateIcon.setToolTipText(null);
            }
            this.textFieldName.setText((String)btBeaconRec.getField(3));
            this.textFieldBuilding.setText((String)btBeaconRec.getField(4));
            this.textFieldFloor.setText((String)btBeaconRec.getField(5));
            this.textFieldRoom.setText((String)btBeaconRec.getField(6));
            this.checkBoxCheckpoint.setSelected((Boolean)btBeaconRec.getField(11));
            this.sliderRSSIThreshold.setValue((Integer)btBeaconRec.getField(8));
        } else {
            this.labelHeaderBar.setText(UtilLocale.getString("TXT_RECORD_INVALID"));
            this.textFieldMACAddress.setText("");
            this.textFieldRfpId.setText("");
            this.labelStateIcon.setIcon(null);
            this.labelStateIcon.setToolTipText(null);
            this.textFieldName.setText("");
            this.textFieldBuilding.setText("");
            this.textFieldFloor.setText("");
            this.textFieldRoom.setText("");
            this.checkBoxCheckpoint.setSelected(false);
            this.sliderRSSIThreshold.setValue(-64);
        }
        if (this.getRootPane() != null) {
            this.getRootPane().setDefaultButton(this.getButtonCancel());
            this.getButtonCancel().requestFocusInWindow();
        }
    }

    @Override
    protected AastraPanel getTabGeneral() {
        if (this.tabGeneral == null) {
            super.getTabGeneral();
            UtilSetPanelEditable.setDisabled(this.tabGeneral);
        }
        return this.tabGeneral;
    }

    @Override
    protected BtBeaconDetailPanel.TabSensitivityPanel getTabSensitivity() {
        if (this.tabSensitivity == null) {
            super.getTabSensitivity();
            this.labelSensitivityHigh.setEnabled(false);
            this.labelSensitivityLow.setEnabled(false);
            UtilSetPanelEditable.setDisabled(this.tabSensitivity);
        }
        return this.tabSensitivity;
    }

    @Override
    protected AastraSlider getSliderRssiThreshold() {
        if (this.sliderRSSIThreshold == null) {
            super.getSliderRssiThreshold();
            CommonDataHandler.BlueToothSensitivityClass blueToothSensitivityClass = this.getBlueToothSensitivity();
            if (blueToothSensitivityClass != null) {
                this.sliderRSSIThreshold.setTicksAndLabels(blueToothSensitivityClass.rfpSens.high, blueToothSensitivityClass.rfpSens.low);
            }
            this.sliderRSSIThreshold.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    AastraSlider aastraSlider = (AastraSlider)changeEvent.getSource();
                    if (!aastraSlider.getValueIsAdjusting()) {
                        BtBeaconMonitorDetailPanel.this.labelRssiThresholdValue.setText("" + aastraSlider.getValue() + " dBm");
                    }
                }
            });
        }
        return this.sliderRSSIThreshold;
    }

    public CommonDataHandler.BlueToothSensitivityClass getBlueToothSensitivity() {
        CommonDataHandler.BlueToothSensitivityClass blueToothSensitivityClass = null;
        try {
            blueToothSensitivityClass = (CommonDataHandler.BlueToothSensitivityClass)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.BlueToothSensitivity);
        }
        catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
            // empty catch block
        }
        return blueToothSensitivityClass;
    }

    @Override
    public void processCommonDataNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum) {
        if (commonDataItemEnum == CommonDataHandler.CommonDataItemEnum.BlueToothSensitivity) {
            CommonDataHandler.BlueToothSensitivityClass blueToothSensitivityClass = null;
            try {
                blueToothSensitivityClass = (CommonDataHandler.BlueToothSensitivityClass)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.BlueToothSensitivity);
            }
            catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                return;
            }
            if (this.sliderRSSIThreshold != null) {
                this.sliderRSSIThreshold.setTicksAndLabels(blueToothSensitivityClass.rfpSens.high, blueToothSensitivityClass.rfpSens.low);
            }
        }
    }

    @Override
    public void processCommonDataErrorNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage) {
    }
}

