/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.btbeacon;

import com.aastra.oamp.btbeacon.BtBeaconConfigMainPanel;
import com.aastra.oamp.btbeacon.BtBeaconMonitorDetailPanel;
import com.aastra.oamp.btbeacon.BtBeaconMonitorTaskPanel;
import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.util.UtilFilterTable;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.oamp.util.UtilPrint;
import com.aastra.omilib.BluetoothBeaconHandler;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.BitSet;

public class BtBeaconMonitorMainPanel
extends AastraPanel
implements CommonDataHandler.CommonDataNotificationInterface,
BluetoothBeaconHandler.BtBeaconNotificationInterface,
ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface,
GuiComponentActivationInterface {
    private static final long serialVersionUID = 1L;
    private BluetoothBeaconHandler btBeaconHandler = null;
    private BluetoothBeaconHandler.BtBeaconDatabase btBeaconDatabase = null;
    private CommonDataHandler commonDataHandler = null;
    private GuiUtilDetailSplitPanel btBeaconDetailSplitPane = null;
    private AastraScrollPane btBeaconTablePane = null;
    private BtBeaconMonitorDetailPanel btBeaconDetailPanel = null;
    private BtBeaconMonitorTaskPanel btBeaconTaskPanel = null;
    private GuiUtilConfiguratorTable btBeaconTable = null;
    private int currentBtBeaconDetailPanel = -1;
    private int dividerLocation = 0;

    public BtBeaconMonitorMainPanel(BluetoothBeaconHandler bluetoothBeaconHandler, CommonDataHandler commonDataHandler) {
        this.btBeaconHandler = bluetoothBeaconHandler;
        this.commonDataHandler = commonDataHandler;
        this.btBeaconHandler.registerDataNotificationListener(this);
        this.btBeaconDatabase = (BluetoothBeaconHandler.BtBeaconDatabase)this.btBeaconHandler.getDb();
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.BlueToothGlobal, this);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getBtBeaconDetailSplitPane(), "Center");
        this.add((Component)this.getBtBeaconMonitorTaskPanel(), "East");
    }

    private GuiUtilDetailSplitPanel getBtBeaconDetailSplitPane() {
        if (this.btBeaconDetailSplitPane == null) {
            this.btBeaconDetailSplitPane = new GuiUtilDetailSplitPanel(310);
            this.btBeaconDetailSplitPane.setTopComponent(this.getBtBeaconTablePane());
            this.btBeaconDetailSplitPane.setBottomComponent(null);
        }
        return this.btBeaconDetailSplitPane;
    }

    private GuiUtilConfiguratorTable getBtBeaconTable() {
        if (this.btBeaconTable == null) {
            this.btBeaconTable = new GuiUtilConfiguratorTable((Object)this, (Database)this.btBeaconDatabase, BtBeaconConfigMainPanel.btBeaconTableConfigIdxArray, this.getActiveBtBeaconConfigColumns(), UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthBtBeaconMonitor, 0);
            this.btBeaconTable.setColumnFormatString(0, "0x%03X");
            this.btBeaconTable.setColumnFormatString(2, "0x%03X");
            this.btBeaconTable.setColumnFormatString(8, "%d dBm");
            this.btBeaconTable.setIconArray(11, GuiUtilIcon.getIconArrayInactiveActive());
            this.btBeaconTable.setIconArray(10, GuiUtilIcon.getIconArray_Disconnect_OK_Error());
        }
        return this.btBeaconTable;
    }

    private AastraScrollPane getBtBeaconTablePane() {
        if (this.btBeaconTablePane == null) {
            this.btBeaconTablePane = new AastraScrollPane(this.getBtBeaconTable());
            this.dividerLocation = this.btBeaconDetailSplitPane.getHeight() - 310;
            this.btBeaconTablePane.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.btBeaconTablePane;
    }

    private int[] getActiveBtBeaconConfigColumns() {
        int n = 0;
        int[] nArray = null;
        int[] nArray2 = BtBeaconConfigMainPanel.btBeaconTableConfigIdxArray;
        BitSet bitSet = UtilPreferences.getTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectBtBeaconMonitor);
        if (bitSet != null) {
            nArray = new int[bitSet.cardinality()];
            for (int i = 0; i < nArray2.length; ++i) {
                if (!bitSet.get(i)) continue;
                nArray[n++] = nArray2[i];
            }
        } else {
            nArray = BtBeaconConfigMainPanel.btBeaconTableConfigIdxArrayDefault;
            if (bitSet == null) {
                bitSet = new BitSet();
            }
            block1: for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray2.length; ++j) {
                    if (nArray[i] != nArray2[j]) continue;
                    bitSet.set(j);
                    continue block1;
                }
            }
            UtilPreferences.setTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectBtBeaconMonitor, bitSet);
        }
        return nArray;
    }

    private void enableTableAccess() {
        this.btBeaconTable.setActive(true);
        this.btBeaconTaskPanel.setTaskButtonFilter(true);
        this.btBeaconTaskPanel.setTaskButtonConfigureTable(true);
    }

    private void disableTableAccess() {
        this.btBeaconTable.setActive(false);
        this.btBeaconTaskPanel.setTaskButtonShowDetails(false);
        this.btBeaconTaskPanel.setTaskButtonFilter(false);
        this.btBeaconTaskPanel.setTaskButtonConfigureTable(false);
    }

    protected void configureTableFilter() {
        boolean bl = UtilFilterTable.setFilterItems(this.btBeaconTable, BtBeaconConfigMainPanel.btBeaconTableConfigIdxArray, UtilPreferences.getTableFilterValues(UtilPreferences.TableFilterValuesKeyTypeEnum.TableFilterValuesBtBeaconMonitor));
        this.btBeaconTaskPanel.setTaskButtonFilterState(bl, null);
    }

    private AastraPanel getBtBeaconMonitorDetailPanel() {
        if (this.btBeaconDetailPanel == null) {
            this.btBeaconDetailPanel = new BtBeaconMonitorDetailPanel(this, this.commonDataHandler);
        }
        return this.btBeaconDetailPanel;
    }

    private AastraPanel getBtBeaconMonitorTaskPanel() {
        if (this.btBeaconTaskPanel == null) {
            this.btBeaconTaskPanel = new BtBeaconMonitorTaskPanel(this, this.btBeaconTable);
        }
        return this.btBeaconTaskPanel;
    }

    public void createBtBeaconDetailPanel(DataRecord dataRecord) {
        if (this.btBeaconDetailSplitPane.getBottomComponent() != null) {
            this.dividerLocation = this.btBeaconDetailSplitPane.getDividerLocation();
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Updating BT beacon monitor detail panel");
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating BT beacon monitor detail panel");
            this.btBeaconDetailSplitPane.setBottomComponent(this.getBtBeaconMonitorDetailPanel());
            this.btBeaconDetailPanel.setDefaultTab();
        }
        if (dataRecord != null) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading BT beacon[" + (Integer)dataRecord.getField(0) + "]:");
            UtilPrint.printBtBeaconRecordString((BluetoothBeaconHandler.BtBeaconRec)dataRecord, this);
            this.currentBtBeaconDetailPanel = (Integer)dataRecord.getField(0);
            this.btBeaconDetailPanel.setBtBeaconDetailData((BluetoothBeaconHandler.BtBeaconRec)dataRecord);
        } else {
            this.btBeaconDetailPanel.setBtBeaconDetailData(null);
        }
        this.btBeaconDetailSplitPane.setDividerLocation(this.dividerLocation);
        this.btBeaconDetailSplitPane.validate();
        this.btBeaconTaskPanel.setTaskButtonShowDetails(false);
    }

    public void removeBtBeaconDetailPanel() {
        this.currentBtBeaconDetailPanel = -1;
        this.dividerLocation = this.btBeaconDetailSplitPane.getDividerLocation();
        this.btBeaconDetailSplitPane.setBottomComponent(null);
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing BT beacon monitor detail panel");
        if (this.btBeaconTable.getSelectedRow() >= 0) {
            this.btBeaconTaskPanel.setTaskButtonShowDetails(true);
        }
    }

    public void showBtBeaconDetails() {
        int n;
        BluetoothBeaconHandler.BtBeaconRec btBeaconRec;
        int n2 = this.btBeaconTable.getSelectedRow();
        if (n2 >= 0 && (btBeaconRec = (BluetoothBeaconHandler.BtBeaconRec)this.btBeaconDatabase.getRecordByIdx(n = this.btBeaconTable.convertRowIndexToModel(n2))) != null) {
            this.createBtBeaconDetailPanel(btBeaconRec);
        }
    }

    @Override
    public void processBtdDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "BT beacon notification: " + dataNotificationEnum.toString() + ",btBeaconId=" + n);
        switch (dataNotificationEnum) {
            case DATA_DELETED_ALL: {
                this.disableTableAccess();
                break;
            }
            case DATA_BULK_READY: {
                this.enableTableAccess();
                break;
            }
            default: {
                BluetoothBeaconHandler.BtBeaconRec btBeaconRec;
                if (this.btBeaconTable.getSelectedRow() == -1) {
                    this.btBeaconTaskPanel.setTaskButtonShowDetails(false);
                }
                if (this.currentBtBeaconDetailPanel != n || (btBeaconRec = this.btBeaconDatabase.getRecordById(n)) == null) break;
                this.btBeaconDetailPanel.setBtBeaconDetailData(btBeaconRec);
            }
        }
    }

    @Override
    public void processBtdDataErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        if (this.btBeaconDetailSplitPane.getBottomComponent() != null) {
            if (dataRecord != null) {
                this.createBtBeaconDetailPanel(dataRecord);
            } else {
                this.removeBtBeaconDetailPanel();
            }
        } else {
            this.btBeaconTaskPanel.setTaskButtonShowDetails(true);
        }
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        this.createBtBeaconDetailPanel(dataRecord);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        int n;
        if (this.btBeaconDetailSplitPane.getBottomComponent() != null) {
            if (dataRecord != null) {
                this.createBtBeaconDetailPanel(dataRecord);
            } else {
                this.removeBtBeaconDetailPanel();
            }
        }
        if ((n = this.btBeaconTable.getSelectedRowCount()) == 1) {
            this.btBeaconTaskPanel.setTaskButtonShowDetails(true);
        } else {
            this.btBeaconTaskPanel.setTaskButtonShowDetails(false);
        }
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
        int n = this.btBeaconTable.getSelectedRowCount();
        if (n == 1) {
            this.btBeaconTaskPanel.setTaskButtonShowDetails(true);
        } else {
            this.btBeaconTaskPanel.setTaskButtonShowDetails(false);
            if (n > 1 && this.btBeaconDetailSplitPane.getBottomComponent() != null) {
                this.removeBtBeaconDetailPanel();
            }
        }
    }

    @Override
    public void componentActivated(Component component) {
        this.btBeaconHandler.start();
        this.configureTableFilter();
    }

    @Override
    public void componentDeactivated() {
    }

    @Override
    public void processCommonDataNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum) {
        if (commonDataItemEnum == CommonDataHandler.CommonDataItemEnum.BlueToothGlobal) {
            Boolean bl = null;
            try {
                bl = (Boolean)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.BlueToothGlobal);
            }
            catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                bl = false;
            }
            this.btBeaconTaskPanel.setTaskButtonEnableBluetoothIcon(bl);
        }
    }

    @Override
    public void processCommonDataErrorNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage) {
    }
}

