/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.conferenceroom;

import com.aastra.oamp.conferenceroom.ConferenceRoomMainPanel;
import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilChangeHandler;
import com.aastra.oamp.guiutil.GuiUtilDetailPanel;
import com.aastra.oamp.guiutil.GuiUtilPasswordFieldNew;
import com.aastra.oamp.guiutil.GuiUtilTextField;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilMisc;
import com.aastra.oamp.util.UtilSetPanelEditable;
import com.aastra.omilib.ConferenceRoomHandler;
import com.aastra.omilib.OmiMessage;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

public class ConferenceRoomDetailPanel
extends GuiUtilDetailPanel {
    private static final long serialVersionUID = 1L;
    private ConferenceRoomMainPanel conferenceRoomMainPanel = null;
    private AastraButton buttonOK = null;
    private AastraButton buttonCancel = null;
    private AastraPanel tabGeneral = null;
    private AastraLabel labelName = null;
    private GuiUtilTextField textFieldName = null;
    private AastraLabel labelConferenceId = null;
    private GuiUtilTextField textFieldConferenceId = null;
    private AastraLabel labelUserName = null;
    private GuiUtilTextField textFieldUserName = null;
    private AastraLabel labelPassword = null;
    private GuiUtilPasswordFieldNew passwordFieldPassword = null;
    private AastraLabel labelPasswordConfirm = null;
    private GuiUtilPasswordFieldNew passwordFieldPasswordConfirm = null;
    private AastraLabel labelFixedSIPPort = null;
    private GuiUtilTextField textFieldFixedSIPPort = null;
    private AastraLabel labelCalculatedSIPPort = null;
    private GuiUtilTextField textFieldCalculatedSIPPort = null;
    private GuiUtilChangeHandler utilChangeHandler = null;
    private UtilErrorComp utilErrorComp = null;
    private boolean isEditable = true;
    private GuiMain.GuiNavPanelTypeEnum guiNavPanelType = null;
    private ConferenceRoomHandler.ConferenceRoom conferenceRoom = null;
    private ActionModeEnum actionMode;

    public ConferenceRoomDetailPanel(ConferenceRoomMainPanel conferenceRoomMainPanel, GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum, UtilErrorComp utilErrorComp) {
        super(300, 150);
        this.conferenceRoomMainPanel = conferenceRoomMainPanel;
        this.guiNavPanelType = guiNavPanelTypeEnum;
        this.utilErrorComp = utilErrorComp;
        this.initialize();
    }

    private void initialize() {
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
            this.utilChangeHandler = new GuiUtilChangeHandler(this.getButtonOK(), this.getButtonCancel(), false);
            this.panelButtonBar.add(this.getButtonOK());
        } else {
            this.isEditable = false;
        }
        this.panelTabbed.addTab(UtilLocale.getString("TXT_GENERAL"), null, this.getTabGeneral(), null);
        this.panelButtonBar.add(this.getButtonCancel());
    }

    private AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            this.buttonOK = new AastraButton();
            this.buttonOK.setBounds(70, 15, 90, 25);
            this.buttonOK.setText(UtilLocale.getString("TXT_OK"));
            this.buttonOK.setEnabled(false);
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ConferenceRoomDetailPanel.this.utilChangeHandler.deactivate();
                    ConferenceRoomDetailPanel.this.utilErrorComp.clearComponents();
                    if (ConferenceRoomDetailPanel.this.actionMode == ActionModeEnum.CHANGE) {
                        ConferenceRoomDetailPanel.this.conferenceRoomMainPanel.changeConferenceRoom();
                    } else {
                        ConferenceRoomDetailPanel.this.conferenceRoomMainPanel.createConferenceRoom();
                    }
                }
            });
        }
        return this.buttonOK;
    }

    private AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new AastraButton();
            if (this.isEditable) {
                this.buttonCancel.setBounds(230, 15, 90, 25);
            } else {
                this.buttonCancel.setBounds(150, 15, 90, 25);
            }
            this.buttonCancel.setText(UtilLocale.getString("TXT_CANCEL"));
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ConferenceRoomDetailPanel.this.isEditable) {
                        ConferenceRoomDetailPanel.this.utilChangeHandler.deactivate();
                    }
                    ConferenceRoomDetailPanel.this.conferenceRoomMainPanel.removeConferenceRoomDetailPanel();
                }
            });
        }
        return this.buttonCancel;
    }

    private AastraPanel getTabGeneral() {
        if (this.tabGeneral == null) {
            this.labelName = new AastraLabel();
            this.labelName.setBounds(30, 15, 150, 16);
            this.labelName.setText(UtilLocale.getString("TXT_NAME"));
            this.labelConferenceId = new AastraLabel();
            this.labelConferenceId.setBounds(30, 45, 150, 16);
            this.labelConferenceId.setText(UtilLocale.getString("TXT_CONFERENCE_ID"));
            this.labelUserName = new AastraLabel();
            this.labelUserName.setBounds(30, 75, 150, 20);
            this.labelUserName.setText(UtilLocale.getString("TXT_USER_NAME"));
            this.labelPassword = new AastraLabel();
            this.labelPassword.setBounds(30, 105, 150, 20);
            this.labelPassword.setText(UtilLocale.getString("TXT_PASSWORD"));
            this.labelPasswordConfirm = new AastraLabel();
            this.labelPasswordConfirm.setText("<html>" + UtilLocale.getString("TXT_PASSWORD_CONFIRMATION") + "</html>");
            this.labelPasswordConfirm.setBounds(30, 135, 150, 36);
            this.labelFixedSIPPort = new AastraLabel();
            this.labelFixedSIPPort.setText(UtilLocale.getString("TXT_FIXED_SIP_PORT"));
            this.labelFixedSIPPort.setBounds(30, 165, 140, 16);
            this.labelCalculatedSIPPort = new AastraLabel();
            this.labelCalculatedSIPPort.setText(UtilLocale.getString("TXT_CALCULATED_SIP_PORT"));
            this.labelCalculatedSIPPort.setBounds(300, 165, 140, 16);
            this.tabGeneral = new AastraPanel();
            this.tabGeneral.setLayout(null);
            this.tabGeneral.add((Component)this.labelName, null);
            this.tabGeneral.add((Component)this.getTextFieldName(), null);
            this.tabGeneral.add((Component)this.labelConferenceId, null);
            this.tabGeneral.add((Component)this.getTextFieldConferenceId(), null);
            this.tabGeneral.add((Component)this.labelUserName, null);
            this.tabGeneral.add((Component)this.getTextFieldUserName(), null);
            this.tabGeneral.add((Component)this.labelPassword, null);
            this.tabGeneral.add((Component)this.getPasswordFieldPassword(), null);
            this.tabGeneral.add((Component)this.labelPasswordConfirm, null);
            this.tabGeneral.add((Component)this.getPasswordFieldPasswordConfirm(), null);
            this.tabGeneral.add(this.labelFixedSIPPort);
            this.tabGeneral.add(this.getTextFieldFixedSIPPort());
            this.tabGeneral.add(this.labelCalculatedSIPPort);
            this.tabGeneral.add(this.getTextFieldCalculatedSIPPort());
            if (this.isEditable) {
                this.utilErrorComp.put(OmiMessage.ConferenceRoomType.name.toString(), this.labelName, this.textFieldName);
                this.utilErrorComp.put(OmiMessage.ConferenceRoomType.conferenceId.toString(), this.labelConferenceId, this.textFieldConferenceId);
                this.utilErrorComp.put(OmiMessage.ConferenceRoomType.sipAuthId.toString(), this.labelUserName, this.textFieldUserName);
                this.utilErrorComp.put(OmiMessage.ConferenceRoomType.sipPw.toString(), this.labelPassword, this.passwordFieldPassword);
                this.utilErrorComp.put("sipPwConfirm", this.labelPasswordConfirm, this.passwordFieldPasswordConfirm);
                this.utilErrorComp.put(OmiMessage.ConferenceRoomType.fixedSipPort.toString(), this.labelFixedSIPPort, this.textFieldFixedSIPPort);
            } else {
                UtilSetPanelEditable.setDisabled(this.tabGeneral);
            }
        }
        return this.tabGeneral;
    }

    private GuiUtilTextField getTextFieldName() {
        if (this.textFieldName == null) {
            this.textFieldName = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldName.setBounds(185, 15, 150, 18);
        }
        return this.textFieldName;
    }

    private GuiUtilTextField getTextFieldConferenceId() {
        if (this.textFieldConferenceId == null) {
            this.textFieldConferenceId = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldConferenceId.setBounds(185, 45, 240, 18);
            this.textFieldConferenceId.setToolTipText(UtilLocale.getString("TXT_PLEASE_ENTER_SIP_USER_NAME"));
        }
        return this.textFieldConferenceId;
    }

    private GuiUtilTextField getTextFieldUserName() {
        if (this.textFieldUserName == null) {
            this.textFieldUserName = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldUserName.setBounds(185, 75, 400, 18);
        }
        return this.textFieldUserName;
    }

    private GuiUtilPasswordFieldNew getPasswordFieldPassword() {
        if (this.passwordFieldPassword == null) {
            this.passwordFieldPassword = new GuiUtilPasswordFieldNew(this.utilChangeHandler);
            this.passwordFieldPassword.setBounds(185, 105, 240, 18);
        }
        return this.passwordFieldPassword;
    }

    private GuiUtilPasswordFieldNew getPasswordFieldPasswordConfirm() {
        if (this.passwordFieldPasswordConfirm == null) {
            this.passwordFieldPasswordConfirm = new GuiUtilPasswordFieldNew(this.utilChangeHandler);
            this.passwordFieldPasswordConfirm.setBounds(185, 135, 240, 18);
        }
        return this.passwordFieldPasswordConfirm;
    }

    private GuiUtilTextField getTextFieldFixedSIPPort() {
        if (this.textFieldFixedSIPPort == null) {
            this.textFieldFixedSIPPort = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldFixedSIPPort.setBounds(185, 165, 60, 18);
        }
        return this.textFieldFixedSIPPort;
    }

    private GuiUtilTextField getTextFieldCalculatedSIPPort() {
        if (this.textFieldCalculatedSIPPort == null) {
            this.textFieldCalculatedSIPPort = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldCalculatedSIPPort.setBounds(455, 165, 60, 18);
            this.textFieldCalculatedSIPPort.setEditable(false);
        }
        return this.textFieldCalculatedSIPPort;
    }

    public void setConferenceRoomDetailData(ConferenceRoomHandler.ConferenceRoom conferenceRoom) {
        if (conferenceRoom != null) {
            this.conferenceRoom = conferenceRoom.clone();
            this.labelHeaderBar.setText(UtilLocale.getString("TXT_CONFERENCE_ROOM") + " #" + this.conferenceRoom.id);
            this.textFieldName.setText(this.conferenceRoom.name);
            this.textFieldConferenceId.setText(this.conferenceRoom.conferenceId);
            this.textFieldUserName.setText(this.conferenceRoom.sipAuthId);
            this.textFieldFixedSIPPort.setText(String.valueOf(this.conferenceRoom.fixedSipPort));
            this.textFieldCalculatedSIPPort.setText(String.valueOf(this.conferenceRoom.calculatedSipPort));
            this.actionMode = ActionModeEnum.CHANGE;
        } else {
            this.conferenceRoom = null;
            if (this.isEditable) {
                this.labelHeaderBar.setText(UtilLocale.getString("TXT_NEW_CONFERENCE_ROOM"));
            } else {
                this.labelHeaderBar.setText(UtilLocale.getString("TXT_RECORD_INVALID"));
            }
            this.textFieldName.setText("");
            this.textFieldConferenceId.setText("");
            this.textFieldUserName.setText("");
            this.textFieldFixedSIPPort.setText("0");
            this.textFieldCalculatedSIPPort.setText("");
            this.actionMode = ActionModeEnum.CREATE;
        }
        this.passwordFieldPassword.setInitial();
        this.passwordFieldPasswordConfirm.setInitial();
        if (this.isEditable) {
            this.utilChangeHandler.initRootPane(this.getRootPane());
            this.getTextFieldName().requestFocusInWindow();
        } else {
            this.getButtonCancel().requestFocusInWindow();
        }
        this.getRootPane().setDefaultButton(this.getButtonCancel());
    }

    /*
     * Enabled aggressive block sorting
     */
    public ConferenceRoomHandler.ConferenceRoom getConferenceRoomDetailData() {
        block5: {
            if (this.conferenceRoom == null) {
                this.conferenceRoom = new ConferenceRoomHandler.ConferenceRoom();
            }
            this.conferenceRoom.name = this.textFieldName.getText();
            this.conferenceRoom.conferenceId = this.textFieldConferenceId.getText();
            this.conferenceRoom.sipAuthId = this.textFieldUserName.getText();
            if (this.passwordFieldPassword.isChanged() || this.passwordFieldPasswordConfirm.isChanged()) {
                String string = new String(this.passwordFieldPassword.getPassword());
                String string2 = new String(this.passwordFieldPasswordConfirm.getPassword());
                if (this.passwordFieldPassword.isChanged() && this.passwordFieldPasswordConfirm.isChanged() && string.equals(string2)) {
                    this.conferenceRoom.sipPassword = string;
                    break block5;
                } else {
                    GuiInfoConsole.showError(UtilLocale.getString("TXT_PASSWORD_CONFIRMATION_FAILED"));
                    this.markErrorComponent(OmiMessage.ConferenceRoomType.sipPw.toString());
                    return null;
                }
            }
            this.conferenceRoom.sipPassword = null;
        }
        if ((this.conferenceRoom.fixedSipPort = Integer.valueOf(UtilMisc.getIntFromTextField(this.textFieldFixedSIPPort, UtilLocale.getString("TXT_FIXED_SIP_PORT"), this.utilErrorComp, 10))) == -1) {
            return null;
        }
        return this.conferenceRoom;
    }

    public String getErrorLabelText(String string) {
        if (string == null) {
            return null;
        }
        return this.utilErrorComp.getLabelText(string);
    }

    public void markErrorComponent(String string) {
        JComponent jComponent;
        if (string != null && (jComponent = this.utilErrorComp.getField(string)) != null) {
            this.utilErrorComp.markComponent(jComponent);
            if (string.equals(OmiMessage.ConferenceRoomType.sipPw.toString())) {
                this.utilErrorComp.markComponent(this.passwordFieldPasswordConfirm);
                this.passwordFieldPassword.setInitial();
                this.passwordFieldPasswordConfirm.setInitial();
            }
        }
    }

    private static enum ActionModeEnum {
        CREATE,
        CHANGE;

    }
}

