/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.gui;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.gui.GuiStatusBar;
import com.aastra.oamp.util.UtilFileHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilProdInfo;
import com.aastra.omilib.OmiFileTransfer;
import com.aastra.omilib.OmiMessage;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraDialog;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.style.AastraTextArea;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class GuiEulaDlg
extends AastraDialog
implements OmiFileTransfer.FileTransferNotificationInterface {
    private static final long serialVersionUID = 1L;
    private AastraPanel panelEula = null;
    private AastraPanel panelButtonBar = null;
    private AastraScrollPane scrollPaneEula = null;
    private AastraTextArea textAreaEula = null;
    private AastraButton buttonOK = null;
    private boolean showLocalEula = true;
    private GuiStatusBar guiStatusBar = null;
    private GuiEulaDlg guiEulaDlg = null;
    private String remoteEulaPath = UtilFileHandling.getAppDataDirectory() + File.separator + "eula.txt";

    public GuiEulaDlg(GuiMain guiMain, boolean bl, GuiStatusBar guiStatusBar) {
        super(guiMain);
        this.showLocalEula = bl;
        this.guiStatusBar = guiStatusBar;
        this.initialize();
    }

    private void initialize() {
        this.guiEulaDlg = this;
        this.setSize(700, 600);
        this.setLocationRelativeTo(null);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle(UtilLocale.getString("TXT_END_USER_LICENSE_AGREEMENT"));
        this.setContentPane(this.getPanelEula());
        if (!this.showLocalEula) {
            this.setDefaultCloseOperation(0);
        }
    }

    private AastraPanel getPanelEula() {
        if (this.panelEula == null) {
            this.panelEula = new AastraPanel();
            this.panelEula.setLayout(new BorderLayout());
            this.panelEula.add((Component)this.getScrollPaneEula(), "Center");
            this.panelEula.add((Component)this.getPanelButtonBar(), "South");
            this.getRootPane().setDefaultButton(this.getButtonOK());
        }
        return this.panelEula;
    }

    private AastraScrollPane getScrollPaneEula() {
        if (this.scrollPaneEula == null) {
            this.textAreaEula = new AastraTextArea(0, 0);
            this.textAreaEula.setEditable(false);
            if (this.showLocalEula) {
                String string = UtilProdInfo.getEula(this.getClass());
                if (string != null) {
                    this.textAreaEula.setText(string);
                    this.textAreaEula.setCaretPosition(0);
                }
            } else {
                OmiFileTransfer.StartFileTransferReturnEnum startFileTransferReturnEnum = OmiFileTransfer.startFileTransfer(OmiMessage.elemIds.GetFile, ":eula", this.remoteEulaPath, this.guiEulaDlg);
                switch (startFileTransferReturnEnum) {
                    case FILETRANSFER_START_OK: {
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "EULA download started successfully");
                        this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_BUSY, UtilLocale.getString("TXT_DOWNLOADING_EULA"));
                        break;
                    }
                    case FILETRANSFER_ACTIVE: {
                        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "EULA download error: Another file transfer is still active");
                        break;
                    }
                    case WRONG_PARAM: {
                        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "EULA download error: Wrong parameters");
                        break;
                    }
                    case FILE_TRANSFER_NOT_INITIALIZED: {
                        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "EULA download error: File transfer not initialized");
                        break;
                    }
                    case LOCAL_FILE_ERROR: {
                        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "EULA download error: Local file access failed");
                        break;
                    }
                    case NO_LINK_TO_OMM: {
                        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "EULA download error: OMM link failed");
                        break;
                    }
                    default: {
                        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "EULA download error: Unknown");
                    }
                }
            }
            this.scrollPaneEula = new AastraScrollPane(this.textAreaEula, 20, 30);
        }
        return this.scrollPaneEula;
    }

    private AastraPanel getPanelButtonBar() {
        if (this.panelButtonBar == null) {
            this.panelButtonBar = new AastraPanel();
            this.panelButtonBar.setPreferredSize(new Dimension(0, 65));
            this.panelButtonBar.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.panelButtonBar.add((Component)this.getButtonOK(), gridBagConstraints);
        }
        return this.panelButtonBar;
    }

    private AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            this.buttonOK = new AastraButton();
            this.buttonOK.setPreferredSize(new Dimension(90, 25));
            if (this.showLocalEula) {
                this.buttonOK.setText(UtilLocale.getString("TXT_OK"));
            } else {
                this.buttonOK.setText(UtilLocale.getString("TXT_ACCEPT"));
            }
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiEulaDlg.this.setVisible(false);
                }
            });
        }
        return this.buttonOK;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void omiFileTransferNotification(String var1_1, OmiFileTransfer.OmiFileTransferEvents var2_2, OmiMessage var3_3, int var4_4) {
        var5_5 = null;
        if (var1_1 != null && !var1_1.equals(":eula")) {
            return;
        }
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "File transfer event: " + var2_2.toString() + ",remoteFile='" + var1_1 + "',progress=" + var4_4 + "%");
        switch (2.$SwitchMap$com$aastra$omilib$OmiFileTransfer$OmiFileTransferEvents[var2_2.ordinal()]) {
            case 1: {
                GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_EULA_DOWNLOAD_SUCCESSFUL"), new Object[0]));
                var6_6 = new File(this.remoteEulaPath);
                var7_7 = (int)var6_6.length();
                if (var7_7 <= 0) ** GOTO lbl30
                try {
                    var8_8 = new FileInputStream(var6_6);
                    var9_11 = new InputStreamReader((InputStream)var8_8, Charset.forName("UTF-8"));
                    var10_12 = new char[var7_7];
                    var11_13 = var9_11.read(var10_12, 0, var7_7);
                    var9_11.close();
                    if (var11_13 == -1) ** GOTO lbl22
                    var5_5 = new String(var10_12).substring(0, var11_13 - 1);
                    this.textAreaEula.setText(var5_5);
                    this.textAreaEula.setCaretPosition(0);
                    ** GOTO lbl31
lbl22:
                    // 1 sources

                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilProdInfo.class, "File '" + this.remoteEulaPath + "' empty");
                }
                catch (FileNotFoundException var8_9) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilProdInfo.class, "File '" + this.remoteEulaPath + "' not found");
                }
                catch (IOException var8_10) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilProdInfo.class, "Reading file '" + this.remoteEulaPath + "' failed");
                }
                ** GOTO lbl31
lbl30:
                // 1 sources

                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilProdInfo.class, "File '" + this.remoteEulaPath + "' not found");
lbl31:
                // 5 sources

                this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
                break;
            }
            case 2: {
                GuiInfoConsole.showError(UtilLocale.getString("TXT_EULA_DOWNLOAD_FAILED") + ": " + UtilLocale.getString("TXT_TRANSFER_ERROR"));
                this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
                break;
            }
            case 3: {
                GuiInfoConsole.showError(UtilLocale.getString("TXT_EULA_DOWNLOAD_FAILED") + ": " + UtilLocale.getString("TXT_FILE_NAME_CONFLICT"));
                this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
                break;
            }
            case 4: {
                GuiInfoConsole.showError(UtilLocale.getString("TXT_EULA_DOWNLOAD_FAILED") + ": " + UtilLocale.getString("TXT_FILE_OFFSET_MISMATCH"));
                this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
                break;
            }
        }
    }
}

