/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.gui;

import com.aastra.oamp.gui.GuiAboutDlg;
import com.aastra.oamp.gui.GuiEulaDlg;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.gui.GuiOptionsDlg;
import com.aastra.oamp.gui.GuiSpyConsole;
import com.aastra.oamp.gui.GuiVersionInfoDlg;
import com.aastra.oamp.util.UtilConvert;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilProdInfo;
import com.aastra.omilib.VersionHandler;
import com.aastra.style.AastraCheckBoxMenuItem;
import com.aastra.style.AastraMenu;
import com.aastra.style.AastraMenuBar;
import com.aastra.style.AastraMenuItem;
import com.aastra.util.UtilSpy;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class GuiMenuBar
extends AastraMenuBar {
    private static final long serialVersionUID = 1L;
    private GuiMain guiMain = null;
    private VersionHandler versionHandler = null;
    private AastraMenu menuHelp = null;
    private AastraMenu menuGeneral = null;
    private AastraMenu menuDebug = null;
    private AastraMenuItem menuItemOptions = null;
    private AastraMenuItem menuItemExit = null;
    private AastraCheckBoxMenuItem menuItemSpyConsole = null;
    private AastraMenuItem menuItemException = null;
    private AastraMenuItem menuItemDefaultSize = null;
    private AastraMenuItem menuItemAboutAXI = null;
    private AastraMenuItem menuItemEula = null;
    private AastraMenuItem menuItemAboutOMP = null;
    private GuiSpyConsole spyConsole = GuiMain.getSpyConsole();

    public GuiMenuBar(VersionHandler versionHandler) {
        this.guiMain = GuiMain.getGuiMainObject();
        this.versionHandler = versionHandler;
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(350, 26));
        this.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.add(this.getMenuHelp());
        this.add(this.getMenuGeneral());
        if (UtilProdInfo.isPrivateProduction()) {
            this.add(this.getMenuDebug());
        }
        this.spyConsole.initializeGuiMenuBarObject(this);
    }

    private AastraMenu getMenuDebug() {
        if (this.menuDebug == null) {
            this.menuDebug = new AastraMenu();
            this.menuDebug.setText("Debug");
            this.menuDebug.add(this.getMenuItemSpyConsole());
            this.menuDebug.add(this.getMenuItemException());
            this.menuDebug.add(this.getMenuItemDefaultSize());
        }
        return this.menuDebug;
    }

    private AastraMenu getMenuHelp() {
        if (this.menuHelp == null) {
            this.menuHelp = new AastraMenu();
            String string = UtilLocale.getString("TXT_HELP");
            this.menuHelp.setText(string);
            Integer n = null;
            for (int i = 0; i < string.length() && (n = UtilConvert.getKeyEvent(Character.valueOf(string.charAt(i)))) == null; ++i) {
            }
            if (n != null) {
                this.menuHelp.setMnemonic(n);
            }
            this.menuHelp.add(this.getMenuItemEula());
            this.menuHelp.add(this.getMenuItemAboutAXI());
            this.menuHelp.add(this.getMenuItemAboutOMP());
        }
        return this.menuHelp;
    }

    private AastraCheckBoxMenuItem getMenuItemSpyConsole() {
        if (this.menuItemSpyConsole == null) {
            this.menuItemSpyConsole = new AastraCheckBoxMenuItem();
            this.menuItemSpyConsole.setText(UtilLocale.getString("TXT_EXPERT_CONSOLE"));
            this.menuItemSpyConsole.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (GuiMenuBar.this.menuItemSpyConsole.isSelected()) {
                        GuiMenuBar.this.spyConsole.setVisible(true);
                        UtilSpy.spySetOutputConfiguration(true, true);
                    } else {
                        GuiMenuBar.this.spyConsole.setVisible(false);
                        UtilSpy.spySetOutputConfiguration(true, false);
                    }
                }
            });
        }
        return this.menuItemSpyConsole;
    }

    private AastraMenuItem getMenuItemException() {
        if (this.menuItemException == null) {
            this.menuItemException = new AastraMenuItem();
            this.menuItemException.setText("Throw exception");
            this.menuItemException.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    throw new NullPointerException();
                }
            });
        }
        return this.menuItemException;
    }

    private AastraMenuItem getMenuItemDefaultSize() {
        if (this.menuItemDefaultSize == null) {
            this.menuItemDefaultSize = new AastraMenuItem();
            this.menuItemDefaultSize.setText("Set default size");
            this.menuItemDefaultSize.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiMenuBar.this.guiMain.setSize(1024, 810);
                }
            });
        }
        return this.menuItemDefaultSize;
    }

    private AastraMenuItem getMenuItemEula() {
        if (this.menuItemEula == null) {
            this.menuItemEula = new AastraMenuItem();
            String string = UtilLocale.getString("TXT_INFO_20");
            this.menuItemEula.setText(string);
            Integer n = null;
            for (int i = 0; i < string.length() && (n = UtilConvert.getKeyEvent(Character.valueOf(string.charAt(i)))) == null; ++i) {
            }
            if (n != null) {
                this.menuItemEula.setMnemonic(n);
            }
            this.menuItemEula.setEnabled(true);
            this.menuItemEula.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiEulaDlg guiEulaDlg = new GuiEulaDlg(GuiMenuBar.this.guiMain, true, null);
                    guiEulaDlg.setVisible(true);
                }
            });
        }
        return this.menuItemEula;
    }

    private AastraMenuItem getMenuItemAboutAXI() {
        if (this.menuItemAboutAXI == null) {
            this.menuItemAboutAXI = new AastraMenuItem();
            String string = UtilLocale.getString("TXT_ABOUT") + " AXI";
            this.menuItemAboutAXI.setText(string);
            Integer n = null;
            for (int i = 0; i < string.length() && ((n = UtilConvert.getKeyEvent(Character.valueOf(string.charAt(i)))) == null || n.compareTo(this.menuItemEula.getMnemonic()) == 0); ++i) {
            }
            if (n != null) {
                this.menuItemAboutAXI.setMnemonic(n);
            }
            this.menuItemAboutAXI.setEnabled(true);
            this.menuItemAboutAXI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiVersionInfoDlg guiVersionInfoDlg = new GuiVersionInfoDlg(GuiMenuBar.this.versionHandler);
                    guiVersionInfoDlg.setVisible(true);
                }
            });
        }
        return this.menuItemAboutAXI;
    }

    private AastraMenuItem getMenuItemAboutOMP() {
        if (this.menuItemAboutOMP == null) {
            this.menuItemAboutOMP = new AastraMenuItem();
            String string = UtilLocale.getString("TXT_ABOUT") + " " + "OMP";
            this.menuItemAboutOMP.setText(string);
            Integer n = null;
            for (int i = 0; i < string.length() && ((n = UtilConvert.getKeyEvent(Character.valueOf(string.charAt(i)))) == null || n.compareTo(this.menuItemEula.getMnemonic()) == 0 || n.compareTo(this.menuItemAboutAXI.getMnemonic()) == 0); ++i) {
            }
            if (n != null) {
                this.menuItemAboutOMP.setMnemonic(n);
            }
            this.menuItemAboutOMP.setEnabled(true);
            this.menuItemAboutOMP.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiAboutDlg guiAboutDlg = new GuiAboutDlg(GuiMenuBar.this.guiMain);
                    guiAboutDlg.setVisible(true);
                }
            });
        }
        return this.menuItemAboutOMP;
    }

    public void setMenuItemSpyConsole(Boolean bl) {
        this.menuItemSpyConsole.setSelected(bl);
    }

    private AastraMenu getMenuGeneral() {
        if (this.menuGeneral == null) {
            this.menuGeneral = new AastraMenu();
            String string = UtilLocale.getString("TXT_GENERAL");
            this.menuGeneral.setText(string);
            Integer n = null;
            for (int i = 0; i < string.length() && ((n = UtilConvert.getKeyEvent(Character.valueOf(string.charAt(i)))) == null || n == Integer.valueOf(this.menuHelp.getMnemonic())); ++i) {
            }
            if (n != null) {
                this.menuGeneral.setMnemonic(n);
            }
            this.menuGeneral.add(this.getMenuItemOptions());
            this.menuGeneral.add(this.getMenuItemExit());
        }
        return this.menuGeneral;
    }

    private AastraMenuItem getMenuItemOptions() {
        if (this.menuItemOptions == null) {
            this.menuItemOptions = new AastraMenuItem();
            String string = UtilLocale.getString("TXT_OPTIONS");
            this.menuItemOptions.setText(string);
            Integer n = UtilConvert.getKeyEvent(Character.valueOf(string.charAt(0)));
            if (n != null) {
                this.menuItemOptions.setMnemonic(n);
            }
            this.menuItemOptions.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiOptionsDlg guiOptionsDlg = new GuiOptionsDlg();
                    guiOptionsDlg.setVisible(true);
                }
            });
        }
        return this.menuItemOptions;
    }

    private AastraMenuItem getMenuItemExit() {
        if (this.menuItemExit == null) {
            this.menuItemExit = new AastraMenuItem();
            String string = UtilLocale.getString("TXT_EXIT");
            this.menuItemExit.setText(string);
            Integer n = null;
            for (int i = 0; i < string.length() && ((n = UtilConvert.getKeyEvent(Character.valueOf(string.charAt(i)))) == null || n == Integer.valueOf(this.menuItemOptions.getMnemonic())); ++i) {
            }
            if (n != null) {
                this.menuItemExit.setMnemonic(n);
            }
            this.menuItemExit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (GuiMenuBar.this.guiMain != null) {
                        GuiMenuBar.this.guiMain.exitApplication(true, null);
                    }
                }
            });
        }
        return this.menuItemExit;
    }
}

