/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.gui;

import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.gui.GuiNavigationNodeInfo;
import com.aastra.style.AastraScrollPane;
import com.aastra.style.AastraSplitPane;
import com.aastra.style.AastraTree;
import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class GuiNavigationPanel
extends AastraScrollPane
implements GuiComponentActivationInterface {
    private static final long serialVersionUID = 1L;
    private AastraSplitPane parentSplitPane = null;
    private AastraTree tree = null;
    public GuiNavigationNodeInfo activeComponent = null;
    private TreePath lastExpandedPath = null;

    public GuiNavigationPanel(AastraTree aastraTree, AastraSplitPane aastraSplitPane) {
        super(aastraTree);
        this.parentSplitPane = aastraSplitPane;
        this.setBorder(new EmptyBorder(0, 0, 0, 2));
        this.tree = aastraTree;
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }
        });
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                if (treeExpansionEvent.getPath().getParentPath() == null) {
                    throw new ExpandVetoException(treeExpansionEvent);
                }
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)GuiNavigationPanel.this.tree.getLastSelectedPathComponent();
                if (defaultMutableTreeNode == null) {
                    return;
                }
                TreePath treePath = treeSelectionEvent.getPath();
                if (GuiNavigationPanel.this.lastExpandedPath != null) {
                    if (!GuiNavigationPanel.this.lastExpandedPath.equals(treePath)) {
                        EventQueue.invokeLater(new CollapseExpandHandler(treePath));
                    }
                } else {
                    EventQueue.invokeLater(new CollapseExpandHandler(treePath));
                }
                Object object = defaultMutableTreeNode.getUserObject();
                try {
                    GuiNavigationNodeInfo guiNavigationNodeInfo = (GuiNavigationNodeInfo)object;
                    if (guiNavigationNodeInfo != null && guiNavigationNodeInfo.component != null && GuiNavigationPanel.this.parentSplitPane != null && GuiNavigationPanel.this.activeComponent != guiNavigationNodeInfo) {
                        GuiNavigationPanel.this.deactivatePanel(GuiNavigationPanel.this.activeComponent);
                        GuiNavigationPanel.this.activatePanel(guiNavigationNodeInfo, GuiNavigationPanel.this.activeComponent);
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        });
    }

    public void deactivatePanel(GuiNavigationNodeInfo guiNavigationNodeInfo) {
        if (guiNavigationNodeInfo != null && guiNavigationNodeInfo.activationNotifyObject != null) {
            guiNavigationNodeInfo.activationNotifyObject.componentDeactivated();
        }
    }

    public void activatePanel(GuiNavigationNodeInfo guiNavigationNodeInfo, GuiNavigationNodeInfo guiNavigationNodeInfo2) {
        this.parentSplitPane.setRightComponent(guiNavigationNodeInfo.component);
        this.parentSplitPane.invalidate();
        if (guiNavigationNodeInfo.activationNotifyObject != null) {
            if (guiNavigationNodeInfo2 != null) {
                guiNavigationNodeInfo.activationNotifyObject.componentActivated(guiNavigationNodeInfo2.component);
            } else {
                guiNavigationNodeInfo.activationNotifyObject.componentActivated(null);
            }
        }
        this.activeComponent = guiNavigationNodeInfo;
    }

    public static DefaultMutableTreeNode addEntry(DefaultMutableTreeNode defaultMutableTreeNode, String string, Component component) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new GuiNavigationNodeInfo(string, component));
        if (defaultMutableTreeNode != null) {
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode2;
    }

    public static DefaultMutableTreeNode addEntry(DefaultMutableTreeNode defaultMutableTreeNode, String string, Component component, GuiComponentActivationInterface guiComponentActivationInterface) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new GuiNavigationNodeInfo(string, component, guiComponentActivationInterface));
        if (defaultMutableTreeNode != null) {
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode2;
    }

    public void treeChanged() {
        if (this.tree != null) {
            this.tree.updateUI();
        }
    }

    @Override
    public void componentActivated(Component component) {
        if (component != null && component.getClass() == GuiNavigationPanel.class) {
            GuiNavigationPanel guiNavigationPanel = (GuiNavigationPanel)component;
            guiNavigationPanel.deactivatePanel(guiNavigationPanel.activeComponent);
            if (this.activeComponent == null) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
                Object object = defaultMutableTreeNode.getUserObject();
                try {
                    GuiNavigationNodeInfo guiNavigationNodeInfo = (GuiNavigationNodeInfo)object;
                    this.activatePanel(guiNavigationNodeInfo, guiNavigationPanel.activeComponent);
                }
                catch (ClassCastException classCastException) {}
            } else {
                this.activatePanel(this.activeComponent, guiNavigationPanel.activeComponent);
            }
        }
    }

    public void presetActiveComponent(Component component) {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.findComponent(defaultMutableTreeNode, component);
        if (defaultMutableTreeNode2 != null && (object = defaultMutableTreeNode2.getUserObject()) != null) {
            try {
                GuiNavigationNodeInfo guiNavigationNodeInfo;
                this.activeComponent = guiNavigationNodeInfo = (GuiNavigationNodeInfo)object;
                this.tree.setSelectionPath(new TreePath(defaultMutableTreeNode2.getPath()));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    @Override
    public void componentDeactivated() {
    }

    private DefaultMutableTreeNode findComponent(DefaultMutableTreeNode defaultMutableTreeNode, Component component) {
        Object object;
        Object object2 = defaultMutableTreeNode.getUserObject();
        if (object2 != null) {
            try {
                object = (GuiNavigationNodeInfo)object2;
                if (((GuiNavigationNodeInfo)object).component != null && ((GuiNavigationNodeInfo)object).component == component) {
                    return defaultMutableTreeNode;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        object = defaultMutableTreeNode.children();
        while (object.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.findComponent((DefaultMutableTreeNode)object.nextElement(), component);
            if (defaultMutableTreeNode2 == null) continue;
            return defaultMutableTreeNode2;
        }
        return null;
    }

    public void activateComponent(Component component) {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.findComponent(defaultMutableTreeNode, component);
        if (defaultMutableTreeNode2 != null && (object = defaultMutableTreeNode2.getUserObject()) != null) {
            try {
                GuiNavigationNodeInfo guiNavigationNodeInfo = (GuiNavigationNodeInfo)object;
                this.deactivatePanel(this.activeComponent);
                this.activatePanel(guiNavigationNodeInfo, this.activeComponent);
                this.tree.setSelectionPath(new TreePath(defaultMutableTreeNode2.getPath()));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public class CollapseExpandHandler
    implements Runnable {
        public TreePath expandPath;

        public CollapseExpandHandler(TreePath treePath) {
            this.expandPath = treePath;
        }

        @Override
        public void run() {
            if (GuiNavigationPanel.this.lastExpandedPath != null) {
                int n = GuiNavigationPanel.this.lastExpandedPath.getPathCount();
                int n2 = this.expandPath.getPathCount();
                while (n-- >= n2) {
                    GuiNavigationPanel.this.tree.collapsePath(GuiNavigationPanel.this.lastExpandedPath);
                    GuiNavigationPanel.this.lastExpandedPath = GuiNavigationPanel.this.lastExpandedPath.getParentPath();
                }
            }
            GuiNavigationPanel.this.tree.expandPath(this.expandPath);
            GuiNavigationPanel.this.lastExpandedPath = this.expandPath;
        }
    }
}

