/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.gui;

import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraDialog;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraProgressBar;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class GuiProgressDlg
extends AastraDialog
implements OmiManagementEventInterface {
    private static final long serialVersionUID = 1L;
    private OmiManagement omiManagement = null;
    private AastraPanel progressPanel = null;
    private AastraProgressBar progressBar = null;
    private AastraLabel labelIcon = null;
    private AastraLabel labelText = null;
    protected AastraButton buttonCancel = null;
    private String text = null;
    private boolean indeterminate = false;
    private boolean stringPainted = false;

    public GuiProgressDlg(String string, boolean bl, boolean bl2) {
        super(GuiMain.getGuiMainObject());
        this.text = string;
        this.indeterminate = bl;
        this.stringPainted = bl2;
        this.omiManagement = GuiMain.getOmiManagementObject();
        this.omiManagement.registerManagementEventListener(this);
        this.initialize();
    }

    private void initialize() {
        this.setSize(400, 195);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle(UtilLocale.getString("TXT_INFO"));
        this.setContentPane(this.getProgressPanel());
    }

    private AastraPanel getProgressPanel() {
        if (this.progressPanel == null) {
            this.progressPanel = new AastraPanel();
            this.progressPanel.setLayout(null);
            this.labelIcon = new AastraLabel();
            this.labelIcon.setBounds(30, 20, 25, 25);
            this.labelIcon.setIcon(GuiUtilIcon.getIconInfo(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeLarge));
            this.labelText = new AastraLabel();
            this.labelText.setBounds(70, 20, 290, 25);
            this.labelText.setText(this.text);
            this.labelText.setVerticalAlignment(0);
            this.progressPanel.add((Component)this.labelIcon, null);
            this.progressPanel.add((Component)this.labelText, null);
            this.progressPanel.add((Component)this.getProgressBar(), null);
            this.progressPanel.add((Component)this.getButtonCancel(), null);
            this.buttonCancelAddActionListener();
        }
        return this.progressPanel;
    }

    private AastraProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new AastraProgressBar(0, 100);
            this.progressBar.setBounds(30, 70, 330, 20);
            if (this.indeterminate) {
                this.progressBar.setIndeterminate(true);
            }
            if (this.stringPainted) {
                this.progressBar.setStringPainted(true);
            }
        }
        return this.progressBar;
    }

    private AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new AastraButton();
            this.buttonCancel.setText(UtilLocale.getString("TXT_CANCEL"));
            this.buttonCancel.setBounds(150, 120, 90, 25);
        }
        return this.buttonCancel;
    }

    protected void buttonCancelAddActionListener() {
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GuiProgressDlg.this.dispose();
            }
        });
    }

    public void setValue(int n) {
        if (n < 0 || n > 100 || this.indeterminate) {
            return;
        }
        this.progressBar.setValue(n);
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        if (omiManagementEventEnum == OmiManagementEventEnum.LINK_CLOSED) {
            this.dispose();
        }
    }
}

