/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.gui;

import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.gui.GuiNavigationPanel;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilMisc;
import com.aastra.omilib.OmiMessage;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraContentButton;
import com.aastra.style.AastraSplitPane;
import com.aastra.style.AastraToolBar;
import com.aastra.util.UtilResource;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ImageIcon;

public class GuiToolBar
extends AastraToolBar {
    private static final long serialVersionUID = 1L;
    private AastraSplitPane splitPane = null;
    private AastraContentButton buttonConfig = null;
    private AastraContentButton buttonMonitor = null;
    private AastraContentButton buttonPlanning = null;
    private GuiNavigationPanel panelConfig = null;
    private GuiNavigationPanel panelMonitor = null;
    private GuiNavigationPanel panelPlanning = null;
    private GuiNavigationPanel panelActive = null;

    public GuiToolBar(AastraSplitPane aastraSplitPane) {
        this.splitPane = aastraSplitPane;
        this.initialize();
    }

    private void initialize() {
        this.add(Box.createRigidArea(new Dimension(30, 84)));
        this.add(this.getButtonConfiguration());
        this.add(Box.createRigidArea(new Dimension(28, 84)));
        this.add(this.getButtonMonitoring());
        this.add(Box.createRigidArea(new Dimension(28, 84)));
        this.add(this.getButtonPlanning());
    }

    public void initializePanelsAndButtons(GuiNavigationPanel guiNavigationPanel, GuiNavigationPanel guiNavigationPanel2, GuiNavigationPanel guiNavigationPanel3, GuiNavigationPanel guiNavigationPanel4) {
        OmiMessage.PermissionType[] permissionTypeArray = GuiMain.getOmiManagementObject().getOmmPermissions();
        boolean bl = UtilMisc.getPermission(permissionTypeArray, OmiMessage.PermissionType.AllCnfWrite);
        this.panelConfig = guiNavigationPanel;
        this.panelMonitor = guiNavigationPanel2;
        this.panelPlanning = guiNavigationPanel3;
        if (bl) {
            this.selectButton(GuiToolBarButtonEnum.GuiToolBarButtonConfig);
            this.buttonConfig.setEnabled(true);
            this.buttonMonitor.setEnabled(true);
            this.buttonPlanning.setEnabled(true);
        } else {
            this.selectButton(GuiToolBarButtonEnum.GuiToolBarButtonMonitor);
            this.buttonConfig.setEnabled(false);
            this.buttonMonitor.setEnabled(true);
        }
    }

    private AastraContentButton getButtonConfiguration() {
        if (this.buttonConfig == null) {
            this.buttonConfig = new AastraContentButton();
            this.buttonConfig.setPreferredSize(new Dimension(36, 36));
            this.buttonConfig.setMaximumSize(new Dimension(36, 36));
            ImageIcon imageIcon = UtilResource.createImageIcon(GuiUtilIcon.class, "Settings-36_white.png", 36, 36);
            this.buttonConfig.setIconUnselected(imageIcon);
            imageIcon = UtilResource.createImageIcon(GuiUtilIcon.class, "Settings-36_blue.png", 36, 36);
            this.buttonConfig.setIconSelected(imageIcon);
            imageIcon = UtilResource.createImageIcon(GuiUtilIcon.class, "Settings-36_disabled.png", 36, 36);
            this.buttonConfig.setIconDisabled(imageIcon);
            this.buttonConfig.setRolloverEnabled(true);
            this.buttonConfig.setBgNormal(AastraCommon.MitelColorDarkBackground);
            this.buttonConfig.setBgHover(AastraCommon.MitelToolbarButtonHover);
            this.buttonConfig.setEnabled(false);
            this.buttonConfig.setToolTipText(UtilLocale.getString("TXT_CONFIGURATION_20"));
            this.buttonConfig.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiToolBar.this.selectButton(GuiToolBarButtonEnum.GuiToolBarButtonConfig);
                }
            });
        }
        return this.buttonConfig;
    }

    private AastraContentButton getButtonMonitoring() {
        if (this.buttonMonitor == null) {
            this.buttonMonitor = new AastraContentButton();
            this.buttonMonitor.setPreferredSize(new Dimension(36, 36));
            this.buttonMonitor.setMaximumSize(new Dimension(36, 36));
            ImageIcon imageIcon = UtilResource.createImageIcon(GuiUtilIcon.class, "Search-36-white.png", 36, 36);
            this.buttonMonitor.setIconUnselected(imageIcon);
            imageIcon = UtilResource.createImageIcon(GuiUtilIcon.class, "Search-36-blue.png", 36, 36);
            this.buttonMonitor.setIconSelected(imageIcon);
            imageIcon = UtilResource.createImageIcon(GuiUtilIcon.class, "Search-36-disabled.png", 36, 36);
            this.buttonMonitor.setIconDisabled(imageIcon);
            this.buttonMonitor.setRolloverEnabled(true);
            this.buttonMonitor.setBgNormal(AastraCommon.MitelColorDarkBackground);
            this.buttonMonitor.setBgHover(AastraCommon.MitelToolbarButtonHover);
            this.buttonMonitor.setEnabled(false);
            this.buttonMonitor.setToolTipText(UtilLocale.getString("TXT_MONITORING_20"));
            this.buttonMonitor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiToolBar.this.selectButton(GuiToolBarButtonEnum.GuiToolBarButtonMonitor);
                }
            });
        }
        return this.buttonMonitor;
    }

    private AastraContentButton getButtonPlanning() {
        if (this.buttonPlanning == null) {
            this.buttonPlanning = new AastraContentButton();
            this.buttonPlanning.setPreferredSize(new Dimension(36, 36));
            this.buttonPlanning.setMaximumSize(new Dimension(36, 36));
            ImageIcon imageIcon = UtilResource.createImageIcon(GuiUtilIcon.class, "Edit-36_white.png", 36, 36);
            this.buttonPlanning.setIconUnselected(imageIcon);
            imageIcon = UtilResource.createImageIcon(GuiUtilIcon.class, "Edit-36_blue.png", 36, 36);
            this.buttonPlanning.setIconSelected(imageIcon);
            imageIcon = UtilResource.createImageIcon(GuiUtilIcon.class, "Edit-36_disabled.png", 36, 36);
            this.buttonPlanning.setIconDisabled(imageIcon);
            this.buttonPlanning.setRolloverEnabled(true);
            this.buttonPlanning.setBgNormal(AastraCommon.MitelColorDarkBackground);
            this.buttonPlanning.setBgHover(AastraCommon.MitelToolbarButtonHover);
            this.buttonPlanning.setEnabled(false);
            this.buttonPlanning.setToolTipText(UtilLocale.getString("TXT_PLANNING_20"));
            this.buttonPlanning.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiToolBar.this.selectButton(GuiToolBarButtonEnum.GuiToolBarButtonPlanning);
                }
            });
        }
        return this.buttonPlanning;
    }

    private void selectButton(GuiToolBarButtonEnum guiToolBarButtonEnum) {
        switch (guiToolBarButtonEnum) {
            case GuiToolBarButtonConfig: {
                this.buttonMonitor.select(false);
                this.buttonPlanning.select(false);
                this.buttonConfig.select(true);
                this.splitPane.setLeftComponent(this.panelConfig);
                if (this.panelActive != null) {
                    this.panelActive.componentDeactivated();
                    this.panelConfig.componentActivated(this.panelActive);
                }
                this.panelActive = this.panelConfig;
                break;
            }
            case GuiToolBarButtonMonitor: {
                this.buttonConfig.select(false);
                this.buttonMonitor.select(true);
                this.buttonPlanning.select(false);
                this.splitPane.setLeftComponent(this.panelMonitor);
                if (this.panelActive != null) {
                    this.panelActive.componentDeactivated();
                    this.panelMonitor.componentActivated(this.panelActive);
                }
                this.panelActive = this.panelMonitor;
                break;
            }
            case GuiToolBarButtonPlanning: {
                this.buttonConfig.select(false);
                this.buttonMonitor.select(false);
                this.buttonPlanning.select(true);
                this.splitPane.setLeftComponent(this.panelPlanning);
                if (this.panelActive != null) {
                    this.panelActive.componentDeactivated();
                    this.panelPlanning.componentActivated(this.panelActive);
                }
                this.panelActive = this.panelPlanning;
                break;
            }
        }
    }

    public void setButton(GuiToolBarButtonEnum guiToolBarButtonEnum, boolean bl) {
        switch (guiToolBarButtonEnum) {
            case GuiToolBarButtonConfig: {
                this.buttonConfig.setVisible(bl);
                break;
            }
            case GuiToolBarButtonMonitor: {
                this.buttonMonitor.setVisible(bl);
                break;
            }
            case GuiToolBarButtonPlanning: {
                this.buttonPlanning.setVisible(bl);
                break;
            }
        }
    }

    public static enum GuiToolBarButtonEnum {
        GuiToolBarButtonConfig,
        GuiToolBarButtonMonitor,
        GuiToolBarButtonPlanning;

    }
}

