/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.pp;

import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.gui.GuiProgressDlgCancel;
import com.aastra.oamp.gui.GuiStatusBar;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.pp.PpConfigDetailPanel;
import com.aastra.oamp.pp.PpConfigTaskPanel;
import com.aastra.oamp.pp.PpUtil;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilFilterTable;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilMisc;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.oamp.util.UtilPrint;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.DatabaseChangeEvent;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.PpDataHandler;
import com.aastra.omilib.PpDataNotificationInterface;
import com.aastra.omilib.PpDataRecord;
import com.aastra.omilib.PpDevDataRecord;
import com.aastra.omilib.PpEventEnum;
import com.aastra.omilib.PpUserDataRecord;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;

public class PpConfigMainPanel
extends AastraPanel
implements ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface,
GuiComponentActivationInterface,
DataHandler.DataHandlerSendBulkInterface,
GuiProgressDlgCancel.GuiProgressDlgCancelInterface {
    private static final long serialVersionUID = 1L;
    protected static final int xSizeDetailPanelSurcharge = 300;
    protected static final int ySizeDetailPanelSurcharge = 180;
    protected static final int ySizeDetailPanel = 390;
    private CommonDataHandler commonDataHandler = null;
    private PpDataHandler ppDataHandler = null;
    private NotificationHandlerClass ppUserHandler = null;
    private NotificationHandlerClass ppDevHandler = null;
    private GuiUtilDetailSplitPanel ppDetailSplitPane = null;
    private AastraScrollPane ppTablePane = null;
    private PpConfigDetailPanel ppDetailPanel = null;
    private PpConfigTaskPanel ppTaskPanel = null;
    private GuiUtilConfiguratorTable ppTable = null;
    private GuiStatusBar guiStatusBar = null;
    private boolean detailPanelPending = false;
    private HashMap<Integer, Boolean> pendingUid = new HashMap();
    private HashMap<Integer, Boolean> pendingPpn = new HashMap();
    private int dividerLocation = 0;
    private boolean ppTableConfigIdxArrayChecked = false;
    private boolean ppTableConfigIdxArrayDefaultChecked = false;
    private int[] activePpConfigColumns = null;
    private int cntNotificationsToReceive = 0;
    private boolean componentActivated = false;
    private OmiManagement omiManagement = null;
    private int cntPPSendBulkTotal;
    private int cntPPToChange;
    private DataHandler.SendBulkActionType sendBulkAction = null;
    private GuiProgressDlgCancel guiProgressDlg = null;
    private UtilErrorComp utilErrorComp = null;
    private int[] ppTableConfigIdxArray = new int[]{PpDataRecord.devDataIdx(PpDevDataRecord.IDX_PPN), PpDataRecord.devDataIdx(PpDevDataRecord.IDX_IPEI), PpDataRecord.devDataIdx(PpDevDataRecord.IDX_AC), PpDataRecord.devDataIdx(PpDevDataRecord.IDX_ENCRYPT), PpUserDataRecord.IDX_NAME, PpUserDataRecord.IDX_NUM, PpUserDataRecord.IDX_HIERARCHY1, PpUserDataRecord.IDX_HIERARCHY2, PpUserDataRecord.IDX_ADD_ID, PpUserDataRecord.IDX_SOS_NUM, PpUserDataRecord.IDX_MAN_DOWN_NUM, PpUserDataRecord.IDX_TRACKING_ACTIVE, PpUserDataRecord.IDX_LOCATABLE, PpUserDataRecord.IDX_LOC_RIGHT, PpUserDataRecord.IDX_MSG_RIGHT, PpUserDataRecord.IDX_SEND_VCARD_RIGHT, PpUserDataRecord.IDX_RECV_VCARD_RIGHT, PpUserDataRecord.IDX_VIP, PpUserDataRecord.IDX_SIP_REGISTER_CHECK, PpUserDataRecord.IDX_FIXED_SIP_PORT, PpUserDataRecord.IDX_CALCULATED_SIP_PORT};
    private int[] ppTableConfigIdxArrayDefault = new int[]{PpDataRecord.devDataIdx(PpDevDataRecord.IDX_IPEI), PpUserDataRecord.IDX_NAME, PpUserDataRecord.IDX_NUM, PpDataRecord.devDataIdx(PpDevDataRecord.IDX_PPN)};

    public PpConfigMainPanel(CommonDataHandler commonDataHandler, PpDataHandler ppDataHandler) {
        this.guiStatusBar = GuiMain.getGuiStatusBarObject();
        this.commonDataHandler = commonDataHandler;
        this.ppDataHandler = ppDataHandler;
        PpUtil.initOmiHandler(this.ppDataHandler.getOmiHandler());
        this.ppUserHandler = new NotificationHandlerClass();
        this.ppUserHandler.notificationType = NotificationTypeEnum.USER_NOTIFICATION;
        this.ppDataHandler.registerUserDataNotificationListener(this.ppUserHandler);
        this.ppDevHandler = new NotificationHandlerClass();
        this.ppDevHandler.notificationType = NotificationTypeEnum.DEVICE_NOTIFICATION;
        this.ppDataHandler.registerDevDataNotificationListener(this.ppDevHandler);
        this.omiManagement = GuiMain.getOmiManagementObject();
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPpDetailSplitPane(), "Center");
        this.add((Component)this.getPpTaskPanel(), "East");
        this.utilErrorComp = new UtilErrorComp();
    }

    private int[] getPpTableConfigIdxArrayDefault() {
        int n = 1;
        int n2 = this.ppTableConfigIdxArrayDefault.length;
        if (!this.ppTableConfigIdxArrayDefaultChecked) {
            this.ppTableConfigIdxArrayDefaultChecked = true;
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUnboundDevices)) {
                n += 2;
            }
            int[] nArray = Arrays.copyOf(this.ppTableConfigIdxArrayDefault, this.ppTableConfigIdxArrayDefault.length + n);
            this.ppTableConfigIdxArrayDefault = nArray;
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUnboundDevices)) {
                this.ppTableConfigIdxArrayDefault[n2++] = PpUserDataRecord.IDX_UID;
                this.ppTableConfigIdxArrayDefault[n2++] = PpUserDataRecord.IDX_REL_TYPE;
                this.ppTableConfigIdxArrayDefault[n2++] = PpUserDataRecord.IDX_GUI_ATTRIB1;
            } else {
                this.ppTableConfigIdxArrayDefault[n2++] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_SUBSCRIBED);
            }
        }
        return this.ppTableConfigIdxArrayDefault;
    }

    public int[] getPpTableConfigIdxArray() {
        int n = 0;
        int n2 = this.ppTableConfigIdxArray.length;
        if (!this.ppTableConfigIdxArrayChecked) {
            this.ppTableConfigIdxArrayChecked = true;
            n = this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUnboundDevices) ? (n += 4) : ++n;
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVoiceboxNumber)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveExternalUserData)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                n += 5;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUMO)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveHCM)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUserDeviceSync)) {
                ++n;
            }
            if (n > 0) {
                int[] nArray = Arrays.copyOf(this.ppTableConfigIdxArray, this.ppTableConfigIdxArray.length + n);
                this.ppTableConfigIdxArray = nArray;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUnboundDevices)) {
                this.ppTableConfigIdxArray[n2++] = PpUserDataRecord.IDX_UID;
                this.ppTableConfigIdxArray[n2++] = PpUserDataRecord.IDX_REL_TYPE;
                this.ppTableConfigIdxArray[n2++] = PpUserDataRecord.IDX_GUI_ATTRIB1;
                this.ppTableConfigIdxArray[n2++] = PpUserDataRecord.IDX_KEEP_LOCAL_PB;
            } else {
                this.ppTableConfigIdxArray[n2++] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_SUBSCRIBED);
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVoiceboxNumber)) {
                this.ppTableConfigIdxArray[n2++] = PpUserDataRecord.IDX_VOICEBOX_NUM;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveExternalUserData)) {
                this.ppTableConfigIdxArray[n2++] = PpUserDataRecord.IDX_EXTERNAL;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo)) {
                this.ppTableConfigIdxArray[n2++] = PpUserDataRecord.IDX_ALLOW_VIDEO_STREAM;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                this.ppTableConfigIdxArray[n2++] = PpUserDataRecord.IDX_SIP_AUTH_ID;
                this.ppTableConfigIdxArray[n2++] = PpUserDataRecord.IDX_AUTO_ANSWER;
                this.ppTableConfigIdxArray[n2++] = PpUserDataRecord.IDX_MICROPHONE_MUTE;
                this.ppTableConfigIdxArray[n2++] = PpUserDataRecord.IDX_WARNING_TONE;
                this.ppTableConfigIdxArray[n2++] = PpUserDataRecord.IDX_ALLOW_BARGE_IN;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference)) {
                this.ppTableConfigIdxArray[n2++] = PpUserDataRecord.IDX_CONFERENCE_SERVER_TYPE;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUMO)) {
                this.ppTableConfigIdxArray[n2++] = PpUserDataRecord.IDX_MONITORING;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveHCM)) {
                this.ppTableConfigIdxArray[n2++] = PpUserDataRecord.IDX_CONFIG_DATA_PROFILE_ID;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUserDeviceSync)) {
                this.ppTableConfigIdxArray[n2++] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_SUBSCRIBE_TO_PARI_ONLY);
            }
        }
        return this.ppTableConfigIdxArray;
    }

    void processUserDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "PP user notification: " + dataNotificationEnum.toString() + ",uid=" + n);
        switch (dataNotificationEnum) {
            case DATA_DELETED_ALL: {
                this.disableTableAccess();
                break;
            }
            case DATA_BULK_READY: {
                this.enableTableAccess();
                break;
            }
            case NEW_DATA: {
                if (!this.detailPanelPending) break;
                this.removePpDetailPanel();
                break;
            }
            case DATA_CHANGED: 
            case DATA_DELETED: {
                if (!this.detailPanelPending) break;
                if (this.pendingUid.containsKey(n) && this.cntNotificationsToReceive > 0) {
                    --this.cntNotificationsToReceive;
                }
                this.pendingUid.remove(n);
                if (!this.pendingUid.isEmpty() || !this.pendingPpn.isEmpty()) break;
                this.removePpDetailPanel();
                this.cntNotificationsToReceive = 0;
                break;
            }
        }
    }

    void processDevDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "PP device notification: " + dataNotificationEnum.toString() + ",ppn=" + n);
        if (this.detailPanelPending && dataNotificationEnum == DataNotificationEnum.DATA_CHANGED) {
            if (this.pendingPpn.containsKey(n)) {
                this.pendingPpn.remove(n);
                if (this.cntNotificationsToReceive > 0) {
                    --this.cntNotificationsToReceive;
                }
            }
            if (this.pendingPpn.isEmpty() && this.pendingUid.isEmpty()) {
                this.removePpDetailPanel();
                this.cntNotificationsToReceive = 0;
            }
        }
    }

    private void processError(NotificationTypeEnum notificationTypeEnum, int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        OmiMessage.errorCodes errorCodes2 = null;
        String string4 = null;
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "PP error notification: " + dataNotificationEnum.toString() + ",type=" + notificationTypeEnum.toString() + ",id=" + String.valueOf(n) + ",errCode=" + string + ",bad=" + string2 + ",maxLen=" + string3);
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCodes2 = null;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "PP error notification: unknown errorCode=" + string);
        }
        if (this.detailPanelPending) {
            if (string2 != null) {
                this.ppDetailPanel.markErrorComponent(string2);
            }
            String string5 = this.ppDetailPanel.getErrorLabelText(string2);
            if (errorCodes2 != null) {
                string4 = UtilErrorHandling.getErrorMessage(errorCodes2, string5, string3);
            }
            if ((notificationTypeEnum == NotificationTypeEnum.USER_NOTIFICATION && this.pendingUid.containsKey(n) || notificationTypeEnum == NotificationTypeEnum.DEVICE_NOTIFICATION && this.pendingPpn.containsKey(n)) && this.cntNotificationsToReceive > 0) {
                --this.cntNotificationsToReceive;
            }
            if (dataNotificationEnum == DataNotificationEnum.DATA_CHANGED) {
                Integer n2;
                Integer n3;
                PpUserDataRecord[] ppUserDataRecordArray = null;
                PpDevDataRecord[] ppDevDataRecordArray = null;
                int n4 = 0;
                if (notificationTypeEnum == NotificationTypeEnum.USER_NOTIFICATION) {
                    n3 = n;
                    if (!this.pendingUid.containsKey(n3)) {
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "uid=" + String.valueOf(n3) + " does not exist in send map anymore");
                        return;
                    }
                    this.pendingUid.put(n3, true);
                    for (Integer n5 : this.pendingUid.keySet()) {
                        if (!this.pendingUid.get(n5).booleanValue()) continue;
                        ++n4;
                    }
                    ppUserDataRecordArray = new PpUserDataRecord[n4];
                    ppDevDataRecordArray = new PpDevDataRecord[n4];
                    n4 = 0;
                    for (Integer n5 : this.pendingUid.keySet()) {
                        if (!this.pendingUid.get(n5).booleanValue()) continue;
                        ppUserDataRecordArray[n4] = this.ppDataHandler.getPpUserData(n5);
                        if (ppUserDataRecordArray != null && (n2 = (Integer)ppUserDataRecordArray[n4].getField(PpUserDataRecord.IDX_PPN)) != null) {
                            ppDevDataRecordArray[n4] = this.ppDataHandler.getPpDevData(n2);
                        }
                        ++n4;
                    }
                }
                if (notificationTypeEnum == NotificationTypeEnum.DEVICE_NOTIFICATION) {
                    n2 = n;
                    if (!this.pendingPpn.containsKey(n)) {
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "ppn=" + String.valueOf(n) + " does not exist in send map anymore");
                        return;
                    }
                    this.pendingPpn.put(n, true);
                    n4 = 0;
                    for (Integer n5 : this.pendingPpn.keySet()) {
                        if (!this.pendingPpn.get(n5).booleanValue()) continue;
                        ++n4;
                    }
                    ppUserDataRecordArray = new PpUserDataRecord[n4];
                    ppDevDataRecordArray = new PpDevDataRecord[n4];
                    n4 = 0;
                    for (Integer n5 : this.pendingPpn.keySet()) {
                        if (!this.pendingPpn.get(n5).booleanValue()) continue;
                        ppDevDataRecordArray[n4] = this.ppDataHandler.getPpDevData(n5);
                        if (ppDevDataRecordArray != null && (n3 = (Integer)ppDevDataRecordArray[n4].getField(PpDevDataRecord.IDX_UID)) != null) {
                            ppUserDataRecordArray[n4] = this.ppDataHandler.getPpUserData(n3);
                        }
                        ++n4;
                    }
                }
                this.ppDetailPanel.setPpUserDetailData(ppUserDataRecordArray);
                this.ppDetailPanel.setPpDevDetailData(ppDevDataRecordArray);
            }
        } else if (errorCodes2 != null) {
            string4 = UtilErrorHandling.getErrorMessage(errorCodes2, string2, string3);
        }
        if (this.componentActivated) {
            if (string4 != null) {
                GuiInfoConsole.showError(string4);
            } else {
                GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
            }
            if (this.cntNotificationsToReceive == 0) {
                this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
            }
        }
    }

    public void setDetailPanelPending() {
        this.detailPanelPending = true;
    }

    private void clearDetailPanelPending() {
        this.detailPanelPending = false;
        this.pendingUid.clear();
        this.pendingPpn.clear();
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent();
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        int n = this.ppTable.getSelectedRowCount();
        if (n < 1) {
            return;
        }
        DataRecord[] dataRecordArray = new DataRecord[n];
        int[] nArray = this.ppTable.getSelectedRows();
        for (int i = 0; i < n; ++i) {
            int n2 = this.ppTable.convertRowIndexToModel(nArray[i]);
            dataRecordArray[i] = this.ppDataHandler.getDatabase().getRecordByIdx(n2).clone();
        }
        this.createPpDetailPanel(dataRecordArray);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent();
    }

    private void processTableEvent() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = this.ppTable.getSelectedRowCount();
        DataRecord[] dataRecordArray = null;
        int[] nArray = null;
        if (n > 0) {
            bl = true;
            bl3 = true;
            nArray = this.ppTable.getSelectedRows();
            dataRecordArray = new DataRecord[n];
            for (int i = 0; i < n; ++i) {
                int n2 = this.ppTable.convertRowIndexToModel(nArray[i]);
                dataRecordArray[i] = this.ppDataHandler.getDatabase().getRecordByIdx(n2).clone();
            }
            Object object = UtilMisc.getRecordsFieldObject(dataRecordArray, PpUserDataRecord.IDX_REL_TYPE, (Object)OmiMessage.PPRelTypeType.Unbound);
            Object object2 = UtilMisc.getRecordsFieldObject(dataRecordArray, PpDataRecord.devDataIdx(PpDevDataRecord.IDX_SUBSCRIBED), (Object)OmiMessage.DECTSubscriptionStateType.No);
            bl2 = OmiMessage.PPRelTypeType.class == object.getClass() && ((OmiMessage.PPRelTypeType)((Object)object) == OmiMessage.PPRelTypeType.Fixed || (OmiMessage.PPRelTypeType)((Object)object) == OmiMessage.PPRelTypeType.Dynamic) && OmiMessage.DECTSubscriptionStateType.class == object2.getClass() && (OmiMessage.DECTSubscriptionStateType)((Object)object2) != OmiMessage.DECTSubscriptionStateType.No;
        }
        if (this.ppDetailSplitPane.getBottomComponent() != null) {
            if (n > 0) {
                this.createPpDetailPanel(dataRecordArray);
            } else {
                this.removePpDetailPanel();
            }
            bl = false;
            bl2 = false;
        }
        this.ppTaskPanel.setTaskButtonConfigure(bl);
        this.ppTaskPanel.setTaskButtonChangeRelationType(bl2);
        this.ppTaskPanel.setTaskButtonDelete(bl3);
    }

    public void configurePp() {
        int n = this.ppTable.getSelectedRowCount();
        DataRecord[] dataRecordArray = new DataRecord[n];
        int[] nArray = this.ppTable.getSelectedRows();
        for (int i = 0; i < n; ++i) {
            int n2 = this.ppTable.convertRowIndexToModel(nArray[i]);
            dataRecordArray[i] = this.ppDataHandler.getDatabase().getRecordByIdx(n2).clone();
        }
        if (n > 0) {
            this.createPpDetailPanel(dataRecordArray);
        }
    }

    public void changeRelationType() {
        int n = this.ppTable.getSelectedRowCount();
        int[] nArray = this.ppTable.getSelectedRows();
        for (int i = 0; i < n; ++i) {
            int n2 = this.ppTable.convertRowIndexToModel(nArray[i]);
            PpDataRecord ppDataRecord = this.ppDataHandler.getDatabase().getRecordByIdx(n2);
            int n3 = (Integer)((DataRecord)ppDataRecord).getField(PpUserDataRecord.IDX_UID);
            OmiMessage.PPRelTypeType pPRelTypeType = (OmiMessage.PPRelTypeType)((Object)((DataRecord)ppDataRecord).getField(PpUserDataRecord.IDX_REL_TYPE));
            if (pPRelTypeType == OmiMessage.PPRelTypeType.Fixed) {
                this.ppDataHandler.sendSetPPUserDevRelation(n3, OmiMessage.PPRelTypeType.Dynamic);
                continue;
            }
            this.ppDataHandler.sendSetPPUserDevRelation(n3, OmiMessage.PPRelTypeType.Fixed);
        }
    }

    private GuiUtilDetailSplitPanel getPpDetailSplitPane() {
        if (this.ppDetailSplitPane == null) {
            this.ppDetailSplitPane = new GuiUtilDetailSplitPanel(390);
            this.ppDetailSplitPane.setTopComponent(this.getPpTablePane());
            this.ppDetailSplitPane.setBottomComponent(null);
        }
        return this.ppDetailSplitPane;
    }

    private GuiUtilConfiguratorTable getPpTable() {
        if (this.ppTable == null) {
            this.ppTable = new GuiUtilConfiguratorTable((Object)this, (Database)this.ppDataHandler.getDatabase(), this.getPpTableConfigIdxArray(), this.getActivePpConfigColumns(), UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthPpConfig);
            this.ppTable.setType(DatabaseChangeEvent.DatabaseChangeType.ALL);
            this.ppTable.setIconArray(PpUserDataRecord.IDX_EXTERNAL, GuiUtilIcon.getIconArrayInactiveActive());
            this.ppTable.setIconArray(PpUserDataRecord.IDX_MSG_RIGHT, GuiUtilIcon.getIconArrayInactiveActive());
            this.ppTable.setIconArray(PpUserDataRecord.IDX_SEND_VCARD_RIGHT, GuiUtilIcon.getIconArrayInactiveActive());
            this.ppTable.setIconArray(PpUserDataRecord.IDX_RECV_VCARD_RIGHT, GuiUtilIcon.getIconArrayInactiveActive());
            this.ppTable.setIconArray(PpUserDataRecord.IDX_ALLOW_VIDEO_STREAM, GuiUtilIcon.getIconArrayInactiveActive());
            this.ppTable.setIconArray(PpUserDataRecord.IDX_TRACKING_ACTIVE, GuiUtilIcon.getIconArrayInactiveActive());
            this.ppTable.setIconArray(PpUserDataRecord.IDX_LOCATABLE, GuiUtilIcon.getIconArrayInactiveActive());
            this.ppTable.setIconArray(PpUserDataRecord.IDX_LOC_RIGHT, GuiUtilIcon.getIconArrayInactiveActive());
            this.ppTable.setIconArray(PpUserDataRecord.IDX_KEEP_LOCAL_PB, GuiUtilIcon.getIconArrayInactiveActive());
            this.ppTable.setIconArray(PpUserDataRecord.IDX_VIP, GuiUtilIcon.getIconArrayInactiveActive());
            this.ppTable.setIconArray(PpUserDataRecord.IDX_SIP_REGISTER_CHECK, GuiUtilIcon.getIconArrayInactiveActive());
            this.ppTable.setIconArray(PpUserDataRecord.IDX_GUI_ATTRIB1, GuiUtilIcon.getIconArrayErrorActive());
            this.ppTable.setIconArray(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_ENCRYPT), GuiUtilIcon.getIconArrayErrorActive());
            this.ppTable.setIconArray(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_SUBSCRIBED), GuiUtilIcon.getIconArrayErrorErrorActive());
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUserDeviceSync)) {
                this.ppTable.setIconArray(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_SUBSCRIBE_TO_PARI_ONLY), GuiUtilIcon.getIconArrayInactiveActive());
            }
            this.ppTable.setPasswordColum(PpUserDataRecord.IDX_PIN);
            this.ppTable.setPasswordColum(PpUserDataRecord.IDX_SIP_PW);
            this.ppTable.setColumnFormatString(PpUserDataRecord.IDX_UID, "0x%03X");
            this.ppTable.setColumnFormatString(PpUserDataRecord.IDX_PPN, "0x%03X");
            this.ppTable.setColumnFormatString(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_PPN), "0x%03X");
            this.ppTable.setColumnFormatString(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_UID), "0x%03X");
            this.ppTable.setPreferredColumnWidth(PpUserDataRecord.IDX_UID, 20);
            this.ppTable.setPreferredColumnWidth(PpUserDataRecord.IDX_REL_TYPE, 35);
            this.ppTable.setPreferredColumnWidth(PpUserDataRecord.IDX_GUI_ATTRIB1, 20);
            this.ppTable.setPreferredColumnWidth(PpUserDataRecord.IDX_EXTERNAL, 20);
            this.ppTable.setPreferredColumnWidth(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_PPN), 20);
            this.ppTable.applyPreferredColumnWidthSettings();
        }
        return this.ppTable;
    }

    private AastraScrollPane getPpTablePane() {
        if (this.ppTablePane == null) {
            this.ppTablePane = new AastraScrollPane(this.getPpTable());
            this.dividerLocation = this.ppDetailSplitPane.getHeight() - 390;
            this.ppTablePane.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.ppTablePane;
    }

    private void enableTableAccess() {
        this.ppTable.setActive(true);
        this.ppTaskPanel.setTaskButtonCreate(true);
        this.ppTaskPanel.setTaskButtonConfigureTable(true);
        this.ppTaskPanel.setTaskButtonFilter(true);
    }

    private void disableTableAccess() {
        this.ppTable.setActive(false);
        this.ppTaskPanel.setTaskButtonCreate(false);
        this.ppTaskPanel.setTaskButtonConfigure(false);
        this.ppTaskPanel.setTaskButtonChangeRelationType(false);
        this.ppTaskPanel.setTaskButtonDelete(false);
        this.ppTaskPanel.setTaskButtonConfigureTable(false);
        this.ppTaskPanel.setTaskButtonFilter(false);
    }

    protected void configureTableFilter() {
        boolean bl = UtilFilterTable.setFilterItems(this.ppTable, this.getPpTableConfigIdxArray(), UtilPreferences.getTableFilterValues(UtilPreferences.TableFilterValuesKeyTypeEnum.TableFilterValuesPpConfig));
        this.ppTaskPanel.setTaskButtonFilterState(bl, null);
    }

    private AastraPanel getPpDetailPanel() {
        if (this.ppDetailPanel == null) {
            this.ppDetailPanel = new PpConfigDetailPanel(this, this.utilErrorComp);
        }
        return this.ppDetailPanel;
    }

    private AastraPanel getPpTaskPanel() {
        if (this.ppTaskPanel == null) {
            this.ppTaskPanel = new PpConfigTaskPanel(this, this.commonDataHandler, this.getPpTable());
        }
        return this.ppTaskPanel;
    }

    public void StartPpCreation() {
        this.ppTable.removeRowSelectionAll();
        this.createPpDetailPanel(null);
    }

    private void createPpDetailPanel(DataRecord[] dataRecordArray) {
        if (this.ppDetailSplitPane.getBottomComponent() != null) {
            this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
            this.utilErrorComp.clearComponents();
            this.dividerLocation = this.ppDetailSplitPane.getDividerLocation();
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Updating PP config detail panel");
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating PP config detail panel");
            this.ppDetailSplitPane.setBottomComponent(this.getPpDetailPanel());
            this.ppDetailPanel.setDefaultTab();
        }
        if (dataRecordArray != null) {
            DataRecord[] dataRecordArray2 = new DataRecord[dataRecordArray.length];
            DataRecord[] dataRecordArray3 = new DataRecord[dataRecordArray.length];
            for (int i = 0; i < dataRecordArray.length; ++i) {
                PpDataRecord ppDataRecord = (PpDataRecord)dataRecordArray[i];
                dataRecordArray2[i] = ppDataRecord.ppUser;
                dataRecordArray3[i] = ppDataRecord.ppDev;
                Integer n = (Integer)dataRecordArray2[i].getField(PpUserDataRecord.IDX_UID);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading PP user[" + n + "]:");
                UtilPrint.printPpUserDataRecordString((PpUserDataRecord)dataRecordArray2[i], this);
                Integer n2 = (Integer)dataRecordArray3[i].getField(PpDevDataRecord.IDX_PPN);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading PP device[" + n2 + "]:");
                UtilPrint.printPpDevDataRecordString((PpDevDataRecord)dataRecordArray3[i], this);
            }
            this.ppDetailPanel.setPpUserDetailData(dataRecordArray2);
            this.ppDetailPanel.setPpDevDetailData(dataRecordArray3);
        } else {
            this.ppDetailPanel.setPpUserDetailData(null);
            this.ppDetailPanel.setPpDevDetailData(null);
        }
        this.ppDetailPanel.requestDefaultFocusInWindow();
        this.ppDetailSplitPane.setDividerLocation(this.dividerLocation);
        this.ppDetailSplitPane.validate();
        this.ppTaskPanel.setTaskButtonConfigure(false);
        this.ppTaskPanel.setTaskButtonChangeRelationType(false);
    }

    public void removePpDetailPanel() {
        int n = this.ppTable.getSelectedRowCount();
        DataRecord[] dataRecordArray = null;
        int[] nArray = null;
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing PP config detail panel");
        this.clearDetailPanelPending();
        this.utilErrorComp.clearComponents();
        this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
        this.dividerLocation = this.ppDetailSplitPane.getDividerLocation();
        this.ppDetailSplitPane.setBottomComponent(null);
        if (n >= 0) {
            this.ppTaskPanel.setTaskButtonConfigure(true);
            this.ppTaskPanel.setTaskButtonDelete(true);
        } else {
            this.ppTaskPanel.setTaskButtonDelete(false);
        }
        if (n > 0) {
            nArray = this.ppTable.getSelectedRows();
            dataRecordArray = new DataRecord[n];
            for (int i = 0; i < n; ++i) {
                int n2 = this.ppTable.convertRowIndexToModel(nArray[i]);
                dataRecordArray[i] = this.ppDataHandler.getDatabase().getRecordByIdx(n2).clone();
            }
            Object object = UtilMisc.getRecordsFieldObject(dataRecordArray, PpUserDataRecord.IDX_REL_TYPE, (Object)OmiMessage.PPRelTypeType.Unbound);
            if (OmiMessage.PPRelTypeType.class == object.getClass() && (OmiMessage.PPRelTypeType)((Object)object) == OmiMessage.PPRelTypeType.Fixed || (OmiMessage.PPRelTypeType)((Object)object) == OmiMessage.PPRelTypeType.Dynamic) {
                this.ppTaskPanel.setTaskButtonChangeRelationType(true);
            } else {
                this.ppTaskPanel.setTaskButtonChangeRelationType(false);
            }
        }
    }

    public void createPp() {
        PpUserDataRecord[] ppUserDataRecordArray = (PpUserDataRecord[])this.ppDetailPanel.getPpUserDetailData();
        PpDevDataRecord[] ppDevDataRecordArray = (PpDevDataRecord[])this.ppDetailPanel.getPpDevDetailData();
        if (ppUserDataRecordArray == null) {
            return;
        }
        this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_BUSY, null);
        PpUserDataRecord ppUserDataRecord = ppUserDataRecordArray[0];
        PpDevDataRecord ppDevDataRecord = ppDevDataRecordArray[0];
        ppUserDataRecord.setField(PpUserDataRecord.IDX_REL_TYPE, (Object)OmiMessage.PPRelTypeType.Fixed);
        ppDevDataRecord.setField(PpDevDataRecord.IDX_REL_TYPE, (Object)OmiMessage.PPRelTypeType.Fixed);
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Creating PP user:");
        UtilPrint.printPpUserDataRecordString(ppUserDataRecord, this);
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Creating PP device:");
        UtilPrint.printPpDevDataRecordString(ppDevDataRecord, this);
        PpDataRecord ppDataRecord = new PpDataRecord(ppUserDataRecord, ppDevDataRecord);
        this.ppDataHandler.sendCreatePp(ppDataRecord);
        this.setDetailPanelPending();
    }

    public void changePp() {
        int n;
        DataRecord[] dataRecordArray = null;
        PpUserDataRecord[] ppUserDataRecordArray = (PpUserDataRecord[])this.ppDetailPanel.getPpUserDetailData();
        PpDevDataRecord[] ppDevDataRecordArray = (PpDevDataRecord[])this.ppDetailPanel.getPpDevDetailData();
        if (ppUserDataRecordArray == null || ppDevDataRecordArray == null) {
            return;
        }
        this.cntPPSendBulkTotal = 0;
        this.cntPPToChange = 0;
        for (n = 0; n < ppUserDataRecordArray.length; ++n) {
            boolean bl = false;
            if (ppUserDataRecordArray[n].getRecordChanged()) {
                this.ppDataHandler.getUserDatabase().updateTransientFields(ppUserDataRecordArray[n]);
                ++this.cntPPSendBulkTotal;
                ++this.cntNotificationsToReceive;
                bl = true;
                this.pendingUid.put((Integer)ppUserDataRecordArray[n].getField(PpUserDataRecord.IDX_UID), false);
            }
            if (ppDevDataRecordArray[n].getRecordChanged()) {
                this.ppDataHandler.getDevDatabase().updateTransientFields(ppDevDataRecordArray[n]);
                ++this.cntPPSendBulkTotal;
                ++this.cntNotificationsToReceive;
                bl = true;
                this.pendingPpn.put((Integer)ppDevDataRecordArray[n].getField(PpDevDataRecord.IDX_PPN), false);
            }
            if (!bl) continue;
            ++this.cntPPToChange;
        }
        if (this.cntPPSendBulkTotal > 0) {
            n = 0;
            dataRecordArray = new DataRecord[this.cntPPSendBulkTotal];
            for (int i = 0; i < ppUserDataRecordArray.length; ++i) {
                if (ppUserDataRecordArray[i].getRecordChanged()) {
                    dataRecordArray[n++] = ppUserDataRecordArray[i];
                }
                if (!ppDevDataRecordArray[i].getRecordChanged()) continue;
                dataRecordArray[n++] = ppDevDataRecordArray[i];
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, String.format("Changing %d PP(s)\n", this.cntPPToChange));
            this.sendBulkAction = DataHandler.SendBulkActionType.Change;
            this.ppDataHandler.sendChangeDeletePPs(this.sendBulkAction, dataRecordArray, this);
            this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_BUSY, null);
            this.setDetailPanelPending();
            if (this.cntPPSendBulkTotal > 1) {
                this.guiProgressDlg = new GuiProgressDlgCancel(UtilLocale.getString("TXT_CHANGING_PPS_IN_PROGRESS"), false, true, this);
                this.guiProgressDlg.setValue(0);
                this.guiProgressDlg.setVisible(true);
            }
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Change PP(s): OMILIB told us there is nothing to do (all PP user and device attributes are unchanged)");
            this.removePpDetailPanel();
        }
    }

    public void deletePp() {
        GuiUtilDialog guiUtilDialog;
        DataRecord[] dataRecordArray = null;
        int n = this.ppTable.getSelectedRowCount();
        if (n > 0 && (guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_DELETE_SELECTED_PORTABLE_PARTS_?"), true)).getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
            DataRecord dataRecord;
            int n2;
            int n3;
            int[] nArray = this.ppTable.getSelectedRows();
            int n4 = 0;
            this.cntNotificationsToReceive = nArray.length;
            this.cntPPSendBulkTotal = nArray.length;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n2 = this.ppTable.convertRowIndexToModel(nArray[n3]);
                dataRecord = this.ppDataHandler.getDatabase().getRecordByIdx(n2);
                if (((PpDataRecord)dataRecord).getField(PpUserDataRecord.IDX_REL_TYPE) != OmiMessage.PPRelTypeType.Dynamic) continue;
                ++this.cntPPSendBulkTotal;
            }
            dataRecordArray = new DataRecord[this.cntPPSendBulkTotal];
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n2 = this.ppTable.convertRowIndexToModel(nArray[n3]);
                dataRecord = this.ppDataHandler.getDatabase().getRecordByIdx((int)n2).ppUser;
                int n5 = (Integer)((PpUserDataRecord)dataRecord).getField(PpUserDataRecord.IDX_UID);
                dataRecordArray[n4++] = dataRecord;
                if (((PpUserDataRecord)dataRecord).getField(PpUserDataRecord.IDX_REL_TYPE) == OmiMessage.PPRelTypeType.Dynamic) {
                    dataRecordArray[n4++] = this.ppDataHandler.getDatabase().getRecordByIdx((int)n2).ppDev;
                }
                if (this.ppDetailSplitPane.getBottomComponent() == null || this.ppDetailPanel.getSelectedPpUser() != n5) continue;
                this.setDetailPanelPending();
                this.pendingUid.put(n5, false);
            }
            this.sendBulkAction = DataHandler.SendBulkActionType.Delete;
            this.ppDataHandler.sendChangeDeletePPs(this.sendBulkAction, dataRecordArray, this);
            if (this.cntPPSendBulkTotal > 1) {
                this.guiProgressDlg = new GuiProgressDlgCancel(UtilLocale.getString("TXT_DELETING_PPS_IN_PROGRESS"), false, true, this);
                this.guiProgressDlg.setValue(0);
                this.guiProgressDlg.setVisible(true);
            }
        }
    }

    private int[] getActivePpConfigColumns() {
        if (this.activePpConfigColumns == null) {
            int n = 0;
            int[] nArray = this.getPpTableConfigIdxArray();
            BitSet bitSet = UtilPreferences.getTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectPpConfig);
            if (bitSet != null && !UtilPreferences.isOpenRespAttribsChanged()) {
                this.activePpConfigColumns = new int[bitSet.cardinality()];
                for (int i = 0; i < nArray.length; ++i) {
                    if (!bitSet.get(i)) continue;
                    this.activePpConfigColumns[n++] = nArray[i];
                }
            } else {
                this.activePpConfigColumns = this.getPpTableConfigIdxArrayDefault();
                bitSet = new BitSet();
                block1: for (int i = 0; i < this.activePpConfigColumns.length; ++i) {
                    for (int j = 0; j < nArray.length; ++j) {
                        if (this.activePpConfigColumns[i] != nArray[j]) continue;
                        bitSet.set(j);
                        continue block1;
                    }
                }
                UtilPreferences.setTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectPpConfig, bitSet);
            }
        }
        return this.activePpConfigColumns;
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
        if (this.ppDetailSplitPane.getBottomComponent() != null) {
            this.createPpDetailPanel(dataRecordArray);
        }
    }

    @Override
    public void componentActivated(Component component) {
        this.componentActivated = true;
        this.configureTableFilter();
    }

    @Override
    public void componentDeactivated() {
        this.componentActivated = false;
    }

    @Override
    public void notifyProgress(int n, boolean bl) {
        if (bl || n == this.cntPPSendBulkTotal) {
            if (this.guiProgressDlg != null) {
                this.guiProgressDlg.dispose();
            }
            GuiMain.getGuiStatusBarObject().showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
            if (bl) {
                if (this.sendBulkAction == DataHandler.SendBulkActionType.Change) {
                    GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_CHANGING_PPS_CANCELED_AFTER_*_OF_*_REQUESTS"), n, this.cntPPSendBulkTotal));
                } else {
                    GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_DELETING_PPS_CANCELED_AFTER_*_OF_*_REQUESTS"), n, this.cntPPSendBulkTotal));
                }
            }
        } else {
            this.guiProgressDlg.setValue(100 * n / this.cntPPSendBulkTotal);
        }
    }

    @Override
    public void timeout(int n) {
        if (this.guiProgressDlg != null) {
            this.guiProgressDlg.dispose();
        }
        GuiMain.getGuiStatusBarObject().showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
        if (this.sendBulkAction == DataHandler.SendBulkActionType.Change) {
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_CHANGING_PPS_CANCELED_BY_TIMEOUT_AFTER_*_OF_*_REQUESTS"), n, this.cntPPSendBulkTotal));
        } else {
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_DELETING_PPS_CANCELED_BY_TIMEOUT_AFTER_*_OF_*_REQUESTS"), n, this.cntPPSendBulkTotal));
        }
    }

    @Override
    public void canceled() {
        this.ppDataHandler.cancelChangeDeletePPs();
    }

    class NotificationHandlerClass
    implements PpDataNotificationInterface {
        public NotificationTypeEnum notificationType = NotificationTypeEnum.USER_NOTIFICATION;

        NotificationHandlerClass() {
        }

        @Override
        public void processDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
            if (PpConfigMainPanel.this.ppTable.getSelectedRow() == -1) {
                PpConfigMainPanel.this.ppTaskPanel.setTaskButtonConfigure(false);
                PpConfigMainPanel.this.ppTaskPanel.setTaskButtonChangeRelationType(false);
                PpConfigMainPanel.this.ppTaskPanel.setTaskButtonDelete(false);
            }
            if (this.notificationType == NotificationTypeEnum.USER_NOTIFICATION) {
                PpConfigMainPanel.this.processUserDataNotification(n, dataNotificationEnum);
            } else {
                PpConfigMainPanel.this.processDevDataNotification(n, dataNotificationEnum);
            }
        }

        @Override
        public void processErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
            PpConfigMainPanel.this.processError(this.notificationType, n, dataNotificationEnum, omiMessage);
        }

        @Override
        public void processStatusEvent(int n, int n2, PpEventEnum ppEventEnum, Object[] objectArray) {
        }
    }

    private static enum NotificationTypeEnum {
        USER_NOTIFICATION,
        DEVICE_NOTIFICATION;

    }
}

